/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew.prpertychangeaction;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import org.apache.commons.lang3.StringUtils;

public class PropertyChangeTips {
    private static final String OLD_MODEL = "beforeChangedModelSnapShot";
    private static final Set<String> NOT_NEED_COMPARE = new HashSet<String>(Arrays.asList("parent", "accountpart", "createtime", "modifier", "modifytime", "addtext", "startshare", "parentname", "treeentryentity", "entitypart"));
    private static String[] entryFields;

    public static void afterOpenPage(IDataModel dataModel, IFormView formView) {
        OperationStatus pageStatus = formView.getFormShowParameter().getStatus();
        if (dataModel == null && OperationStatus.ADDNEW.equals((Object)pageStatus)) {
            return;
        }
        if (dataModel != null) {
            String beforeChangedModelSnapShot = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{dataModel.getDataEntity(true)}, (DynamicObjectType)dataModel.getDataEntityType());
            if (StringUtils.isEmpty((CharSequence)formView.getPageCache().get(OLD_MODEL))) {
                formView.getPageCache().put(OLD_MODEL, beforeChangedModelSnapShot);
            }
        }
    }

    public static boolean hasValueChanged(IDataModel dataModel, IFormView formView) {
        String oldModelStr = formView.getPageCache().get(OLD_MODEL);
        if (StringUtils.isNotEmpty((CharSequence)oldModelStr)) {
            DynamicObject oldModel = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)oldModelStr, (DynamicObjectType)dataModel.getDataEntityType())[0];
            DynamicObject newModelDy = dataModel.getDataEntity(true);
            String beforeChangedModelSnapShot = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{newModelDy}, (DynamicObjectType)dataModel.getDataEntityType());
            DynamicObject newModel = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)beforeChangedModelSnapShot, (DynamicObjectType)dataModel.getDataEntityType())[0];
            for (IDataEntityProperty prop : dataModel.getDataEntityType().getProperties()) {
                String entryName;
                if (NOT_NEED_COMPARE.contains(prop.getName())) continue;
                switch (prop.getName()) {
                    case "dm_entry": {
                        entryName = "dm_entry";
                        entryFields = new String[]{"dm_valstr"};
                        break;
                    }
                    case "disentry": {
                        entryName = "disentry";
                        entryFields = new String[]{"permission"};
                        break;
                    }
                    case "bizchangerds": {
                        entryName = "bizchangerds";
                        entryFields = new String[]{"changetype", "bizeffdate", "bizexpdate"};
                        break;
                    }
                    case "namechangerds": {
                        entryName = "namechangerds";
                        entryFields = new String[]{"namerds", "nameeffdate", "nameexpdate"};
                        break;
                    }
                    default: {
                        entryName = "";
                        entryFields = new String[0];
                    }
                }
                boolean equalFlag = "".equals(entryName) ? (prop.getName().contains("dpropertyid") ? true : Objects.equals(newModel.getString(prop), oldModel.getString(prop))) : PropertyChangeTips.isPropertyEquals(newModel, oldModel, prop.getName(), entryName, entryFields);
                if (equalFlag) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isPropertyEquals(DynamicObject newModel, DynamicObject oldModel, String prop, String entryName, String[] entryFields) {
        boolean flag = true;
        if (entryName.equals(prop)) {
            DynamicObjectCollection newCols = newModel.getDynamicObjectCollection(prop);
            DynamicObjectCollection oldCols = oldModel.getDynamicObjectCollection(prop);
            if (newCols == null && oldCols != null || newCols != null && oldCols == null) {
                flag = false;
            } else if (newCols == null && oldCols == null) {
                flag = true;
            } else if (newCols.size() != oldCols.size()) {
                flag = false;
            } else {
                block0: for (int i = 0; i < oldCols.size(); ++i) {
                    for (String entryField : entryFields) {
                        if ("bcm_accountmembertree".equalsIgnoreCase(newModel.getDataEntityType().getExtendName()) && "changetype".equals(entryField) || Objects.equals(((DynamicObject)newCols.get(i)).getString(entryField), ((DynamicObject)oldCols.get(i)).getString(entryField))) continue;
                        flag = false;
                        break block0;
                    }
                }
            }
        }
        return flag;
    }

    public static void afterSave(IDataModel dataModel, IFormView formView) {
        if (dataModel == null) {
            return;
        }
        String beforeChangedModelSnapShot = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{dataModel.getDataEntity()}, (DynamicObjectType)dataModel.getDataEntityType());
        formView.getPageCache().put(OLD_MODEL, beforeChangedModelSnapShot);
        formView.getPageCache().put("continue_save", null);
        formView.getPageCache().put("issave", null);
    }
}

