/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.disclosure.base;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.disclosure.enums.ModuleEnum;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.disclosure.base.ComeFromEnum;
import kd.fi.bcm.spread.common.util.StringUtil;

public class DisclosureReportSectionHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureReportSectionHelper.class);

    public static void saveModuleByReportSection(Map<String, Object> moduleMap) {
        Long dmmodelId = (Long)moduleMap.get("fidmmodelId");
        String number = (String)moduleMap.get("number");
        String name = (String)moduleMap.get("name");
        String description = (String)moduleMap.get("description");
        Long templateId = 0L;
        Long catalogId = (Long)moduleMap.get("catalogId");
        String scope = (String)moduleMap.get("scope");
        Long permclassId = (Long)moduleMap.get("permclassId");
        Long componentId = (Long)moduleMap.get("componentId");
        List reportDims = (List)moduleMap.get("reportDims");
        Long moduleId = GlobalIdUtil.genGlobalLongId();
        if (Objects.isNull(catalogId)) {
            QFilter filter = new QFilter("model", "=", (Object)dmmodelId);
            filter.and("status", "=", (Object)"C");
            DynamicObjectCollection catalogList = QueryServiceHelper.query((String)"fidm_modulecatalog", (String)"id,number,name", (QFilter[])new QFilter[]{filter}, (String)"level,sequence");
            if (catalogList != null && catalogList.size() > 0) {
                catalogId = ((DynamicObject)catalogList.get(0)).getLong("id");
            }
        }
        JSONObject newModule = new JSONObject();
        newModule.put("id", (Object)moduleId.toString());
        newModule.put("number", (Object)number);
        newModule.put("name", (Object)name);
        newModule.put("type", (Object)ModuleEnum.REPORT_SECTION.getType());
        newModule.put("alignment", (Object)"2");
        newModule.put("width", (Object)15);
        newModule.put("height", (Object)10);
        String modelNumber = MemberReader.findModelNumberById((Object)dmmodelId);
        JSONObject reportSection = new JSONObject();
        if (reportDims != null) {
            for (Map reportDim : reportDims) {
                IDNumberTreeNode sourceMember;
                DynamicObject dimDy;
                if (reportDim == null || (dimDy = MemberReader.getDimensionDynById((long)LongUtil.toLong(reportDim.get("dim_id")))) == null) continue;
                reportDim.put("dim_name", dimDy.getString("name"));
                String entityName = MemberReader.getEntityNumberByDim((String)modelNumber, (String)((String)reportDim.get("dim_number")));
                if (StringUtil.isEmptyString((String)((String)reportDim.get("member_id"))) || (sourceMember = MemberReader.findMemberById((long)dmmodelId, (String)entityName, (Long)LongUtil.toLong(reportDim.get("member_id")))) == null) continue;
                reportDim.put("member_name", sourceMember.getName());
            }
        }
        reportSection.put("reportDims", (Object)reportDims);
        newModule.put("reportSection", (Object)reportSection);
        HashMap<String, String> specialMap = new HashMap<String, String>();
        specialMap.put("componentId", componentId.toString());
        newModule.put("specialMap", specialMap);
        String type = ModuleEnum.REPORT_SECTION.getType();
        String properties = newModule.toJSONString();
        DynamicObject module = BusinessDataServiceHelper.newDynamicObject((String)"fidm_modulerepository");
        module.set("id", (Object)moduleId);
        module.set("model", (Object)dmmodelId);
        module.set("number", (Object)number);
        module.set("name", (Object)name);
        module.set("type", (Object)type);
        module.set("description", (Object)description);
        module.set("template", (Object)templateId);
        module.set("catalog", (Object)catalogId);
        module.set("modifier", (Object)RequestContext.get().getCurrUserId());
        module.set("creator", (Object)RequestContext.get().getCurrUserId());
        module.set("scope", (Object)(StringUtils.isNotEmpty((CharSequence)scope) ? scope : "1"));
        module.set("status", (Object)"1");
        module.set("applytype", (Object)"1");
        module.set("permclass", (Object)permclassId);
        module.set("properties", (Object)properties);
        module.set("comefrom", (Object)ComeFromEnum.CM.getType());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{module});
        if (permclassId > 0L) {
            PermClassEntityHelper.saveDiscPermClass((DynamicObject)module, (Long)dmmodelId, (String)"fidmmodel", (String)ApplicationTypeEnum.FIDM.getAppnum());
        }
    }
}

