/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.disclosure.calculate.reportSection;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashMultimap;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.disclosure.calculate.reportSection.dto.ReportSectionAreaInfo;
import kd.fi.bcm.formplugin.report.NewReportMultiExportService;
import kd.fi.bcm.formplugin.report.ReportMultiExportService;
import kd.fi.bcm.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.formplugin.report.export.FileInfo;
import kd.fi.bcm.formplugin.report.export.ReportExportInfo;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.util.GZIPUtils;
import kd.fi.bcm.spread.util.SpreadUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ReportSectionExportService
extends NewReportMultiExportService {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ReportSectionExportService.class);
    private static String exportFormpluginId = "fidm_reportsection_export";
    private Map<String, String> dimMemberMap = new HashMap<String, String>(10);

    public Map<String, Object> getTemplateExcelByInvoke(Map<String, Object> params) {
        SXSSFWorkbook workbook = new SXSSFWorkbook(500);
        try {
            Long templateId = LongUtil.toLong((Object)params.get("templateId"));
            TemplateModel template = TemplateUtil.getTemplateModel((Object)templateId);
            String spreadjson = template.getRptSpreadJson().substring(6);
            String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadjson)));
            Workbook gcbook = SpreadUtils.getWorkbook((String)ssjson);
            ByteArrayOutputStream spreadJsonOut = SpreadUtils.getByteArrayOutputStream((Workbook)gcbook, (SaveFileFormat)SaveFileFormat.Xlsx);
            byte[] excelFileData = spreadJsonOut.toByteArray();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
            map.put("excelData", excelFileData);
            LinkedHashMap<String, Object> linkedHashMap = map;
            return linkedHashMap;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw ex;
        }
        finally {
            workbook.dispose();
        }
    }

    public Map<String, Object> getExcelDataByInvoke(Map<String, Object> params) {
        Long modelId = LongUtil.toLong((Object)params.get("modelId"));
        Long templateId = LongUtil.toLong((Object)params.get("templateId"));
        Map dimMemberMap = (Map)params.get("dimMemberMap");
        int viewDataunit = 1;
        if (params.get("viewDataUnit") != null) {
            viewDataunit = ReportSectionExportService.convertValueToInt(params.get("viewDataUnit"), 1);
        }
        int scale = -1;
        if (params.get("scale") != null) {
            scale = ReportSectionExportService.convertValueToInt(params.get("scale"), -1);
        }
        String sourceStyle = "1";
        if (params.get("sourceStyle") != null) {
            sourceStyle = params.get("sourceStyle").toString();
        }
        String floatDispay = "3";
        if (params.get("floatDispay") != null) {
            floatDispay = params.get("floatDispay").toString();
        }
        return this.getExcelData(modelId, templateId, dimMemberMap, viewDataunit, scale, sourceStyle, floatDispay);
    }

    public Map<String, Object> getExcelData(Long modelId, Long templateId, Map<String, String> dimMemberMap, int viewDataunit, int scale, String sourcestyle, String floatDispay) {
        try {
            String modelNumber = QueryDimensionServiceHelper.getModelNumber((long)modelId);
            this.dimMemberMap = dimMemberMap;
            String scaleStr = "";
            if (scale > 0) {
                StringBuilder buf = new StringBuilder(".");
                for (int i2 = 0; i2 < scale; ++i2) {
                    buf.append("0");
                }
                scaleStr = buf.toString();
            }
            this.setModelId(modelId);
            this.setCube(modelNumber);
            this.setCsl(false);
            this.setDataTypeMap(new HashMap<String, DataTypeAcctCacheInfo>(2));
            this.setViewDataunit(viewDataunit);
            this.setDivisor(BigDecimal.valueOf(Math.pow(10.0, this.getViewDataunit())));
            this.setExcelfiletype("0");
            this.setFileruleStr("yearname_periodname_orgnumber");
            this.setFiletxt("");
            this.setFloat(false);
            this.setReport(false);
            this.setSaveByDim(false);
            this.setSchemeId(0L);
            this.setPackDownload(false);
            this.setRptType("EIRpt#EntityInput");
            this.setScale(scale);
            this.setScaleStr(scaleStr);
            this.setSheetruleStr("reportname");
            this.setSheettxt("");
            this.setUnweave(false);
            this.setPageSourceEnum(ExportPageSourceEnum.DEFAULT);
            this.setSourcestyle(sourcestyle);
            this.setFloatdispay(floatDispay);
            this.setFiletype("3");
            this.setReportStatusOwner();
            this.initReportOwner(templateId);
            this.initEntityDyOwner();
            this.initFYPeriodDyOwner();
            this.initSceneDyOwner();
            this.initCurrencyDyOwner();
            this.initAuditDyOwner();
            this.initProcessDyOwner();
            this.initOtherDim(templateId);
            this.fileContext = new ReportMultiExportService.FileContext();
            this.sheetName2Name = HashMultimap.create();
            this.setTaskConsumer(i -> {});
            this.initService();
            for (ReportExportInfo pair : this.tempReportInfo.getExportInfos()) {
                if (pair.getUnWeavingSize() == 0 && pair.getWeavingSize() == 0) continue;
                return this.doExport_Excel(pair);
            }
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u8868\u7f16\u5236\u4fe1\u606f\u5931\u8d25\uff01", (String)"ModuleDataGeneralHelper_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            logger.error("dm reportsection getExcelData error", (Throwable)ex);
            String msg = ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u8868\u7f16\u5236\u6700\u65b0\u6570\u636e\u5931\u8d25\uff01", (String)"ModuleDataGeneralHelper_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    private void initReportOwner(Long templateId) {
        Object[] tempIds = new Object[]{templateId};
        Map map = TemplateServiceHelper.getTemplates((Object[])tempIds);
        if (map.size() > 0) {
            LinkedHashMap sortMap = new LinkedHashMap(16);
            for (Object id : tempIds) {
                sortMap.put(id, map.get(id));
            }
            DynamicObject source = BusinessDataServiceHelper.newDynamicObject((String)exportFormpluginId);
            DynamicObjectCollection entryEntity = source.getDynamicObjectCollection("reportentry");
            for (Map.Entry objectEntry : sortMap.entrySet()) {
                DynamicObject newReport = new DynamicObject(entryEntity.getDynamicObjectType());
                newReport.set("report_number", objectEntry.getValue());
                entryEntity.add((Object)newReport);
            }
            this.setTempDoc(entryEntity);
        }
    }

    private void initEntityDyOwner() {
        Long entityId = LongUtil.toLong((Object)this.dimMemberMap.get("EntityId"));
        if (entityId > 0L) {
            ArrayList<Long> orgIds = new ArrayList<Long>(2);
            orgIds.add(entityId);
            Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"number,name,isleaf,currency.number,cslscheme.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orgIds.toArray())});
            DynamicObject cslschemeDy = null;
            DynamicObject source = BusinessDataServiceHelper.newDynamicObject((String)exportFormpluginId);
            DynamicObjectCollection entryEntity = source.getDynamicObjectCollection("orgentry");
            for (Map.Entry objectEntry : orgMap.entrySet()) {
                DynamicObject newOrg = new DynamicObject(entryEntity.getDynamicObjectType());
                newOrg.set("org_number", objectEntry.getValue());
                newOrg.set("number", (Object)((DynamicObject)objectEntry.getValue()).getString("number"));
                newOrg.set("name", (Object)((DynamicObject)objectEntry.getValue()).getString("name"));
                newOrg.set("basetype", (Object)"0");
                newOrg.set("membrange", (Object)"10");
                newOrg.set("cynumber", (Object)((DynamicObject)objectEntry.getValue()).getString("currency.number"));
                entryEntity.add((Object)newOrg);
                Long cslschemeId = ((DynamicObject)objectEntry.getValue()).getLong("cslscheme.id");
                if (!LongUtil.isvalidLong((Object)cslschemeId)) continue;
                cslschemeDy = BusinessDataServiceHelper.loadSingle((Object)cslschemeId, (String)"bcm_cslscheme");
            }
            this.setOrgDoc(entryEntity);
            if (cslschemeDy != null) {
                this.setCslscheme_view(cslschemeDy);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ModuleDataGeneralHelper_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void initProcessDyOwner() {
        Long processId = LongUtil.toLong((Object)this.dimMemberMap.get("ProcessId"));
        String processNumber = this.dimMemberMap.get("ProcessNumber");
        if (StringUtils.isNotEmpty((String)processNumber) && !this.processMap.containsKey(processNumber)) {
            this.processMap.put(processNumber, null);
        }
        if (processId > 0L) {
            DynamicObject memDy;
            this.process = memDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_processmembertree", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("id", "=", (Object)processId).toArray());
            if (memDy != null) {
                this.processMap.put(memDy.getString("number"), memDy);
            }
        }
    }

    private void initFYPeriodDyOwner() {
        Long yearId = LongUtil.toLong((Object)this.dimMemberMap.get("YearId"));
        String yearNumber = this.dimMemberMap.get("YearNumber");
        Long periodId = LongUtil.toLong((Object)this.dimMemberMap.get("PeriodId"));
        String periodNumber = this.dimMemberMap.get("PeriodNumber");
        DynamicObject yearMemDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_fymembertree", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("id", "=", (Object)yearId).toArray());
        if (yearMemDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ModuleDataGeneralHelper_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject periodMemDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("id", "=", (Object)periodId).toArray());
        if (periodMemDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ModuleDataGeneralHelper_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ArrayList<FYPeriodPair> fyPeriodPairs = new ArrayList<FYPeriodPair>(2);
        FYPeriodPair fyPeriodPair = new FYPeriodPair(yearNumber + "|" + periodNumber, yearMemDy, periodMemDy);
        fyPeriodPairs.add(fyPeriodPair);
        this.setFyPeriodPairs(fyPeriodPairs);
        this.setStartYear(yearMemDy);
        this.setStartPeriod(periodMemDy);
        this.setEndYear(yearMemDy);
        this.setEndPeriod(periodMemDy);
    }

    private void initAuditDyOwner() {
        Long auditTrailId = LongUtil.toLong((Object)this.dimMemberMap.get("AuditTrailId"));
        if (auditTrailId == null || auditTrailId < 0L) {
            String number = "ATTotal";
            boolean existAuditTrailDimension = MemberReader.isExistAuditTrailDimension((long)this.getModelId());
            if (existAuditTrailDimension) {
                DynamicObject memDy;
                this.audittrial = memDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_audittrialmembertree", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("number", "=", (Object)number).toArray());
            } else {
                this.audittrial = BusinessDataServiceHelper.newDynamicObject((String)"bcm_audittrialmembertree");
                this.audittrial.set("number", (Object)number);
            }
            this.auditMap.put(number, this.audittrial);
        } else {
            DynamicObject memDy;
            this.audittrial = memDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_audittrialmembertree", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("id", "=", (Object)auditTrailId).toArray());
            if (memDy != null) {
                this.auditMap.put(memDy.getString("number"), this.audittrial);
            }
        }
    }

    private void initCurrencyDyOwner() {
        String selectProperties = "id,number,name,dimension,dimension.membermodel";
        QFilter f = new QFilter("model", "=", (Object)this.getModelId());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_currencymembertree", (String)selectProperties, (QFilter[])new QFilter[]{f});
        for (DynamicObject value : map.values()) {
            this.cyNumber2Dy.put(value.getString("number"), value);
        }
        Long currencyId = LongUtil.toLong((Object)this.dimMemberMap.get("CurrencyId"));
        if (currencyId > 0L) {
            DynamicObject memDy;
            this.cyDy = memDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("id", "=", (Object)currencyId).toArray());
            this.setCyObj_view(memDy);
        }
    }

    private void initSceneDyOwner() {
        Long scenarioId = LongUtil.toLong((Object)this.dimMemberMap.get("ScenarioId"));
        if (scenarioId > 0L) {
            DynamicObject memDy;
            this.scene = memDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_scenemembertree", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("id", "=", (Object)scenarioId).toArray());
            this.scene_view = memDy;
        }
        this.initSceneDy();
    }

    private void setReportStatusOwner() {
        ArrayList<String> status = new ArrayList<String>(10);
        status.add(ReportStatusEnum.WEAVING.status());
        status.add(ReportStatusEnum.COMPLETE.status());
        status.add(ReportStatusEnum.COMMIT.status());
        status.add(ReportStatusEnum.BACK.status());
        this.setReportStatus(status);
    }

    private void initOtherDim(Long templateId) {
        try {
            LinkedHashMap<String, DynamicObject> newDimItemMap = new LinkedHashMap<String, DynamicObject>(10);
            TemplateModel template = TemplateUtil.getTemplateModel((Object)templateId);
            for (PageDimensionEntry pageDimensionEntry : template.getPageDimensionEntries()) {
                DynamicObject memberDy;
                String memberId;
                String dimNumber;
                if (pageDimensionEntry.getDimension() == null || "Entity".equalsIgnoreCase(dimNumber = pageDimensionEntry.getDimension().getNumber()) || "Process".equalsIgnoreCase(dimNumber) || "Year".equalsIgnoreCase(dimNumber) || "Period".equalsIgnoreCase(dimNumber) || "AuditTrail".equalsIgnoreCase(dimNumber) || "Currency".equalsIgnoreCase(dimNumber) || "Scenario".equalsIgnoreCase(dimNumber) || StringUtils.isEmpty((String)(memberId = this.dimMemberMap.get(dimNumber + "Id"))) || (memberDy = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)memberId), (String)pageDimensionEntry.getDimension().getMemberEntityNumber())) == null) continue;
                newDimItemMap.put(dimNumber, memberDy);
            }
            if (newDimItemMap.size() > 0) {
                this.setDimNum2Items(newDimItemMap);
            }
        }
        catch (Exception ex) {
            log.warn("fidm  initOtherDim Exception:" + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> doExport_Excel(ReportExportInfo pair) {
        SXSSFWorkbook workbook = new SXSSFWorkbook(500);
        try {
            Serializable serializable;
            ArrayList<SpreadManager> spreadModelList = new ArrayList<SpreadManager>(100);
            this.sheetName2Name.clear();
            this.setCurrentFileInfo(pair);
            FileInfo fileInfo = new FileInfo(null, 0);
            fileInfo.setReportDataType(pair.getReportDataType());
            List<String> numSeqListSort = this.sortTemplateSeqByNumber(this.tempReportInfo.getAllTemps(), pair);
            block12: for (String str : numSeqListSort) {
                for (DynamicObject obj : this.tempReportInfo.getAllTemps().values()) {
                    if (!obj.getString("number").equals(str)) continue;
                    fileInfo.getNumSeqList().add(obj.getString("number"));
                    continue block12;
                }
            }
            for (String number : "2".equals(this.excelfiletype) ? this.tempReportInfo.getOrgIds() : ("1".equals(this.excelfiletype) ? this.tempReportInfo.getOrgIds() : fileInfo.getNumSeqList())) {
                TraceSpan ts = Tracer.create((String)"rpt_export", (String)"rpt_export");
                serializable = null;
                try {
                    ts.addTag("count", "doExport_Excel");
                    workbook = this.initUnWeavingReport(this.tempReportInfo, fileInfo, pair, null, number, workbook, spreadModelList);
                    if (ExportPageSourceEnum.WORKPAPER.getIndex() == this.getPageSourceEnum().getIndex()) continue;
                    workbook = this.initWeavingReport(this.tempReportInfo, fileInfo, pair, null, number, workbook, spreadModelList);
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (ts == null) continue;
                    if (serializable != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                        continue;
                    }
                    ts.close();
                }
            }
            if (StringUtils.isEmpty((String)fileInfo.getFileName())) {
                String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u7f16\u5236\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff0c\u53ef\u80fd\u7ec4\u7ec7\u672a\u5206\u914d\u6a21\u677f\u6216\u8005\u8f93\u5165\u7ef4\u5ea6\u6210\u5458\u6570\u636e\u6743\u9650\u5bfc\u81f4\uff01", (String)"ModuleDataGeneralHelper_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            fileInfo.setFileName(fileInfo.getFileName().replaceFirst("filterdim", ""));
            if (fileInfo.getSheetIndex() != 0) {
                byte[] excelFileData = this.saveToBytes(workbook);
                List<ReportSectionAreaInfo> floatArea = this.getFloatArea(spreadModelList);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
                map.put("excelData", excelFileData);
                map.put("areaData", JSON.toJSONString(floatArea));
                serializable = map;
                return serializable;
            }
        }
        finally {
            workbook.dispose();
        }
        return null;
    }

    private List<ReportSectionAreaInfo> getFloatArea(List<SpreadManager> spreadModelList) {
        ArrayList<ReportSectionAreaInfo> floatAreas = new ArrayList<ReportSectionAreaInfo>(10);
        if (spreadModelList == null || spreadModelList.size() == 0) {
            return floatAreas;
        }
        SpreadManager spreadManager = spreadModelList.get(0);
        if (spreadManager.getAreaManager() == null || spreadManager.getAreaManager().getPostionInfoSet() == null) {
            return floatAreas;
        }
        for (PositionInfo p : spreadManager.getAreaManager().getPostionInfoSet()) {
            if (p == null) continue;
            ArrayList<String> basePoints = new ArrayList<String>(100);
            for (RangeModel rangeModel : p.getFloatDataArea()) {
                basePoints.add(rangeModel.getAreaRangeStr());
            }
            ReportSectionAreaInfo areaInfo = new ReportSectionAreaInfo();
            areaInfo.setOriginalArea(p.getOriginalAreaRange());
            areaInfo.setArea(p.getAreaRange());
            areaInfo.setFloatAreas(basePoints);
            floatAreas.add(areaInfo);
        }
        return floatAreas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] saveToBytes(SXSSFWorkbook workbook) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
        }
        finally {
            block25: {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (workbook == null) break block25;
                    try {
                        workbook.dispose();
                        workbook.close();
                    }
                    catch (IOException e) {
                        log.warn("saveToBytes IOException:" + e);
                    }
                }
                catch (IOException e) {
                    log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                }
            }
        }
        return null;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static Integer convertValueToInt(Object value, int defaultVal) {
        Integer val = defaultVal;
        if (value == null) {
            return val;
        }
        try {
            val = Integer.valueOf(value.toString());
        }
        catch (Exception ex) {
            val = defaultVal;
        }
        if (val == null) {
            val = defaultVal;
        }
        return val;
    }
}

