/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.disclosure.template;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.disclosure.base.DisclosureReportSectionHelper;
import kd.fi.bcm.spread.domain.view.Sheet;

public class ComponentEditPlugin
extends AbstractBaseFormPlugin {
    private static String PERMCLASS = "permclass";
    private static String FIDMMODEL = "fidmmodel";
    public static final String[] CATALOG_TYPE_VALUE = new String[]{"1", "2"};

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit catalog = (BasedataEdit)this.getControl("catalog");
        catalog.addBeforeF7SelectListener(e -> {
            QFilter qf = new QFilter("model.model", "=", (Object)this.getModelId());
            qf.and("catalogtype", "in", Arrays.asList(CATALOG_TYPE_VALUE));
            QFilter qFilter2 = new QFilter("catalogtype", "!=", (Object)"2");
            qFilter2.or("number", "!=", (Object)"root");
            qf.and(qFilter2);
            this.addModuleCataLogPermFilter(qf);
            e.addCustomQFilter(qf);
            ((ListShowParameter)e.getFormShowParameter()).getTreeFilterParameter().setQFilters(Collections.singletonList(qf));
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_cancel", "btn_confrim");
        BasedataEdit permClass = (BasedataEdit)this.getView().getControl(PERMCLASS);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permClass, (Object)this.getFidmmodel(), (String)FIDMMODEL, (String)"fidm");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPageData();
    }

    private void initPageData() {
        String selectedarea = "ALL";
        Long templateId = (Long)this.getFormCustomParam("templateId");
        selectedarea = (String)this.getFormCustomParam("selectedarea");
        String[] split = selectedarea.split(":");
        if (split[0].equals(split[1])) {
            selectedarea = "ALL";
        }
        this.getView().getModel().setValue("selectedarea", (Object)selectedarea);
        this.getView().getModel().setValue("template", (Object)templateId);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"template"});
        if (Objects.isNull(this.getFidmmodel())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"catalog"});
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_confrim": {
                if (!this.saveComponentInfo()) break;
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
            }
        }
    }

    private boolean saveComponentInfo() {
        Long fidmmodelId = this.getFidmmodel();
        if (Objects.isNull(fidmmodelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u62ab\u9732\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u521b\u5efa\u62ab\u9732\u4f53\u7cfb\u3002", (String)"ComponentEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("number") == null || this.getModel().getValue("name") == null || this.getModel().getValue("catalog") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"ComponentEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.checkFidmModuleNumber(fidmmodelId, (String)this.getModel().getValue("number"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"ReportDesignPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject tem = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getFormCustomParam("templateId"), (String)"bcm_templateentity");
        if (Objects.isNull(tem)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f\u3002", (String)"ComponentEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Sheet sheet = (Sheet)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("sheet")));
        DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"bcm_component_info");
        info.set("template", this.getFormCustomParam("templateId"));
        info.set("selectedarea", this.getModel().getValue("selectedarea"));
        info.set("number", this.getModel().getValue("number"));
        info.set("name", this.getModel().getValue("name"));
        info.set("permclass", this.getModel().getValue("permclass"));
        info.set("description", this.getModel().getValue("description"));
        info.set("catalog", this.getModel().getValue("catalog") == null ? Long.valueOf(0L) : this.getModel().getValue("catalog"));
        info.set("slice", (Object)SerializationUtils.serializeToBase64((Object)sheet));
        info.set("model", (Object)this.getModelId());
        info.set("rptdata", (Object)tem.getString("rptdata"));
        info.set("rptspreadjson", (Object)tem.getString("rptspreadjson"));
        List list = (List)JacksonUtils.fromJson((String)((String)this.getFormCustomParam("pageDimension")), List.class);
        info.set("pagedim", (Object)JSON.toJSONString(list.stream().map(t -> (String)t.get("dim_number")).collect(Collectors.toList())));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        PermClassEntityHelper.savePermClass((DynamicObject)info, (String)FIDMMODEL);
        this.saveFidmMudule(info, fidmmodelId);
        this.getView().returnDataToParent((Object)"true");
        return true;
    }

    private Long getFidmmodel() {
        return this.getModelId();
    }

    private boolean checkFidmModuleNumber(Long fidmmodelId, String number) {
        return QueryServiceHelper.exists((String)"fidm_modulerepository", (QFilter[])new QFilter("model", "=", (Object)fidmmodelId).and("number", "=", (Object)number).toArray());
    }

    private void saveFidmMudule(DynamicObject component, Long fidmmodelId) {
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        moduleMap.put("fidmmodelId", fidmmodelId);
        moduleMap.put("number", component.getString("number"));
        moduleMap.put("name", component.getString("name"));
        moduleMap.put("description", component.getString("description"));
        DynamicObject catalog = (DynamicObject)this.getValue("catalog");
        Long catalogId = Objects.nonNull(catalog) ? Long.valueOf(catalog.getLong("id")) : null;
        moduleMap.put("catalogId", catalogId);
        moduleMap.put("permclassId", component.getLong("permclass.id"));
        moduleMap.put("componentId", component.getLong("id"));
        List reportDims = (List)JacksonUtils.fromJson((String)((String)this.getFormCustomParam("pageDimension")), List.class);
        moduleMap.put("reportDims", reportDims);
        DisclosureReportSectionHelper.saveModuleByReportSection(moduleMap);
    }

    private void addModuleCataLogPermFilter(QFilter catalogBuilder) {
        HashSet noPermsCataLog = new HashSet(16);
        noPermsCataLog.addAll(PermClassEntityHelper.getFIDMPermissionMap((String)"fidm_modulecatalog", (Long)this.getFidmmodel(), (Long)this.getUserId()).get((Object)"1"));
        if (noPermsCataLog.size() != 0) {
            catalogBuilder.and(new QFilter("id", "not in", noPermsCataLog));
        }
    }
}

