/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.epmclient;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class EPMClientEditPlugin
extends AbstractBaseFormPlugin {
    public static final String BTN_SAVE = "save";
    public static final String VERSION = "version";
    public static final String REMARK = "remark";
    public static final String RICHTEXTEDITOR = "richtexteditorap";
    public static final String ATTACH = "attach";
    private boolean isAdd = true;

    @Override
    public void initialize() {
        super.initialize();
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)this.getUserId());
        if (!adminUser) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String remark = this.getValue(REMARK).toString();
        RichTextEditor rap = (RichTextEditor)this.getControl(RICHTEXTEDITOR);
        rap.setText(remark);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (BTN_SAVE.equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String action = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"EPMClientEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String version = this.getValue(VERSION).toString();
            String actionResult = version + " " + ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f\u3002", (String)"EPMClientEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (!this.isAdd) {
                actionResult = version + " " + ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"EPMClientEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            OperationLogUtil.writeOperationLog((String)action, (String)actionResult, null, (String)"bcm_epmclient_info");
            this.getView().close();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean bl = this.isAdd = (Long)this.getValue("id") == 0L;
        if (BTN_SAVE.equals(((Save)args.getSource()).getOperateKey())) {
            String version = this.getValue(VERSION).toString().trim().toUpperCase(Locale.ENGLISH);
            if (!version.startsWith("V")) {
                version = "V" + version;
                this.setValue(VERSION, version);
            }
            QFilter qf = new QFilter(VERSION, "=", (Object)version);
            DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_epmclient_info", (String)VERSION, (QFilter[])new QFilter[]{qf});
            Boolean isError = false;
            if (null != data && (Long)this.getValue("id") == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7248\u672c\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"EPMClientEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                isError = true;
                args.setCancel(true);
            }
            DynamicObjectCollection attach = (DynamicObjectCollection)this.getValue(ATTACH);
            if (!isError.booleanValue() && attach.size() != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u9644\u4ef6\uff01", (String)"EPMClientEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            RichTextEditor rap = (RichTextEditor)this.getControl(RICHTEXTEDITOR);
            this.setValue(REMARK, rap.getText());
        }
    }
}

