/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.epmclient;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class EPMClientListPlugin
extends AbstractBaseListPlugin {
    public static final String BTN_ADD = "add";
    public static final String BTN_DEL = "del";
    public static final String BTN_DOWN = "down";
    public static final String BTN_ENABLE = "enable";
    public static final String BTN_DISABLE = "disable";
    public static final String BTN_REFRESH = "refresh";
    private static final String BILLLISTAP = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
    }

    public void setFilter(SetFilterEvent e) {
        e.setMainOrgQFilter(null);
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)this.getUserId());
        if (!adminUser) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("status", "=", (Object)true));
            qFilters.add(new QFilter("userwhitelist.fbasedataid", "=", (Object)this.getUserId()).or(new QFilter("userwhitelist.fbasedataid", "is null", null)));
            e.setCustomQFilters(qFilters);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)this.getUserId());
        if (!adminUser) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ADD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_DEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ENABLE});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "down": {
                this.Download();
                break;
            }
            case "enable": {
                this.SetStatus(true);
                break;
            }
            case "disable": {
                this.SetStatus(false);
                break;
            }
        }
    }

    private void Download() {
        ListSelectedRowCollection billlistap = ((BillList)this.getView().getControl(BILLLISTAP)).getSelectedRows();
        if (!billlistap.isEmpty()) {
            Object[] primaryKeyValues = billlistap.getPrimaryKeyValues();
            DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_epmclient_info", (String)"version,attach.fbasedataid.url", (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray());
            ArrayList<String> versions = new ArrayList<String>(data.size());
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject load = (DynamicObject)data.get(i);
                String url = load.getString("attach.fbasedataid.url");
                versions.add(load.getString("version"));
                String fullUrl = RequestContext.get().getClientFullContextPath() + "attachment/download.do?path=" + url;
                this.downloadFile(fullUrl, null, null);
            }
            String action = ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"EPMClientListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            OperationLogUtil.writeOperationLog((String)action, (String)String.join((CharSequence)",", versions), null, (String)"bcm_epmclient_info");
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"EPMClientListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void SetStatus(boolean enable) {
        BillList billListAp = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection billlistap = billListAp.getSelectedRows();
        if (!billlistap.isEmpty()) {
            Object[] primaryKeyValues = billlistap.getPrimaryKeyValues();
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("id", "in", (Object)primaryKeyValues);
            qfBuilder.add("status", "=", (Object)(!enable ? 1 : 0));
            Object[] dos = BusinessDataServiceHelper.load((String)"bcm_epmclient_info", (String)"id,status,modifier,modifydate,version", (QFilter[])qfBuilder.toArray());
            if (dos.length > 0) {
                String action;
                ArrayList<String> versions = new ArrayList<String>(dos.length);
                for (DynamicObject dynamicObject : dos) {
                    dynamicObject.set("status", (Object)enable);
                    dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
                    versions.add(dynamicObject.getString("version"));
                }
                BusinessDataWriter.update((IDataEntityType)dos[0].getDynamicObjectType(), (Object[])dos);
                billListAp.refresh();
                if (enable) {
                    action = ResManager.loadKDString((String)"\u542f\u7528", (String)"EPMClientListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    String actionResult = ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"EPMClientListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    OperationLogUtil.writeOperationLog((String)action, (String)(String.join((CharSequence)",", versions) + " " + actionResult), null, (String)"bcm_epmclient_info");
                    this.getView().showSuccessNotification(actionResult);
                } else {
                    action = ResManager.loadKDString((String)"\u7981\u7528", (String)"EPMClientListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    String actionResult = ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"EPMClientListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    OperationLogUtil.writeOperationLog((String)action, (String)(String.join((CharSequence)",", versions) + " " + actionResult), null, (String)"bcm_epmclient_info");
                    this.getView().showSuccessNotification(actionResult);
                }
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"EPMClientListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billListAp = (BillList)this.getView().getControl(BILLLISTAP);
        BaseShowParameter bs = this.getBaseShowParameter();
        bs.setPkId(billListAp.getFocusRowPkId());
        bs.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)bs);
    }

    private BaseShowParameter getBaseShowParameter() {
        BaseShowParameter bs = new BaseShowParameter();
        bs.setFormId("bcm_epmclient_info");
        bs.getOpenStyle().setShowType(ShowType.Modal);
        bs.setCustomParam(this.getModelSign(), (Object)this.getModelId());
        bs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_REFRESH));
        return bs;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "refresh": {
                BillList billListAp = (BillList)this.getView().getControl(BILLLISTAP);
                billListAp.refresh();
                break;
            }
        }
    }
}

