/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.eventcenter;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BaseDataConfig {
    private Map<String, Set<ConfigEntry>> typeDim;

    public void addEntry(String number, ConfigEntry entry) {
        if (StringUtils.isEmpty((CharSequence)number) || entry == null) {
            return;
        }
        if (this.typeDim == null) {
            this.typeDim = new HashMap<String, Set<ConfigEntry>>(16);
        }
        Set entrySet = this.typeDim.getOrDefault(number, new HashSet(10));
        entrySet.add(entry);
        this.typeDim.put(number, entrySet);
    }

    public Map<String, Set<ConfigEntry>> getTypeDim() {
        return this.typeDim;
    }

    public Set<String> getBaseDataType() {
        if (this.typeDim == null || this.typeDim.isEmpty()) {
            return Sets.newHashSet();
        }
        return this.typeDim.keySet();
    }

    public static class ConfigEntry {
        private String type;
        private long dimension;
        private long cslscheme;
        private String member;
        private String condition;

        public ConfigEntry(String type, long dimension, long cslscheme, String member, String condition) {
            this.type = type;
            this.dimension = dimension;
            this.cslscheme = cslscheme;
            this.member = member;
            this.condition = condition;
        }

        public String getType() {
            return this.type;
        }

        public long getDimension() {
            return this.dimension;
        }

        public long getCslscheme() {
            return this.cslscheme;
        }

        public String getMember() {
            return this.member;
        }

        public String getCondition() {
            return this.condition;
        }
    }
}

