/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.eventcenter;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.localcache.SyncCacheUtil;
import kd.fi.bcm.common.db.SQLBuilder4RDB;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.eventcenter.BaseDataConfig;
import kd.fi.bcm.formplugin.eventcenter.BaseDataVO;
import kd.fi.bcm.formplugin.eventcenter.DimensionMemberHelper;

public class BaseDataImportHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(BaseDataImportHelper.class);
    private String entityNumber;
    private String operation;
    private List<String> businessKeys;
    private static final String BOS_ORG = "bos_org";
    public static final String BD_CACHE_KEY = "dim-basedata-mapping";

    public BaseDataImportHelper() {
    }

    public BaseDataImportHelper(String entityNumber, String operation, List<String> businessKeys) {
        this.entityNumber = entityNumber;
        this.operation = operation;
        this.businessKeys = businessKeys;
    }

    public void createTempData() {
        Object[] pkArray = new Object[this.businessKeys.size()];
        for (int i2 = 0; i2 < this.businessKeys.size(); ++i2) {
            pkArray[i2] = LongUtil.toLong((Object)this.businessKeys.get(i2));
        }
        Map<Long, BaseDataConfig> mappings = BaseDataImportHelper.getOrLoadMapping(0L);
        Set<String> baseDataType = this.getBaseDataType(0L, mappings);
        if (pkArray.length == 0 || baseDataType.isEmpty()) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)dataEntityType);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        ArrayList newObjects = new ArrayList(dynamicObjects.length);
        ArrayList updateObjects = new ArrayList(10);
        IntStream.range(0, dynamicObjects.length).forEach(i -> {
            QFilter typeFilter;
            String status = dynamicObjects[i].getString("status");
            String enable = dynamicObjects[i].getString("enable");
            if (BOS_ORG.equalsIgnoreCase(this.entityNumber) && !dynamicObjects[i].getBoolean("fisaccounting")) {
                return;
            }
            if (!this.isValid(status, enable)) {
                return;
            }
            Long baseDataId = dynamicObjects[i].getLong("id");
            QFilter idFilter = new QFilter("basedataid", "=", (Object)baseDataId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_basedataimport", (String)"id,type,number,name,simplename,basedataid,operation,status,enable,source,execstatus,creator,modifier,createtime,modifytime,isintercompany", (QFilter[])new QFilter[]{idFilter, typeFilter = new QFilter("type", "=", (Object)this.entityNumber)});
            if (Objects.isNull(dynamicObject)) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_basedataimport");
                dynamicObject.set("createtime", (Object)TimeServiceHelper.now());
                dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
                newObjects.add(dynamicObject);
            } else {
                updateObjects.add(dynamicObject);
            }
            dynamicObject.set("type", (Object)this.entityNumber);
            dynamicObject.set("number", (Object)dynamicObjects[i].getString("number"));
            dynamicObject.set("name", (Object)dynamicObjects[i].getString("name"));
            if (BOS_ORG.equalsIgnoreCase(this.entityNumber)) {
                dynamicObject.set("simplename", (Object)dynamicObjects[i].getString("simplename"));
            }
            dynamicObject.set("basedataid", (Object)dynamicObjects[i].getLong("id"));
            dynamicObject.set("operation", (Object)this.operation);
            dynamicObject.set("status", (Object)dynamicObjects[i].getString("status"));
            dynamicObject.set("enable", (Object)dynamicObjects[i].getString("enable"));
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
            dynamicObject.set("source", (Object)"0");
            dynamicObject.set("execstatus", (Object)0);
            String isInternal = "0";
            if (("bd_customer".equals(this.entityNumber) || "bd_supplier".equals(this.entityNumber)) && dynamicObjects[i].get("internal_company") != null) {
                isInternal = "1";
            }
            dynamicObject.set("isintercompany", (Object)isInternal);
        });
        if (!updateObjects.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateObjects.toArray(new DynamicObject[0]));
            this.resetStatus(updateObjects.stream().map(m -> m.getLong("id")).collect(Collectors.toSet()));
        }
        if (!newObjects.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])newObjects.toArray(new DynamicObject[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBaseData(long modelId) {
        block34: {
            log.startWatch();
            try (DLock lock = DLock.create((String)("BaseDataImportHelper_importBaseData_" + modelId)).fastMode();){
                if (!lock.tryLock()) break block34;
                try {
                    BaseDataConfig config = BaseDataImportHelper.getOrLoadMapping(modelId).get(modelId);
                    if (config == null || CollectionUtils.isEmpty(config.getBaseDataType())) {
                        return;
                    }
                    Set<String> baseDataType = config.getBaseDataType();
                    SQLBuilder4RDB sqlBuilder = new SQLBuilder4RDB();
                    sqlBuilder.append("select a.fid,a.ftype,a.fnumber,a.fname,a.fsimplename,a.fbasedataid,a.fexecstatus,a.fisintercompany from t_bcm_bdimport a where a.fexecstatus = 0 and ").in("a.ftype", baseDataType).append("and not exists (select 1 from t_bcm_bdimportentry b where b.fid=a.fid  and").equal("b.fmodelid", (Object)modelId).append(" and b.fstatus='1') order by a.fmodifytime desc");
                    HashSet<Long> ids = new HashSet<Long>(1024);
                    ArrayList<BaseDataVO> dataList = new ArrayList<BaseDataVO>(1024);
                    try (DataSet dataset = DB.queryDataSet((String)"BaseDataImport.doQuery", (DBRoute)BCMConstant.DBROUTE, (String)sqlBuilder.getSQL(), (Object[])sqlBuilder.getParams());){
                        Iterator result = dataset.iterator();
                        while (result.hasNext()) {
                            if (ids.size() >= 10000) {
                                break;
                            }
                            Row row = (Row)result.next();
                            ids.add(row.getLong("fid"));
                            BaseDataVO data2 = new BaseDataVO(row.getLong("fid"), row.getString("ftype"), row.getString("fnumber"), row.getString("fname"));
                            data2.setBaseDataId(row.getLong("fbasedataid"));
                            data2.setStatus(row.getInteger("fexecstatus"));
                            data2.setInterCompany(row.getBoolean("fisintercompany"));
                            dataList.add(data2);
                        }
                    }
                    log.info("basedata importing size:" + ids.size());
                    HashSet cacheDim = new HashSet(16);
                    dataList.forEach(data -> {
                        if (config.getBaseDataType().contains(data.getType())) {
                            Set<BaseDataConfig.ConfigEntry> entries = config.getTypeDim().get(data.getType());
                            entries.forEach(entry -> new DimensionMemberHelper(modelId, (BaseDataConfig.ConfigEntry)entry, (BaseDataVO)data, cacheDim).saveOrUpdateDim());
                        }
                    });
                    log.infoEnd("basedata import end size:" + ids.size());
                    String modelNum = MemberReader.findModelNumberById((Object)modelId);
                    cacheDim.forEach(d -> {
                        SyncCacheUtil.updateAppCacheTime((String)GlobalCacheServiceHelper.packAboutDimCacheKey((String)modelNum, (String)MemberReader.getEntityNumberByDim((String)modelNum, (String)d)));
                        MQMessagePublisherServiceHelper.publishClearDimMemberCache((String)modelNum, (String)d);
                    });
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    public static Map<Long, BaseDataConfig> getOrLoadMapping(long modelId) {
        return (Map)GlobalCacheServiceHelper.getOrLoadNodeFixKey((String)("dim-basedata-mapping_" + modelId), () -> {
            HashMap mapping = new HashMap(16);
            String selectFields = "id,model,entryentity.dimension,entryentity.config,entryentity.cslscheme,entryentity.member,entryentity.assistantgroup,entryentity.filtercondition_tag";
            QFilter filter = new QFilter("status", "=", (Object)"1");
            if (modelId != 0L) {
                filter.and(new QFilter("model.id", "=", (Object)modelId));
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_bdmapping", (String)selectFields, (QFilter[])new QFilter[]{filter});
            IntStream.range(0, dynamicObjects.length).forEach(i -> {
                DynamicObject dynamicObject = dynamicObjects[i];
                long mId = dynamicObject.getLong("model.id");
                DynamicObjectCollection entryDoc = (DynamicObjectCollection)dynamicObject.get("entryentity");
                BaseDataConfig config = mapping.getOrDefault(mId, new BaseDataConfig());
                mapping.put(mId, config);
                IntStream.range(0, entryDoc.size()).forEach(j -> {
                    String number = ((DynamicObject)entryDoc.get(j)).getString("config.number");
                    long cslscheme = ((DynamicObject)entryDoc.get(j)).getLong("cslscheme.id");
                    long dimension = ((DynamicObject)entryDoc.get(j)).getLong("dimension.id");
                    String member = ((DynamicObject)entryDoc.get(j)).getString("member");
                    String condition = ((DynamicObject)entryDoc.get(j)).getString("filtercondition_tag");
                    BaseDataConfig.ConfigEntry entry = new BaseDataConfig.ConfigEntry(number, dimension, cslscheme, member, condition);
                    config.addEntry(number, entry);
                });
            });
            return Collections.unmodifiableMap(mapping);
        });
    }

    private boolean isValid(String status, String enable) {
        if (status != null && !"C".equals(status)) {
            return false;
        }
        return enable == null || "1".equals(enable);
    }

    private Set<String> getBaseDataType(long modelId, Map<Long, BaseDataConfig> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            return Sets.newHashSet();
        }
        HashSet<String> baseDataType = new HashSet<String>(16);
        if (modelId != 0L && mappings.get(modelId) != null) {
            return mappings.get(modelId).getBaseDataType();
        }
        mappings.values().forEach(c -> baseDataType.addAll(c.getBaseDataType()));
        return baseDataType;
    }

    private void resetStatus(Set<Long> ids) {
        SQLBuilder4RDB sqlBuilder = new SQLBuilder4RDB();
        sqlBuilder.append("update t_bcm_bdimportentry set fstatus = '0' where ").in("fid", ids);
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sqlBuilder.getSQL(), (Object[])sqlBuilder.getParams());
    }
}

