/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.dimension.imp.AccountImportPlugin;
import kd.fi.bcm.formplugin.dimension.imp.DimensionImportHelper;
import kd.fi.bcm.formplugin.eventcenter.BaseDataConfig;
import kd.fi.bcm.formplugin.eventcenter.BaseDataVO;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.lang3.StringUtils;

public class DimensionMemberHelper {
    private static final Log logger = LogFactory.getLog(DimensionMemberHelper.class);
    private Long modelId;
    private String modelNum;
    private String dimNum;
    private Long dimension;
    private Long cslscheme;
    private String number;
    private String name;
    private String member;
    private BaseDataVO baseData;
    private String entityName;
    private Set<String> cacheDim;
    private String dataType;
    private String condition;
    private static final String PARENT_FIELDS = "id,number,name,longnumber,model,level,isleaf";

    public DimensionMemberHelper(Long modelId, BaseDataConfig.ConfigEntry configEntry, BaseDataVO baseData) {
        this.modelId = modelId;
        this.dimension = configEntry.getDimension();
        this.baseData = baseData;
        this.cslscheme = configEntry.getCslscheme();
        this.member = configEntry.getMember();
        this.number = baseData.getNumber();
        this.name = baseData.getName();
        this.modelNum = MemberReader.findModelNumberById((Object)modelId);
        this.entityName = MemberReader.getDimensionDynById((long)this.dimension).getString("membermodel");
        this.dimNum = MemberReader.getDimensionNumById((long)this.dimension);
        this.dataType = configEntry.getType();
        this.condition = configEntry.getCondition();
    }

    public DimensionMemberHelper(Long modelId, BaseDataConfig.ConfigEntry configEntry, BaseDataVO baseData, Set<String> cacheDim) {
        this(modelId, configEntry, baseData);
        this.cacheDim = cacheDim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void saveOrUpdateDim() {
        block14: {
            block15: {
                block13: {
                    block12: {
                        block11: {
                            errorMsg = new StringBuilder();
                            if (this.modelId == null || this.dimension == null || this.baseData == null) {
                                return;
                            }
                            if (StringUtils.isEmpty((CharSequence)this.condition)) break block11;
                            filter = new QFilter("id", "=", (Object)this.baseData.getBaseDataId());
                            filter.and(this.getCondition(this.dataType, this.condition));
                            if (QueryServiceHelper.exists((String)this.dataType, (QFilter[])filter.toArray())) break block11;
                            this.updateStatus(this.baseData.getId(), this.modelId, errorMsg.length() > 0 ? 2 : 1, errorMsg.toString());
                            return;
                        }
                        if (!"bcm_icmembertree".equals(this.entityName) || !this.baseData.isInterCompany()) break block12;
                        errorMsg.append("Base data is internal company.");
                        this.updateStatus(this.baseData.getId(), this.modelId, errorMsg.length() > 0 ? 2 : 1, errorMsg.toString());
                        return;
                    }
                    fields = "id,number,name,simplename,modifytime";
                    if (!"bcm_entitymembertree".equals(this.entityName)) ** GOTO lbl31
                    if (this.cslscheme != null && this.cslscheme != 0L) break block13;
                    errorMsg.append("Entity scheme is null.");
                    this.updateStatus(this.baseData.getId(), this.modelId, errorMsg.length() > 0 ? 2 : 1, errorMsg.toString());
                    return;
                }
                fields = fields + ",isinnerorg,entitypart.isouterorg,cslscheme.id";
lbl31:
                // 2 sources

                if ((docs = QueryServiceHelper.query((String)this.entityName, (String)fields, (QFilter[])(qFilter = this.getQFilter(this.number)).toArray())) == null || docs.size() == 0) {
                    this.createDim(this.entityName, errorMsg);
                    break block14;
                }
                if (docs.size() != 1) ** GOTO lbl46
                doc = (DynamicObject)docs.get(0);
                if (!"bcm_entitymembertree".equals(this.entityName) || this.cslscheme.longValue() == doc.getLong("cslscheme.id")) break block15;
                errorMsg.append("Config scheme not equals entity scheme.");
                this.updateStatus(this.baseData.getId(), this.modelId, errorMsg.length() > 0 ? 2 : 1, errorMsg.toString());
                return;
            }
            try {
                if (StringUtils.isNotEmpty((CharSequence)this.name) && !this.name.equals(doc.getString("name"))) {
                    this.updateDim(this.entityName, doc.getLong("id"), errorMsg);
                }
                break block14;
lbl46:
                // 1 sources

                errorMsg.append("Found multi record.");
            }
            catch (Exception ex) {
                try {
                    errorMsg.append(ThrowableHelper.toString((Exception)ex));
                    this.updateStatus(this.baseData.getId(), this.modelId, errorMsg.length() > 0 ? 2 : 1, errorMsg.toString());
                }
                catch (Throwable var6_7) {
                    this.updateStatus(this.baseData.getId(), this.modelId, errorMsg.length() > 0 ? 2 : 1, errorMsg.toString());
                    throw var6_7;
                }
            }
        }
        this.updateStatus(this.baseData.getId(), this.modelId, errorMsg.length() > 0 ? 2 : 1, errorMsg.toString());
    }

    private void setCacheDim(String dimNum) {
        if (this.cacheDim == null) {
            this.cacheDim = new HashSet<String>(16);
        }
        this.cacheDim.add(dimNum);
    }

    private void updateDim(String entityName, long memberId, StringBuilder errorMsg) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)memberId, (String)entityName);
                String oldName = member.getString("name");
                member.set("name", (Object)this.name);
                member.set("simplename", (Object)this.baseData.getSimpleName());
                member.set("modifytime", (Object)TimeServiceHelper.now());
                if ("bcm_entitymembertree".equals(entityName)) {
                    DynamicObject myCompanyObj;
                    DynamicObject icObj;
                    this.updateNameRecord(entityName, member, oldName);
                    boolean isInnerOrg = member.getBoolean("isinnerorg");
                    boolean isOuterOrg = member.getBoolean("isouterorg");
                    QFilter filter = new QFilter("model", "=", (Object)this.modelId);
                    filter.and(new QFilter("number", "=", (Object)this.number));
                    if ((isInnerOrg || isOuterOrg) && Objects.nonNull(icObj = BusinessDataServiceHelper.loadSingle((String)"bcm_icmembertree", (String)"id,name", (QFilter[])new QFilter[]{filter}))) {
                        icObj.set("name", (Object)this.name);
                        SaveServiceHelper.update((DynamicObject)icObj);
                        this.setCacheDim(DimTypesEnum.INTERCOMPANY.getNumber());
                    }
                    if (Objects.nonNull(myCompanyObj = BusinessDataServiceHelper.loadSingle((String)"bcm_mycompanymembertree", (String)"id,name", (QFilter[])new QFilter[]{filter}))) {
                        myCompanyObj.set("name", (Object)this.name);
                        SaveServiceHelper.update((DynamicObject)myCompanyObj);
                        this.setCacheDim(DimTypesEnum.MYCOMPANY.getNumber());
                    }
                } else {
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{member});
                }
                this.setCacheDim(this.dimNum);
                this.modifyLog(this.modelId, this.dimension, this.number, oldName, this.name);
            }
            catch (Exception e) {
                tx.markRollback();
                errorMsg.append(ThrowableHelper.toString((Exception)e));
                logger.error(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private void createDim(String memberModel, StringBuilder errorMsg) {
        this.setCacheDim(this.dimNum);
        switch (memberModel) {
            case "bcm_userdefinedmembertree": {
                this.createUserDefinedDim(errorMsg);
                break;
            }
            case "bcm_icmembertree": {
                this.createICOEntityDim(errorMsg);
                break;
            }
            case "bcm_entitymembertree": {
                this.createEntityDim(errorMsg);
                break;
            }
            case "bcm_accountmembertree": {
                this.createAccountDim(errorMsg);
                break;
            }
            case "bcm_currencymembertree": {
                this.createCurrencyDim(errorMsg);
                break;
            }
        }
    }

    private DynamicObject createCommonMemberTree(String entityName, long dimId, String parentNum) {
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and(new QFilter("dimension", "=", (Object)dimId));
        filter.and(new QFilter("number", "=", (Object)parentNum));
        DynamicObject parent = QueryServiceHelper.queryOne((String)entityName, (String)"id,level,longnumber,isleaf", (QFilter[])filter.toArray());
        long parentId = parent.getLong("id");
        String memberTable = entityName.contains("icmembertree") ? "bcm_intercompanymember" : entityName.substring(0, entityName.length() - 4);
        DynamicObject member = this.newMember(memberTable);
        DynamicObject memberTree = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)memberTree);
        memberTree.set("member", (Object)member);
        memberTree.set("model", (Object)this.modelId);
        memberTree.set("dimension", (Object)dimId);
        memberTree.set("number", (Object)this.number);
        memberTree.set("name", (Object)this.name);
        memberTree.set("isleaf", (Object)true);
        memberTree.set("level", (Object)(parent.getInt("level") + 1));
        memberTree.set("storagetype", (Object)StorageTypeEnum.STORAGE.index);
        memberTree.set("aggoprt", (Object)AggOprtEnum.ADD.sign);
        memberTree.set("issysmember", (Object)2);
        memberTree.set("longnumber", (Object)(parent.getString("longnumber") + '!' + this.number));
        memberTree.set("parent", (Object)parentId);
        memberTree.set("dseq", (Object)this.getNextSeq(entityName, this.modelId, parentId));
        if (parent.getBoolean("isleaf")) {
            this.resetParentIsleaf(entityName, parentId);
        }
        return memberTree;
    }

    private void updateStatus(long id, long modelId, int status, String errorMsg) {
        DynamicObject executeRecord;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_basedataimport");
        DynamicObjectCollection docs = dynamicObject.getDynamicObjectCollection("executerecord");
        Optional<DynamicObject> record = docs.stream().filter(r -> r.getLong("model.id") == modelId).findFirst();
        if (record.isPresent()) {
            executeRecord = record.get();
        } else {
            executeRecord = new DynamicObject(docs.getDynamicObjectType());
            docs.add((Object)executeRecord);
        }
        errorMsg = errorMsg.length() > 200 ? errorMsg.substring(0, 200) : errorMsg;
        executeRecord.set("model", (Object)modelId);
        executeRecord.set("executestatus", (Object)status);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            executeRecord.set("executemsg", (Object)errorMsg);
        }
        executeRecord.set("executor", (Object)RequestContext.get().getCurrUserId());
        executeRecord.set("executetime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void createEntityDim(StringBuilder errorMsg) {
        long baseOrgId = this.baseData.getBaseDataId();
        DynamicObject defaultCur = this.getOrgDefaultCur(baseOrgId);
        if (defaultCur == null) {
            errorMsg.append("Not config default currency.");
            this.updateStatus(this.baseData.getId(), this.modelId, 0, errorMsg.toString());
            return;
        }
        DynamicObject parent = this.getEntityParent();
        String parentNum = parent.getString("number");
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.createCurAndProcessMember(defaultCur.getString("basecurrrency.number"), defaultCur.getString("basecurrrency.name"));
                DynamicObject memberTree = this.createCommonMemberTree("bcm_entitymembertree", this.dimension, parentNum);
                memberTree.set("simplename", (Object)this.baseData.getSimpleName());
                memberTree.set("cslscheme", (Object)this.cslscheme);
                memberTree.set("shownumber", (Object)this.number);
                memberTree.set("isclearorg", (Object)"0");
                memberTree.set("isinnerorg", (Object)"1");
                memberTree.set("currency", (Object)defaultCur.getLong("basecurrrency.id"));
                Date nowTime = TimeServiceHelper.now();
                long userId = RequestContext.get().getCurrUserId();
                DynamicObjectCollection nameRecords = memberTree.getDynamicObjectCollection("namechangerds");
                DynamicObject nameRecord = new DynamicObject(nameRecords.getDynamicObjectType());
                nameRecord.set("namerds", memberTree.get("name"));
                nameRecord.set("simplenamerds", memberTree.get("simplename"));
                nameRecord.set("nameeffdate", (Object)TimeServiceHelper.today());
                nameRecord.set("namemodifier", (Object)userId);
                nameRecord.set("namemodifytime", (Object)nowTime);
                nameRecord.set("seq", (Object)1);
                nameRecords.add((Object)nameRecord);
                DynamicObjectCollection bizRecords = memberTree.getDynamicObjectCollection("bizchangerds");
                DynamicObject bizRecord = new DynamicObject(bizRecords.getDynamicObjectType());
                bizRecord.set("changetype", (Object)OrgBizChangeTypeEnum.initNewlyAdded.getValue());
                bizRecord.set("bizeffdate", (Object)TimeServiceHelper.today());
                bizRecord.set("bizmodifier", (Object)userId);
                bizRecord.set("bizmodifytime", (Object)nowTime);
                bizRecord.set("seq", (Object)1);
                bizRecords.add((Object)bizRecord);
                DynamicObjectCollection currencyRecords = memberTree.getDynamicObjectCollection("currencychangerds");
                DynamicObject currencyRecord = new DynamicObject(currencyRecords.getDynamicObjectType());
                currencyRecord.set("currencyrds", (Object)defaultCur.getLong("basecurrrency.id"));
                currencyRecord.set("currencyeffdate", (Object)TimeServiceHelper.today());
                currencyRecord.set("currencymodifier", (Object)userId);
                currencyRecord.set("currencymodifytime", (Object)nowTime);
                currencyRecord.set("seq", (Object)1);
                currencyRecords.add((Object)currencyRecord);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberTree});
                boolean icSuccess = this.createInternalMember();
                boolean mcSuccess = this.createMyCompanyMember();
                ShareNodeStructSyncHelper.resyncShareNodeStructure((String)"bcm_entitymembertree", (long)this.modelId, (long)this.dimension);
                this.modifyLog(this.modelId, this.dimension, this.number, null, this.name);
                OlapServiceHelper.createMember((String)this.modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (String)this.number, (int)AggOprtEnum.ADD.getIntSign(), (String)parentNum);
                OlapServiceHelper.createMember((String)this.modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (String)(parentNum + "_" + this.number));
                if (icSuccess) {
                    OlapServiceHelper.createMember((String)this.modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)this.number, (int)AggOprtEnum.ADD.getIntSign(), (String)"ICEntity");
                    this.setCacheDim(DimTypesEnum.INTERCOMPANY.getNumber());
                }
                if (mcSuccess) {
                    OlapServiceHelper.createMember((String)this.modelNum, (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)this.number, (int)AggOprtEnum.ADD.getIntSign(), (String)"MyCompany");
                    this.setCacheDim(DimTypesEnum.MYCOMPANY.getNumber());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                errorMsg.append(ThrowableHelper.toString((Exception)e));
                logger.error(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private void createAccountDim(StringBuilder errorMsg) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bd_accountview");
        DynamicObject account = BusinessDataServiceHelper.loadSingle((Object)this.baseData.getBaseDataId(), (DynamicObjectType)dataEntityType);
        if (Objects.isNull(account)) {
            errorMsg.append("Base data account is not found.");
            return;
        }
        DynamicObject parent = this.getAccountParent(account);
        String parentNum = parent.getString("number");
        try (TXHandle tx = TX.requiresNew();){
            try {
                DynamicObject memberTree = this.createCommonMemberTree("bcm_accountmembertree", this.dimension, parentNum);
                memberTree.set("simplename", (Object)this.baseData.getSimpleName());
                memberTree.set("accountuse", (Object)"1");
                memberTree.set("datatype", (Object)"1");
                memberTree.set("isparticipmerge", (Object)"1");
                memberTree.set("isrelateorg", (Object)"0");
                memberTree.set("isyearendcarried", (Object)"0");
                if ("1".equals(account.getString("dc"))) {
                    memberTree.set("drcrdirect", (Object)"1");
                } else {
                    memberTree.set("drcrdirect", (Object)"2");
                }
                String accountType = AccountImportPlugin.getBaseAccountTypeName(account.getString("accounttype.accounttype"));
                String accountIndex = AccountImportPlugin.AccountType.getIndexByName(accountType);
                memberTree.set("accounttype", (Object)accountIndex);
                memberTree.set("exchange", (Object)"0");
                if (AccountImportPlugin.AccountType.ZC.getIndex().equals(accountIndex) || AccountImportPlugin.AccountType.FZ.getIndex().equals(accountIndex) || AccountImportPlugin.AccountType.QY.getIndex().equals(accountIndex)) {
                    memberTree.set("exchange", (Object)"1");
                } else if (AccountImportPlugin.AccountType.SY.getIndex().equals(accountIndex) || AccountImportPlugin.AccountType.XJLL.getIndex().equals(accountIndex)) {
                    memberTree.set("exchange", (Object)"2");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberTree});
                this.modifyLog(this.modelId, this.dimension, this.number, null, this.name);
                OlapServiceHelper.createMember((String)this.modelNum, (String)DimTypesEnum.ACCOUNT.getNumber(), (String)this.number, (int)AggOprtEnum.ADD.getIntSign(), (String)parentNum);
            }
            catch (Exception e) {
                tx.markRollback();
                errorMsg.append(ThrowableHelper.toString((Exception)e));
                logger.error(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private boolean createInternalMember() {
        long icDimId = MemberReader.getDimensionIdByNum((long)this.modelId, (String)"InternalCompany");
        QFilter mFilter = new QFilter("model", "=", (Object)this.modelId);
        QFilter nFilter = new QFilter("number", "=", (Object)this.number);
        if (QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])new QFilter[]{mFilter, nFilter})) {
            return false;
        }
        DynamicObject memberTree = this.createCommonMemberTree("bcm_icmembertree", icDimId, "ICEntity");
        memberTree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberTree});
        return true;
    }

    private boolean createMyCompanyMember() {
        long dimId = MemberReader.getDimensionIdByNum((long)this.modelId, (String)"MyCompany");
        QFilter mFilter = new QFilter("model", "=", (Object)this.modelId);
        QFilter nFilter = new QFilter("number", "=", (Object)this.number);
        if (QueryServiceHelper.exists((String)"bcm_mycompanymembertree", (QFilter[])new QFilter[]{mFilter, nFilter})) {
            return false;
        }
        DynamicObject memberTree = this.createCommonMemberTree("bcm_mycompanymembertree", dimId, "MyCompany");
        memberTree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberTree});
        return true;
    }

    private void createCurrencyDim(StringBuilder errorMsg) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.createCurAndProcessMember(this.number, this.name);
                this.modifyLog(this.modelId, this.dimension, this.number, null, this.name);
            }
            catch (Exception e) {
                tx.markRollback();
                errorMsg.append(ThrowableHelper.toString((Exception)e));
                logger.error(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private void createCurAndProcessMember(String number, String name) {
        DynamicObject currencyMember = DimensionServiceHelper.createCurrencyMember((long)this.modelId, (String)this.modelNum, (String)number, (String)name, (String)this.getClass().getName());
        if (currencyMember != null) {
            DimensionServiceHelper.createProcessMember((long)this.modelId, (DynamicObject)currencyMember, (String)this.modelNum, (String)this.getClass().getName());
        }
    }

    private void createUserDefinedDim(StringBuilder errorMsg) {
        String parentNum = StringUtils.isEmpty((CharSequence)this.member) ? this.dimNum : this.member;
        try (TXHandle tx = TX.requiresNew();){
            try {
                DynamicObject memberTree = this.createCommonMemberTree("bcm_userdefinedmembertree", this.dimension, parentNum);
                memberTree.set("datatype", (Object)DataTypeEnum.DEFAULT.index);
                memberTree.set("source", (Object)LongUtil.toLong((Object)DimensionImportHelper.getIndex(this.baseData.getType())));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberTree});
                OlapServiceHelper.createMember((String)this.modelNum, (String)this.dimNum, (String)this.number, (int)AggOprtEnum.ADD.getIntSign(), (String)parentNum);
                this.modifyLog(this.modelId, this.dimension, this.number, null, this.name);
            }
            catch (Exception e) {
                tx.markRollback();
                errorMsg.append(ThrowableHelper.toString((Exception)e));
                logger.error(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private void createICOEntityDim(StringBuilder errorMsg) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                DynamicObject memberTree = this.createCommonMemberTree("bcm_icmembertree", this.dimension, "ICOEntity");
                memberTree.set("source", (Object)LongUtil.toLong((Object)DimensionImportHelper.getIndex(this.baseData.getType())));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberTree});
                OlapServiceHelper.createMember((String)this.modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)this.number, (int)AggOprtEnum.ADD.getIntSign(), (String)"ICOEntity");
                this.modifyLog(this.modelId, this.dimension, this.number, null, this.name);
            }
            catch (Exception e) {
                tx.markRollback();
                errorMsg.append(ThrowableHelper.toString((Exception)e));
                logger.error(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private DynamicObject newMember(String memberTable) {
        DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)memberTable);
        member.set("model", (Object)this.modelId);
        member.set("dimension", (Object)this.dimension);
        member.set("number", (Object)this.number);
        member.set("simplename", (Object)this.baseData.getSimpleName());
        member.set("name", (Object)this.name);
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)member);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{member});
        return member;
    }

    private void updateNameRecord(String entityName, DynamicObject entity, String oldName) {
        DynamicObjectCollection record = entity.getDynamicObjectCollection("namechangerds");
        DynamicObject lastRecord = (DynamicObject)record.get(record.size() - 1);
        Date lastEffDate = lastRecord.getDate("nameeffdate");
        Date effDate = TimeServiceHelper.today();
        if (DateTimeUtils.dayEquals((Date)effDate, (Date)lastEffDate)) {
            lastRecord.set("namerds", (Object)this.name);
            lastRecord.set("simplenamerds", (Object)this.baseData.getSimpleName());
            lastRecord.set("namemodifier", (Object)RequestContext.get().getCurrUserId());
            lastRecord.set("namemodifytime", (Object)TimeServiceHelper.now());
        } else {
            Date expDate = DateTimeUtils.getDayBefore((Date)effDate);
            if (expDate.before(lastEffDate)) {
                expDate = lastEffDate;
            }
            lastRecord.set("nameexpdate", (Object)expDate);
            DynamicObject newRecord = new DynamicObject(lastRecord.getDynamicObjectType());
            newRecord.set("namerds", (Object)this.name);
            newRecord.set("simplenamerds", (Object)this.baseData.getSimpleName());
            newRecord.set("nameeffdate", (Object)effDate);
            newRecord.set("namemodifier", (Object)RequestContext.get().getCurrUserId());
            newRecord.set("namemodifytime", (Object)TimeServiceHelper.now());
            newRecord.set("seq", (Object)(lastRecord.getInt("seq") + 1));
            record.add((Object)newRecord);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
        this.syncShareNode(entityName, entity.getLong("id"), record, oldName);
    }

    private void syncShareNode(String entityName, long copyFrom, DynamicObjectCollection storageRecord, String oldName) {
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and(new QFilter("number", "=", (Object)this.number));
        filter.and(new QFilter("copyfrom", "=", (Object)copyFrom));
        Set<Long> shareNodeIds = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter}).stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList nodes = new ArrayList(shareNodeIds.size());
        shareNodeIds.forEach(id -> {
            DynamicObject node = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)dataEntityType);
            String shareName = node.getString("name");
            if (shareName.equals(oldName)) {
                node.set("name", (Object)this.name);
                node.set("simplename", (Object)this.baseData.getSimpleName());
                node.set("modifytime", (Object)TimeServiceHelper.now());
                DynamicObjectCollection nameRecords = new DynamicObjectCollection();
                storageRecord.forEach(s -> nameRecords.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)s, (boolean)true, (boolean)true))));
                node.set("namechangerds", (Object)nameRecords);
                nodes.add(node);
            }
        });
        if (!nodes.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])nodes.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject getEntityParent() {
        String parentNumber;
        if (StringUtils.isNotEmpty((CharSequence)this.member)) {
            QFilter filter = this.getQFilter();
            filter.and(new QFilter("cslscheme", "=", (Object)this.cslscheme));
            filter.and(new QFilter("number", "=", (Object)this.member));
            filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index));
            DynamicObject parent = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)PARENT_FIELDS, (QFilter[])new QFilter[]{filter});
            if (Objects.nonNull(parent)) {
                return parent;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(parentNumber = this.getOrgParentNumber()))) {
            QFilter pFilter = this.getQFilter(parentNumber);
            pFilter.and(new QFilter("cslscheme", "=", (Object)this.cslscheme));
            DynamicObject parent = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)PARENT_FIELDS, (QFilter[])new QFilter[]{pFilter});
            if (Objects.nonNull(parent)) {
                return parent;
            }
        }
        QFilter filter = this.getQFilter();
        filter.and(new QFilter("parent.number", "=", (Object)"Entity"));
        filter.and(new QFilter("cslscheme", "=", (Object)this.cslscheme));
        return QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)PARENT_FIELDS, (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject getAccountParent(DynamicObject account) {
        String parentNumber;
        if (StringUtils.isNotEmpty((CharSequence)this.member)) {
            QFilter filter = this.getQFilter();
            filter.and(new QFilter("number", "=", (Object)this.member));
            filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index));
            DynamicObject parent = QueryServiceHelper.queryOne((String)"bcm_accountmembertree", (String)PARENT_FIELDS, (QFilter[])new QFilter[]{filter});
            if (Objects.nonNull(parent)) {
                return parent;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(parentNumber = account.getString("parent.number")))) {
            QFilter pFilter = this.getQFilter(parentNumber);
            DynamicObject parent = QueryServiceHelper.queryOne((String)"bcm_accountmembertree", (String)PARENT_FIELDS, (QFilter[])new QFilter[]{pFilter});
            if (Objects.nonNull(parent)) {
                return parent;
            }
        }
        QFilter filter = this.getQFilter();
        filter.and(new QFilter("number", "=", (Object)"Account"));
        return QueryServiceHelper.queryOne((String)"bcm_accountmembertree", (String)PARENT_FIELDS, (QFilter[])new QFilter[]{filter});
    }

    private int getNextSeq(String entityName, long modelId, long parentId) {
        String key = "getNextSeq|" + this.modelNum + "|" + parentId;
        int cacheSeq = (Integer)ThreadCache.get((Object)key, () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("parent", "=", (Object)parentId));
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)"dseq", (QFilter[])new QFilter[]{filter}, (String)"dseq desc", (int)1);
            int result = 0;
            if (!dcs.isEmpty()) {
                result = ((DynamicObject)dcs.get(0)).getInt("dseq");
            }
            return result;
        });
        ThreadCache.put((Object)key, (Object)(++cacheSeq));
        return cacheSeq;
    }

    private QFilter getQFilter(String number) {
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and(new QFilter("dimension", "=", (Object)this.dimension));
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("number", "=", (Object)number));
        filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index));
        return filter;
    }

    private QFilter getQFilter() {
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and(new QFilter("dimension", "=", (Object)this.dimension));
        filter.and(new QFilter("status", "=", (Object)"C"));
        return filter;
    }

    private void resetParentIsleaf(String entityName, long pid) {
        QFilter idFilter = new QFilter("id", "=", (Object)pid);
        QFilter filter = new QFilter("isleaf", "=", (Object)"1");
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"isleaf", (QFilter[])new QFilter[]{idFilter, filter});
        if (Objects.nonNull(parent)) {
            parent.set("isleaf", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
        }
    }

    private void modifyLog(long modelId, long dimension, String number, String beforeName, String name) {
        DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog((Long)modelId, (Long)dimension, null, (String)number, (String)name, (String)DimMemberOperateTypeEnum.BASE_DATA_IMPORT.getValue(), (String)DimMemberOperateTypeEnum.BASE_DATA_IMPORT.getName(), (String)beforeName, (String)name, (long)RequestContext.get().getCurrUserId(), (int)1, (String)RequestContext.get().getLoginIP());
        SaveDimMemberHelper.batchInsertDimMemberModifyLog(Collections.singletonList(modifyLog));
    }

    private String getOrgParentNumber() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject parentObj = BusinessDataServiceHelper.loadSingle((Object)this.baseData.getBaseDataId(), (DynamicObjectType)dataEntityType);
        DynamicObjectCollection docs = (DynamicObjectCollection)parentObj.get("structure");
        String parentNumber = null;
        for (DynamicObject dynamicObject : docs) {
            parentNumber = dynamicObject.getString("viewparent.number");
            if (!StringUtils.isNotEmpty((CharSequence)parentNumber)) continue;
            return parentNumber;
        }
        return parentNumber;
    }

    private DynamicObject getOrgDefaultCur(long baseOrgId) {
        return (DynamicObject)ThreadCache.get((Object)("getOrgDefaultCur|" + baseOrgId), () -> BusinessDataServiceHelper.loadSingle((String)"bd_accountingsys_base", (String)"basecurrrency", (QFilter[])new QFilter[]{new QFilter("baseacctorg.id", "=", (Object)baseOrgId)}));
    }

    private QFilter getCondition(String entityName, String condition) {
        FlexBDValueCondition flexCondition = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)condition, FlexBDValueCondition.class);
        FilterCondition fc = flexCondition.getFilterCondition();
        if (fc != null) {
            FilterBuilder filterBuilder = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)entityName), fc, true);
            filterBuilder.buildFilter(true);
            if (filterBuilder.getQFilter() != null) {
                return filterBuilder.getQFilter();
            }
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }
}

