/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.scheme.AbstractScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.excel.IExcelAction;
import kd.fi.bcm.formplugin.excel.dto.DimMember;
import kd.fi.bcm.formplugin.excel.dto.Dimension;
import kd.fi.bcm.formplugin.excel.dto.ReportTemplate;
import kd.fi.bcm.formplugin.report.ReportDataSelectScheme;
import kd.fi.bcm.formplugin.report.util.ReportDataSchemeUtil;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.domain.FilterDimDomain;
import kd.fi.bcm.spread.domain.PageDimDomain;
import kd.fi.bcm.spread.domain.ViewPointDimDomain;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;

public abstract class AbstractExcelAction
implements IExcelAction {
    protected Map<String, Object> param;

    public AbstractExcelAction() {
    }

    public AbstractExcelAction(Map<String, Object> param) {
        this.param = param;
    }

    @Override
    public Object execute() {
        return null;
    }

    protected Long getModelId() {
        return LongUtil.toLong((Object)this.param.get("modelId"));
    }

    protected Long getEntityId() {
        return LongUtil.toLong((Object)this.param.get("entityId"));
    }

    protected Long getYearId() {
        return LongUtil.toLong((Object)this.param.get("yearId"));
    }

    protected Long getScenarioId() {
        return LongUtil.toLong((Object)this.param.get("scenarioId"));
    }

    protected Long getPeriodId() {
        return LongUtil.toLong((Object)this.param.get("periodId"));
    }

    protected Long getCurrencyId() {
        return LongUtil.toLong((Object)this.param.get("currencyId"));
    }

    protected Long getTemplateId() {
        return LongUtil.toLong((Object)this.param.get("templateId"));
    }

    protected Long getProcessId() {
        return LongUtil.toLong((Object)this.param.get("processId"));
    }

    protected Long getAudittrailId() {
        return LongUtil.toLong((Object)this.param.get("audittrailId"));
    }

    protected Long getReportId() {
        return LongUtil.toLong((Object)this.param.get("reportId"));
    }

    protected String getEntityNumber() {
        return this.param.get("entityNumber").toString();
    }

    protected String getYearNumber() {
        return this.param.get("yearNumber").toString();
    }

    protected String getScenarioNumber() {
        return this.param.get("scenarioNmber").toString();
    }

    protected String getCurrencyNumber() {
        return this.param.get("currencyNumber").toString();
    }

    protected String getPeriodNumber() {
        return this.param.get("periodNumber").toString();
    }

    protected Map<String, Object> getExtraDimensions() {
        return (Map)this.param.get("extraDimensions");
    }

    protected ReportTemplate getReportTemplate(TemplateModel model) {
        DimMember dimMember;
        Dimension dimension;
        ReportTemplate doc = new ReportTemplate();
        doc.setId(model.getId());
        doc.setNumber(model.getNumber());
        doc.setTemplateType(model.getTemplateType());
        doc.setName(model.getName());
        doc.setAutoCalculate(model.isAutoCalculate());
        doc.setSaveByDim(model.isSaveByDim());
        doc.setTemplateCatalogName(model.getTemplateCatalog().get("Name").toString());
        doc.setTemplateCatalogId(LongUtil.toLong((Object)model.getTemplateCatalog().getId()));
        ArrayList<Dimension> pageDimension = new ArrayList<Dimension>(16);
        ArrayList<Dimension> filterDimension = new ArrayList<Dimension>(16);
        for (PageDimensionEntry entry : model.getPageDimensionEntries()) {
            dimension = new Dimension();
            dimension.setNumber(entry.getDimension().getNumber());
            dimension.setName(entry.getDimension().getName());
            dimension.setDseq(entry.getSeq());
            dimension.setId(entry.getDimension().getId());
            for (Member member : entry.getMembers()) {
                dimMember = new DimMember();
                dimMember.setNumber(member.getNumber());
                dimMember.setScope(member.getScope());
                dimMember.setName(member.getName());
                dimMember.setId(member.getId());
                dimMember.setDimensionId(dimension.getId());
                dimension.addMember(dimMember);
            }
            pageDimension.add(dimension);
        }
        doc.setPagedimension(pageDimension);
        for (PageDimensionEntry entry : model.getFilterDimensionEntries()) {
            dimension = new Dimension();
            dimension.setNumber(entry.getDimension().getNumber());
            dimension.setName(entry.getDimension().getName());
            dimension.setDseq(entry.getSeq());
            dimension.setId(entry.getDimension().getId());
            for (Member member : entry.getMembers()) {
                dimMember = new DimMember();
                dimMember.setNumber(member.getNumber());
                dimMember.setScope(member.getScope());
                dimMember.setName(member.getName());
                dimMember.setId(member.getId());
                dimMember.setDimensionId(dimension.getId());
                dimension.addMember(dimMember);
            }
            filterDimension.add(dimension);
        }
        doc.setFilterDimension(filterDimension);
        return doc;
    }

    protected void initSpreadFilter(SpreadManager spm, TemplateModel template) {
        if (spm.getFilter() == null) {
            String entityNumber;
            ViewPointDimDomain view = new ViewPointDimDomain();
            PageDimDomain page = new PageDimDomain();
            FilterDimDomain filter = new FilterDimDomain();
            IDimension dim = null;
            IDimMember member = null;
            ReportDataSelectScheme rdss = ReportDataSchemeUtil.getReportDataSelectScheme(new SchemeContext(this.getModelId().longValue(), (Object)this.getTemplateId()), "1");
            ReportDataSelectScheme.filterByTemplate(template, rdss);
            Map details = new HashMap();
            List<AbstractScheme> selSchemes = rdss.getRDataSelectSchemes().get("all0310");
            if (null != selSchemes && selSchemes.size() > 0) {
                AbstractScheme scheme = selSchemes.get(0);
                details = scheme.getSchemeDetails();
            }
            for (ViewPointDimensionEntry v : template.getViewPointDimensionEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                member = ObjectConvertUtils.toDimMember(v.getMember(), dim);
                member.setId(v.getMember().getId());
                dim.addMember(member);
                view.addDimension(dim);
            }
            for (ViewPointDimensionEntry v : template.getPageDimensionEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                entityNumber = v.getDimension().getMemberEntityNumber();
                if (v.getMembers().isEmpty() && "bcm_entitymembertree".equals(entityNumber)) {
                    member = this.queryMemberById(entityNumber, this.getEntityId(), dim);
                } else {
                    member = this.initDimMembersFromExcelParam(dim, entityNumber);
                    if (member == null) {
                        if (details.containsKey(dim.getNumber())) {
                            DynamicObject membDefault = (DynamicObject)details.get(dim.getNumber());
                            member = new kd.fi.bcm.spread.model.DimMember(membDefault.getString("name"), membDefault.getString("number"), "", dim);
                        } else {
                            Member m = (Member)v.getMembers().get(0);
                            Object[] obj = this.getMember(m, dim);
                            member = (IDimMember)obj[0];
                        }
                    }
                }
                dim.addMember(member);
                page.addDimension(dim);
            }
            for (FilterDimensionEntry f : template.getFilterDimensionEntries()) {
                dim = ObjectConvertUtils.toIDimension(f.getDimension());
                member = this.initDimMembersFromExcelParam(dim, entityNumber = f.getDimension().getMemberEntityNumber());
                if (member == null) {
                    Object[] obj = this.getMember((Member)f.getMembers().get(0), dim);
                    member = (IDimMember)obj[0];
                    member.setId(((Long)obj[1]).longValue());
                }
                dim.addMember(member);
                filter.addDimension(dim);
            }
            spm.setFilter(new FilterView(view, page, filter));
        }
        for (IDimension d : spm.getFilter().getFilterDomain().getDimensions()) {
            spm.getFilter().changeFilterDim(d, spm);
        }
    }

    protected IDimMember initDimMembersFromExcelParam(IDimension dim, String entityNumber) {
        IDimMember member = null;
        switch (entityNumber) {
            case "bcm_processmembertree": {
                member = this.queryMemberById(entityNumber, this.getProcessId(), dim);
                break;
            }
            case "bcm_audittrialmembertree": {
                if (0L == this.getAudittrailId()) break;
                member = this.queryMemberById(entityNumber, this.getAudittrailId(), dim);
                break;
            }
            case "bcm_scenemembertree": {
                member = this.queryMemberById(entityNumber, this.getScenarioId(), dim);
                break;
            }
            case "bcm_fymembertree": {
                member = this.queryMemberById(entityNumber, this.getYearId(), dim);
                break;
            }
            case "bcm_periodmembertree": {
                member = this.queryMemberById(entityNumber, this.getPeriodId(), dim);
                break;
            }
            case "bcm_currencymembertree": {
                member = this.queryMemberById(entityNumber, this.getCurrencyId(), dim);
                break;
            }
            default: {
                Map dimMemObj;
                Map<String, Object> extraDimensions = this.getExtraDimensions();
                if (extraDimensions == null || extraDimensions.size() <= 0 || (dimMemObj = (Map)extraDimensions.get(dim.getNumber())) == null) break;
                member = this.queryMemberById(entityNumber, (Long)dimMemObj.get("Id"), dim);
            }
        }
        return member;
    }

    protected IDimMember queryMemberById(String entityNumber, long dimId, IDimension dim) {
        long modelId = this.getModelId();
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter("id", "=", (Object)dimId);
        DynamicObject dobject = QueryServiceHelper.queryOne((String)entityNumber, (String)"id,number,name", (QFilter[])new QFilter[]{qf, qf2});
        Member m = new Member();
        m.setName(dobject.getString("name"));
        m.setNumber(dobject.getString("number"));
        IDimMember member = ObjectConvertUtils.toDimMember(m, dim);
        member.setId(dobject.getLong("id"));
        return member;
    }

    protected Object[] getMember(Member m, IDimension dim) {
        int scope = m.getScope();
        long memberid = m.getId();
        kd.fi.bcm.spread.model.DimMember member = null;
        if (scope == RangeEnum.VALUE_20.getValue() || scope == RangeEnum.VALUE_40.getValue()) {
            QFilter qf = new QFilter("parent", "=", (Object)memberid);
            DynamicObject dot = QueryServiceHelper.queryOne((String)m.getDataEntityNumber(), (String)"id,name,number,simpleName", (QFilter[])new QFilter[]{qf});
            member = new kd.fi.bcm.spread.model.DimMember(dot.getString("name"), dot.getString("number"), dot.getString("name"), dim);
            return new Object[]{member, dot.getLong("id")};
        }
        if (scope == RangeEnum.VALUE_60.getValue()) {
            QFilter qf = new QFilter("id", "=", (Object)memberid);
            DynamicObject dot = QueryServiceHelper.queryOne((String)m.getDataEntityNumber(), (String)"parent", (QFilter[])new QFilter[]{qf});
            long parentid = dot.getLong("parent");
            QFilter qf1 = new QFilter("parent", "=", (Object)parentid);
            QFilter qf2 = new QFilter("id", "!=", (Object)memberid);
            dot = QueryServiceHelper.queryOne((String)m.getDataEntityNumber(), (String)"id,name,number,simpleName", (QFilter[])new QFilter[]{qf1, qf2});
            member = new kd.fi.bcm.spread.model.DimMember(dot.getString("name"), dot.getString("number"), dot.getString("simpleName"), dim);
            return new Object[]{member, dot.getLong("id")};
        }
        if (scope == RangeEnum.VALUE_90.getValue() || scope == RangeEnum.VALUE_110.getValue()) {
            String pLongNum = BusinessDataServiceHelper.loadSingle((Object)m.getId(), (String)m.getDataEntityNumber(), (String)"longnumber").getString("longnumber");
            DynamicObject dot = QueryServiceHelper.queryOne((String)m.getDataEntityNumber(), (String)"id,name,number,simpleName", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(pLongNum + '!' + "%")).or("longnumber", "=", (Object)pLongNum), new QFilter("model", "=", (Object)this.getModelId()), new QFilter("isleaf", "=", (Object)(scope == RangeEnum.VALUE_90.getValue() ? 1 : 0))});
            ArrayList items = new ArrayList();
            new MembRangeItem(m.getDataEntityNumber(), Long.valueOf(m.getId()), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, (Object)this.getModelId()).matchItems(c -> items.add(c.number));
            member = new kd.fi.bcm.spread.model.DimMember(dot.getString("name"), dot.getString("number"), dot.getString("simpleName"), dim);
            return new Object[]{member, dot.getLong("id")};
        }
        member = new kd.fi.bcm.spread.model.DimMember(m.getName(), m.getNumber(), m.getName(), dim);
        return new Object[]{member, memberid};
    }
}

