/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.fi.bcm.business.model.excel.ApiResponseModel;
import kd.fi.bcm.business.serviceHelper.ModelPermHelper;
import kd.fi.bcm.common.CustOperationContexts;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.excel.ExcelConstant;
import kd.fi.bcm.formplugin.excel.ExcelDispatcher;
import kd.fi.bcm.formplugin.excel.ExcelSerivce;

public class ExcelPlugin
extends AbstractBillWebApiPlugin {
    private static final String PARAM_MODELID = "ModelId";

    public ApiResult doCustomService(Map<String, Object> params) {
        Object backData;
        ApiResult result = new ApiResult();
        ApiResponseModel response = new ApiResponseModel();
        try {
            this.checkLicense(params);
            this.checkModel(params);
            CustOperationContexts.setCustFormIdForEPM();
            backData = ExcelDispatcher.getInstance().invoke(params);
            backData = this.compress(params, backData);
        }
        catch (KDBizException e) {
            response.setSuccess(false);
            backData = e.getMessage();
        }
        catch (Exception e) {
            response.setSuccess(false);
            backData = "errorMessage:" + ThrowableHelper.toString((Exception)e);
        }
        response.setBackData(backData);
        result.setData((Object)response);
        return result;
    }

    private void checkLicense(Map<String, Object> params) {
        ExcelSerivce service;
        LicenseCheckResult checkResult;
        Boolean result;
        String methodName = (String)params.get("method");
        if ("checkLicense".equalsIgnoreCase(methodName) || "checkDataSetLicense".equalsIgnoreCase(methodName)) {
            return;
        }
        String appId = ApplicationTypeEnum.CM.getOIndex();
        if (params.containsKey("AppId")) {
            appId = params.get("AppId").toString();
        }
        if (Boolean.FALSE.equals(result = (checkResult = (service = new ExcelSerivce()).checkLicense(appId)).getHasLicense())) {
            throw new KDBizException(checkResult.getMsg());
        }
    }

    private void checkModel(Map<String, Object> params) {
        Object param;
        String appId = ApplicationTypeEnum.CM.getOIndex();
        if (params.containsKey("AppId")) {
            appId = params.get("AppId").toString();
        }
        if (null == (param = params.get("param"))) {
            return;
        }
        if (ApplicationTypeEnum.CM.getOIndex().equals(appId) || ApplicationTypeEnum.RPT.getOIndex().equals(appId)) {
            this.checkCMModelPerm(params);
        }
    }

    private void checkCMModelPerm(Map<String, Object> params) {
        String methodName = (String)params.get("method");
        Object param = params.get("param");
        if (ExcelConstant.CHECK_CM_MODEL_WHITELIST.contains(methodName)) {
            return;
        }
        long modelId = 0L;
        if (methodName.equals("getScenePeriodMap") || methodName.equals("getUserInfo") || methodName.equals("getDocumentFileEntity")) {
            modelId = LongUtil.toLong((Object)param);
        } else {
            Map map = (Map)param;
            if (map.containsKey("modelId")) {
                modelId = LongUtil.toLong(map.get("modelId"));
            } else if (map.containsKey(PARAM_MODELID)) {
                modelId = LongUtil.toLong(map.get(PARAM_MODELID));
            } else if (map.containsKey("modelid")) {
                modelId = LongUtil.toLong(map.get("modelid"));
            } else if (map.containsKey("Cubecatalog")) {
                modelId = MemberReader.findModelIdByNum((String)map.get("Cubecatalog").toString());
            } else if (map.containsKey("modelNumber")) {
                modelId = MemberReader.findModelIdByNum((String)map.get("modelNumber").toString());
            }
        }
        if (modelId > 0L && !ModelPermHelper.hasModelPerm((long)modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u8be5\u4f53\u7cfb\u6743\u9650\u3002", (String)"ExcelPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Object compress(Map<String, Object> params, Object backData) {
        Boolean isGzip;
        if (params.containsKey("isGzip") && null != backData && Boolean.TRUE.equals(isGzip = (Boolean)params.get("isGzip"))) {
            String jsonData = JSON.toJSONStringWithDateFormat((Object)backData, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            backData = ObjectSerialUtil.compress4GZip((String)jsonData);
        }
        return backData;
    }
}

