/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.service.bo.Version;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.bizstatus.BizStatusServer;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.bizstatus.model.StatusResult;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.service.DataTrace2FromService;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.linkquery.LinkFormulaUtil;
import kd.fi.bcm.business.member.MemberListUtil;
import kd.fi.bcm.business.mergecontrol.MergeCondition;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.olap.OlapSaveBuilder;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.UpgradeStatusUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKReportType;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.excel.ExcelFlowControlTypes;
import kd.fi.bcm.formplugin.excel.action.DataTraceApiHelper;
import kd.fi.bcm.formplugin.excel.action.ExcelAdHocSolutionAction;
import kd.fi.bcm.formplugin.excel.action.ExcelAdjustOffsetAction;
import kd.fi.bcm.formplugin.excel.action.ExcelDataIntegrationAction;
import kd.fi.bcm.formplugin.excel.action.ExcelDimensionManagerAction;
import kd.fi.bcm.formplugin.excel.action.ExcelFormulaDataCollectAction;
import kd.fi.bcm.formplugin.excel.action.ExcelIntegrationAction;
import kd.fi.bcm.formplugin.excel.action.ExcelLoadAction;
import kd.fi.bcm.formplugin.excel.action.ExcelSaveAction;
import kd.fi.bcm.formplugin.excel.action.ExcelTemplateAction;
import kd.fi.bcm.formplugin.excel.action.ExcelVersionAction;
import kd.fi.bcm.formplugin.excel.action.ExcelYearCarryAction;
import kd.fi.bcm.formplugin.excel.dto.AbstractDimMember;
import kd.fi.bcm.formplugin.excel.dto.AbstractDimProperty;
import kd.fi.bcm.formplugin.excel.dto.AbstractDimension;
import kd.fi.bcm.formplugin.excel.dto.CalculateMessage;
import kd.fi.bcm.formplugin.excel.dto.CslScheme;
import kd.fi.bcm.formplugin.excel.dto.DataCollectTemplate;
import kd.fi.bcm.formplugin.excel.dto.DataTraceResult;
import kd.fi.bcm.formplugin.excel.dto.DimMember;
import kd.fi.bcm.formplugin.excel.dto.DimMetaField;
import kd.fi.bcm.formplugin.excel.dto.DimProperty;
import kd.fi.bcm.formplugin.excel.dto.Dimension;
import kd.fi.bcm.formplugin.excel.dto.EnumValue;
import kd.fi.bcm.formplugin.excel.dto.EpmClientVersion;
import kd.fi.bcm.formplugin.excel.dto.ExcelApiOutput;
import kd.fi.bcm.formplugin.excel.dto.ExtendMember;
import kd.fi.bcm.formplugin.excel.dto.ExtendModel;
import kd.fi.bcm.formplugin.excel.dto.ISSchemesData;
import kd.fi.bcm.formplugin.excel.dto.ISSchemesResult;
import kd.fi.bcm.formplugin.excel.dto.IntegrationObject;
import kd.fi.bcm.formplugin.excel.dto.IntegrationProperty;
import kd.fi.bcm.formplugin.excel.dto.LinkQueryParam;
import kd.fi.bcm.formplugin.excel.dto.MergeStructModel;
import kd.fi.bcm.formplugin.excel.dto.OrgBizChangeEffEnum;
import kd.fi.bcm.formplugin.excel.dto.OrgBizChangeRecord;
import kd.fi.bcm.formplugin.excel.dto.OrgNameChangeRecord;
import kd.fi.bcm.formplugin.excel.dto.PeriodMemberEx;
import kd.fi.bcm.formplugin.excel.dto.ReportTemplate;
import kd.fi.bcm.formplugin.excel.dto.TemplateCatalog;
import kd.fi.bcm.formplugin.excel.dto.TemplateDetail;
import kd.fi.bcm.formplugin.excel.dto.UserInfo;
import kd.fi.bcm.formplugin.excel.dto.YearCarryTemplate;
import kd.fi.bcm.formplugin.excel.dto.adhoc.AdHocSolution;
import kd.fi.bcm.formplugin.excel.dto.adhoc.AdHocSolutionDimMember;
import kd.fi.bcm.formplugin.excel.dto.adjust.AdjustBussinessTypeModel;
import kd.fi.bcm.formplugin.excel.dto.adjust.AdjustLogModel;
import kd.fi.bcm.formplugin.excel.dto.adjust.AdjustOffsetModel;
import kd.fi.bcm.formplugin.excel.dto.fidm.PermissionClass;
import kd.fi.bcm.formplugin.form.DocumentFileEntityService;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang3.BooleanUtils;

public class ExcelSerivce {
    private static Log log = LogFactory.getLog(ExcelSerivce.class);

    public Map<String, String> getEpmServerVersion() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("EpmServerVersion", "1.1.1");
        map.put("EpmClientVersion", "1.6.1");
        map.put("EpmApiVersionDate", "2024-06-05");
        return map;
    }

    public Object getModelList(Map<String, Object> param) {
        if (param == null) {
            return null;
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        QFilter qUser = new QFilter("user.id", "=", (Object)userId);
        Set ids = BcmFunPermissionHelper.getAllHasPermModel((QFilter[])new QFilter[]{qUser});
        String reportType = String.valueOf(param.get("reporttype"));
        ApplicationTypeEnum applicationType = ApplicationTypeEnum.getEnumByIndex((String)reportType);
        ids.addAll(BcmFunPermissionHelper.getRoleModel((long)userId, (String)"bcm_model", (ApplicationTypeEnum)applicationType, (String)"bcm_report_list", (String)"47150e89000000ac"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        QFilter upgradedid = new QFilter("id", "in", (Object)UpgradeStatusUtil.getUpgradesModelIds());
        qFilters.add(upgradedid);
        QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
        QFilter haspermid = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getEffectiveByPermModel((String)"bcm_report_list", (ApplicationTypeEnum)ApplicationTypeEnum.CM));
        qFilters.add(superid.or(new QFilter("id", "in", (Object)ids.toArray())).or(haspermid));
        if (ApplicationTypeEnum.CM.getOIndex().compareTo(reportType) == 0) {
            qFilters.add(new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.CM.getOIndex()));
        } else {
            QFilter qcf = BcmFunPermissionHelper.getRptAdminModelQFilter();
            qcf.or(new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.CM.getOIndex()));
            qFilters.add(qcf);
        }
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        if (param.containsKey("modifytime")) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                qFilters.add(new QFilter("modifytime", ">=", (Object)format.parse(param.get("modifytime").toString())));
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
        }
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_model", (String)"id,name,number,shownumber,reporttype", (QFilter[])qFilters.toArray(new QFilter[0]));
        HashMap<String, Object> data = null;
        ArrayList modelNameList = new ArrayList(16);
        for (DynamicObject dy : dys) {
            data = new HashMap<String, Object>(8);
            data.put("Id", dy.getString("id"));
            data.put("Name", dy.getString("name"));
            data.put("Number", dy.getString("number"));
            data.put("ShowNumber", dy.getString("shownumber"));
            data.put("ReportType", dy.getString("reporttype"));
            data.put("IsAdmin", MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(dy.getLong("id"))));
            modelNameList.add(data);
        }
        return modelNameList;
    }

    public Object saveReport(Map<String, Object> param) {
        return new ExcelSaveAction(param).execute();
    }

    public Object getReportTabInfo(Map<String, Object> param) {
        return new ExcelLoadAction(param).execute();
    }

    public Map<String, Object> getReportDetailInfo(Map<String, Object> param) {
        return new ExcelLoadAction(param).getReportDetailInfo();
    }

    public Map<String, Object> getReportFormula(Map<String, Object> param) {
        return new ExcelLoadAction(param).getReportFormulaInfo();
    }

    public Map<String, List<String>> getScenePeriodMap(Long modelid) {
        DynamicObject[] dycol;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(16);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelid);
        for (DynamicObject dy : dycol = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"number, sceneperiod.number", (QFilter[])qfBuilder.toArray())) {
            if (map.get(dy.getString("number")) == null) {
                map.put(dy.getString("number"), new ArrayList());
            }
            if (dy.getDynamicObjectCollection("sceneperiod") == null) continue;
            dy.getDynamicObjectCollection("sceneperiod").forEach(e -> {
                if (e.getDynamicObject("fbasedataid") != null) {
                    ((List)map.get(dy.getString("number"))).add(e.getDynamicObject("fbasedataid").getString("number"));
                }
            });
        }
        return map;
    }

    public List<CslScheme> getCslSchemeByModelId(Map<String, Object> param) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long modelId = LongUtil.toLong((Object)param.get("modelId"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        qFilters.add(new QFilter("modifytime", ">", (Object)format.parse(param.get("modifyTime").toString())));
        DynamicObjectCollection dimData = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,number,name,parent_id,isleaf,level,modifytime,description,effectivestatus,islegalorgview,isenable,nodetype,longnumber", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc");
        DynamicObjectCollection filterSchemes = new DynamicObjectCollection();
        for (DynamicObject dyobj : dimData) {
            dyobj.refreshDataEntityState();
            filterSchemes.add((Object)dyobj);
        }
        CslSchemeServiceHelper.filterByPerm((DynamicObjectCollection)filterSchemes, (Long)modelId);
        ArrayList<CslScheme> schemes = new ArrayList<CslScheme>(filterSchemes.size());
        for (DynamicObject row : filterSchemes) {
            CslScheme scheme = new CslScheme();
            scheme.setId(row.getLong("id"));
            scheme.setNumber(row.getString("number"));
            scheme.setName(row.getString("name"));
            scheme.setParentId(row.getLong("parent_id"));
            scheme.setLeaf(row.getBoolean("isleaf"));
            scheme.setLevel(row.getInt("level"));
            scheme.setModifyTime(row.getDate("modifytime"));
            scheme.setDescription(row.getString("description"));
            scheme.setEffectiveStatus(row.getBoolean("effectivestatus"));
            scheme.setLegalOrgView(row.getBoolean("islegalorgview"));
            scheme.setEnable(row.getBoolean("isenable"));
            scheme.setNodeType(row.getInt("nodetype"));
            scheme.setLongNumber(row.getString("longnumber"));
            schemes.add(scheme);
        }
        return schemes;
    }

    public Map<String, Object> queryData(Map<String, Object> param) {
        SQLBuilder sqlBuilder = new SQLBuilder(param.get("Cubecatalog").toString());
        List selectors = (List)param.get("Selector");
        List filters = (List)param.get("Filter");
        for (int i = 0; i < filters.size(); ++i) {
            String key = ((Map)filters.get(i)).get("Key").toString();
            List values = (List)((Map)filters.get(i)).get("Values");
            sqlBuilder.addFilter(key, values.toArray(new String[0]));
        }
        sqlBuilder.addSelectField(selectors.toArray(new String[0]));
        ArrayList<String> measures = new ArrayList<String>(1);
        if (param.containsKey("Measures")) {
            Long modelId = LongUtil.toLong((Object)param.get("ModelId"));
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            List measuresParams = (List)param.get("Measures");
            if (!measuresParams.isEmpty()) {
                Integer cursor = 0;
                for (FacTabFieldDefEnum measure : FacTabFieldDefEnum.values()) {
                    if (measuresParams.contains(cursor) && OlapCommandUtil.checkMeasure((String)modelNumber, (String)measure.getField())) {
                        measures.add(measure.getField());
                    }
                    Integer n = cursor;
                    Integer n2 = cursor = Integer.valueOf(cursor + 1);
                }
            }
        } else {
            measures.add(FacTabFieldDefEnum.FIELD_MONEY.getField());
        }
        if (measures.size() == 0) {
            return new HashMap<String, Object>(0);
        }
        sqlBuilder.addMeasures(measures.toArray(new String[0]));
        MDResultSet set = OlapServiceHelper.queryData((SQLBuilder)sqlBuilder);
        return set.asMap();
    }

    public String queryData1() {
        return "PRJ-00397626";
    }

    public List<AbstractDimension> getDimensionByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            qFilters.add(new QFilter("modifytime", ">", (Object)format.parse(param.get("modifyTime").toString())));
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        DynamicObjectCollection dimData = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,number,shortnumber,dseq,modifytime,issysdimension", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<AbstractDimension> dimensions = new ArrayList<AbstractDimension>(dimData.size());
        for (DynamicObject dimRow : dimData) {
            Dimension dim = new Dimension();
            dim.setId(dimRow.getLong("id"));
            dim.setNumber(dimRow.getString("number"));
            dim.setName(dimRow.getString("name"));
            dim.setShortNumber(dimRow.getString("shortnumber"));
            dim.setDseq(dimRow.getInt("dseq"));
            dim.setModifyTime(dimRow.getDate("modifytime"));
            dim.setSysDimension(dimRow.getBoolean("issysdimension"));
            dimensions.add(dim);
        }
        return dimensions;
    }

    public List<AbstractDimMember> getMemberByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        if (param.containsKey("dimensionId")) {
            qFilters.add(new QFilter("id", "=", param.get("dimensionId")));
        }
        DynamicObjectCollection dimDatas = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_dimension", (String)"id,membermodel,issysdimension", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(dimDatas.size());
        ArrayList<HashMap<String, Object>> batchdatas = new ArrayList<HashMap<String, Object>>(dimDatas.size());
        int size = param.size() + 3;
        for (DynamicObject dimData : dimDatas) {
            HashMap<String, Object> rowdata = new HashMap<String, Object>(size);
            rowdata.putAll(param);
            rowdata.put("membermodel", dimData.getString("membermodel"));
            rowdata.put("issysdimension", dimData.getBoolean("issysdimension"));
            rowdata.put("dimId", dimData.getLong("id"));
            if (this.getMemberCountByModelId(rowdata) > 5000) {
                batchdatas.add(rowdata);
                continue;
            }
            datas.add(rowdata);
        }
        ArrayList<AbstractDimMember> members = new ArrayList<AbstractDimMember>();
        if (batchdatas.size() > 0) {
            members.addAll(BatchProcessHelper.batchHandle(batchdatas, (int)1, (int)1, this::batchDimMembers, null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.IO));
        }
        if (datas.size() > 0) {
            members.addAll(this.batchDimMembers(datas));
        }
        return members;
    }

    private int getMemberCountByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qMemberFilters = new ArrayList<QFilter>();
        qMemberFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        try {
            if (param.containsKey("modifyTime")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                qMemberFilters.add(new QFilter("modifytime", ">", (Object)format.parse(param.get("modifyTime").toString())));
            }
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        if (!((Boolean)param.get("issysdimension")).booleanValue()) {
            qMemberFilters.add(new QFilter("dimension_id", "=", param.get("dimId")));
        }
        String memberModel = param.get("membermodel").toString();
        return ORM.create().count(this.getClass().getName(), memberModel, "id", qMemberFilters.toArray(new QFilter[0]));
    }

    private List<AbstractDimMember> batchDimMembers(List<Map<String, Object>> rowdatas) {
        ArrayList<AbstractDimMember> members = new ArrayList<AbstractDimMember>(rowdatas.size());
        for (Map<String, Object> rowdata : rowdatas) {
            String memberModel = rowdata.get("membermodel").toString();
            long dimensionId = (Long)rowdata.get("dimId");
            ArrayList<QFilter> qMemberFilters = new ArrayList<QFilter>();
            qMemberFilters.add(new QFilter("model_id", "=", rowdata.get("modelId")));
            try {
                if (rowdata.containsKey("modifyTime")) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    qMemberFilters.add(new QFilter("modifytime", ">", (Object)format.parse(rowdata.get("modifyTime").toString())));
                }
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
            boolean hasDataType = false;
            String selectFields = "id,number,name,isleaf,level,parent_id,modifytime,dpropertyid1.id,longnumber,dseq,storagetype";
            if (!((Boolean)rowdata.get("issysdimension")).booleanValue()) {
                qMemberFilters.add(new QFilter("dimension_id", "=", (Object)dimensionId));
                hasDataType = true;
                selectFields = selectFields + ",datatype,enumitem";
            }
            if (memberModel.equals("bcm_entitymembertree")) {
                selectFields = "id,number,name,isleaf,level,parent_id,modifytime,dpropertyid1.id,longnumber,dseq,cslscheme.id,currency.number,storagetype";
            }
            if (!memberModel.equals("bcm_currencymembertree") && !memberModel.equals("bcm_processmembertree")) {
                selectFields = selectFields + ",copyfrom.id";
            }
            if (memberModel.equals("bcm_scenemembertree") || memberModel.equals("bcm_accountmembertree") || memberModel.equals("bcm_changetypemembertree")) {
                hasDataType = true;
                selectFields = selectFields + ",datatype,enumitem";
            }
            if (memberModel.equals("bcm_datasortmembertree")) {
                hasDataType = true;
                selectFields = selectFields + ",datatype";
            }
            if (memberModel.equals("bcm_audittrialmembertree")) {
                selectFields = selectFields + ",datasource";
            }
            DynamicObjectCollection memberDatas = QueryServiceHelper.query((String)memberModel, (String)selectFields, (QFilter[])qMemberFilters.toArray(new QFilter[0]), (String)"id desc");
            this.getAbstractDimMembers(members, memberModel, memberDatas, hasDataType, dimensionId);
        }
        return members;
    }

    private void getAbstractDimMembers(List<AbstractDimMember> members, String memberModel, DynamicObjectCollection memberDatas, boolean hasDataType, long dimensionId) {
        for (DynamicObject memberRow : memberDatas) {
            DimMember member = new DimMember();
            member.setId(memberRow.getLong("id"));
            member.setNumber(memberRow.getString("number"));
            member.setName(memberRow.getString("name"));
            member.setIsLeaf(memberRow.getBoolean("isleaf"));
            member.setLevel(memberRow.getInt("level"));
            member.setParentId(memberRow.getLong("parent_id"));
            member.setModifyTime(memberRow.getDate("modifytime"));
            member.setPropertyId(memberRow.getLong("dpropertyid1.id"));
            member.setLongNumber(memberRow.getString("longnumber"));
            member.setStorageType(memberRow.getInt("storagetype"));
            member.setDseq(memberRow.getLong("dseq"));
            member.setDimensionId(dimensionId);
            if (memberModel.equals("bcm_entitymembertree")) {
                member.setSchemeId(memberRow.getLong("cslscheme.id"));
                member.setCurrencyNumber(memberRow.getString("currency.number"));
            }
            if (!memberModel.equals("bcm_currencymembertree") && !memberModel.equals("bcm_processmembertree")) {
                member.setCopyFrom(memberRow.getLong("copyfrom.id"));
            }
            if (hasDataType) {
                String dataType;
                if (!memberModel.equals("bcm_datasortmembertree")) {
                    member.setEnumItemId(memberRow.getLong("enumitem"));
                }
                if (StringUtils.isEmpty((String)(dataType = memberRow.getString("datatype")))) {
                    member.setDataType("0");
                } else {
                    member.setDataType(dataType);
                }
            } else {
                member.setDataType("0");
            }
            if (memberModel.equals("bcm_audittrialmembertree") && !StringUtils.isEmpty((String)memberRow.getString("datasource"))) {
                member.setAtSourceFrom(memberRow.getString("datasource"));
            }
            members.add(member);
        }
    }

    public List<AbstractDimProperty> getPropertyByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        if (param.containsKey("dimensionId")) {
            qFilters.add(new QFilter("dimension_id", "=", param.get("dimensionId")));
        }
        HashMap propertySorts = new HashMap(6);
        DynamicObjectCollection roots = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id,dimension_id", (QFilter[])qFilters.toArray(new QFilter[0]));
        Map<Long, List<DynamicObject>> dimProperties = roots.stream().collect(Collectors.groupingBy(r -> r.getLong("dimension_id")));
        dimProperties.forEach((k, v) -> {
            int i = 1;
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(6);
            for (DynamicObject dy : v) {
                map.put(dy.getLong("id"), i);
                ++i;
            }
            propertySorts.put(k, map);
        });
        DynamicObjectCollection propertyData = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,name,parentid.id,level,longnumber,dseq,dimension_id,propertyid", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc");
        ArrayList<AbstractDimProperty> properties = new ArrayList<AbstractDimProperty>(propertyData.size());
        for (DynamicObject propertyRow : propertyData) {
            Integer dseq;
            DimProperty property = new DimProperty();
            property.setId(propertyRow.getLong("id"));
            property.setNumber(propertyRow.getString("number"));
            property.setName(propertyRow.getString("name"));
            property.setParentId(propertyRow.getLong("parentid.id"));
            property.setLevel(propertyRow.getInt("level"));
            property.setLongNumber(propertyRow.getString("longnumber"));
            property.setDseq(propertyRow.getLong("dseq"));
            property.setDimensionId(propertyRow.getLong("dimension_id"));
            if (property.getParentId() == 0L && propertySorts.containsKey(property.getDimensionId()) && (dseq = (Integer)((Map)propertySorts.get(property.getDimensionId())).get(propertyRow.getLong("propertyid"))) != null) {
                property.setDseq(dseq.intValue());
            }
            properties.add(property);
        }
        return properties;
    }

    public List<ReportTemplate> getTemplateListByModelId(Map<String, Object> param) {
        return new ArrayList<ReportTemplate>(16);
    }

    public boolean saveOlapData(Map<String, Object> param) {
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        Long modelId = (Long)param.get("ModelId");
        String modelNumber = QueryDimensionServiceHelper.getModelNumber((long)modelId);
        Map dimsInfo = (Map)param.get("DimsInfo");
        if ("EC".equals(dimsInfo.get(PresetConstant.CURRENCY_DIM))) {
            String entityMembers = (String)dimsInfo.get(PresetConstant.ENTITY_DIM);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
            qFilters.add(new QFilter("model_id", "=", param.get("ModelId")));
            qFilters.add(new QFilter("number", "=", (Object)entityMembers));
            DynamicObject orgCurrency = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"currency.number as currency_number", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (orgCurrency != null && orgCurrency.getString("currency_number") != null) {
                param.put(PresetConstant.CURRENCY_DIM, orgCurrency.getString("currency_number"));
            }
        }
        ArrayList dimKeyList = new ArrayList(dimsInfo.size());
        ArrayList memeberValueList = new ArrayList(dimsInfo.size());
        for (Map.Entry entry : dimsInfo.entrySet()) {
            dimKeyList.add(entry.getKey());
            memeberValueList.add(entry.getValue());
        }
        String[] dimKey = dimKeyList.toArray(new String[dimKeyList.size()]);
        info.setDimensions(dimKey);
        CellSet cellSets = new CellSet(dimKey, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        cellSets.setFromQuery(false);
        cellSets.set(memeberValueList.toArray(new String[memeberValueList.size()]), FacTabFieldDefEnum.FIELD_MONEY.getField(), param.get("Value"));
        OlapCommandUtil.addSourceMeasure((String)modelNumber, (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.E1);
        OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSets, (String)modelNumber);
        String action = ResManager.loadKDString((String)"\u63d0\u4ea4\u6570\u636e", (String)"ExcelSerivce_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String opDescriotion = String.format(ResManager.loadKDString((String)"SV\u516c\u5f0f%1$s%2$s", (String)"ExcelSerivce_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), action, ResultStatusEnum.SUCCESS.getName());
        OperationLogUtil.writeOperationLog((String)action, (String)opDescriotion, (Long)modelId, (String)"");
        return true;
    }

    public Set<String> currencyConvert(Map<String, Object> param) {
        HashSet<String> errorMsgs = new HashSet<String>(16);
        Long modelid = LongUtil.toLong((Object)param.get("ModelId"));
        boolean isCheckPeriod = ConfigServiceHelper.getBoolParam((Long)modelid, (String)"CM012");
        List entityPathMap = (List)param.get("EntityInfo");
        ArrayList opDescriptions = new ArrayList(2);
        String operateLogResult = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"ExcelSerivce_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String successOperateLogResult = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ExcelSerivce_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String opName = ResManager.loadKDString((String)"\u62a5\u8868\u6298\u7b97", (String)"ExcelSerivce_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        entityPathMap.forEach(entityMap -> {
            Pair model = Pair.onePair((Object)LongUtil.toLong(param.get("ModelId")), (Object)((String)param.get("ModelNumber")));
            Pair entity = Pair.onePair((Object)LongUtil.toLong(entityMap.get("EntityMemberId")), (Object)((String)entityMap.get("EntityMemberNumber")));
            Pair fy = Pair.onePair((Object)LongUtil.toLong(param.get("YearMemberId")), (Object)((String)param.get("YearMemberNumber")));
            Pair period = Pair.onePair((Object)LongUtil.toLong(param.get("PeriodMemberId")), (Object)((String)param.get("PeriodMemberNumber")));
            Pair scene = Pair.onePair((Object)LongUtil.toLong(param.get("ScenarioMemberId")), (Object)((String)param.get("ScenarioMemberNumber")));
            if (isCheckPeriod && !PeriodSettingHelper.checkPeriodStatus((long)((Long)model.p1), (String)((String)entity.p2), (long)((Long)scene.p1), (long)((Long)fy.p1), (long)((Long)period.p1), (String)"datastatus")) {
                String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExcelSerivce_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                errorMsgs.add(errMsg);
                OperationLogUtil.writeOperationLog((String)opName, (String)((String)entity.p2 + MemberReader.findEntityMemberByNum((String)((String)model.p2), (String)((String)entity.p2)).getName() + " " + operateLogResult + ":" + errMsg), (Long)modelid, (String)"bcm_mergecontrollist");
                return;
            }
            List cvtPaths = new ArrayList<Pair>(10);
            cvtPaths.add(Pair.onePair((Object)LongUtil.toLong(entityMap.get("CurrentCurrencyId")), (Object)((String)entityMap.get("CurrentCurrencyNumber"))));
            cvtPaths.add(Pair.onePair((Object)LongUtil.toLong(entityMap.get("TargetCurrencyId")), (Object)((String)entityMap.get("TargetCurrencyNumber"))));
            cvtPaths = ConvertServiceHelper.getCurrectCvtPath(cvtPaths, (long)((Long)entity.p1), (Long)((Long)fy.p1), (Long)((Long)period.p1));
            if (cvtPaths.size() == 2 && ((String)((Pair)cvtPaths.get((int)0)).p2).equals(((Pair)cvtPaths.get((int)1)).p2)) {
                return;
            }
            Set errMsg = ConvertServiceHelper.convertByPath(cvtPaths, (Pair)model, (Pair)entity, (Pair)fy, (Pair)period, (Pair)scene);
            if (errMsg.size() > 0) {
                opDescriptions.add((String)entity.p2 + MemberReader.findEntityMemberByNum((String)((String)model.p2), (String)((String)entity.p2)).getName() + " " + operateLogResult);
            } else {
                opDescriptions.add((String)entity.p2 + MemberReader.findEntityMemberByNum((String)((String)model.p2), (String)((String)entity.p2)).getName() + " " + successOperateLogResult);
            }
            errorMsgs.addAll(errMsg);
        });
        OperationLogUtil.batchWriteOperationLog((String)opName, opDescriptions, (Long)modelid, (String)"bcm_mergecontrollist");
        return errorMsgs;
    }

    public boolean getTemplateIsAutoConvert(Map<String, Object> param) {
        Long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        Long entityId = LongUtil.toLong((Object)param.get("EntityId"));
        IDNumberTreeNode enode = MemberReader.findEntityMemberById((Long)modelId, (Long)entityId);
        return ExchangeQueryHelper.getAutoConvert((Long)modelId, (Long)LongUtil.toLong((Object)param.get("SceneId")), (Long)LongUtil.toLong((Object)param.get("YearId")), (Long)LongUtil.toLong((Object)param.get("PeriodId")), (SimpleVo)SimpleVo.newOne((IDNumberTreeNode)enode));
    }

    public ExcelApiOutput checkData(Map<String, Object> param) {
        List tempIds = (List)param.get("templateIds");
        Long modelId = LongUtil.toLong((Object)param.get("modelId"));
        Long entityId = LongUtil.toLong((Object)param.get("entityId"));
        Long scenarioId = LongUtil.toLong((Object)param.get("scenarioId"));
        Long yearId = LongUtil.toLong((Object)param.get("yearId"));
        Long periodId = LongUtil.toLong((Object)param.get("periodId"));
        String entityNumber = param.get("entityNumber").toString();
        IDNumberTreeNode enityNode = MemberReader.findEntityMemberById((Long)modelId, (Long)entityId);
        boolean isCheckPeriod = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012");
        if (isCheckPeriod && !PeriodSettingHelper.checkPeriodStatus((long)LongUtil.toLong((Object)param.get("modelId")), (String)entityNumber, (long)LongUtil.toLong((Object)param.get("scenarioId")), (long)LongUtil.toLong((Object)param.get("yearId")), (long)LongUtil.toLong((Object)param.get("periodId")), (String)"datastatus")) {
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExcelSerivce_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return new ExcelApiOutput(false, errMsg);
        }
        McStatus mcStatus = McStatus.getMcStatus((Object)modelId, (Object)entityId, (Object)scenarioId, (Object)yearId, (Object)periodId);
        if (mcStatus.getFlow().isSubmit()) {
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u5e01\u62a5\u8868\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"CheckUpChkReportPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return new ExcelApiOutput(false, errMsg);
        }
        QFilter filter2 = new QFilter("model", "=", (Object)modelId);
        filter2.and(new QFilter("id", "in", (Object)tempIds));
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name", (QFilter[])new QFilter[]{filter2});
        List templateNumbers = templates.stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
        String opName = ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5", (String)"ExcelSerivce_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        ArrayList<String> errorInfo = new ArrayList<String>(16);
        String chkTmpNumber = null;
        try {
            CalContext ctx = new CalContext(param.get("modelNumber").toString(), param.get("entityNumber").toString(), param.get("yearNumber").toString(), param.get("periodNumber").toString(), param.get("scenarioNumber").toString(), param.get("currencyNumber").toString());
            ctx.setProperty("originalOrgId", (Object)entityId);
            ctx.setProperty("reporttype", (Object)CHKReportType.NORMALREPORT.getSign());
            if (templates.size() == 1) {
                chkTmpNumber = ((DynamicObject)templates.get(0)).getString("number");
                ctx.setProperty("temp", (Object)chkTmpNumber);
                ChkCheckServiceHelper.check((ICalContext)ctx);
            } else if (templates.size() > 1) {
                chkTmpNumber = String.join((CharSequence)",", templateNumbers);
                DynamicObjectCollection reportlist = new DynamicObjectCollection();
                templates.forEach(t -> {
                    DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportentity");
                    dyn.set("entity", (Object)entityId);
                    dyn.set("template", t);
                    reportlist.add((Object)dyn);
                });
                ctx.setProperty("selecttemplatelist", (Object)reportlist);
                ctx.setProperty("batchChkTmp", (Object)chkTmpNumber);
                ctx.setProperty("clickCheck", (Object)true);
                ChkCheckServiceHelper.check((ICalContext)ctx, (boolean)true);
            }
            OperationLogUtil.writeOperationLog((String)opName, (String)String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s,\u52fe\u7a3d\u68c0\u67e5\u6210\u529f", (String)"ReportListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), enityNode.getName(), enityNode.getNumber(), chkTmpNumber), (Long)modelId, (String)"bcm_mergecontrollist");
        }
        catch (Exception e) {
            OperationLogUtil.writeOperationLog((String)opName, (String)String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s,\u52fe\u7a3d\u68c0\u67e5\u5931\u8d25", (String)"ReportListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), enityNode.getName(), enityNode.getNumber(), chkTmpNumber), (Long)modelId, (String)"bcm_mergecontrollist");
            errorInfo.add(String.format("org[%s]-template[%s] reportListChk error!", param.get("entityNumber").toString(), chkTmpNumber));
            log.error("chk error:" + e);
        }
        if (errorInfo.size() > 0) {
            return new ExcelApiOutput(false, String.join((CharSequence)"|", errorInfo));
        }
        return new ExcelApiOutput(true);
    }

    public Map<String, Boolean> saveUpdateValues(Map<String, Object> param) {
        String cubecatalog = param.get("Cubecatalog").toString();
        OlapSaveBuilder olapSaveBuilder = new OlapSaveBuilder(cubecatalog);
        Map fixedDimensions = (Map)param.get("FixedDimensions");
        for (Map.Entry entry : fixedDimensions.entrySet()) {
            olapSaveBuilder.addFixedDimension((String)entry.getKey(), (String)entry.getValue());
        }
        List crossDimensions = (List)param.get("CrossDimensions");
        olapSaveBuilder.setCrossDimensions(crossDimensions.toArray(new String[crossDimensions.size()]));
        olapSaveBuilder.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        Map values = (Map)param.get("Values");
        ArrayList<Pair> cellset = new ArrayList<Pair>(16);
        for (Map.Entry entry : values.entrySet()) {
            String[] group = ((String)entry.getKey()).split("\\|");
            Pair pair = new Pair((Object)group, entry.getValue());
            cellset.add(pair);
        }
        olapSaveBuilder.setCellSet(cellset);
        olapSaveBuilder.setSourceEnum(OlapSourceEnum.E1);
        olapSaveBuilder.doSave();
        OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e", (String)"AnalyticsSolutionDataPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u6210\u529f", (String)"AnalyticsSolutionDataPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Long)MemberReader.findModelIdByNum((String)cubecatalog), (String)"bcm_analyticssolutiondata");
        return null;
    }

    public Map<String, StatusResult> getCellStatus(Map<String, Object> param) {
        QueryStatusCommandInfo comm = new QueryStatusCommandInfo(param.get("Cubecatalog").toString());
        Map fixedDimensions = (Map)param.get("FixedDimensions");
        for (Map.Entry entry : fixedDimensions.entrySet()) {
            comm.addFixDimension((String)entry.getKey(), (String)entry.getValue());
        }
        if (param.containsKey("TemplateId")) {
            comm.setTemplateId(LongUtil.toLong((Object)param.get("TemplateId")).longValue());
        }
        if (param.containsKey("ReportId")) {
            comm.setReportId(LongUtil.toLong((Object)param.get("ReportId")).longValue());
        }
        List crossDimensions = (List)param.get("CrossDimensions");
        comm.setCrossDimensions(crossDimensions);
        List cells = (List)param.get("Cells");
        for (List cell : cells) {
            comm.addCrossMembers(cell);
        }
        if (param.containsKey("QueryTypes")) {
            comm.setBizStatusQueryTypes((List)param.get("QueryTypes"));
        } else {
            comm.setBizStatusQueryTypes(ExcelFlowControlTypes.types);
        }
        if (param.containsKey("IsparticipMerge")) {
            comm.setBizGroupInMerge(((Boolean)param.get("IsparticipMerge")).booleanValue());
        }
        comm.setKeyPacker(membs -> {
            ArrayList list = new ArrayList();
            comm.getCrossDimensions().forEach(dim -> list.add(membs.get(dim)));
            return String.join((CharSequence)"|", list);
        });
        BizStatusContext ct = new BizStatusContext(comm);
        return BizStatusServer.queryStatus((BizStatusContext)ct);
    }

    public UserInfo getUserInfo(long modelId) {
        RequestContext context = RequestContext.get();
        long userId = Long.parseLong(context.getUserId());
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds);
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId));
        if (userInfoList != null && userInfoList.size() > 0) {
            Map userinfo = (Map)userInfoList.get(0);
            UserInfo user = new UserInfo();
            user.setId(userId);
            user.setNumber(String.valueOf(userinfo.get("number")));
            user.setIsAdmin(adminUserBol);
            user.setName(String.valueOf(userinfo.get("name")));
            user.setUsername(String.valueOf(userinfo.get("username")));
            user.setGender(String.valueOf(userinfo.get("gender")));
            user.setPhone(String.valueOf(userinfo.get("phone")));
            user.setEmail(String.valueOf(userinfo.get("email")));
            user.setAvatar(String.valueOf(userinfo.get("picturefield")));
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                user.setBirthday(format.parse(String.valueOf(userinfo.get("birthday"))));
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
            return user;
        }
        return null;
    }

    public Map<String, Object> getCalculateStatus(Map<String, Object> params) {
        Long modelId = LongUtil.toLong((Object)params.get("modelid"));
        Map dimParams = (Map)params.get("dimparams");
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        List orgIds = (List)dimParams.get("entity");
        List scenarioIds = (List)dimParams.get("scenario");
        List yearIds = (List)dimParams.get("year");
        List periodIds = (List)dimParams.get("period");
        Map mcStatus = McStatus.batchGetMcStatus4Periods((Long)modelId, (Collection)orgIds, (Collection)scenarioIds, (Collection)yearIds, (Collection)periodIds);
        for (Map.Entry entry : mcStatus.entrySet()) {
            if (entry == null) continue;
            boolean success = ((McStatus)entry.getValue()).getCalculate().isSuccess();
            if (mapResult.containsKey(entry.getKey())) continue;
            mapResult.put((String)entry.getKey(), success);
        }
        return mapResult;
    }

    public Map<String, Object> getFlowStatus(Map<String, Object> params) {
        Long modelId = LongUtil.toLong((Object)params.get("modelid"));
        Map dimParams = (Map)params.get("dimparams");
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        List orgIds = (List)dimParams.get("entity");
        List scenarioIds = (List)dimParams.get("scenario");
        List yearIds = (List)dimParams.get("year");
        List periodIds = (List)dimParams.get("period");
        Map mcStatus = McStatus.batchGetMcStatus4Periods((Long)modelId, (Collection)orgIds, (Collection)scenarioIds, (Collection)yearIds, (Collection)periodIds);
        for (Map.Entry entry : mcStatus.entrySet()) {
            if (entry == null) continue;
            boolean success = ((McStatus)entry.getValue()).getFlow().isSubmit();
            if (mapResult.containsKey(entry.getKey())) continue;
            mapResult.put((String)entry.getKey(), success);
        }
        return mapResult;
    }

    @Deprecated
    public Map<String, Object> getUserAllMemberRight(Map<String, Object> param) {
        Object modelId = param.get("modelId");
        boolean isPart = param.containsKey("isPart");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", modelId));
        if (param.containsKey("dimensionNumber")) {
            qFilters.add(new QFilter("number", "=", param.get("dimensionNumber")));
        }
        DynamicObjectCollection dimDatas = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,membermodel,number", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        HashMap<String, Object> result = new HashMap<String, Object>();
        dimDatas.forEach(dimRow -> {
            String entityName = dimRow.get("membermodel").toString();
            long id = LongUtil.toLong((Object)dimRow.get("id"));
            String number = dimRow.get("number").toString();
            if (isPart) {
                result.put(number, MemberPermHelper.getNoPermAndReadPermission((String)entityName, (long)id, (Object)modelId));
            } else {
                result.put(number, MemberPermHelper.getMemberPermission((String)entityName, (long)id, (Object)modelId));
            }
        });
        return result;
    }

    public Map<String, Map<Integer, Set<Long>>> getDimMemberRights(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("modelId"));
        HashMap<String, Map<Integer, Set<Long>>> result = new HashMap<String, Map<Integer, Set<Long>>>(6);
        PermissionService permService = PermissionServiceImpl.getInstance((Long)modelId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        if (param.containsKey("dimensionNumber")) {
            qFilters.add(new QFilter("number", "=", param.get("dimensionNumber")));
        }
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number", (QFilter[])qFilters.toArray(new QFilter[0]));
        for (DynamicObject dim : dims) {
            HashMap memberPerms = new HashMap(2);
            PermPackageList perms = permService.getDimPermSet(Long.valueOf(dim.getLong("id")));
            perms.getList().forEach(p -> memberPerms.put(p.getPerm().getValue(), p.getPermSet()));
            result.put(dim.getString("number"), memberPerms);
        }
        return result;
    }

    public BigDecimal getRate(Map<String, Object> param) {
        String modelNumber = param.get("modelNumber").toString();
        String sourceCurrency = param.get("sourceCurrency").toString();
        String targetCurrency = param.get("targetCurrency").toString();
        String rateType = param.get("rateType").toString();
        String ratePreset = param.get("ratePreset").toString();
        String scenario = param.get("scenario").toString();
        String year = param.get("year").toString();
        String period = param.get("period").toString();
        CalContext calContext = new CalContext(modelNumber, ratePreset, year, period, scenario, targetCurrency);
        CalculateService calculateService = new CalculateService((ICalContext)calContext);
        BigDecimal result = (BigDecimal)calculateService.singleCalculate("excrate(\"E." + ratePreset + "\",\"A." + rateType + "\",\"S." + scenario + "\",\"FY." + year + "\",\"P." + period + "\",\"BP." + sourceCurrency + "\",\"C." + targetCurrency + "\")");
        return result;
    }

    public BigDecimal getEsp(Map<String, Object> param) {
        String modelNumber = param.get("modelNumber").toString();
        String relaType = param.get("relaType").toString();
        String valType = param.get("valType").toString();
        String investCmp = param.get("investCmp").toString();
        String investeeCmp = param.get("investeeCmp").toString();
        String scenario = param.get("scenario").toString();
        String year = param.get("year").toString();
        String period = param.get("period").toString();
        CalContext calContext = new CalContext(modelNumber, null, year, period, scenario, null);
        CalculateService calculateService = new CalculateService((ICalContext)calContext);
        BigDecimal result = (BigDecimal)calculateService.singleCalculate("esp(\"" + relaType + "\",\"" + valType + "\",\"" + scenario + "\",\"" + year + "\",\"" + period + "\",\"" + investCmp + "\",\"" + investeeCmp + "\")");
        return result;
    }

    public ExcelApiOutput getRate1(Map<String, Object> param) {
        String period;
        ExcelApiOutput output = new ExcelApiOutput();
        String modelNumber = param.get("modelNumber").toString();
        String sourceCurrency = param.get("sourceCurrency").toString();
        String targetCurrency = param.get("targetCurrency").toString();
        String rateType = param.get("rateType").toString();
        String ratePreset = param.get("ratePreset").toString();
        String scenario = param.get("scenario").toString();
        String year = param.get("year").toString();
        CalContext calContext = new CalContext(modelNumber, ratePreset, year, period = param.get("period").toString(), scenario, targetCurrency);
        CalculateService calculateService = new CalculateService((ICalContext)calContext);
        Object result = calculateService.singleCalculate("excrate(\"E." + ratePreset + "\",\"A." + rateType + "\",\"S." + scenario + "\",\"FY." + year + "\",\"P." + period + "\",\"BP." + sourceCurrency + "\",\"C." + targetCurrency + "\")");
        if (result instanceof Exception) {
            output.setSuccess(false);
            output.setMessage(((Exception)result).getMessage());
        } else {
            output.setSuccess(true);
            output.setData(result);
        }
        return output;
    }

    public ExcelApiOutput getEsp1(Map<String, Object> param) {
        String period;
        ExcelApiOutput output = new ExcelApiOutput();
        String modelNumber = param.get("modelNumber").toString();
        String relaType = param.get("relaType").toString();
        String valType = param.get("valType").toString();
        String investCmp = param.get("investCmp").toString();
        String investeeCmp = param.get("investeeCmp").toString();
        String scenario = param.get("scenario").toString();
        String year = param.get("year").toString();
        CalContext calContext = new CalContext(modelNumber, null, year, period = param.get("period").toString(), scenario, null);
        CalculateService calculateService = new CalculateService((ICalContext)calContext);
        Object result = calculateService.singleCalculate("esp(\"" + relaType + "\",\"" + valType + "\",\"" + scenario + "\",\"" + year + "\",\"" + period + "\",\"" + investCmp + "\",\"" + investeeCmp + "\")");
        if (result instanceof Exception) {
            output.setSuccess(false);
            output.setMessage(((Exception)result).getMessage());
        } else {
            output.setSuccess(true);
            output.setData(result);
        }
        return output;
    }

    public ExcelApiOutput mergeReport(Map<String, Object> param) {
        FixedItem fixedItem = this.getFixedItem(param);
        fixedItem.setOrg(fixedItem.getEntity());
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add((Long)fixedItem.getEntity().getId());
        String errInfo = this.checkPeriodStatus(orgIds, fixedItem.getModelId(), fixedItem.getScenarioId(), fixedItem.getFyId(), fixedItem.getPeriodId());
        if (!StringUtils.isEmpty((String)errInfo)) {
            return new ExcelApiOutput(false, errInfo);
        }
        ResultBox result = MergeControlHelper.execMerge((FixedItem)fixedItem, null);
        if (result.isNotSuccess()) {
            return new ExcelApiOutput(false, result.getMessageText());
        }
        Long traceId = (Long)result.getData();
        return new ExcelApiOutput(true, String.valueOf(traceId));
    }

    public ExcelApiOutput mergeReportByCondition(Map<String, Object> param) {
        FixedItem fixedItem = this.getFixedItem(param);
        fixedItem.setOrg(fixedItem.getEntity());
        MergeCondition condition = this.getMergeCondition(param);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add((Long)fixedItem.getEntity().getId());
        String errInfo = this.checkPeriodStatus(orgIds, fixedItem.getModelId(), fixedItem.getScenarioId(), fixedItem.getFyId(), fixedItem.getPeriodId());
        if (!StringUtils.isEmpty((String)errInfo)) {
            return new ExcelApiOutput(false, errInfo);
        }
        ResultBox result = MergeControlHelper.execMerge((FixedItem)fixedItem, (MergeCondition)condition);
        if (result.isNotSuccess()) {
            return new ExcelApiOutput(false, result.getMessageText());
        }
        Long traceId = (Long)result.getData();
        return new ExcelApiOutput(true, String.valueOf(traceId));
    }

    public ExcelApiOutput calculateReport(Map<String, Object> param) {
        FixedItem fixedItem = this.getFixedItem(param);
        fixedItem.setOrgList(Collections.singletonList(fixedItem.getEntity()));
        List<Long> orgIds = fixedItem.getOrgList().stream().map(x -> LongUtil.toLong((Object)x.getId())).collect(Collectors.toList());
        String errInfo = this.checkPeriodStatus(orgIds, fixedItem.getModelId(), fixedItem.getScenarioId(), fixedItem.getFyId(), fixedItem.getPeriodId());
        if (!StringUtils.isEmpty((String)errInfo)) {
            return new ExcelApiOutput(false, errInfo);
        }
        ResultBox result = MergeControlHelper.execCalculate((FixedItem)fixedItem, null);
        if (result.isNotSuccess()) {
            return new ExcelApiOutput(false, result.getMessageText());
        }
        return new ExcelApiOutput(true);
    }

    public ExcelApiOutput calculateReportByCondition(Map<String, Object> param) {
        FixedItem fixedItem = this.getFixedItem(param);
        fixedItem.setOrgList(Collections.singletonList(fixedItem.getEntity()));
        MergeCondition condition = this.getMergeCondition(param);
        List<Long> orgIds = fixedItem.getOrgList().stream().map(x -> LongUtil.toLong((Object)x.getId())).collect(Collectors.toList());
        String errInfo = this.checkPeriodStatus(orgIds, fixedItem.getModelId(), fixedItem.getScenarioId(), fixedItem.getFyId(), fixedItem.getPeriodId());
        if (!StringUtils.isEmpty((String)errInfo)) {
            return new ExcelApiOutput(false, errInfo);
        }
        ResultBox result = MergeControlHelper.execCalculate((FixedItem)fixedItem, (MergeCondition)condition);
        if (result.isNotSuccess()) {
            return new ExcelApiOutput(false, result.getMessageText());
        }
        return new ExcelApiOutput(true);
    }

    private FixedItem getFixedItem(Map<String, Object> param) {
        long modelId = (Long)param.get("modelId");
        String orgNumber = param.get("entity").toString();
        if (orgNumber.contains("_")) {
            orgNumber = orgNumber.substring(orgNumber.lastIndexOf("_") + 1);
        }
        DynamicObject org = QueryDimensionServiceHelper.getMemberMsgByNumber((long)modelId, (String)orgNumber, (String)"bcm_entitymembertree");
        DynamicObject scenario = QueryDimensionServiceHelper.getMemberMsgByNumber((long)modelId, (String)param.get("scenario").toString(), (String)"bcm_scenemembertree");
        DynamicObject year = QueryDimensionServiceHelper.getMemberMsgByNumber((long)modelId, (String)param.get("year").toString(), (String)"bcm_fymembertree");
        DynamicObject period = QueryDimensionServiceHelper.getMemberMsgByNumber((long)modelId, (String)param.get("period").toString(), (String)"bcm_periodmembertree");
        FixedItem fixedItem = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelId, (String)MemberReader.findModelNumberById((Object)modelId)), (SimpleItem)SimpleItem.newOne((Object)scenario.getLong("id"), (String)scenario.getString("number")), (SimpleItem)SimpleItem.newOne((Object)year.getLong("id"), (String)year.getString("number")), (SimpleItem)SimpleItem.newOne((Object)period.getLong("id"), (String)period.getString("number")), (SimpleItem)SimpleItem.newOne((Object)org.getLong("id"), (String)org.getString("number")));
        return fixedItem;
    }

    private MergeCondition getMergeCondition(Map<String, Object> param) {
        MergeCondition condition = new MergeCondition();
        condition.setMergeScope(1);
        condition.setMergeCondition(((Integer)param.get("mergeCondition")).intValue());
        condition.setEcRuleCondition(((Integer)param.get("mergeRuleOnEC")).intValue());
        condition.setPcRuleCondition(((Integer)param.get("mergeRuleOnPC")).intValue());
        condition.setInterCheckCondition(((Integer)param.get("mergeInterCheck")).intValue());
        condition.setInvElimCondition(((Integer)param.get("geninvelim")).intValue());
        if (param.get("commonPaperAdjustCondition") != null && param.get("intrElimCondition") != null) {
            condition.setCommonPaperElimCondition(((Integer)param.get("commonPaperAdjustCondition")).intValue());
            condition.setIntrElimCondition(((Integer)param.get("intrElimCondition")).intValue());
        }
        return condition;
    }

    private String checkPeriodStatus(Collection<Long> entityIds, long modelId, long scenarioId, long yearId, long periodId) {
        if (CollectionUtils.isEmpty(entityIds) || !ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012")) {
            return "";
        }
        Map orgNodeMap = MemberReader.getAllNodeFromCache((String)"bcm_entitymembertree", (String)MemberReader.findModelNumberById((Object)modelId));
        HashMultimap orgNumber2IdMap = HashMultimap.create();
        for (Long entityId : entityIds) {
            orgNumber2IdMap.put((Object)orgNodeMap.getOrDefault(entityId, IDNumberTreeNode.NotFoundTreeNode).getNumber(), (Object)entityId);
        }
        Set periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)modelId, (Set)orgNumber2IdMap.keySet(), (Long)scenarioId, (Long)yearId, (Long)periodId, (String)"datastatus");
        HashSet periodClosed = new HashSet(orgNumber2IdMap.size());
        orgNumber2IdMap.forEach((num, id) -> {
            if (!periodOpenOrgSet.contains(num)) {
                entityIds.remove(id);
                periodClosed.add(num);
            }
        });
        if (periodClosed.size() > 0) {
            return String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"Operator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), periodClosed);
        }
        return "";
    }

    public Integer getMergeProgress(Map<String, Object> param) {
        long traceId = LongUtil.toLong((Object)param.get("traceId"));
        QFilter qf = QFilter.of((String)"id=?", (Object[])new Object[]{traceId});
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_mergeprogressentity", (String)"fstatus", (QFilter[])new QFilter[]{qf});
        Integer fstatus = dynamicObject.getInt("fstatus");
        return fstatus;
    }

    public List<Long> getMemberIdsByScopeValue(Map<String, Object> param) {
        long modelId = (Long)param.get("modelId");
        long dimensionId = (Long)param.get("dimensionId");
        int scope = (Integer)param.get("scope");
        return MemberListUtil.getMemberList((Object)modelId, (Long)dimensionId, (Object)scope);
    }

    public Map<String, ExcelApiOutput> upsertRptAdjustOffsetFormula(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).upsertRptAdjustOffsetFormula();
    }

    public Map<String, DynamicObjectCollection> getDocumentFileEntity(long modelId) {
        return DocumentFileEntityService.getDocumentFileEntity(modelId);
    }

    private static DynamicObject getCommonDimDynamicObject(DynamicObjectType objType, Long dimid, Long membid, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("comdimension", (Object)dimid);
        dynaObj.set("commembid", (Object)membid);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    private static DynamicObject getSpreadDimDynamicObject(DynamicObjectType objType, Long dimid, Long membid, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("spreaddimension", (Object)dimid);
        dynaObj.set("spreadmembid", (Object)membid);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    public List<EnumValue> getEnumValueByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        if (param.containsKey("dimensionId")) {
            qFilters.add(new QFilter("dimension_id", "=", param.get("dimensionId")));
        }
        DynamicObjectCollection enumValueData = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,dimension_id,enumitemid,datatype,name,enumvalue,dseq", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc");
        ArrayList<EnumValue> enumValues = new ArrayList<EnumValue>(enumValueData.size());
        for (DynamicObject valueRow : enumValueData) {
            EnumValue enumValue = new EnumValue();
            enumValue.setId(valueRow.getLong("id"));
            enumValue.setDimensionId(valueRow.getLong("dimension_id"));
            enumValue.setEnumItemId(valueRow.getLong("enumitemid"));
            enumValue.setDataType(valueRow.getInt("datatype"));
            enumValue.setName(valueRow.getString("name"));
            enumValue.setValue(valueRow.getString("enumvalue"));
            enumValue.setDseq(valueRow.getInt("dseq"));
            enumValues.add(enumValue);
        }
        return enumValues;
    }

    public LicenseCheckResult checkLicense() {
        Long groupId = 401L;
        String appId = "2/FPWJAAAGX=";
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        LicenseCheckResult result = new LicenseCheckResult(Boolean.valueOf(true), "");
        String licenseVersion = LicenseServiceHelper.getProductVersion();
        if (Integer.parseInt(licenseVersion.split("\\.")[0]) >= 4 && (result = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)groupId)).getHasLicense().booleanValue()) {
            result = LicenseServiceHelper.checkLicenseModules((String)appId);
        }
        return result;
    }

    public LicenseCheckResult checkLicense(String appId) {
        Long groupId = 401L;
        String epmAppId = "2/FPWJAAAGX=";
        String cmAppId = "11H66HLOX4IC";
        String rptAppId = "L/B5N23NCFS";
        String fidmAppId = "2IFNVZ0SS0W4";
        String farAppId = "2K++OWYYMS5J";
        Long userId = RequestContext.get().getCurrUserId();
        LicenseCheckResult result = new LicenseCheckResult(Boolean.valueOf(true), "");
        String licenseVersion = LicenseServiceHelper.getProductVersion();
        if (Integer.parseInt(licenseVersion.split("\\.")[0]) >= 4 && Boolean.TRUE.equals((result = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)groupId)).getHasLicense()) && Boolean.TRUE.equals((result = LicenseServiceHelper.checkLicenseModules((String)epmAppId)).getHasLicense())) {
            if (ApplicationTypeEnum.CM.getOIndex().equals(appId)) {
                result = LicenseServiceHelper.checkLicenseModules((String)cmAppId);
            } else if (ApplicationTypeEnum.RPT.getOIndex().equals(appId)) {
                result = LicenseServiceHelper.checkLicenseModules((String)rptAppId);
            } else if (ApplicationTypeEnum.FIDM.getOIndex().equals(appId)) {
                result = LicenseServiceHelper.checkLicenseModules((String)fidmAppId);
            } else if (ApplicationTypeEnum.FAR.getOIndex().equals(appId)) {
                result = LicenseServiceHelper.checkLicenseModules((String)farAppId);
            }
        }
        return result;
    }

    public LicenseCheckResult checkDataSetLicense() {
        Long groupId = 401L;
        String epmAppId = "2/FPWJAAAGX=";
        String fidmAppId = "2IFNVZ0SS0W4";
        String farAppId = "2K++OWYYMS5J";
        Long userId = RequestContext.get().getCurrUserId();
        LicenseCheckResult result = new LicenseCheckResult(Boolean.valueOf(false), "");
        String licenseVersion = LicenseServiceHelper.getProductVersion();
        if (Integer.parseInt(licenseVersion.split("\\.")[0]) >= 4 && Boolean.TRUE.equals((result = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)groupId)).getHasLicense()) && Boolean.TRUE.equals((result = LicenseServiceHelper.checkLicenseModules((String)epmAppId)).getHasLicense())) {
            result = LicenseServiceHelper.checkLicenseModules((String)fidmAppId);
            if (Boolean.TRUE.equals(result.getHasLicense())) {
                return result;
            }
            result = LicenseServiceHelper.checkLicenseModules((String)farAppId);
        }
        return result;
    }

    public Map<String, Integer> getEPMPermMap(Map<String, Object> param) {
        long modelId = (Long)param.get("modelId");
        String appId = param.containsKey("appId") ? param.get("appId").toString() : "cm";
        long userId = RequestContext.get().getCurrUserId();
        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)userId, (String)String.valueOf(modelId));
        List permItems = (List)param.get("permItems");
        HashMap<String, Integer> result = new HashMap<String, Integer>(permItems.size());
        permItems.forEach(item -> {
            if (StringUtils.isNotEmpty((String)item)) {
                int perm = isAdmin ? 1 : PermissionServiceHelper.checkPermission((long)userId, (String)"bcm_model", (long)modelId, (String)appId, (String)"bcm_epmclient_info", (String)item);
                result.put((String)item, perm);
            }
        });
        return result;
    }

    public String getVersion() {
        List versions = VersionService.getVersionInfos();
        Iterator versionIter = versions.iterator();
        String versionNum = "0.0.000.0";
        while (versionIter.hasNext()) {
            Version version = (Version)versionIter.next();
            if (!version.getProductNumber().startsWith("constellation_")) continue;
            versionNum = version.getVersion();
        }
        return versionNum;
    }

    public Map<String, String> getOrgCurrency(Map<String, Object> param) {
        HashMap<String, String> result = new HashMap<String, String>();
        long modelId = (Long)param.get("modelId");
        List orgEntrys = (List)param.get("orgEntrys");
        for (Map orgEntry : orgEntrys) {
            DynamicObject orgCurrency;
            String orgNumber = (String)orgEntry.get("Entity");
            if (((String)orgEntry.get("Year")).equals("") || ((String)orgEntry.get("Period")).equals("")) {
                QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)orgNumber)};
                DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"currency.number", (QFilter[])filters);
                if (org == null) {
                    return null;
                }
                QFilter[] filters2 = new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)org.getString(0))};
                orgCurrency = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id,number,name", (QFilter[])filters2);
                if (orgCurrency == null) continue;
                result.put((String)orgEntry.get("queryKey"), orgCurrency.get("number").toString());
                continue;
            }
            QFilter qf = new QFilter("number", "=", (Object)orgNumber);
            QFilter modelQf = new QFilter("model", "=", (Object)modelId);
            orgCurrency = OrgCurrencyServiceHelper.getOrgCurrency((QFilter[])new QFilter[]{qf, modelQf}, (Long)modelId, (String)((String)orgEntry.get("Year")), (String)((String)orgEntry.get("Period")));
            if (orgCurrency == null) continue;
            result.put((String)orgEntry.get("queryKey"), orgCurrency.get("currency.number").toString());
        }
        return result;
    }

    public DynamicObject getEpmClientLatest() {
        String selectFields = "version,remark,attach.fbasedataid.url url";
        DynamicObjectCollection dimData = QueryServiceHelper.query((String)"bcm_epmclient_info", (String)selectFields, null, (String)"version desc");
        if (dimData.size() == 0) {
            return null;
        }
        DynamicObject latest = (DynamicObject)dimData.get(0);
        String[] current = latest.getString("version").toUpperCase().replace("V", "").split("\\.");
        block0: for (DynamicObject dimRow : dimData) {
            String[] versionStrs = dimRow.getString("version").toUpperCase().replace("V", "").split("\\.");
            int maxLength = Math.max(current.length, versionStrs.length);
            for (int i = 0; i < maxLength; ++i) {
                int versionVal;
                int currentVal = i < current.length ? Integer.parseInt(current[i]) : 0;
                int n = versionVal = i < versionStrs.length ? Integer.parseInt(versionStrs[i]) : 0;
                if (currentVal < versionVal) {
                    latest = dimRow;
                    current = versionStrs;
                    continue block0;
                }
                if (currentVal != versionVal) continue block0;
            }
        }
        return latest;
    }

    public DynamicObjectCollection getEpmClientList() {
        String selectFields = "version,remark,attach.fbasedataid.url url";
        return QueryServiceHelper.query((String)"bcm_epmclient_info", (String)selectFields, null, (String)"version desc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] downloadFile(Map<String, Object> param) {
        byte[] byArray;
        Throwable throwable;
        BufferedInputStream inStream;
        long tick;
        ByteArrayOutputStream output;
        String remoteFilePath;
        block27: {
            block28: {
                remoteFilePath = param.get("remoteFilePath").toString();
                FileService fs = FileServiceFactory.getAttachmentFileService();
                output = new ByteArrayOutputStream();
                tick = System.currentTimeMillis();
                if (!fs.exists(remoteFilePath)) {
                    return null;
                }
                inStream = new BufferedInputStream(fs.getInputStream(remoteFilePath));
                throwable = null;
                byte[] buf = new byte[1024];
                int numBytesRead = 0;
                while ((numBytesRead = inStream.read(buf)) != -1) {
                    output.write(buf, 0, numBytesRead);
                }
                byArray = output.toByteArray();
                if (inStream == null) break block27;
                if (throwable == null) break block28;
                try {
                    inStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block27;
            }
            inStream.close();
        }
        log.info(String.format("download_file with targetURL: %s, cost: %s", remoteFilePath, System.currentTimeMillis() - tick));
        if (output.size() == 0) {
            try {
                output.close();
            }
            catch (IOException e) {
                log.error("download_file failed on URL: " + remoteFilePath, (Throwable)e);
            }
        }
        return byArray;
        {
            catch (Throwable buf) {
                try {
                    try {
                        try {
                            throwable = buf;
                            throw buf;
                        }
                        catch (Throwable throwable3) {
                            if (inStream != null) {
                                if (throwable != null) {
                                    try {
                                        inStream.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    inStream.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        log.error("download_file failed on URL: " + remoteFilePath, (Throwable)e);
                        throwable = null;
                        log.info(String.format("download_file with targetURL: %s, cost: %s", remoteFilePath, System.currentTimeMillis() - tick));
                        if (output.size() == 0) {
                            try {
                                output.close();
                            }
                            catch (IOException e2) {
                                log.error("download_file failed on URL: " + remoteFilePath, (Throwable)e2);
                            }
                        }
                        return throwable;
                    }
                }
                catch (Throwable throwable5) {
                    log.info(String.format("download_file with targetURL: %s, cost: %s", remoteFilePath, System.currentTimeMillis() - tick));
                    if (output.size() == 0) {
                        try {
                            output.close();
                        }
                        catch (IOException e) {
                            log.error("download_file failed on URL: " + remoteFilePath, (Throwable)e);
                        }
                    }
                    throw throwable5;
                }
            }
        }
    }

    public String getCellLockMsg(Map<String, Object> param) {
        QueryStatusCommandInfo comm = new QueryStatusCommandInfo(param.get("Cubecatalog").toString());
        Map fixedDimensions = (Map)param.get("FixedDimensions");
        for (Map.Entry entry : fixedDimensions.entrySet()) {
            comm.addFixDimension((String)entry.getKey(), (String)entry.getValue());
        }
        if (param.containsKey("TemplateId")) {
            comm.setTemplateId(LongUtil.toLong((Object)param.get("TemplateId")).longValue());
        }
        List crossDimensions = (List)param.get("CrossDimensions");
        comm.setCrossDimensions(crossDimensions);
        List cells = (List)param.get("Cells");
        for (List cell : cells) {
            comm.addCrossMembers(cell);
        }
        if (param.containsKey("QueryTypes")) {
            comm.setBizStatusQueryTypes((List)param.get("QueryTypes"));
        } else {
            comm.setBizStatusQueryTypes(ExcelFlowControlTypes.types);
        }
        comm.setKeyPacker(membs -> {
            ArrayList list = new ArrayList();
            comm.getCrossDimensions().forEach(dim -> list.add(membs.get(dim)));
            return String.join((CharSequence)"|", list);
        });
        BizStatusContext ct = new BizStatusContext(comm);
        int code = (Integer)param.get("StatusCode");
        return BizStatusServer.getLockMsg((BizStatusContext)ct, (int)code);
    }

    public Map<String, Object> getAcct(Map<String, Object> param) {
        String year = param.get("yearNumber").toString();
        Integer period = Integer.parseInt(param.get("periodNumber").toString());
        String entity = param.get("entityNumber").toString();
        String currency = param.get("currencyNumber").toString();
        String accounBookType = param.get("accounBookType").toString();
        String account = param.get("account").toString();
        String valType = param.get("valType").toString();
        String reclassification = "";
        if (param.containsKey("reclassification")) {
            reclassification = param.get("reclassification").toString();
        }
        String periodNumber = "M_M" + String.format("%02d", period);
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        CalContext calContext = new CalContext("", entity, "FY" + year, periodNumber, "", currency);
        CalculateService calculateService = new CalculateService((ICalContext)calContext);
        Object val = StringUtil.isEmptyString((String)reclassification) ? calculateService.singleCalculate("ACCT(\"" + entity + "\",\"" + accounBookType + "\",\"" + account + "\",\"" + valType + "\",\"" + year + "\",\"" + period + "\",\"" + currency + "\")") : (param.containsKey("accountOffset") && !StringUtil.isEmptyString((String)param.get("accountOffset").toString()) ? calculateService.singleCalculate("ACCT(\"" + entity + "\",\"" + accounBookType + "\",\"" + account + "\",\"" + valType + "\",\"" + year + "\",\"" + period + "\",\"" + currency + "\",\"" + reclassification + "\",\"" + param.get("accountOffset").toString() + "\")") : calculateService.singleCalculate("ACCT(\"" + entity + "\",\"" + accounBookType + "\",\"" + account + "\",\"" + valType + "\",\"" + year + "\",\"" + period + "\",\"" + currency + "\",\"" + reclassification + "\")"));
        if (val instanceof Exception) {
            result.put("false", ((Exception)val).getMessage());
        } else {
            result.put("true", val);
        }
        return result;
    }

    public Map<String, Object> getAcctcf(Map<String, Object> param) {
        String year = param.get("yearNumber").toString();
        Integer period = Integer.parseInt(param.get("periodNumber").toString());
        String entity = param.get("entityNumber").toString();
        String currency = param.get("currencyNumber").toString();
        String accounBookType = param.get("accounBookType").toString();
        String account = param.get("account").toString();
        String valType = param.get("valType").toString();
        String periodNumber = "M_M" + String.format("%02d", period);
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        CalContext calContext = new CalContext("", entity, "FY" + year, periodNumber, "", currency);
        CalculateService calculateService = new CalculateService((ICalContext)calContext);
        Object val = calculateService.singleCalculate("ACCTCF(\"" + entity + "\",\"" + accounBookType + "\",\"" + account + "\",\"" + valType + "\",\"0\",\"0\",\"" + currency + "\")");
        if (val instanceof Exception) {
            result.put("false", ((Exception)val).getMessage());
        } else {
            result.put("true", val);
        }
        return result;
    }

    public List<DimMetaField> getDimProperties(Map<String, Object> param) {
        return new ExcelDimensionManagerAction(param).getDimProperties();
    }

    public List<Map<String, Object>> getMemberDataByFieldLazy(Map<String, Object> param) {
        return new ExcelDimensionManagerAction(param).getMemberDataByFieldLazy();
    }

    public List<CalculateMessage> getCalculateMessages(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("modelId"));
        long yearId = LongUtil.toLong((Object)param.get("yearId"));
        long periodId = LongUtil.toLong((Object)param.get("periodId"));
        long scenarioId = LongUtil.toLong((Object)param.get("scenarioId"));
        long entityId = LongUtil.toLong((Object)param.get("entityId"));
        long templateId = LongUtil.toLong((Object)param.get("templateId"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        qFilters.add(new QFilter("fy_id", "=", (Object)yearId));
        qFilters.add(new QFilter("period_id", "=", (Object)periodId));
        qFilters.add(new QFilter("scenario_id", "=", (Object)scenarioId));
        qFilters.add(new QFilter("template_id", "=", (Object)templateId));
        qFilters.add(new QFilter("org_id", "=", (Object)entityId));
        qFilters.add(new QFilter("logtype", "=", (Object)InvFormulaLogTypeEnum.ReoprtFormulaLog.getLogType()));
        DynamicObjectCollection memberData = QueryServiceHelper.query((String)"bcm_datacollectlog", (String)"org.name,template.name,template.number,dims,template.templatecatalog.name,datafrom,error,collector.name,collecttime", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<CalculateMessage> result = new ArrayList<CalculateMessage>(memberData.size());
        for (DynamicObject dyObj : memberData) {
            CalculateMessage message = new CalculateMessage();
            message.setEntityName(dyObj.getString("org.name"));
            message.setTemplateName(dyObj.getString("template.name"));
            message.setTemplateCode(dyObj.getString("template.number"));
            message.setTemplateClassify(dyObj.getString("template.templatecatalog.name"));
            message.setCellPostion(dyObj.getString("dims"));
            message.setFailedMessage(dyObj.getString("error"));
            message.setFormula(dyObj.getString("datafrom"));
            message.setExcuteTime(dyObj.getString("collecttime"));
            message.setExcuteUser(dyObj.getString("collector.name"));
            result.add(message);
        }
        return result;
    }

    public List<CalculateMessage> getCalculateMessagesBatch(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("modelId"));
        long yearId = LongUtil.toLong((Object)param.get("yearId"));
        long periodId = LongUtil.toLong((Object)param.get("periodId"));
        long scenarioId = LongUtil.toLong((Object)param.get("scenarioId"));
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model_id", "=", (Object)modelId));
        builder.add(new QFilter("fy_id", "=", (Object)yearId));
        builder.add(new QFilter("period_id", "=", (Object)periodId));
        builder.add(new QFilter("scenario_id", "=", (Object)scenarioId));
        builder.add(new QFilter("logtype", "=", (Object)InvFormulaLogTypeEnum.ReoprtFormulaLog.getLogType()));
        DynamicObjectCollection memberData = QueryServiceHelper.query((String)"bcm_datacollectlog", (String)"org.name,template.name,template.number,template.templatecatalog.name,dims,datafrom,error,collector.name,collecttime", (QFilter[])builder.toArray());
        ArrayList<CalculateMessage> result = new ArrayList<CalculateMessage>(memberData.size());
        for (DynamicObject dyObj : memberData) {
            CalculateMessage message = new CalculateMessage();
            message.setEntityName(dyObj.getString("org.name"));
            message.setTemplateName(dyObj.getString("template.name"));
            message.setTemplateCode(dyObj.getString("template.number"));
            message.setTemplateClassify(dyObj.getString("template.templatecatalog.name"));
            message.setCellPostion(dyObj.getString("dims"));
            message.setFailedMessage(dyObj.getString("error"));
            message.setFormula(dyObj.getString("datafrom"));
            message.setExcuteTime(dyObj.getString("collecttime"));
            message.setExcuteUser(dyObj.getString("collector.name"));
            result.add(message);
        }
        return result;
    }

    public List<DataCollectTemplate> getFormulaDataCollectTemplate(Map<String, Object> param) {
        return new ExcelFormulaDataCollectAction(param).getDataCollectTemplate();
    }

    public ExcelApiOutput batchExcuteFormulaDataCollect(Map<String, Object> param) {
        return new ExcelFormulaDataCollectAction(param).batchExcuteDataCollect();
    }

    public Map<String, Integer> getFormulaDataCollectStatus(Map<String, Object> param) {
        return new ExcelFormulaDataCollectAction(param).getTemplateExcuteStatus();
    }

    public boolean getModelTemplateIsSorted(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("modelId"));
        List templates = (List)param.get("templates");
        QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
        QFilter idQFilters = new QFilter("id", "in", (Object)templates);
        String selectFields = "id,group";
        DynamicObjectCollection groupQueryResult = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, idQFilters}, null);
        HashSet groupIds = Sets.newHashSet();
        groupQueryResult.forEach(c -> {
            Long groupId = c.getLong("group");
            groupIds.add(groupId);
        });
        QFilter groupQFilter = new QFilter("group", "in", (Object)groupIds);
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bcm_datacollectorder", (String)"id,setorder", (QFilter[])new QFilter[]{modelQFilter, groupQFilter}, null);
        return queryResult.size() > 0;
    }

    public ExcelApiOutput saveTemplatePageDimension(Map<String, Object> param) {
        return new ExcelFormulaDataCollectAction(param).savePageDimension();
    }

    public List<ISSchemesData> getISSchemes(Map<String, Object> param) {
        return new ExcelDataIntegrationAction(param).getISSchemes();
    }

    public ExcelApiOutput collectISSchemeData(Map<String, Object> param) {
        return new ExcelDataIntegrationAction(param).collectISSchemeData();
    }

    public List<ISSchemesResult> getDataCollectResult(Map<String, Object> params) {
        return new ExcelDataIntegrationAction(params).getDataCollectResult();
    }

    public List<LinkQueryParam> getGlPageParamByFormulas(Map<String, Object> params) {
        Map commonParam = (Map)params.get("CommParam");
        List formulas = (List)params.get("Formulas");
        if (params.containsKey("modelId")) {
            commonParam.put("model", LongUtil.toLong((Object)params.get("modelId")));
        }
        HashMap<String, PairList> formulaGroup = new HashMap<String, PairList>();
        for (String formula : formulas) {
            String[] strs = formula.split("\\(");
            if (strs.length <= 0) continue;
            String type = strs[0];
            if (!formulaGroup.containsKey(type)) {
                formulaGroup.put(type, new PairList());
            }
            ((PairList)formulaGroup.get(type)).addPair((Object)formula, null);
        }
        ArrayList<LinkQueryParam> result = new ArrayList<LinkQueryParam>();
        formulaGroup.forEach((k, v) -> {
            List parameters = LinkFormulaUtil.getLinkPageParam((String)k, (PairList)v, (Map)commonParam);
            parameters.forEach(p -> {
                if (p instanceof FormShowParameter) {
                    LinkQueryParam paramLink = new LinkQueryParam();
                    paramLink.setFormId(((FormShowParameter)p).getFormId());
                    paramLink.setReportQueryParam((String)((FormShowParameter)p).getCustomParam("reportQueryParam"));
                    result.add(paramLink);
                }
            });
        });
        return result;
    }

    public List<Map<String, Object>> getDataTraceChilds(Map<String, Object> params) {
        long modelId = LongUtil.toLong((Object)params.get("modelId"));
        String clickDimNumber = params.get("selectField").toString();
        Object fMoney = params.get("fMoney");
        boolean unfoldAllRow = BooleanUtils.toBoolean((String)params.get("unfoldAllRow").toString());
        boolean isContainSon = BooleanUtils.toBoolean((String)params.get("isContainSon").toString());
        HashMap<String, Object> memberMap = new HashMap<String, Object>(16);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if ("modelId".equalsIgnoreCase(entry.getKey()) || "isContainSon".equalsIgnoreCase(entry.getKey()) || "fMoney".equalsIgnoreCase(entry.getKey()) || "unfoldAllRow".equalsIgnoreCase(entry.getKey()) || "selectField".equalsIgnoreCase(entry.getKey())) continue;
            memberMap.put(entry.getKey(), entry.getValue());
        }
        return new DataTraceApiHelper().getDataTraceChilds(modelId, clickDimNumber, memberMap, fMoney, isContainSon, unfoldAllRow);
    }

    public ExcelApiOutput getLinkData(Map<String, Object> params) {
        long modelId = LongUtil.toLong((Object)params.get("modelId").toString());
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if ("modelId".equalsIgnoreCase(entry.getKey())) continue;
            memberMap.put(entry.getKey(), entry.getValue().toString());
        }
        DataTrace2FromService service = new DataTrace2FromService(Long.valueOf(modelId), Long.valueOf(0L));
        DataTraceFrom dtf = service.queryDataTraceFrom(memberMap);
        if (dtf != null) {
            DataTraceResult result = new DataTraceResult();
            result.setTraceNum(dtf.getM());
            result.setTractInfo(dtf.getD());
            result.setDataTraceFromList(dtf.getDf());
            return new ExcelApiOutput(result);
        }
        return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\u8ffd\u6eaf\u4fe1\u606f\u3002", (String)"DataTracePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public List<TemplateCatalog> getTemplateWithCatalog(Map<String, Object> params) {
        return new ExcelTemplateAction(params).getTemplateWithCatalog();
    }

    public List<YearCarryTemplate> getYearCarryDataCollectTemplate(Map<String, Object> param) {
        return new ExcelYearCarryAction(param).getYearCarryDataCollectTemplate();
    }

    public ExcelApiOutput getYearCarryPerformDataCollect(Map<String, Object> param) {
        return new ExcelYearCarryAction(param).yearCarryPerform();
    }

    public ExcelApiOutput yearCarryConfirmOperation(Map<String, Object> param) {
        return new ExcelYearCarryAction(param).yearCarryConfirmOperation();
    }

    public EpmClientVersion getEpmClientPackageInfoByVersion(Map<String, Object> param) {
        return ExcelVersionAction.getEpmClientPackageInfoByVersion(param);
    }

    public Map<Long, Integer> getReportGjStatus(Map<String, Object> param) {
        return new ExcelTemplateAction(param).getReportGjStatus();
    }

    public List<OrgBizChangeRecord> downloadEntityBizChangeRecord(Map<String, Object> param) {
        Long modelId = LongUtil.toLong((Object)param.get("modelId"));
        DBRoute dbRoute = new DBRoute("bcm");
        String bizSql = "select x.fid ,t.fentityid,t.feffdate ,t.fexpdate ,t.fseq ,t.fchangetype from  t_bcm_structofent x join t_bcm_entitybizrecord t on  x.fid =t.fid  where x.fmodelid =?";
        DataSet bizDataSet = DB.queryDataSet((String)"getOrgBizChangeRecord", (DBRoute)dbRoute, (String)bizSql, (Object[])new Object[]{modelId});
        Map invChangetypeModel = InvestServiceHelper.getInvChangetypeModel((Long)modelId);
        Map<String, Map> BizChangeTypeMap = invChangetypeModel.values().stream().collect(Collectors.toMap(x -> x.number(), x -> {
            HashMap<String, Constable> map = new HashMap<String, Constable>();
            map.put("change", Integer.valueOf(Integer.parseInt(x.change())));
            map.put("isdefault", Boolean.valueOf(x.isdefault()));
            map.put("modelId", modelId);
            return map;
        }, (v1, v2) -> (Long)v1.get("modelId") != 0L ? v1 : v2));
        if (!BizChangeTypeMap.containsKey(OrgBizChangeTypeEnum.disable.getValue())) {
            HashMap<String, Constable> DisableMap = new HashMap<String, Constable>();
            DisableMap.put("change", Integer.valueOf(2));
            DisableMap.put("isdefault", Boolean.valueOf(true));
            BizChangeTypeMap.put(OrgBizChangeTypeEnum.disable.getValue(), DisableMap);
        }
        ArrayList<OrgBizChangeRecord> result = new ArrayList<OrgBizChangeRecord>(16);
        for (Row row : bizDataSet) {
            String changeType = row.getString("fchangetype");
            if (!BizChangeTypeMap.containsKey(changeType)) continue;
            OrgBizChangeRecord record = new OrgBizChangeRecord();
            record.setEffdate(row.getDate("feffdate"));
            record.setExpdate(row.getDate("fexpdate"));
            record.setChangeType(changeType);
            record.setSeq(row.getInteger("fseq"));
            boolean isDefault = (Boolean)BizChangeTypeMap.get(changeType).get("isdefault");
            if (isDefault) {
                switch (changeType) {
                    case "BD000": {
                        record.setEffType(OrgBizChangeEffEnum.CurrentMonth.ordinal());
                        record.setChangeDirect(2);
                        break;
                    }
                    case "BD001": 
                    case "BD002": 
                    case "BD003": 
                    case "BD004": 
                    case "BD007": 
                    case "BD008": {
                        record.setEffType(OrgBizChangeEffEnum.CurrentMonth.ordinal());
                        record.setChangeDirect(1);
                        break;
                    }
                    case "BD005": 
                    case "BD006": {
                        record.setEffType(OrgBizChangeEffEnum.NextYear.ordinal());
                        record.setChangeDirect(2);
                        break;
                    }
                    case "BD009": {
                        record.setEffType(OrgBizChangeEffEnum.NextMonth.ordinal());
                        record.setChangeDirect(2);
                        break;
                    }
                }
            } else {
                Integer changeDirect = (Integer)BizChangeTypeMap.get(changeType).get("change");
                if (changeDirect == 1) {
                    record.setEffType(OrgBizChangeEffEnum.CurrentMonth.ordinal());
                } else if (changeDirect == 2) {
                    record.setEffType(OrgBizChangeEffEnum.NextYear.ordinal());
                }
                record.setChangeDirect(changeDirect);
            }
            record.setEntryId(row.getLong("fentityid"));
            record.setOrgId(row.getLong("fid"));
            record.setModelId(modelId);
            result.add(record);
        }
        return result;
    }

    public List<OrgNameChangeRecord> downloadEntityizNameChangeRecord(Map<String, Object> param) {
        Long modelId = LongUtil.toLong((Object)param.get("modelId"));
        Date beginDate = EntityVersioningUtil.getModelBeginDate((Object)modelId);
        DBRoute dbRoute = new DBRoute("bcm");
        String bizSql = "select x.fid,t.fentityid ,t.fname ,t.fsimplename ,t.feffdate ,t.fexpdate,t.fseq from  t_bcm_structofent x join t_bcm_entitynamerecord t on  x.fid =t.fid where x.fmodelid =? ";
        DataSet bizDataSet = DB.queryDataSet((String)"getOrgNameChangeRecord", (DBRoute)dbRoute, (String)bizSql, (Object[])new Object[]{modelId});
        ArrayList<OrgNameChangeRecord> result = new ArrayList<OrgNameChangeRecord>(16);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        for (Row row : bizDataSet) {
            if (null == row.getDate("feffdate") || fmt.format(beginDate).equals(fmt.format(row.getDate("feffdate"))) && null == row.get("fexpdate")) continue;
            OrgNameChangeRecord record = new OrgNameChangeRecord();
            record.setEffdate(row.getDate("feffdate"));
            record.setExpdate(row.getDate("fexpdate"));
            record.setName(row.getString("fname"));
            record.setSimpleName(row.getString("fsimplename"));
            record.setSeq(row.getInteger("fseq"));
            record.setEntryId(row.getLong("fentityid"));
            record.setOrgId(row.getLong("fid"));
            record.setModelId(modelId);
            result.add(record);
        }
        return result;
    }

    public List<PeriodMemberEx> downloadPeriodMemberEx(Map<String, Object> param) {
        Long modelId = LongUtil.toLong((Object)param.get("modelId"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            qFilters.add(new QFilter("modifytime", ">", (Object)format.parse(param.get("modifyTime").toString())));
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        DynamicObjectCollection PeriodDatas = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_periodmembertree", (String)"id, effmonth, effday, expmonth, expday,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<PeriodMemberEx> result = new ArrayList<PeriodMemberEx>(16);
        for (DynamicObject obj : PeriodDatas) {
            PeriodMemberEx item = new PeriodMemberEx();
            item.setEffday(obj.getInt("effday"));
            item.setEffmonth(obj.getInt("effmonth"));
            item.setExpmonth(obj.getInt("expmonth"));
            item.setExpday(obj.getInt("expday"));
            item.setModelId(modelId);
            item.setId(obj.getLong("id"));
            item.setModifytime(obj.getDate("modifytime"));
            result.add(item);
        }
        return result;
    }

    public Map<String, Object> downloadMergeStructInfo(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        Long modelId = LongUtil.toLong((Object)param.get("modelId"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        Boolean isOpenMerge = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isMergeInfoStruct");
        result.put("isopenmerge", isOpenMerge);
        if (!isOpenMerge.booleanValue()) {
            result.put("records", new ArrayList());
            return result;
        }
        DynamicObjectCollection MergeStructInfoDatas = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_mergestructinfo", (String)"id, orgnumber, orglnumber, ismerge, model_id,scenario_id,year_id,period_id,orgname", (QFilter[])qFilters.toArray(new QFilter[0]), null);
        ArrayList<MergeStructModel> records = new ArrayList<MergeStructModel>(16);
        for (DynamicObject obj : MergeStructInfoDatas) {
            MergeStructModel model = new MergeStructModel();
            model.setId(obj.getLong("id"));
            model.setOrglNumber(obj.getString("orglnumber"));
            model.setModelId(obj.getLong("model_id"));
            model.setMerge(obj.getBoolean("ismerge"));
            model.setOrgNumber(obj.getString("orgnumber"));
            model.setPeriodId(obj.getLong("period_id"));
            model.setYearId(obj.getLong("year_id"));
            model.setOrgName(obj.getString("orgname"));
            model.setScenarioId(obj.getLong("scenario_id"));
            records.add(model);
        }
        result.put("records", records);
        boolean showNoMergeOrg = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM030");
        result.put("shownomergeorg", showNoMergeOrg);
        return result;
    }

    public List<AbstractDimension> getDimensionExtendByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension_ext", (String)"id,number,shortnumber,name,dseq,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<AbstractDimension> dimensions = new ArrayList<AbstractDimension>(dims.size());
        for (DynamicObject dimRow : dims) {
            Dimension dim = new Dimension();
            dim.setId(dimRow.getLong("id"));
            dim.setNumber(dimRow.getString("number"));
            dim.setName(dimRow.getString("name"));
            dim.setShortNumber(dimRow.getString("shortnumber"));
            dim.setDseq(dimRow.getInt("dseq"));
            dim.setModifyTime(dimRow.getDate("modifytime"));
            dim.setSysDimension(false);
            dimensions.add(dim);
        }
        return dimensions;
    }

    public List<ExtendMember> getDimExtendMembersByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        if (param.containsKey("dimensionId")) {
            qFilters.add(new QFilter("dimension_id", "=", param.get("dimensionId")));
        }
        try {
            if (param.containsKey("modifyTime")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                qFilters.add(new QFilter("modifytime", ">", (Object)format.parse(param.get("modifyTime").toString())));
            }
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        String selectFields = "id,number,longnumber,name,level,isleaf,parent_id,dimension_id,storagetype,datatype,enumitem,grouptype,dseq,modifytime,isparticipmerge";
        DynamicObjectCollection dimMembers = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_structofextend", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<ExtendMember> members = new ArrayList<ExtendMember>(dimMembers.size());
        for (DynamicObject memRow : dimMembers) {
            ExtendMember member = new ExtendMember();
            member.setId(memRow.getLong("id"));
            member.setNumber(memRow.getString("number"));
            member.setLongNumber(memRow.getString("longnumber"));
            member.setName(memRow.getString("name"));
            member.setLevel(memRow.getInt("level"));
            member.setIsLeaf(memRow.getBoolean("isleaf"));
            member.setParentId(memRow.getLong("parent_id"));
            member.setDimensionId(memRow.getLong("dimension_id"));
            member.setStorageType(memRow.getInt("storagetype"));
            member.setDataType(memRow.getInt("datatype"));
            member.setEnumItemId(memRow.getLong("enumitem"));
            member.setGrouptype(memRow.getInt("grouptype"));
            member.setDseq(memRow.getInt("dseq"));
            member.setModifyTime(memRow.getDate("modifytime"));
            member.setIsparticipmerge(memRow.getBoolean("isparticipmerge"));
            members.add(member);
        }
        return members;
    }

    public List<ExtendModel> getExtendModelsByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("model", "=", param.get("modelId")));
        String selectFields = "id,number,name,extendsgroup";
        DynamicObjectCollection dynamicObjectModels = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<ExtendModel> models = new ArrayList<ExtendModel>(dynamicObjectModels.size());
        for (DynamicObject row : dynamicObjectModels) {
            ExtendModel model = new ExtendModel();
            model.setId(row.getLong("id"));
            model.setNumber(row.getString("number"));
            model.setName(row.getString("name"));
            model.setGroupId(row.getLong("extendsgroup"));
            ArrayList<QFilter> qFilters1 = new ArrayList<QFilter>(1);
            qFilters1.add(new QFilter("extmodelid", "=", (Object)row.getLong("id")));
            DynamicObjectCollection dynamicObjectFields = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"extfield", (QFilter[])qFilters1.toArray(new QFilter[0]), (String)"sequence asc");
            model.setFieldIds(dynamicObjectFields.stream().map(f -> f.getLong("extfield")).collect(Collectors.toList()));
            DynamicObjectCollection dynamicObjectDims = QueryServiceHelper.query((String)"bcm_extmodeldim", (String)"dimension.id", (QFilter[])qFilters1.toArray(new QFilter[0]), (String)"sequence asc");
            model.setDimensionIds(dynamicObjectDims.stream().map(f -> f.getLong("dimension.id")).collect(Collectors.toList()));
            models.add(model);
        }
        return models;
    }

    public Map<String, Object> updateReportStatus(Map<String, Object> param) {
        return new ExcelSaveAction().updateReportStatus(param);
    }

    public List<AdHocSolution> getSolutionList(Map<String, Object> param) {
        return ExcelAdHocSolutionAction.getSolutionList(param);
    }

    public AdHocSolution getSolution(Map<String, Object> param) {
        return ExcelAdHocSolutionAction.getSolution(param);
    }

    public List<AdHocSolutionDimMember> getSolutionDimMembers(Map<String, Object> param) {
        return ExcelAdHocSolutionAction.getSolutionDimMembers(param);
    }

    public ExcelApiOutput saveSolution(Map<String, Object> solution) {
        return ExcelAdHocSolutionAction.saveSolution(solution);
    }

    public ExcelApiOutput deleteSolution(Map<String, Object> param) {
        return ExcelAdHocSolutionAction.deleteSolution(param);
    }

    public Map<Long, List<Long>> getDeleteMemberByModelId(Map<String, Object> param) {
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        if (!param.containsKey("modifyTime")) {
            return map;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        qFilters.add(new QFilter("operatenumber", "=", (Object)DimMemberOperateTypeEnum.DELETE.getValue()).or("operatenumber", "=", (Object)DimMemberOperateTypeEnum.DELETE_SHARE.getValue()));
        if (param.containsKey("dimensionId")) {
            qFilters.add(new QFilter("dimension.id", "=", param.get("dimensionId")));
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            qFilters.add(new QFilter("createtime", ">", (Object)format.parse(param.get("modifyTime").toString())));
        }
        catch (ParseException e) {
            ExcelSerivce.log.error((Throwable)e);
        }
        DynamicObjectCollection logs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_dimensionmodifylog", (String)"id,dimension.id,memberid", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"dimension.id asc");
        List dimIds = logs.stream().map(log -> log.getLong("dimension.id")).distinct().collect(Collectors.toList());
        for (Long dimId : dimIds) {
            List memberIds = logs.stream().filter(log -> log.getLong("dimension.id") == dimId.longValue()).map(log -> log.getLong("memberid")).distinct().collect(Collectors.toList());
            map.put(dimId, memberIds);
        }
        return map;
    }

    public List<AdjustOffsetModel> getRptAdjustOffsetList(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).getRptAdjustOffsetList();
    }

    public List<AdjustOffsetModel> getRptAdjustOffsetListPage(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).getRptAdjustOffsetListPage();
    }

    public List<Long> getOffsetListIds(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).getOffsetListIds();
    }

    public List<TemplateCatalog> getRptAdjustCatalog(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).getRptAdjustCatalog();
    }

    public ExcelApiOutput getAdjustLogInfo(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).getAdjustLogInfo();
    }

    public List<AdjustLogModel> getAdjustLogList(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).getAdjustLogList();
    }

    public ExcelApiOutput deleteRptAdjustOffsets(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).deleteRptAdjustOffsets();
    }

    public List<AdjustOffsetModel> getRptAdjustOffsetDetails(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).getRptAdjustOffsetDetails();
    }

    public List<ExcelApiOutput> upsertRptAdjustOffset(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).upsertRptAdjustOffset();
    }

    public List<AdjustBussinessTypeModel> getBussinessTypeModels(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).getBussinessTypeModels();
    }

    public ExcelApiOutput updateAdjustStatus(Map<String, Object> param) {
        return new ExcelAdjustOffsetAction(param).updateAdjustStatus();
    }

    public List<PermissionClass> getPerClassList(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        String number = StringUtils.getStringValue((Object)param.get("Number"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (StringUtils.isNotEmpty((String)number)) {
            qFilters.add(new QFilter("number", "like", (Object)("%" + number + "%")));
        }
        Set ids = new HashSet();
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)Long.toString(modelId));
        if (!adminUserBol) {
            ids = PermClassEntityHelper.getWriteDataPermission((String)Long.toString(modelId), (String)"model", (String)"");
        }
        DynamicObjectCollection perms = QueryServiceHelper.query((String)"bcm_permissionclass", (String)"id,number,remark,modifier.name,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<PermissionClass> list = new ArrayList<PermissionClass>(perms.size());
        for (DynamicObject perm : perms) {
            PermissionClass p = new PermissionClass();
            p.setId(perm.getLong("id"));
            p.setNumber(perm.getString("number"));
            p.setRemark(perm.getString("remark"));
            p.setModifier(perm.getString("modifier.name"));
            p.setModifyTime(perm.getDate("modifytime"));
            if (adminUserBol) {
                p.setHasRight(true);
            } else {
                p.setHasRight(ids.contains(p.getId()));
            }
            list.add(p);
        }
        return list;
    }

    public List<Long> getMemberIdByRange(Map<String, Object> param) {
        return new ExcelDimensionManagerAction(param).getMemberIdByRange();
    }

    public ExcelApiOutput getFidmDataSetResult(Map<String, Object> param) {
        ExcelApiOutput output = new ExcelApiOutput();
        String jsonData = JSON.toJSONString(param);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"epm", (String)"far", (String)"BcmMsService", (String)"getFidmDataSetResult", (Object[])new Object[]{jsonData});
        if (null != result && result.containsKey("success")) {
            output.setSuccess((Boolean)result.get("success"));
        }
        if (null != result && result.containsKey("errors") && null != result.get("errors")) {
            output.setMessage(result.get("errors").toString());
        }
        if (null != result && result.containsKey("data")) {
            output.setData(result.get("data"));
        }
        return output;
    }

    public List<IntegrationObject> getIntegrationObjects(Map<String, Object> param) {
        return ExcelIntegrationAction.getIntegrationObjects(param);
    }

    public List<IntegrationProperty> getIntegrationProperties(Map<String, Object> param) {
        return ExcelIntegrationAction.getIntegrationProperties(param);
    }

    public List<ReportTemplate> GetTemplateList(Map<String, Object> param) {
        return new ExcelTemplateAction(param).GetTemplateList();
    }

    public TemplateDetail GetTemplateDetail(Map<String, Object> param) {
        return new ExcelTemplateAction(param).GetTemplateDetail();
    }
}

