/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.query.BaseConvertFormula;
import kd.fi.bcm.business.convert.util.ConvertSchemeServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDColumn;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.datatrace.DataTraceHelper;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import org.apache.commons.lang3.BooleanUtils;

public class DataTraceApiHelper {
    private static final Set<String> doNotShowHyperlink = new HashSet<String>(Arrays.asList("ADJT", "SADJ", "EJET", "SEJE", "CCTotal", "CC", "PRPT", "ARPT", "Rpt", "ERpt", "CT", "CSTE", "SRPT", "SCADJ", "SCCADJ", "SEIC", "SEOE", "SEOther", "SEIT", "SECF"));
    private static final String[] staticFixHeads1 = new String[]{"Entity", "Account", "ChangeType", "Currency"};
    private static final String[] staticFixHeads1ATCT = new String[]{"Entity", "Account", "Currency"};
    private static final String[] selectDimList = new String[]{"Entity", "AuditTrail", "Process", "Currency"};
    private static final String[] selectDimListATCT = new String[]{"Entity", "Process", "Currency"};
    private static final String fMoneyColName = "fMoney";
    private static final String rMoneyColName = "rMoney";
    private static final String unfoldFiled = "Entity";
    private long globalModelId;
    private String globalModelNumber;
    private Map<String, IDNumberTreeNode> globalDataBizMap;
    private boolean globalIsContainSon = false;

    public List<Map<String, Object>> getDataTraceChilds(long modelId, String clickDimNumber, Map<String, Object> paramsMap, Object fMoney, boolean isContainSon, boolean unfoldAllRow) {
        List<Map<String, Object>> addRows = this.getNodesChilds(modelId, clickDimNumber, paramsMap, fMoney, isContainSon);
        if (!unfoldAllRow) {
            for (Map<String, Object> row : addRows) {
                row.put("Childs", new HashMap());
            }
            return addRows;
        }
        if (addRows.size() > 0) {
            this.getDataTraceChildsLoop(modelId, clickDimNumber, paramsMap, fMoney, isContainSon, addRows);
        }
        return addRows;
    }

    private void getDataTraceChildsLoop(long modelId, String clickDimNumber, Map<String, Object> paramsMap, Object fMoney, boolean isContainSon, List<Map<String, Object>> rows) {
        for (Map<String, Object> curRow : rows) {
            boolean isNeedAddPlus = BooleanUtils.toBoolean((String)((Map)curRow.get(clickDimNumber)).get("IsNeedAddPlus").toString());
            if (isNeedAddPlus) {
                HashMap<String, Object> nextParamsMap = new HashMap<String, Object>(paramsMap.size());
                for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
                    if (entry.getKey().equalsIgnoreCase("TraceData") || entry.getKey().equalsIgnoreCase("Childs")) continue;
                    if (curRow.containsKey(entry.getKey())) {
                        Map data = (Map)curRow.get(entry.getKey());
                        nextParamsMap.put(entry.getKey(), data.get("MemberId"));
                        continue;
                    }
                    nextParamsMap.put(entry.getKey(), entry.getValue());
                }
                fMoney = curRow.get("TraceData");
                List<Map<String, Object>> childRows = this.getNodesChilds(modelId, clickDimNumber, nextParamsMap, fMoney, isContainSon);
                if (childRows.size() > 0) {
                    this.getDataTraceChildsLoop(modelId, clickDimNumber, nextParamsMap, fMoney, isContainSon, childRows);
                }
                curRow.put("Childs", childRows);
                continue;
            }
            curRow.put("Childs", new HashMap());
        }
    }

    public List<Map<String, Object>> convertToList(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> row : list) {
            HashMap<String, Object> newRow = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("TraceData")) {
                    newRow.put(entry.getKey(), entry.getValue());
                    continue;
                }
                Map data = (Map)entry.getValue();
                newRow.put(entry.getKey(), data);
            }
            result.add(newRow);
        }
        return result;
    }

    private Map<String, Object> buildDisplayCoulmnMap(Map<String, Object> paramsMap) {
        String[] fixHead = staticFixHeads1;
        if (!this.isExistAuditTrailDimension()) {
            fixHead = staticFixHeads1ATCT;
        }
        HashMap<String, Object> newParamsMap = new HashMap<String, Object>(paramsMap.size());
        for (String colName : fixHead) {
            newParamsMap.put(colName, paramsMap.get(colName));
        }
        fixHead = new String[]{"Process", "AuditTrail"};
        if (!this.isExistAuditTrailDimension()) {
            fixHead = new String[]{"Process"};
        }
        for (String colName : fixHead) {
            newParamsMap.put(colName, paramsMap.get(colName));
        }
        for (Map.Entry entry : paramsMap.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("Year") || ((String)entry.getKey()).equalsIgnoreCase("Period") || ((String)entry.getKey()).equalsIgnoreCase("Scenario") || newParamsMap.containsKey(entry.getKey())) continue;
            newParamsMap.put((String)entry.getKey(), entry.getValue());
        }
        return newParamsMap;
    }

    public List<Map<String, Object>> getNodesChilds(long modelId, String clickDimNumber, Map<String, Object> paramsMap, Object fMoney, boolean isContainSon) {
        this.globalModelId = modelId;
        this.globalModelNumber = MemberReader.findModelNumberById((Object)modelId);
        this.globalIsContainSon = isContainSon;
        this.globalDataBizMap = new HashMap<String, IDNumberTreeNode>(paramsMap.size());
        for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
            String entityNumber = MemberReader.getEntityNumberByDim((String)this.globalModelNumber, (String)entry.getKey());
            this.globalDataBizMap.put(entry.getKey(), MemberReader.findMemberById((long)modelId, (String)entityNumber, (Long)LongUtil.toLong((Object)entry.getValue().toString())));
        }
        Map<String, Object> displayMap = this.buildDisplayCoulmnMap(paramsMap);
        Sheet sheet = this.CreateSheet(displayMap);
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        int rowNumber = 1;
        for (int j = 0; j < sheet.getMaxColumnCount(); ++j) {
            Cell newCell = sheet.getCell(rowNumber, j);
            Cell dimCell = sheet.getCell(0, j);
            String dimNumber = dimCell.getUserObject("number").toString();
            if (this.globalDataBizMap.containsKey(dimNumber)) {
                IDNumberTreeNode idNumberTreeNode = this.globalDataBizMap.get(dimNumber);
                newCell.setValue((Object)idNumberTreeNode.getName());
                newCell.setUserObject("number", (Object)idNumberTreeNode.getNumber());
                newCell.setUserObject("name", (Object)idNumberTreeNode.getName());
                newCell.setUserObject("id", (Object)idNumberTreeNode.getId());
                newCell.setUserObject("level", (Object)idNumberTreeNode.getLevel());
                if (idNumberTreeNode.isLeaf()) {
                    newCell.setUserObject("isleaf", (Object)"1");
                }
            } else if (dimNumber.equalsIgnoreCase(fMoneyColName)) {
                newCell.setValue(fMoney);
            } else if (dimNumber.equalsIgnoreCase(rMoneyColName)) {
                newCell.setValue(fMoney);
            }
            newCell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
        }
        return this.addNewRow(rowNumber, columnIndexMap.get(clickDimNumber), sheet);
    }

    public Sheet CreateSheet(Map<String, Object> columnsMap) {
        Sheet sheet = new Sheet();
        int curIndex = 0;
        for (Map.Entry<String, Object> entry : columnsMap.entrySet()) {
            Cell cell = sheet.getCell(0, curIndex);
            IDNumberTreeNode idNumberTreeNode = this.globalDataBizMap.get(entry.getKey());
            cell.setValue((Object)idNumberTreeNode.getName());
            cell.setUserObject("number", (Object)idNumberTreeNode.getDimNumber());
            cell.setUserObject("dimId", (Object)idNumberTreeNode.getDimId());
            ++curIndex;
        }
        Cell cell = sheet.getCell(0, curIndex);
        cell.setValue((Object)ResManager.loadKDString((String)"\u8ffd\u6eaf\u6570", (String)"DataTracePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        cell.setUserObject("number", (Object)fMoneyColName);
        Cell cell2 = sheet.getCell(0, ++curIndex);
        cell2.setValue((Object)ResManager.loadKDString((String)"\u8868\u683c\u6570", (String)"DataTracePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        cell2.setUserObject("number", (Object)rMoneyColName);
        return sheet;
    }

    private List<Map<String, Object>> addNewRow(int rowNumber, int colNumber, Sheet sheet) {
        long modelId = this.globalModelId;
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        Cell clickCell = sheet.getCell(rowNumber, colNumber);
        SearchHelper.updateSelectCellValue(rowNumber, colNumber, clickCell, cellValues);
        Cell clickDimCell = sheet.getCell(0, colNumber);
        String clickDimNumber = (String)clickDimCell.getUserObject("number");
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get(unfoldFiled).intValue());
        Map<String, String> orgCurrencyMap = SearchHelper.getCurrencyByOrg(sheet, Long.parseLong(orgCell.getUserObject("id").toString()), modelId);
        BaseConvertFormula convertFormula = ConvertSchemeServiceHelper.getBaseConvertFormula((long)modelId, (long)0L);
        Map<String, List<String>> unfoldMap = DataTraceHelper.getUnfoldMapForProcess(orgCurrencyMap, convertFormula, this.isExistAuditTrailDimension(), Boolean.FALSE);
        return this.dealNewRowUnfoldByOrg(rowNumber, sheet, modelId, columnIndexMap, clickCell, clickDimNumber, orgCurrencyMap, convertFormula, unfoldMap);
    }

    private List<Map<String, Object>> dealNewRowUnfoldByOrg(int rowNumber, Sheet sheet, Long modelId, Map<String, Integer> columnIndexMap, Cell clickCell, String clickDimNumber, Map<String, String> orgCurrencyMap, BaseConvertFormula convertFormula, Map<String, List<String>> unfoldMap) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String unfoledDim = clickDimNumber;
        Cell unfoledCell = clickCell;
        DynamicObjectCollection lookupOrgs = null;
        DynamicObjectCollection extendsOrgs = new DynamicObjectCollection();
        Cell fMoney = sheet.getCell(rowNumber, columnIndexMap.get(fMoneyColName).intValue());
        Boolean money = DataTraceHelper.checkZero(fMoney.getValue());
        Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
        Cell currencyCell = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue());
        Cell auditTrailCell = new Cell();
        if (columnIndexMap.containsKey("AuditTrail")) {
            auditTrailCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
        }
        HashMap<String, DynamicObject> orgDimMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, HashMap<String, String>> auditOrEcChildren = null;
        QFilter qFilter = new QFilter("id", "=", sheet.getCell(rowNumber, columnIndexMap.get(unfoldFiled).intValue()).getUserObject("id"));
        DynamicObject currentOrg = QueryServiceHelper.queryOne((String)DimEntityNumEnum.getEntieyNumByNumber((String)unfoldFiled), (String)"id,name,number,isleaf,level,longnumber", (QFilter[])new QFilter[]{qFilter});
        orgDimMap.put(currentOrg.getString("number"), currentOrg);
        Boolean flag = money != false && Objects.nonNull(auditTrailCell) && Objects.equals("ATTotal", auditTrailCell.getUserObject("number"));
        DynamicObjectCollection nextChildrenforAudittail = this.getSonInfo(sheet, modelId, auditTrailCell, "AuditTrail", columnIndexMap, unfoldMap, orgCurrencyMap, false, flag);
        if (unfoldFiled.equalsIgnoreCase(unfoledDim)) {
            if (processCell.getUserObject("isleaf") == null || flag.booleanValue()) {
                unfoledDim = "Process";
                unfoledCell = processCell;
            } else if (DataTraceHelper.getProcessForUnfold(sheet, rowNumber, unfoldMap, columnIndexMap, flag) != null) {
                unfoledDim = "Process";
                unfoledCell = processCell;
            } else if (auditTrailCell.getUserObject("isleaf") == null) {
                unfoledDim = "AuditTrail";
                unfoledCell = auditTrailCell;
            } else {
                return result;
            }
        }
        int colNumber = columnIndexMap.get(unfoledDim);
        DynamicObject atTotalObj = this.getSingleDynamicObject("AuditTrail", "ATTotal");
        DynamicObject erptObj = this.getSingleDynamicObject("Process", "ERpt");
        DynamicObjectCollection sonInfo = this.getSonInfo(sheet, modelId, unfoledCell, unfoledDim, columnIndexMap, unfoldMap, orgCurrencyMap, money, flag);
        DynamicObjectCollection nextChildren = this.getSonInfo(sheet, modelId, unfoledCell, unfoledDim, columnIndexMap, unfoldMap, orgCurrencyMap, null, flag);
        if ((sonInfo = this.filterEffectiveMember(unfoledDim, sonInfo, this.globalDataBizMap.get("Year").getNumber(), this.globalDataBizMap.get("Period").getId(), this.globalDataBizMap.get("Scenario").getId())) == null || sonInfo.isEmpty()) {
            return result;
        }
        if (money.booleanValue()) {
            lookupOrgs = this.getEffectiveOrg(rowNumber, sheet, columnIndexMap, currentOrg.getString("longnumber"));
            lookupOrgs.add((Object)currentOrg);
        }
        boolean isUnfoldDimOrg = false;
        if ("Process".equalsIgnoreCase(unfoledDim) && DataTraceHelper.isCanUnfoldProcessEC(sheet, rowNumber, columnIndexMap, unfoldMap)) {
            isUnfoldDimOrg = true;
            extendsOrgs = this.getEffectiveOrg(rowNumber, sheet, columnIndexMap, null);
        } else {
            extendsOrgs.add((Object)currentOrg);
        }
        this.buildSonNode(Objects.nonNull(lookupOrgs) ? lookupOrgs : extendsOrgs, orgDimMap);
        MDResultSet set = this.getDataFromOLAP(sheet, rowNumber, colNumber, sonInfo, columnIndexMap, Objects.nonNull(lookupOrgs) ? lookupOrgs : extendsOrgs, unfoldMap, atTotalObj, unfoledDim, convertFormula, orgCurrencyMap, erptObj, money);
        if (money.booleanValue() && Objects.nonNull(auditOrEcChildren = this.isAuditChidData(isUnfoldDimOrg, set, extendsOrgs, unfoledDim, nextChildren, currencyCell.getUserObject("number").toString(), unfoldMap, columnIndexMap, auditTrailCell, modelId, flag, nextChildrenforAudittail)) && auditOrEcChildren.keySet().contains("AuditTrail")) {
            unfoledDim = "AuditTrail";
            unfoledCell = auditTrailCell;
            sonInfo = nextChildrenforAudittail;
        }
        List<Map<String, Object>> realList = this.getRealListUnfoldByOrg(unfoledDim, set, extendsOrgs, nextChildren, isUnfoldDimOrg, money, auditOrEcChildren, currentOrg, this.globalDataBizMap.get("Currency").getNumber());
        this.filterRealList(realList, unfoledDim, columnIndexMap, sheet, unfoledCell, money);
        if (realList.isEmpty()) {
            return result;
        }
        HashMap<String, DynamicObject> sonDimMap = new HashMap<String, DynamicObject>(16);
        this.buildSonNode(sonInfo, sonDimMap);
        int curRowNumber = rowNumber;
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : realList) {
            Object value = row.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
            if (value == null) continue;
            rows.add(this.buildSingleNewRow(rowNumber, ++curRowNumber, sheet, sonDimMap, columnIndexMap, row, atTotalObj, unfoledDim, unfoldMap, orgDimMap, orgCurrencyMap, convertFormula, erptObj));
        }
        return rows;
    }

    private Map<String, Object> buildSingleNewRow(int rowNumber, int curRowNumber, Sheet sheet, Map<String, DynamicObject> sonDimMap, Map<String, Integer> columnIndexMap, Map<String, Object> row, DynamicObject atTotalObj, String clickDimNumber, Map<String, List<String>> unfoldMap, Map<String, DynamicObject> orgDimMap, Map<String, String> orgCurrencyMap, BaseConvertFormula convertFormula, DynamicObject erptObj) {
        HashMap<String, Object> rowData = new HashMap<String, Object>(columnIndexMap.size());
        for (int j = 0; j < sheet.getMaxColumnCount(); ++j) {
            Cell dimCell = sheet.getCell(0, j);
            Cell curCell = sheet.getCell(curRowNumber, j);
            if (dimCell.getUserObject("number") == null) continue;
            String dimNumber = dimCell.getUserObject("number").toString();
            if (dimNumber.equals(clickDimNumber)) {
                this.buildSingleCellData(curCell, sonDimMap.get(row.get(clickDimNumber)), dimNumber);
                continue;
            }
            if (dimNumber.equals(unfoldFiled) && "Process".equalsIgnoreCase(clickDimNumber) && DataTraceHelper.isCanUnfoldProcessEC(sheet, rowNumber, columnIndexMap, unfoldMap)) {
                String orgNum = (String)row.get(unfoldFiled);
                if (orgNum == null || orgNum.length() == 0) continue;
                this.buildSingleCellData(curCell, orgDimMap.get(orgNum), dimNumber);
                continue;
            }
            if (this.isExistAuditTrailDimension() && dimNumber.equals("AuditTrail") && (Objects.equals(clickDimNumber, "Process") && DataTraceHelper.isIRptEC(sheet, rowNumber, columnIndexMap, unfoldMap) || DataTraceHelper.needChangeAudiForIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap, convertFormula))) {
                this.buildSingleCellData(curCell, atTotalObj, dimNumber);
                continue;
            }
            if (dimNumber.equals("Process") && "Currency".equalsIgnoreCase(clickDimNumber) && DataTraceHelper.isIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap)) {
                this.buildSingleCellData(curCell, erptObj, dimNumber);
                continue;
            }
            if (dimNumber.equalsIgnoreCase(fMoneyColName)) {
                curCell.setValue(row.get(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                curCell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
                continue;
            }
            if (!this.globalDataBizMap.containsKey(dimNumber)) continue;
            curCell.setUserObject("number", (Object)this.globalDataBizMap.get(dimNumber).getNumber());
            curCell.setUserObject("name", (Object)this.globalDataBizMap.get(dimNumber).getName());
            curCell.setUserObject("id", (Object)this.globalDataBizMap.get(dimNumber).getId());
            curCell.setUserObject("level", (Object)this.globalDataBizMap.get(dimNumber).getLevel());
            curCell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
            curCell.setUserObject("isNeedAddPlus", (Object)(this.globalDataBizMap.get(dimNumber).isLeaf() ? false : this.isNeedAddPlus(unfoldFiled, dimNumber)));
            if (!this.globalDataBizMap.get(dimNumber).isLeaf()) continue;
            curCell.setUserObject("isleaf", (Object)1);
        }
        Cell processCell = sheet.getCell(curRowNumber, columnIndexMap.get("Process").intValue());
        Cell auditCell = sheet.getCell(curRowNumber, columnIndexMap.get("AuditTrail").intValue());
        Cell orgCell = sheet.getCell(curRowNumber, columnIndexMap.get(unfoldFiled).intValue());
        if (unfoldFiled.equalsIgnoreCase(unfoldFiled)) {
            if (processCell.getUserObject("isleaf") == null || auditCell.getUserObject("isleaf") == null || orgCell.getUserObject("isleaf") == null && DataTraceHelper.getProcessForUnfold(sheet, curRowNumber, unfoldMap, columnIndexMap, false) != null) {
                orgCell.setUserObject("isNeedAddPlus", (Object)true);
            }
        } else if (orgCell.getUserObject("isleaf") == null && DataTraceHelper.getProcessForUnfold(sheet, curRowNumber, unfoldMap, columnIndexMap, false) != null) {
            orgCell.setUserObject("isNeedAddPlus", (Object)true);
        }
        Map short2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.globalModelNumber);
        String clickDimShortNumber = this.getClickDimShortNumber(clickDimNumber, short2NumberMap);
        Recorder noAgg = new Recorder((Object)false);
        for (int j = 0; j < sheet.getMaxColumnCount(); ++j) {
            String[] dimShortNumbers;
            Cell dimCell = sheet.getCell(0, j);
            Cell curCell = sheet.getCell(curRowNumber, j);
            if (dimCell.getUserObject("number") == null) continue;
            String dimNumber = dimCell.getUserObject("number").toString();
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (curCell.getUserObject("cellFlag") == null || dimNumber.equalsIgnoreCase(fMoneyColName)) continue;
            data.put("MemberId", curCell.getUserObject("id"));
            data.put("MemberName", curCell.getUserObject("name"));
            data.put("MemberNumber", curCell.getUserObject("number"));
            data.put("IsNeedAddPlus", curCell.getUserObject("isNeedAddPlus"));
            rowData.put(dimNumber, data);
            if (dimNumber.equals(unfoldFiled) || dimNumber.equals("Process")) continue;
            IDNumberTreeNode expandMember = MemberReader.findMemberByNumber((String)this.globalModelNumber, (String)dimNumber, (String)curCell.getUserObject("number").toString());
            if (clickDimNumber.equals(dimNumber)) {
                noAgg.setRecord((Object)((Boolean)noAgg.getRecord() != false || AggOprtEnum.SKIP.name.equals(expandMember.getAggOprt()) ? 1 : 0));
                continue;
            }
            String rule = ShieldRuleBulider.getRuleStrByMem((Object)expandMember.getDimId(), (Object)expandMember.getId());
            if (rule == null) continue;
            for (String num : dimShortNumbers = rule.split(",")) {
                if (!num.equals(clickDimShortNumber)) continue;
                noAgg.setRecord((Object)true);
            }
        }
        rowData.put("IsIgnoreRow", noAgg.getRecord());
        rowData.put("Hyperlink", this.dealSpecialCell(sheet, columnIndexMap, curRowNumber));
        rowData.put("TraceData", row.get(FacTabFieldDefEnum.FIELD_MONEY.getField()));
        return rowData;
    }

    private String getClickDimShortNumber(String clickDimNumber, Map<String, String> short2NumberMap) {
        for (Map.Entry<String, String> entry : short2NumberMap.entrySet()) {
            if (!entry.getValue().equals(clickDimNumber)) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean dealSpecialCell(Sheet sheet, Map<String, Integer> columnIndexMap, int inserRowNum) {
        Cell audiCell = null;
        String audiNum = null;
        if (this.isExistAuditTrailDimension()) {
            audiCell = sheet.getCell(inserRowNum, columnIndexMap.get("AuditTrail").intValue());
            audiNum = audiCell.getUserObject("number").toString();
        }
        Cell processCell = sheet.getCell(inserRowNum, columnIndexMap.get("Process").intValue());
        Cell accountCell = sheet.getCell(inserRowNum, columnIndexMap.get("Account").intValue());
        return !doNotShowHyperlink.contains(processCell.getUserObject("number").toString()) && (!"EJE".equals(processCell.getUserObject("number").toString()) || "EJE".equals(processCell.getUserObject("number").toString()) && processCell.getUserObject("isleaf") != null) && audiNum != null && this.isEntryAdjusted(audiNum) && accountCell.getUserObject("isleaf") != null;
    }

    private boolean isEntryAdjusted(String number) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.globalModelId);
        qFilter.and("number", "=", (Object)number);
        DynamicObject auditTrailObject = QueryServiceHelper.queryOne((String)DimEntityNumEnum.getEntieyNumByNumber((String)"AuditTrail"), (String)"datasource", (QFilter[])new QFilter[]{qFilter});
        String datasource = auditTrailObject.getString("datasource");
        return "3".equals(datasource);
    }

    private void buildSingleCellData(Cell cell, DynamicObject dim, String clickDimNumber) {
        boolean isNeedAdd = false;
        if (dim.getBoolean("isleaf")) {
            isNeedAdd = false;
            cell.setUserObject("isleaf", (Object)1);
        } else if (this.isNeedAddPlus(unfoldFiled, clickDimNumber)) {
            isNeedAdd = true;
        }
        cell.setValue((Object)dim.getString("name"));
        cell.setUserObject("number", (Object)dim.getString("number"));
        cell.setUserObject("name", (Object)dim.getString("name"));
        cell.setUserObject("id", (Object)dim.getLong("id"));
        cell.setUserObject("level", (Object)dim.getString("level"));
        cell.setUserObject("isNeedAddPlus", (Object)isNeedAdd);
        cell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
    }

    private List<Map<String, Object>> getRealListUnfoldByOrg(String clickDimNumber, MDResultSet set, DynamicObjectCollection currentOrgs, DynamicObjectCollection sonInfo, boolean isUnfoldDimOrg, boolean money, HashMap<String, HashMap<String, String>> auditOrEcChildren, DynamicObject currentOrg, String currency) {
        Set extendDims = sonInfo.parallelStream().map(s -> s.getString("number")).collect(Collectors.toSet());
        List<Object> effectList = new ArrayList(0);
        if (set != null && set.getFetchSize() != 0) {
            effectList = this.getEffectOLAPResultList(clickDimNumber, set, currentOrgs);
        }
        LinkedList<Map<String, Object>> realList = new LinkedList<Map<String, Object>>();
        Map<String, Row> rowMap = null;
        Row exist = effectList.stream().filter(row -> row.getString("Currency").equals(currency)).findAny().orElse(null);
        if (money && effectList.size() == 0) {
            if (Objects.nonNull(auditOrEcChildren) && auditOrEcChildren.size() > 0) {
                if (isUnfoldDimOrg) {
                    for (Map.Entry<String, HashMap<String, String>> entry : auditOrEcChildren.entrySet()) {
                        HashMap<String, String> values = entry.getValue();
                        for (Map.Entry<String, String> temp : values.entrySet()) {
                            HashMap<String, Object> tempRow = new HashMap<String, Object>(4);
                            tempRow.put(entry.getKey(), temp.getValue());
                            tempRow.put(DimTypesEnum.ENTITY.getNumber(), temp.getKey());
                            tempRow.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                            realList.add(tempRow);
                        }
                    }
                    return realList;
                }
                for (Map.Entry<String, HashMap<String, String>> entry : auditOrEcChildren.entrySet()) {
                    HashMap<String, String> values = entry.getValue();
                    for (Map.Entry<String, String> temp : values.entrySet()) {
                        HashMap<String, Object> tempRow = new HashMap<String, Object>(4);
                        tempRow.put(entry.getKey(), temp.getKey());
                        tempRow.put(DimTypesEnum.ENTITY.getNumber(), currentOrg.getString("number"));
                        tempRow.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                        realList.add(tempRow);
                    }
                }
                return realList;
            }
        } else if (money && effectList.size() > 0) {
            effectList = effectList.parallelStream().filter(row -> sonInfo.parallelStream().map(s -> s.getString("number")).collect(Collectors.toList()).contains(row.getString(clickDimNumber))).collect(Collectors.toList());
        }
        rowMap = this.getRowMap(isUnfoldDimOrg, effectList, clickDimNumber);
        if (isUnfoldDimOrg) {
            for (DynamicObject son : sonInfo) {
                for (DynamicObject org : currentOrgs) {
                    HashMap<String, Object> tmp = new HashMap<String, Object>();
                    String sonNumber = son.getString("number");
                    String orgNumber = org.getString("number");
                    String number = sonNumber + "_" + orgNumber;
                    tmp.put(clickDimNumber, sonNumber);
                    tmp.put(unfoldFiled, orgNumber);
                    if (rowMap.containsKey(number) && rowMap.get(number) != null) {
                        if (money) {
                            if (Objects.nonNull(exist) && !Objects.equals(currency, rowMap.get(number).getString("Currency"))) continue;
                            if (!(Objects.nonNull(exist) || Objects.equals(currency, rowMap.get(number).getString("Currency")) || Objects.equals(clickDimNumber, "Currency"))) {
                                tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                                tmp.put("Currency", rowMap.get(number).getString("Currency"));
                            } else {
                                tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), rowMap.get(number).getBigDecimal("FMONEY"));
                            }
                            if (!extendDims.contains(rowMap.get(number).getString(clickDimNumber))) {
                                tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                            }
                        } else {
                            tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), rowMap.get(number).getBigDecimal("FMONEY"));
                        }
                        realList.add(tmp);
                        continue;
                    }
                    if (!this.globalIsContainSon) continue;
                    tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                    realList.add(tmp);
                }
            }
        } else {
            for (DynamicObject son : sonInfo) {
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                String number = son.getString("number");
                tmp.put(clickDimNumber, number);
                tmp.put(unfoldFiled, currentOrg.getString("number"));
                if (!rowMap.containsKey(number) || rowMap.get(number) == null) continue;
                if (money) {
                    if (Objects.nonNull(exist) && !Objects.equals(currency, rowMap.get(number).getString("Currency"))) {
                        tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                        tmp.put("Currency", rowMap.get(number).getString("Currency"));
                    }
                    if (!(Objects.nonNull(exist) || Objects.equals(currency, rowMap.get(number).getString("Currency")) || Objects.equals(clickDimNumber, "Currency"))) {
                        tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                        tmp.put("Currency", rowMap.get(number).getString("Currency"));
                    } else {
                        tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), rowMap.get(number).getBigDecimal("FMONEY"));
                    }
                    if (!extendDims.contains(rowMap.get(number).getString(clickDimNumber))) {
                        tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                    }
                } else {
                    tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), rowMap.get(number).getBigDecimal("FMONEY"));
                }
                realList.add(tmp);
            }
        }
        return realList;
    }

    private Map<String, Row> getRowMap(boolean isUnfoldDimOrg, List<Row> effectList, String clickDimNumber) {
        HashMap<String, Row> rowMap = new HashMap<String, Row>(16);
        for (Row row : effectList) {
            if (isUnfoldDimOrg) {
                String orgNumber = row.getString(unfoldFiled);
                if (orgNumber != null && orgNumber.split("_").length > 1) {
                    orgNumber = orgNumber.split("_")[1];
                }
                rowMap.put(row.getString(clickDimNumber) + "_" + orgNumber, row);
                continue;
            }
            rowMap.put(row.getString(clickDimNumber), row);
        }
        return rowMap;
    }

    private List<Row> getEffectOLAPResultList(String clickDimNumber, MDResultSet set, DynamicObjectCollection orgSonCol) {
        ArrayList<Row> effectList = new ArrayList<Row>(set.getFetchSize());
        MDResultSetMetaData md = set.getMetaData();
        Set<String> orgs = orgSonCol.stream().map(s -> s.getString("number")).collect(Collectors.toSet());
        int orgIndex = -1;
        int processIndex = -1;
        for (MDColumn mdColumn : md.getMetaDatas()) {
            if (unfoldFiled.equalsIgnoreCase(mdColumn.getMdName())) {
                orgIndex = mdColumn.getColIndex();
                continue;
            }
            if (!"Process".equalsIgnoreCase(mdColumn.getMdName())) continue;
            processIndex = mdColumn.getColIndex();
        }
        while (set.next()) {
            Row row = set.getRow();
            if (this.judgeIsIgnore(orgIndex, processIndex, clickDimNumber, row) || !this.orgsIsContains(orgs, row, Objects.equals(orgIndex, -1))) continue;
            effectList.add(row);
        }
        return effectList;
    }

    private DynamicObjectCollection filterEffectiveMember(String clickDimNumber, DynamicObjectCollection sonInfo, String yearNumber, long periodId, long scenarId) {
        if ("AuditTrail".equals(clickDimNumber)) {
            sonInfo = this.getAuditTrailCol(sonInfo);
        }
        if (unfoldFiled.equalsIgnoreCase(clickDimNumber)) {
            FilterOrgStructParam param = new FilterOrgStructParam(this.globalModelId, scenarId, yearNumber, periodId);
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)sonInfo);
        }
        return sonInfo;
    }

    private DynamicObjectCollection getSonInfo(Sheet sheet, long modelId, Cell clickCell, String clickDimNumber, Map<String, Integer> columnIndexMap, Map<String, List<String>> unfoldMap, Map<String, String> orgCurrencyMap, Boolean money, Boolean ignoreAT) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject current = BusinessDataServiceHelper.loadSingle((Object)clickCell.getUserObject("id"), (String)DimEntityNumEnum.getEntieyNumByNumber((String)clickDimNumber));
        int rowNumber = clickCell.getRow();
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get(unfoldFiled).intValue());
        Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
        Cell currencyCell = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue());
        Cell audiCell = null;
        if (columnIndexMap.containsKey("AuditTrail")) {
            audiCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
        }
        if ("Process".equalsIgnoreCase(clickDimNumber) && DataTraceHelper.getProcessForUnfold(sheet, rowNumber, unfoldMap, columnIndexMap, ignoreAT) != null) {
            qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
            qFilter.and("number", "in", DataTraceHelper.getProcessForUnfold(sheet, rowNumber, unfoldMap, columnIndexMap, ignoreAT));
        } else if ("Currency".equalsIgnoreCase(clickDimNumber)) {
            qFilter.and("number", "=", (Object)orgCurrencyMap.get(orgCell.getUserObject("number").toString()));
        } else {
            qFilter.and("parent.id", "=", clickCell.getUserObject("id"));
        }
        if (Objects.equals(money, true)) {
            if ("Process".equalsIgnoreCase(clickDimNumber)) {
                DynamicObjectCollection result = new DynamicObjectCollection();
                result = DataTraceHelper.getAllChildrenNodes("Process", processCell.getUserObject("number").toString(), LongUtil.toLong((Object)processCell.getUserObject("id")), currencyCell.getUserObject("number").toString(), unfoldMap, columnIndexMap, result, modelId, audiCell, ignoreAT);
                return result.parallelStream().distinct().collect(Collectors.toCollection(DynamicObjectCollection::new));
            }
            if ("Currency".equalsIgnoreCase(clickDimNumber)) {
                qFilter.and("number", "=", (Object)orgCurrencyMap.get(orgCell.getUserObject("number").toString()));
            } else {
                qFilter = new QFilter("model", "=", (Object)modelId).and(new QFilter("longnumber", "like", (Object)(current.getString("longnumber") + "%")));
            }
        }
        return QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)clickDimNumber), (String)"id,name,number,isleaf,level,storagetype", (QFilter[])new QFilter[]{qFilter}, (String)"dseq asc");
    }

    private MDResultSet getDataFromOLAP(Sheet sheet, int rowNumber, int colNumber, DynamicObjectCollection sonInfo, Map<String, Integer> columnIndexMap, DynamicObjectCollection orgSonCol, Map<String, List<String>> unfoldMap, DynamicObject atTotalObj, String clickDimNumber, BaseConvertFormula convertFormula, Map<String, String> orgCurrencyMap, DynamicObject erptObj, Boolean money) {
        SQLBuilder sql = new SQLBuilder(this.globalModelNumber);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sql.addFilter("Year", new String[]{this.globalDataBizMap.get("Year").getNumber()});
        sql.addFilter("Period", new String[]{this.globalDataBizMap.get("Period").getNumber()});
        sql.addFilter("Scenario", new String[]{this.globalDataBizMap.get("Scenario").getNumber()});
        if (this.setOLAPFilterFromSheet(sheet, rowNumber, colNumber, sonInfo, columnIndexMap, orgSonCol, unfoldMap, atTotalObj, sql, convertFormula, orgCurrencyMap, erptObj, clickDimNumber)) {
            return null;
        }
        if (!"Process".equalsIgnoreCase(clickDimNumber) && !this.isInSelectDimList(clickDimNumber)) {
            if (!this.isExistAuditTrailDimension()) {
                if (money.booleanValue()) {
                    sql.addSelectField(new String[]{clickDimNumber, "Process", "Currency", unfoldFiled});
                } else {
                    sql.addSelectField(new String[]{clickDimNumber, "Process", "Currency"});
                }
            } else if (money.booleanValue()) {
                sql.addSelectField(new String[]{clickDimNumber, "Process", "AuditTrail", "Currency", unfoldFiled});
            } else {
                sql.addSelectField(new String[]{clickDimNumber, "Process", "AuditTrail", "Currency"});
            }
        } else if (!this.isExistAuditTrailDimension()) {
            sql.addSelectField(selectDimListATCT);
        } else {
            sql.addSelectField(selectDimList);
        }
        return OlapServiceHelper.queryData((SQLBuilder)sql);
    }

    private boolean setOLAPFilterFromSheet(Sheet sheet, int rowNumber, int colNumber, DynamicObjectCollection sonInfo, Map<String, Integer> columnIndexMap, DynamicObjectCollection orgSonCol, Map<String, List<String>> unfoldMap, DynamicObject atTotalObj, SQLBuilder sql, BaseConvertFormula convertFormula, Map<String, String> orgCurrencyMap, DynamicObject erptObj, String clickDimNumber) {
        Cell fMoney = sheet.getCell(rowNumber, columnIndexMap.get(fMoneyColName).intValue());
        Boolean money = DataTraceHelper.checkZero(fMoney.getValue());
        for (int i = 0; i < sheet.getMaxColumnCount(); ++i) {
            Cell cell;
            Cell currentDimCell = sheet.getCell(0, i);
            String dimNumber = (String)currentDimCell.getUserObject("number");
            if (i == colNumber) {
                sql.addFilter(dimNumber, DataTraceHelper.getMembersFromCollection(sonInfo));
                continue;
            }
            if ("AuditTrail".equalsIgnoreCase(dimNumber) && (Objects.equals(clickDimNumber, "Process") || Objects.equals(clickDimNumber, "Currency")) && (DataTraceHelper.isIRptEC(sheet, rowNumber, columnIndexMap, unfoldMap) || DataTraceHelper.needChangeAudiForIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap, convertFormula))) {
                sql.addFilter(dimNumber, new String[]{atTotalObj.getString("number")});
                continue;
            }
            if (unfoldFiled.equalsIgnoreCase(dimNumber)) {
                DynamicObjectCollection col;
                if (money.booleanValue() && Objects.nonNull(orgSonCol) && !orgSonCol.isEmpty()) {
                    sql.addFilter(dimNumber, this.dealOrgMemForOLAP(orgSonCol, Arrays.asList(DataTraceHelper.getMembersFromCollection(sonInfo))));
                    continue;
                }
                if ("Process".equalsIgnoreCase(clickDimNumber)) {
                    if (DataTraceHelper.isCanUnfoldProcessEC(sheet, rowNumber, columnIndexMap, unfoldMap)) {
                        if (Objects.isNull(orgSonCol) || orgSonCol.isEmpty()) {
                            return true;
                        }
                        sql.addFilter(dimNumber, this.dealOrgMemForOLAP(orgSonCol, DataTraceHelper.getProcessForUnfold(sheet, rowNumber, unfoldMap, columnIndexMap, false)));
                        continue;
                    }
                    col = this.getOrgByOrgCell(sheet, rowNumber, columnIndexMap);
                    sql.addFilter(dimNumber, this.dealOrgMemForOLAP(col, Arrays.asList(DataTraceHelper.getMembersFromCollection(sonInfo))));
                    continue;
                }
                col = this.getOrgByOrgCell(sheet, rowNumber, columnIndexMap);
                Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
                sql.addFilter(dimNumber, this.dealOrgMemForOLAP(col, Collections.singletonList(processCell.getUserObject("number").toString())));
                continue;
            }
            if ("Currency".equalsIgnoreCase(clickDimNumber) && "Process".equalsIgnoreCase(dimNumber) && DataTraceHelper.isIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap)) {
                sql.addFilter(dimNumber, new String[]{erptObj.getString("number")});
                continue;
            }
            if (money.booleanValue() && ("Currency".equalsIgnoreCase(dimNumber) || "AuditTrail".equalsIgnoreCase(dimNumber)) || (cell = sheet.getCell(rowNumber, i)).getUserObject("number") == null) continue;
            sql.addFilter(dimNumber, new String[]{cell.getUserObject("number").toString()});
        }
        return false;
    }

    private HashMap<String, HashMap<String, String>> isAuditChidData(Boolean unfoledDim, MDResultSet set, DynamicObjectCollection orgSonCol, String extenddim, DynamicObjectCollection nextChild, String currencyNumber, Map<String, List<String>> unfoldMap, Map<String, Integer> columnIndexMap, Cell audiCell, Long modelId, Boolean flag, DynamicObjectCollection nextChildrenforAudittail) {
        set.beforeFirst();
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>(16);
        HashMap<String, String> resultmap = new HashMap<String, String>(16);
        HashSet<String> validchildren = new HashSet<String>(set.getCount());
        String myextenddim = extenddim;
        Set extendDims = nextChild.parallelStream().map(s -> s.getString("number")).collect(Collectors.toSet());
        Set extendOrgs = orgSonCol.parallelStream().map(s -> s.getString("number")).collect(Collectors.toSet());
        Set extendAts = nextChildrenforAudittail.parallelStream().map(s -> s.getString("number")).collect(Collectors.toSet());
        List<String> belongtoMerOrg = Arrays.asList("CT", "CSTE", "SRPT", "ADJT", "SADJ", "SCADJ", "SCCADJ", "DADJ", "EJET", "SEJE", "DEJE");
        while (set.next()) {
            String auditchild;
            Row row = set.getRow();
            int orgIndex = -1;
            MDResultSetMetaData md = set.getMetaData();
            md.getMetaDatas().parallelStream().filter(s -> Objects.equals(s.getMdName(), unfoldFiled));
            for (MDColumn mdColumn : md.getMetaDatas()) {
                if (!unfoldFiled.equalsIgnoreCase(mdColumn.getMdName())) continue;
                orgIndex = mdColumn.getColIndex();
            }
            String orgNum = null;
            if (orgIndex != -1) {
                orgNum = row.getString(DimTypesEnum.ENTITY.getNumber());
                if (orgNum == null || orgNum.length() == 0) {
                    return null;
                }
                String[] orgNums = orgNum.split("_");
                if (orgNums.length > 1) {
                    orgNum = orgNums[1];
                }
            }
            if (extendDims.contains(row.getString(extenddim)) && extendOrgs.contains(orgNum) && extendAts.contains(row.getString("AuditTrail"))) {
                set.beforeFirst();
                return null;
            }
            String child = this.getExistNode(extenddim, nextChild, row.getString(extenddim), currencyNumber, unfoldMap, columnIndexMap, audiCell, modelId);
            if (Objects.nonNull(child) && extendDims.contains(child) && (!Objects.equals(((DynamicObject)orgSonCol.get(0)).getBoolean("isleaf"), true) || !belongtoMerOrg.contains(child))) {
                validchildren.add(child);
                if (unfoledDim.booleanValue()) {
                    if (resultmap.containsKey(orgNum)) {
                        String process;
                        String currentProcess = row.getString(extenddim);
                        if (DataTraceHelper.getParentNumber(currentProcess, process = (String)resultmap.get(orgNum), modelId)) {
                            resultmap.put(orgNum, row.getString(extenddim));
                        }
                    } else {
                        resultmap.put(orgNum, child);
                    }
                } else {
                    resultmap.put(child, orgNum);
                }
            }
            if (!flag.booleanValue() || validchildren.size() != 0 || !Objects.nonNull(auditchild = this.getExistNode("AuditTrail", nextChildrenforAudittail, row.getString("AuditTrail"), currencyNumber, unfoldMap, columnIndexMap, audiCell, modelId)) || !extendAts.contains(auditchild)) continue;
            resultmap.put("AuditTrail", auditchild);
            myextenddim = "AuditTrail";
        }
        set.beforeFirst();
        if (resultmap.size() > 0) {
            result.put(myextenddim, resultmap);
        }
        return result;
    }

    private String getExistNode(String extenddim, DynamicObjectCollection nextChild, String value, String currencyNumber, Map<String, List<String>> unfoldMap, Map<String, Integer> columnIndexMap, Cell audiCell, Long modelId) {
        String resultstring = null;
        for (DynamicObject temp : nextChild) {
            if (Objects.equals(temp.getString("number"), value)) {
                return temp.getString("number");
            }
            DynamicObjectCollection result = new DynamicObjectCollection();
            DataTraceHelper.getAllChildrenNodes(extenddim, temp.getString("number"), temp.getLong("id"), currencyNumber, unfoldMap, columnIndexMap, result, modelId, audiCell, false);
            if (!result.parallelStream().anyMatch(s -> Objects.equals(s.getString("number"), value))) continue;
            return temp.getString("number");
        }
        return resultstring;
    }

    private void filterRealList(List<Map<String, Object>> realList, String unfoldDimNumber, Map<String, Integer> columnIndexMap, Sheet sheet, Cell unfoldCell, Boolean money) {
        if (realList == null || realList.isEmpty()) {
            return;
        }
        Iterator<Map<String, Object>> it = realList.iterator();
        while (it.hasNext()) {
            Map<String, Object> rowData = it.next();
            if (rowData.get(FacTabFieldDefEnum.FIELD_MONEY.getField()) != BigDecimal.ZERO || money.booleanValue() || !this.isNotNormalData(rowData, unfoldDimNumber, columnIndexMap, sheet, unfoldCell.getRow())) continue;
            it.remove();
        }
    }

    private boolean isNotNormalData(Map<String, Object> rowData, String clickDimNumber, Map<String, Integer> columnIndexMap, Sheet sheet, int row) {
        if (this.isProcessOrAuditTrailUnfold(clickDimNumber)) {
            String processDim = rowData.get("Process") != null ? rowData.get("Process").toString() : String.valueOf(sheet.getCell(row, columnIndexMap.get("Process").intValue()).getUserObject("number"));
            String auditDim = rowData.get("AuditTrail") != null ? rowData.get("AuditTrail").toString() : String.valueOf(sheet.getCell(row, columnIndexMap.get("AuditTrail").intValue()).getUserObject("number"));
            return DataTraceHelper.isLeafNodeData(processDim, auditDim, this.globalModelId);
        }
        if ("Currency".equalsIgnoreCase(clickDimNumber)) {
            return false;
        }
        boolean isleaf = MemberReader.findMemberByNumber((String)this.globalModelNumber, (String)clickDimNumber, (String)String.valueOf(rowData.get(clickDimNumber))).isLeaf();
        Cell processCell = sheet.getCell(row, columnIndexMap.get("Process").intValue());
        Cell auditCell = sheet.getCell(row, columnIndexMap.get("AuditTrail").intValue());
        return isleaf && auditCell.getUserObject("isleaf") != null && processCell.getUserObject("isleaf") != null;
    }

    private DynamicObject getSingleDynamicObject(String dimName, String memNumber) {
        QFilter qFilter2 = new QFilter("model", "=", (Object)this.globalModelId);
        qFilter2.and("number", "=", (Object)memNumber);
        DynamicObject atTotalObj = QueryServiceHelper.queryOne((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimName), (String)"id,name,number,isleaf,level", (QFilter[])new QFilter[]{qFilter2});
        return atTotalObj;
    }

    private DynamicObjectCollection getAuditTrailCol(DynamicObjectCollection col) {
        ArrayList<Long> atIds = new ArrayList<Long>(10);
        for (DynamicObject at : col) {
            Long id = at.getLong("id");
            atIds.add(id);
        }
        QFilter qFilter = new QFilter("model", "=", (Object)this.globalModelId);
        qFilter.and("id", "in", atIds);
        qFilter.and("aggoprt", "!=", (Object)"5");
        DynamicObjectCollection col1 = QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)"AuditTrail"), (String)"id", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection colNew = new DynamicObjectCollection();
        block1: for (DynamicObject dt1 : col1) {
            String id1 = dt1.getString("id");
            for (DynamicObject at : col) {
                String id = at.getString("id");
                if (!id1.equals(id)) continue;
                colNew.add((Object)at);
                continue block1;
            }
        }
        return colNew;
    }

    private boolean isExistAuditTrailDimension() {
        return MemberReader.isExistDimension((String)this.globalModelNumber, (String)PresetConstant.AUDITTRIAL_DIM);
    }

    private DynamicObjectCollection getEffectiveOrg(int rowNumber, Sheet sheet, Map<String, Integer> columnIndexMap, String isNeedChildData) {
        ArrayList<Long> yearIdList = new ArrayList<Long>(10);
        ArrayList<Long> periodIdList = new ArrayList<Long>(10);
        yearIdList.add(this.globalDataBizMap.get("Year").getId());
        periodIdList.add(this.globalDataBizMap.get("Period").getId());
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get(unfoldFiled).intValue());
        String mergeOrgNum = orgCell.getUserObject("number").toString();
        Set noMergeOrgNumSet = MergeControlHelper.getNoMergeByNumber((Long)this.globalModelId, (Long)this.globalDataBizMap.get("Scenario").getId(), (Long)((Long)yearIdList.get(0)), (Long)((Long)periodIdList.get(0)));
        DynamicObjectCollection orgCols = this.getBasicDimSon(unfoldFiled, sheet.getCell(rowNumber, columnIndexMap.get(unfoldFiled).intValue()).getUserObject("id").toString(), isNeedChildData);
        DynamicObjectCollection orgSonList = new DynamicObjectCollection();
        for (DynamicObject org : orgCols) {
            if (noMergeOrgNumSet.contains(mergeOrgNum + "!" + org.getString("number"))) continue;
            orgSonList.add((Object)org);
        }
        return this.filterByOrgVersion(orgSonList);
    }

    private DynamicObjectCollection filterByOrgVersion(DynamicObjectCollection dynamicObjects) {
        Long modelId = this.globalModelId;
        String yearNumber = this.globalDataBizMap.get("Year").getNumber();
        long periodId = this.globalDataBizMap.get("Period").getId();
        long sceneId = this.globalDataBizMap.get("Scenario").getId();
        FilterOrgStructParam param = new FilterOrgStructParam(modelId.longValue(), sceneId, yearNumber, periodId);
        ArrayList orgList = new ArrayList(dynamicObjects.size());
        dynamicObjects.forEach(org -> orgList.add(org));
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, orgList);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.addAll(orgList);
        return collection;
    }

    private DynamicObjectCollection getBasicDimSon(String dimName, String member, String isNeedChildData) {
        QFilter qFilter2 = new QFilter("model", "=", (Object)this.globalModelId);
        QFilter qFilter = new QFilter("parent.id", "=", (Object)LongUtil.toLong((Object)member));
        if (Objects.nonNull(isNeedChildData)) {
            QFilter qf = new QFilter("longnumber", "like", (Object)(isNeedChildData + "!%"));
            return QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimName), (String)"id,name,number,isleaf,level,longnumber", (QFilter[])new QFilter[]{qFilter2, qf}, (String)"dseq asc");
        }
        return QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimName), (String)"id,name,number,isleaf,level,longnumber", (QFilter[])new QFilter[]{qFilter2, qFilter}, (String)"dseq asc");
    }

    private void buildSonNode(DynamicObjectCollection col, Map<String, DynamicObject> sonDimMap) {
        for (DynamicObject dim : col) {
            sonDimMap.put(dim.getString("number"), dim);
        }
    }

    private String[] dealOrgMemForOLAP(DynamicObjectCollection col, List<String> memNumbers) {
        HashSet<String> memSet = new HashSet<String>(16);
        for (DynamicObject obj : col) {
            String number = obj.getString("number");
            for (String mem : memNumbers) {
                String newMember = number;
                if (mem != null && OrgRelaProcessMembPool.isRelaProcess((String)mem)) {
                    OrgRelaMembSupplier supplier = new OrgRelaMembSupplier(Long.valueOf(obj.getLong("id")), number, Long.valueOf(this.globalModelId));
                    newMember = supplier.access(newMember);
                }
                memSet.add(newMember);
            }
        }
        return memSet.toArray(new String[memSet.size()]);
    }

    private DynamicObjectCollection getOrgByOrgCell(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap) {
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get(unfoldFiled).intValue());
        DynamicObjectCollection col = new DynamicObjectCollection();
        DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
        org.set("id", (Object)Long.valueOf(orgCell.getUserObject("id").toString()));
        org.set("number", (Object)orgCell.getUserObject("number").toString());
        col.add((Object)org);
        return col;
    }

    private boolean isInSelectDimList(String clickDimNumber) {
        boolean result = false;
        for (String dimNum : selectDimList) {
            if (!dimNum.equalsIgnoreCase(clickDimNumber)) continue;
            result = true;
        }
        return result;
    }

    private boolean isProcessOrAuditTrailUnfold(String clickDimNumber) {
        return "Process".equalsIgnoreCase(clickDimNumber) || "AuditTrail".equalsIgnoreCase(clickDimNumber);
    }

    private boolean judgeIsIgnore(int orgIndex, int processIndex, String dimName, Row row) {
        boolean isIgnore = false;
        if (orgIndex != -1 && processIndex != -1 && "Process".equalsIgnoreCase(dimName)) {
            String[] orgNum = row.getValue(orgIndex).toString().split("_");
            if (OrgRelaProcessMembPool.isRelaProcess((String)row.getValue(processIndex).toString())) {
                if (orgNum.length != 2) {
                    isIgnore = true;
                }
            } else if (orgNum.length == 2) {
                isIgnore = true;
            }
        }
        return isIgnore;
    }

    private boolean orgsIsContains(Set<String> orgs, Row row, boolean notexsitOrg) {
        if (notexsitOrg) {
            return true;
        }
        String orgNum = row.getString(DimTypesEnum.ENTITY.getNumber());
        if (Objects.nonNull(orgNum)) {
            String[] orgNums = orgNum.split("_");
            if (orgNums.length > 1) {
                orgNum = orgNums[1];
            }
            return orgs.contains(orgNum);
        }
        return true;
    }

    private boolean isNeedAddPlus(String unfoldFiled, String clickDimName) {
        if (unfoldFiled.equalsIgnoreCase(clickDimName) && "Process".equalsIgnoreCase(unfoldFiled)) {
            return false;
        }
        return !"Process".equalsIgnoreCase(clickDimName) && !"AuditTrail".equalsIgnoreCase(clickDimName) && !unfoldFiled.equalsIgnoreCase(clickDimName) || !unfoldFiled.equalsIgnoreCase(unfoldFiled);
    }
}

