/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.spread.domain.view.Book;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.FreeStyleTemplateFinalBuilder;
import kd.fi.bcm.spread.model.IDimMember;

public class ExcelActionHelper {
    private ExcelActionHelper() {
    }

    public static List<Map<String, Object>> buildCrossInfo(SpreadManager sm, TemplateModel templateModel, IRelaMembSupplier<String, String> periodSupplier, boolean noReport) {
        if (noReport) {
            FreeStyleTemplateFinalBuilder templateBuilder = new FreeStyleTemplateFinalBuilder(sm, templateModel);
            templateBuilder.doBuildReport(false, false);
        }
        ArrayList<Map<String, Object>> setSets = new ArrayList<Map<String, Object>>();
        StringBuilder keys = new StringBuilder();
        Book book = sm.getBook();
        book.getSheet(0).iteratorCells(cell -> {
            if (cell.isMdDataDomain()) {
                ExcelActionHelper.packDimKeyByMember(cell.getMemberFromUserObject(), keys, periodSupplier);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("r", cell.getRow());
                map.put("c", cell.getCol());
                map.put("v", keys.toString());
                setSets.add(map);
            }
        });
        return setSets;
    }

    public static void execBizRuleWhenSave(Object templateId, String modelNum, ApplicationTypeEnum app, Map<String, Object> commonParam) {
        BizRuleExecParam param = ExcelActionHelper.getBizRuleExecParamSave(modelNum, commonParam);
        BizRuleExecStarter.execBizRuleWhenSave((Object)templateId, (BizRuleExecParam)param, (ApplicationTypeEnum)app);
    }

    public static void execBizRuleWhenOpen(Object templateId, SpreadManager SM, String modelNum, ApplicationTypeEnum app, Map<String, Object> commonParam) {
        BizRuleExecParam param = ExcelActionHelper.getBizRuleExecParam(SM, modelNum, commonParam);
        BizRuleExecStarter.execBizRuleWhenOpen((Object)templateId, (BizRuleExecParam)param, (ApplicationTypeEnum)app);
    }

    private static BizRuleExecParam getBizRuleExecParam(SpreadManager SM, String modelNum, Map<String, Object> param) {
        Map<DimTypesEnum, Object> map = ExcelActionHelper.getCurrentReportCommonParam("number", param);
        Map<DimTypesEnum, Object> idMap = ExcelActionHelper.getCurrentReportCommonParam("id", param);
        Long currencyId = 0L;
        Long orgId = (Long)idMap.get(DimTypesEnum.ENTITY);
        Long periodId = (Long)idMap.get(DimTypesEnum.PERIOD);
        String yearNum = map.get(DimTypesEnum.YEAR).toString();
        String currency = param.get("currencyNumber").toString();
        if (CurrencyEnum.EC.getNumber().equals(currency) || CurrencyEnum.DC.getNumber().equals(currency)) {
            DynamicObject currencyDynaObj = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgId, (String)yearNum, (Long)periodId);
            map.put(DimTypesEnum.CURRENCY, currencyDynaObj.getString("number"));
            idMap.put(DimTypesEnum.CURRENCY, currencyDynaObj.getLong("id"));
            currency = currencyDynaObj.getString("number");
            currencyId = currencyDynaObj.getLong("id");
        }
        BizRuleExecParam p = new BizRuleExecParam(modelNum);
        ExcelActionHelper.setBizCommonParam(p, DimTypesEnum.ENTITY, map, idMap);
        ExcelActionHelper.setBizCommonParam(p, DimTypesEnum.YEAR, map, idMap);
        ExcelActionHelper.setBizCommonParam(p, DimTypesEnum.PERIOD, map, idMap);
        ExcelActionHelper.setBizCommonParam(p, DimTypesEnum.SCENARIO, map, idMap);
        if (currency != null) {
            p.addCommonParamPair(DimTypesEnum.CURRENCY.getNumber(), currencyId, currency);
        }
        String process = null;
        String audittrial = null;
        if (SM.getFilter() != null) {
            process = SpreadMemUtil.getMemFromFilter((SpreadManager)SM, (String)DimTypesEnum.PROCESS.getNumber());
            if (StringUtils.isNotEmpty((String)process)) {
                p.addCommonParamPair(DimTypesEnum.PROCESS.getNumber(), MemberReader.findProcessMemberByNum((String)modelNum, (String)process).getId(), process);
            }
            if (MemberReader.isExistAuditTrailDimension((String)modelNum) && StringUtils.isNotEmpty((String)(audittrial = SpreadMemUtil.getMemFromFilter((SpreadManager)SM, (String)DimTypesEnum.AUDITTRIAL.getNumber())))) {
                p.addExternalCommParams(DimTypesEnum.AUDITTRIAL.getNumber(), new String[]{audittrial});
            }
        }
        return p;
    }

    private static BizRuleExecParam getBizRuleExecParamSave(String modelNum, Map<String, Object> param) {
        Map<DimTypesEnum, Object> map = ExcelActionHelper.getCurrentReportCommonParam("number", param);
        Map<DimTypesEnum, Object> idMap = ExcelActionHelper.getCurrentReportCommonParam("id", param);
        Object currency = map.get(DimTypesEnum.CURRENCY);
        Long currencyId = 0L;
        Long orgId = (Long)idMap.get(DimTypesEnum.ENTITY);
        Long periodId = (Long)idMap.get(DimTypesEnum.PERIOD);
        String yearNum = map.get(DimTypesEnum.YEAR).toString();
        if (CurrencyEnum.EC.getNumber().equals(currency) || CurrencyEnum.DC.getNumber().equals(currency)) {
            DynamicObject currencyDynaObj = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgId, (String)yearNum, (Long)periodId);
            map.put(DimTypesEnum.CURRENCY, currencyDynaObj.getString("number"));
            idMap.put(DimTypesEnum.CURRENCY, currencyDynaObj.getLong("id"));
            currency = currencyDynaObj.getString("number");
            currencyId = currencyDynaObj.getLong("id");
        }
        BizRuleExecParam p = new BizRuleExecParam(modelNum);
        ExcelActionHelper.setBizCommonParam(p, DimTypesEnum.ENTITY, map, idMap);
        ExcelActionHelper.setBizCommonParam(p, DimTypesEnum.YEAR, map, idMap);
        ExcelActionHelper.setBizCommonParam(p, DimTypesEnum.PERIOD, map, idMap);
        ExcelActionHelper.setBizCommonParam(p, DimTypesEnum.SCENARIO, map, idMap);
        if (currency != null) {
            p.addCommonParamPair(DimTypesEnum.CURRENCY.getNumber(), currencyId, (String)currency);
        }
        if (null != param.get("processId")) {
            Long processId = LongUtil.toLong((Object)param.get("processId"));
            p.addCommonParamPair(DimTypesEnum.PROCESS.getNumber(), processId, MemberReader.findProcessMemberById((String)modelNum, (Long)processId).getNumber());
        }
        return p;
    }

    private static void setBizCommonParam(BizRuleExecParam p, DimTypesEnum dimType, Map<DimTypesEnum, Object> numMap, Map<DimTypesEnum, Object> idMap) {
        if (numMap.containsKey(dimType)) {
            p.addCommonParamPair(dimType.getNumber(), (Long)idMap.get(dimType), (String)numMap.get(dimType));
        }
    }

    private static Map<DimTypesEnum, Object> getCurrentReportCommonParam(String filtField, Map<String, Object> param) {
        HashMap<DimTypesEnum, Object> commonParam = new HashMap<DimTypesEnum, Object>();
        if ("number".equals(filtField)) {
            commonParam.put(DimTypesEnum.SCENARIO, param.get("scenarioNmber"));
            commonParam.put(DimTypesEnum.YEAR, param.get("yearNumber"));
            commonParam.put(DimTypesEnum.PERIOD, param.get("periodNumber"));
            commonParam.put(DimTypesEnum.CURRENCY, param.get("currencyNumber"));
            commonParam.put(DimTypesEnum.ENTITY, param.get("entityNumber"));
        } else if ("id".equals(filtField)) {
            commonParam.put(DimTypesEnum.SCENARIO, param.get("scenarioId"));
            commonParam.put(DimTypesEnum.YEAR, param.get("yearId"));
            commonParam.put(DimTypesEnum.PERIOD, param.get("periodId"));
            commonParam.put(DimTypesEnum.CURRENCY, param.get("currencyId"));
            commonParam.put(DimTypesEnum.ENTITY, param.get("entityId"));
        }
        return commonParam;
    }

    private static void packDimKeyByMember(List<IDimMember> members, StringBuilder keys, IRelaMembSupplier<String, String> periodSupplier) {
        keys.setLength(0);
        members.forEach(e -> {
            String dim = e.getDimension().getNumber();
            String member = e.getNumber();
            if (PresetConstant.PERIOD_DIM.equals(dim) && ("CurrentPeriod".equals(member) || "LastPeriod".equals(member))) {
                String changePeriod = (String)periodSupplier.access((Object)member);
                member = changePeriod.isEmpty() ? member : changePeriod;
            } else if (PresetConstant.FY_DIM.equals(dim) && ("CurrentYear".equals(member) || "LastYear".equals(member))) {
                String changeYear = (String)periodSupplier.access((Object)member);
                member = changeYear.isEmpty() ? member : changeYear;
            }
            keys.append(dim).append('!').append(member).append(';');
        });
        keys.deleteCharAt(keys.length() - 1);
    }

    public static TemplateModel getTemplateModelById(Long templateid) {
        String templateSerial = (String)AppCacheServiceHelper.get((String)templateid.toString(), String.class);
        TemplateModel template = new TemplateModel();
        if (StringUtils.isEmpty((String)templateSerial)) {
            DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)templateid, (String)"bcm_templateentity");
            template.loadDynaObj2Model(templateDy);
            AppCacheServiceHelper.put((String)templateid.toString(), (Object)ObjectSerialUtil.toByteSerialized((Object)template));
        } else {
            template = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
        }
        return template;
    }
}

