/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.AnalyticsSolutionScopeEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.excel.dto.ExcelApiOutput;
import kd.fi.bcm.formplugin.excel.dto.adhoc.AdHocSolution;
import kd.fi.bcm.formplugin.excel.dto.adhoc.AdHocSolutionDimMember;
import kd.fi.bcm.formplugin.excel.dto.adhoc.AdHocSolutionTotal;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public final class ExcelAdHocSolutionAction {
    private static final String PARAM_MODELID = "modelId";
    private static final String PARAM_DIMENSIONID = "DimensionId";
    private static final String PARAM_DIMENSIONINDEX = "DimensionIndex";
    private static final String PARAM_MEMBER = "Member";
    private static final String FIELD_MODELID = "model_id";
    private static final String MODEL = "model";
    private static final String FIELD_SCOPE = "scope";
    private static final String FIELD_SOLUTIONNAME = "solutionname";
    private static final String FIELD_CREATEUSERID = "createuserid";

    private ExcelAdHocSolutionAction() {
    }

    public static List<AdHocSolution> getSolutionList(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get(PARAM_MODELID));
        String name = StringUtils.getStringValue((Object)param.get("name"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(FIELD_MODELID, "=", (Object)modelId));
        if (StringUtils.isNotEmpty((String)name)) {
            qFilters.add(new QFilter(FIELD_SOLUTIONNAME, "like", (Object)("%" + param.get("name").toString() + "%")));
        }
        ArrayList hasWritePermIds = new ArrayList(6);
        long userId = RequestContext.get().getCurrUserId();
        boolean isAdminModel = MemberPermHelper.isModelManager((Long)modelId);
        if (!isAdminModel) {
            ArrayListMultimap permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_analyticssoluentry", (String)Long.toString(modelId), (String)Long.toString(userId));
            List noPermissionIds = permissionMap.containsKey((Object)DataTypeEnum.NO.getIndex()) ? permissionMap.get((Object)DataTypeEnum.NO.getIndex()) : new ArrayList(6);
            hasWritePermIds = permissionMap.containsKey((Object)DataTypeEnum.WRITEIN.getIndex()) ? permissionMap.get((Object)DataTypeEnum.WRITEIN.getIndex()) : new ArrayList(6);
            qFilters.add(new QFilter(FIELD_SCOPE, "in", (Object)AnalyticsSolutionScopeEnum.getScopValues()).or(FIELD_CREATEUSERID, "=", (Object)userId));
            if (!noPermissionIds.isEmpty()) {
                qFilters.add(new QFilter("id", "not in", noPermissionIds));
            }
        }
        ArrayList<AdHocSolution> solutions = new ArrayList<AdHocSolution>(16);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_analyticssoluentry", (String)"id,solutionnumber,solutionname,turnstatus,scope,explanation,model as model_id,showmemberstyle,moneyunit,hiderow,hidecol,createuserid", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"solutionname asc");
        int i = 1;
        for (DynamicObject dyObject : doc) {
            AdHocSolution solution = ExcelAdHocSolutionAction.getSolution(dyObject, i++);
            if (isAdminModel) {
                solution.setHasWritePerm(true);
            } else if (AnalyticsSolutionScopeEnum.PERM_CLASS.getKey() == solution.getScope()) {
                solution.setHasWritePerm(hasWritePermIds.contains(solution.getId()));
            } else {
                solution.setHasWritePerm(userId == solution.getCreatorId());
            }
            solutions.add(solution);
        }
        return solutions;
    }

    public static List<AdHocSolutionDimMember> getSolutionDimMembers(Map<String, Object> param) {
        Long solutionId = LongUtil.toLong((Object)param.get("solutionId"));
        DynamicObject dyObject = BusinessDataServiceHelper.loadSingle((Object)solutionId, (String)"bcm_analyticssoluentry");
        return ExcelAdHocSolutionAction.getDimMembers(dyObject);
    }

    public static ExcelApiOutput saveSolution(Map<String, Object> solution) {
        DynamicObject solutionDyObj;
        long modelId = LongUtil.toLong((Object)solution.get("ModelId"));
        long solutionId = LongUtil.toLong((Object)solution.get("Id"));
        long permClassId = LongUtil.toLong((Object)solution.get("PermClassId"));
        String solutionNumber = solution.get("Number").toString();
        String solutionName = solution.get("Name").toString();
        List allDimMembers = (List)solution.get("DimMembers");
        OperationStatus status = OperationStatus.ADDNEW;
        long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        QFilter qf = new QFilter(MODEL, "=", (Object)modelId);
        if (solutionId == 0L) {
            qf.and(FIELD_SOLUTIONNAME, "=", (Object)solutionName);
            if (QueryServiceHelper.exists((String)"bcm_analyticssoluentry", (QFilter[])qf.toArray())) {
                return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            solutionId = GlobalIdUtil.genGlobalLongId();
            if (StringUtil.isEmptyString((String)solutionNumber)) {
                solutionNumber = CodeRuleUtil.getCodeRuleNumber("bcm_analyticssoluentry", "createtime");
            }
            solutionDyObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_analyticssoluentry");
            solutionDyObj.set(FIELD_CREATEUSERID, (Object)userId);
            solutionDyObj.set("createtime", (Object)now);
            solutionDyObj.set("id", (Object)solutionId);
            solutionDyObj.set("turnstatus", (Object)"2");
            solutionDyObj.set(MODEL, (Object)modelId);
        } else {
            status = OperationStatus.EDIT;
            qf.and(FIELD_SOLUTIONNAME, "=", (Object)solutionName);
            qf.and("id", "!=", (Object)solutionId);
            if (QueryServiceHelper.exists((String)"bcm_analyticssoluentry", (QFilter[])qf.toArray())) {
                return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            solutionDyObj = BusinessDataServiceHelper.loadSingle((Object)solutionId, (String)"bcm_analyticssoluentry");
            if (!MemberPermHelper.isModelManager((Long)modelId)) {
                List noPermissionIds;
                int scope = Integer.parseInt(solutionDyObj.getString(FIELD_SCOPE));
                ArrayListMultimap permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_analyticssoluentry", (String)Long.toString(modelId), (String)Long.toString(userId));
                List list = noPermissionIds = permissionMap.containsKey((Object)DataTypeEnum.WRITEIN.getIndex()) ? permissionMap.get((Object)DataTypeEnum.WRITEIN.getIndex()) : new ArrayList(6);
                if (AnalyticsSolutionScopeEnum.PERM_CLASS.getKey() == scope) {
                    if (!noPermissionIds.contains(solutionDyObj.getLong("id"))) {
                        String tips = String.format(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u7c7b\u6743\u9650\u4e0d\u53ef\u4fee\u6539\u65b9\u6848\u3010%1$s\u3011", (String)"ExcelAdHocSolutionAction_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), solutionDyObj.getString(FIELD_SOLUTIONNAME));
                        return new ExcelApiOutput(false, tips);
                    }
                } else if (userId != solutionDyObj.getLong(FIELD_CREATEUSERID)) {
                    String tips = String.format(ResManager.loadKDString((String)"\u975e\u65b9\u6848\u521b\u5efa\u4eba\u4e0d\u53ef\u4fee\u6539\u65b9\u6848\u3010%1$s\u3011", (String)"ExcelAdHocSolutionAction_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), solutionDyObj.getString(FIELD_SOLUTIONNAME));
                    return new ExcelApiOutput(false, tips);
                }
            }
        }
        solutionDyObj.set("solutionnumber", (Object)solutionNumber);
        solutionDyObj.set(FIELD_SOLUTIONNAME, (Object)solutionName);
        solutionDyObj.set(FIELD_SCOPE, (Object)Character.valueOf(String.valueOf(solution.get("Scope").toString()).charAt(0)));
        solutionDyObj.set("explanation", (Object)solution.get("Explanation").toString());
        solutionDyObj.set("updateuserid", (Object)userId);
        solutionDyObj.set("updatetime", (Object)now);
        if (solution.containsKey("MemberName")) {
            solutionDyObj.set("showmemberstyle", solution.get("MemberName"));
        }
        if (solution.containsKey("MetaTable")) {
            solutionDyObj.set("moneyunit", solution.get("MetaTable"));
        }
        if (solution.containsKey("HideRow")) {
            solutionDyObj.set("hiderow", solution.get("HideRow"));
        }
        if (solution.containsKey("HideCol")) {
            solutionDyObj.set("hidecol", solution.get("HideCol"));
        }
        if (allDimMembers != null && !allDimMembers.isEmpty()) {
            DynamicObjectCollection pageDim = solutionDyObj.getDynamicObjectCollection("pagedim");
            DynamicObjectCollection rowDim = solutionDyObj.getDynamicObjectCollection("rowdim");
            DynamicObjectCollection colDim = solutionDyObj.getDynamicObjectCollection("coldim");
            DynamicObjectCollection totalRow = solutionDyObj.getDynamicObjectCollection("totalrow");
            if (status == OperationStatus.EDIT) {
                pageDim.clear();
                rowDim.clear();
                colDim.clear();
                totalRow.clear();
            }
            List pageDimMembers = allDimMembers.stream().filter(x -> (Integer)x.get("Type") == 4).collect(Collectors.toList());
            for (Object dimMembers : pageDimMembers) {
                DynamicObject newRow = pageDim.addNew();
                newRow.set("dimid", (Object)LongUtil.toLong(dimMembers.get(PARAM_DIMENSIONID)));
                newRow.set("dimid_id", (Object)LongUtil.toLong(dimMembers.get(PARAM_DIMENSIONID)));
                newRow.set("orderindex_id", dimMembers.get(PARAM_DIMENSIONINDEX));
                newRow.set("menberid", (Object)dimMembers.get(PARAM_MEMBER).toString());
            }
            List rowDimMembers = allDimMembers.stream().filter(x -> (Integer)x.get("Type") == 2).collect(Collectors.toList());
            for (Object dimMembers : rowDimMembers) {
                DynamicObject newRow = rowDim.addNew();
                newRow.set("rowdimid", (Object)LongUtil.toLong(dimMembers.get(PARAM_DIMENSIONID)));
                newRow.set("rowdimid_id", (Object)LongUtil.toLong(dimMembers.get(PARAM_DIMENSIONID)));
                newRow.set("roworderindex_id", dimMembers.get(PARAM_DIMENSIONINDEX));
                newRow.set("rowmenberid", (Object)dimMembers.get(PARAM_MEMBER).toString());
            }
            List colDimMembers = allDimMembers.stream().filter(x -> (Integer)x.get("Type") == 1).collect(Collectors.toList());
            for (Map dimMembers : colDimMembers) {
                DynamicObject newRow = colDim.addNew();
                newRow.set("columndimid", (Object)LongUtil.toLong(dimMembers.get(PARAM_DIMENSIONID)));
                newRow.set("columndimid_id", (Object)LongUtil.toLong(dimMembers.get(PARAM_DIMENSIONID)));
                newRow.set("colorderindex_id", dimMembers.get(PARAM_DIMENSIONINDEX));
                newRow.set("columnmenberid", (Object)dimMembers.get(PARAM_MEMBER).toString());
            }
            if (solution.containsKey("Totals")) {
                List totals = (List)solution.get("Totals");
                for (Map total : totals) {
                    DynamicObject newRow = totalRow.addNew();
                    newRow.set("type", total.get("Type"));
                    newRow.set("rowindex", total.get("RowIndex"));
                    newRow.set("colindex", total.get("ColIndex"));
                    newRow.set("value", total.get("Value"));
                    newRow.set("formula", total.get("Formula"));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{solutionDyObj});
        ExcelAdHocSolutionAction.savePermClassEntity(modelId, solutionId, permClassId, status);
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848", (String)"AnalyticsSolutionService_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String opDescribe = String.format(ResManager.loadKDString((String)"%s\u4fdd\u5b58\u6210\u529f", (String)"AnalyticsSolutionSaveOtherPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), solutionName);
        OperationLogUtil.writeOperationLog((String)opName, (String)opDescribe, (Long)modelId, (String)"bcm_analyticssoluentry");
        return new ExcelApiOutput(solutionId);
    }

    public static ExcelApiOutput deleteSolution(Map<String, Object> param) {
        long modelId = (Long)param.get(PARAM_MODELID);
        List solutionIds = (List)param.get("solutionIds");
        QFilter qFilter1 = new QFilter(FIELD_MODELID, "=", (Object)modelId);
        QFilter qFilter2 = new QFilter("id", "in", (Object)solutionIds);
        DynamicObjectCollection dos = QueryServiceHelper.query((String)"bcm_analyticssoluentry", (String)"id,solutionname,scope,createuserid", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (!MemberPermHelper.isModelManager((Long)modelId)) {
            long userId = RequestContext.get().getCurrUserId();
            StringBuilder sb = new StringBuilder();
            ArrayListMultimap permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_analyticssoluentry", (String)Long.toString(modelId), (String)Long.toString(userId));
            List noPermissionIds = permissionMap.containsKey((Object)DataTypeEnum.WRITEIN.getIndex()) ? permissionMap.get((Object)DataTypeEnum.WRITEIN.getIndex()) : new ArrayList(6);
            for (DynamicObject d : dos) {
                int scope = Integer.parseInt(d.getString(FIELD_SCOPE));
                if (AnalyticsSolutionScopeEnum.PERM_CLASS.getKey() == scope) {
                    if (noPermissionIds.contains(d.getLong("id"))) continue;
                    if (sb.length() > 0) {
                        sb.append("\uff1b");
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u7c7b\u6743\u9650\u4e0d\u53ef\u5220\u9664\u65b9\u6848\u3010%1$s\u3011", (String)"ExcelAdHocSolutionAction_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), d.getString(FIELD_SOLUTIONNAME)));
                    continue;
                }
                if (userId == d.getLong(FIELD_CREATEUSERID)) continue;
                if (sb.length() > 0) {
                    sb.append("\uff1b");
                }
                sb.append(String.format(ResManager.loadKDString((String)"\u975e\u65b9\u6848\u521b\u5efa\u4eba\u4e0d\u53ef\u5220\u9664\u65b9\u6848\u3010%1$s\u3011", (String)"ExcelAdHocSolutionAction_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), d.getString(FIELD_SOLUTIONNAME)));
            }
            if (sb.length() > 0) {
                sb.append("\u3002");
                return new ExcelApiOutput(false, sb.toString());
            }
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_analyticssoluentry"), (Object[])solutionIds.toArray());
        String opName = ResManager.loadKDString((String)"\u5220\u9664\u65b9\u6848", (String)"AnalyticsSolutionsListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String description = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalyticsSolutionsListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        for (DynamicObject dy : dos) {
            String opDescription = String.format("%s%s", dy.getString(FIELD_SOLUTIONNAME), description);
            OperationLogUtil.writeOperationLog((String)opName, (String)opDescription, (Long)modelId, (String)"bcm_analyticssoluentry");
        }
        return new ExcelApiOutput(true);
    }

    public static AdHocSolution getSolution(Map<String, Object> param) {
        Long solutionId = LongUtil.toLong((Object)param.get("solutionId"));
        DynamicObject solutionDyObj = BusinessDataServiceHelper.loadSingle((Object)solutionId, (String)"bcm_analyticssoluentry");
        AdHocSolution solution = ExcelAdHocSolutionAction.getSolution(solutionDyObj, 1);
        List<AdHocSolutionDimMember> dimMembers = ExcelAdHocSolutionAction.getDimMembers(solutionDyObj);
        ArrayList<AdHocSolutionTotal> totals = new ArrayList<AdHocSolutionTotal>(16);
        DynamicObjectCollection doc = solutionDyObj.getDynamicObjectCollection("totalrow");
        for (DynamicObject dyObject : doc) {
            AdHocSolutionTotal total = new AdHocSolutionTotal();
            total.setId(dyObject.getLong("id"));
            total.setSolutionId(solutionId);
            total.setType(dyObject.getInt("type"));
            total.setRowIndex(dyObject.getInt("rowindex"));
            total.setColIndex(dyObject.getInt("colindex"));
            total.setValue(dyObject.getString("value"));
            total.setFormula(dyObject.getString("formula"));
            totals.add(total);
        }
        solution.setDimMembers(dimMembers);
        solution.setTotals(totals);
        return solution;
    }

    private static AdHocSolution getSolution(DynamicObject dyObject, int dseq) {
        DynamicObject permClass;
        AdHocSolution solution = new AdHocSolution();
        solution.setModelId(dyObject.getLong(FIELD_MODELID));
        solution.setId(dyObject.getLong("id"));
        solution.setNumber(dyObject.getString("solutionnumber"));
        solution.setName(dyObject.getString(FIELD_SOLUTIONNAME));
        solution.setType(dyObject.getString("turnstatus"));
        solution.setDseq(dseq);
        solution.setScope(dyObject.getInt(FIELD_SCOPE));
        solution.setExplanation(dyObject.getString("explanation"));
        solution.setMemberName(dyObject.getInt("showmemberstyle"));
        solution.setMetaTable(dyObject.getInt("moneyunit"));
        solution.setHiderow(dyObject.getInt("hiderow"));
        solution.setHidecol(dyObject.getInt("hidecol"));
        solution.setCreatorId(dyObject.getLong(FIELD_CREATEUSERID));
        if (solution.getScope() == AnalyticsSolutionScopeEnum.PERM_CLASS.getKey() && (permClass = PermClassEntityHelper.getPermissionClassEntity((String)"bcm_analyticssoluentry", (Long)solution.getId(), (Object)solution.getModelId())) != null) {
            solution.setPermClassId(permClass.getLong("permclass.id"));
            solution.setPermClassNumber(permClass.getString("permclass.number"));
        }
        return solution;
    }

    private static List<AdHocSolutionDimMember> getDimMembers(DynamicObject solutionDyObj) {
        AdHocSolutionDimMember dimMember;
        long solutionId = solutionDyObj.getLong("id");
        ArrayList<AdHocSolutionDimMember> dimMembers = new ArrayList<AdHocSolutionDimMember>(16);
        DynamicObjectCollection doc = solutionDyObj.getDynamicObjectCollection("coldim");
        for (DynamicObject dyObject : doc) {
            dimMember = new AdHocSolutionDimMember();
            dimMember.setType(1);
            dimMember.setId(dyObject.getLong("id"));
            dimMember.setSolutionId(solutionId);
            dimMember.setDimensionId(dyObject.getLong("columndimid_id"));
            dimMember.setMember(dyObject.getString("columnmenberid"));
            dimMember.setDimensionIndex(dyObject.getLong("colorderindex_id"));
            dimMembers.add(dimMember);
        }
        doc = solutionDyObj.getDynamicObjectCollection("rowdim");
        for (DynamicObject dyObject : doc) {
            dimMember = new AdHocSolutionDimMember();
            dimMember.setType(2);
            dimMember.setId(dyObject.getLong("id"));
            dimMember.setSolutionId(solutionId);
            dimMember.setDimensionId(dyObject.getLong("rowdimid_id"));
            dimMember.setMember(dyObject.getString("rowmenberid"));
            dimMember.setDimensionIndex(dyObject.getLong("roworderindex_id"));
            dimMembers.add(dimMember);
        }
        doc = solutionDyObj.getDynamicObjectCollection("pagedim");
        for (DynamicObject dyObject : doc) {
            dimMember = new AdHocSolutionDimMember();
            dimMember.setType(4);
            dimMember.setId(dyObject.getLong("id"));
            dimMember.setSolutionId(solutionId);
            dimMember.setDimensionId(dyObject.getLong("dimid_id"));
            dimMember.setMember(dyObject.getString("menberid"));
            dimMember.setDimensionIndex(dyObject.getLong("orderindex_id"));
            dimMembers.add(dimMember);
        }
        return dimMembers;
    }

    private static void savePermClassEntity(long modelId, long entityId, long permClassId, OperationStatus status) {
        DynamicObject dyn = PermClassEntityHelper.getDiscPermissionClassEntity((String)"bcm_analyticssoluentry", (Long)entityId, (Object)modelId, (String)MODEL, (String)"");
        if (permClassId > 0L) {
            if (status != OperationStatus.EDIT || dyn == null) {
                dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                dyn.set("entityname", (Object)"bcm_analyticssoluentry");
                dyn.set(MODEL, (Object)modelId);
                dyn.set("entityid", (Object)entityId);
            }
            dyn.set("permclass", (Object)permClassId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        } else if (dyn != null) {
            DeleteServiceHelper.delete((IDataEntityType)dyn.getDynamicObjectType(), (Object[])new Object[]{dyn.getPkValue()});
        }
    }
}

