/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustDataSaveParam;
import kd.fi.bcm.business.adjust.operation.AdjustClearOperation;
import kd.fi.bcm.business.adjust.operation.AdjustFlowCancelOperation;
import kd.fi.bcm.business.adjust.operation.AdjustFlowOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.adjust.operation.AdjustSaveOperation;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.excel.AbstractExcelAction;
import kd.fi.bcm.formplugin.excel.dto.DimMember;
import kd.fi.bcm.formplugin.excel.dto.ExcelApiOutput;
import kd.fi.bcm.formplugin.excel.dto.TemplateCatalog;
import kd.fi.bcm.formplugin.excel.dto.adjust.AdjustBussinessTypeModel;
import kd.fi.bcm.formplugin.excel.dto.adjust.AdjustDataModel;
import kd.fi.bcm.formplugin.excel.dto.adjust.AdjustLogModel;
import kd.fi.bcm.formplugin.excel.dto.adjust.AdjustOffsetModel;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import org.jetbrains.annotations.NotNull;

public class ExcelAdjustOffsetAction
extends AbstractExcelAction {
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    public static final List<String> normalSourceType = new ArrayList<String>(16);
    public static final List<BusinessTypeEnum> MergeBizTypes = new ArrayList<BusinessTypeEnum>(4);

    public ExcelAdjustOffsetAction(Map<String, Object> param) {
        super(param);
    }

    public List<AdjustOffsetModel> getRptAdjustOffsetList() {
        List ids = AdjustQueryServiceHelper.queryAdjustIds((long)this.getModelId(), (long)this.getScenarioId(), (long)this.getYearId(), (long)this.getPeriodId(), new HashSet((List)this.param.get("entityIds")), null).stream().collect(Collectors.toList());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        qFilters.add(new QFilter("id", "in", ids));
        qFilters.add(new QFilter("multiplecurrency", "=", (Object)"0"));
        qFilters.add(new QFilter("status", "in", (Object)((List)this.param.get("status"))));
        List classifications = (List)this.param.get("classifications");
        if (classifications.size() > 0) {
            qFilters.add(new QFilter("templatecatalog", "in", (Object)classifications.toArray()));
        }
        String selectField = "id,number,name,status,bussnesstype,balancetype,journaltype,entrysource,sourcetype,extendfrom,allshareorg,templatecatalog.name,templatecatalog.id,description,belongorg.name,belongorg.id";
        DynamicObjectCollection dySource = QueryServiceHelper.query((String)"bcm_rptadjust", (String)selectField, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"number");
        ArrayList<AdjustOffsetModel> offsets = new ArrayList<AdjustOffsetModel>(16);
        for (DynamicObject obj : dySource) {
            AdjustOffsetModel adjust = new AdjustOffsetModel();
            adjust.setId(obj.getLong("id"));
            adjust.setName(obj.getString("name"));
            adjust.setCode(obj.getString("number"));
            adjust.setStatus(obj.getInt("status"));
            adjust.setBussnessType(obj.getString("bussnesstype"));
            adjust.setBalanceCtrl(obj.getInt("balancetype"));
            adjust.setJournalType(obj.getInt("journaltype"));
            adjust.setEntrySource(obj.getInt("entrysource"));
            adjust.setSourceType(obj.getInt("sourcetype"));
            adjust.setSourceCode(obj.getString("extendfrom"));
            adjust.setBelongOrg(obj.getString("belongorg.name"));
            adjust.setBelongOrgId(obj.getLong("belongorg.id"));
            adjust.setClassificationName(obj.getString("templatecatalog.name"));
            adjust.setClassificationId(obj.getLong("templatecatalog.id"));
            adjust.setDescription(obj.getString("description"));
            offsets.add(adjust);
        }
        return offsets;
    }

    public List<AdjustOffsetModel> getRptAdjustOffsetListPage() {
        List ids = (List)this.param.get("pkIds");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("id", "in", (Object)ids));
        String selectField = "id,number,name,status,bussnesstype,balancetype,journaltype,entrysource,sourcetype,extendfrom,allshareorg,templatecatalog.name,templatecatalog.id,description,belongorg.name,belongorg.id";
        DynamicObjectCollection dySource = QueryServiceHelper.query((String)"bcm_rptadjust", (String)selectField, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"number");
        ArrayList<AdjustOffsetModel> offsets = new ArrayList<AdjustOffsetModel>(16);
        for (DynamicObject obj : dySource) {
            AdjustOffsetModel adjust = new AdjustOffsetModel();
            adjust.setId(obj.getLong("id"));
            adjust.setName(obj.getString("name"));
            adjust.setCode(obj.getString("number"));
            adjust.setStatus(obj.getInt("status"));
            adjust.setBussnessType(obj.getString("bussnesstype"));
            adjust.setBalanceCtrl(obj.getInt("balancetype"));
            adjust.setJournalType(obj.getInt("journaltype"));
            adjust.setEntrySource(obj.getInt("entrysource"));
            adjust.setSourceType(obj.getInt("sourcetype"));
            adjust.setSourceCode(obj.getString("extendfrom"));
            adjust.setBelongOrg(obj.getString("belongorg.name"));
            adjust.setBelongOrgId(obj.getLong("belongorg.id"));
            adjust.setClassificationName(obj.getString("templatecatalog.name"));
            adjust.setClassificationId(obj.getLong("templatecatalog.id"));
            adjust.setDescription(obj.getString("description"));
            offsets.add(adjust);
        }
        return offsets;
    }

    public List<Long> getOffsetListIds() {
        return this.getOffsetPkIdsByFilter();
    }

    private List<Long> getOffsetPkIdsByFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("adjust.multiplecurrency", "=", (Object)"0"));
        qFilters.add(new QFilter("adjust.status", "in", (Object)((List)this.param.get("status"))));
        List classifications = (List)this.param.get("classifications");
        if (classifications.size() > 0) {
            qFilters.add(new QFilter("adjust.templatecatalog", "in", (Object)classifications.toArray()));
        }
        List<Long> ids = AdjustQueryServiceHelper.queryAdjustIds((long)this.getModelId(), (long)this.getScenarioId(), (long)this.getYearId(), (long)this.getPeriodId(), new HashSet((List)this.param.get("entityIds")), qFilters, (String)"adjust.createtime desc", (boolean)true).stream().collect(Collectors.toList());
        return ids;
    }

    public List<TemplateCatalog> getRptAdjustCatalog() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        qfBuilder.add(new QFilter("catalogtype", "=", (Object)String.valueOf(TemplateCatalogTypeEnum.ADJCATALOG.getType())).or("parent.id", "=", (Object)0));
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        DynamicObjectCollection catalogori = QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,name,number,parent.id parent_id,longnumber,sequence", (QFilter[])qfBuilder.toArray(), (String)"sequence ASC");
        DynamicObjectCollection catalogs = new DynamicObjectCollection();
        if (!adminUserBol) {
            ArrayListMultimap permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_templatecatalog", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId());
            List noPerms = permissionMap.get((Object)DataTypeEnum.NO.getIndex());
            for (DynamicObject obj : catalogori) {
                if (noPerms.contains(obj.getLong("id"))) continue;
                catalogs.add((Object)obj);
            }
        } else {
            catalogs.addAll((Collection)catalogori);
        }
        ArrayList<TemplateCatalog> result = new ArrayList<TemplateCatalog>(catalogs.size());
        for (DynamicObject catalog : catalogs) {
            TemplateCatalog currentCatalog = new TemplateCatalog();
            currentCatalog.setId(catalog.getLong("id"));
            currentCatalog.setName(catalog.getString("name"));
            currentCatalog.setNumber(catalog.getString("number"));
            currentCatalog.setLongNumber(catalog.getString("longnumber"));
            currentCatalog.setDesq(catalog.getInt("sequence"));
            currentCatalog.setParentId(catalog.getLong("parent_id"));
            result.add(currentCatalog);
        }
        return result;
    }

    public ExcelApiOutput deleteRptAdjustOffsets() {
        List delRows = (List)this.param.get("delIds");
        AdjustClearOperation clearOper = new AdjustClearOperation(this.getModelId(), this.getScenarioId(), this.getYearId(), this.getPeriodId(), delRows);
        clearOper.asynexcute();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        qfBuilder.add(new QFilter("userid", "=", (Object)RequestContext.get().getCurrUserId()));
        qfBuilder.add(new QFilter("operationtype", "=", (Object)String.valueOf(AdjustOperTypeEnum.DELETEOPERATION.getValue())));
        DynamicObjectCollection dyobjs = QueryServiceHelper.query((String)"bcm_adjustprogressentity", (String)"id", (QFilter[])qfBuilder.toArray(), (String)"begintime desc");
        Long traceId = 0L;
        if (dyobjs.size() > 0) {
            traceId = ((DynamicObject)dyobjs.get(0)).getLong("id");
        }
        ExcelApiOutput result = new ExcelApiOutput(true);
        result.setData(traceId);
        return result;
    }

    public ExcelApiOutput getAdjustLogInfo() {
        Long traceId = LongUtil.toLong(this.param.get("traceId"));
        DynamicObject record = AdjustOperationThreadHelper.getAdjLogFromCache((Long)traceId);
        if (null == record) {
            return new ExcelApiOutput(false);
        }
        AdjustLogModel logModel = new AdjustLogModel();
        logModel.setId(record.getLong("id"));
        logModel.setModelName(record.getDynamicObject("model").getString("name"));
        logModel.setModelNumber(record.getDynamicObject("model").getString("shownumber"));
        logModel.setOperateUser(record.getDynamicObject("userid").getString("name"));
        logModel.setAdjustOperationStatus(record.getInt("status"));
        logModel.setOperationType(record.getInt("operationtype"));
        logModel.setScenario(this.dyObjToMemberDto(record.getDynamicObject("scenario")));
        logModel.setYear(this.dyObjToMemberDto(record.getDynamicObject("year")));
        logModel.setPeriod(this.dyObjToMemberDto(record.getDynamicObject("period")));
        logModel.setStartTime(record.getDate("begintime"));
        logModel.setEndTime(record.getDate("endtime"));
        logModel.setErrorLog(this.handErrorlog(record.getString("failedlog")));
        logModel.setCount(record.getInt("count"));
        logModel.setSuccessCount(record.getInt("successcount"));
        logModel.setErrorCount(record.getInt("errorcount"));
        ExcelApiOutput output = new ExcelApiOutput(true);
        output.setData(logModel);
        return output;
    }

    public List<AdjustLogModel> getAdjustLogList() {
        int rowLimit = 20;
        Long modelId = this.getModelId();
        if (this.param.containsKey("count")) {
            rowLimit = (Integer)this.param.get("count");
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        String selectField = "id,operationtype,userid.name,status,scenario,year,period,begintime,endtime,failedlog,successcount,errorcount,count";
        DynamicObjectCollection logdyobjs = QueryServiceHelper.query((String)"bcm_adjustprogressentity", (String)selectField, (QFilter[])qfBuilder.toArray(), (String)"begintime desc", (int)rowLimit);
        ArrayList<AdjustLogModel> result = new ArrayList<AdjustLogModel>(rowLimit);
        for (DynamicObject dyobj : logdyobjs) {
            AdjustLogModel logModel = new AdjustLogModel();
            logModel.setId(dyobj.getLong("id"));
            logModel.setModelName(model.getString("name"));
            logModel.setModelNumber(model.getString("shownumber"));
            logModel.setOperateUser(dyobj.getString("userid.name"));
            logModel.setAdjustOperationStatus(dyobj.getInt("status"));
            logModel.setOperationType(dyobj.getInt("operationtype"));
            logModel.setScenario(this.getMemberDTO(dyobj.getLong("scenario"), model.getString("number"), 1));
            logModel.setYear(this.getMemberDTO(dyobj.getLong("year"), model.getString("number"), 2));
            logModel.setPeriod(this.getMemberDTO(dyobj.getLong("period"), model.getString("number"), 3));
            logModel.setStartTime(dyobj.getDate("begintime"));
            logModel.setEndTime(dyobj.getDate("endtime"));
            logModel.setErrorLog(this.handErrorlog(dyobj.getString("failedlog")));
            logModel.setCount(dyobj.getInt("count"));
            logModel.setSuccessCount(dyobj.getInt("successcount"));
            logModel.setErrorCount(dyobj.getInt("errorcount"));
            result.add(logModel);
        }
        return result;
    }

    private DimMember dyObjToMemberDto(DynamicObject obj) {
        if (null == obj) {
            return null;
        }
        DimMember dimMember = new DimMember();
        dimMember.setNumber(obj.getString("number"));
        dimMember.setName(obj.getString("name"));
        dimMember.setId(obj.getLong("id"));
        return dimMember;
    }

    private DimMember getMemberDTO(long id, String modelNumber, int type) {
        IDNumberTreeNode member = null;
        if (type == 1) {
            member = MemberReader.findScenaMemberById((String)modelNumber, (Long)id);
        } else if (type == 2) {
            member = MemberReader.findFyMemberById((String)modelNumber, (Long)id);
        } else if (type == 3) {
            member = MemberReader.findPeriodMemberById((String)modelNumber, (Long)id);
        }
        if (null == member) {
            return null;
        }
        DimMember dimMember = new DimMember();
        dimMember.setNumber(member.getNumber());
        dimMember.setName(member.getName());
        dimMember.setId(id);
        return dimMember;
    }

    private DimMember dyObjToMemberDto(DynamicObject obj, Long dimensionId) {
        if (null == obj) {
            return null;
        }
        DimMember dimMember = new DimMember();
        dimMember.setNumber(obj.getString("number"));
        dimMember.setName(obj.getString("name"));
        dimMember.setId(obj.getLong("id"));
        dimMember.setDimensionId(dimensionId);
        return dimMember;
    }

    private String handErrorlog(String curLogStr) {
        String warning = String.format("<%s>", ErrorLevel.Warning.name());
        if (StringUtils.isNotEmpty((String)curLogStr) && curLogStr.startsWith(warning)) {
            curLogStr = curLogStr.substring(warning.length());
        }
        if (StringUtils.isNotEmpty((String)curLogStr)) {
            curLogStr = curLogStr.replace("kd\\.bos\\.exception\\.KDException", "");
        }
        if (curLogStr.contains("/**ERROR**/")) {
            curLogStr = curLogStr.replace("/**ERROR**/", "");
        }
        return curLogStr;
    }

    public List<AdjustOffsetModel> getRptAdjustOffsetDetails() {
        List pkIds = (List)this.param.get("pkIds");
        boolean isLinkage = (Boolean)this.param.get("isLinkage");
        DynamicObject[] dySource = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        List linkIds = Arrays.stream(dySource).map(x -> x.getLong("linkagelinksource")).filter(x -> x != 0L).collect(Collectors.toList());
        qFilters.add(new QFilter("adjust", "in", (Object)pkIds).or(new QFilter("adjust", "in", linkIds)));
        String selectFields = "adjust,id,dseq,showseq,groupnum,description,entrysource,merge,entity,account,year,period,scenario,process,currency,audittrail,changetype,internalcompany,multigaap,datasort,dim1,dim2,dim3,dim4,dim5,dim6,debit,credit,isdefaultcurrency,mycompany";
        DynamicObject[] dataEntrySource = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"showseq");
        Map customDimMap = DimensionServiceHelper.getUserDefineDimensionNameAndMapByModel((Object)this.getModelId(), (boolean)false);
        Map<String, Long> dimNumberToIdMap = this.getDimensionNumberIdMap();
        ArrayList<Integer> normalSourceType = new ArrayList<Integer>(16);
        normalSourceType.add(1);
        normalSourceType.add(3);
        normalSourceType.add(5);
        normalSourceType.add(7);
        normalSourceType.add(8);
        ArrayList<AdjustOffsetModel> offsets = new ArrayList<AdjustOffsetModel>(16);
        for (DynamicObject obj : dySource) {
            List<DynamicObject> adjustDatas = Arrays.stream(dataEntrySource).filter(x -> {
                if (isLinkage || ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equals(obj.getString("entrysource")) || ElimHeaderSourceEnum.SHARE_LINKAGE.getValue().equals(obj.getString("entrysource"))) {
                    return x.getLong("adjust.id") == obj.getLong("id") || x.getLong("adjust.id") == obj.getLong("linkagelinksource");
                }
                return x.getLong("adjust.id") == obj.getLong("id") && normalSourceType.contains(x.getInt("entrysource"));
            }).collect(Collectors.toList());
            List<DynamicObject> adjustDatasSorted = this.sortAdjustDatas(adjustDatas);
            offsets.add(this.getRptAdjustDtoByDynamicObj(obj, adjustDatasSorted, customDimMap, dimNumberToIdMap));
        }
        return offsets;
    }

    private List<DynamicObject> sortAdjustDatas(List<DynamicObject> adjustDatas) {
        adjustDatas.forEach(x -> {
            Optional<DynamicObject> opData;
            Optional<String> op;
            if (ElimRptAdjSourceTypeEnum.LINK.getValue() == x.getInt("entrysource") && (op = Arrays.stream(StringUtils.split((String)x.getString("dseq"), (boolean)false, (char[])new char[]{'-'})).findFirst()).isPresent() && (opData = adjustDatas.stream().filter(k -> k.getString("groupnum").equals(x.getString("groupnum")) && k.getString("dseq").equals(op.get())).findFirst()).isPresent()) {
                x.set("showseq", (Object)opData.get().getInt("showseq"));
            }
        });
        Comparator<DynamicObject> showSeqComp = Comparator.comparing(x -> x.getInt("showseq"));
        Comparator<DynamicObject> seqComp = showSeqComp.thenComparing((x, y) -> {
            String xdesq = x.getString("dseq");
            String ydesq = y.getString("dseq");
            if (null == xdesq && null == ydesq) {
                return 0;
            }
            if (null == xdesq) {
                return 1;
            }
            if (null == ydesq) {
                return -1;
            }
            if (xdesq.length() == ydesq.length()) {
                String[] ydesqArr;
                String[] xdesqArr = xdesq.split("-");
                if (xdesqArr.length == (ydesqArr = ydesq.split("-")).length && xdesqArr.length != 0) {
                    return Integer.parseInt(xdesqArr[xdesqArr.length - 1]) - Integer.parseInt(ydesqArr[ydesqArr.length - 1]);
                }
                return xdesqArr.length - ydesqArr.length;
            }
            return xdesq.length() - ydesq.length();
        });
        return adjustDatas.stream().sorted(seqComp).collect(Collectors.toList());
    }

    private AdjustOffsetModel getRptAdjustDtoByDynamicObj(DynamicObject obj, List<DynamicObject> adjustDatas, Map<String, String> customDimMap, Map<String, Long> dimNumberToIdMap) {
        AdjustOffsetModel adjust = new AdjustOffsetModel();
        adjust.setId(obj.getLong("id"));
        adjust.setName(obj.getString("name"));
        adjust.setCode(obj.getString("number"));
        adjust.setStatus(obj.getInt("status"));
        adjust.setBussnessType(obj.getString("bussnesstype"));
        adjust.setBalanceCtrl(obj.getInt("balancetype"));
        adjust.setJournalType(obj.getInt("journaltype"));
        adjust.setLinkCreateType(obj.getInt("linkcreatetype"));
        adjust.setEntrySource(obj.getInt("entrysource"));
        adjust.setSourceType(obj.getInt("sourcetype"));
        adjust.setSourceCode(obj.getString("extendfrom"));
        if (null != obj.getDynamicObject("belongorg")) {
            adjust.setBelongOrg(obj.getDynamicObject("belongorg").getString("name"));
            adjust.setBelongOrgId(obj.getDynamicObject("belongorg").getLong("id"));
        }
        adjust.setClassificationName(obj.getString("templatecatalog.name"));
        adjust.setClassificationId(obj.getLong("templatecatalog.id"));
        adjust.setDescription(obj.getString("description"));
        DynamicObjectCollection comDimDys = obj.getDynamicObjectCollection("commembentry");
        Map<String, DimMember> comDims = comDimDys.stream().filter(x -> !x.getString("comentitysign").equals("bcm_mergenode")).collect(Collectors.toMap(x -> x.getDynamicObject("comdimension").getString("number"), x -> {
            Long memberId = x.getLong("commembid");
            DynamicObject comDimension = x.getDynamicObject("comdimension");
            if (null == comDimension) {
                return null;
            }
            String entryTreeNumber = comDimension.getString("memberform");
            IDNumberTreeNode memberNode = MemberReader.findMemberById((long)this.getModelId(), (String)entryTreeNumber, (Long)memberId);
            DimMember member = new DimMember();
            member.setId(memberId);
            member.setNumber(memberNode.getNumber());
            member.setName(memberNode.getName());
            member.setDimensionId(memberNode.getDimId());
            return member;
        }));
        adjust.setCommonDims(comDims);
        DynamicObjectCollection speradDimDys = obj.getDynamicObjectCollection("spreadmembentry");
        List<String> speradDims = speradDimDys.stream().map(x -> x.getDynamicObject("spreaddimension").getString("number")).collect(Collectors.toList());
        adjust.setSpreadDims(speradDims);
        ArrayList<AdjustDataModel> datas = new ArrayList<AdjustDataModel>(16);
        for (DynamicObject data : adjustDatas) {
            if (!data.getBoolean("isdefaultcurrency")) continue;
            AdjustDataModel dataModel = new AdjustDataModel();
            dataModel.setId(data.getLong("id"));
            dataModel.setAdjustId(data.getLong("adjust.id"));
            dataModel.setSeq(data.getString("dseq"));
            dataModel.setGroup(data.getString("groupnum"));
            dataModel.setDescription(data.getString("description"));
            dataModel.setEntrySource(data.getInt("entrysource"));
            if (null != data.getDynamicObject("merge")) {
                dataModel.setMergeEntity(this.dyObjToMemberDto(data.getDynamicObject("merge"), dimNumberToIdMap.get(DimTypesEnum.ENTITY.getNumber())));
            }
            if (null != data.getDynamicObject("entity")) {
                DimMember curEntity = this.dyObjToMemberDto(data.getDynamicObject("entity"), dimNumberToIdMap.get(DimTypesEnum.ENTITY.getNumber()));
                curEntity.setParentId(data.getDynamicObject("entity").getDynamicObject("parent").getLong("id"));
                curEntity.setSchemeId(data.getDynamicObject("entity").getLong("cslscheme_id"));
                dataModel.setEntity(curEntity);
            }
            dataModel.setAccount(this.dyObjToMemberDto(data.getDynamicObject("account"), dimNumberToIdMap.get(DimTypesEnum.ACCOUNT.getNumber())));
            dataModel.setYear(this.dyObjToMemberDto(data.getDynamicObject("year"), dimNumberToIdMap.get(DimTypesEnum.YEAR.getNumber())));
            dataModel.setPeriod(this.dyObjToMemberDto(data.getDynamicObject("period"), dimNumberToIdMap.get(DimTypesEnum.PERIOD.getNumber())));
            dataModel.setScenario(this.dyObjToMemberDto(data.getDynamicObject("scenario"), dimNumberToIdMap.get(DimTypesEnum.SCENARIO.getNumber())));
            dataModel.setProcess(this.dyObjToMemberDto(data.getDynamicObject("process"), dimNumberToIdMap.get(DimTypesEnum.PROCESS.getNumber())));
            dataModel.setCurrency(this.dyObjToMemberDto(data.getDynamicObject("currency"), dimNumberToIdMap.get(DimTypesEnum.CURRENCY.getNumber())));
            dataModel.setAudittrail(this.dyObjToMemberDto(data.getDynamicObject("audittrail"), dimNumberToIdMap.get(DimTypesEnum.AUDITTRIAL.getNumber())));
            dataModel.setMycompany(this.dyObjToMemberDto(data.getDynamicObject("mycompany"), dimNumberToIdMap.get(DimTypesEnum.MYCOMPANY.getNumber())));
            dataModel.setChangetype(this.dyObjToMemberDto(data.getDynamicObject("changetype"), dimNumberToIdMap.get(DimTypesEnum.CHANGETYPE.getNumber())));
            dataModel.setInternalcompany(this.dyObjToMemberDto(data.getDynamicObject("internalcompany"), dimNumberToIdMap.get(DimTypesEnum.INTERCOMPANY.getNumber())));
            dataModel.setMultigaap(this.dyObjToMemberDto(data.getDynamicObject("multigaap"), dimNumberToIdMap.get(DimTypesEnum.MULTIGAAP.getNumber())));
            dataModel.setDatasort(this.dyObjToMemberDto(data.getDynamicObject("datasort"), dimNumberToIdMap.get(DimTypesEnum.DATASORT.getNumber())));
            HashMap<String, DimMember> customDim = new HashMap<String, DimMember>(16);
            for (Map.Entry<String, String> kv : customDimMap.entrySet()) {
                customDim.put(kv.getKey(), this.dyObjToMemberDto(data.getDynamicObject(kv.getValue()), dimNumberToIdMap.get(kv.getKey())));
            }
            dataModel.setCustomDims(customDim);
            dataModel.setDebit(data.getBigDecimal("debit"));
            dataModel.setCredit(data.getBigDecimal("credit"));
            datas.add(dataModel);
        }
        adjust.setEntrys(datas);
        return adjust;
    }

    public List<ExcelApiOutput> upsertRptAdjustOffset() {
        Long modelId = this.getModelId();
        boolean isLinkage = (Boolean)this.param.get("isLinkage");
        AdjustDataSaveParam dataSaveParam = (AdjustDataSaveParam)JSON.parseObject((String)JSON.toJSONString(this.param.get("dataSaveParam")), (TypeReference)new TypeReference<AdjustDataSaveParam>(){}, (Feature[])new Feature[0]);
        if (null == dataSaveParam) {
            dataSaveParam = new AdjustDataSaveParam();
        }
        List adjusts = (List)JSON.parseObject((String)JSON.toJSONString(this.param.get("adjustOffsets")), (TypeReference)new TypeReference<List<AdjustOffsetModel>>(){}, (Feature[])new Feature[0]);
        return this.save(modelId, isLinkage, dataSaveParam, adjusts).values().stream().collect(Collectors.toList());
    }

    public Map<String, ExcelApiOutput> upsertRptAdjustOffsetFormula() {
        long modelId = (Long)this.param.get("modelId");
        List adjusts = (List)JSON.parseObject((String)JSON.toJSONString(this.param.get("adjustOffsets")), (TypeReference)new TypeReference<List<AdjustOffsetModel>>(){}, (Feature[])new Feature[0]);
        HashMap<String, ExcelApiOutput> result = new HashMap<String, ExcelApiOutput>(adjusts.size());
        List numbers = adjusts.stream().map(x -> x.getCode()).collect(Collectors.toList());
        QFilter qf = new QFilter("number", "in", numbers);
        DynamicObjectCollection adjustsExist = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id,status,number,scenario_id,year_id,period_id", (QFilter[])new QFilter[]{qf});
        Map<Long, String> idToNumberMap = adjustsExist.stream().collect(Collectors.toMap(x -> x.getLong("id"), k -> k.getString("number")));
        HashMap deleteAdjusts = new HashMap(16);
        for (DynamicObject obj : adjustsExist) {
            if (obj.getString("status") == "3" || obj.getString("status") == "4" || obj.getString("status") == "5") {
                List findAdjust = adjusts.stream().filter(x -> x.getCode().equals(obj.getString("number"))).collect(Collectors.toList());
                for (AdjustOffsetModel model : findAdjust) {
                    ExcelApiOutput entryResult = new ExcelApiOutput();
                    entryResult.setSuccess(false);
                    entryResult.setMessage(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u6216\u4fdd\u5b58\u72b6\u6001", (String)"ExcelSerivce_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    result.put(model.getQueryKey(), entryResult);
                    adjusts.remove(model);
                }
                continue;
            }
            String key = obj.getString("scenario_id") + "|" + obj.getString("year_id") + "|" + obj.getString("period_id");
            if (deleteAdjusts.containsKey(key)) {
                ((List)deleteAdjusts.get(key)).add(obj.getLong("id"));
                continue;
            }
            ArrayList<Long> delIds = new ArrayList<Long>(16);
            delIds.add(obj.getLong("id"));
            deleteAdjusts.put(key, delIds);
        }
        for (Map.Entry entry : deleteAdjusts.entrySet()) {
            String[] dimIds = ((String)entry.getKey()).split("\\|");
            long scenarioId = LongUtil.toLong((Object)dimIds[0]);
            long yearId = LongUtil.toLong((Object)dimIds[1]);
            long periodId = LongUtil.toLong((Object)dimIds[2]);
            AdjustClearOperation clearOper = new AdjustClearOperation(this.getModelId(), Long.valueOf(scenarioId), Long.valueOf(yearId), Long.valueOf(periodId), (List)entry.getValue());
            clearOper.excute();
        }
        Map<String, ExcelApiOutput> resultSave = this.save(modelId, false, new AdjustDataSaveParam(), adjusts);
        result.putAll(resultSave);
        return result;
    }

    @NotNull
    private Map<String, ExcelApiOutput> save(Long modelId, boolean isLinkage, AdjustDataSaveParam dataSaveParam, List<AdjustOffsetModel> adjust) {
        RequestContext ctx = RequestContext.get();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Map customDimMap = DimensionServiceHelper.getUserDefineDimensionNameAndMapByModel((Object)modelId, (boolean)false);
        Map<String, Long> dimNumberToIdMap = this.getDimensionNumberIdMap();
        HashMap<String, ExcelApiOutput> result = new HashMap<String, ExcelApiOutput>(adjust.size());
        List pkIds = adjust.stream().filter(x -> null != x.getId() && x.getId() != 0L).map(x -> x.getId()).collect(Collectors.toList());
        DynamicObject[] dySource = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"));
        Map<Long, DynamicObject> sourceMap = Arrays.stream(dySource).collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
        String dataFieldSelect = String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata").getAllFields().keySet());
        LinkedHashMap<String, Map<String, Object>> allDim = this.getAllDimInfo();
        for (AdjustOffsetModel adjustOffset : adjust) {
            if (StringUtils.isEmpty((String)adjustOffset.getQueryKey())) {
                adjustOffset.setQueryKey(UUID.randomUUID().toString());
            }
            ArrayList<String> errors = new ArrayList<String>(16);
            ExcelApiOutput output = new ExcelApiOutput();
            try {
                Optional<BusinessTypeEnum> optional;
                Object error;
                if (adjustOffset.getEntrys().size() == 0) {
                    String error2 = ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExcelSerivce_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    output.setSuccess(false);
                    output.setMessage(error2);
                    result.put(adjustOffset.getQueryKey(), output);
                    continue;
                }
                Optional<AdjustDataModel> containEntityOpt = adjustOffset.getEntrys().stream().filter(x -> null != x.getEntity()).findAny();
                if (!containEntityOpt.isPresent()) {
                    error = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u5bb6\u7ec4\u7ec7\u3002", (String)"AdjustCheckCommonSpreadValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    output.setSuccess(false);
                    output.setMessage((String)error);
                    result.put(adjustOffset.getQueryKey(), output);
                    continue;
                }
                if (!RptAdjustStatusEnum.TEMPSAVE.status().equals(String.valueOf(adjustOffset.getStatus())) && !RptAdjustStatusEnum.SAVE.status().equals(String.valueOf(adjustOffset.getStatus()))) {
                    error = ResManager.loadKDString((String)"\u975e\u6682\u5b58\u6216\u4fdd\u5b58\u72b6\u6001", (String)"ExcelSerivce_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    output.setSuccess(false);
                    output.setMessage((String)error);
                    result.put(adjustOffset.getQueryKey(), output);
                    continue;
                }
                if (StringUtils.isEmpty((String)adjustOffset.getName())) {
                    errors.add(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustCheckCommonSpreadValidator_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                for (Map.Entry entry : adjustOffset.getCommonDims().entrySet()) {
                    if (null != entry.getValue() && ((DimMember)entry.getValue()).getId() != 0L) continue;
                    errors.add(String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u201c%s\u201d\u7684\u503c\u7f3a\u5931\u3002", (String)"ExcelSerivce_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entry.getKey()));
                }
                String updateNumber = adjustOffset.getCode();
                if (StringUtils.isEmpty((String)updateNumber) && 0L == adjustOffset.getId()) {
                    CodeRuleInfo codeRuleInfo = CodeRuleUtil.getCodeRuleInfo("bcm_rptadjust");
                    if (null == codeRuleInfo) {
                        errors.add(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustCheckCommonSpreadValidator_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    updateNumber = CodeRuleUtil.getCodeRuleNumber("bcm_rptadjust", "createtime");
                    adjustOffset.setCode(updateNumber);
                } else {
                    long l = adjust.stream().filter(x -> x.getCode().equals(adjustOffset.getCode())).count();
                    if (l >= 2L) {
                        errors.add(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d", (String)"ExcelSerivce_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    } else {
                        Long id = adjustOffset.getId();
                        long yearId = adjustOffset.getCommonDims().get(DimTypesEnum.YEAR.getNumber()).getId();
                        long scenarioId = adjustOffset.getCommonDims().get(DimTypesEnum.SCENARIO.getNumber()).getId();
                        long periodId = adjustOffset.getCommonDims().get(DimTypesEnum.PERIOD.getNumber()).getId();
                        if (AdjustmentServiceHelper.adjustNumberIsExist((Object)id, (Object)this.getModelId(), (Object)yearId, (Object)scenarioId, (Object)periodId, (String)updateNumber)) {
                            errors.add(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AdjustCheckCommonSpreadValidator_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                        if (!BCMNumberRule.checkNumber((String)updateNumber)) {
                            errors.add(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustQueryBaseInfoPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
                if (!adjustOffset.getCommonDims().containsKey(DimTypesEnum.PROCESS.getNumber())) {
                    String string = ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8fc7\u7a0b", (String)"ExcelSerivce_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    errors.add(string);
                }
                if (!(optional = Arrays.stream(BusinessTypeEnum.values()).filter(x -> x.getIndex().equals(adjustOffset.getBussnessType())).findFirst()).isPresent()) {
                    String error4 = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u65e0\u6548\u3002", (String)"ExcelSerivce_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    errors.add(error4);
                }
                if (errors.size() > 0) {
                    output.setSuccess(false);
                    output.setMessage(String.join((CharSequence)"|", errors));
                    result.put(adjustOffset.getQueryKey(), output);
                    continue;
                }
                Map<String, Long> comNumberToIdMap = adjustOffset.getCommonDims().entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), x -> ((DimMember)x.getValue()).getId()));
                DynamicObject adjustObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
                if (sourceMap.containsKey(adjustOffset.getId())) {
                    adjustObj = sourceMap.get(adjustOffset.getId());
                    adjustObj.set("modifytime", (Object)new Date());
                    adjustObj.set("modifier", (Object)ctx.getUserId());
                    adjustObj.set("spreadjson", null);
                    adjustObj.set("data", null);
                } else {
                    adjustObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                    adjustObj.set("model", (Object)modelId);
                    adjustObj.set("creator", (Object)ctx.getUserId());
                    adjustObj.set("createtime", (Object)new Date());
                    adjustObj.set("entrysource", (Object)"0");
                    adjustObj.set("sourcetype", (Object)"0");
                    adjustObj.set("multiplecurrency", (Object)"0");
                    QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
                    QFilter numFilter = new QFilter("number", "=", (Object)(StringUtils.isNotEmpty((String)adjustOffset.getClassificationNumber()) ? adjustOffset.getClassificationNumber() : "root"));
                    List temcalogs = QueryServiceHelper.queryPrimaryKeys((String)"bcm_templatecatalog", (QFilter[])new QFilter[]{modelFilter, numFilter}, null, (int)1);
                    adjustObj.set("templatecatalog", temcalogs.isEmpty() ? null : temcalogs.get(0));
                    DynamicObjectCollection commonDims = adjustObj.getDynamicObjectCollection("commembentry");
                    DynamicObjectCollection spreadDims = adjustObj.getDynamicObjectCollection("spreadmembentry");
                    if (MergeBizTypes.contains(optional.get())) {
                        DynamicObject mergeRow = commonDims.addNew();
                        mergeRow.set("comdimension", ((Map)allDim.get(DimTypesEnum.ENTITY.getNumber())).get("id"));
                        mergeRow.set("comdimension_id", ((Map)allDim.get(DimTypesEnum.ENTITY.getNumber())).get("id"));
                        mergeRow.set("comentitysign", (Object)"bcm_mergenode");
                    }
                    for (Map.Entry entry : allDim.entrySet()) {
                        DynamicObject newRow;
                        String number = (String)entry.getKey();
                        if (comNumberToIdMap.containsKey(number)) {
                            newRow = commonDims.addNew();
                            newRow.set("comdimension", ((Map)entry.getValue()).get("id"));
                            newRow.set("comdimension_id", ((Map)entry.getValue()).get("id"));
                            newRow.set("comentitysign", ((Map)entry.getValue()).get("entity"));
                            continue;
                        }
                        newRow = spreadDims.addNew();
                        newRow.set("spreaddimension", ((Map)entry.getValue()).get("id"));
                        newRow.set("spreadentitysign", ((Map)entry.getValue()).get("entity"));
                    }
                }
                adjustObj.set("number", (Object)updateNumber);
                adjustObj.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
                if (optional.isPresent()) {
                    adjustObj.set("bussnesstype", (Object)optional.get().getName());
                }
                adjustObj.set("balancetype", (Object)adjustOffset.getBalanceCtrl());
                adjustObj.set("journaltype", (Object)adjustOffset.getJournalType());
                adjustObj.set("linkcreatetype", (Object)adjustOffset.getLinkCreateType());
                adjustObj.set("belongorg", (Object)adjustOffset.getBelongOrgId());
                adjustObj.set("entity", (Object)adjustOffset.getBelongOrgId());
                adjustObj.set("name", (Object)adjustOffset.getName());
                Map<Long, String> DimIdToNumberMap = allDim.entrySet().stream().collect(Collectors.toMap(x -> LongUtil.toLong(((Map)x.getValue()).get("id")), x -> (String)x.getKey()));
                DynamicObjectCollection comdyobjs = adjustObj.getDynamicObjectCollection("commembentry");
                for (DynamicObject obj : comdyobjs) {
                    if (obj.getString("comentitysign").equals("bcm_mergenode")) {
                        obj.set("commembid", (Object)adjustOffset.getBelongOrgId());
                        continue;
                    }
                    Long dimId = obj.getLong("comdimension_id");
                    String number = DimIdToNumberMap.get(dimId);
                    if (!comNumberToIdMap.containsKey(number)) continue;
                    obj.set("commembid", (Object)comNumberToIdMap.get(number));
                }
                Long processId = adjustOffset.getCommonDims().get(DimTypesEnum.PROCESS.getNumber()).getId();
                IDNumberTreeNode process = MemberReader.findProcessMemberById((String)modelNumber, (Long)processId);
                adjustObj.set("scenario", (Object)comNumberToIdMap.get(DimTypesEnum.SCENARIO.getNumber()));
                adjustObj.set("year", (Object)comNumberToIdMap.get(DimTypesEnum.YEAR.getNumber()));
                adjustObj.set("period", (Object)comNumberToIdMap.get(DimTypesEnum.PERIOD.getNumber()));
                adjustObj.set("process", (Object)process.getNumber());
                int maxGroupIndex = this.getMaxGroupNum(adjustOffset.getEntrys());
                String groupNumber = "G" + maxGroupIndex;
                HashMap<String, AtomicInteger> hashMap = new HashMap<String, AtomicInteger>(16);
                ArrayList<DynamicObject> adjustData = new ArrayList<DynamicObject>(16);
                int order = 0;
                for (AdjustDataModel model : adjustOffset.getEntrys()) {
                    DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustdata");
                    if (null != model.getId() && model.getId() != 0L) {
                        DynamicObject currow = BusinessDataServiceHelper.loadSingle((Object)model.getId(), (String)"bcm_rptadjustdata");
                        row.set("id", currow.get("id"));
                        row.set("entrysource", currow.get("entrysource"));
                        row.set("model_id", currow.get("model_id"));
                        row.set("differ", currow.get("differ"));
                        row.set("ischanged", currow.get("ischanged"));
                        row.set("isdefaultcurrency", currow.get("isdefaultcurrency"));
                        row.set("adjust_id", currow.get("adjust_id"));
                        row.set("adjust", currow.get("adjust"));
                        row.set("groupnum", (Object)model.getGroup());
                        row.set("dseq", (Object)model.getSeq());
                    } else {
                        row.set("model_id", (Object)modelId);
                        row.set("differ", (Object)0.0);
                        row.set("entrysource", (Object)3);
                        row.set("ischanged", (Object)1);
                        row.set("isdefaultcurrency", (Object)1);
                        row.set("adjust_id", (Object)adjustObj.getLong("id"));
                        row.set("adjust", (Object)adjustObj.getLong("id"));
                        row.set("groupnum", (Object)groupNumber);
                        int currentRowSeq = hashMap.computeIfAbsent(groupNumber, v -> new AtomicInteger(1)).getAndIncrement();
                        int rowSeqLength = Integer.toString(adjustOffset.getEntrys().size()).length();
                        row.set("dseq", (Object)String.format("%0" + Math.max(2, rowSeqLength) + "d", currentRowSeq));
                    }
                    row.set("showseq", (Object)order);
                    ++order;
                    row.set("merge_id", (Object)adjustOffset.getBelongOrgId());
                    row.set("description", (Object)model.getDescription());
                    if (null != model.getEntity()) {
                        row.set("entity_id", (Object)model.getEntity().getId());
                        if (0L == adjustOffset.getBelongOrgId()) {
                            row.set("merge_id", (Object)model.getEntity().getId());
                        }
                    }
                    Long accountId = 0L;
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.ACCOUNT.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.ACCOUNT.getNumber())) {
                        accountId = adjustOffset.getCommonDims().get(DimTypesEnum.ACCOUNT.getNumber()).getId();
                        row.set("account_id", (Object)accountId);
                    } else if (null != model.getAccount()) {
                        accountId = model.getAccount().getId();
                        row.set("account_id", (Object)accountId);
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.YEAR.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.YEAR.getNumber())) {
                        row.set("year_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.YEAR.getNumber()).getId());
                    } else if (null != model.getYear()) {
                        row.set("year_id", (Object)model.getYear().getId());
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.PERIOD.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.PERIOD.getNumber())) {
                        row.set("period_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.PERIOD.getNumber()).getId());
                    } else if (null != model.getPeriod()) {
                        row.set("period_id", (Object)model.getPeriod().getId());
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.SCENARIO.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.SCENARIO.getNumber())) {
                        row.set("scenario_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.SCENARIO.getNumber()).getId());
                    } else if (null != model.getScenario()) {
                        row.set("scenario_id", (Object)model.getScenario().getId());
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.PROCESS.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.PROCESS.getNumber())) {
                        row.set("process_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.PROCESS.getNumber()).getId());
                    } else if (null != model.getProcess()) {
                        row.set("process_id", (Object)model.getProcess().getId());
                    }
                    if (null != model.getCurrency()) {
                        row.set("currency_id", (Object)model.getCurrency().getId());
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.AUDITTRIAL.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.AUDITTRIAL.getNumber())) {
                        row.set("audittrail_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.AUDITTRIAL.getNumber()).getId());
                    } else if (null != model.getAudittrail()) {
                        row.set("audittrail_id", (Object)model.getAudittrail().getId());
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.CHANGETYPE.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.CHANGETYPE.getNumber())) {
                        row.set("changetype_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.CHANGETYPE.getNumber()).getId());
                    } else if (null != model.getChangetype()) {
                        row.set("changetype_id", (Object)model.getChangetype().getId());
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.INTERCOMPANY.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.INTERCOMPANY.getNumber())) {
                        row.set("internalcompany_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.INTERCOMPANY.getNumber()).getId());
                    } else if (null != model.getInternalcompany()) {
                        row.set("internalcompany_id", (Object)model.getInternalcompany().getId());
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.MULTIGAAP.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.MULTIGAAP.getNumber())) {
                        row.set("multigaap_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.MULTIGAAP.getNumber()).getId());
                    } else if (null != model.getMultigaap()) {
                        row.set("multigaap_id", (Object)model.getMultigaap().getId());
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.MYCOMPANY.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.MYCOMPANY.getNumber())) {
                        row.set("mycompany_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.MYCOMPANY.getNumber()).getId());
                    } else if (null != model.getMycompany()) {
                        row.set("mycompany_id", (Object)model.getMycompany().getId());
                    }
                    if (adjustOffset.getCommonDims().containsKey(DimTypesEnum.DATASORT.getNumber()) && null != adjustOffset.getCommonDims().get(DimTypesEnum.DATASORT.getNumber())) {
                        row.set("datasort_id", (Object)adjustOffset.getCommonDims().get(DimTypesEnum.DATASORT.getNumber()).getId());
                    } else if (null != model.getDatasort()) {
                        row.set("datasort_id", (Object)model.getDatasort().getId());
                    }
                    if (null != model.getCustomDims()) {
                        for (Map.Entry kv : customDimMap.entrySet()) {
                            String fieldName = (String)kv.getValue();
                            if (adjustOffset.getCommonDims().containsKey(kv.getKey()) && null != adjustOffset.getCommonDims().get(kv.getKey())) {
                                row.set(fieldName + "_id", (Object)adjustOffset.getCommonDims().get(kv.getKey()).getId());
                                continue;
                            }
                            if (!model.getCustomDims().containsKey(kv.getKey()) || null == model.getCustomDims().get(kv.getKey())) continue;
                            row.set(fieldName + "_id", (Object)model.getCustomDims().get(kv.getKey()).getId());
                        }
                    }
                    String olapOrg = model.getEntity().getNumber();
                    if (null != adjustOffset.getCommonDims().get("Process") && 0L != adjustOffset.getBelongOrgId() && OrgRelaProcessMembPool.isRelaProcess((String)adjustOffset.getCommonDims().get("Process").getNumber())) {
                        IDNumberTreeNode orgMerge = MemberReader.findEntityMemberById((Long)modelId, (Long)adjustOffset.getBelongOrgId());
                        olapOrg = ExcelAdjustOffsetAction.getParentDirectChild(orgMerge.getNumber(), model.getEntity().getLongNumber());
                    }
                    row.set("olaporg", (Object)olapOrg);
                    row.set("debit", (Object)model.getDebit());
                    row.set("credit", (Object)model.getCredit());
                    IDNumberTreeNode accoutNode = MemberReader.findMemberById((long)modelId, (String)"bcm_accountmembertree", (Long)accountId);
                    String direct = (String)accoutNode.getProperty("drcrdirect");
                    BigDecimal summoney = DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.getOIndex().equals(direct) ? model.getCredit().subtract(model.getDebit()) : model.getDebit().subtract(model.getCredit());
                    row.set("summoney", (Object)summoney);
                    AdjustOperationHelper.fillAdjustDataOfOlapOrg((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)process.getNumber(), (DynamicObject)row);
                    adjustData.add(row);
                }
                BusinessDataWriter.save((IDataEntityType)adjustObj.getDynamicObjectType(), (Object[])new Object[]{adjustObj});
                if (adjustOffset.getId() != 0L) {
                    QFBuilder qf = new QFBuilder();
                    qf.add("model", "=", (Object)modelId);
                    qf.add("adjust", "=", (Object)adjustOffset.getId());
                    DeleteServiceHelper.delete((String)"bcm_rptadjustdata", (QFilter[])qf.toArray());
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata"), (Object[])adjustData.toArray());
                if (RptAdjustStatusEnum.SAVE.status().equals(String.valueOf(adjustOffset.getStatus()))) {
                    ArrayList<Long> ids = new ArrayList<Long>(1);
                    ids.add(adjustObj.getLong("id"));
                    AdjustOperationContext actx = new AdjustOperationContext(modelId.longValue(), this.getScenarioId().longValue(), this.getYearId().longValue(), this.getPeriodId().longValue());
                    AdjustSaveOperation saveOperation = new AdjustSaveOperation(actx, ids, dataSaveParam);
                    saveOperation.excute();
                    OperationResult saveResult = saveOperation.getOperationResult();
                    if (!saveResult.isSuccess()) {
                        output.setSuccess(false);
                        List saveErrors = saveResult.getAllErrorOrValidateInfo().stream().map(x -> x.getMessage()).collect(Collectors.toList());
                        output.setMessage(String.join((CharSequence)"|", saveErrors));
                        adjustOffset.setId(adjustObj.getLong("id"));
                        adjustOffset.setStatus(adjustObj.getInt("status"));
                        output.setData(adjustOffset);
                        result.put(adjustOffset.getQueryKey(), output);
                        continue;
                    }
                }
                DynamicObject dySourceSaved = BusinessDataServiceHelper.loadSingle((Object)adjustObj.getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
                if (isLinkage && 0L != dySourceSaved.getLong("linkagelinksource")) {
                    qFilters.add(new QFilter("adjust", "=", dySourceSaved.get("id")).or(new QFilter("adjust", "=", (Object)dySourceSaved.getLong("linkagelinksource"))));
                } else {
                    qFilters.add(new QFilter("adjust", "=", dySourceSaved.get("id")));
                }
                if (!isLinkage) {
                    qFilters.add(new QFilter("entrysource", "in", normalSourceType));
                }
                DynamicObject[] dataEntrySource = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)dataFieldSelect, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"dseq");
                List<DynamicObject> sortedDatas = this.sortAdjustDatas(Arrays.stream(dataEntrySource).collect(Collectors.toList()));
                AdjustOffsetModel savedModel = this.getRptAdjustDtoByDynamicObj(dySourceSaved, sortedDatas, customDimMap, dimNumberToIdMap);
                output.setData(savedModel);
                output.setSuccess(true);
                result.put(adjustOffset.getQueryKey(), output);
            }
            catch (Exception e) {
                errors.add(e.getMessage());
                output.setSuccess(false);
                output.setMessage(String.join((CharSequence)"|", errors));
                result.put(adjustOffset.getQueryKey(), output);
            }
        }
        return result;
    }

    private LinkedHashMap<String, Map<String, Object>> getAllDimInfo() {
        LinkedHashMap<String, Map<String, Object>> allPoint = new LinkedHashMap<String, Map<String, Object>>(10);
        DynamicObjectCollection dimensions = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        List dimensionSorted = dimensions.stream().sorted(Comparator.comparing(x -> x.getInt("dseq"))).collect(Collectors.toList());
        for (DynamicObject dim : dimensionSorted) {
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dim.getString("number")) && !QueryDimensionServiceHelper.checkIcEnt((long)this.getModelId())) continue;
            String number = dim.getString("number");
            String entity = dim.getString("membermodel");
            String seq = dim.getString("dseq");
            HashMap<String, Object> dimMap = new HashMap<String, Object>(16);
            dimMap.put("id", dim.getLong("id"));
            dimMap.put("name", dim.getString("name"));
            dimMap.put("entity", entity);
            dimMap.put("sign", entity + seq + "s");
            dimMap.put("seq", seq);
            dimMap.put("number", number);
            dimMap.put("shortnumber", dim.getString("shortnumber"));
            allPoint.put(number, dimMap);
        }
        return allPoint;
    }

    public List<AdjustBussinessTypeModel> getBussinessTypeModels() {
        ArrayList<AdjustBussinessTypeModel> result = new ArrayList<AdjustBussinessTypeModel>(16);
        List<Pair<LocaleString, String>> items = ExcelAdjustOffsetAction.getBussinessType(this.getModelId());
        for (Pair<LocaleString, String> pair : items) {
            AdjustBussinessTypeModel model = new AdjustBussinessTypeModel();
            String name = (String)pair.p2;
            BusinessTypeEnum type = BusinessTypeEnum.searchByName((String)name);
            model.setDescribe(((LocaleString)pair.p1).getLocaleValue());
            model.setProcNumber(type.getProcessNumber());
            model.setType(type.getName());
            result.add(model);
        }
        return result;
    }

    private int getMaxGroupNum(List<AdjustDataModel> dataModels) {
        int maxGroupNum = 0;
        for (int i = 0; i < dataModels.size(); ++i) {
            String groupNumStr = dataModels.get(i).getGroup();
            int groupNum = 0;
            if (null != groupNumStr && groupNumStr.startsWith("G")) {
                String temp = groupNumStr.substring(1);
                int n = groupNum = temp.matches("^[0-9]+$") ? Integer.parseInt(temp) : 0;
            }
            if (groupNum <= maxGroupNum) continue;
            maxGroupNum = groupNum;
        }
        return maxGroupNum + 1;
    }

    private Map<String, Long> getDimensionNumberIdMap() {
        HashMap<String, Long> result = new HashMap<String, Long>(10);
        DynamicObjectCollection dimensions = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        for (DynamicObject dim : dimensions) {
            result.put(dim.getString("number"), dim.getLong("id"));
        }
        return result;
    }

    public ExcelApiOutput updateAdjustStatus() {
        List pkIds = (List)this.param.get("pkIds");
        int status = (Integer)this.param.get("operType");
        AdjustOperTypeEnum operTypeEnum = AdjustOperTypeEnum.getEnumByValue((int)status);
        boolean isCancelOpertaion = false;
        if (operTypeEnum == AdjustOperTypeEnum.BACKOPERATION) {
            isCancelOpertaion = true;
        }
        AdjustOperationContext ctx = new AdjustOperationContext(this.getModelId().longValue(), this.getScenarioId().longValue(), this.getYearId().longValue(), this.getPeriodId().longValue());
        if (operTypeEnum == AdjustOperTypeEnum.SAVEOPERATION) {
            AdjustDataSaveParam dataSaveParam = (AdjustDataSaveParam)JSON.parseObject((String)JSON.toJSONString(this.param.get("dataSaveParam")), (TypeReference)new TypeReference<AdjustDataSaveParam>(){}, (Feature[])new Feature[0]);
            AdjustSaveOperation saveOperation = new AdjustSaveOperation(ctx, pkIds, dataSaveParam);
            saveOperation.asynexcute();
        } else {
            AdjustFlowCancelOperation adSubOp = isCancelOpertaion ? new AdjustFlowCancelOperation(ctx, pkIds, operTypeEnum) : new AdjustFlowOperation(ctx, pkIds, operTypeEnum);
            adSubOp.asynexcute();
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        qfBuilder.add(new QFilter("userid", "=", (Object)RequestContext.get().getCurrUserId()));
        qfBuilder.add(new QFilter("operationtype", "=", (Object)String.valueOf(operTypeEnum.getValue())));
        DynamicObjectCollection dyobjs = QueryServiceHelper.query((String)"bcm_adjustprogressentity", (String)"id", (QFilter[])qfBuilder.toArray(), (String)"begintime desc");
        Long traceId = 0L;
        if (dyobjs.size() > 0) {
            traceId = ((DynamicObject)dyobjs.get(0)).getLong("id");
        }
        ExcelApiOutput result = new ExcelApiOutput(true);
        result.setData(traceId);
        return result;
    }

    public static List<Pair<LocaleString, String>> getBussinessType(long modelId) {
        ArrayList<Pair<LocaleString, String>> items = new ArrayList<Pair<LocaleString, String>>(10);
        HashSet existBussType = new HashSet(16);
        JSONArray bizTypeConfig = ConfigServiceHelper.getConfigCM005((long)modelId);
        bizTypeConfig.forEach(e -> {
            JSONObject entry = (JSONObject)e;
            existBussType.add(entry.getString("businesstypevalue"));
            if (entry.getBoolean("isshow").booleanValue()) {
                Pair pair = Pair.onePair((Object)LocaleString.fromMap((Map)((Map)entry.get((Object)"showname"))), (Object)entry.getString("businesstypevalue"));
                items.add(pair);
            }
        });
        HashSet<String> noContainsPr = new HashSet<String>(16);
        noContainsPr.add(BusinessTypeEnum.RPTADJUSTSELFLEVEL.getName());
        noContainsPr.add(BusinessTypeEnum.ADJUSTCROSSLEVEL.getName());
        noContainsPr.add(BusinessTypeEnum.PADJ.getName());
        IDNumberTreeNode eje = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"EJE");
        if (eje.isLeaf()) {
            noContainsPr.add(BusinessTypeEnum.OFFSETEICA.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETEIT.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETEOE.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETECF.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETEOther.getName());
        } else {
            noContainsPr.add(BusinessTypeEnum.ADJUSTOFFSETLEVEL.getName());
        }
        Arrays.stream(BusinessTypeEnum.values()).forEach(p -> {
            boolean isShow;
            boolean bl = isShow = !existBussType.contains(p.getName()) && !noContainsPr.contains(p.getName());
            if (isShow) {
                Pair pair = Pair.onePair((Object)new LocaleString(p.getText()), (Object)p.getName());
                items.add(pair);
            }
        });
        return items;
    }

    public static String getParentDirectChild(String pNumber, String childLongNumber) {
        if (!StringUtils.isEmpty((String)pNumber) && !StringUtils.isEmpty((String)childLongNumber)) {
            String[] spr = childLongNumber.split("!");
            for (int i = 0; i < spr.length; ++i) {
                if (!spr[i].equals(pNumber) || i == spr.length - 1) continue;
                return pNumber + "_" + spr[i + 1];
            }
        }
        return null;
    }

    static {
        normalSourceType.add(String.valueOf(1));
        normalSourceType.add(String.valueOf(3));
        normalSourceType.add(String.valueOf(5));
        normalSourceType.add(String.valueOf(7));
        normalSourceType.add(String.valueOf(8));
        MergeBizTypes.add(BusinessTypeEnum.ADJUSTSUBLEVEL);
        MergeBizTypes.add(BusinessTypeEnum.ADJUSTLAYERLEVEL);
        MergeBizTypes.add(BusinessTypeEnum.ADJUSTOFFSETLEVEL);
        MergeBizTypes.add(BusinessTypeEnum.ADJUSTCONTRIBUTIONLEVEL);
    }
}

