/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.excel.AbstractExcelAction;
import kd.fi.bcm.formplugin.excel.dto.ExcelApiOutput;
import kd.fi.bcm.formplugin.excel.dto.ISSchemesAssignEntity;
import kd.fi.bcm.formplugin.excel.dto.ISSchemesData;
import kd.fi.bcm.formplugin.excel.dto.ISSchemesResult;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ExcelDataIntegrationAction
extends AbstractExcelAction {
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());

    public ExcelDataIntegrationAction(Map<String, Object> param) {
        super(param);
    }

    public List<ISSchemesData> getISSchemes() {
        ArrayList<ISSchemesData> result = new ArrayList<ISSchemesData>(10);
        long modelId = LongUtil.toLong(this.param.get("modelId"));
        String periodNumber = this.param.get("periodNumber").toString();
        String yearNumber = this.param.get("yearNumber").toString();
        String scenarioNum = this.param.get("scenarioNumber").toString();
        List EntityMembers = (List)this.param.get("entityNumbers");
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter ftype = new QFilter("type", "=", (Object)"1");
        DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"bcm_schemecatalog", (String)"id,name,number,parent", (QFilter[])new QFilter[]{fmodelid, ftype}, (String)"");
        for (DynamicObject model : catalogs) {
            ISSchemesData catelog = new ISSchemesData();
            catelog.setId(model.getLong("id"));
            catelog.setNumber(model.getString("number"));
            catelog.setName(model.getString("name"));
            catelog.setParentId(model.getLong("parent"));
            catelog.setImportMode(1);
            catelog.setIsCateLog(true);
            result.add(catelog);
        }
        List catalogIds = catalogs.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("status", "=", (Object)true));
        qFilters.add(new QFilter("templatecatalog.id", "in", catalogIds));
        DynamicObjectCollection isschemes = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id,name,number,templatecatalog.id,issrc.number,istarg.number,modifytime,versionnumber,importmodeid.importmode,note,\n effectivedate,expiringdate", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
        List<Long> schemeIds = isschemes.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        IntegrationUtil.filterSchemeByScenarioAndDate((long)modelId, (String)scenarioNum, (String)periodNumber, (String)yearNumber, schemeIds);
        ArrayList<QFilter> qFiltersDim = new ArrayList<QFilter>(2);
        qFiltersDim.add(new QFilter("model_id", "=", (Object)modelId));
        DynamicObjectCollection dimDatas = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number", (QFilter[])qFiltersDim.toArray(new QFilter[0]));
        Optional<DynamicObject> yearOpt = dimDatas.stream().filter(x -> x.getString("number").equals(PresetConstant.FY_DIM)).findFirst();
        Optional<DynamicObject> periodOpt = dimDatas.stream().filter(x -> x.getString("number").equals(PresetConstant.PERIOD_DIM)).findFirst();
        Optional<DynamicObject> entityOpt = dimDatas.stream().filter(x -> x.getString("number").equals(PresetConstant.ENTITY_DIM)).findFirst();
        if (!(yearOpt.isPresent() && periodOpt.isPresent() && entityOpt.isPresent())) {
            return new ArrayList<ISSchemesData>(16);
        }
        Long yearDimId = yearOpt.get().getLong("id");
        Long periodDimId = periodOpt.get().getLong("id");
        Long entityId = entityOpt.get().getLong("id");
        ArrayList<String> yearTarMembs = new ArrayList<String>(16);
        yearTarMembs.add(yearNumber);
        yearTarMembs.add("*");
        Pair yearMemberPair = IntegrationUtil.filterSingleMapMems((Long)yearDimId, schemeIds, yearTarMembs);
        HashSet set = new HashSet();
        ((Map)yearMemberPair.p1).values().forEach(set::addAll);
        if (((Map)yearMemberPair.p2).get(yearNumber) != null) {
            set.removeAll((Collection)((Map)yearMemberPair.p2).get(yearNumber));
        }
        ArrayList<String> periodTarMembs = new ArrayList<String>(16);
        periodTarMembs.add(periodNumber);
        periodTarMembs.add("*");
        Pair periodMemberPair = IntegrationUtil.filterSingleMapMems((Long)periodDimId, set, periodTarMembs);
        HashSet set1 = new HashSet();
        ((Map)periodMemberPair.p1).values().forEach(set1::addAll);
        if (((Map)periodMemberPair.p2).get(periodNumber) != null) {
            set1.removeAll((Collection)((Map)periodMemberPair.p2).get(periodNumber));
        }
        schemeIds = new ArrayList(set1);
        Set<Long> sidSet = this.filterByScenario(schemeIds, scenarioNum);
        EntityMembers.add("*");
        Pair entityMemberPair = IntegrationUtil.filterSingleMapMems((Long)entityId, set1, (List)EntityMembers);
        HashMap entityAvalideMap = new HashMap();
        for (Map.Entry entry : ((Map)entityMemberPair.p1).entrySet()) {
            for (Long schemeId : (List)entry.getValue()) {
                ArrayList entitys;
                if (((Map)entityMemberPair.p2).containsKey(entry.getKey()) && ((List)((Map)entityMemberPair.p2).get(entry.getKey())).contains(schemeId)) continue;
                if (entityAvalideMap.containsKey(schemeId)) {
                    entitys = (ArrayList)entityAvalideMap.get(schemeId);
                    if (entitys.contains(entry.getKey())) continue;
                    entitys.add(entry.getKey());
                    continue;
                }
                entitys = new ArrayList(16);
                entitys.add(entry.getKey());
                entityAvalideMap.put(schemeId, entitys);
            }
        }
        for (DynamicObject model : isschemes) {
            if (!sidSet.contains(model.getLong("id"))) continue;
            ISSchemesData scheme = new ISSchemesData();
            scheme.setId(model.getLong("id"));
            scheme.setNumber(model.getString("number"));
            scheme.setName(model.getString("name"));
            scheme.setParentId(model.getLong("templatecatalog.id"));
            scheme.setIssrc(model.getString("issrc.number"));
            scheme.setIstarg(model.getString("istarg.number"));
            scheme.setModifyTime(model.getDate("modifytime"));
            scheme.setImportMode(model.getInt("importmodeid.importmode"));
            if (scheme.getImportMode() == 0) {
                scheme.setImportMode(1);
            }
            scheme.setVersionNumber(model.getString("versionnumber"));
            scheme.setNote(model.getString("note"));
            scheme.setEffectiveDate(model.getDate("effectivedate"));
            scheme.setExpiringDate(model.getDate("expiringdate"));
            scheme.setIsCateLog(false);
            scheme.setValideEntity((List)entityAvalideMap.get(scheme.getId()));
            result.add(scheme);
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add(QFilter.of((String)"scheme.enable = ?", (Object[])new Object[]{true}));
        qfBuilder.add(new QFilter("scheme.id", "in", schemeIds));
        String selectProperties = "scheme.id,entity.id,range";
        DynamicObjectCollection assignList = QueryServiceHelper.query((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])qfBuilder.toArray());
        for (DynamicObject assign : assignList) {
            Long schemeId = assign.getLong("scheme.id");
            Optional<ISSchemesData> find = result.stream().filter(f -> f.getId() == schemeId.longValue()).findFirst();
            if (!find.isPresent()) continue;
            ISSchemesAssignEntity entity = new ISSchemesAssignEntity();
            entity.setEntityId(assign.getLong("entity.id"));
            entity.setRange(assign.getInt("range"));
            find.get().getAssignEntityList().add(entity);
        }
        return result;
    }

    public ExcelApiOutput collectISSchemeData() {
        String batchName;
        block9: {
            boolean isSync = (Boolean)this.param.get("isSync");
            boolean isEntryIntegrate = false;
            long modelId = LongUtil.toLong(this.param.get("modelId"));
            String modelNumber = this.param.get("modelNumber").toString();
            long scenarioId = LongUtil.toLong(this.param.get("scenarioId"));
            String scenarioNumber = this.param.get("scenarioNumber").toString();
            long yearId = LongUtil.toLong(this.param.get("yearId"));
            String yearNumber = this.param.get("yearNumber").toString();
            long periodId = LongUtil.toLong(this.param.get("periodId"));
            String periodNumber = this.param.get("periodNumber").toString();
            long currencyId = LongUtil.toLong(this.param.get("currencyId"));
            String currencyNumber = this.param.get("currencyNumber").toString();
            batchName = "EPM_" + Long.toString(modelId) + "_" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            ArrayList details = (ArrayList)this.param.get("details");
            if (details.size() == 0) {
                return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u96c6\u6210\u7684\u6570\u636e\u3002", (String)"ExcelSerivce_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            try {
                IntegrateEntity intEntity = new IntegrateEntity();
                intEntity.setModel(Long.valueOf(modelId), modelNumber);
                intEntity.setScene(Long.valueOf(scenarioId), scenarioNumber);
                intEntity.setYear(Long.valueOf(yearId), yearNumber);
                intEntity.setPeriod(Long.valueOf(periodId), periodNumber);
                intEntity.setCurrency(Long.valueOf(currencyId), currencyNumber);
                intEntity.putCustomParam("isEntryIntegrate", (Object)isEntryIntegrate);
                intEntity.putCustomParam("batchname", (Object)batchName);
                List rateOrgIdList = IntegrationUtil.getRateOrgIdList((Long)((Long)intEntity.getModel().p1));
                for (Map row : details) {
                    long orgId = LongUtil.toLong(row.get("orgId"));
                    String orgNumber = row.get("orgNumber").toString();
                    long schemeId = LongUtil.toLong(row.get("schemeId"));
                    String schemeNumber = row.get("schemeNumber").toString();
                    if (rateOrgIdList.contains(orgId)) {
                        IntegrationUtil.saveRateSchemeCurrency2IntEntity((IntegrateEntity)intEntity, (long)schemeId, (String)orgNumber);
                        List currency4Rate = intEntity.getCurrency4Rate();
                        for (int i = 0; i < currency4Rate.size(); ++i) {
                            intEntity.addOrgSchemePair(Long.valueOf(orgId), orgNumber, Long.valueOf(schemeId), schemeNumber);
                        }
                        continue;
                    }
                    intEntity.addOrgSchemePair(Long.valueOf(orgId), orgNumber, Long.valueOf(schemeId), schemeNumber);
                }
                if (intEntity.getOrgSchemePairs().isEmpty()) {
                    return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u6cd5\u4eba\u8d22\u62a5\u7684\u5206\u5f55\u96c6\u6210\u529f\u80fd\u4ec5\u652f\u6301location\u4e3aPR\u7684\u96c6\u6210\u65b9\u6848\u3002", (String)"ISSchemeDataCollectPlugin2_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (!IntegrateDispatcher2.submitTask2((IntegrateEntity)intEntity, (boolean)isSync, (boolean)isEntryIntegrate, null)) {
                    return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\u8f83\u957f\uff0c\u5df2\u8fdb\u5165\u540e\u53f0\u6267\u884c\u4e2d\u3002\u8bf7\u67e5\u770b\u5177\u4f53\u65e5\u5fd7\u4ee5\u4e86\u89e3\u6267\u884c\u60c5\u51b5\u3002", (String)"ISSchemeDataCollectPlugin2_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.printLogMessage(details, modelId, isSync);
            }
            catch (Exception e) {
                if (null != e.getCause()) {
                    return new ExcelApiOutput(false, ThrowableHelper.toString((Exception)e));
                }
                if (null == e.getStackTrace()) break block9;
                return new ExcelApiOutput(false, ThrowableHelper.toString((Exception)e));
            }
        }
        return new ExcelApiOutput(batchName);
    }

    public List<ISSchemesResult> getDataCollectResult() {
        List paramList = (List)this.param.get("Filters");
        ArrayList<ISSchemesResult> result = new ArrayList<ISSchemesResult>(paramList.size());
        for (Map item : paramList) {
            ISSchemesResult data = new ISSchemesResult();
            data.setModelId(LongUtil.toLong(item.get("modelId")));
            data.setScenarioId(LongUtil.toLong(item.get("scenarioId")));
            data.setFyId(LongUtil.toLong(item.get("yearId")));
            data.setPeriodId(LongUtil.toLong(item.get("periodId")));
            if (item.get("currencyId") != null && !StringUtil.isEmptyString((String)item.get("currencyId").toString())) {
                data.setCurrencyId(LongUtil.toLong(item.get("currencyId")));
            }
            data.setSchemeId(LongUtil.toLong(item.get("schemeId")));
            data.setOrgId(LongUtil.toLong(item.get("orgId")));
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("model", "=", (Object)data.getModelId()));
            qfBuilder.add(new QFilter("scenario", "=", (Object)data.getScenarioId()));
            qfBuilder.add(new QFilter("fy", "=", (Object)data.getFyId()));
            qfBuilder.add(new QFilter("period", "=", (Object)data.getPeriodId()));
            qfBuilder.add(new QFilter("scheme", "=", (Object)data.getSchemeId()));
            qfBuilder.add(new QFilter("org", "=", (Object)data.getOrgId()));
            if (data.getCurrencyId() != 0L) {
                qfBuilder.add(new QFilter("currency", "=", (Object)data.getCurrencyId()));
            }
            String selectProperties = "collectstatus";
            DynamicObject cacheData = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_isschemeexecuterec", (String)selectProperties, (QFilter[])qfBuilder.toArray());
            QFBuilder qfLogBuilder = new QFBuilder();
            qfLogBuilder.add(new QFilter("model", "=", (Object)data.getModelId()));
            qfLogBuilder.add(new QFilter("fy", "=", (Object)data.getFyId()));
            qfLogBuilder.add(new QFilter("period", "=", (Object)data.getPeriodId()));
            qfLogBuilder.add(new QFilter("scheme", "=", (Object)data.getSchemeId()));
            qfLogBuilder.add(new QFilter("org", "=", (Object)data.getOrgId()));
            if (cacheData != null) {
                DynamicObjectCollection logs;
                data.setCollectStatus(cacheData.getInt("collectstatus"));
                if (data.getCollectStatus() != CollectStatusEnum.READY.getValue() && data.getCollectStatus() != CollectStatusEnum.RUNNING.getValue() && data.getCollectStatus() != CollectStatusEnum.SUCCESS.getValue() && (logs = QueryServiceHelper.query((String)"bcm_isschemecollectlog", (String)"error", (QFilter[])qfLogBuilder.toArray(), (String)"collecttime desc", (int)1)).size() > 0) {
                    data.setCollectResult(((DynamicObject)logs.get(0)).getString("error"));
                }
            } else {
                data.setCollectStatus(CollectStatusEnum.READY.getValue());
            }
            data.setCollectStatusName(CollectStatusEnum.getEnum((Integer)data.getCollectStatus()).getName());
            result.add(data);
        }
        return result;
    }

    private Set<Long> filterByScenario(List<Long> schemeIds, String scenarioNum) {
        HashSet<Long> result = new HashSet<Long>();
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", schemeIds);
        qfb.add("targmembnumber", "in", (Object)scenarioNum);
        DynamicObjectCollection singMaps = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"schemeid.id", (QFilter[])qfb.toArray());
        singMaps.forEach(item -> result.add(item.getLong("schemeid.id")));
        qfb.clear();
        qfb.add("scheme", "in", schemeIds);
        qfb.add("isdimmaptargentry.isdimmaptargdefval.targetmemnum", "=", (Object)scenarioNum);
        DynamicObjectCollection dimMaps = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,scheme.id", (QFilter[])qfb.toArray());
        dimMaps.forEach(item -> result.add(item.getLong("scheme.id")));
        return result;
    }

    private void printLogMessage(List<Map<String, Object>> details, long modelId, boolean isSync) {
        if (details == null || details.size() == 0) {
            return;
        }
        String doName = "";
        String doSuccesss = "";
        if (isSync) {
            doName = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6", (String)"ISSchemeDataCollectPlugin2_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            doSuccesss = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6\u5b8c\u6210", (String)"ISSchemeDataCollectPlugin2_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else {
            doName = ResManager.loadKDString((String)"\u5b9e\u65f6\u62bd\u53d6", (String)"ISSchemeDataCollectPlugin2_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            doSuccesss = ResManager.loadKDString((String)"\u5b9e\u65f6\u62bd\u53d6\u6210\u529f", (String)"ISSchemeDataCollectPlugin2_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        Object map = null;
        try {
            ArrayList<String> opDescriptions = new ArrayList<String>(details.size());
            HashMap<String, String> orgNames = new HashMap<String, String>(5);
            HashMap<String, String> schemeNames = new HashMap<String, String>(5);
            String orgNumber = null;
            String schemeNumber = null;
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            for (Map<String, Object> row : details) {
                orgNumber = row.get("orgNumber").toString();
                if (!orgNames.containsKey(orgNumber)) {
                    orgNames.put(orgNumber, MemberReader.findEntityMemberByNum((String)modelNumber, (String)orgNumber).getName());
                }
                if (schemeNames.containsKey(schemeNumber = row.get("schemeNumber").toString())) continue;
                schemeNames.put(schemeNumber, MemberReader.findScenaMemberByNum((String)modelNumber, (String)schemeNumber).getName());
            }
            for (Map<String, Object> row : details) {
                orgNumber = row.get("orgNumber").toString();
                schemeNumber = row.get("schemeNumber").toString();
                opDescriptions.add((String)orgNames.get(orgNumber) + " " + orgNumber + " " + schemeNumber + " " + (String)schemeNames.get(schemeNumber) + "," + doSuccesss);
            }
            OperationLogUtil.batchWriteOperationLog((String)doName, opDescriptions, (Long)modelId, (String)"bcm_isschemecollectlist2");
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }
}

