/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimShowPropertyEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.excel.AbstractExcelAction;
import kd.fi.bcm.formplugin.excel.dto.ComboItem;
import kd.fi.bcm.formplugin.excel.dto.DimMetaField;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ExcelDimensionManagerAction
extends AbstractExcelAction {
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());

    public ExcelDimensionManagerAction(Map<String, Object> param) {
        super(param);
    }

    public List<DimMetaField> getDimProperties() {
        long modelId = LongUtil.toLong(this.param.get("modelId"));
        String dimensionNumber = this.param.get("dimensionNumber").toString();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        qFilters.add(new QFilter("number", "=", (Object)dimensionNumber));
        DynamicObject dimData = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,membermodel,issysdimension", (QFilter[])qFilters.toArray(new QFilter[0]));
        String memberModel = "";
        if (null != dimData) {
            memberModel = dimData.getString("membermodel");
        } else {
            dimData = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (null != dimData) {
                memberModel = "bcm_structofextend";
            }
        }
        if (StringUtil.isEmptyString((String)memberModel)) {
            return new ArrayList<DimMetaField>();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)memberModel);
        List<String> showField = this.getProperties(memberModel, "cm");
        ArrayList<DimMetaField> result = new ArrayList<DimMetaField>();
        for (IDataEntityProperty p : dataEntityType.getProperties()) {
            DimMetaField field = new DimMetaField();
            if (null == p.getDisplayName()) {
                field.setDisplayName(p.getName());
            } else {
                field.setDisplayName(p.getDisplayName().getLocaleValue());
            }
            if (showField.contains(p.getName()) || showField.contains("parent.name") && p.getName().equals("parent")) {
                field.setVisible(true);
                int index = showField.indexOf(p.getName());
                field.setSequ(index);
            }
            field.setName(p.getName());
            field.setEnableNull(p.isEnableNull());
            field.setReadonly(p.getReadOnly());
            if (p instanceof BasedataProp) {
                field.setDisplayProp(((BasedataProp)p).getDisplayProp());
            }
            if (p instanceof ComboProp) {
                ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                ((ComboProp)p).getComboItems().forEach(x -> {
                    ComboItem item = new ComboItem();
                    item.setText(x.getName().getLocaleValue());
                    item.setValue(x.getValue());
                    items.add(item);
                });
                field.setComboItems(items);
            }
            result.add(field);
        }
        return result;
    }

    public List<Map<String, Object>> getMemberDataByFieldLazy() {
        long modelId = LongUtil.toLong(this.param.get("modelId"));
        String dimensionNumber = this.param.get("dimensionNumber").toString();
        ArrayList fields = new ArrayList();
        if (this.param.containsKey("queryFields")) {
            fields.addAll((List)this.param.get("queryFields"));
        }
        ArrayList<QFilter> qFiltersDim = new ArrayList<QFilter>(2);
        qFiltersDim.add(new QFilter("model_id", "=", (Object)modelId));
        qFiltersDim.add(new QFilter("number", "=", (Object)dimensionNumber));
        DynamicObject dimData = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,membermodel,issysdimension", (QFilter[])qFiltersDim.toArray(new QFilter[0]));
        long DimensionId = 0L;
        String memberModel = "";
        if (null != dimData) {
            DimensionId = dimData.getLong("id");
            memberModel = dimData.getString("membermodel");
        } else {
            dimData = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"id", (QFilter[])qFiltersDim.toArray(new QFilter[0]));
            if (null != dimData) {
                DimensionId = dimData.getLong("id");
                memberModel = "bcm_structofextend";
            }
        }
        if (0L == DimensionId) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<QFilter> qFiltersMember = new ArrayList<QFilter>();
        qFiltersMember.add(new QFilter("model_id", "=", (Object)modelId));
        QFilter qcd = new QFilter("dimension", "=", (Object)DimensionId);
        qFiltersMember.add(qcd);
        if (this.param.containsKey("schemeId") && dimensionNumber.equals(PresetConstant.ENTITY_DIM)) {
            qFiltersMember.add(new QFilter("cslscheme.id", "=", (Object)LongUtil.toLong(this.param.get("schemeId"))));
        }
        qFiltersMember.add(new QFilter("status", "!=", (Object)"A"));
        if (this.param.containsKey("parentId")) {
            long parentId = LongUtil.toLong(this.param.get("parentId"));
            String longNumber = this.param.get("longNumber").toString();
            switch ((Integer)this.param.get("expandLevel")) {
                case 1: {
                    qFiltersMember.add(new QFilter("parent.id", "=", (Object)parentId));
                    break;
                }
                case 2: {
                    qFiltersMember.add(new QFilter("longNumber", "!=", (Object)longNumber));
                    qFiltersMember.add(new QFilter("longNumber", "like", (Object)(longNumber + "%")));
                    break;
                }
                case 3: {
                    qFiltersMember.add(new QFilter("longNumber", "!=", (Object)longNumber));
                    qFiltersMember.add(new QFilter("longNumber", "like", (Object)(longNumber + "%")));
                    qFiltersMember.add(new QFilter("isLeaf", "=", (Object)"1"));
                    break;
                }
                default: {
                    qFiltersMember.add(new QFilter("parent.id", "=", (Object)parentId));
                    break;
                }
            }
        } else {
            qFiltersMember.add(new QFilter("level", "in", Arrays.asList(1, 2)));
        }
        if (fields.isEmpty()) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)memberModel);
            dataEntityType.getProperties().forEach(x -> fields.add(x.getName()));
        }
        DynamicObjectCollection memberData = QueryServiceHelper.query((String)this.getClass().getName(), (String)memberModel, (String)String.join((CharSequence)",", fields.stream().distinct().collect(Collectors.toList())), (QFilter[])qFiltersMember.toArray(new QFilter[0]), (String)"id desc");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject dyobj : memberData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String field : fields) {
                Object valueObj = dyobj.get(field);
                if (valueObj instanceof DynamicObject) {
                    IDataEntityType entityType = ((DynamicObject)dyobj.get(field)).getDataEntityType();
                    if (entityType instanceof RefEntityType) {
                        String nameProperty = ((RefEntityType)entityType).getNameProperty();
                        if (null == nameProperty || "".equals(nameProperty)) {
                            map.put(field, "");
                            continue;
                        }
                        String translater = ((DynamicObject)valueObj).getLocaleString(nameProperty).getLocaleValue();
                        if (StringUtils.isEmpty((String)translater)) {
                            translater = ((DynamicObject)valueObj).getString(nameProperty);
                        }
                        map.put(field, translater);
                        continue;
                    }
                    if (valueObj instanceof OrmLocaleValue) {
                        if (StringUtils.isEmpty((String)((OrmLocaleValue)valueObj).getLocaleValue())) {
                            map.put(field, ((OrmLocaleValue)valueObj).getLocaleValue_zh_CN());
                            continue;
                        }
                        map.put(field, ((OrmLocaleValue)valueObj).getLocaleValue());
                        continue;
                    }
                    map.put(field, "");
                    continue;
                }
                if (valueObj instanceof OrmLocaleValue) {
                    if (StringUtils.isEmpty((String)((OrmLocaleValue)valueObj).getLocaleValue())) {
                        map.put(field, ((OrmLocaleValue)valueObj).getLocaleValue_zh_CN());
                        continue;
                    }
                    map.put(field, ((OrmLocaleValue)valueObj).getLocaleValue());
                    continue;
                }
                if (valueObj instanceof DynamicObjectCollection) {
                    map.put(field, "");
                    continue;
                }
                map.put(field, dyobj.get(field));
            }
            result.add(map);
        }
        return result;
    }

    private List<String> getProperties(String memberentityid, String appId) {
        DimShowPropertyEnum showpro = DimShowPropertyEnum.getEnumBySign((String)memberentityid, (String)appId);
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList(showpro.getShowlist()));
        if (SysDimensionEnum.DataType.getNumber().equalsIgnoreCase(showpro.name().toLowerCase(Locale.ENGLISH))) {
            properties.add("cycle");
        }
        properties.add("memberid");
        properties.add("longnumber");
        properties.add("nodetype");
        properties.add("creator");
        properties.add("createtime");
        return properties;
    }

    public List<Long> getMemberIdByRange() {
        long modelId = LongUtil.toLong(this.param.get("ModelId"));
        long dimId = LongUtil.toLong(this.param.get("DimensionId"));
        long schemeId = LongUtil.toLong(this.param.get("SchemeId"));
        boolean isProperty = (Boolean)this.param.get("IsProperty");
        List members = (List)this.param.get("Members");
        if (members == null || members.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        String dimNumber = MemberReader.getDimensionNumById((long)dimId);
        String entityNumber = MemberReader.getEntityNumberByDim((String)modelNumber, (String)dimNumber);
        ArrayList results = new ArrayList(6);
        for (Map member : members) {
            long memId = LongUtil.toLong(member.get("MemberId"));
            String memNumber = StringUtils.getStringValue(member.get("MemberNumber"));
            int range = Integer.parseInt(StringUtils.getStringValue(member.get("Range")));
            MembRangeItem item = new MembRangeItem(entityNumber, Long.valueOf(memId), memNumber, range, isProperty, (Object)modelId);
            if ("bcm_entitymembertree".equals(entityNumber) && schemeId > 0L) {
                item.setSchemeId(schemeId);
            }
            item.matchItems(i -> results.add(i.getId()));
        }
        return results.stream().distinct().collect(Collectors.toList());
    }
}

