/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.datacollet.DataCollectRowModel;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.permission.strategy.PermControlStrategy;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.business.util.DefaultPageDimSettingUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.excel.AbstractExcelAction;
import kd.fi.bcm.formplugin.excel.dto.AbstractDimMember;
import kd.fi.bcm.formplugin.excel.dto.DataCollectTemplate;
import kd.fi.bcm.formplugin.excel.dto.DimMember;
import kd.fi.bcm.formplugin.excel.dto.Dimension;
import kd.fi.bcm.formplugin.excel.dto.ExcelApiOutput;
import kd.fi.bcm.formplugin.excel.dto.ReportTemplate;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.datacollect.DCContext;
import kd.fi.bcm.spread.datacollect.DataCollectService;
import org.apache.commons.collections.CollectionUtils;

public class ExcelFormulaDataCollectAction
extends AbstractExcelAction {
    protected WatchLogger log;
    private static final String only_weave = "1";
    private static final String ID = "id";
    private static final String not_found = "not found";
    private Set<String> excludeDims = Sets.newHashSet((Object[])new String[]{PresetConstant.ENTITY_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM});

    public ExcelFormulaDataCollectAction(Map<String, Object> param) {
        super(param);
        this.log = BcmLogFactory.getWatchLogInstance(this.getClass());
    }

    public List<DataCollectTemplate> getDataCollectTemplate() {
        Long yearId = LongUtil.toLong(this.param.get("yearId"));
        Long periodId = LongUtil.toLong(this.param.get("periodId"));
        Long modelId = LongUtil.toLong(this.param.get("modelId"));
        Long scenarioId = LongUtil.toLong(this.param.get("scenarioId"));
        String yearNumber = this.param.get("yearNumber").toString();
        List entityNumbers = (List)this.param.get("entityNumbers");
        List filterTemps = (List)this.param.get("templateIds");
        List filterTempClassifications = (List)this.param.get("filterTempClassifications");
        Set templateIds = TemplateDistributionOrgUtil.getDispenseTemplateIds((Object)modelId);
        Collection rigntids = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)yearId, (Long)periodId, new HashSet(templateIds)).values();
        List<Long> newTemplateIds = new ArrayList<Long>(10);
        for (Long templateId : templateIds) {
            if (!rigntids.contains(templateId)) continue;
            newTemplateIds.add(templateId);
        }
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        Set<Long> perm = this.getPerm(modelId);
        if (!perm.isEmpty() && !adminUserBol) {
            newTemplateIds.removeAll(perm);
        }
        if (filterTemps.size() > 0) {
            newTemplateIds = newTemplateIds.stream().filter(x -> filterTemps.contains(x)).collect(Collectors.toList());
        }
        List noPermsCatalog = new ArrayList(1);
        if (!adminUserBol) {
            ArrayListMultimap permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_templatecatalog", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId());
            noPermsCatalog = permissionMap.get((Object)DataTypeEnum.NO.getIndex());
        }
        List<TemplateModel> TemplateModels = ModelDataProvider.batchGetTemplateModel(newTemplateIds, modelId);
        List<Object> templateModelsByFilter = new ArrayList(10);
        Object templateModel = null;
        for (TemplateModel templateModelItem : TemplateModels) {
            if (!TemplateRangeService.isInnerRange((String)"bcm_fymembertree", (TemplateModel)templateModelItem, (Object)yearId, (boolean)true) || !TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)templateModelItem, (Object)scenarioId, (boolean)true) || !TemplateRangeService.isInnerRange((String)"bcm_periodmembertree", (TemplateModel)templateModelItem, (Object)periodId, (boolean)true) || noPermsCatalog.contains(templateModelItem.getTemplateCatalog().getId())) continue;
            templateModelsByFilter.add(templateModelItem);
        }
        templateModelsByFilter = templateModelsByFilter.stream().filter(template -> only_weave.equals(template.get("usage")) && Boolean.FALSE.equals(template.get("isonlyread"))).collect(Collectors.toList());
        DynamicObjectCollection orgs = TemplateRangeService.getHavePermOrgSetWithShare((Object)modelId);
        DynamicObjectCollection orgsCopy = new DynamicObjectCollection();
        orgsCopy.addAll((Collection)orgs);
        FilterOrgStructParam param = new FilterOrgStructParam(modelId.longValue(), scenarioId.longValue(), yearNumber, periodId.longValue());
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)orgs);
        OrgServiceHelper.getMergeOrgListByParentDisable((DynamicObjectCollection)orgs, (Object)modelId.toString(), (long)scenarioId, (String)yearNumber, (Object)periodId.toString(), null);
        OrgServiceHelper.dealNoMergeOrgList((DynamicObjectCollection)orgs, (Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId);
        DynamicObjectCollection orgsList = new DynamicObjectCollection();
        if (CollectionUtils.isNotEmpty((Collection)entityNumbers) && CollectionUtils.isNotEmpty((Collection)orgs)) {
            for (String s : entityNumbers) {
                for (DynamicObject org : orgs) {
                    if (!s.equals(org.getString("number"))) continue;
                    orgsList.add((Object)org);
                }
            }
        } else {
            orgsList.addAll((Collection)orgs);
        }
        ArrayList<TemplateModel> tempList2 = new ArrayList<TemplateModel>(16);
        if (CollectionUtils.isNotEmpty((Collection)filterTempClassifications) && CollectionUtils.isNotEmpty(templateModelsByFilter)) {
            int templateClassNameListSize = filterTempClassifications.size();
            int templatesSize = templateModelsByFilter.size();
            for (int i = 0; i < templateClassNameListSize; ++i) {
                for (int j = 0; j < templatesSize; ++j) {
                    if (!((Long)filterTempClassifications.get(i)).equals(((DynaEntityObject)((TemplateModel)templateModelsByFilter.get(j)).get("templatecatalog")).getId())) continue;
                    tempList2.add((TemplateModel)templateModelsByFilter.get(j));
                }
            }
        }
        if (null == filterTempClassifications || filterTempClassifications.size() == 0) {
            tempList2.addAll(templateModelsByFilter);
        }
        Set<Long> orgIdSet = this.getBaseId(orgsList);
        List baseOrgs = orgsCopy.stream().filter(e -> orgIdSet.contains(e.getLong(ID))).sorted(Comparator.comparing(e -> e.getString("number"))).collect(Collectors.toList());
        DynamicObjectCollection baseOrgDys = new DynamicObjectCollection();
        baseOrgDys.addAll(baseOrgs);
        List<DataCollectTemplate> temps = this.buildCollectDataNodes(baseOrgDys, tempList2);
        this.fillPageDimension(temps, new ArrayList<Long>(templateIds), orgIdSet);
        this.fillExecuteStatus(temps, orgIdSet);
        this.fillFlowStatus(temps);
        return temps;
    }

    public ExcelApiOutput batchExcuteDataCollect() {
        Long yearId = LongUtil.toLong(this.param.get("yearId"));
        Long periodId = LongUtil.toLong(this.param.get("periodId"));
        Long scenarioId = LongUtil.toLong(this.param.get("scenarioId"));
        Long modelId = LongUtil.toLong(this.param.get("modelId"));
        String yearNumber = this.param.get("yearNumber").toString();
        String periodNumber = this.param.get("periodNumber").toString();
        String scenarioNumber = this.param.get("scenarioNumber").toString();
        String modelNumber = this.param.get("modelNumber").toString();
        boolean isSort = (Boolean)this.param.get("isSort");
        boolean isReCet = (Boolean)this.param.get("isRecalculate");
        ArrayList<String> errorMessages = new ArrayList<String>();
        this.checkPeriodStatus(errorMessages);
        this.checkMcStatus(errorMessages);
        this.checkCurrency(errorMessages);
        if (errorMessages.size() > 0) {
            return new ExcelApiOutput(false, errorMessages.stream().collect(Collectors.joining("\n")));
        }
        List<HashMap<String, Object>> dataCollectTemps = this.checkByReportStatus();
        if (dataCollectTemps.size() == 0) {
            return new ExcelApiOutput(true);
        }
        HashMultimap dataCollectRowsByOrg = HashMultimap.create();
        HashMultimap organdtmp = HashMultimap.create();
        List<String> opDescriptions = new ArrayList<String>();
        for (HashMap<String, Object> dataCollectTemplate : dataCollectTemps) {
            List templates = (List)dataCollectTemplate.get("Templates");
            for (HashMap template : templates) {
                Long templateId = LongUtil.toLong(template.get("Id"));
                Long orgId = LongUtil.toLong((Object)dataCollectTemplate.get("EntityId"));
                String orgNum = dataCollectTemplate.get("EntityNumber").toString();
                DataCollectRowModel dataCollectModel = new DataCollectRowModel(orgId.longValue(), templateId.longValue(), orgNum);
                dataCollectRowsByOrg.put((Object)orgId, (Object)dataCollectModel);
                organdtmp.put((Object)orgId, (Object)templateId);
                opDescriptions.add(orgNum + " " + dataCollectTemplate.get("EntityName") + " " + template.get("Number") + " " + template.get("Name"));
            }
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("scenario", "=", (Object)scenarioId);
        qfBuilder.add("fy", "=", (Object)yearId);
        qfBuilder.add("period", "=", (Object)periodId);
        qfBuilder.add("model", "=", (Object)modelId);
        DCContext _ctx = new DCContext(SimpleItem.newOne((Object)modelId, (String)modelNumber), SimpleItem.newOne((Object)scenarioId, (String)scenarioNumber), SimpleItem.newOne((Object)yearId, (String)yearNumber), SimpleItem.newOne((Object)periodId, (String)periodNumber), (Multimap)organdtmp);
        _ctx.setSort(isSort);
        _ctx.setReCollect(isReCet);
        new DataCollectService(_ctx).excute();
        if (opDescriptions.size() > 0) {
            opDescriptions = opDescriptions.stream().map(desc -> String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6570\u636e\u91c7\u96c6\u6267\u884c\u6210\u529f\u3002", (String)"DataCollectedNewPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), desc)).collect(Collectors.toList());
            OperationLogUtil.batchWriteOperationLog((String)ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u91c7\u96c6", (String)"DataCollectedNewPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opDescriptions, (Long)this.getModelId(), (String)"bcm_datacollection");
        }
        return new ExcelApiOutput(true);
    }

    public Map<String, Integer> getTemplateExcuteStatus() {
        Long modelId = this.getModelId();
        Long fyId = LongUtil.toLong(this.param.get("yearId"));
        Long periodId = LongUtil.toLong(this.param.get("periodId"));
        Long scenarioId = LongUtil.toLong(this.param.get("scenarioId"));
        Map OrgAndTemp = (Map)this.param.get("orgTempMap");
        QFBuilder filter = new QFBuilder();
        filter.add("model", "=", (Object)modelId);
        filter.and("fy", "=", (Object)fyId);
        filter.and("period", "=", (Object)periodId);
        filter.and("scenario", "=", (Object)scenarioId);
        List orgs = OrgAndTemp.keySet().stream().map(x -> LongUtil.toLong((Object)x)).collect(Collectors.toList());
        filter.and("org", "in", orgs);
        DynamicObjectCollection allstatus = QueryServiceHelper.query((String)"bcm_datacollect", (String)"org.id,template.id,collectstatus,modifydate,modifier.name", (QFilter[])filter.toArray());
        HashBasedTable statustable = HashBasedTable.create();
        for (DynamicObject obj : allstatus) {
            statustable.put((Object)obj.getString("org.id"), (Object)obj.getString("template.id"), (Object)obj);
        }
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        for (Map.Entry entry : OrgAndTemp.entrySet()) {
            for (Long tempId : (List)entry.getValue()) {
                DynamicObject s = (DynamicObject)statustable.get((Object)String.valueOf(entry.getKey()), (Object)String.valueOf(tempId));
                resultMap.put((String)entry.getKey() + "|" + tempId.toString(), s.getInt("collectstatus"));
            }
        }
        return resultMap;
    }

    public ExcelApiOutput savePageDimension() {
        Long entityId = LongUtil.toLong(this.param.get("entityId"));
        Long templateId = LongUtil.toLong(this.param.get("templateId"));
        List pageDims = (List)this.param.get("pageDimensions");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        QFilter filter = new QFilter("template", "=", (Object)templateId);
        QFilter orgfilter = new QFilter("org", "=", (Object)entityId);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_pageselect", (String)"id,dimension,member", (QFilter[])new QFilter[]{filter, orgfilter});
        if (dys != null && dys.length > 0) {
            for (DynamicObject dyObj : dys) {
                map.put(dyObj.getString("dimension.number"), dyObj);
            }
        }
        if (pageDims != null && pageDims.size() > 0) {
            for (Map pagedim : pageDims) {
                Long memberId = LongUtil.toLong(pagedim.get("memberId"));
                String dimNumber = pagedim.get("dimNumber").toString();
                if (dys != null && dys.length > 0) {
                    DynamicObject dyDim = kd.fi.bcm.formplugin.report.util.DataCollectUtil.getDim(memberId, DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimNumber));
                    DynamicObject dyObj = (DynamicObject)map.get(dyDim.getString("dimension.number"));
                    dyObj.set("dimension", (Object)dyDim.getDynamicObject("dimension"));
                    dyObj.set("member", (Object)memberId);
                    list.add(dyObj);
                    continue;
                }
                DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_pageselect");
                dyObj.set("dimension", (Object)kd.fi.bcm.formplugin.report.util.DataCollectUtil.getDim(memberId, DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimNumber)).getDynamicObject("dimension"));
                dyObj.set("member", (Object)memberId);
                dyObj.set("template", (Object)templateId);
                dyObj.set("org", (Object)entityId);
                list.add(dyObj);
            }
            BusinessDataServiceHelper.save((IDataEntityType)((DynamicObject)list.get(0)).getDataEntityType(), (Object[])list.toArray());
        }
        return new ExcelApiOutput(true);
    }

    private List<DataCollectTemplate> buildCollectDataNodes(DynamicObjectCollection orgs, Collection<TemplateModel> templates) {
        List tempNums = templates.stream().map(t -> t.getNumber()).collect(Collectors.toList());
        QFilter qf = new QFilter("template.number", "in", tempNums);
        QFilter groupQf = new QFilter("template.number", "in", tempNums);
        HashSet hasAuthTmpNums = new HashSet(16);
        HashSet notHasAuthTmpNums = new HashSet(16);
        TemplateUtil.setUserAuth((Long)this.getModelId(), (Long)Long.valueOf(RequestContext.get().getUserId()), hasAuthTmpNums, notHasAuthTmpNums, (QFilter)qf);
        HashSet groupHasAuthTempNums = new HashSet(16);
        HashSet groupNotHasAuthTempNums = new HashSet(16);
        TemplateUtil.setGroupAuth((Long)this.getModelId(), (Long)Long.valueOf(RequestContext.get().getUserId()), groupHasAuthTempNums, groupNotHasAuthTempNums, (QFilter)groupQf);
        HashSet allTempNums = new HashSet(hasAuthTmpNums);
        allTempNums.addAll(notHasAuthTmpNums);
        allTempNums.addAll(groupHasAuthTempNums);
        allTempNums.addAll(groupNotHasAuthTempNums);
        Set groups = templates.stream().map(TemplateModel::getGroup).collect(Collectors.toSet());
        Map maxVersionDefault = TemplateUtil.getMaxVersionDefault(groups);
        ArrayList<DataCollectTemplate> temInfoSet = new ArrayList<DataCollectTemplate>(16);
        HashMultimap dispenseMap = HashMultimap.create();
        List ids = templates.stream().map(x -> x.getId()).collect(Collectors.toList());
        if (ids != null) {
            QFBuilder qfb = new QFBuilder();
            qfb.add("model", "=", (Object)this.getModelId());
            qfb.add("template", "in", ids);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bcm_distributionentity", (String)"template.id,entity.id,entity.number,entity.longnumber,definedpropertyvalue.number,definedpropertyvalue.id,definedpropertyvalue.longnumber,memrangdecombo", (QFilter[])qfb.toArray());
            coll.forEach(e -> dispenseMap.put((Object)e.getLong("template.id"), e));
        }
        if (orgs != null && !templates.isEmpty()) {
            orgs.forEach(e -> {
                DataCollectTemplate pNode = new DataCollectTemplate();
                pNode.setEntityNumber(e.getString("number"));
                pNode.setEntityName(e.getString("name"));
                pNode.setEntityId(e.getLong(ID));
                templates.forEach(t -> {
                    if (this.isInnerTemplateDispenseRange((TemplateModel)t, e.getLong(ID), (HashMultimap<Long, DynamicObject>)dispenseMap)) {
                        if (maxVersionDefault.get(t.getNumber()) != null) {
                            boolean isDefaultHasAuth = (Boolean)maxVersionDefault.get(t.getNumber());
                            boolean isFilter = TemplateUtil.isFilter((String)t.getNumber(), (boolean)isDefaultHasAuth, (Set)notHasAuthTmpNums, (Set)groupNotHasAuthTempNums, (Set)allTempNums);
                            if (isFilter) {
                                return;
                            }
                        }
                        pNode.getTemplates().add(this.getReportTemplate((TemplateModel)t));
                    }
                });
                temInfoSet.add(pNode);
            });
        }
        return temInfoSet;
    }

    private void fillPageDimension(List<DataCollectTemplate> billNodes, List<Long> templateIds, Set<Long> orgIdList) {
        Map<String, Object> temOrgNameMap = this.getAllselectPagesByCondition(templateIds, orgIdList);
        for (DataCollectTemplate dataCollectTemplate : billNodes) {
            for (ReportTemplate template : dataCollectTemplate.getTemplates()) {
                if (!template.isSaveByDim()) {
                    template.getPagedimension().clear();
                    continue;
                }
                Object obj = temOrgNameMap.get(template.getId() + "_" + dataCollectTemplate.getEntityId());
                if (Objects.isNull(obj)) {
                    obj = temOrgNameMap.get(template.getId() + "_" + 0L);
                }
                if (obj instanceof List) {
                    List pageMembers = (List)obj;
                    template.getPagedimension().clear();
                    List<Dimension> dimensions = pageMembers.stream().map(x -> {
                        Dimension dimension = new Dimension();
                        dimension.setId(x.getDimId());
                        dimension.setNumber(x.getDimNumber());
                        DimMember member = new DimMember();
                        member.setLongNumber(x.getLongNumber());
                        member.setName(x.getName());
                        member.setId(x.getId());
                        member.setDimensionId(x.getDimId());
                        member.setNumber(x.getNumber());
                        ArrayList<AbstractDimMember> members = new ArrayList<AbstractDimMember>();
                        members.add(member);
                        dimension.setMembers(members);
                        return dimension;
                    }).collect(Collectors.toList());
                    template.setPagedimension(dimensions);
                    continue;
                }
                template.getPagedimension().removeIf(x -> this.excludeDims.contains(x.getNumber()));
                for (Dimension dimension : template.getPagedimension()) {
                    dimension.setMembers(null);
                    IDNumberTreeNode memberNode = null;
                    switch (dimension.getNumber()) {
                        case "AuditTrail": 
                        case "Currency": 
                        case "Process": {
                            memberNode = DataCollectUtil.getDefautMem((String)this.getModelNumber(), (String)dimension.getNumber(), (long)0L);
                            break;
                        }
                        case "Account": {
                            break;
                        }
                        case "InternalCompany": {
                            memberNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)"ICNone");
                            break;
                        }
                        case "ChangeType": {
                            memberNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)DimTypesEnum.CHANGETYPE.getNumber(), (String)"EndingBalance");
                            if (null != memberNode) break;
                            memberNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)DimTypesEnum.CHANGETYPE.getNumber(), (String)"YTD");
                            break;
                        }
                        case "MultiGAAP": {
                            memberNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)DimTypesEnum.MULTIGAAP.getNumber(), (String)"PRCGAAP");
                            break;
                        }
                        case "DataSort": {
                            memberNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)DimTypesEnum.DATASORT.getNumber(), (String)"Actual");
                            break;
                        }
                        default: {
                            memberNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)dimension.getNumber(), (String)(dimension.getShortNumber() + "None"));
                        }
                    }
                    if (null == memberNode || memberNode.getNumber().equals(not_found)) continue;
                    ArrayList<AbstractDimMember> members = new ArrayList<AbstractDimMember>();
                    DimMember member = new DimMember();
                    member.setLongNumber(memberNode.getLongNumber());
                    member.setName(memberNode.getName());
                    member.setId(memberNode.getId());
                    member.setDimensionId(dimension.getId());
                    member.setNumber(memberNode.getNumber());
                    members.add(member);
                    dimension.setMembers(members);
                }
            }
        }
    }

    private Map<String, Object> getAllselectPagesByCondition(List<Long> templateIds, Set<Long> orgidList) {
        return DefaultPageDimSettingUtil.getAllselectPagesByCondition((String)MemberReader.findModelNumberById((Object)this.getModelId()), templateIds, orgidList, (boolean)true);
    }

    private void fillExecuteStatus(List<DataCollectTemplate> billNodes, Set<Long> orgIdSet) {
        Long modelId = this.getModelId();
        Long fyId = LongUtil.toLong(this.param.get("yearId"));
        Long periodId = LongUtil.toLong(this.param.get("periodId"));
        QFBuilder filter = new QFBuilder();
        filter.add("model", "=", (Object)modelId);
        filter.and("fy", "=", (Object)fyId);
        filter.and("period", "=", (Object)periodId);
        filter.and("org", "in", orgIdSet);
        DynamicObjectCollection allstatus = QueryServiceHelper.query((String)"bcm_datacollect", (String)"org.id,template.id,collectstatus,modifydate,modifier.name", (QFilter[])filter.toArray());
        HashBasedTable statustable = HashBasedTable.create();
        for (DynamicObject obj : allstatus) {
            statustable.put((Object)obj.getString("org.id"), (Object)obj.getString("template.id"), (Object)obj);
        }
        billNodes.forEach(arg_0 -> ExcelFormulaDataCollectAction.lambda$fillExecuteStatus$13((Table)statustable, arg_0));
    }

    private void fillFlowStatus(List<DataCollectTemplate> billNodes) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)this.getModelId()));
        builder.add(new QFilter("scene", "=", (Object)this.getScenarioId()));
        builder.add(new QFilter("fyear", "=", (Object)this.getYearId()));
        builder.add(new QFilter("period", "=", (Object)this.getPeriodId()));
        Map<String, Map<Long, Map<String, String>>> comMemMapsMaps = this.getComMemMapsByNode(billNodes);
        QFBuilder orgbuilder = new QFBuilder();
        for (DataCollectTemplate dataCollectTemplate : billNodes) {
            for (ReportTemplate template : dataCollectTemplate.getTemplates()) {
                QFilter temp = new QFilter("template", "=", (Object)template.getId());
                temp.and(new QFilter("entity", "=", (Object)dataCollectTemplate.getEntityId()));
                Map<String, String> orgTempMap = comMemMapsMaps.get(dataCollectTemplate.getEntityNumber()).get(template.getId());
                String curNum = "EC";
                if (StringUtil.isEmptyString((String)orgTempMap.get(DimTypesEnum.CURRENCY.getNumber()))) {
                    curNum = orgTempMap.get(DimTypesEnum.CURRENCY.getNumber());
                }
                Pair msg = TransMemberUtil.transOrgAndCurbyOrgId((String)this.getModelNumber(), (long)dataCollectTemplate.getEntityId(), (String)"EIRpt", (String)curNum, (long)0L, (long)0L);
                temp.and(new QFilter("currency.number", "=", msg.p2));
                orgbuilder.or_null(temp);
            }
        }
        builder.and(orgbuilder);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_reportentity", (String)"entity,template,reportstatus", (QFilter[])builder.toArray());
        for (DataCollectTemplate dataCollectTemplate : billNodes) {
            for (ReportTemplate template : dataCollectTemplate.getTemplates()) {
                Optional<DynamicObject> target = col.stream().filter(x -> x.getLong("template") == template.getId() && x.getLong("entity") == dataCollectTemplate.getEntityId()).findFirst();
                if (!target.isPresent()) {
                    template.setFlowStatus(ReportStatusEnum.UNWEAVE.status());
                    continue;
                }
                template.setFlowStatus(target.get().getString("reportstatus"));
            }
        }
    }

    private boolean isInnerTemplateDispenseRange(TemplateModel t, Long orgId, HashMultimap<Long, DynamicObject> dispenseMap) {
        Set dispensese = dispenseMap.containsKey((Object)t.getId()) ? dispenseMap.get((Object)t.getId()) : new HashSet(0);
        boolean isInner = dispensese.stream().anyMatch(d -> {
            boolean isCustom = d.getLong("entity.id") == 0L && d.getLong("definedpropertyvalue.id") != 0L;
            Long mId = isCustom ? d.getLong("definedpropertyvalue.id") : d.getLong("entity.id");
            String mLongNumber = isCustom ? d.getString("definedpropertyvalue.longnumber") : d.getString("entity.longnumber");
            String mnumber = isCustom ? d.getString("definedpropertyvalue.number") : d.getString("entity.number");
            RangeEnum range = RangeEnum.getRangeByVal((int)d.getInt("memrangdecombo"));
            MembBaseItem item = new MembBaseItem("bcm_entitymembertree", mId, mLongNumber, mnumber, range, isCustom, (Object)t.getModelId());
            return PermControlStrategy.getStrategy((RangeEnum)range).isMatchPermission(item, (Object)orgId);
        });
        return isInner;
    }

    private List<HashMap<String, Object>> checkByReportStatus() {
        List dataCollectTemps = (List)this.param.get("dataCollectTemps");
        if (dataCollectTemps.isEmpty() || dataCollectTemps.size() == 0) {
            return dataCollectTemps;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)this.getModelId()));
        builder.add(new QFilter("scene", "=", (Object)this.getScenarioId()));
        builder.add(new QFilter("fyear", "=", (Object)this.getYearId()));
        builder.add(new QFilter("period", "=", (Object)this.getPeriodId()));
        QFBuilder orgbuilder = new QFBuilder();
        Map<String, Map<Long, Map<String, String>>> comMemMapsMaps = this.getComMemMaps(dataCollectTemps);
        for (HashMap dataCollctTemplate : dataCollectTemps) {
            List templates = (List)dataCollctTemplate.get("Templates");
            Long entityId = LongUtil.toLong(dataCollctTemplate.get("EntityId"));
            String entityNumber = dataCollctTemplate.get("EntityNumber").toString();
            for (HashMap template : templates) {
                Long templateId = LongUtil.toLong(template.get("Id"));
                QFilter temp = new QFilter("template", "=", (Object)templateId);
                temp.and(new QFilter("entity", "=", (Object)entityId));
                Map<String, String> orgTempMap = comMemMapsMaps.get(entityNumber).get(templateId);
                String curNum = "EC";
                if (StringUtil.isEmptyString((String)orgTempMap.get(DimTypesEnum.CURRENCY.getNumber()))) {
                    curNum = orgTempMap.get(DimTypesEnum.CURRENCY.getNumber());
                }
                Pair msg = TransMemberUtil.transOrgAndCurbyOrgId((String)this.getModelNumber(), (long)entityId, (String)"EIRpt", (String)curNum, (long)0L, (long)0L);
                temp.and(new QFilter("currency.number", "=", msg.p2));
                orgbuilder.or_null(temp);
            }
        }
        builder.and(orgbuilder);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_reportentity", (String)"entity,template,reportstatus", (QFilter[])builder.toArray());
        for (DynamicObject dot : col) {
            List templates;
            Optional<HashMap> target;
            Optional<HashMap> dataCollctTemplate;
            if (!dot.get("reportstatus").equals("C") && !dot.get("reportstatus").equals("D") || !(dataCollctTemplate = dataCollectTemps.stream().filter(x -> LongUtil.toLong(x.get("EntityId")).longValue() == dot.getLong("entity")).findFirst()).isPresent() || !(target = (templates = (List)dataCollctTemplate.get().get("Templates")).stream().filter(x -> LongUtil.toLong(x.get("Id")).longValue() == dot.getLong("template")).findFirst()).isPresent()) continue;
            templates.remove(target.get());
            if (!templates.isEmpty()) continue;
            dataCollectTemps.remove(dataCollctTemplate.get());
        }
        return dataCollectTemps;
    }

    private Map<String, Map<Long, Map<String, String>>> getComMemMaps(List<HashMap<String, Object>> dataCollctTemplates) {
        HashMap orgNumTempIdMap = Maps.newHashMap();
        for (HashMap<String, Object> dataCollctTemplate : dataCollctTemplates) {
            List templates = (List)dataCollctTemplate.get("Templates");
            for (HashMap template : templates) {
                List tempIDList = (List)orgNumTempIdMap.get(dataCollctTemplate.get("EntityNumber").toString());
                if (CollectionUtils.isEmpty((Collection)tempIDList)) {
                    tempIDList = Lists.newArrayList((Object[])new Long[]{LongUtil.toLong(template.get("Id"))});
                } else {
                    tempIDList.add(LongUtil.toLong(template.get("Id")));
                }
                orgNumTempIdMap.put(dataCollctTemplate.get("EntityNumber").toString(), tempIDList);
            }
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : orgNumTempIdMap.entrySet()) {
            Map comMemMaps = DataCollectUtil.collectPageSelect((String)this.getModelNumber(), (String)((String)entry.getKey()), (List)((List)entry.getValue()));
            result.put(entry.getKey(), comMemMaps);
        }
        return result;
    }

    private Map<String, Map<Long, Map<String, String>>> getComMemMapsByNode(List<DataCollectTemplate> billNodes) {
        HashMap orgNumTempIdMap = Maps.newHashMap();
        for (DataCollectTemplate dataCollctTemplate : billNodes) {
            for (ReportTemplate template : dataCollctTemplate.getTemplates()) {
                List tempIDList = (List)orgNumTempIdMap.get(dataCollctTemplate.getEntityNumber());
                if (CollectionUtils.isEmpty((Collection)tempIDList)) {
                    tempIDList = Lists.newArrayList((Object[])new Long[]{LongUtil.toLong((Object)template.getId())});
                } else {
                    tempIDList.add(LongUtil.toLong((Object)template.getId()));
                }
                orgNumTempIdMap.put(dataCollctTemplate.getEntityNumber(), tempIDList);
            }
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : orgNumTempIdMap.entrySet()) {
            Map comMemMaps = DataCollectUtil.collectPageSelect((String)this.getModelNumber(), (String)((String)entry.getKey()), (List)((List)entry.getValue()));
            result.put(entry.getKey(), comMemMaps);
        }
        return result;
    }

    private void checkCurrency(List<String> errorMessages) {
        List dataCollectTemps = (List)this.param.get("dataCollectTemps");
        HashMap<Long, String> orgIdAndNameMap = new HashMap<Long, String>(16);
        HashMap<Long, String> templateIdAndName = new HashMap<Long, String>(16);
        for (HashMap dataCollectTemp : dataCollectTemps) {
            List templates = (List)dataCollectTemp.get("Templates");
            for (Object template : templates) {
                Long templateId = LongUtil.toLong(((HashMap)template).get("Id"));
                templateIdAndName.put(templateId, ((HashMap)template).get("Name").toString());
                String orgName = dataCollectTemp.get("EntityName").toString();
                Long orgId = LongUtil.toLong(dataCollectTemp.get("EntityId"));
                orgIdAndNameMap.put(orgId, orgName);
            }
        }
        Map orgAndTemplates = DefaultPageDimSettingUtil.getOrgIdAndNotEc((String)this.getModelNumber(), orgIdAndNameMap.keySet(), templateIdAndName.keySet());
        ArrayList orgNameList = new ArrayList(16);
        Long modelId = this.getModelId();
        HashSet<SimpleVo> orgs = new HashSet<SimpleVo>(orgAndTemplates.size());
        for (Long orgId : orgAndTemplates.keySet()) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            orgs.add(SimpleVo.newOne((IDNumberTreeNode)orgNode));
        }
        Map dataMap = ExchangeQueryHelper.queryOrgRate((Long)modelId, (Long)this.getScenarioId(), (Long)this.getYearId(), (Long)this.getPeriodId(), orgs);
        dataMap.forEach((k, v) -> {
            if (((Boolean)v.p1).booleanValue()) {
                orgNameList.add(orgIdAndNameMap.get(k));
            }
        });
        if (orgNameList.size() > 0) {
            errorMessages.add(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\uff0c\u6298\u7b97\u5e01\u65e0\u6cd5\u6267\u884c\u516c\u5f0f\u53d6\u6570\u3002", (String)"DataCollectedNewPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNameList.stream().collect(Collectors.joining(","))));
        }
    }

    private void checkPeriodStatus(List<String> errorMessages) {
        boolean isEnable = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
        if (isEnable) {
            List dataCollectTemps = (List)this.param.get("dataCollectTemps");
            HashMap<String, String> orgNumberMap = new HashMap<String, String>(16);
            for (HashMap dataCollectTemp : dataCollectTemps) {
                String orgNumber = dataCollectTemp.get("EntityNumber").toString();
                String orgName = dataCollectTemp.get("EntityName").toString();
                orgNumberMap.put(orgNumber, orgName);
            }
            Set orgNumbers = orgNumberMap.keySet();
            Set periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)this.getModelId(), orgNumbers, (Long)this.getScenarioId(), (Long)this.getYearId(), (Long)this.getPeriodId(), (String)"datastatus");
            orgNumbers.removeAll(periodOpenOrgSet);
            if (orgNumbers.size() > 0) {
                List orgName = orgNumbers.stream().map(x -> (String)orgNumberMap.get(x)).distinct().collect(Collectors.toList());
                errorMessages.add(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExcelFormulaDataCollectAction_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", orgName)));
            }
        }
    }

    private void checkMcStatus(List<String> errorMessages) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashMap<Long, String> orgMap = new HashMap<Long, String>(16);
        List dataCollectTemps = (List)this.param.get("dataCollectTemps");
        for (HashMap dataCollectTemp : dataCollectTemps) {
            Long orgId = LongUtil.toLong(dataCollectTemp.get("EntityId"));
            String orgName = dataCollectTemp.get("EntityName").toString();
            orgIds.add(orgId);
            orgMap.put(orgId, orgName);
        }
        Map mcStatusMap = McStatus.batchGetMcStatus((Object)this.getModelId(), orgIds, (Object)this.getScenarioId(), (Object)this.getYearId(), (Object)this.getPeriodId());
        ArrayList orgNameList = new ArrayList(16);
        for (Map.Entry entry : mcStatusMap.entrySet()) {
            if (!((McStatus)entry.getValue()).getFlow().isSubmit()) continue;
            orgNameList.add(orgMap.get(entry.getKey()));
        }
        if (orgNameList.size() > 0) {
            errorMessages.add(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u5df2\u7ecf\u63d0\u4ea4\u6216\u8005\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u516c\u5f0f\u53d6\u6570\u3002", (String)"DataCollectedNewPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", orgNameList)));
        }
    }

    private Set<Long> getBaseId(DynamicObjectCollection orgs) {
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (DynamicObject org : orgs) {
            if (org.getLong("copyfrom") == 0L) {
                orgIdSet.add(org.getLong(ID));
                continue;
            }
            orgIdSet.add(org.getLong("copyfrom"));
        }
        return orgIdSet;
    }

    private Set<Long> getPerm(Long modelId) {
        boolean modelManager = MemberPermHelper.isModelManager((Long)modelId);
        HashSet<Long> set = new HashSet<Long>();
        if (modelManager) {
            return set;
        }
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(modelId), (String)String.valueOf(RequestContext.get().getUserId()));
        Collection entries = map.entries();
        for (Map.Entry entrie : entries) {
            if (!DataTypeEnum.NO.getIndex().equals(entrie.getKey())) continue;
            set.add((Long)entrie.getValue());
        }
        return set;
    }

    private String getModelNumber() {
        return this.param.get("modelNumber").toString();
    }

    private static /* synthetic */ void lambda$fillExecuteStatus$13(Table statustable, DataCollectTemplate n) {
        Date maxCollectTime = new Date(0L);
        String collectModifier = null;
        AtomicInteger allUnExecuting = new AtomicInteger(0);
        AtomicInteger allExecuted = new AtomicInteger(0);
        AtomicInteger allExecuting = new AtomicInteger(0);
        for (ReportTemplate c : n.getTemplates()) {
            DynamicObject s = (DynamicObject)statustable.get((Object)String.valueOf(n.getEntityId()), (Object)String.valueOf(c.getId()));
            if (s != null) {
                c.setExecuteStatus(s.getInt("collectstatus"));
                switch (s.getInt("collectstatus")) {
                    case 1: {
                        allUnExecuting.incrementAndGet();
                        break;
                    }
                    case 2: {
                        allExecuting.incrementAndGet();
                        break;
                    }
                    case 3: {
                        allExecuted.incrementAndGet();
                        break;
                    }
                    case 4: {
                        allExecuting.incrementAndGet();
                        break;
                    }
                }
                if (s.getString("collectstatus").equals(only_weave)) {
                    c.setCollectTime(null);
                    c.setCollectModifier(null);
                } else {
                    c.setCollectTime(s.getDate("modifydate"));
                    c.setCollectModifier(s.get("modifier.name").toString());
                }
                if (c.getCollectTime() == null || c.getCollectTime().compareTo(maxCollectTime) <= 0) continue;
                maxCollectTime = c.getCollectTime();
                collectModifier = c.getCollectModifier();
                continue;
            }
            c.setExecuteStatus(1);
            allUnExecuting.incrementAndGet();
        }
        if (allExecuted.get() == n.getTemplates().size()) {
            n.setExecuteStatus(DataCollectRecordEnum.EXECUTED.getValue());
            n.setCollectTime(maxCollectTime);
            n.setCollectModifier(collectModifier);
        } else if (allExecuted.get() == 0 && allExecuting.get() == 0) {
            n.setExecuteStatus(DataCollectRecordEnum.TOEXCUTE.getValue());
        } else {
            n.setExecuteStatus(DataCollectRecordEnum.EXCUTING.getValue());
            n.setCollectTime(maxCollectTime);
            n.setCollectModifier(collectModifier);
        }
    }
}

