/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.Status;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.olap.PeriodRelaMembSupplier;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.power.PowerUserServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.config.IcTypeEnum;
import kd.fi.bcm.formplugin.excel.AbstractExcelAction;
import kd.fi.bcm.formplugin.excel.action.ExcelActionHelper;
import kd.fi.bcm.formplugin.excel.dto.ExtendInfoModel;
import kd.fi.bcm.formplugin.excel.dto.MDResultForExcel;
import kd.fi.bcm.formplugin.excel.dto.ReportCellModel;
import kd.fi.bcm.formplugin.excel.dto.ReportTemplate;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.report.style.adjust.FloatDataProvider;
import kd.fi.bcm.formplugin.report.util.DataCollectUtil;
import kd.fi.bcm.spread.datacollect.OrgDCContext;
import kd.fi.bcm.spread.datacollect.ReportCalculateHelper;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.Domain;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.ReportDataRefleshService;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.dao.ExtDataHandleService;
import kd.fi.bcm.spread.model.dao.Tuple;
import kd.fi.bcm.spread.util.SpreadUtils;
import org.apache.commons.collections.CollectionUtils;

public class ExcelLoadAction
extends AbstractExcelAction {
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    protected Pair<Long, String> model = Pair.onePair((Object)this.getModelId(), (Object)QueryDimensionServiceHelper.getModelNumber((long)this.getModelId()));
    protected Pair<Long, String> scene = Pair.onePair((Object)this.getScenarioId(), (Object)this.getScenarioNumber());
    protected Pair<Long, String> year = Pair.onePair((Object)this.getYearId(), (Object)this.getYearNumber());
    protected Pair<Long, String> period = Pair.onePair((Object)this.getPeriodId(), (Object)this.getPeriodNumber());
    protected Pair<Long, String> currency;
    protected Pair<Long, String> entity = Pair.onePair((Object)this.getEntityId(), (Object)this.getEntityNumber());
    protected Long templateid;

    public ExcelLoadAction(Map<String, Object> param) {
        super(param);
        this.currency = Pair.onePair((Object)this.getCurrencyId(), (Object)this.getCurrencyNumber());
        this.templateid = this.getTemplateId();
    }

    @Override
    public Object execute() {
        return this.getReportTabInfo();
    }

    public Map<String, Object> getReportDetailInfo() {
        QFBuilder qf = this.addQFBuilder();
        DynamicObjectCollection report = QueryServiceHelper.query((String)"bcm_reportentity", (String)"template_id,id, reportstatus", (QFilter[])qf.toArray());
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (DynamicObject dy : report) {
            result.put("" + dy.getLong("template_id"), dy);
        }
        return result;
    }

    public Map<String, Object> getReportFormulaInfo() {
        String status;
        HashMap<String, Object> reportInfo = new HashMap<String, Object>();
        ArrayList<String> errorInfos = new ArrayList<String>();
        HashSet<Long> tmpIds = new HashSet<Long>(16);
        tmpIds.add(this.templateid);
        TemplateModel template = ModelDataProvider.getTemplateModel(TemplateUtil.getRightTplIdByVersioned((Long)((Long)this.model.p1), (Long)((Long)this.year.p1), (Long)((Long)this.period.p1), tmpIds).get(this.templateid));
        SpreadManager currentSpread = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
        this.initSpreadFilter(currentSpread, template);
        this.initFyPeriod(currentSpread);
        Map<String, Object> numbermap = this.getCurrentReportCommonParam(currentSpread, "number");
        Map<String, Object> idmap = this.getCurrentReportCommonParam(currentSpread, "id");
        DynamicObject report = this.getReportInfo();
        if (null != report && ((status = report.getString("reportstatus")).equals("C") || status.equals("D"))) {
            errorInfos.add("StatusError");
            reportInfo.put("calculateErrors", errorInfos);
            return reportInfo;
        }
        if (template.getIsOnlyRead()) {
            errorInfos.add("OnlyRead");
            reportInfo.put("calculateErrors", errorInfos);
            return reportInfo;
        }
        if (template.isSaveByDim()) {
            String currencyNum;
            Long scenarioId;
            Long yearId;
            String auditTrailNum;
            IDNumberTreeNode orgNode;
            Long orgId;
            Long periodId;
            String entityNum;
            String processNum = (String)numbermap.get(DimTypesEnum.PROCESS.getNumber());
            String yearNum = (String)numbermap.get(DimTypesEnum.YEAR.getNumber());
            if (null == yearNum || "".equals(yearNum)) {
                yearNum = (String)this.year.p2;
            }
            if (null == (entityNum = (String)numbermap.get(DimTypesEnum.ENTITY.getNumber())) || "".equals(entityNum)) {
                entityNum = (String)this.entity.p2;
            }
            if ((periodId = LongUtil.toLong((Object)idmap.get(DimTypesEnum.PERIOD.getNumber()))) == 0L) {
                periodId = (Long)this.period.p1;
            }
            if ((orgId = LongUtil.toLong((Object)idmap.get(DimTypesEnum.ENTITY.getNumber()))) == 0L) {
                orgId = (Long)this.entity.p1;
            }
            if (!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isConInputWithOutDim") && !(orgNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgId)).isLeaf()) {
                errorInfos.add(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u7684\u62a5\u8868\u4e0d\u53ef\u6267\u884c\u516c\u5f0f\u53d6\u6570\u3002", (String)"AbstractMultiReportPlugin_71", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if ((auditTrailNum = (String)numbermap.get(DimTypesEnum.AUDITTRIAL.getNumber())) != null && !"EntityInput".equals(auditTrailNum)) {
                errorInfos.add(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u8ba1\u7ebf\u7d22\u7684\u6210\u5458\u4e3a\u6570\u636e\u8f93\u5165\u624d\u80fd\u6267\u884c\u516c\u5f0f\u53d6\u6570\uff0c\u8bf7\u4fee\u6539\u5ba1\u8ba1\u7ebf\u7d22\u540e\u91cd\u65b0\u53d6\u6570\u3002", (String)"AbstractMultiReportPlugin_196", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if ((yearId = LongUtil.toLong((Object)idmap.get(DimTypesEnum.YEAR.getNumber()))) == 0L) {
                yearId = (Long)this.year.p1;
            }
            if ((scenarioId = LongUtil.toLong((Object)idmap.get(DimTypesEnum.SCENARIO.getNumber()))) == 0L) {
                scenarioId = (Long)this.scene.p1;
            }
            if (null == (currencyNum = (String)numbermap.get(DimTypesEnum.CURRENCY.getNumber())) || "".equals(currencyNum)) {
                currencyNum = (String)this.currency.p2;
            }
            DynamicObject dyOrg = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bcm_entitymembertree");
            String orgNum = dyOrg.getString("number");
            if (ExchangeQueryHelper.getAutoConvert((Long)((Long)this.model.p1), (Long)scenarioId, (Long)yearId, (Long)LongUtil.toLong((Object)periodId), (SimpleVo)SimpleVo.newOne((String)orgNum, (Long)orgId)).booleanValue() && !"EC".equals(currencyNum) && !"DC".equals(currencyNum) && !currencyNum.equals(dyOrg.getString("currency.number"))) {
                errorInfos.add(ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u4e0d\u80fd\u6267\u884c\u516c\u5f0f\u53d6\u6570\u3002", (String)"AbstractMultiReportPlugin_198", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            boolean isSumbit = false;
            String orgCurrencyNum = dyOrg.getString("currency.number");
            if (currencyNum.equals(orgCurrencyNum)) {
                Status flow = McStatus.getMcStatus((Object)this.getModelId(), (Object)orgId, (Object)scenarioId, (Object)yearId, (Object)periodId).getFlow();
                boolean bl = isSumbit = !PowerUserServiceHelper.isPowerUserThreadCache((long)this.getModelId()) || flow.isSubmit();
            }
            if (isSumbit) {
                errorInfos.add(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u5e01\u62a5\u8868\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u516c\u5f0f\u53d6\u6570\u3002", (String)"AbstractMultiReportPlugin_201", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (null != processNum && !"EIRpt".equals(processNum)) {
                errorInfos.add(ResManager.loadKDString((String)"\u53ea\u6709\u8fc7\u7a0b\u7684\u6210\u5458\u4e3aEIRpt\u624d\u80fd\u6267\u884c\u516c\u5f0f\u53d6\u6570\u3002", (String)"AbstractMultiReportPlugin_199", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            boolean isEnable = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
            boolean isOpen = PeriodSettingHelper.checkPeriodStatus((long)this.getModelId(), (String)entityNum, (long)scenarioId, (long)yearId, (long)periodId, (String)"datastatus");
            if (isEnable && !isOpen) {
                errorInfos.add(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractMultiReportPlugin_52", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (errorInfos.size() > 0) {
            reportInfo.put("calculateErrors", errorInfos);
            return reportInfo;
        }
        OrgDCContext excuteContext = this.calculateReportFormula(currentSpread, template);
        int succnums = excuteContext.getSuccessacctSum();
        int failnums = excuteContext.getFailacctSum();
        reportInfo.put("successCount", succnums);
        reportInfo.put("failedCount", excuteContext.getFailacctSum());
        String logs = String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s,%4$s%5$s%6$s\u6761,%7$s%8$s\u6761", (String)"ExcelLoadAction_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.entity.p2, template.getNumber(), template.getName(), OpItemEnum.DATACOLLECT.getName(), ResultStatusEnum.SUCCESS.getName(), succnums, ResultStatusEnum.FAIL.getName(), failnums);
        OperationLogUtil.writeOperationLog((String)OpItemEnum.DATACOLLECT.getName(), (String)logs, (Long)((Long)this.model.p1), (String)"bcm_report_list");
        HashMap formulaData = new HashMap();
        currentSpread.getBook().getSheet(0).iteratorCells(cell -> {
            String formlua;
            if (cell != null && (formlua = cell.getFormula()) != null && !"".equals(formlua) && !"null".equals(formlua) && cell.getValue() != null) {
                formulaData.put(cell.getExcelAxis(), cell.getValue().toString());
            }
        });
        reportInfo.put("formulaData", formulaData);
        return reportInfo;
    }

    private QFBuilder addQFBuilder() {
        QFBuilder qf = new QFBuilder();
        qf.add("model_id", "=", this.model.p1);
        qf.add("scene_id", "=", this.scene.p1);
        qf.add("fyear_id", "=", this.year.p1);
        qf.add("period_id", "=", this.period.p1);
        if ("EC".equals(this.currency.p2) || "DC".equals(this.currency.p2)) {
            DynamicObject c = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)((Long)this.entity.p1), (String)((String)this.year.p2), (Long)((Long)this.period.p1));
            qf.add("currency_id", "=", (Object)c.getLong("id"));
        } else {
            qf.add("currency_id", "=", this.currency.p1);
        }
        IDNumberTreeNode node = MemberReader.findMemberById((long)((Long)this.model.p1), (String)"bcm_entitymembertree", (Long)((Long)this.entity.p1));
        Long baseid = (Long)this.entity.p1;
        if (node.isShare()) {
            baseid = node.getCopyfromId();
        }
        qf.add("entity_id", "=", (Object)baseid);
        return qf;
    }

    private DynamicObject getReportInfo() {
        QFBuilder qf = this.addQFBuilder();
        qf.add("template_id", "=", (Object)this.templateid);
        return QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)"id, reportstatus,spreadjson,data", (QFilter[])qf.toArray());
    }

    private Object getReportTabInfo() {
        if (this.param == null) {
            return null;
        }
        HashMap<String, Object> reportInfo = new HashMap<String, Object>();
        HashSet<Long> tmpIds = new HashSet<Long>(16);
        tmpIds.add(this.templateid);
        TemplateModel template = ModelDataProvider.getTemplateModel(TemplateUtil.getRightTplIdByVersioned((Long)((Long)this.model.p1), (Long)((Long)this.year.p1), (Long)((Long)this.period.p1), tmpIds).get(this.templateid));
        ReportTemplate reportTemplate = this.getReportTemplate(template);
        reportInfo.put("template", reportTemplate);
        if (template != null) {
            SpreadManager currentSpread = this.loadCommonReportInfo(reportInfo, template);
            ExcelActionHelper.execBizRuleWhenOpen(template.getId(), currentSpread, (String)this.model.p2, ApplicationTypeEnum.CM, this.param);
            Integer temType = template.getTemplateType();
            if (temType == 0) {
                this.loadFixReportInfo(reportInfo, currentSpread);
            } else if (temType == 1) {
                this.loadFloatReportInfo(reportInfo, currentSpread);
            }
        }
        return reportInfo;
    }

    private SpreadManager loadCommonReportInfo(Map<String, Object> reportInfo, TemplateModel template) {
        SpreadManager currentSpread = null;
        DynamicObject report = this.getReportInfo();
        if (report == null) {
            currentSpread = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
            reportInfo.put("reportid", null);
            reportInfo.put("exceldata", this.getBytes2ExcelB64Data(template.getRptSpreadJson()));
        } else {
            Integer temType = template.getTemplateType();
            if (temType == 0) {
                String spreadData = report.getString("data");
                if (StringUtils.isEmpty((String)spreadData)) {
                    spreadData = template.getRptData();
                }
                currentSpread = JsonSerializerUtil.toSpreadManager((String)spreadData);
                String spreadJson = report.getString("SpreadJson");
                if ("".equals(spreadJson) || null == spreadJson) {
                    spreadJson = template.getRptSpreadJson();
                }
                reportInfo.put("exceldata", this.getBytes2ExcelB64Data(spreadJson));
            } else {
                currentSpread = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
                reportInfo.put("exceldata", this.getBytes2ExcelB64Data(template.getRptSpreadJson()));
            }
            reportInfo.put("reportid", report.get("id"));
            reportInfo.put("reportstatus", report.get("reportstatus"));
        }
        this.param.put("modelNumber", this.model.p2);
        this.initSpreadFilter(currentSpread, template);
        this.initFyPeriod(currentSpread);
        HashMap<String, String> dimesionMember = new HashMap<String, String>();
        dimesionMember.put("viewpointmembentry", JSON.toJSONString((Object)currentSpread.getFilter().getViewPointDomain().getDimensions()));
        dimesionMember.put("pagemembentry", JSON.toJSONString((Object)currentSpread.getFilter().getPageDomain().getDimensions()));
        dimesionMember.put("filtermembentry", JSON.toJSONString((Object)currentSpread.getFilter().getFilterDomain().getDimensions()));
        reportInfo.put("dimesionMember", dimesionMember);
        boolean isNoReport = report == null;
        List<Map<String, Object>> crossInfo = ExcelActionHelper.buildCrossInfo(currentSpread, template, this.getPeriodRelaMembSupplier(), isNoReport);
        reportInfo.put("crossInfo", JSON.toJSONString(crossInfo));
        HashMap formulaData = new HashMap();
        HashMap formulaInfo = new HashMap();
        ArrayList lockedCells = new ArrayList(16);
        String curnumber = this.getConcreteCY((String)this.currency.p2, currentSpread);
        CalContext ctx = new CalContext((String)this.model.p2, (String)this.entity.p2, (String)this.year.p2, (String)this.period.p2, (String)this.scene.p2, curnumber);
        ctx.setProperty("templateId", (Object)this.getTemplateId());
        ReportCalculateHelper.calculateSheet((Sheet)currentSpread.getBook().getSheet(0), (ICalContext)ctx, cell -> cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("newrptinfo"), error -> {});
        currentSpread.getBook().getSheet(0).iteratorCells(cell -> {
            if (cell != null) {
                String formlua = cell.getFormula();
                if (formlua != null && !"".equals(formlua) && !"null".equals(formlua)) {
                    if (formlua.toLowerCase(Locale.ENGLISH).startsWith("newrptinfo")) {
                        formulaData.put(cell.getExcelAxis(), String.valueOf(cell.getValue()));
                    }
                    formulaInfo.put(cell.getExcelAxis(), formlua);
                }
                if (null != cell.getUserObject() && cell.getUserObject().containsKey((Object)"locked") && ((Boolean)cell.getUserObject().get((Object)"locked")).booleanValue()) {
                    lockedCells.add(cell.getExcelAxis());
                }
            }
        });
        reportInfo.put("formulaData", formulaData);
        reportInfo.put("formulaInfo", formulaInfo);
        reportInfo.put("lockedCells", lockedCells);
        reportInfo.put("reportApiVersion", 2);
        HashMap<String, ExtendInfoModel> extendData = new HashMap<String, ExtendInfoModel>(16);
        String modelShowNumber = MemberReader.findModelSNumberById((Object)this.getModelId());
        Map setmap = ExtDataHandleService.queryExtData((SpreadManager)currentSpread, (String)modelShowNumber, this.getOrgRelaMembSupplier());
        for (Map.Entry entry : setmap.entrySet()) {
            ArrayList<EDRow> rows = new ArrayList<EDRow>(16);
            while (((EDResultSet)entry.getValue()).next()) {
                rows.add(((EDResultSet)entry.getValue()).getRow());
            }
            ExtendInfoModel extendInfo = new ExtendInfoModel();
            extendInfo.setMetaData(((EDResultSet)entry.getValue()).getMetaData());
            extendInfo.setRows(rows);
            extendData.put(((PositionInfo)entry.getKey()).getOriginalAreaRange(), extendInfo);
        }
        reportInfo.put("extendData", extendData);
        return currentSpread;
    }

    private SpreadManager loadFixReportInfo(Map<String, Object> reportInfo, SpreadManager currentSpread) {
        try {
            Set positionInfoList = currentSpread.getAreaManager().getPostionInfoSet();
            reportInfo.put("positionInfoList", JSON.toJSONString((Object)positionInfoList));
            HashMap<String, Object> MdDate = new HashMap<String, Object>();
            IRelaMembSupplier<String, String> s = this.getOrgRelaMembSupplier();
            new ReportDataRefleshService().reflesh(currentSpread, (String)this.model.p2, s, this.getPeriodRelaMembSupplier());
            for (List rows : currentSpread.getBook().getSheet(0).getTable()) {
                for (Cell cell : rows) {
                    if (null == cell || !cell.isMdDataDomain() || null == cell.getValue()) continue;
                    MdDate.put(cell.getRow() + "|" + cell.getCol(), cell.getValue());
                }
            }
            reportInfo.put("mddData", MdDate);
            return currentSpread;
        }
        catch (Exception e) {
            reportInfo.put("msg", e.toString());
            return currentSpread;
        }
    }

    private SpreadManager loadFloatReportInfo(Map<String, Object> reportInfo, SpreadManager currentSpread) {
        Set positionInfoList = currentSpread.getAreaManager().getPostionInfoSet();
        reportInfo.put("positionInfoList", JSON.toJSONString((Object)positionInfoList));
        HashMap fixMemberPosition = new HashMap();
        for (PositionInfo position : positionInfoList) {
            for (BasePointInfo basePointInfo : position.getBasePoints()) {
                ArrayList<String> dixArr = new ArrayList<String>(16);
                for (Map.Entry entry : basePointInfo.getFixMemberPosition().entrySet()) {
                    int currentSize = dixArr.size();
                    if ((Integer)entry.getKey() > currentSize) {
                        for (int i = 0; i < (Integer)entry.getKey() - currentSize; ++i) {
                            dixArr.add("");
                        }
                    }
                    ArrayList<String> dimMemberStr = new ArrayList<String>(16);
                    for (Object member : (List)entry.getValue()) {
                        dimMemberStr.add(((DimMember)member).getDimension().getNumber() + "!" + ((DimMember)member).getNumber());
                    }
                    String crossDim = String.join((CharSequence)";", dimMemberStr);
                    if (dixArr.size() > (Integer)entry.getKey()) {
                        dixArr.add((Integer)entry.getKey(), crossDim);
                        continue;
                    }
                    dixArr.add(String.join((CharSequence)";", dimMemberStr));
                }
                fixMemberPosition.put(basePointInfo.getOriginalDynaRange(), dixArr);
            }
        }
        reportInfo.put("fixMemberPosition", fixMemberPosition);
        Map<String, MDResultSet> floatMap = FloatDataProvider.queryMDResultSetMapByPageAndView(currentSpread, (Long)this.model.p1, true, this.getOrgRelaMembSupplier(), this.getPeriodRelaMembSupplier());
        HashMap MDResultMap = new HashMap();
        floatMap.forEach((posStr, MDResult) -> {
            if (MDResult == null) {
                return;
            }
            ArrayList<String> listValues = new ArrayList<String>();
            while (MDResult.next()) {
                Row row = MDResult.getRow();
                listValues.add(row.toString());
            }
            MDResultMap.put(posStr, new MDResultForExcel((String)posStr, MDResult.getMetaData().toString(), (List<String>)listValues));
        });
        reportInfo.put("floatResultMap", JSON.toJSONString(MDResultMap));
        IRelaMembSupplier<String, String> s = this.getOrgRelaMembSupplier();
        new ReportDataRefleshService().reflesh(currentSpread, (String)this.model.p2, s, this.getPeriodRelaMembSupplier());
        ArrayList<ReportCellModel> fixDimCells = new ArrayList<ReportCellModel>(16);
        for (List rows : currentSpread.getBook().getSheet(0).getTable()) {
            for (Cell cell : rows) {
                if (null == cell || !cell.isMdDataDomain()) continue;
                String address = cell.getRow() + "|" + cell.getCol();
                ReportCellModel cellModel = new ReportCellModel();
                cellModel.setMemberCross(String.join((CharSequence)";", cell.getMemberFromUserObject().stream().map(x -> x.toString()).collect(Collectors.toList())));
                cellModel.setAddress(address);
                cellModel.setValue(cell.getValue());
                fixDimCells.add(cellModel);
            }
        }
        reportInfo.put("fixDimCells", fixDimCells);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)this.getEntityId());
        if (!orgNode.isLeaf()) {
            boolean bl;
            boolean isIcFloat = false;
            block7: for (PositionInfo positionInfo : positionInfoList) {
                if (isIcFloat) break;
                block8: for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                    if (isIcFloat) continue block7;
                    for (BasePointInnerLineInfo basePointInnerLineInfo : basePointInfo.getBasePointInnerLineInfo()) {
                        if (!PresetConstant.INTERNALCOMPANY_DIM.equals(basePointInnerLineInfo.getDimension().getNumber()) || !basePointInnerLineInfo.isFloated()) continue;
                        isIcFloat = true;
                        continue block8;
                    }
                }
            }
            if (isIcFloat && (bl = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM041"))) {
                HashMap<String, String> icColorConfig = new HashMap<String, String>(16);
                String icWithMerColor = "";
                String icWithOutMerColor = "";
                String outIcColor = "";
                JSONObject config = ParamSettingServiceHelper.getJSON((long)this.getModelId(), (String)"CM041");
                if (config != null) {
                    icWithMerColor = config.getString("color" + IcTypeEnum.ICTYPE_WHITMERGER.getIndex());
                    icWithOutMerColor = config.getString("color" + IcTypeEnum.ICTYPE_WHITOUTMER.getIndex());
                    outIcColor = config.getString("color" + IcTypeEnum.ICTYPE_OUT.getIndex());
                }
                icColorConfig.put("icWithMerColor", icWithMerColor);
                icColorConfig.put("icWithOutMerColor", icWithOutMerColor);
                icColorConfig.put("outIcColor", outIcColor);
                reportInfo.put("icColorConfig", icColorConfig);
                Set notMergeSet = MergeControlHelper.getNoMergeOrgWithChildrenByNumber((Long)this.getModelId(), (Long)this.getScenarioId(), (Long)this.getYearId(), (Long)this.getPeriodId(), (String)orgNode.getLongNumber());
                reportInfo.put("notMergeSet", notMergeSet);
            }
        }
        return currentSpread;
    }

    private OrgDCContext calculateReportFormula(SpreadManager currentSpread, TemplateModel template) {
        HashMap<String, String> mapViewPoint = new HashMap<String, String>();
        mapViewPoint.put(DimTypesEnum.YEAR.getNumber(), (String)this.year.p2);
        mapViewPoint.put(DimTypesEnum.PERIOD.getNumber(), (String)this.period.p2);
        mapViewPoint.put(DimTypesEnum.ENTITY.getNumber(), (String)this.entity.p2);
        mapViewPoint.put(DimTypesEnum.CURRENCY.getNumber(), (String)this.currency.p2);
        mapViewPoint.put(DimTypesEnum.SCENARIO.getNumber(), (String)this.scene.p2);
        Map<String, Object> comPara = this.getCurrentReportCommonParam(currentSpread, "number");
        for (Map.Entry<String, Object> entry : comPara.entrySet()) {
            if (mapViewPoint.containsKey(entry.getKey())) continue;
            mapViewPoint.put(entry.getKey(), entry.getValue().toString());
        }
        Optional specificFy = PeriodUtils.trans2SpecificFy((String)((String)this.model.p2), (String)((String)this.year.p2), (String)((String)mapViewPoint.get(DimTypesEnum.YEAR.getNumber())));
        Optional trans2SpecificPeriod = PeriodUtils.trans2SpecificPeriod((String)((String)this.model.p2), (String)((String)this.period.p2), (String)((String)mapViewPoint.get(DimTypesEnum.PERIOD.getNumber())), (boolean)true);
        if (specificFy.isPresent()) {
            mapViewPoint.put(DimTypesEnum.YEAR.getNumber(), (String)specificFy.get());
        }
        if (trans2SpecificPeriod.isPresent()) {
            mapViewPoint.put(DimTypesEnum.PERIOD.getNumber(), (String)trans2SpecificPeriod.get());
        }
        return DataCollectUtil.doCollect(template.getId(), (Long)this.entity.p1, (String)this.model.p2, (Long)this.model.p1, mapViewPoint, template.isSaveByDim(), currentSpread);
    }

    private IRelaMembSupplier<String, String> getOrgRelaMembSupplier() {
        return new OrgRelaMembSupplier((Long)this.entity.p1, (String)this.entity.p2, (Long)this.model.p1);
    }

    private IRelaMembSupplier<String, String> getPeriodRelaMembSupplier() {
        return new PeriodRelaMembSupplier((String)this.model.p2, (String)this.year.p2, (String)this.period.p2);
    }

    private String getBytes2ExcelB64Data(String data) {
        String prefix = "base64";
        byte[] datas = data.startsWith(prefix) ? SpreadUtils.transZippedJson2Excel((String)data.substring(prefix.length())) : SpreadUtils.transJson2Excel((String)data);
        return Base64.getEncoder().encodeToString(datas);
    }

    protected DynamicObject getCurrencyDynaObjByOrgId(long orgId, Long yearId, Long periodId) {
        return OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgId, (Long)yearId, (Long)periodId);
    }

    private Map<String, Object> getCurrentReportCommonParam(SpreadManager spread, String field) {
        HashMap<String, Object> commonParam = new HashMap<String, Object>();
        List pageDims = spread.getFilter().getPageDomain().getDimensions();
        List viewDims = spread.getFilter().getViewPointDomain().getDimensions();
        Collection allDims = CollectionUtils.union((Collection)pageDims, (Collection)viewDims);
        if ("id".equals(field)) {
            allDims.forEach(dim -> {
                if (null != dim.getMembers().get(0) && !commonParam.containsKey(dim.getNumber())) {
                    commonParam.put(dim.getNumber(), ((IDimMember)dim.getMembers().get(0)).getId());
                }
            });
        } else if ("number".equals(field)) {
            allDims.forEach(dim -> {
                if (null != dim.getMembers().get(0) && !commonParam.containsKey(dim.getNumber())) {
                    commonParam.put(dim.getNumber(), ((IDimMember)dim.getMembers().get(0)).getNumber());
                }
            });
        } else if ("name".equals(field)) {
            allDims.forEach(dim -> {
                if (null != dim.getMembers().get(0) && !commonParam.containsKey(dim.getNumber())) {
                    commonParam.put(dim.getNumber(), ((IDimMember)dim.getMembers().get(0)).getName());
                }
            });
        }
        return commonParam;
    }

    private void initFyPeriod(SpreadManager sm) {
        sm.getAreaManager().forEach(e -> {
            this.transPeriodOrFy2SpecificVal((Domain)((Tuple)e.getValue()).k);
            this.transPeriodOrFy2SpecificVal((Domain)((Tuple)e.getValue()).v);
        });
    }

    private void transPeriodOrFy2SpecificVal(Domain dom) {
        dom.getAllMembers().forEach(m -> {
            if (m.getDimension().getNumber().equals(PresetConstant.PERIOD_DIM)) {
                Optional temp = PeriodUtils.trans2SpecificPeriod((String)((String)this.model.p2), (String)((String)this.period.p2), (String)m.getNumber(), (boolean)false);
                temp.ifPresent(v -> {
                    ((DimMember)m).setOriNumber(m.getNumber());
                    m.setNumber(v);
                });
            } else if (m.getDimension().getNumber().equals(PresetConstant.FY_DIM)) {
                Optional temp = PeriodUtils.trans2SpecificFy((String)((String)this.model.p2), (String)((String)this.year.p2), (String)m.getNumber());
                temp.ifPresent(v -> {
                    ((DimMember)m).setOriNumber(m.getNumber());
                    m.setNumber(v);
                });
            }
        });
    }

    public String getConcreteCY(String cur, SpreadManager spreadManager) {
        String bp;
        DynamicObject obj;
        if ("EC".equals(cur)) {
            obj = BusinessDataServiceHelper.loadSingle((Object)this.entity.p1, (String)DimEntityNumEnum.ENTITY.getEntityNum(), (String)"currency.number");
            cur = obj.getString("currency.number");
        }
        if ("DC".equals(cur) && (bp = SpreadMemUtil.getMemFromFilter((SpreadManager)spreadManager, (String)DimTypesEnum.PROCESS.getNumber())) != null) {
            cur = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)this.getModelId().longValue(), (long)((Long)this.entity.p1).longValue(), (String)bp, (String)cur, (long)0L, (long)0L).p2;
        }
        if ("PC".equals(cur)) {
            obj = BusinessDataServiceHelper.loadSingle((Object)this.entity.p1, (String)DimEntityNumEnum.ENTITY.getEntityNum(), (String)"parent.currency.number");
            cur = obj.getString("parent.currency.number");
        }
        return cur;
    }
}

