/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.excel.AbstractExcelAction;
import kd.fi.bcm.formplugin.excel.action.ExcelActionHelper;
import kd.fi.bcm.formplugin.report.util.ReportRecordUtil;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.ExtDataHandleService;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.GZIPUtils;

public class ExcelSaveAction
extends AbstractExcelAction {
    protected WatchLogger log;

    public ExcelSaveAction() {
    }

    public ExcelSaveAction(Map<String, Object> param) {
        super(param);
        this.log = BcmLogFactory.getWatchLogInstance(this.getClass());
    }

    @Override
    public Object execute() {
        String spreadJson;
        SpreadManager sm;
        String status;
        DynamicObject report = null;
        report = null != this.getReportId() && this.getReportId() != 0L ? this.getReportRecord(this.getReportId()) : this.QueryReportRecordByDim();
        if (null != report && ((status = report.getString("reportstatus")).equals("C") || status.equals("D"))) {
            return ResManager.loadKDString((String)"\u7f16\u5236\u5b8c\u6210\u6216\u8005\u5df2\u4e0a\u62a5\u7684\u62a5\u8868\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ExcelSaveAction0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        LinkedHashMap dimensionData = (LinkedHashMap)this.param.get("dimensionData");
        long templateId = this.getTemplateId();
        long modelId = this.getModelId();
        String cubeCatalog = QueryDimensionServiceHelper.getModelNumber((long)modelId);
        String templateSerial = (String)AppCacheServiceHelper.get((String)String.valueOf(templateId), String.class);
        TemplateModel template = new TemplateModel();
        if (StringUtils.isEmpty((String)templateSerial)) {
            DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bcm_templateentity");
            template.loadDynaObj2Model(templateDy);
            AppCacheServiceHelper.put((String)String.valueOf(templateId), (Object)ObjectSerialUtil.toByteSerialized((Object)template));
        } else {
            template = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
        }
        if (null != report) {
            sm = JsonSerializerUtil.toSpreadManager((String)report.getString("data"));
            spreadJson = report.getString("spreadjson");
        } else {
            sm = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
            spreadJson = ExcelActionHelper.getTemplateModelById(templateId).getRptSpreadJson();
        }
        this.initSpreadFilter(sm, template);
        SaveCommandInfo info = new SaveCommandInfo();
        Map<String, CellSet> cellSetList = this.processCommandDimensions(info, sm, dimensionData);
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        OlapCommandUtil.addSourceMeasure((String)cubeCatalog, (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.E1);
        cellSetList.forEach((k, v) -> {
            info.setDimensions(k.split(","));
            OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)v, (String)cubeCatalog);
        });
        List dataSaveModels = (List)this.param.get("extendDatas");
        try {
            this.saveExtReportData(sm, MemberReader.findModelSNumberById((Object)this.getModelId()), dataSaveModels);
        }
        catch (KDBizException ex) {
            return ex.getMessage();
        }
        Map cellValueMap = (Map)this.param.get("cellData");
        Map newSpreadMap = this.saveCellValueAndFormula(sm, spreadJson, cellValueMap);
        this.saveReportRecord(newSpreadMap, this.convertObjectToEnum(this.param.get("reportStatus")));
        ExcelActionHelper.execBizRuleWhenSave(templateId, cubeCatalog, ApplicationTypeEnum.CM, this.param);
        String action = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractMultiReportPlugin_142", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String opDescriotion = String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s %4$s %5$s \u62a5\u8868%6$s\u6210\u529f", (String)"AbstractMultiReportPlugin_129", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getYearNumber(), this.getPeriodNumber(), this.getEntityNumber(), template.getNumber(), template.getName(), action);
        OperationLogUtil.writeOperationLog((String)action, (String)opDescriotion, (Long)modelId, (String)"bcm_cslreportprocess");
        return "success";
    }

    private DynamicObject QueryReportRecordByDim() {
        QFBuilder qfByDim = new QFBuilder();
        qfByDim.add("model_id", "=", (Object)this.getModelId());
        qfByDim.add("scene_id", "=", (Object)this.getScenarioId());
        qfByDim.add("fyear_id", "=", (Object)this.getYearId());
        qfByDim.add("period_id", "=", (Object)this.getPeriodId());
        if ("EC".equals(this.getCurrencyNumber()) || "DC".equals(this.getCurrencyNumber())) {
            DynamicObject c = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)this.getEntityId(), (String)this.getYearNumber(), (Long)this.getPeriodId());
            qfByDim.add("currency_id", "=", (Object)c.getLong("id"));
        } else {
            qfByDim.add("currency_id", "=", (Object)this.getCurrencyId());
        }
        IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)this.getEntityId());
        Long baseid = this.getEntityId();
        if (node.isShare()) {
            baseid = node.getCopyfromId();
        }
        qfByDim.add("entity_id", "=", (Object)baseid);
        qfByDim.add("template_id", "=", (Object)this.getTemplateId());
        return QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)"id, reportstatus,data,spreadjson", (QFilter[])qfByDim.toArray());
    }

    private ReportStatusEnum convertObjectToEnum(Object obj) {
        if (obj == null) {
            return null;
        }
        return ReportStatusEnum.valueOf((String)obj.toString());
    }

    private Map<String, CellSet> processCommandDimensions(SaveCommandInfo info, SpreadManager sm, Map<String, Object> cellData) {
        Map<String, CellSet> cellSets;
        HashMap<String, String> fixDimension = new HashMap<String, String>(16);
        boolean isOpenDynaMemConvert = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM043");
        Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembers((long)this.getModelId()));
        boolean isEntityInViewOrPage = false;
        boolean isProcessInViewOrPage = false;
        boolean isCurrencyInViewOrPage = false;
        ArrayList entries = new ArrayList(16);
        entries.addAll(sm.getFilter().getViewPointDomain().getDimensions());
        entries.addAll(sm.getFilter().getPageDomain().getDimensions());
        for (IDimension dimension : entries) {
            String key = dimension.getNumber();
            if (key.toUpperCase(Locale.ENGLISH).equals("template")) continue;
            List members = dimension.getMembers();
            String inputNumber = ((IDimMember)members.get(0)).getNumber();
            if (key.equals("Currency") && inputNumber != null && inputNumber.equals("EC")) {
                Long entityId = LongUtil.toLong((Object)this.getEntityId());
                String yearNum = this.getYearNumber();
                Long periodId = this.getPeriodId();
                inputNumber = OrgCurrencyServiceHelper.getOrgModelAndCurrency((Long)entityId, (String)yearNum, (Long)periodId).get("currency.number").toString();
            }
            if (isOpenDynaMemConvert && assoMembs.contains((Object)key, (Object)inputNumber) && !key.equals("MyCompany")) {
                fixDimension.put(key, (String)assoMembs.get((Object)key, (Object)inputNumber));
            } else {
                fixDimension.put(key, inputNumber);
            }
            if (key.equals("Entity")) {
                isEntityInViewOrPage = true;
            }
            if (key.equals("Currency")) {
                isCurrencyInViewOrPage = true;
            }
            if (!key.equals("Process")) continue;
            isProcessInViewOrPage = true;
        }
        boolean isRemoveMc = false;
        String defaultMc = "";
        if (isOpenDynaMemConvert && fixDimension.containsKey("MyCompany")) {
            isRemoveMc = true;
            defaultMc = (String)fixDimension.remove("MyCompany");
        }
        if (!(isProcessInViewOrPage && isCurrencyInViewOrPage && isEntityInViewOrPage)) {
            String defaultEntityNumber = "";
            String defaultCurrencyNumber = "";
            String defaultProcessNumber = "";
            if (isCurrencyInViewOrPage) {
                defaultCurrencyNumber = (String)fixDimension.remove("Currency");
            }
            if (isProcessInViewOrPage) {
                defaultProcessNumber = (String)fixDimension.remove("Process");
            }
            if (isEntityInViewOrPage) {
                defaultEntityNumber = (String)fixDimension.remove("Entity");
            }
            HashMap<String, Object> newData = new HashMap<String, Object>(16);
            for (Map.Entry<String, Object> entry : cellData.entrySet()) {
                ArrayList<String> newDimMembers = new ArrayList<String>();
                String currentEnityNumber = "";
                String currentCurrencyNumber = "";
                String currentProcessNumber = "";
                for (String dimStr : entry.getKey().split(";")) {
                    String[] dimStrArr = dimStr.split("!");
                    String dim = dimStrArr[0];
                    String member = dimStrArr[1];
                    if (dim.equals("Entity")) {
                        currentEnityNumber = member;
                        continue;
                    }
                    if (dim.equals("Process")) {
                        if (isOpenDynaMemConvert && assoMembs.contains((Object)dim, (Object)member)) {
                            member = (String)assoMembs.get((Object)dim, (Object)member);
                        }
                        currentProcessNumber = member;
                        continue;
                    }
                    if (dim.equals("Currency")) {
                        currentCurrencyNumber = member;
                        continue;
                    }
                    newDimMembers.add(dimStr);
                }
                if (currentEnityNumber != null && currentEnityNumber.equals("")) {
                    currentEnityNumber = defaultEntityNumber;
                }
                if (currentProcessNumber != null && currentProcessNumber.equals("")) {
                    currentProcessNumber = defaultProcessNumber;
                }
                if (currentCurrencyNumber != null && currentCurrencyNumber.equals("")) {
                    currentCurrencyNumber = defaultCurrencyNumber;
                }
                Pair convertedOrgAndCurrency = TransMemberUtil.transOrgAndCurbyOrgId((long)this.getModelId(), (long)this.queryEntryIdByNumber("bcm_entitymembertree", currentEnityNumber, this.getModelId()), (String)currentProcessNumber, (String)currentCurrencyNumber, (long)0L, (long)0L);
                newDimMembers.add("Entity!" + (String)convertedOrgAndCurrency.p1);
                newDimMembers.add("Process!" + currentProcessNumber);
                newDimMembers.add("Currency!" + (String)convertedOrgAndCurrency.p2);
                if (isRemoveMc) {
                    newDimMembers.add("MyCompany!" + defaultMc);
                }
                newData.put(String.join((CharSequence)";", newDimMembers), entry.getValue());
            }
            cellSets = this.buildCellsetFromDimensionData(newData, fixDimension);
        } else {
            String currentEnityNumber = (String)fixDimension.get("Entity");
            String currentCurrencyNumber = (String)fixDimension.get("Currency");
            String currentProcessNumber = (String)fixDimension.get("Process");
            Pair convertedOrgAndCurrency = TransMemberUtil.transOrgAndCurbyOrgId((long)this.getModelId(), (long)this.queryEntryIdByNumber("bcm_entitymembertree", currentEnityNumber, this.getModelId()), (String)currentProcessNumber, (String)currentCurrencyNumber, (long)0L, (long)0L);
            fixDimension.put("Entity", (String)convertedOrgAndCurrency.p1);
            fixDimension.put("Currency", (String)convertedOrgAndCurrency.p2);
            if (isRemoveMc) {
                String mcDimMemb = "MyCompany!" + defaultMc;
                cellData = cellData.entrySet().stream().collect(HashMap::new, (k, v) -> k.put((String)v.getKey() + ";" + mcDimMemb, v.getValue()), HashMap::putAll);
            }
            cellSets = this.buildCellsetFromDimensionData(cellData, fixDimension);
        }
        for (Map.Entry entry : fixDimension.entrySet()) {
            info.addfixedDimension(new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
        return cellSets;
    }

    private Map<String, CellSet> buildCellsetFromDimensionData(Map<String, Object> data, Map<String, String> fixDimension) {
        HashMap<String, CellSet> cellSetsSet = new HashMap<String, CellSet>(16);
        ArrayList dimkeys = new ArrayList();
        ArrayList dimvals = new ArrayList();
        Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembers((long)this.getModelId()));
        data.forEach((key, val) -> {
            String joinedDimkeys;
            for (String dimStr : key.split(";")) {
                String[] dimStrArr = dimStr.split("!");
                String dim = dimStrArr[0];
                String member = dimStrArr[1];
                if (PresetConstant.PERIOD_DIM.equals(dim) && "CurrentPeriod".equals(member)) {
                    member = (String)this.getPeriod().p2;
                }
                dimkeys.add(dim);
                if (assoMembs.contains((Object)dim, (Object)member) && !dim.equals("MyCompany")) {
                    dimvals.add(assoMembs.get((Object)dim, (Object)member));
                    continue;
                }
                dimvals.add(member);
            }
            int indexOfMc = dimkeys.indexOf("MyCompany");
            if (indexOfMc > -1) {
                String mcNumber = (String)dimvals.get(indexOfMc);
                String convertMcNum = (String)assoMembs.get((Object)"MyCompany", (Object)mcNumber);
                if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(convertMcNum)) {
                    if (fixDimension.containsKey("Entity")) {
                        dimvals.set(indexOfMc, fixDimension.get("Entity"));
                    } else {
                        int indexOfOrg = dimkeys.indexOf("Entity");
                        if (indexOfOrg > -1) {
                            dimvals.set(indexOfMc, dimvals.get(indexOfOrg));
                        }
                    }
                } else if (SystemVarsEnum.PR_NONE.getNumber().equals(convertMcNum)) {
                    dimvals.set(indexOfMc, "MCNone");
                }
            }
            if (!cellSetsSet.containsKey(joinedDimkeys = String.join((CharSequence)",", dimkeys))) {
                CellSet cellSet = new CellSet(dimkeys.toArray(new String[0]), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                cellSetsSet.put(joinedDimkeys, cellSet);
            }
            CellSet cellSet = (CellSet)cellSetsSet.get(joinedDimkeys);
            cellSet.set(dimvals.toArray(new String[0]), FacTabFieldDefEnum.FIELD_MONEY.getField(), val);
            dimkeys.clear();
            dimvals.clear();
        });
        return cellSetsSet;
    }

    private Pair<Long, String> getPeriod() {
        Pair period;
        Map dimensions = (Map)this.param.get("Dimensions");
        if (dimensions.get("Period") != null) {
            period = Pair.onePair((Object)LongUtil.toLong(((Map)dimensions.get("Period")).get("Id")), (Object)((Map)dimensions.get("Period")).get("Number").toString());
        } else {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", this.param.get("ModelId"));
            qf.add("number", "=", this.param.get("Period"));
            period = (Pair)ThreadCache.get((Object)"periodId", () -> {
                DynamicObject p = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)"id,number", (QFilter[])qf.toArray());
                return Pair.onePair((Object)p.getLong("id"), (Object)p.getString("number"));
            });
        }
        return period;
    }

    private long queryEntryIdByNumber(String entryName, String dimNumber, long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)dimNumber);
        DynamicObject dobject = QueryServiceHelper.queryOne((String)entryName, (String)"id", (QFilter[])new QFilter[]{qf, qf2});
        if (dobject == null) {
            return 0L;
        }
        return dobject.getLong("id");
    }

    private void saveExtReportData(SpreadManager sm, String modelNumber, List<HashMap<String, Object>> dataSaveModels) {
        HashMap<String, String> fixDimension = new HashMap<String, String>(16);
        ArrayList pageAndViewDimension = new ArrayList(16);
        pageAndViewDimension.addAll(sm.getFilter().getPageDomain().getDimensions());
        pageAndViewDimension.addAll(sm.getFilter().getViewPointDomain().getDimensions());
        pageAndViewDimension.addAll(sm.getFilter().getFilterDomain().getDimensions());
        for (IDimension iDimension : pageAndViewDimension) {
            for (IDimMember m : iDimension.getMembers()) {
                if (!ExtDataUtil.fixDims.contains(m.getDimension().getNumber())) continue;
                fixDimension.put(iDimension.getNumber(), m.getNumber());
            }
        }
        for (HashMap hashMap : dataSaveModels) {
            PositionInfo positionInfo;
            Optional<PositionInfo> positionOption = sm.getAreaManager().getPostionInfoSet().stream().filter(x -> x.getOriginalAreaRange().equals(saveModel.get("positionOriginalStr").toString())).findFirst();
            if (!positionOption.isPresent() || null == (positionInfo = positionOption.get()).getExtendInfo()) continue;
            EDSaveComInfo saveComInfo = new EDSaveComInfo(modelNumber, positionInfo.getExtendInfo().getExtGroup(), positionInfo.getExtendInfo().getExtModelNumber());
            saveComInfo.setFixDim(fixDimension);
            List<String> mddColDims = positionInfo.getExtendInfo().getFloatdims().stream().map(f -> f.getDimension().getNumber()).collect(Collectors.toList());
            List<String> extCols = positionInfo.getExtendInfo().getCols().stream().filter(c -> !mddColDims.contains(c)).collect(Collectors.toList());
            saveComInfo.setCols(extCols.toArray(new String[0]));
            saveComInfo.setDims(mddColDims.toArray(new String[0]));
            List headMddColIndexs = mddColDims.stream().map(x -> positionInfo.getExtendInfo().getCols().indexOf(x)).collect(Collectors.toList());
            List headExtColIndexs = extCols.stream().map(x -> positionInfo.getExtendInfo().getCols().indexOf(x)).collect(Collectors.toList());
            ArrayList<String> sourceOrgs = new ArrayList<String>(16);
            for (HashMap row : (List)hashMap.get("rows")) {
                Integer n;
                Integer n2;
                Object[] valueRow = new Object[headExtColIndexs.size()];
                String[] dimValueRow = new String[headMddColIndexs.size()];
                Integer index = 0;
                while (index < headMddColIndexs.size()) {
                    Object value = ((List)row.get("cellData")).get((Integer)headMddColIndexs.get(index));
                    if (null != value) {
                        dimValueRow[index.intValue()] = value.toString();
                    }
                    n2 = index;
                    n = index = Integer.valueOf(index + 1);
                }
                index = 0;
                while (index < headExtColIndexs.size()) {
                    valueRow[index.intValue()] = ((List)row.get("cellData")).get((Integer)headExtColIndexs.get(index));
                    n2 = index;
                    n = index = Integer.valueOf(index + 1);
                }
                if (LongUtil.toLong(row.get("pkId")) != 0L) {
                    saveComInfo.putUpdateValues(LongUtil.toLong(row.get("pkId")).longValue(), valueRow, dimValueRow);
                } else {
                    saveComInfo.addValue(valueRow, dimValueRow);
                }
                if (null == row.get("sourceOrgs")) continue;
                sourceOrgs.add(row.get("sourceOrgs").toString());
            }
            List delIds = new ArrayList(16);
            if (hashMap.containsKey("delRowIds")) {
                delIds = (List)hashMap.get("delRowIds");
            }
            ExtDataHandleService.saveExtDatasForExcelClient((String)modelNumber, this.getOrgRelaMembSupplier(), (PositionInfo)positionInfo, (EDSaveComInfo)saveComInfo, sourceOrgs, extCols, delIds);
        }
    }

    private void saveReportRecord(Map spreadMap, ReportStatusEnum status) {
        DynamicObject record = null;
        Long currencyid = this.getCurrencyId();
        Pair convertedOrgAndCurrency = TransMemberUtil.transOrgAndCurbyOrgId((long)this.getModelId(), (long)this.getEntityId(), (String)this.getPeriodNumber(), (String)this.getCurrencyNumber(), (long)this.getYearId(), (long)this.getPeriodId());
        if (convertedOrgAndCurrency.p2 != null) {
            currencyid = this.queryEntryIdByNumber("bcm_currencymembertree", (String)convertedOrgAndCurrency.p2, this.getModelId());
        }
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.getModelId());
        qf.add("fyear", "=", (Object)this.getYearId());
        qf.add("period", "=", (Object)this.getPeriodId());
        qf.add("scene", "=", (Object)this.getScenarioId());
        qf.add("currency", "=", (Object)currencyid);
        IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)this.getEntityId());
        Long baseOrgId = this.getEntityId();
        if (node.isShare()) {
            baseOrgId = node.getCopyfromId();
        }
        qf.add("entity", "=", (Object)baseOrgId);
        qf.add("template", "=", (Object)this.getTemplateId());
        record = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_reportentity", (QFilter[])qf.toArray());
        if (record == null) {
            record = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportentity");
            record.set("createtime", (Object)TimeServiceHelper.now());
            record.set("creator_id", (Object)RequestContext.get().getUserId());
            record.set("entity_id", (Object)this.getEntityId());
            record.set("fyear_id", (Object)this.getYearId());
            record.set("period_id", (Object)this.getPeriodId());
            record.set("scene_id", (Object)this.getScenarioId());
            record.set("currency_id", (Object)currencyid);
            record.set("template_id", (Object)this.getTemplateId());
            record.set("model_id", (Object)this.getModelId());
        }
        record.set("spreadjson", (Object)spreadMap.get("spreadJson").toString());
        record.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)((SpreadManager)spreadMap.get("spreadManager"))));
        record.set("modifytime", (Object)TimeServiceHelper.now());
        record.set("modifier_id", (Object)RequestContext.get().getUserId());
        if (status != null) {
            record.set("reportstatus", (Object)status.status());
        }
        BusinessDataWriter.save((IDataEntityType)record.getDataEntityType(), (Object[])new Object[]{record});
    }

    private DynamicObject getReportRecord(long reportId) {
        QFBuilder qf = new QFBuilder();
        qf.add("id", "=", (Object)reportId);
        DynamicObject report = QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)"id, reportstatus,data,spreadjson", (QFilter[])qf.toArray());
        return report;
    }

    public Map saveCellValueAndFormula(SpreadManager sm, String spreadJson, Map<String, Map<String, Object>> cellValueMap) {
        Sheet sheet = sm.getBook().getSheet(0);
        ArrayList<Cell> cells = new ArrayList<Cell>(cellValueMap.size());
        for (Map.Entry<String, Map<String, Object>> entry : cellValueMap.entrySet()) {
            String point = entry.getKey();
            int row = ExcelUtils.pos2Y((String)point);
            int col = ExcelUtils.pos2X((String)point);
            Cell cell = sheet.getCell(row, col);
            Map<String, Object> cellValue = entry.getValue();
            if (cellValue.get("value") != null) {
                cell.setValue(cellValue.get("value"));
            }
            if (cellValue.get("formula") != null) {
                cell.setFormula(String.valueOf(cellValue.get("formula")));
            }
            cells.add(cell);
        }
        String newSpreadJson = ExcelSaveAction.dealSpreadJson(cells, sm.getBook().getSheet(0).getSheetName(), spreadJson);
        sm.setFilter(null);
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("spreadJson", newSpreadJson);
        data.put("spreadManager", (String)sm);
        return data;
    }

    public static String dealSpreadJson(List<Cell> cells, String sheetname, String json) {
        json = TempFormulaUtil.dealBase64Str(json);
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(json)));
        JSONObject obj = JSONObjectUtil.parseObjectOrder((String)ssjson);
        JSONObject dataTable = DataAndJsonTranslator.getDataTable((JSONObject)obj, (String)sheetname);
        for (Cell c : cells) {
            JSONObject rowObject = (JSONObject)dataTable.get((Object)(c.getRow() + ""));
            if (rowObject == null) {
                rowObject = new JSONObject();
                dataTable.put(c.getRow() + "", (Object)rowObject);
            } else {
                dataTable.put(c.getRow() + "", (Object)rowObject);
            }
            JSONObject cell = (JSONObject)rowObject.get((Object)(c.getCol() + ""));
            if (cell == null) {
                cell = new JSONObject();
                rowObject.put(c.getCol() + "", (Object)cell);
            } else {
                rowObject.put(c.getCol() + "", (Object)cell);
            }
            if (c.getValue() == null) {
                cell.remove((Object)"value");
            } else {
                cell.put("value", c.getValue());
            }
            if (c.getFormula() == null || !c.hasFormula() || !TempFormulaUtil.checkIsOnlyExcel(c.getFormula())) {
                cell.remove((Object)"formula");
                continue;
            }
            if (c.getFormula().startsWith("=")) {
                cell.put("formula", (Object)c.getFormula().replace("=", ""));
                continue;
            }
            cell.put("formula", (Object)c.getFormula());
        }
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)obj.toJSONString()));
        String bbs = new String(bb);
        return "base64" + bbs;
    }

    public Map<String, Object> updateReportStatus(Map<String, Object> param) {
        Map<String, Object> result = ReportRecordUtil.executeReportStatusToEPM(param);
        ReportRecordUtil.batchWriteLogs((Long)param.get("ModelId"), result, true);
        return result;
    }

    private IRelaMembSupplier<String, String> getOrgRelaMembSupplier() {
        return new OrgRelaMembSupplier(this.getEntityId(), this.getEntityNumber(), this.getModelId());
    }
}

