/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckStatusHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.reportlist.cache.ReportRedisCache;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.excel.AbstractExcelAction;
import kd.fi.bcm.formplugin.excel.dto.AbstractDimMember;
import kd.fi.bcm.formplugin.excel.dto.DimMember;
import kd.fi.bcm.formplugin.excel.dto.Dimension;
import kd.fi.bcm.formplugin.excel.dto.ReportTemplate;
import kd.fi.bcm.formplugin.excel.dto.TemplateCatalog;
import kd.fi.bcm.formplugin.excel.dto.TemplateDetail;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;

public class ExcelTemplateAction
extends AbstractExcelAction {
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());

    public ExcelTemplateAction(Map<String, Object> param) {
        super(param);
    }

    @Override
    public Object execute() {
        return this.getTemplateWithCatalog();
    }

    public List<TemplateCatalog> getTemplateWithCatalog() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        qfBuilder.add(new QFilter("catalogtype", "=", (Object)Character.valueOf('0')).or("parent.id", "=", (Object)0));
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        DynamicObjectCollection catalogori = QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,name,number,parent.id parent_id,longnumber,sequence", (QFilter[])qfBuilder.toArray(), (String)"sequence ASC");
        DynamicObjectCollection catalogs = new DynamicObjectCollection();
        if (!adminUserBol) {
            ArrayListMultimap permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_templatecatalog", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId());
            List noPerms = permissionMap.get((Object)DataTypeEnum.NO.getIndex());
            for (DynamicObject obj : catalogori) {
                if (noPerms.contains(obj.getLong("id"))) continue;
                catalogs.add((Object)obj);
            }
        } else {
            catalogs.addAll((Collection)catalogori);
        }
        boolean isloadReport = false;
        if (this.param.containsKey("isLoadReport")) {
            isloadReport = (Boolean)this.param.get("isLoadReport");
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("model_id", "=", (Object)this.getModelId()));
        int usageType = 0;
        if (this.param.containsKey("usageType")) {
            usageType = (Integer)this.param.get("usageType");
        }
        if (usageType != 0) {
            QFilter usageFilter = new QFilter("usage", "=", (Object)Integer.toString(usageType));
            qFilters.add(usageFilter);
        }
        DynamicObjectCollection tempData = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,name,number,isonlyread,versionnumber,templatecatalog,status,usage,modifytime,effectivedate,expiringdate", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        Set tempIds = tempData.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        Map templateIds2 = TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)((Long)this.param.get("yearid")), (Long)((Long)this.param.get("periodid")), tempIds);
        List tempIdsByVersion = templateIds2.values().stream().collect(Collectors.toList());
        Set<Long> noPermTempIds = this.getNoPerm(this.getModelId());
        List rightTempIds = tempIdsByVersion.stream().filter(x -> adminUserBol || !noPermTempIds.contains(x)).collect(Collectors.toList());
        Map<Object, Object> distributeMap = new HashMap(16);
        if (this.param.containsKey("orgNodeIds")) {
            Set<Long> orgBaseIds = ((List)this.param.get("orgNodeIds")).stream().collect(Collectors.toSet());
            distributeMap = this.getDistributeMapFromCacheNew(this.getModelId(), new HashSet<Long>(templateIds2.values()), orgBaseIds);
            distributeMap = this.delNoOrgMember(distributeMap, orgBaseIds);
        }
        List models = ReportRedisCache.queryTemplateModelFromCache(rightTempIds.stream().collect(Collectors.toSet()), (long)this.getModelId(), (boolean)false);
        ArrayList<ReportTemplate> templates = new ArrayList<ReportTemplate>(models.size());
        boolean isNewModel = QueryDimensionServiceHelper.checkInfoInModel((String)"number", (String)"number", (String)"CurrentYear", (String)"bcm_fymembertree", (String)String.valueOf(this.getModelId()));
        for (TemplateModel model : models) {
            boolean flag;
            Set entityIdSet = (Set)distributeMap.get(model.getId());
            if (isloadReport ? (flag = this.handleTemplateViewPageDim(model, (Map)this.param.get("filterView"), isNewModel)) || entityIdSet == null || entityIdSet.isEmpty() : (null == entityIdSet || entityIdSet.isEmpty()) && this.param.containsKey("orgNodeIds") && ((List)this.param.get("orgNodeIds")).size() > 0) continue;
            ReportTemplate tempViewModel = this.getReportTemplate(model);
            Optional<DynamicObject> op = tempData.stream().filter(x -> x.getLong("id") == model.getId()).findFirst();
            if (op.isPresent()) {
                tempViewModel.setReadonly(op.get().getBoolean("isonlyread"));
                tempViewModel.setVersionNumber(op.get().getLong("versionnumber"));
                tempViewModel.setUsage(op.get().getInt("usage"));
            }
            templates.add(tempViewModel);
        }
        List catalogRootNodes = catalogs.stream().filter(x -> x.getLong("parent_id") == 0L).collect(Collectors.toList());
        ArrayList<TemplateCatalog> result = new ArrayList<TemplateCatalog>(catalogRootNodes.size());
        for (DynamicObject catalog : catalogRootNodes) {
            TemplateCatalog currentCatalog = new TemplateCatalog();
            currentCatalog.setId(catalog.getLong("id"));
            currentCatalog.setName(catalog.getString("name"));
            currentCatalog.setNumber(catalog.getString("number"));
            currentCatalog.setLongNumber(catalog.getString("longnumber"));
            currentCatalog.setDesq(catalog.getInt("sequence"));
            currentCatalog.setParentId(catalog.getLong("parent_id"));
            currentCatalog.setTemplates(templates.stream().filter(k -> k.getTemplateCatalogId() == catalog.getLong("id")).collect(Collectors.toList()));
            this.BuildCatalogTree(currentCatalog, catalogs, templates);
            result.add(currentCatalog);
        }
        return result;
    }

    public List<ReportTemplate> GetTemplateList() {
        ArrayListMultimap permissionMap;
        List list;
        boolean onlyDim;
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        if (this.param.containsKey("status")) {
            List status = (List)this.param.get("status");
            filter.and("status", "in", (Object)status);
        }
        filter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        if (this.param.containsKey("onlyDim") && (onlyDim = ((Boolean)this.param.get("onlyDim")).booleanValue())) {
            filter.and("issavebydim", "=", (Object)"1");
        }
        if (!PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin() && !CollectionUtils.isEmpty((Collection)(list = (permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)this.getModelId().toString(), (String)RequestContext.get().getUserId())).get((Object)DataTypeEnum.NO.getIndex())))) {
            filter.and(new QFilter("id", "not in", (Object)list));
        }
        DynamicObjectCollection temps = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,name,number,isonlyread,versionnumber,templatecatalog.id,templatecatalog.name,status,usage,modifytime,effectivedate,expiringdate", (QFilter[])filter.toArray());
        ArrayList<ReportTemplate> result = new ArrayList<ReportTemplate>(temps.toArray().length);
        for (DynamicObject temp : temps) {
            ReportTemplate tempModel = new ReportTemplate();
            tempModel.setId(temp.getLong("id"));
            tempModel.setName(temp.getString("name"));
            tempModel.setNumber(temp.getString("number"));
            tempModel.setReadonly(temp.getBoolean("isonlyread"));
            tempModel.setVersionNumber(temp.getLong("versionnumber"));
            tempModel.setTemplateCatalogId(temp.getLong("templatecatalog.id"));
            tempModel.setTemplateCatalogName(temp.getString("templatecatalog.name"));
            tempModel.setStatus(temp.getBoolean("status"));
            tempModel.setUsage(temp.getInt("usage"));
            tempModel.setModifyTime(temp.getDate("modifytime"));
            tempModel.setEffectiveDate(temp.getDate("effectivedate"));
            tempModel.setExpiringDate(temp.getDate("expiringdate"));
            result.add(tempModel);
        }
        return result;
    }

    public TemplateDetail GetTemplateDetail() {
        Long templateId = LongUtil.toLong(this.param.get("templateId"));
        TemplateModel template = TemplateUtil.getTemplateModel((Object)templateId);
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
        Set postionInfoSet = sm.getAreaManager().getPostionInfoSet();
        boolean isDim = false;
        TemplateDetail detail = new TemplateDetail();
        for (PositionInfo positionInfo : postionInfoSet) {
            ExtendInfo extendInfo = positionInfo.getExtendInfo();
            if (Objects.nonNull(extendInfo)) {
                detail.getExtendInfos().add(extendInfo);
                continue;
            }
            isDim = true;
        }
        detail.setDimReport(isDim);
        detail.setViewDimensions(template.getViewPointDimensionEntries().stream().map(x -> {
            Dimension dim = new Dimension();
            dim.setNumber(x.getDimension().getNumber());
            dim.setName(x.getDimension().getName());
            dim.setId(x.getDimension().getId());
            dim.setShortNumber(x.getDimension().getShortNumber());
            Member srcMember = x.getMember();
            if (srcMember != null) {
                DimMember tarMember = new DimMember();
                tarMember.setId(srcMember.getId());
                tarMember.setNumber(srcMember.getNumber());
                tarMember.setName(srcMember.getName());
                tarMember.setScope(srcMember.getScope());
                ArrayList<AbstractDimMember> tarMembers = new ArrayList<AbstractDimMember>(1);
                tarMembers.add(tarMember);
                dim.setMembers(tarMembers);
            }
            return dim;
        }).collect(Collectors.toList()));
        detail.setPageDimensions(template.getPageDimensionEntries().stream().map(x -> {
            Dimension dim = new Dimension();
            dim.setNumber(x.getDimension().getNumber());
            dim.setName(x.getDimension().getName());
            dim.setId(x.getDimension().getId());
            dim.setShortNumber(x.getDimension().getShortNumber());
            List srcMembers = x.getMembers();
            ArrayList<AbstractDimMember> tarMembers = new ArrayList<AbstractDimMember>(srcMembers.size());
            for (Member srcMember : srcMembers) {
                DimMember tarMember = new DimMember();
                tarMember.setId(srcMember.getId());
                tarMember.setNumber(srcMember.getNumber());
                tarMember.setName(srcMember.getName());
                tarMember.setScope(srcMember.getScope());
                tarMembers.add(tarMember);
            }
            dim.setMembers(tarMembers);
            return dim;
        }).collect(Collectors.toList()));
        detail.setFilterDimensions(template.getFilterDimensionEntries().stream().map(x -> {
            Dimension dim = new Dimension();
            dim.setNumber(x.getDimension().getNumber());
            dim.setName(x.getDimension().getName());
            dim.setId(x.getDimension().getId());
            dim.setShortNumber(x.getDimension().getShortNumber());
            List srcMembers = x.getMembers();
            ArrayList<AbstractDimMember> tarMembers = new ArrayList<AbstractDimMember>(srcMembers.size());
            for (Member srcMember : srcMembers) {
                DimMember tarMember = new DimMember();
                tarMember.setId(srcMember.getId());
                tarMember.setNumber(srcMember.getNumber());
                tarMember.setName(srcMember.getName());
                tarMember.setScope(srcMember.getScope());
                tarMembers.add(tarMember);
            }
            dim.setMembers(tarMembers);
            return dim;
        }).collect(Collectors.toList()));
        return detail;
    }

    public Map<Long, Integer> getReportGjStatus() {
        Long orgId = LongUtil.toLong(this.param.get("entityId"));
        Long yearId = LongUtil.toLong(this.param.get("yearId"));
        Long scenarioId = LongUtil.toLong(this.param.get("scenarioId"));
        Long periodId = LongUtil.toLong(this.param.get("periodId"));
        Long currencyId = LongUtil.toLong(this.param.get("currencyId"));
        Long cslschemeId = LongUtil.toLong(this.param.get("cslschemeId"));
        List templateIds = (List)this.param.get("templateIds");
        Boolean isEcCurrency = false;
        HashSet<Long> orgs = new HashSet<Long>(16);
        orgs.add(orgId);
        IDNumberTreeNode memberCur = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_currencymembertree", (Long)currencyId);
        if (null != memberCur) {
            isEcCurrency = CurrencyEnum.EC.number.equals(memberCur.getNumber()) || CurrencyEnum.DC.number.equals(memberCur.getNumber());
        }
        Map<Long, DynamicObject> org_curr = DimensionUtil.getCurrencyDynasByModelId(this.getModelId(), orgs, yearId, periodId);
        HashMap orgId2CurId = new HashMap();
        org_curr.forEach((k, v) -> orgId2CurId.put(k, v.getLong("id")));
        Map statusMap = ChkCheckStatusHelper.getChkStatusMap((long)this.getModelId(), orgs, (long)yearId, (long)scenarioId, (long)periodId, orgId2CurId, (long)cslschemeId);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, number, versionnumber, group", (QFilter[])new QFBuilder("id", "in", (Object)templateIds).toArray());
        Map<Long, Long> group2Id = templates.stream().collect(Collectors.toMap(t -> t.getLong("group"), t -> t.getLong("id")));
        DynamicObjectCollection firstVersionTmps = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,group", (QFilter[])new QFilter[]{new QFilter("group", "in", group2Id.keySet()), new QFilter("versionnumber", "=", (Object)BigDecimal.ONE)});
        HashMap tmpId2FirVerTmpIdMap = new HashMap(firstVersionTmps.size());
        firstVersionTmps.forEach(t -> tmpId2FirVerTmpIdMap.put(group2Id.get(t.getLong("group")), t.getLong("id")));
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
        Iterator iterator = templateIds.iterator();
        while (iterator.hasNext()) {
            long temId;
            long searchId = temId = ((Long)iterator.next()).longValue();
            if (tmpId2FirVerTmpIdMap.containsKey(temId)) {
                searchId = (Long)tmpId2FirVerTmpIdMap.get(temId);
            }
            if (isEcCurrency.booleanValue()) {
                currencyId = org_curr.get(orgId).getLong("id");
            }
            boolean isEC = isEcCurrency;
            if (org_curr.get(orgId) != null) {
                isEC = isEcCurrency != false || currencyId.longValue() == org_curr.get(orgId).getLong("id");
            }
            Pair checkresult = ChkCheckStatusHelper.getStatus((String)cslschemeId.toString(), (String)orgId.toString(), (Long)searchId, (String)currencyId.toString(), (Map)statusMap, (boolean)isEC);
            result.put(temId, (Integer)checkresult.p1);
        }
        return result;
    }

    private void BuildCatalogTree(TemplateCatalog currentCatalog, DynamicObjectCollection catalogs, List<ReportTemplate> templates) {
        List<TemplateCatalog> childCatalog = catalogs.stream().filter(x -> x.getLong("parent_id") == currentCatalog.getId()).map(x -> {
            TemplateCatalog catalog = new TemplateCatalog();
            catalog.setId(x.getLong("id"));
            catalog.setName(x.getString("name"));
            catalog.setNumber(x.getString("number"));
            catalog.setLongNumber(x.getString("longnumber"));
            catalog.setDesq(x.getInt("sequence"));
            catalog.setParentId(x.getLong("parent_id"));
            catalog.setTemplates(templates.stream().filter(k -> k.getTemplateCatalogId() == x.getLong("id")).collect(Collectors.toList()));
            return catalog;
        }).collect(Collectors.toList());
        currentCatalog.setChilderns(childCatalog);
        for (TemplateCatalog catalog : childCatalog) {
            this.BuildCatalogTree(catalog, catalogs, templates);
        }
    }

    private Map<Long, Set<Long>> delNoOrgMember(Map<Long, Set<Long>> distributeMap, Set<Long> orgRangeBaseMember) {
        HashMap<Long, Set<Long>> distributeMapTemp = new HashMap<Long, Set<Long>>();
        distributeMap.forEach((p, v) -> {
            if (v != null && v.size() != 0) {
                v.retainAll(orgRangeBaseMember);
                distributeMapTemp.put((Long)p, (Set<Long>)v);
            }
        });
        return distributeMapTemp;
    }

    private Map<Long, Set<Long>> getDistributeMapFromCacheNew(Object modelId, Set<Long> selectTemplateIdSet, Set<Long> orgRangeBsaeMembers) {
        Map dispenseMap = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)Long.valueOf(modelId.toString()), selectTemplateIdSet, orgRangeBsaeMembers);
        return dispenseMap;
    }

    private boolean handleTemplateViewPageDim(TemplateModel templateModel, Map<String, Long> filterView, boolean isNewModel) {
        if (filterView == null || filterView.isEmpty()) {
            return false;
        }
        ArrayList dims = Lists.newArrayList((Object[])new String[]{PresetConstant.SCENE_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.CURRENCY_DIM});
        for (String dim : dims) {
            Set<Long> orgIds;
            IDNumberTreeNode currencyMem;
            boolean isInnerRange = true;
            Long memberid = filterView.get(dim);
            if (memberid == null) continue;
            String entity = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dim);
            isInnerRange = TemplateRangeService.isInnerRange((String)entity, (TemplateModel)templateModel, (Object)memberid);
            if (!isInnerRange && isNewModel && PresetConstant.FY_DIM.equals(dim)) {
                isInnerRange = TemplateRangeService.isInnerRange((String)entity, (TemplateModel)templateModel, (Object)this.getIdByNumber(entity, "CurrentYear", templateModel.getModelId())) || TemplateRangeService.isInnerRange((String)entity, (TemplateModel)templateModel, (Object)this.getIdByNumber(entity, "LastYear", templateModel.getModelId()));
            } else if (!isInnerRange && isNewModel && PresetConstant.PERIOD_DIM.equals(dim)) {
                isInnerRange = TemplateRangeService.isInnerRange((String)entity, (TemplateModel)templateModel, (Object)this.getIdByNumber(entity, "CurrentPeriod", templateModel.getModelId())) || TemplateRangeService.isInnerRange((String)entity, (TemplateModel)templateModel, (Object)this.getIdByNumber(entity, "LastPeriod", templateModel.getModelId()));
            } else if (!isInnerRange && PresetConstant.CURRENCY_DIM.equals(dim) && null != (currencyMem = MemberReader.findMemberById((long)this.getModelId(), (String)entity, (Long)memberid)) && ("DC".equals(currencyMem.getNumber()) || "EC".equals(currencyMem.getNumber())) && (orgIds = ((List)this.param.get("orgNodeIds")).stream().collect(Collectors.toSet())).size() > 0) {
                Long orgId = (Long)orgIds.iterator().next();
                Map<Long, DynamicObject> cur_orgdys = DimensionUtil.getCurrencyDynasByModelId(this.getModelId(), orgIds, filterView.get(PresetConstant.FY_DIM), filterView.get(PresetConstant.PERIOD_DIM));
                DynamicObject cyDy = cur_orgdys.get(orgId);
                if (null != cyDy) {
                    isInnerRange = TemplateRangeService.isInnerRangeNotAnalyCY((String)entity, (TemplateModel)templateModel, (Object)memberid, (Object)cur_orgdys.get(orgId).getLong("id"));
                }
            }
            if (isInnerRange) continue;
            return true;
        }
        return false;
    }

    private Object getIdByNumber(String entity, String number, Long modelId) {
        return ThreadCache.get((Object)("id:" + entity + "|" + number), () -> {
            DynamicObject at = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("model", "=", (Object)modelId)});
            return at.getLong("id");
        });
    }

    private Set<Long> getNoPerm(Long modelId) {
        boolean modelManager = MemberPermHelper.isModelManager((Long)modelId);
        HashSet<Long> set = new HashSet<Long>();
        if (modelManager) {
            return set;
        }
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(modelId), (String)String.valueOf(RequestContext.get().getUserId()));
        Collection entries = map.entries();
        for (Map.Entry entrie : entries) {
            if (!DataTypeEnum.NO.getIndex().equals(entrie.getKey())) continue;
            set.add((Long)entrie.getValue());
        }
        return set;
    }
}

