/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.formplugin.excel.dto.EpmClientVersion;
import org.apache.commons.lang3.StringUtils;

public final class ExcelVersionAction {
    private static final String FIELD_VERSION = "version";

    private ExcelVersionAction() {
    }

    public static EpmClientVersion getEpmClientPackageInfoByVersion(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("status", "=", (Object)true));
        qFilters.add(new QFilter("userwhitelist.fbasedataid", "=", (Object)RequestContext.get().getCurrUserId()).or(new QFilter("userwhitelist.fbasedataid", "is null", null)));
        String selectFields = "id,version,attach.fbasedataid.url url";
        DynamicObjectCollection clientInfos = QueryServiceHelper.query((String)"bcm_epmclient_info", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"version desc");
        if (clientInfos.isEmpty()) {
            return null;
        }
        List ids = clientInfos.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        QFilter idsFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection remarks = QueryServiceHelper.query((String)"bcm_epmclient_info", (String)"id,remark", (QFilter[])new QFilter[]{idsFilter});
        Map<Long, String> idToRemarkMap = remarks.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("remark")));
        boolean isLatest = (Boolean)param.get("isLatest");
        ArrayList<EpmClientVersion> epmVersions = new ArrayList<EpmClientVersion>(16);
        String version = param.get(FIELD_VERSION).toString().toUpperCase().replace("V", "").trim();
        for (DynamicObject clientInfo : clientInfos) {
            EpmClientVersion epmClientVersion;
            String versionTarget = clientInfo.getString(FIELD_VERSION).toUpperCase().replace("V", "").trim();
            Long id = clientInfo.getLong("id");
            if (isLatest) {
                if (ExcelVersionAction.compareVersion(version, versionTarget) >= 0) continue;
                epmClientVersion = new EpmClientVersion();
                epmClientVersion.setVersion(clientInfo.getString(FIELD_VERSION));
                if (idToRemarkMap.containsKey(id)) {
                    epmClientVersion.setRemark(idToRemarkMap.get(id));
                }
                epmClientVersion.setUrl(clientInfo.getString("url"));
                epmClientVersion.setFullVersion(ExcelVersionAction.getFullVersion(versionTarget));
                epmVersions.add(epmClientVersion);
                continue;
            }
            if (!version.equals(versionTarget)) continue;
            epmClientVersion = new EpmClientVersion();
            epmClientVersion.setVersion(clientInfo.getString(FIELD_VERSION));
            if (idToRemarkMap.containsKey(id)) {
                epmClientVersion.setRemark(idToRemarkMap.get(id));
            }
            epmClientVersion.setUrl(clientInfo.getString("url"));
            return epmClientVersion;
        }
        if (isLatest && !epmVersions.isEmpty()) {
            return ExcelVersionAction.getLatestVersion(epmVersions);
        }
        return null;
    }

    private static int compareVersion(String version1, String version2) {
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        if (versionArray1.length != 3 || versionArray2.length != 3) {
            return 0;
        }
        int diff = 0;
        for (int index = 0; index < 2 && (diff = versionArray1[index].length() - versionArray2[index].length()) == 0 && (diff = versionArray1[index].compareTo(versionArray2[index])) == 0; ++index) {
        }
        if (diff == 0) {
            String thridStr1 = StringUtils.rightPad((String)versionArray1[2], (int)4, (String)"0");
            String thridStr2 = StringUtils.rightPad((String)versionArray2[2], (int)4, (String)"0");
            diff = Integer.parseInt(thridStr1) - Integer.parseInt(thridStr2);
        }
        return diff;
    }

    private static String getFullVersion(String version) {
        String[] versionArray = version.split("\\.");
        String first = StringUtils.leftPad((String)versionArray[0], (int)4, (String)"0");
        String second = StringUtils.leftPad((String)versionArray[1], (int)4, (String)"0");
        String third = StringUtils.rightPad((String)versionArray[2], (int)4, (String)"0");
        return String.format("%s.%s.%s", first, second, third);
    }

    private static EpmClientVersion getLatestVersion(List<EpmClientVersion> versions) {
        Collections.sort(versions);
        String remarks = "";
        for (EpmClientVersion version : versions) {
            if (!kd.bos.util.StringUtils.isNotEmpty((String)version.getRemark())) continue;
            remarks = remarks.concat(version.getRemark());
        }
        EpmClientVersion latest = versions.get(versions.size() - 1);
        latest.setRemark(remarks);
        return latest;
    }
}

