/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.excel.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.carry.CarryServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.reportlist.cache.ReportRedisCache;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.excel.AbstractExcelAction;
import kd.fi.bcm.formplugin.excel.dto.CarryConfirmModel;
import kd.fi.bcm.formplugin.excel.dto.ExcelApiOutput;
import kd.fi.bcm.formplugin.excel.dto.ReportTemplate;
import kd.fi.bcm.formplugin.excel.dto.YearCarryTemplate;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import org.apache.commons.lang3.tuple.Pair;

public class ExcelYearCarryAction
extends AbstractExcelAction {
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    private static final String NUMBER = "number";
    private static final String scenario = "scenario";
    private static final String year = "year";
    private static final String period = "period";

    public ExcelYearCarryAction(Map<String, Object> param) {
        super(param);
    }

    public List<YearCarryTemplate> getYearCarryDataCollectTemplate() {
        Long yearId = this.getYearId();
        Long periodId = this.getPeriodId();
        Long modelId = this.getModelId();
        Long scenarioId = this.getScenarioId();
        String yearNumber = this.getYearNumber();
        Long cslschemeId = LongUtil.toLong(this.param.get("cslschemeId"));
        String cslschemeNum = StringUtil.toString(this.param.get("cslschemeNum"));
        List orgIds = (List)this.param.get("entityIds");
        List filterTempIds = (List)this.param.get("templateIds");
        HashSet<Long> templateIds = null;
        String strModelId = StringUtil.toString((Object)this.getModelId());
        CslSchemeServiceHelper.QueryOrgParam param = CslSchemeServiceHelper.QueryOrgParam.of((String)"model", (Object)strModelId);
        param.setCslScheme(Pair.of((Object)cslschemeId, (Object)cslschemeNum));
        param.set(year, (Object)yearNumber);
        param.set(period, (Object)periodId);
        param.set(scenario, (Object)scenarioId);
        DynamicObjectCollection orgs = CslSchemeServiceHelper.getOrgDynamicObjectCollection((CslSchemeServiceHelper.QueryOrgParam)param);
        OrgServiceHelper.dealNoMergeOrgs((DynamicObjectCollection)orgs, (Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId, null);
        if (null == orgIds || orgIds.size() == 0) {
            orgIds = orgs.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        }
        Set<Object> rightOrgIds = new HashSet(16);
        boolean isAdmin = MemberPermHelper.isModelAdmin((Long)modelId);
        if (isAdmin) {
            rightOrgIds = orgIds.stream().collect(Collectors.toSet());
        } else {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(NUMBER, "=", (Object)PresetConstant.ENTITY_DIM);
            Iterator dimension = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{filter});
            long dimensionId = dimension == null ? 0L : dimension.getLong("id");
            rightOrgIds = PermissionServiceImpl.getInstance((Long)modelId).matchWritePermMembers(Long.valueOf(dimensionId), "bcm_entitymembertree", orgIds);
        }
        DynamicObjectCollection orgsList = new DynamicObjectCollection();
        for (DynamicObject org : orgs) {
            if (!rightOrgIds.contains(LongUtil.toLong((Object)org.getPkValue()))) continue;
            orgsList.add((Object)org);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)filterTempIds)) {
            templateIds = new HashSet<Long>(filterTempIds.size());
            templateIds.addAll(filterTempIds);
        } else {
            templateIds = TemplateRangeService.getAllTemplateIdByModel((Object)this.getModelId());
        }
        Set<Long> perm = this.getPerm(modelId);
        if (!perm.isEmpty()) {
            templateIds.removeAll(perm);
        }
        List<YearCarryTemplate> temps = this.buildCollectDataNodes(orgsList, templateIds);
        this.fillCarryStatus(temps, rightOrgIds);
        return temps;
    }

    public ExcelApiOutput yearCarryPerform() {
        QFilter numberqf;
        QFilter modelqfilter;
        Long yearId = this.getYearId();
        Long modelId = this.getModelId();
        Long sceneId = this.getScenarioId();
        Long periodId = this.getPeriodId();
        DynamicObject yearobj = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"dseq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)yearId)});
        if (yearobj == null) {
            return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u8d22\u5e74\u4e0d\u5b58\u5728\u3002", (String)"ExcelYearCarryAction_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        QFilter seqqfilter = new QFilter("dseq", "<", yearobj.get("dseq"));
        DynamicObjectCollection lastyearobj = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id", (QFilter[])new QFilter[]{seqqfilter, modelqfilter = new QFilter("model", "=", (Object)modelId), numberqf = new QFilter(NUMBER, "like", (Object)"FY%")}, (String)"dseq desc", (int)1);
        if (lastyearobj == null || lastyearobj.size() == 0) {
            return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u540e\u91cd\u8bd5\u3002", (String)"ExcelYearCarryAction_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashSet filterPeriods = new HashSet();
        boolean isEnable = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
        if (isEnable) {
            List orgNumbers = (List)this.param.get("entityNumbers");
            QFilter qfModel = new QFilter("model", "=", (Object)modelId);
            QFilter qfOrg = new QFilter("orgnumber", "in", (Object)orgNumbers);
            QFilter qfScenario = new QFilter(scenario, "=", (Object)sceneId);
            QFilter qfYear = new QFilter(year, "=", (Object)yearId);
            QFilter qfStatus = new QFilter("datastatus", "=", (Object)"A");
            QFilter[] qFilters = new QFilter[]{qfModel, qfOrg, qfScenario, qfYear, qfStatus};
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_periodmanageentity", (String)"id, orgnumber, datastatus, entrystatus, period.number", (QFilter[])qFilters);
            HashMap orgPeriodNums = new HashMap(16);
            for (DynamicObject periodDyn : doc) {
                String orgNumber = periodDyn.getString("orgnumber");
                orgPeriodNums.putIfAbsent(orgNumber, new HashSet());
                ((Set)orgPeriodNums.get(orgNumber)).add(periodDyn.getString("period.number"));
            }
            if (orgPeriodNums.size() != orgNumbers.size()) {
                return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ec4\u7ec7\u4e2d\u4e0d\u5b58\u5728\u5f00\u542f\u7684\u671f\u95f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExcelYearCarryAction_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            Set includes = new HashSet();
            boolean isStartCal = false;
            for (Set value : orgPeriodNums.values()) {
                if (isStartCal && includes.size() == 0) break;
                if (!isStartCal) {
                    includes = value;
                    isStartCal = true;
                    continue;
                }
                includes.retainAll(value);
            }
            if (includes.size() == 0) {
                return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ec4\u7ec7\u4e2d\u4e0d\u5b58\u5728\u5f00\u542f\u7684\u671f\u95f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExcelYearCarryAction_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            filterPeriods.addAll(includes);
        }
        String modelNum = this.getModelNumber();
        String periodNum = MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId).getNumber();
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId).and(scenario, "=", (Object)sceneId).and(new QFilter(year, "=", (Object)yearId));
        DynamicObject first = QueryServiceHelper.queryOne((String)"bcm_carrymap", (String)"id", (QFilter[])modelFilter.toArray());
        if (first != null) {
            long id = first.getLong("id");
            modelFilter.and("id", "=", (Object)id);
            String selefields = "id,entryentity.curperiod as curperiodid,entryentity.lastscenario,entryentity.lastperiod,entryentity.lastyear ";
            DynamicObjectCollection carryObj = QueryServiceHelper.query((String)"bcm_carrymap", (String)selefields, (QFilter[])modelFilter.toArray(), (String)"entryentity.seq");
            if (carryObj.size() > 0) {
                carryObj.removeIf(car -> {
                    String cur = MemberReader.findPeriodMemberById((String)modelNum, (Long)car.getLong("curperiodid")).getNumber();
                    boolean result = filterPeriods.size() == 0 ? cur.compareTo(periodNum) < 0 : cur.compareTo(periodNum) < 0 || !filterPeriods.contains(cur);
                    return result;
                });
                if (carryObj.size() > 0) {
                    return new ExcelApiOutput(this.insertEntry(carryObj, yearId, sceneId, ((DynamicObject)carryObj.get(0)).getLong("entryentity.lastyear"), true, String.valueOf(id)));
                }
            }
        }
        QFilter filter1 = new QFilter("id", "=", (Object)sceneId);
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])new QFilter[]{filter1});
        ArrayList ids = new ArrayList();
        DynamicObjectCollection periods = dot.getDynamicObjectCollection("sceneperiod");
        periods.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
        QFilter idsFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection periodCollection = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id as curperiodid,number,name", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), idsFilter}, (String)NUMBER);
        if (periodCollection != null && periodCollection.size() > 0) {
            periodCollection.removeIf(car -> {
                String cur = car.getString(NUMBER);
                boolean result = filterPeriods.size() == 0 ? cur.compareTo(periodNum) < 0 : cur.compareTo(periodNum) < 0 || !filterPeriods.contains(cur);
                return result;
            });
            if (periodCollection.size() > 0) {
                return new ExcelApiOutput(this.insertEntry(periodCollection, yearId, sceneId, ((DynamicObject)lastyearobj.get(0)).getLong("id"), false, ""));
            }
        }
        return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u660e\u7ec6\u671f\u95f4\u3002", (String)"ExcelYearCarryAction_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public ExcelApiOutput yearCarryConfirmOperation() {
        HashMap<Long, YearCarryTemplate> yearCarryAllTemplates = new HashMap<Long, YearCarryTemplate>();
        HashMap<Long, YearCarryTemplate> yearCarryTemplates = new HashMap<Long, YearCarryTemplate>();
        Object object = this.param.get("dataCollectTemps");
        if (object == null) {
            return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelYearCarryAction_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        List dataCollectTemps = JSON.parseArray((String)object.toString(), YearCarryTemplate.class);
        Long orgid = null;
        for (YearCarryTemplate dataCollectTemp : dataCollectTemps) {
            orgid = dataCollectTemp.getOrgId();
            if (dataCollectTemp.getTemplates() == null || dataCollectTemp.getTemplates().size() == 0) {
                yearCarryAllTemplates.put(orgid, dataCollectTemp);
                continue;
            }
            yearCarryTemplates.put(orgid, dataCollectTemp);
        }
        ExcelApiOutput excelApiOutput = new ExcelApiOutput(true);
        if (yearCarryAllTemplates.size() > 0) {
            excelApiOutput = this.carryOperationInAllTemplates(yearCarryAllTemplates);
        }
        if (excelApiOutput.isSuccess() && yearCarryTemplates.size() > 0) {
            for (Map.Entry yearCarryTemplate : yearCarryTemplates.entrySet()) {
                excelApiOutput = this.carryOperationInTemplates((Long)yearCarryTemplate.getKey(), (YearCarryTemplate)yearCarryTemplate.getValue());
            }
        }
        return excelApiOutput;
    }

    private static final String getOperationBeginningOfTheYear() {
        return ResManager.loadKDString((String)"\u5e74\u521d\u7ed3\u8f6c", (String)"ExcelYearCarryAction_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static final String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ExcelYearCarryAction_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private JSONObject insertEntry(DynamicObjectCollection collection, Long yearId, Long scenarioId, Long lastYearId, boolean haveLastPeriod, String carryId) {
        String modelNum = this.getModelNumber();
        Long lastPeriodId = null;
        Long lastScenarioId = null;
        String lastPeriodNum = "";
        String lastScenarioNum = "";
        String lastPeriodName = "";
        String lastScenarioName = "";
        IDNumberTreeNode idNumberTreeNode = MemberReader.findFyMemberById((String)modelNum, (Long)lastYearId);
        String lastYearNum = idNumberTreeNode.getNumber();
        String lastYearName = idNumberTreeNode.getName();
        Long periodId = null;
        idNumberTreeNode = MemberReader.findFyMemberById((String)modelNum, (Long)yearId);
        String yearNum = idNumberTreeNode.getNumber();
        String yearName = idNumberTreeNode.getName();
        idNumberTreeNode = MemberReader.findScenaMemberById((String)modelNum, (Long)scenarioId);
        String scenarioNum = idNumberTreeNode.getNumber();
        String scenarioName = idNumberTreeNode.getName();
        int size = collection.size();
        if (!haveLastPeriod) {
            lastPeriodId = ((DynamicObject)collection.get(size - 1)).getLong("curperiodid");
            lastPeriodNum = ((DynamicObject)collection.get(size - 1)).getString(NUMBER);
            lastPeriodName = ((DynamicObject)collection.get(size - 1)).getString("name");
            lastScenarioId = scenarioId;
            lastScenarioNum = scenarioNum;
            lastScenarioName = scenarioName;
        }
        ArrayList<CarryConfirmModel> carryConfirmModels = new ArrayList<CarryConfirmModel>(size);
        CarryConfirmModel carryConfirmModel = null;
        for (DynamicObject obj : collection) {
            if (haveLastPeriod) {
                lastPeriodId = obj.getLong("entryentity.lastperiod");
                idNumberTreeNode = MemberReader.findPeriodMemberById((String)modelNum, (Long)lastPeriodId);
                lastPeriodNum = idNumberTreeNode.getNumber();
                lastPeriodName = idNumberTreeNode.getName();
                lastScenarioId = obj.getLong("entryentity.lastscenario");
                idNumberTreeNode = MemberReader.findScenaMemberById((String)modelNum, (Long)lastScenarioId);
                lastScenarioNum = idNumberTreeNode.getNumber();
                lastScenarioName = idNumberTreeNode.getName();
            }
            carryConfirmModel = new CarryConfirmModel();
            carryConfirmModel.setYearId(yearId);
            carryConfirmModel.setYearNumber(yearNum);
            carryConfirmModel.setYearName(yearName);
            periodId = obj.getLong("curperiodid");
            carryConfirmModel.setPeriodId(periodId);
            idNumberTreeNode = MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId);
            carryConfirmModel.setPeriodNumber(idNumberTreeNode.getNumber());
            carryConfirmModel.setPeriodName(idNumberTreeNode.getName());
            carryConfirmModel.setScenarioId(scenarioId);
            carryConfirmModel.setScenarioNumber(scenarioNum);
            carryConfirmModel.setScenarioName(scenarioName);
            carryConfirmModel.setLastYearId(lastYearId);
            carryConfirmModel.setLastYearNumber(lastYearNum);
            carryConfirmModel.setLastYearName(lastYearName);
            carryConfirmModel.setLastScenarioId(lastScenarioId);
            carryConfirmModel.setLastScenarioNumber(lastScenarioNum);
            carryConfirmModel.setLastScenarioName(lastScenarioName);
            carryConfirmModel.setLastPeriodId(lastPeriodId);
            carryConfirmModel.setLastPeriodNumber(lastPeriodNum);
            carryConfirmModel.setLastPeriodName(lastPeriodName);
            carryConfirmModels.add(carryConfirmModel);
        }
        JSONObject returnData = new JSONObject(2);
        returnData.put("carryId", (Object)carryId);
        returnData.put("entryDatas", carryConfirmModels);
        return returnData;
    }

    private Set<Long> getPerm(Long modelId) {
        boolean modelManager = MemberPermHelper.isModelManager((Long)modelId);
        HashSet<Long> set = new HashSet<Long>();
        if (modelManager) {
            return set;
        }
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(modelId), (String)String.valueOf(RequestContext.get().getCurrUserId()));
        Collection entries = map.entries();
        for (Map.Entry entrie : entries) {
            if (!DataTypeEnum.NO.getIndex().equals(entrie.getKey())) continue;
            set.add((Long)entrie.getValue());
        }
        return set;
    }

    private List<YearCarryTemplate> buildCollectDataNodes(DynamicObjectCollection orgs, Set<Long> templateIds) {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        List noPerms = new ArrayList(1);
        if (!adminUserBol) {
            ArrayListMultimap permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_templatecatalog", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId());
            noPerms = permissionMap.get((Object)DataTypeEnum.NO.getIndex());
        }
        List templateModelList = ReportRedisCache.queryTemplateModelFromCache(templateIds, (long)this.getModelId(), (boolean)false);
        List<kd.fi.bcm.common.Pair<String, String>> dimensionPairList = this.getDimensionPairList();
        ArrayList<YearCarryTemplate> temInfoSet = new ArrayList<YearCarryTemplate>(16);
        Long scenarioId = this.getScenarioId();
        IDNumberTreeNode idNumberTreeNode = MemberReader.findScenaMemberById((String)this.getModelNumber(), (Long)scenarioId);
        String scenarioName = idNumberTreeNode.getName();
        if (orgs != null) {
            for (DynamicObject org : orgs) {
                YearCarryTemplate yearCarryTemplate = new YearCarryTemplate();
                yearCarryTemplate.setOrgNumber(org.getString(NUMBER));
                yearCarryTemplate.setOrgName(org.getString("name"));
                Long orrgId = org.getLong("id");
                yearCarryTemplate.setOrgId(orrgId);
                yearCarryTemplate.setScenarioId(scenarioId);
                yearCarryTemplate.setScenarioName(scenarioName);
                HashSet<Long> orgIdSet = new HashSet<Long>(1);
                IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)orrgId);
                Long orgBaseId = node.isShare() ? node.getCopyfromId() : orrgId;
                orgIdSet.add(orgBaseId);
                HashSet<Long> tempIds = new HashSet<Long>(templateIds.size());
                tempIds.addAll(templateIds);
                Map<Long, Set<Long>> disMaps = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)this.getModelId(), tempIds, orgIdSet);
                disMaps = this.delNoOrgMember(disMaps, orgIdSet);
                Map source2Right = TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)this.getYearId(), (Long)this.getPeriodId(), disMaps.keySet());
                HashSet rTempIds = new HashSet(source2Right.values());
                for (TemplateModel templateModel : templateModelList) {
                    boolean flag;
                    if (!rTempIds.contains(templateModel.getId()) || !(flag = this.handleTemplateViewPageDim(dimensionPairList, templateModel, true)) && !noPerms.contains(templateModel.getTemplateCatalog().getId())) continue;
                    rTempIds.remove(templateModel.getId());
                }
                QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
                qFilter.and(new QFilter("id", "in", rTempIds));
                qFilter.and(new QFilter("usage", "=", (Object)"1"));
                qFilter.and("templatetype", "in", (Object)new String[]{String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType())});
                qFilter.and("status", "=", (Object)"1");
                qFilter.and("isonlyread", "=", (Object)false);
                DynamicObjectCollection templateColls = TreeBuilder.getTempTreeDynamicObjects(() -> new QFilter[]{qFilter}, null);
                rTempIds.clear();
                for (DynamicObject templateColl : templateColls) {
                    rTempIds.add(templateColl.getLong("id"));
                }
                templateModelList.forEach(t -> {
                    if (rTempIds.contains(t.getId())) {
                        yearCarryTemplate.getTemplates().add(this.getReportTemplate((TemplateModel)t));
                    }
                });
                temInfoSet.add(yearCarryTemplate);
            }
        }
        return temInfoSet;
    }

    private void fillCarryStatus(List<YearCarryTemplate> billNodes, Set<Long> orgIdSet) {
        Long modelId = this.getModelId();
        Long yearId = this.getYearId();
        Long periodId = this.getPeriodId();
        Long scenarioId = this.getScenarioId();
        QFBuilder filter = new QFBuilder();
        filter.add("model", "=", (Object)modelId);
        filter.add("scene", "=", (Object)scenarioId);
        filter.add(year, "=", (Object)yearId);
        filter.add(period, "=", (Object)periodId);
        filter.add("org", "in", orgIdSet);
        String seletFields = "model,scene,year,period,org.name,org.number,lastscene,lastperiod,carrystatus,modifier,modifydate,entryentity.account,entryentity.scope,entryentity.sourceperiod";
        DynamicObject[] allCarryStatus = BusinessDataServiceHelper.load((String)"bcm_carryentity", (String)seletFields, (QFilter[])filter.toArray(), (String)"modifydate desc");
        HashMap<String, DynamicObject> statustable = new HashMap<String, DynamicObject>(allCarryStatus.length);
        for (DynamicObject obj : allCarryStatus) {
            String key = obj.getString("org.id");
            if (statustable.containsKey(key)) continue;
            statustable.put(key, obj);
        }
        String modelNum = this.getModelNumber();
        Optional lastYear = PeriodUtils.getLastYear((String)modelNum, (String)this.getYearNumber());
        Optional endPeriod = PeriodUtils.getLastPeriod((String)modelNum, (String)"M_M01", (boolean)true);
        billNodes.forEach(n -> {
            DynamicObject dyObj = (DynamicObject)statustable.get(String.valueOf(n.getOrgId()));
            if (dyObj != null) {
                n.setCarryStatus(dyObj.getString("carrystatus"));
                if (!dyObj.getString("carrystatus").equals("0") && lastYear.isPresent()) {
                    String defaultPeriod = null;
                    if (endPeriod.isPresent()) {
                        defaultPeriod = MemberReader.findPeriodMemberByNum((String)modelNum, (String)((String)endPeriod.get())).getName();
                    }
                    n.setCarryContent(this.setAccountStr(n.getScenarioName(), MemberReader.findFyMemberByNum((String)modelNum, (String)((String)lastYear.get())).getName(), defaultPeriod, dyObj));
                }
            }
        });
    }

    private String setAccountStr(String defaultScene, String year, String defaultPeriod, DynamicObject dyObj) {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection dyns = dyObj.getDynamicObjectCollection("entryentity");
        if (StringUtils.isNotEmpty((CharSequence)dyObj.getString("lastscene.name"))) {
            defaultScene = dyObj.getString("lastscene.name");
        }
        if (StringUtils.isNotEmpty((CharSequence)dyObj.getString("lastperiod.name"))) {
            defaultPeriod = dyObj.getString("lastperiod.name");
        }
        sb.append(ResManager.loadKDString((String)"\u9ed8\u8ba4\uff1a", (String)"ExcelYearCarryAction_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(defaultScene).append("_").append(year).append("_").append(defaultPeriod).append(";");
        if (dyns.size() != 0) {
            sb.append(ResManager.loadKDString((String)"\u7279\u6b8a\uff1a", (String)"ExcelYearCarryAction_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            for (DynamicObject dyn : dyns) {
                IDNumberTreeNode member = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_accountmembertree", (Long)dyn.getLong("account.id"));
                RangeEnum.buildScopeShowName((StringBuilder)sb, (String)member.getName(), (int)dyn.getInt("scope"));
                sb = new StringBuilder(sb.substring(0, sb.length() - 1));
                if (dyn.getDynamicObject("sourceperiod") != null) {
                    defaultPeriod = dyn.getDynamicObject("sourceperiod").getString("name");
                }
                sb.append("_").append(defaultPeriod).append(",");
            }
            sb = new StringBuilder(sb.substring(0, sb.length() - 1));
        }
        return sb.toString();
    }

    private ExcelApiOutput carryOperationInAllTemplates(Map<Long, YearCarryTemplate> yearCarryAllTemplates) {
        Long modelId = this.getModelId();
        ArrayList<Long> orgIds = new ArrayList<Long>(yearCarryAllTemplates.size());
        orgIds.addAll(yearCarryAllTemplates.keySet());
        HashSet orgNumbers = new HashSet();
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,name,parent.number", (QFilter[])new QFilter[]{new QFilter("id", "in", yearCarryAllTemplates.keySet()), new QFilter("model", "=", (Object)modelId)});
        result.forEach(e -> {
            orgNumbers.add(e.getString(NUMBER));
            orgNumbers.add(e.getString("parent.number") + "_" + e.getString(NUMBER));
        });
        if (orgNumbers.size() == 0) {
            return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7ec4\u7ec7\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"ExcelYearCarryAction_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        List CaryyEntrys = JSON.parseArray((String)this.param.get("CaryyEntrys").toString(), CarryConfirmModel.class);
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Long scenarioId = ((CarryConfirmModel)CaryyEntrys.get(0)).getScenarioId();
        String scenarioNumber = ((CarryConfirmModel)CaryyEntrys.get(0)).getScenarioNumber();
        String lastScenarioNumber = ((CarryConfirmModel)CaryyEntrys.get(0)).getLastScenarioNumber();
        Long yearId = ((CarryConfirmModel)CaryyEntrys.get(0)).getYearId();
        Set curPeriodIds = CaryyEntrys.stream().map(CarryConfirmModel::getPeriodId).collect(Collectors.toSet());
        Map<Long, String> periodIdToNumberMap = CaryyEntrys.stream().collect(Collectors.toMap(CarryConfirmModel::getPeriodId, CarryConfirmModel::getPeriodNumber, (key1, key2) -> key2));
        HashSet<String> orgAndPeriod = new HashSet<String>(16);
        for (YearCarryTemplate yearCarryTemplate : yearCarryAllTemplates.values()) {
            for (CarryConfirmModel carryEntry : CaryyEntrys) {
                orgAndPeriod.add(String.format("%s_%s_%s_%s", yearCarryTemplate.getOrgNumber(), scenarioId, yearId, carryEntry.getPeriodId()));
            }
        }
        HashMap mcStatusMap = new HashMap(16);
        for (Long period : curPeriodIds) {
            mcStatusMap.putAll(McStatus.batchGetMcStatus((Object)modelId, orgIds, (Object)scenarioId, (Object)yearId, (Object)period));
        }
        if (mcStatusMap.values().stream().anyMatch(m -> m.getFlow().isSubmit())) {
            return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u4e2d\u5305\u542b\u5df2\u63d0\u4ea4\u6216\u8005\u5df2\u5f52\u6863\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ExcelYearCarryAction_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        boolean bl = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
        if (bl) {
            HashSet<Long> scenarioIdSet = new HashSet<Long>(16);
            scenarioIdSet.add(scenarioId);
            HashSet<Long> yearIdSet = new HashSet<Long>(16);
            yearIdSet.add(yearId);
            Map dataPeriodStatus = PeriodSettingHelper.batchCheckPeriodStatus((long)modelId, orgNumbers, scenarioIdSet, yearIdSet, curPeriodIds, (String)"datastatus");
            ArrayList<String> notOpenPeriodOrgNumber = new ArrayList<String>(10);
            for (String key3 : orgAndPeriod) {
                if (((Boolean)dataPeriodStatus.get(key3)).booleanValue()) continue;
                String[] split = key3.split("_");
                notOpenPeriodOrgNumber.add(split[0] + "_" + periodIdToNumberMap.get(LongUtil.toLong((Object)split[3])));
            }
            if (notOpenPeriodOrgNumber.size() > 0) {
                return new ExcelApiOutput(false, String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExcelYearCarryAction_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", notOpenPeriodOrgNumber)));
            }
        }
        DynamicObject[] dyns = new DynamicObject[CaryyEntrys.size() * orgIds.size()];
        Map carrySpecialSetting = CarryServiceHelper.getCarrySpecialSetting((String)modelNumber, (String)scenarioNumber, (String)((CarryConfirmModel)CaryyEntrys.get(0)).getYearNumber());
        int index = 0;
        for (CarryConfirmModel CaryyEntry : CaryyEntrys) {
            String opDescriotion;
            StringBuilder builder = CarryServiceHelper.simpleCarry((long)modelId, (String)modelNumber, (String)lastScenarioNumber, (String)CaryyEntry.getLastYearNumber(), (String)CaryyEntry.getLastPeriodNumber(), (String)scenarioNumber, (String)CaryyEntry.getYearNumber(), (String)CaryyEntry.getPeriodNumber(), orgNumbers, Collections.emptySet(), null);
            Map specials = (Map)carrySpecialSetting.get(CaryyEntry.getPeriodNumber());
            if (builder.length() > 0) {
                for (DynamicObject res : result) {
                    builder.insert(0, res.getString(NUMBER) + " " + res.getString("name") + " ");
                    opDescriotion = builder + ExcelYearCarryAction.getOperationStstusSuccess();
                    OperationLogUtil.writeOperationLog((String)ExcelYearCarryAction.getOperationBeginningOfTheYear(), (String)opDescriotion, (Long)this.getModelId(), (String)"bcm_carryconfirm_multi");
                }
            } else {
                for (DynamicObject res : result) {
                    opDescriotion = res.getString(NUMBER) + " " + res.getString("name") + "," + ExcelYearCarryAction.getOperationBeginningOfTheYear() + ExcelYearCarryAction.getOperationStstusSuccess();
                    OperationLogUtil.writeOperationLog((String)ExcelYearCarryAction.getOperationBeginningOfTheYear(), (String)opDescriotion, (Long)this.getModelId(), (String)"bcm_carryconfirm_multi");
                }
            }
            for (int i = 0; i < orgIds.size(); ++i) {
                Long orgId = (Long)orgIds.get(i);
                DynamicObject carryObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_carryentity");
                carryObj.set("model", (Object)modelId);
                carryObj.set("scene", (Object)scenarioId);
                carryObj.set("lastscene", (Object)CaryyEntry.getLastScenarioId());
                carryObj.set(year, (Object)yearId);
                carryObj.set(period, (Object)CaryyEntry.getPeriodId());
                carryObj.set("lastperiod", (Object)CaryyEntry.getLastPeriodId());
                carryObj.set("org", (Object)orgId);
                carryObj.set("carrystatus", (Object)"1");
                carryObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                carryObj.set("modifydate", (Object)TimeServiceHelper.now());
                if (builder.length() > 0 && specials != null) {
                    DynamicObjectCollection colls = carryObj.getDynamicObjectCollection("entryentity");
                    HashMap<String, List> sourcePeriod = new HashMap<String, List>(16);
                    specials.forEach((key, val) -> {
                        if (!key.equals(CaryyEntry.getLastPeriodNumber())) {
                            for (String v : val) {
                                Map tempMapList = (Map)SerializationUtils.fromJsonString((String)v, Map.class);
                                HashSet entities = new HashSet(16);
                                if (tempMapList.get(SysDimensionEnum.Entity.getSign()) != null) {
                                    ((List)tempMapList.get(SysDimensionEnum.Entity.getSign())).stream().forEach(map -> {
                                        Long id = Long.valueOf((String)map.get("id"));
                                        String scope = (String)map.get("scope");
                                        String entityNum = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)id).getNumber();
                                        new MembRangeItem("bcm_entitymembertree", id, entityNum, RangeEnum.getRangeByVal((int)Integer.parseInt(scope)), false, (Object)modelId).matchItems(c -> entities.add(c.id.toString()));
                                    });
                                }
                                if (entities.size() != 0 && !entities.contains(orgId.toString())) continue;
                                sourcePeriod.putIfAbsent((String)key, new ArrayList(10));
                                if (tempMapList.get(SysDimensionEnum.Account.getSign()) == null) continue;
                                ((List)tempMapList.get(SysDimensionEnum.Account.getSign())).stream().forEach(map -> ((List)sourcePeriod.get(key)).add(new kd.fi.bcm.common.Pair((Object)Long.valueOf((String)map.get("id")), map.get("scope"))));
                            }
                        }
                    });
                    if (sourcePeriod.size() > 0) {
                        sourcePeriod.forEach((per, pairs) -> {
                            Long periodId = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)per).getId();
                            if (pairs.size() == 0) {
                                DynamicObject temp = new DynamicObject(colls.getDynamicObjectType());
                                temp.set("sourceperiod", (Object)periodId);
                                colls.add((Object)temp);
                            } else {
                                for (kd.fi.bcm.common.Pair pair : pairs) {
                                    DynamicObject temp = new DynamicObject(colls.getDynamicObjectType());
                                    temp.set("account", pair.p1);
                                    temp.set("scope", pair.p2);
                                    temp.set("sourceperiod", (Object)periodId);
                                    colls.add((Object)temp);
                                }
                            }
                        });
                    }
                }
                dyns[index] = carryObj;
                ++index;
            }
        }
        SaveServiceHelper.save((DynamicObject[])dyns);
        return new ExcelApiOutput(true);
    }

    private ExcelApiOutput carryOperationInTemplates(Long orgid, YearCarryTemplate yearCarryTemplate) {
        if (yearCarryTemplate == null || yearCarryTemplate.getTemplates() == null || yearCarryTemplate.getTemplates().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5e74\u7ed3\u7684\u62a5\u8868\u8bb0\u5f55\u3002", (String)"ExcelYearCarryAction_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        boolean isDC = true;
        Map<Long, Set<String>> orgIdNumberMap = this.getOrgNumbers(orgid);
        HashSet<String> orgnumbers = new HashSet<String>(16);
        for (Set<String> numset : orgIdNumberMap.values()) {
            orgnumbers.addAll(numset);
        }
        Long modelId = this.getModelId();
        Long scenarioId = this.getScenarioId();
        Long yearId = this.getYearId();
        Long periodId = this.getPeriodId();
        Map mcStatusMap = McStatus.batchGetMcStatus((Object)modelId, orgIdNumberMap.keySet(), (Object)scenarioId, (Object)yearId, (Object)periodId);
        for (Map.Entry<Long, Set<String>> entry : orgIdNumberMap.entrySet()) {
            McStatus mcStatus = (McStatus)mcStatusMap.get(entry.getKey());
            if (!mcStatus.getFlow().isSubmit()) continue;
            orgnumbers.removeAll((Collection)entry.getValue());
        }
        String onlyselfOrNot = "1";
        if (orgnumbers.size() == 0) {
            if ("1".equals(onlyselfOrNot)) {
                return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5728\u667a\u80fd\u5408\u5e76\u4e2d\u7684\u6d41\u7a0b\u72b6\u6001\u4e0d\u662f\u5904\u7406\u4e2d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5e74\u521d\u7ed3\u8f6c\u3002", (String)"ExcelYearCarryAction_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return new ExcelApiOutput(true, ResManager.loadKDString((String)"\u5e74\u7ed3\u6210\u529f\uff0c\u5df2\u8df3\u8fc7\u667a\u80fd\u5408\u5e76\u4e2d\u6d41\u7a0b\u72b6\u6001\u4e3a\u975e\u5904\u7406\u4e2d\u7684\u7ec4\u7ec7\u8bb0\u5f55\u3002", (String)"ExcelYearCarryAction_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        List CaryyEntrys = JSON.parseArray((String)this.param.get("CaryyEntrys").toString(), CarryConfirmModel.class);
        ArrayList<String> opDescriotions = new ArrayList<String>(yearCarryTemplate.getTemplates().size());
        for (ReportTemplate template : yearCarryTemplate.getTemplates()) {
            long templateId = template.getId();
            if (!isDC) continue;
            HashSet accounts = new HashSet();
            List scope = SpreadMemUtil.analysisMemberFromSheet((SpreadManager)SpreadMemUtil.querySpreadManager((Long)templateId), (TemplateModel)TemplateUtil.getTempModel((Object)templateId), (String[])new String[]{DimTypesEnum.CHANGETYPE.getNumber(), DimTypesEnum.ACCOUNT.getNumber()});
            scope.forEach(e -> {
                Set cts = (Set)e.get(PresetConstant.CHANGETYPE_DIM);
                if (cts != null && (cts.contains("BFLY") || cts.contains("BBOY"))) {
                    accounts.addAll((Collection)e.get(PresetConstant.ACCOUNT_DIM));
                }
            });
            if (accounts.size() <= 0) continue;
            for (CarryConfirmModel CaryyEntry : CaryyEntrys) {
                CarryServiceHelper.simpleCarry((long)this.getModelId(), (String)this.getModelNumber(), (String)CaryyEntry.getLastScenarioNumber(), (String)CaryyEntry.getLastYearNumber(), (String)CaryyEntry.getLastPeriodNumber(), (String)CaryyEntry.getScenarioNumber(), (String)CaryyEntry.getYearNumber(), (String)CaryyEntry.getPeriodNumber(), orgnumbers, accounts, null);
                IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgid);
                opDescriotions.add(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s,\u5e74\u7ed3\u64cd\u4f5c\u6210\u529f\u3002", (String)"ExcelYearCarryAction_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), node.getName(), template.getNumber(), template.getName()));
            }
        }
        if (opDescriotions.size() > 0) {
            OperationLogUtil.batchWriteOperationLog((String)ResManager.loadKDString((String)"\u5e74\u7ed3", (String)"ExcelYearCarryAction_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opDescriotions, (Long)modelId, (String)"bcm_carryconfirm");
        }
        if ("1".equals(onlyselfOrNot)) {
            return new ExcelApiOutput(true, ResManager.loadKDString((String)"\u5e74\u7ed3\u6267\u884c\u6210\u529f\u3002", (String)"ExcelYearCarryAction_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return new ExcelApiOutput(true, ResManager.loadKDString((String)"\u5e74\u7ed3\u6210\u529f\uff0c\u5df2\u8df3\u8fc7\u667a\u80fd\u5408\u5e76\u4e2d\u6d41\u7a0b\u72b6\u6001\u4e3a\u975e\u5904\u7406\u4e2d\u7684\u7ec4\u7ec7\u8bb0\u5f55\u3002", (String)"ExcelYearCarryAction_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private Map<Long, Set<String>> getOrgNumbers(Long orgid) {
        HashMap<Long, Set<String>> orgIdNumberMap = new HashMap<Long, Set<String>>(16);
        String onlyselfOrNot = "1";
        DynamicObject org = QueryDimensionServiceHelper.getMemMsgById((String)String.valueOf(orgid), (String)"bcm_entitymembertree");
        if (!DimTypesEnum.ENTITY.getNumber().equals(org.getString(NUMBER)) && onlyselfOrNot.equals("2")) {
            QFBuilder qf = new QFBuilder("model", "=", (Object)this.getModelId());
            qf.add("cslscheme", "=", (Object)org.getLong("cslscheme"));
            qf.add("longnumber", "like", (Object)(org.getString("longnumber") + "%"));
            DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,parent.number", (QFilter[])qf.toArray());
            result.forEach(e -> {
                HashSet<String> tempnums = new HashSet<String>(2);
                tempnums.add(e.getString(NUMBER));
                tempnums.add(e.getString("parent.number") + "_" + e.getString(NUMBER));
                orgIdNumberMap.put(e.getLong("id"), tempnums);
            });
        } else {
            HashSet<String> tempnums = new HashSet<String>(2);
            tempnums.add(org.getString(NUMBER));
            orgIdNumberMap.put(org.getLong("id"), tempnums);
        }
        return orgIdNumberMap;
    }

    private void removeExchangeAccount(Long modelId, Map<String, Set<String>> accountNums) {
        HashSet<String> allAccount = new HashSet<String>();
        for (Set<String> nums : accountNums.values()) {
            allAccount.addAll(nums);
        }
        QFBuilder qb = new QFBuilder();
        qb.add(NUMBER, "in", allAccount);
        qb.add("accounttype", "!=", (Object)AccountTypeEnum.EXCHANGERATE.index);
        qb.add("model", "=", (Object)modelId);
        qb.add("isleaf", "=", (Object)true);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)NUMBER, (QFilter[])qb.toArray());
        if (!CollectionUtils.isEmpty((Collection)cols)) {
            Set contains = cols.stream().map(col -> col.getString(NUMBER)).collect(Collectors.toSet());
            for (Set<String> value : accountNums.values()) {
                value.retainAll(contains);
            }
        }
    }

    private String getModelNumber() {
        return this.param.get("modelNumber").toString();
    }

    @Override
    protected Long getModelId() {
        return (Long)this.param.get("modelId");
    }

    private Map<Long, Set<Long>> delNoOrgMember(Map<Long, Set<Long>> distributeMap, Set<Long> orgRangeBaseMember) {
        HashMap<Long, Set<Long>> distributeMapTemp = new HashMap<Long, Set<Long>>();
        distributeMap.forEach((p, v) -> {
            if (v != null && v.size() != 0) {
                v.retainAll(orgRangeBaseMember);
                distributeMapTemp.put((Long)p, (Set<Long>)v);
            }
        });
        return distributeMapTemp;
    }

    private List<kd.fi.bcm.common.Pair<String, String>> getDimensionPairList() {
        ArrayList dimensionPairList = Lists.newArrayList((Object[])new kd.fi.bcm.common.Pair[]{kd.fi.bcm.common.Pair.onePair((Object)scenario, (Object)"bcm_scenemembertree"), kd.fi.bcm.common.Pair.onePair((Object)year, (Object)"bcm_fymembertree"), kd.fi.bcm.common.Pair.onePair((Object)period, (Object)"bcm_periodmembertree")});
        return dimensionPairList;
    }

    private boolean handleTemplateViewPageDim(List<kd.fi.bcm.common.Pair<String, String>> dimensionPairList, TemplateModel templateModel, boolean isNewModel) {
        for (int i = 0; i < dimensionPairList.size(); ++i) {
            if (!templateModel.isSaveByDim() && DimEntityNumEnum.SCENARIO.getEntityNum().equals(dimensionPairList.get((int)i).p2)) continue;
            String f7Key = (String)dimensionPairList.get((int)i).p1;
            Long id = 0L;
            switch (f7Key) {
                case "scenario": {
                    id = this.getScenarioId();
                    break;
                }
                case "year": {
                    id = this.getYearId();
                    break;
                }
                case "period": {
                    id = this.getPeriodId();
                    break;
                }
            }
            boolean isInnerRange = TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)id);
            if (isNewModel && f7Key.equals(year)) {
                if (!isInnerRange) {
                    boolean isCurrentOrLastYear;
                    isInnerRange = isCurrentOrLastYear = TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)this.getIdByNumber((String)dimensionPairList.get((int)i).p2, "CurrentYear", templateModel.getModelId())) || TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)this.getIdByNumber((String)dimensionPairList.get((int)i).p2, "LastYear", templateModel.getModelId()));
                }
            } else if (isNewModel && f7Key.equals(period) && !isInnerRange) {
                boolean isCurrentOrLastPeriod;
                isInnerRange = isCurrentOrLastPeriod = TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)this.getIdByNumber((String)dimensionPairList.get((int)i).p2, "CurrentPeriod", templateModel.getModelId())) || TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)this.getIdByNumber((String)dimensionPairList.get((int)i).p2, "LastPeriod", templateModel.getModelId()));
            }
            if (isInnerRange) continue;
            return true;
        }
        return false;
    }

    private Object getIdByNumber(String entity, String number, Long modelId) {
        return ThreadCache.get((Object)("id:" + entity + "|" + number), () -> {
            DynamicObject at = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number), new QFilter("model", "=", (Object)modelId)});
            return at.getLong("id");
        });
    }
}

