/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.exchangeRate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.exchangeRate.ExchangeRateCopyServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.collections.CollectionUtils;

public class ExchangeRateCopy
extends AbstractBaseFormPlugin {
    private static final String FY = "fy";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String SCENE = "scene";
    private static final String COPY = "copy";
    private static final String ISSHARE = "isshare";
    private static final String ENTITYID = "entityid";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fydedit = (BasedataEdit)this.getControl(YEAR);
        BasedataEdit periodedit = (BasedataEdit)this.getControl(PERIOD);
        BasedataEdit scenededit = (BasedataEdit)this.getControl(SCENE);
        fydedit.addBeforeF7SelectListener(this::beforeF7Select);
        periodedit.addBeforeF7SelectListener(this::beforeF7Select);
        scenededit.addBeforeF7SelectListener(this::beforeF7Select);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long modelId = this.getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String contextStr = (String)params.get("context");
        FixedItem context = (FixedItem)ObjectSerialUtil.deSerializedBytes((String)contextStr);
        String entityId = String.valueOf(context.getEntityId());
        Boolean isShareScene = ExchangeRateShareSceneHelper.isOpenRateShare((String)entityId);
        this.getPageCache().put(ENTITYID, entityId);
        if (isShareScene.booleanValue()) {
            this.getPageCache().put(ISSHARE, "1");
            this.getModel().setValue(SCENE, (Object)context.getScenarioId());
            this.getView().setVisible(Boolean.FALSE, new String[]{SCENE});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String f7Key = ((Control)beforeF7SelectEvent.getSource()).getKey();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"))));
        qfilters.add(new QFilter("isleaf", "=", (Object)"1"));
        switch (f7Key) {
            case "year": {
                qfilters.add(new QFilter("number", "not in", (Object)new String[]{"CurrentYear", "LastYear"}));
                break;
            }
            case "period": {
                DynamicObject yearDy = (DynamicObject)this.getModel().getValue(YEAR);
                if (yearDy == null || this.getValue(YEAR) == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d22\u5e74\u3002", (String)"RptAdjustQueryEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                if ("1".equals(this.getPageCache().get(ISSHARE))) {
                    HashMap maps = ExchangeRateShareSceneHelper.getRateShareScenePeriodIds((String)this.getPageCache().get(ENTITYID), (String)yearDy.getString("number"));
                    qfilters.add(new QFilter("id", "in", maps.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                } else {
                    DynamicObject obj = (DynamicObject)this.getModel().getValue(SCENE);
                    if (obj == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"GuideBasePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                    String currentSceneId = obj.getString("id");
                    if (LongUtil.isvalidLong((Object)currentSceneId)) {
                        qfilters.add(new QFilter("id", "in", (Object)ExchangeRateShareSceneHelper.getScenePeriodIds((String)currentSceneId, (String)yearDy.getString("number"))));
                    }
                }
                qfilters.add(new QFilter("number", "not in", (Object)new String[]{"CurrentPeriod", "LastPeriod"}));
                break;
            }
            case "scene": {
                break;
            }
        }
        beforeF7SelectEvent.setCustomQFilters(qfilters);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map params;
        String contextStr;
        FixedItem tgttext;
        ResultBox result;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (COPY.equals(operate.getOperateKey()) && CollectionUtils.isNotEmpty((Collection)(result = ExchangeRateCopyServiceHelper.copyData((FixedItem)this.getSourceContext(tgttext = (FixedItem)ObjectSerialUtil.deSerializedBytes((String)(contextStr = (String)(params = this.getView().getFormShowParameter().getCustomParams()).get("context")))), (FixedItem)tgttext)).getErrorList())) {
            args.setCancel(Boolean.TRUE.booleanValue());
            this.getView().showErrorNotification(result.getMessageText());
        }
    }

    private FixedItem getSourceContext(FixedItem ctx) {
        DynamicObject sourceScene = this.getModel().getDataEntity().getDynamicObject(SCENE);
        DynamicObject originfy = this.getModel().getDataEntity().getDynamicObject(YEAR);
        DynamicObject originperiod = this.getModel().getDataEntity().getDynamicObject(PERIOD);
        SimpleItem scenario = null;
        scenario = sourceScene == null ? SimpleItem.newOne((Object)ctx.getScenarioId(), (String)ctx.getScenarioNum()) : SimpleItem.newOne((Object)sourceScene.getLong("id"), (String)sourceScene.getString("number"));
        SimpleItem fy = SimpleItem.newOne((Object)originfy.getLong("id"), (String)originfy.getString("number"));
        SimpleItem period = SimpleItem.newOne((Object)originperiod.getLong("id"), (String)originperiod.getString("number"));
        FixedItem srcCtx = FixedItem.newOne((SimpleItem)ctx.getModel(), (SimpleItem)scenario, (SimpleItem)fy, (SimpleItem)period, (SimpleItem)ctx.getEntity());
        return srcCtx;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean isSuccess = afterDoOperationEventArgs.getOperationResult().getValidateResult().isSuccess();
        if (isSuccess && COPY.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getView().returnDataToParent((Object)this.getView().getFormShowParameter().getStatus());
            this.getView().close();
        }
    }
}

