/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.exchangeRate;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.FormulaServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class ExchangeRateFormulaPlugin
extends AbstractBaseFormPlugin {
    private static final String ENTRYENTITY = "rateformulaentry";
    private static final String entity = "entity";
    private static final String account = "account";
    private static final String btncancel = "btncancel";
    private static final String btnok = "btnok";
    private static final String FORMULA = "formula";
    private static final String FORMULATEXT = "formulatext";
    private static final String ORIGIN_ENTRYENTITY = "origin_entryentity";

    @Override
    public void initialize() {
        BasedataEdit plan;
        super.initialize();
        this.addClickListeners(btncancel, btnok, FORMULATEXT);
        this.addItemClickListeners("advcontoolbarap");
        BasedataEdit source = (BasedataEdit)this.getControl(account);
        if (source != null) {
            source.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((plan = (BasedataEdit)this.getControl(entity)) != null) {
            plan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            plan.setF7BatchFill(Boolean.FALSE.booleanValue());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadRateFormula();
        if (Objects.equals("1", this.getFormCustomParam("readOnly"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{btnok});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (FORMULATEXT.equals(propName) && (newValue == null || "".equals(newValue))) {
            this.getModel().setValue(FORMULA, (Object)"", this.getModel().getEntryCurrentRowIndex(ENTRYENTITY));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        String key = beforeF7SelectEvent.getProperty().getName();
        if (account.equals(key)) {
            QFilter qfnumber = new QFilter("number", "like", (Object)"UserdefinedRate%");
            qfnumber.or("number", "=", (Object)"ClosingRate");
            qfnumber.or("number", "=", (Object)"AverageRate");
            this.getPermFilter(qFilter, "bcm_accountmembertree");
            qFilter.and(qfnumber);
            beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, account));
        } else if (entity.equals(key)) {
            IDNumberTreeNode rateEntityNode = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)"RateEntity");
            qFilter.and("isexchangerate", "=", (Object)"1");
            qFilter.and("parent", "=", (Object)rateEntityNode.getId());
            this.getPermFilter(qFilter, "bcm_entitymembertree");
            beforeF7SelectEvent.getFormShowParameter().addCustPlugin("kd.fi.bcm.formplugin.convertscheme.FiledCustomVisiblePlugin");
            beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6c47\u7387\u65b9\u6848", (String)"ConvertSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, entity));
        }
        beforeF7SelectEvent.addCustomQFilter(qFilter);
    }

    @Override
    public void click(EventObject evt) {
        String opkey = ((Control)evt.getSource()).getKey();
        if (btncancel.equals(opkey)) {
            return;
        }
        super.click(evt);
        if (FORMULATEXT.equalsIgnoreCase(opkey)) {
            this.openCvtFormula();
        } else if (btnok.equalsIgnoreCase(opkey)) {
            if (this.checkData() == Boolean.FALSE) {
                return;
            }
            DynamicObjectCollection rateColl = this.getModel().getEntryEntity(ENTRYENTITY);
            String origin = this.getPageCache().get(ORIGIN_ENTRYENTITY);
            if (StringUtils.isNotEmpty((CharSequence)origin)) {
                Object[] originformulas = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)origin);
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_rateformula"), (Object[])originformulas);
            }
            SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_rateformula"), (Object[])this.generateRateFormulas(rateColl));
            String context = (String)this.getView().getFormShowParameter().getCustomParam("context");
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)context)) {
                FixedItem ctx = (FixedItem)SerializationUtils.deSerializeFromBase64((String)context);
                sb.append(ctx.getNoEntityInfo());
            }
            sb.append(ResultStatusEnum.SUCCESS.getName());
            OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u6c47\u7387\u516c\u5f0f\u8bbe\u7f6e", (String)"ExchangeRateMaintainPlugin_51", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)sb.toString(), (Long)this.getModelId(), (String)"bcm_exchangerateplan_edit");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ExchangeRateFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void checkPerm(String opkey) {
        String[] perm = this.getPerm("btn_configformula", "bcm_exchangerate_maintain");
        if (perm == null) {
            return;
        }
        String bizAppId = this.getBizAppId();
        if (ApplicationTypeEnum.BGMD.appnum.equalsIgnoreCase(bizAppId)) {
            bizAppId = ApplicationTypeEnum.EB.appnum;
        }
        this.doCheckPermission(perm[0], perm[1], this.getModelId(), bizAppId);
        this.doCheckUnionPerm(perm);
    }

    private Boolean checkData() {
        DynamicObjectCollection rateColl = this.getModel().getEntryEntity(ENTRYENTITY);
        int i = 0;
        for (DynamicObject rate : rateColl) {
            if (rate.get(account) == null || rate.getLong("account.id") == 0L) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6c47\u7387\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExchangeRateFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                return Boolean.FALSE;
            }
            if (StringUtils.isEmpty((CharSequence)rate.getString(FORMULATEXT))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExchangeRateFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                return Boolean.FALSE;
            }
            if (StringUtils.isEmpty((CharSequence)rate.getString("status"))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExchangeRateFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                return Boolean.FALSE;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    private DynamicObject[] generateRateFormulas(DynamicObjectCollection entryentity) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(entryentity.size());
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)entryentity.size());
        int i = 0;
        for (DynamicObject s : entryentity) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rateformula");
            object.set("model", (Object)this.getModelId());
            object.set("executionorder", s.get("executionorder"));
            object.set(account, s.get(account));
            object.set(entity, s.get(entity));
            object.set(FORMULA, s.get(FORMULA));
            object.set("description", s.get("description"));
            object.set("status", s.get("status"));
            object.set("id", (Object)ids[i]);
            result.add(object);
            ++i;
        }
        return result.toArray(new DynamicObject[0]);
    }

    private void openCvtFormula() {
        if (0L == this.getModelId()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ConvertSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_convertformula_edit");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c47\u7387\u516c\u5f0f\u7f16\u8f91", (String)"ExchangeRateMaintainPlugin_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("showtype", (Object)"1");
        int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        Object myformula = this.getModel().getValue(FORMULA, index);
        if (null != myformula && StringUtils.isNotBlank((CharSequence)String.valueOf(myformula))) {
            formShowParameter.setCustomParam(FORMULA, myformula);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "RateFormula");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void loadRateFormula() {
        Long modelId = this.getModelId();
        if (!LongUtil.isvalidLong((Object)modelId)) {
            return;
        }
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_rateformula").getAllFields().keySet();
        DynamicObject[] rateformula = BusinessDataServiceHelper.load((String)"bcm_rateformula", (String)StringUtils.join(fields, (String)","), (QFilter[])new QFBuilder("model", "=", (Object)modelId).toArray(), (String)"id");
        if (rateformula == null || rateformula.length == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, rateformula.length);
        int index = 0;
        for (DynamicObject entry : rateformula) {
            this.getModel().setValue("id", entry.get("id"), index);
            this.getModel().setValue("executionorder", entry.get("executionorder"), index);
            this.getModel().setValue(account, (Object)entry.getDynamicObject(account), index);
            this.getModel().setValue(entity, (Object)entry.getDynamicObject(entity), index);
            this.getModel().setValue("status", entry.get("status"), index);
            this.getModel().setValue("description", entry.get("description"), index);
            this.getModel().setValue(FORMULA, entry.get(FORMULA), index);
            String translated = FormulaServiceHelper.analyCvtFullFormula((String)entry.getString(FORMULA), null, (long)this.getModelId());
            this.getModel().setValue(FORMULATEXT, (Object)translated, index);
            ++index;
        }
        this.getPageCache().put(ORIGIN_ENTRYENTITY, SerializationUtils.serializeToBase64((Object)rateformula));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        Object result = closedCallBackEvent.getReturnData();
        if (null == result) {
            return;
        }
        switch (key = closedCallBackEvent.getActionId()) {
            case "RateFormula": {
                Pair myformula = (Pair)this.deSerializedBytes(String.valueOf(result));
                int entryIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
                this.getModel().setValue(FORMULA, myformula.p1, entryIndex);
                this.getModel().setValue(FORMULATEXT, myformula.p2, entryIndex);
                break;
            }
            case "entity": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)result;
                if (rows.isEmpty()) {
                    return;
                }
                this.getModel().setItemValueByID(entity, rows.get(0).getPrimaryKeyValue(), this.getModel().getEntryCurrentRowIndex(ENTRYENTITY));
                break;
            }
            case "account": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)result;
                if (rows.isEmpty()) {
                    return;
                }
                int i = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
                this.getModel().setValue(account, rows.get(0).getPrimaryKeyValue(), i);
                if (rows.size() <= 1) break;
                int[] rowindex = this.getModel().appendEntryRow(ENTRYENTITY, i, rows.size() - 1);
                int k = 1;
                for (int j : rowindex) {
                    this.getModel().setValue(account, rows.get(k).getPrimaryKeyValue(), j);
                    ++k;
                }
                break;
            }
        }
    }

    private QFilter getPermFilter(QFilter qFilter, String entity) {
        Long modelId = this.getModelId();
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId));
        if (!adminUserBol) {
            ArrayListMultimap tmplPermMap = PermClassEntityHelper.getPermissionMapBatch((String)entity, (String)String.valueOf(modelId), (String)RequestContext.get().getUserId());
            HashSet ids = new HashSet(16);
            ids.addAll(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()));
            ids.addAll(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue()));
            qFilter.and("id", "not in", ids);
        }
        return qFilter;
    }
}

