/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.exchangeRate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.compress.utils.Sets;

public class ExchangeRateImportFieldMappingPlugin
extends AbstractBaseFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String BTN_ADD = "add";
    private static final String BTN_DELETE = "delete";
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_OK = "btnok";
    private static final String TOOL_BAR = "advcontoolbarap";
    private static final String BOS_BD_EXRATE = "bd_exrate_tree";
    private static final Set<String> BOS_BD_EXRATE_EXCLUDE = Sets.newHashSet((Object[])new String[]{"masterid", "precision"});

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOL_BAR);
        this.addClickListeners(BTN_OK, BTN_CANCEL);
        BasedataEdit source = (BasedataEdit)this.getControl("target");
        source.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (modelId > 0L) {
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
            this.loadSettingData(modelId);
        }
    }

    private void loadSettingData(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection settingList = QueryServiceHelper.query((String)"bcm_ratefieldsetting", (String)"sourcefield,rateaccount.id", (QFilter[])filter.toArray(), (String)"dseq");
        if (settingList.size() > 0) {
            for (DynamicObject record : settingList) {
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("source", (Object)record.getString("sourcefield"), index);
                this.getModel().setValue("target", (Object)record.getLong("rateaccount.id"), index);
            }
        } else {
            this.getModel().deleteEntryData(ENTRYENTITY);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSourceComboItem();
    }

    private void initSourceComboItem() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("source");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        LinkedHashMap<String, LocaleString> sourceFieldInfoMap = this.getSourceFieldInfoMap();
        for (Map.Entry<String, LocaleString> entry : sourceFieldInfoMap.entrySet()) {
            data.add(new ComboItem(entry.getValue(), entry.getKey()));
        }
        comboEdit.setComboItems(data);
    }

    private LinkedHashMap<String, LocaleString> getSourceFieldInfoMap() {
        LinkedHashMap<String, LocaleString> sourceFieldMap = new LinkedHashMap<String, LocaleString>(16);
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)BOS_BD_EXRATE).getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof DecimalProp) || property instanceof BigIntProp || BOS_BD_EXRATE_EXCLUDE.contains(property.getName())) continue;
            sourceFieldMap.put(property.getName(), property.getDisplayName());
        }
        return sourceFieldMap;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("target".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("model.id", "=", (Object)this.getModelId());
            qFilter.and("longnumber", "like", (Object)"Account!ExchangeRate!%");
            showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{qFilter}), "dseq asc"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectAccount"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("selectAccount".equals(actionId) && (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            this.getModel().setValue("target", returnData.get(0).getPrimaryKeyValue(), this.getCurrentRowIndex());
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "add": {
                this.addEntry();
                break;
            }
            case "delete": {
                this.deleteEntry();
            }
        }
    }

    private int getCurrentRowIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        int currentRow = 0;
        if (selectRows.length > 0) {
            currentRow = selectRows[0];
        }
        return currentRow;
    }

    private void addEntry() {
        this.getModel().createNewEntryRow(ENTRYENTITY);
    }

    private void deleteEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u518d\u64cd\u4f5c\u3002", (String)"ExchangeRateImportFieldMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.saveSetting();
        }
    }

    private void saveSetting() {
        if (this.checkForSave()) {
            long modelId = this.getModelId();
            DynamicObjectCollection currentData = this.getModel().getEntryEntity(ENTRYENTITY);
            DynamicObjectCollection allList = new DynamicObjectCollection();
            if (currentData.size() > 0) {
                int seq = 0;
                for (DynamicObject data : currentData) {
                    DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_ratefieldsetting");
                    newData.set("model", (Object)modelId);
                    newData.set("sourcefield", (Object)data.getString("source"));
                    newData.set("rateaccount", (Object)data.getLong("target.id"));
                    newData.set("dseq", (Object)seq++);
                    newData.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
                    newData.set("createtime", (Object)TimeServiceHelper.now());
                    allList.add((Object)newData);
                }
            }
            TXHandle tx = TX.required();
            Object object = null;
            try {
                try {
                    QFilter filter = new QFilter("model", "=", (Object)modelId);
                    DeleteServiceHelper.delete((String)"bcm_ratefieldsetting", (QFilter[])filter.toArray());
                    SaveServiceHelper.save((DynamicObject[])((DynamicObject[])allList.toArray((Object[])new DynamicObject[0])));
                }
                catch (Exception e) {
                    tx.markRollback();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            this.getView().close();
        }
    }

    private boolean checkForSave() {
        DynamicObject currentRow;
        int i;
        boolean isOk = true;
        DynamicObjectCollection currentData = this.getModel().getEntryEntity(ENTRYENTITY);
        int count = currentData.size();
        ArrayList<String> emptyRowIndex = new ArrayList<String>(10);
        for (i = 0; i < count; ++i) {
            currentRow = (DynamicObject)currentData.get(i);
            String source = currentRow.getString("source");
            String target = currentRow.getString("target.number");
            if (null != source && null != target) continue;
            emptyRowIndex.add(String.valueOf(i + 1));
        }
        if (!emptyRowIndex.isEmpty()) {
            isOk = false;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u6570\u636e\u6e90\u503c\u5b57\u6bb5\u548c\u6c47\u7387\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u586b\u5199\u5b8c\u6574\u3002", (String)"ExchangeRateImportFieldMappingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", emptyRowIndex)));
        }
        if (isOk && count > 1) {
            for (i = 1; i < count; ++i) {
                currentRow = (DynamicObject)currentData.get(i);
                String targetNumber = currentRow.getString("target.number");
                for (int j = 0; j < i; ++j) {
                    DynamicObject lastRow = (DynamicObject)currentData.get(j);
                    String lastTargetNumber = lastRow.getString("target.number");
                    if (!targetNumber.equals(lastTargetNumber)) continue;
                    isOk = false;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c\u548c\u7b2c %2$s \u884c\u8bb0\u5f55\u6620\u5c04\u540c\u4e00\u4e2a\u6c47\u7387\u79d1\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6c47\u7387\u79d1\u76ee\u3002", (String)"ExchangeRateImportFieldMappingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1, j + 1));
                }
            }
        }
        return isOk;
    }
}

