/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.exchangeRate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.ModelServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.DataMutextHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;

public class ExchangeRateMaintainImportPlugin
extends AbsCommonImport {
    private static final Log log = LogFactory.getLog(ExchangeRateMaintainImportPlugin.class);
    private final Set<String> repeatKeys = Sets.newHashSetWithExpectedSize((int)16);
    private final String[] rateColumns4Olap = new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate", "periodend", "average", "userdefine"};
    private Map<String, DynamicObject> recordMap;
    private Map<String, DynamicObject> modelMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> fyMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> sceneMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> periodMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> entityMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> sourceMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> targetMap = new HashMap<String, DynamicObject>(16);
    private Map<String, Boolean> periodOpenMap = new HashMap<String, Boolean>(16);
    private Map<String, Boolean> loeckedMap = new HashMap<String, Boolean>(16);
    private HashSet<String> loeckedKey = new HashSet(16);
    private final CloneUtils cloneUtils = new CloneUtils(true, true);
    private static final String MUTUAL_RATE_ID = "mutualRateId";

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.entityName = "bcm_exchagerate";
        return this;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        super.beforeSave(billDatas, logger);
        this.initData(billDatas);
    }

    private void initData(List<ImportBillData> billDatas) {
        this.modelMap = this.getDynamicObjFromDb(billDatas, "model.shownumber", "bcm_model");
        this.sceneMap = this.getDynamicObjFromDb(billDatas, "scene.number", "bcm_scenemembertree");
        this.periodMap = this.getDynamicObjFromDb(billDatas, "period.number", "bcm_periodmembertree");
        this.entityMap = this.getDynamicObjFromDb(billDatas, "entity.number", "bcm_entitymembertree");
        this.sourceMap = this.getDynamicObjFromDb(billDatas, "source.number", "bcm_processmembertree");
        this.targetMap = this.getDynamicObjFromDb(billDatas, "target.number", "bcm_currencymembertree");
        this.fyMap = this.getDynamicObjFromDb(billDatas, "fy.number", "bcm_fymembertree");
        this.recordMap = this.getDataFromDb();
        this.initPeriodOpenMap(billDatas);
    }

    private void initPeriodOpenMap(List<ImportBillData> billDatas) {
        HashMultimap group = HashMultimap.create();
        HashSet lockTag = new HashSet(16);
        billDatas.stream().forEach(t -> {
            ArrayList<String> tag = new ArrayList<String>();
            DynamicObject model = this.modelMap.get(ImportHelper.getImportBillProp(t, "model.shownumber").toString());
            DynamicObject scene = this.sceneMap.get(ImportHelper.getImportBillProp(t, "scene.number").toString());
            DynamicObject fy = this.fyMap.get(ImportHelper.getImportBillProp(t, "fy.number").toString());
            DynamicObject period = this.periodMap.get(ImportHelper.getImportBillProp(t, "period.number").toString());
            String entityNum = ImportHelper.getImportBillProp(t, "entity.number").toString();
            DynamicObject entity = this.entityMap.get(entityNum);
            if (model != null && scene != null && fy != null && period != null && entity != null) {
                tag.add(model.getString("id"));
                tag.add(scene.getString("id"));
                tag.add(fy.getString("id"));
                tag.add(period.getString("id"));
                group.put((Object)String.join((CharSequence)";", tag), (Object)entityNum);
                tag.add(entity.getString("id"));
                lockTag.add(String.join((CharSequence)";", tag));
            }
        });
        group.asMap().forEach((k, v) -> {
            String[] keys = k.split(";");
            Set entityIds = v.stream().filter(s -> this.entityMap.get(s) != null).map(s -> this.entityMap.get(s).getLong("id")).collect(Collectors.toSet());
            Set validEntityIds = ExchangeRateShareSceneHelper.checkRatePeriodSceneOpen((Long)LongUtil.toLong((Object)keys[0]), entityIds, (Long)LongUtil.toLong((Object)keys[1]), (Long)LongUtil.toLong((Object)keys[2]), (Long)LongUtil.toLong((Object)keys[3]));
            validEntityIds.forEach(s -> {
                String tag = k + ";" + s;
                this.periodOpenMap.put(tag, Boolean.TRUE);
            });
        });
        lockTag.forEach(s -> {
            String[] keys = s.split(";");
            Long modelId = LongUtil.toLong((Object)keys[0]);
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((Long)modelId, (Long)LongUtil.toLong((Object)keys[1]));
            IDNumberTreeNode fyNode = MemberReader.findFyMemberById((Long)modelId, (Long)LongUtil.toLong((Object)keys[2]));
            IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)LongUtil.toLong((Object)keys[3]));
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)modelId, (Long)LongUtil.toLong((Object)keys[4]));
            Boolean flag = this.requireLock(modelNum, sceneNode, fyNode, periodNode, entityNode);
            this.loeckedMap.put((String)s, flag);
        });
    }

    private Boolean requireLock(String modelNum, IDNumberTreeNode sceneNode, IDNumberTreeNode fyNode, IDNumberTreeNode periodNode, IDNumberTreeNode entityNode) {
        if (sceneNode == IDNumberTreeNode.NotFoundTreeNode || fyNode == IDNumberTreeNode.NotFoundTreeNode || periodNode == IDNumberTreeNode.NotFoundTreeNode || entityNode == IDNumberTreeNode.NotFoundTreeNode) {
            return Boolean.FALSE;
        }
        Long sceneId = sceneNode.getId();
        if (ExchangeRateShareSceneHelper.isInRateShare((String)entityNode.getId().toString(), (String)sceneNode.getId().toString()).booleanValue()) {
            sceneId = 0L;
        }
        String datakey = modelNum + sceneId + fyNode.getNumber() + periodNode.getNumber() + entityNode.getNumber();
        boolean lockSucess = DataMutextHelper.request((String)datakey, (String)"bcm_exchangerate_maintain", (String)"updateRate", (Boolean)Boolean.FALSE);
        return lockSucess;
    }

    private void releaseLock(HashSet<String> keys) {
        for (String key : keys) {
            Map lockInfo = DataMutextHelper.getLockInfo((String)key, (String)"bcm_exchangerate_maintain", (String)"updateRate");
            if (lockInfo == null || !((String)lockInfo.get("userid")).equals(RequestContext.getOrCreate().getUserId())) continue;
            DataMutextHelper.release((String)key, (String)"bcm_exchangerate_maintain", (String)"updateRate");
        }
    }

    @Override
    protected void afterImport() {
        super.afterImport();
        this.releaseLock(this.loeckedKey);
    }

    private Boolean getInPerm(Long modelId, Long entityId) {
        return (Boolean)ThreadCache.get((Object)(modelId + entityId), () -> {
            boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId));
            if (!adminUserBol) {
                ArrayListMultimap tmplPermMap = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_entitymembertree", (String)String.valueOf(modelId), (String)RequestContext.get().getUserId());
                HashMap allTmplPermMap = new HashMap();
                for (String key : tmplPermMap.keySet()) {
                    List ids = tmplPermMap.get((Object)key);
                    ids.forEach(id -> allTmplPermMap.put(id.toString(), key));
                }
                if (tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue()).contains(entityId)) {
                    return Boolean.FALSE;
                }
                if (tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()).contains(entityId)) {
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        });
    }

    private Map<String, DynamicObject> getDataFromDb() {
        QFilter filter = new QFilter("model.shownumber", "in", this.modelMap.keySet());
        Object[] mcs = BusinessDataServiceHelper.load((String)"bcm_exchagerate", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet()), (QFilter[])new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])mcs)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(mcs).collect(Collectors.toMap(this::getRepeatKey, Function.identity(), (v1, v2) -> v1));
    }

    private Map<String, DynamicObject> getDynamicObjFromDb(List<ImportBillData> importBillData, String field, String entity) {
        Set numbers = importBillData.stream().map(t -> ImportHelper.getImportBillProp(t, field).toString()).collect(Collectors.toSet());
        String[] c = field.split("\\.");
        String entityNumber = c[0];
        String fieldNumber = c[1];
        QFilter qf = new QFilter(fieldNumber, "in", numbers);
        if (Objects.equals("model", entityNumber)) {
            qf = new QFilter("shownumber", "in", numbers);
        } else {
            qf.and("model.shownumber", "in", this.modelMap.keySet());
        }
        Map map = BusinessDataServiceHelper.loadFromCache((String)entity, (String)("id,name,number," + fieldNumber), (QFilter[])new QFilter[]{qf});
        if (CollectionUtils.isEmpty((Map)map)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        return map.values().stream().distinct().collect(Collectors.toMap(t -> t.getString(fieldNumber), Function.identity(), (v1, v2) -> v1));
    }

    @Override
    protected void updateWithExistId(List<ImportBillData> rowdatas, boolean addNew) {
        ArrayList newDataList = Lists.newArrayListWithCapacity((int)16);
        for (ImportBillData rowData : rowdatas) {
            DynamicObject mutualDy;
            Optional<DynamicObject> dbOld = this.getDbOld(rowData);
            if (dbOld.isPresent()) {
                rowData.getData().put("id", dbOld.get().get("id"));
                rowData.getData().put("existingRecordDy", (Object)dbOld.get());
                continue;
            }
            if (((Boolean)ImportHelper.getImportBillProp(rowData, "mutual")).booleanValue() && (mutualDy = this.recordMap.get(this.getMutualRepeatKey(rowData))) != null) {
                rowData.getData().put("id", (Object)DBServiceHelper.genGlobalLongId());
                rowData.getData().put(MUTUAL_RATE_ID, mutualDy.get("id"));
                continue;
            }
            if (!addNew) continue;
            newDataList.add(rowData);
        }
        if (!CollectionUtils.isEmpty((Collection)newDataList)) {
            this.updateWithNewId(newDataList);
        }
    }

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        ArrayList tag;
        Boolean isPeriodOpen;
        String modelShowNumber = ImportHelper.getImportBillProp(bill, "model.shownumber").toString();
        String modelNumber = MemberReader.findModelNumberByShowNum((String)modelShowNumber);
        Long modelId = MemberReader.findModelIdByNum((String)modelNumber);
        if (StringUtils.isEmpty((String)modelNumber)) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u3002", (String)"ExchangeRateMaintainImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        String sceneNumber = ImportHelper.getImportBillProp(bill, "scene.number").toString();
        if (sceneNumber == null || sceneNumber.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExchangeRateMaintainImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)modelNumber, (String)sceneNumber);
        if (scene == IDNumberTreeNode.NotFoundTreeNode) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u60c5\u666f\u7f16\u7801\u3002", (String)"ExchangeRateMaintainImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        String fyNumber = ImportHelper.getImportBillProp(bill, "fy.number").toString();
        if (fyNumber == null || fyNumber.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExchangeRateMaintainImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        IDNumberTreeNode fy = MemberReader.findFyMemberByNum((String)modelNumber, (String)fyNumber);
        if (fy == IDNumberTreeNode.NotFoundTreeNode) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u8d22\u5e74\u7f16\u7801\u3002", (String)"ExchangeRateMaintainImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        Long fyId = fy.getId();
        String periodNumber = ImportHelper.getImportBillProp(bill, "period.number").toString();
        if (periodNumber == null || periodNumber.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExchangeRateMaintainImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)periodNumber);
        if (period == IDNumberTreeNode.NotFoundTreeNode) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u671f\u95f4\u7f16\u7801\u3002", (String)"ExchangeRateMaintainImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        Long periodId = period.getId();
        String entityNumber = ImportHelper.getImportBillProp(bill, "entity.number").toString();
        if (entityNumber == null || entityNumber.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExchangeRateMaintainImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        IDNumberTreeNode entity = MemberReader.findEntityMemberByNum((String)modelNumber, (String)entityNumber);
        if (entity == IDNumberTreeNode.NotFoundTreeNode || entity == null) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u7ec4\u7ec7\u65b9\u6848\u7f16\u7801\u3002", (String)"ExchangeRateMaintainImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        Long entityId = entity.getId();
        if (!this.getInPerm(modelId, entityId).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u64cd\u4f5c\u8be5\u6c47\u7387\u65b9\u6848\u3002", (String)"ExchangeRateMaintainImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        Long sceneId = scene.getId();
        if (ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012") && ((isPeriodOpen = this.periodOpenMap.get(String.join((CharSequence)";", tag = Lists.newArrayList((Object[])new String[]{modelId.toString(), sceneId.toString(), fyId.toString(), periodId.toString(), entityId.toString()})))) == null || isPeriodOpen != Boolean.TRUE)) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u4e0d\u80fd\u5bfc\u5165\uff0c\u5982\u679c\u662f\u5171\u4eab\u60c5\u666f\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u6240\u6709\u60c5\u666f\u671f\u95f4\u662f\u5426\u90fd\u5f00\u542f\u3002", (String)"ExchangeRateMaintainImportPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        tag = Lists.newArrayList((Object[])new String[]{modelId.toString(), sceneId.toString(), fyId.toString(), periodId.toString(), entityId.toString()});
        Boolean isLocekd = this.loeckedMap.get(String.join((CharSequence)";", tag));
        if (isLocekd == null || isLocekd != Boolean.TRUE) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\u65e0\u6cd5\u6267\u884c\u5bfc\u5165\u64cd\u4f5c\u3002", (String)"ExchangeRateMaintainImportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        if (!ExchangeRateShareSceneHelper.hasWritePermInAllScene((Long)modelId, (Long)entityId, (Long)sceneId, (Long)periodId).booleanValue()) {
            String msg = String.format(ResManager.loadKDString((String)"\u65e0\u60c5\u666f\u6210\u5458%s\u5199\u5165\u6743\u9650\uff0c\u5982\u679c\u662f\u5171\u4eab\u60c5\u666f\u9700\u8981\u6240\u5173\u8054\u60c5\u666f\u90fd\u6709\u5199\u5165\u6743\u9650\u3002", (String)"ExchangeRateMaintainImportPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]), scene.getNumber());
            return Optional.of(msg);
        }
        if (ExchangeRateShareSceneHelper.isInRateShare((String)entityId.toString(), (String)sceneId.toString()).booleanValue()) {
            sceneId = 0L;
        } else if (ExchangeRateShareSceneHelper.isOpenRateShare((String)entityId.toString()).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u60c5\u666f\u4e0d\u5728\u6b64\u5171\u4eab\u60c5\u666f\u4e2d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ExchangeRateMaintainImportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        String sourceNumber = ImportHelper.getImportBillProp(bill, "source.number").toString();
        if (sourceNumber == null || sourceNumber.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u539f\u5e01\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExchangeRateMaintainImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        IDNumberTreeNode source = MemberReader.findProcessMemberByNum((String)modelNumber, (String)sourceNumber);
        if (source == IDNumberTreeNode.NotFoundTreeNode) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u539f\u5e01\u7f16\u7801\u3002", (String)"ExchangeRateMaintainImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        Long sourceId = source.getId();
        String targetNumber = ImportHelper.getImportBillProp(bill, "target.number").toString();
        if (targetNumber == null || targetNumber.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u76ee\u6807\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExchangeRateMaintainImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        IDNumberTreeNode target = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)targetNumber);
        if (target == IDNumberTreeNode.NotFoundTreeNode) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u76ee\u6807\u5e01\u7f16\u7801\u3002", (String)"ExchangeRateMaintainImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        Long targetId = target.getId();
        DynamicObject rate = QueryServiceHelper.queryOne((String)"bcm_exchagerate", (String)"id,fromid,triangle", (QFilter[])this.getUniqueFilters(modelId, sceneId, fyId, periodId, entityId, sourceId, targetId));
        if (rate != null && StringUtils.isNotEmpty((String)rate.getString("triangle"))) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u6c47\u7387\u4e3a\u4e09\u89d2\u6c47\u7387\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"ExchangeRateMaintainImportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        if (rate != null && rate.getLong("fromid") != 0L) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u6c47\u7387\u4e3a\u4e92\u7b97\u5f97\u5230\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ExchangeRateMaintainImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        if (Objects.equals((Object)importType, (Object)ImportOperateType.NEW)) {
            Optional<DynamicObject> dbOld = this.getDbOld(bill);
            if (dbOld.isPresent()) {
                return Optional.of(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"ExchangeRateMaintainImportPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (((Boolean)ImportHelper.getImportBillProp(bill, "mutual")).booleanValue() && this.recordMap.containsKey(this.getMutualRepeatKey(bill))) {
                return Optional.of(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7684\u4e92\u7b97\u6c47\u7387\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"ExchangeRateMaintainImportPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (!StringUtil.isEmpty((CharSequence)((String)ImportHelper.getImportBillProp(bill, "triangle")))) {
            return Optional.of(ResManager.loadKDString((String)"\u65e0\u6cd5\u5bfc\u5165\u4e09\u89d2\u6c47\u7387\u3002", (String)"ExchangeRateMaintainImportPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String repeatKey = this.getRepeatKey(bill);
        if (!this.repeatKeys.add(repeatKey)) {
            return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5728\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"DataAuthMainImport_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        DynamicObject dynamicObject = this.recordMap.get(this.getRepeatKey(rowData));
        return Optional.ofNullable(dynamicObject);
    }

    protected Map<Object, String> batchInsert(DynamicObject[] dys, Map<Object, String> errorMap) {
        if (Objects.isNull(dys) || dys.length == 0) {
            return errorMap;
        }
        try (TXHandle tx = TX.requiresNew((String)"insertBatch");){
            try {
                Map<String, List<DynamicObject>> result = Arrays.stream(dys).filter(s -> s.getLong("fromid") == 0L).collect(Collectors.groupingBy(s -> s.getString("model.id") + "." + s.getString("model.number") + "|" + s.getString("scene.id") + "." + s.getString("scene.number") + "|" + s.getString("fy.id") + "." + s.getString("fy.number") + "|" + s.getString("period.id") + "." + s.getString("period.number") + "|" + s.getString("entity.id") + "." + s.getString("entity.number")));
                this.handleScene(dys);
                SaveServiceHelper.save((DynamicObject[])dys);
                result.forEach((key, value) -> {
                    Pair<Boolean, FixedItem> item = this.getFixItem((String)key);
                    ExchangeRateShareSceneHelper.calcTriangleRate((FixedItem)((FixedItem)item.p2));
                    this.saveOlap((FixedItem)item.p2);
                    this.writeImportLog(value.toArray(new DynamicObject[0]), OpItemEnum.IMPORT.getName() + OpItemEnum.ADD.getName());
                    ExchangeQueryHelper.clearRateCache((BaseData)new BaseData((FixedItem)item.p2));
                });
            }
            catch (Exception e) {
                log.error("insert_import_submit rollback, error:" + e.getMessage(), (Throwable)e);
                tx.markRollback();
                Map<Object, String> map = this.buildErrorMap(dys, e, errorMap);
                if (tx != null) {
                    if (var4_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return map;
            }
        }
        return errorMap;
    }

    private void writeImportLog(DynamicObject[] dys, String opName) {
        Map userdefinedRateNum2Names = ExchageRateServiceHelper.getUserdefinedrateNum2NameIgnoreCase((long)dys[0].getLong("model.id"));
        for (DynamicObject dy : dys) {
            StringBuilder sb = new StringBuilder();
            String sourceName = dy.getString("source.name");
            String targetName = dy.getString("target.name");
            sb.append(ResManager.loadKDString((String)"\u5bfc\u5165\uff1a", (String)"ExchangeRateMaintainImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801", (String)"ExchangeRateMaintainImportPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(" ").append(dy.getString("entity.number")).append("\uff0c").append(ResManager.loadKDString((String)"\u60c5\u666f", (String)"ExchangeRateMaintainImportPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(" ").append(dy.getString("scene.number")).append("\uff0c").append(ResManager.loadKDString((String)"\u8d22\u5e74", (String)"ExchangeRateMaintainImportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(" ").append(dy.getString("fy.number")).append("\uff0c").append(ResManager.loadKDString((String)"\u671f\u95f4", (String)"ExchangeRateMaintainImportPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(" ").append(dy.getString("period.number")).append("\uff0c").append(ResManager.loadKDString((String)"\u539f\u5e01", (String)"ExchangeRateMaintainImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(" ").append(sourceName).append(" -> ").append(ResManager.loadKDString((String)"\u76ee\u6807\u5e01", (String)"ExchangeRateMaintainImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(" ").append(targetName).append('\uff0c');
            String periodend = dy.getString("periodend");
            sb.append(ResManager.loadKDString((String)"\u671f\u672b\u6c47\u7387", (String)"ExchangeRateMaintainImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(" ").append(periodend).append("\uff0c");
            String average = dy.getString("average");
            sb.append(ResManager.loadKDString((String)"\u5e73\u5747\u6c47\u7387", (String)"ExchangeRateMaintainImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(" ").append(average).append("\uff0c");
            String userdefine = dy.getString("userdefine");
            sb.append(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6c47\u7387", (String)"ExchangeRateMaintainImportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(" ").append(userdefine).append("\uff0c");
            userdefinedRateNum2Names.forEach((number, name) -> {
                BigDecimal val = dy.getBigDecimal(number);
                sb.append((String)name).append(" ").append(val == null ? "" : val.stripTrailingZeros().toPlainString()).append("\uff0c");
            });
            String precision = dy.getString("precision");
            sb.append(String.format(ResManager.loadKDString((String)"\u7cbe\u5ea6 %s\uff0c\u6210\u529f", (String)"ExchangeRateMaintainImportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), precision));
            OperationLogUtil.writeOperationLog((String)opName, (String)sb.toString(), (Long)dy.getLong("model.id"), (String)"bcm_exchangerate_maintain");
        }
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        return this.buildDynamicObject(billDataList, false);
    }

    protected DynamicObject[] buildDynamicObject(List<ImportBillData> billDataList, boolean isUpdate) {
        ArrayList<DynamicObject> alldys = new ArrayList<DynamicObject>(billDataList.size());
        HashSet<String> mutualkeys = new HashSet<String>(billDataList.size());
        for (ImportBillData billData : billDataList) {
            if (mutualkeys.contains(this.getRepeatKey(billData))) continue;
            DynamicObject dyn = this.getDynamicObject(billData, isUpdate);
            mutualkeys.add(this.getRepeatKey(billData));
            alldys.add(dyn);
            if (!dyn.getBoolean("mutual")) continue;
            DynamicObject mutualDyn = this.getMutualDynamicObject(dyn);
            if (billData.getData().containsKey((Object)MUTUAL_RATE_ID)) {
                mutualDyn.set("id", billData.getData().get((Object)MUTUAL_RATE_ID));
            }
            if (mutualkeys.contains(this.getRepeatKey(mutualDyn))) continue;
            mutualkeys.add(this.getRepeatKey(mutualDyn));
            alldys.add(mutualDyn);
        }
        return alldys.toArray(new DynamicObject[0]);
    }

    private DynamicObject getMutualDynamicObject(DynamicObject dyn) {
        DynamicObject mutualDyn = (DynamicObject)this.cloneUtils.clone((IDataEntityBase)dyn);
        String modelNumber = MemberReader.findModelNumberById((Object)dyn.getLong("model.id"));
        IDNumberTreeNode mutualSourceProcess = MemberReader.findProcessMemberByNum((String)modelNumber, (String)dyn.getString("target.number"));
        IDNumberTreeNode mutualTargetProcess = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)dyn.getString("source.number"));
        DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)mutualSourceProcess.getId(), (String)"bcm_processmembertree");
        DynamicObject target = BusinessDataServiceHelper.loadSingle((Object)mutualTargetProcess.getId(), (String)"bcm_currencymembertree");
        mutualDyn.set("source", (Object)source);
        mutualDyn.set("target", (Object)target);
        int precision = dyn.getInt("precision");
        mutualDyn.set("precision", (Object)precision);
        mutualDyn.set("beginyear", (Object)this.getReciprocal(dyn.getBigDecimal("beginyear"), precision));
        mutualDyn.set("boyaveragerate", (Object)this.getReciprocal(dyn.getBigDecimal("boyaveragerate"), precision));
        mutualDyn.set("boyuserdefinedrate", (Object)this.getReciprocal(dyn.getBigDecimal("boyuserdefinedrate"), precision));
        mutualDyn.set("periodend", (Object)this.getReciprocal(dyn.getBigDecimal("periodend"), precision));
        mutualDyn.set("average", (Object)this.getReciprocal(dyn.getBigDecimal("average"), precision));
        mutualDyn.set("userdefine", (Object)this.getReciprocal(dyn.getBigDecimal("userdefine"), precision));
        Set userdefinedRates = ExchageRateServiceHelper.getUserdefinedrateAccountIgnoreCase((long)dyn.getLong("model.id"));
        if (!userdefinedRates.isEmpty()) {
            for (String userdefinedRate : userdefinedRates) {
                BigDecimal val = dyn.getBigDecimal(userdefinedRate);
                if (val == null) continue;
                mutualDyn.set(userdefinedRate, (Object)this.getReciprocal(val, precision));
            }
        }
        mutualDyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
        mutualDyn.set("modifytime", (Object)TimeServiceHelper.now());
        mutualDyn.set("eseq", (Object)this.getNextSeq(dyn.getLong("model.id"), dyn.getLong("scene.id"), dyn.getLong("fy.id"), dyn.getLong("period.id"), dyn.getLong("entity.id")));
        mutualDyn.set("mutual", (Object)true);
        mutualDyn.set("fromid", (Object)dyn.getLong("id"));
        return mutualDyn;
    }

    private BigDecimal getReciprocal(BigDecimal rate, int precision) {
        return rate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(precision, RoundingMode.HALF_UP) : BigDecimal.ONE.divide(rate, precision, RoundingMode.HALF_UP);
    }

    private DynamicObject getDynamicObject(ImportBillData billData, boolean isUpdate) {
        Set userdefinedRates;
        boolean isUpdateRate;
        JSONObject data = billData.getData();
        DynamicObject dyn = null;
        DynamicObject scene = this.sceneMap.get(ImportHelper.getImportBillProp(billData, "scene.number").toString());
        if (isUpdate && billData.getData().containsKey((Object)"id")) {
            dyn = (DynamicObject)this.cloneUtils.clone((IDataEntityBase)((DynamicObject)billData.getData().get((Object)"existingRecordDy")));
            String modelShowNumber = dyn.getString("model.shownumber");
            DynamicObject model = this.modelMap.get(modelShowNumber);
            dyn.set("model", (Object)model);
        } else {
            DynamicObject model = this.modelMap.get(ImportHelper.getImportBillProp(billData, "model.shownumber").toString());
            DynamicObject entity = this.entityMap.get(ImportHelper.getImportBillProp(billData, "entity.number").toString());
            DynamicObject fy = this.fyMap.get(ImportHelper.getImportBillProp(billData, "fy.number").toString());
            DynamicObject period = this.periodMap.get(ImportHelper.getImportBillProp(billData, "period.number").toString());
            DynamicObject source = this.sourceMap.get(ImportHelper.getImportBillProp(billData, "source.number").toString());
            DynamicObject target = this.targetMap.get(ImportHelper.getImportBillProp(billData, "target.number").toString());
            dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exchagerate");
            dyn.set("model", (Object)model);
            dyn.set("entity", (Object)entity);
            dyn.set("scene", (Object)scene);
            dyn.set("fy", (Object)fy);
            dyn.set("period", (Object)period);
            dyn.set("source", (Object)source);
            dyn.set("target", (Object)target);
        }
        dyn.set("precision", data.get((Object)"precision"));
        int precision = dyn.getInt("precision");
        if (precision < 0 || precision > 15) {
            precision = 15;
            dyn.set("precision", (Object)precision);
        }
        if (isUpdateRate = ConfigServiceHelper.getBoolParam((Long)dyn.getLong("model.id"), (String)"CM009")) {
            dyn.set("beginyear", (Object)data.getBigDecimal("beginyear").setScale(precision, RoundingMode.HALF_UP));
            dyn.set("boyaveragerate", (Object)data.getBigDecimal("boyaveragerate").setScale(precision, RoundingMode.HALF_UP));
            dyn.set("boyuserdefinedrate", (Object)data.getBigDecimal("boyuserdefinedrate").setScale(precision, RoundingMode.HALF_UP));
            dyn.set("beginyear", (Object)dyn.getBigDecimal("beginyear").setScale(precision, RoundingMode.HALF_UP));
            dyn.set("boyaveragerate", (Object)dyn.getBigDecimal("boyaveragerate").setScale(precision, RoundingMode.HALF_UP));
            dyn.set("boyuserdefinedrate", (Object)dyn.getBigDecimal("boyuserdefinedrate").setScale(precision, RoundingMode.HALF_UP));
        }
        if (!(userdefinedRates = ExchageRateServiceHelper.getUserdefinedrateAccountIgnoreCase((long)dyn.getLong("model.id"))).isEmpty()) {
            for (String userdefinedRate : userdefinedRates) {
                BigDecimal val;
                if (!isUpdateRate && userdefinedRate.startsWith("boyuserdefinedrate") || (val = data.getBigDecimal(userdefinedRate)) == null) continue;
                dyn.set(userdefinedRate, (Object)val.setScale(precision, RoundingMode.HALF_UP));
            }
        }
        dyn.set("periodend", (Object)data.getBigDecimal("periodend").setScale(precision, RoundingMode.HALF_UP));
        dyn.set("average", (Object)data.getBigDecimal("average").setScale(precision, RoundingMode.HALF_UP));
        dyn.set("userdefine", (Object)data.getBigDecimal("userdefine").setScale(precision, RoundingMode.HALF_UP));
        dyn.set("periodend", (Object)dyn.getBigDecimal("periodend").setScale(precision, RoundingMode.HALF_UP));
        dyn.set("average", (Object)dyn.getBigDecimal("average").setScale(precision, RoundingMode.HALF_UP));
        dyn.set("userdefine", (Object)dyn.getBigDecimal("userdefine").setScale(precision, RoundingMode.HALF_UP));
        dyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dyn.set("modifytime", (Object)TimeServiceHelper.now());
        dyn.set("eseq", (Object)this.getNextSeq(dyn.getLong("model.id"), dyn.getLong("scene.id"), dyn.getLong("fy.id"), dyn.getLong("period.id"), dyn.getLong("entity.id")));
        dyn.set("mutual", data.get((Object)"mutual"));
        dyn.set("id", data.get((Object)"id"));
        dyn.set("scene", (Object)scene);
        return dyn;
    }

    private void handleScene(DynamicObject[] dys) {
        Map<String, List<DynamicObject>> result = Arrays.stream(dys).collect(Collectors.groupingBy(s -> s.getString("entity.id") + s.getString("scene.id")));
        result.forEach((k, v) -> {
            String sceneId;
            String entityId = ((DynamicObject)v.get(0)).getString("entity.id");
            if (ExchangeRateShareSceneHelper.isInRateShare((String)entityId, (String)(sceneId = ((DynamicObject)v.get(0)).getString("scene.id"))).booleanValue()) {
                v.stream().forEach(s -> s.set("scene", null));
            }
        });
    }

    @Override
    protected Map<Object, String> saveNew(List<ImportBillData> billDataList) {
        DynamicObject[] dys = this.buildInsertDynamicObject(billDataList);
        return this.batchInsert(dys, (Map<Object, String>)Maps.newHashMapWithExpectedSize((int)16));
    }

    @Override
    protected Map<Object, String> saveOverride(List<ImportBillData> billDataList) {
        ArrayList needUpdate = Lists.newArrayListWithCapacity((int)16);
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)16);
        for (ImportBillData billData : billDataList) {
            if (Objects.nonNull(billData.getData().get((Object)"existingRecordDy"))) {
                needUpdate.add(billData);
                continue;
            }
            errorMap.put(billData.getData().getLong("id"), ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u8bb0\u5f55\u4e0d\u66f4\u65b0\u3002", (String)"AbsCommonImport_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Map<Object, String> result = this.batchUpdate(needUpdate, errorMap);
        return result;
    }

    @Override
    protected void batchInsertDBOpt(List<ImportBillData> billDataList) {
        DynamicObject[] dys = this.buildInsertDynamicObject(billDataList);
        Map<String, List<DynamicObject>> result = Arrays.stream(dys).filter(s -> s.getLong("fromid") == 0L).collect(Collectors.groupingBy(s -> s.getString("model.id") + "." + s.getString("model.number") + "|" + s.getString("scene.id") + "." + s.getString("scene.number") + "|" + s.getString("fy.id") + "." + s.getString("fy.number") + "|" + s.getString("period.id") + "." + s.getString("period.number") + "|" + s.getString("entity.id") + "." + s.getString("entity.number")));
        this.handleScene(dys);
        SaveServiceHelper.save((DynamicObject[])dys);
        result.forEach((key, value) -> {
            Pair<Boolean, FixedItem> item = this.getFixItem((String)key);
            ExchangeRateShareSceneHelper.calcTriangleRate((FixedItem)((FixedItem)item.p2));
            this.saveOlap((FixedItem)item.p2);
            this.writeImportLog(value.toArray(new DynamicObject[0]), OpItemEnum.IMPORT.getName() + OpItemEnum.ADD.getName());
            ExchangeQueryHelper.clearRateCache((BaseData)new BaseData((FixedItem)item.p2));
        });
    }

    protected Pair<Boolean, FixedItem> getFixItem(String key) {
        String[] conditions = key.split("\\|");
        ArrayList<SimpleItem> items = new ArrayList<SimpleItem>(conditions.length);
        for (String one : conditions) {
            String[] data = one.split("\\.");
            SimpleItem item = SimpleItem.newOne((Object)LongUtil.toLong((Object)data[0]), (String)data[1]);
            items.add(item);
        }
        Long entityId = (Long)((SimpleItem)items.get(4)).getId();
        Long realSceneId = (Long)((SimpleItem)items.get(1)).getId();
        Boolean flag = Boolean.FALSE;
        if (ExchangeRateShareSceneHelper.isOpenRateShare((String)entityId.toString()).booleanValue()) {
            realSceneId = 0L;
            flag = Boolean.TRUE;
        }
        FixedItem result = FixedItem.newOne((SimpleItem)((SimpleItem)items.get(0)), (SimpleItem)SimpleItem.newOne((Object)realSceneId, (String)((SimpleItem)items.get(1)).getNumber()), (SimpleItem)((SimpleItem)items.get(2)), (SimpleItem)((SimpleItem)items.get(3)), (SimpleItem)((SimpleItem)items.get(4)));
        return new Pair((Object)flag, (Object)result);
    }

    @Override
    protected void batchUpdateDBOpt(List<ImportBillData> billDataList) {
        DynamicObject[] dys = this.buildUpdateDynamicObject(billDataList);
        List ids = Arrays.stream(dys).map(e -> e.getLong("id")).filter(e -> e != 0L).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)"bcm_exchagerate", (QFilter[])new QFilter("id", "in", ids).or("fromid", "in", ids).toArray());
        Map<String, List<DynamicObject>> result = Arrays.stream(dys).filter(s -> s.getLong("fromid") == 0L).collect(Collectors.groupingBy(s -> s.getString("model.id") + "." + s.getString("model.number") + "|" + s.getLong("scene.id") + "." + s.getString("scene.number") + "|" + s.getString("fy.id") + "." + s.getString("fy.number") + "|" + s.getString("period.id") + "." + s.getString("period.number") + "|" + s.getString("entity.id") + "." + s.getString("entity.number")));
        this.handleScene(dys);
        SaveServiceHelper.save((DynamicObject[])dys);
        result.forEach((key, value) -> {
            Pair<Boolean, FixedItem> item = this.getFixItem((String)key);
            ExchangeRateShareSceneHelper.calcTriangleRate((FixedItem)((FixedItem)item.p2));
            this.saveOlap((FixedItem)item.p2);
            this.writeImportLog(value.toArray(new DynamicObject[0]), OpItemEnum.IMPORT.getName() + OpItemEnum.EDIT.getName());
        });
    }

    @Override
    protected Map<Object, String> saveOverrideNew(List<ImportBillData> billDataList) {
        ArrayList needInsert = Lists.newArrayListWithCapacity((int)16);
        ArrayList needUpdate = Lists.newArrayListWithCapacity((int)16);
        for (ImportBillData billData : billDataList) {
            if (Objects.nonNull(billData.getData().get((Object)"existingRecordDy")) || billData.getData().containsKey((Object)MUTUAL_RATE_ID)) {
                needUpdate.add(billData);
                continue;
            }
            needInsert.add(billData);
        }
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)16);
        this.batchUpdate(needUpdate, errorMap);
        this.batchInsert(needInsert, (Map<Object, String>)errorMap);
        return errorMap;
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        return this.buildDynamicObject(billDataList, true);
    }

    private String getRepeatKey(ImportBillData data) {
        String modelShowNumber = ImportHelper.getImportBillProp(data, "model.shownumber").toString();
        String sceneNumber = ImportHelper.getImportBillProp(data, "scene.number").toString();
        String fyNumber = ImportHelper.getImportBillProp(data, "fy.number").toString();
        String periodNumber = ImportHelper.getImportBillProp(data, "period.number").toString();
        String entityNumber = ImportHelper.getImportBillProp(data, "entity.number").toString();
        String sourceNumber = ImportHelper.getImportBillProp(data, "source.number").toString();
        String targetNumber = ImportHelper.getImportBillProp(data, "target.number").toString();
        String modelNumber = MemberReader.findModelNumberByShowNum((String)modelShowNumber);
        IDNumberTreeNode node = MemberReader.findEntityMemberByNum((String)modelNumber, (String)entityNumber);
        if (ExchangeRateShareSceneHelper.isOpenRateShare((String)node.getId().toString()).booleanValue()) {
            sceneNumber = "";
        }
        return new StringJoiner("|").add(modelShowNumber).add(sceneNumber).add(fyNumber).add(periodNumber).add(entityNumber).add(sourceNumber).add(targetNumber).toString();
    }

    private String getMutualRepeatKey(ImportBillData data) {
        String modelNumber = ImportHelper.getImportBillProp(data, "model.shownumber").toString();
        String sceneNumber = ImportHelper.getImportBillProp(data, "scene.number").toString();
        String fyNumber = ImportHelper.getImportBillProp(data, "fy.number").toString();
        String periodNumber = ImportHelper.getImportBillProp(data, "period.number").toString();
        String entityNumber = ImportHelper.getImportBillProp(data, "entity.number").toString();
        String targetNumber = ImportHelper.getImportBillProp(data, "source.number").toString();
        String sourceNumber = ImportHelper.getImportBillProp(data, "target.number").toString();
        return new StringJoiner("|").add(modelNumber).add(sceneNumber).add(fyNumber).add(periodNumber).add(entityNumber).add(sourceNumber).add(targetNumber).toString();
    }

    private String getRepeatKey(DynamicObject dy) {
        if (ExchangeRateShareSceneHelper.isOpenRateShare((String)dy.getString("entity.id")).booleanValue()) {
            return new StringJoiner("|").add(dy.getString("model.shownumber")).add("").add(dy.getString("fy.number")).add(dy.getString("period.number")).add(dy.getString("entity.number")).add(dy.getString("source.number")).add(dy.getString("target.number")).toString();
        }
        return new StringJoiner("|").add(dy.getString("model.shownumber")).add(dy.getString("scene.number")).add(dy.getString("fy.number")).add(dy.getString("period.number")).add(dy.getString("entity.number")).add(dy.getString("source.number")).add(dy.getString("target.number")).toString();
    }

    private int getNextSeq(Long modelId, Long sceneId, Long fyId, Long periodId, Long entityId) {
        return ((AtomicInteger)ThreadCache.get((Object)("seq@" + sceneId + fyId + periodId + entityId), () -> {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("scene", "=", (Object)sceneId).add("fy", "=", (Object)fyId).add("period", "=", (Object)periodId).add("entity", "=", (Object)entityId).add("triangle", "=", (Object)" ");
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_exchagerate", (String)"max(eseq) as seq", (QFilter[])qfBuilder.toArray());
            Integer seq = dy != null ? dy.getInt("seq") : 0;
            return new AtomicInteger(seq != null ? seq + 1 : 0);
        })).getAndIncrement();
    }

    private QFilter[] getUniqueFilters(Long modelId, Long sceneId, Long fyId, Long periodId, Long entityId, Long sourceId, Long targetId) {
        return new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId)).add("scene", "=", (Object)LongUtil.toLong((Object)sceneId)).add("fy", "=", (Object)LongUtil.toLong((Object)fyId)).add("period", "=", (Object)LongUtil.toLong((Object)periodId)).add("entity", "=", (Object)LongUtil.toLong((Object)entityId)).add("source", "=", (Object)LongUtil.toLong((Object)sourceId)).add("target", "=", (Object)LongUtil.toLong((Object)targetId)).toArray();
    }

    private QFilter[] getUniqueFilterForData(Long modelId, Long sceneId, Long fyId, Long periodId, Long entityId) {
        return new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId)).add("scene", "=", (Object)LongUtil.toLong((Object)sceneId)).add("fy", "=", (Object)LongUtil.toLong((Object)fyId)).add("period", "=", (Object)LongUtil.toLong((Object)periodId)).add("entity", "=", (Object)LongUtil.toLong((Object)entityId)).toArray();
    }

    private void saveOlap(FixedItem item) {
        Set sceneIds;
        ApplicationTypeEnum app;
        Pair rule;
        Long modelId = item.getModelId();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_exchagerate", (String)String.join((CharSequence)",", fields), (QFilter[])this.getUniqueFilterForData(item.getModelId(), item.getScenarioId(), item.getFyId(), item.getPeriodId(), item.getEntityId()));
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>(10);
        if (dynamicObjects[0].getDynamicObject("scene") != null) {
            pairs.add(Pair.onePair((Object)DimTypesEnum.SCENARIO.getNumber(), (Object)dynamicObjects[0].getString("scene.number")));
        }
        pairs.add(Pair.onePair((Object)DimTypesEnum.YEAR.getNumber(), (Object)dynamicObjects[0].getString("fy.number")));
        pairs.add(Pair.onePair((Object)DimTypesEnum.PERIOD.getNumber(), (Object)dynamicObjects[0].getString("period.number")));
        pairs.add(Pair.onePair((Object)DimTypesEnum.ENTITY.getNumber(), (Object)dynamicObjects[0].getString("entity.number")));
        if (MemberReader.isExistAuditTrailDimension((String)MemberReader.findModelNumberById((Object)modelId))) {
            pairs.add(Pair.onePair((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)"ATNone"));
        }
        if (MemberReader.isExistChangeTypeDimension((String)modelNumber)) {
            pairs.add(Pair.onePair((Object)DimTypesEnum.CHANGETYPE.getNumber(), (Object)"EndingBalance"));
        }
        pairs.add(Pair.onePair((Object)DimTypesEnum.INTERCOMPANY.getNumber(), (Object)"ICNone"));
        QFilter modelFilter = new QFilter("id", "=", (Object)modelId);
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"isspptmultrule, isspptdatasort, defineddim", (QFilter[])new QFilter[]{modelFilter});
        if (model.getBoolean("isspptmultrule")) {
            rule = Pair.onePair((Object)DimTypesEnum.MULTIGAAP.getNumber(), PresetConstant.RULE_MEMS.get(1));
            pairs.add(rule);
        }
        if (model.getBoolean("isspptdatasort")) {
            rule = Pair.onePair((Object)DimTypesEnum.DATASORT.getNumber(), (Object)"Actual");
            pairs.add(rule);
        }
        if (DimensionServiceHelper.existsMyCompanyDim((long)modelId)) {
            rule = Pair.onePair((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MCNone");
            pairs.add(rule);
        }
        if ((app = ModelServiceHelper.getModelApp((long)modelId)) == ApplicationTypeEnum.RPT || app == ApplicationTypeEnum.UNRPT || app == ApplicationTypeEnum.PUB) {
            String defineddim = model.getString("defineddim");
            if (defineddim.contains("1")) {
                pairs.add(Pair.onePair((Object)SysDimensionEnum.Project.getNumber(), (Object)(SysDimensionEnum.Project.getShortnumber() + "None")));
            }
            if (defineddim.contains("2")) {
                pairs.add(Pair.onePair((Object)SysDimensionEnum.BusinessPartner.getNumber(), (Object)(SysDimensionEnum.BusinessPartner.getShortnumber() + "None")));
            }
            if (defineddim.contains("3")) {
                pairs.add(Pair.onePair((Object)SysDimensionEnum.MultiBook.getNumber(), (Object)(SysDimensionEnum.MultiBook.getShortnumber() + "None")));
            }
        }
        List userDefines = QueryDimensionServiceHelper.getUserDefineDim((Long)modelId);
        HashSet dimIDs = new HashSet(16);
        userDefines.forEach(u -> dimIDs.add(u.getLong("id")));
        QFBuilder qf = new QFBuilder();
        qf.add("dimension", "in", dimIDs);
        qf.add("model", "=", (Object)modelId);
        qf.add("level", "=", (Object)2);
        qf.add("ISSYSMEMBER", "=", (Object)1);
        qf.add("number", "like", (Object)"%None");
        DynamicObjectCollection dimMembers = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"dimension,number", (QFilter[])qf.toArray());
        HashMap<Long, String> dimMap = new HashMap<Long, String>(16);
        for (DynamicObject member : dimMembers) {
            Long dimID = member.getLong("dimension");
            String number = member.getString("number");
            dimMap.put(dimID, number);
        }
        userDefines.forEach(u -> {
            Long dimID = u.getLong("id");
            String dimNumber = u.getString("number");
            Pair userDefineP = Pair.onePair((Object)dimNumber, dimMap.get(dimID));
            pairs.add(userDefineP);
        });
        List<String> allRateColumnsOlap = this.getAllrateColumns(this.rateColumns4Olap, modelId);
        Optional<Pair> entity = pairs.stream().filter(s -> DimTypesEnum.ENTITY.getNumber().equals(s.p1)).findFirst();
        Optional<Pair> scene = pairs.stream().filter(s -> DimTypesEnum.SCENARIO.getNumber().equals(s.p1)).findFirst();
        Optional<Pair> period = pairs.stream().filter(s -> DimTypesEnum.PERIOD.getNumber().equals(s.p1)).findFirst();
        HashSet<Object> sceneNumbers = new HashSet<Object>(8);
        if (!entity.isPresent() || !period.isPresent()) {
            return;
        }
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)((String)entity.get().p2));
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)((String)period.get().p2));
        if (!scene.isPresent()) {
            sceneIds = ExchangeRateShareSceneHelper.getRateShare2ApplySceneInPeriod((Long)entityNode.getId(), (Long)periodNode.getId());
            sceneIds.forEach(s -> {
                IDNumberTreeNode curScene = MemberReader.findScenaMemberById((String)modelNumber, (Long)s);
                if (IDNumberTreeNode.NotFoundTreeNode != curScene) {
                    sceneNumbers.add(curScene.getNumber());
                }
            });
        } else if (ExchangeRateShareSceneHelper.isOpenRateShare((String)entityNode.getId().toString()).booleanValue()) {
            pairs.remove(scene.get());
            sceneIds = ExchangeRateShareSceneHelper.getRateShare2ApplySceneInPeriod((Long)entityNode.getId(), (Long)periodNode.getId());
            sceneIds.forEach(s -> {
                IDNumberTreeNode curScene = MemberReader.findScenaMemberById((String)modelNumber, (Long)s);
                if (IDNumberTreeNode.NotFoundTreeNode != curScene) {
                    sceneNumbers.add(curScene.getNumber());
                }
            });
        } else {
            pairs.remove(scene.get());
            sceneNumbers.add(scene.get().p2);
        }
        for (String property : allRateColumnsOlap) {
            ExchageRateServiceHelper.saveExchangeRate4Rows(pairs, Arrays.asList(dynamicObjects), (String)property, (String)modelNumber, (boolean)false, sceneNumbers, (OlapSourceEnum)OlapSourceEnum.M1);
        }
    }

    private List<String> getAllrateColumns(String[] rateColumns, Long modelId) {
        ArrayList<String> allRateColumns = new ArrayList<String>(Arrays.asList(rateColumns == null ? new String[]{} : rateColumns));
        ExchageRateServiceHelper.getUserdefinedrateAccount((long)modelId).keySet().stream().forEach(e -> allRateColumns.add(e.toLowerCase(Locale.ENGLISH)));
        return allRateColumns;
    }
}

