/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.exchangeRate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateCopyServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.exchangeRate.RateSchemeServiceHelper;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.util.QCfilterUtils;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.util.DataMutextHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.PeriodTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ExchangeRateMaintainPlugin
extends AbstractBaseListPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
CellClickListener,
TreeNodeClickListener,
EntryGridBindDataListener {
    private static final String model = "model";
    private static final String scene = "scenario";
    private static final String year = "year";
    private static final String period = "period";
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static final String entryentity = "entryentity";
    private static final String RATETREE = "treeviewap";
    private static final String SHOWTYPE = "showtype";
    private static final String SHARESCENE = "sharescene";
    private static final String LOCKMODE = "lockedmode";
    private static final String CurrentRateShareType = "currentratesharetype";
    private static final String CacheTree = "cachetree";
    private static final String CACHE_ROOT = "cacheroot";
    private static final String CHANGE_DATA_INDEX = "change_data_index";
    private static final String NEW_ENTRY_DATA_KEY = "new_entry_data_key";
    private static final String DATABASE_IDS_KEY = "database_ids_key";
    private static final String KEY_NOPERMRATE = "nopermrate";
    private static final String KEY_READONLYRATE = "readonlyrate";
    private static final String KEY_READWRITERATE = "readwriterate";
    private static final String SEARCH_BOFORE = "searchbefore";
    private static final String SEARCH_NEXT = "searchnext";
    private static final String KEY_ADMINUSERBOL = "adminUserBol";
    private static final String IMPORT_CALLBACK = "import_callback";
    private static final String SYS_IMPORT_TABLE = "sys_import_table";
    private static final String[] BEGINRATE_TYPE = new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate", "boyuserdefinedrate1", "boyuserdefinedrate2", "boyuserdefinedrate3", "boyuserdefinedrate4", "boyuserdefinedrate5", "boyuserdefinedrate6", "boyuserdefinedrate7", "boyuserdefinedrate8", "boyuserdefinedrate9", "boyuserdefinedrate10"};
    private static final String[] btns = new String[]{"bar_addrow", "bar_delrow", "btnedit", "btndel", "save", "btn_triangleratecalc", "btn_calculateformula", "copyfromother", "btn_import", "btn_sysimport"};
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ExchangeRateMaintainPlugin.class);
    private String treeNode_CacheOldId = "focusnode_oldid";
    private String treeNode_CacheId = "focusnodeid";
    private String sysNode_CacheId = "sysnodeid";
    private String source_rate = "sourcerate";
    private String change_rowId = "changeid";
    private String[] rateColumns = new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate", "boyuserdefinedrate1", "boyuserdefinedrate2", "boyuserdefinedrate3", "boyuserdefinedrate4", "boyuserdefinedrate5", "boyuserdefinedrate6", "boyuserdefinedrate7", "boyuserdefinedrate8", "boyuserdefinedrate9", "boyuserdefinedrate10", "periodend", "average", "userdefine", "userdefinedrate1", "userdefinedrate2", "userdefinedrate3", "userdefinedrate4", "userdefinedrate5", "userdefinedrate6", "userdefinedrate7", "userdefinedrate8", "userdefinedrate9", "userdefinedrate10"};
    private String[] rateColumns4Olap = new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate", "periodend", "average", "userdefine"};
    private String[] allColumns = new String[]{"id", "source", "target", "beginyear", "boyaveragerate", "boyuserdefinedrate", "periodend", "average", "userdefine", "precision", "mutual", "modifytime", "modifier", "fromid", "triangle"};
    private String searchColumns = "id,source.id,target.id,source.number,target.number,source.name,target.name,beginyear,boyaveragerate,boyuserdefinedrate,periodend,average,userdefine,precision,mutual,modifytime,modifier.id,modifier.name,fromid,triangle";
    private boolean isCopy = false;
    private static final String opKey = "updateRate";
    private static final String PAGECACHE_LOCKED = "pageCache_locked";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        switch (arg0.getProperty().getName()) {
            case "source": {
                QFilter modelFilter = new QFilter(model, "=", (Object)this.getModelId());
                ArrayList<QFilter> customFilter = new ArrayList<QFilter>(10);
                modelFilter = this.getDimPermissonFilter(this.getModelId(), "bcm_processmembertree");
                customFilter.add(modelFilter);
                customFilter.add(new QFilter("parent.number", "=", (Object)"TCF"));
                arg0.setCustomQFilters(customFilter);
                arg0.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u539f\u5e01", (String)"ExchangeRateMaintainPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                arg0.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sourcef7"));
                break;
            }
            case "target": {
                QFilter targetFilter = new QFilter(model, "=", (Object)this.getModelId());
                ArrayList<QFilter> targetCustomFilter = new ArrayList<QFilter>(10);
                targetFilter = this.getDimPermissonFilter(this.getModelId(), "bcm_currencymembertree");
                targetCustomFilter.add(targetFilter);
                targetCustomFilter.add(new QFilter("isleaf", "=", (Object)"1"));
                targetCustomFilter.add(new QFilter("number", "not in", (Object)new String[]{"CNone", "EC", "PC", "OC"}));
                arg0.setCustomQFilters(targetCustomFilter);
                arg0.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u76ee\u6807\u5e01", (String)"ExchangeRateMaintainPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                arg0.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "targetf7"));
            }
        }
    }

    private void checkmodel() {
        if (this.getModelId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExchangeRateMaintainPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap_entryentity");
        this.addClickListeners("source", "target", "btnadd", "btnedit", "btndel");
        this.addClickListeners(SEARCH_BOFORE, SEARCH_NEXT);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryentity);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addCellClickListener((CellClickListener)this);
        BasedataEdit source = (BasedataEdit)this.getControl("source");
        source.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit target = (BasedataEdit)this.getControl("target");
        target.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView tv = (TreeView)this.getControl(RATETREE);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(var1 -> {
            this.checkmodel();
            String searchContent = var1.getText().toLowerCase(Locale.ENGLISH).trim();
            if (StringUtils.isEmpty((CharSequence)searchContent)) {
                this.getPageCache().put("resultlist", null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                return;
            }
            String lastsearch = this.getPageCache().get("lastsearch");
            this.getPageCache().put("search", searchContent);
            String foucesId = this.getPageCache().get("foucesId");
            if (!Objects.equals(lastsearch, searchContent)) {
                foucesId = "";
            }
            this.searchNext(searchContent, foucesId, 1);
        });
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        IFormView view = this.getView();
        boolean isUpdateRate = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM009");
        if (isUpdateRate) {
            view.setEnable(Boolean.TRUE, -1, BEGINRATE_TYPE);
        } else {
            view.setEnable(Boolean.FALSE, -1, BEGINRATE_TYPE);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getPageCache().put(this.treeNode_CacheOldId, this.getPageCache().get(this.treeNode_CacheId));
        this.getPageCache().put(this.treeNode_CacheId, String.valueOf(evt.getNodeId()));
        this.getPageCache().put("propName", "entity");
        this.updateShareSceneCache(String.valueOf(evt.getNodeId()));
        if (this.getEntryEntityDataChange().booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u6c47\u7387\u6570\u636e\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ExchangeRateMaintainPlugin_73", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("treeNodeClick_save_confirm", (IFormPlugin)this));
            return;
        }
        this.refreshEntryEntity();
        this.writeOperationLog(OpItemEnum.LOOKUP.getName(), ResultStatusEnum.SUCCESS.getName());
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int[] selected = ((EntryGrid)evt.getSource()).getSelectRows();
        this.getPageCache().put("selected", ObjectSerialUtil.toByteSerialized((Object)selected));
    }

    private void setCellEnable(String[] columns, boolean enable, int row) {
        for (String property : columns) {
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(property);
            fieldEdit.setEnable("", enable, row);
        }
    }

    private void setAllEnable() {
        String scenes = this.getPageCache().get(SHARESCENE);
        DynamicObjectCollection entryentitycolls = this.getModel().getEntryEntity(entryentity);
        ArrayList<Integer> colorRow = new ArrayList<Integer>();
        FixedItem item = this.getContextFixItem(Boolean.FALSE);
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), scene);
        Boolean getNoLock = StringUtils.isEmpty((CharSequence)this.getPageCache().get(PAGECACHE_LOCKED));
        this.lockCols(getNoLock == false && ExchangeRateShareSceneHelper.checkRateSharePeriodSceneOpen((Long)item.getModelId(), (Long)item.getEntityId(), (Long)LongUtil.toLong((Object)sceneId), (Long)item.getFyId(), (Long)item.getPeriodId()) != false);
        for (DynamicObject row : entryentitycolls) {
            if (row.getLong("fromid") != 0L || StringUtils.isNotEmpty((CharSequence)row.getString("triangle"))) {
                this.setCellEnable(this.rateColumns, false, row.getInt("seq") - 1);
                this.setCellEnable(new String[]{"source", "target", "precision", "mutual"}, false, row.getInt("seq") - 1);
                colorRow.add(row.getInt("seq") - 1);
            } else {
                if (row.getBoolean("mutual")) {
                    this.setCellEnable(new String[]{"source", "target"}, false, row.getInt("seq") - 1);
                }
                DynamicObject sourceObject = (DynamicObject)row.get("source");
                DynamicObject targetObject = (DynamicObject)row.get("target");
                this.setCellEnable(new String[]{"mutual"}, sourceObject != null && targetObject != null, row.getInt("seq") - 1);
            }
            this.setCellEnable(new String[]{SHARESCENE}, false, row.getInt("seq") - 1);
        }
        EntryGrid control = (EntryGrid)this.getControl(entryentity);
        int[] rows = new int[colorRow.size()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = (Integer)colorRow.get(i);
        }
        control.setRowBackcolor("#e5e5e5", rows);
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotEmpty((CharSequence)scenes)), new String[]{SHARESCENE});
    }

    private void lockCols(Boolean isOpen) {
        ArrayList allcols = Lists.newArrayList((Object[])this.rateColumns);
        ArrayList beginCols = Lists.newArrayList((Object[])BEGINRATE_TYPE);
        if (!isOpen.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, -1, this.rateColumns);
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"source", "target", "precision"});
            return;
        }
        boolean isBeginUpdate = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM009");
        if (!isBeginUpdate) {
            allcols.removeAll(beginCols);
            this.getView().setEnable(Boolean.FALSE, -1, BEGINRATE_TYPE);
            this.getView().setEnable(Boolean.TRUE, -1, allcols.toArray(new String[0]));
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"source", "target", "precision"});
        } else {
            this.getView().setEnable(Boolean.TRUE, -1, this.rateColumns);
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"source", "target", "precision"});
        }
    }

    private void updateEntry(Boolean updateSelected) {
        if (updateSelected.booleanValue()) {
            this.getPageCache().put("selected", ObjectSerialUtil.toByteSerialized((Object)new int[]{this.getModel().getEntryCurrentRowIndex(entryentity)}));
        }
        this.getView().updateView(entryentity);
        this.setAllEnable();
    }

    private void updateCell(IClientViewProxy proxy, String entryKey, String propertyName, Object val, int i) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("k", entryKey);
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("r", i);
        state.put("v", val);
        state.put("k", propertyName);
        dataMap.put("fieldstates", Collections.singletonList(state));
        proxy.addAction("u", dataMap);
    }

    private void setRatePrecision(DynamicObject rowObj, int precision, boolean isUpdateRate, List<String> beginCols) {
        Long modelId = this.getModelId();
        List allRateColumns = ExchangeRateShareSceneHelper.getAllrateColumns((Long)modelId, (String[])this.rateColumns);
        for (String property : allRateColumns) {
            if (!isUpdateRate && beginCols.stream().anyMatch(p -> property.toLowerCase(Locale.ENGLISH).startsWith((String)p))) continue;
            this.getModel().setValue(property, (Object)rowObj.getBigDecimal(property).setScale(precision, RoundingMode.HALF_UP), rowObj.getInt("seq") - 1);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (SEARCH_BOFORE.equals(key) || SEARCH_NEXT.equals(key)) {
            this.checkmodel();
            this.getIndexBeforeOrNext(key);
        } else if (evt.getSource() instanceof Button) {
            this.checkmodel();
            this.getPageCache().put(this.treeNode_CacheOldId, this.getPageCache().get(this.treeNode_CacheId));
            this.getPageCache().put("propName", "entity");
            this.getPageCache().put("ratePlanOperate", ((Control)evt.getSource()).getKey());
            if (this.getEntryEntityDataChange().booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u6c47\u7387\u6570\u636e\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ExchangeRateMaintainPlugin_73", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ratePlanOperate_save_confirm", (IFormPlugin)this));
            } else {
                this.ratePlanOperate();
                this.refreshEntryEntity();
            }
        }
    }

    private void getIndexBeforeOrNext(String key) {
        String rowcache = this.getPageCache().get("resultlist");
        if (rowcache == null) {
            this.getView().showTipNotification(MessageConstant.getNO_DATA());
            return;
        }
        String searchContent = this.getPageCache().get("search");
        String focusNode = this.getPageCache().get("foucesId");
        this.searchNext(searchContent, focusNode, SEARCH_BOFORE.equals(key) ? -1 : 1);
    }

    private void updateButtonAndEntryStatus() {
        this.getPageCache().remove(LOCKMODE);
        Boolean flag = this.isReadOnlyNode() != false || this.isDisabled() != false || !this.hasPerm() || StringUtils.isEmpty((CharSequence)this.getPageCache().get(PAGECACHE_LOCKED));
        this.getView().setEnable(Boolean.valueOf(flag == false), new String[]{"save", "btnedit", "btndel", "btn_import", "btn_sysimport", "copyfromother", "bar_addrow", "bar_delrow", "btn_triangleratecalc", "btn_calculateformula"});
        this.getView().setEnable(Boolean.valueOf(flag == false), new String[]{entryentity});
        if (flag.booleanValue()) {
            this.getPageCache().put(LOCKMODE, "1");
        } else {
            this.getView().setEnable(Boolean.valueOf(true), btns);
        }
    }

    private Boolean isReadOnlyNode() {
        Long currentId = LongUtil.toLong((Object)this.getPageCache().get("focusnodeid"));
        if (!"1".equals(this.getPageCache().get(KEY_ADMINUSERBOL))) {
            Set readOnlyPermIds = this.getPermList(KEY_READONLYRATE);
            return readOnlyPermIds.contains(currentId);
        }
        return Boolean.FALSE;
    }

    private void ratePlanOperate() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("KEY_MODEL_ID", this.getPageCache().get("KEY_MODEL_ID"));
        switch (this.getPageCache().get("ratePlanOperate")) {
            case "btnadd": {
                if (this.checkRateEntity()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u5165\u3010\u4f53\u7cfb\u7ba1\u7406\u5217\u8868\u3011\u5347\u7ea7\u4f53\u7cfb\u3002", (String)"ExchangeRateMaintainPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                params.put("ids", 0L);
                this.openEditForm(params, OperationStatus.ADDNEW);
                break;
            }
            case "btnedit": {
                Long currentId = LongUtil.toLong((Object)this.getPageCache().get("focusnodeid"));
                if (currentId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u7387\u65b9\u6848\u3002", (String)"ExchangeRateMaintainPlugin_64", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                params.put("ids", currentId);
                if (this.isReadOnlyNode().booleanValue()) {
                    params.put("readOnly", "1");
                }
                params.put("type", this.getPageCache().get(CurrentRateShareType));
                this.openEditForm(params, OperationStatus.EDIT);
                break;
            }
            case "btndel": {
                Long id = LongUtil.toLong((Object)this.getPageCache().get(this.treeNode_CacheId));
                if (id == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u7387\u65b9\u6848\u3002", (String)"ExchangeRateMaintainPlugin_64", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (Objects.equals(this.getPageCache().get(this.treeNode_CacheId), this.getPageCache().get(this.sysNode_CacheId))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u6c47\u7387\u65b9\u6848\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ExchangeRateMaintainPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.isRateHaveReference()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6c47\u7387\u65b9\u6848\u5df2\u88ab\u6298\u7b97\u8bbe\u7f6e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ExchangeRateMaintainPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.isRateHaveDatas()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u5173\u6c47\u7387\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ExchangeRateMaintainPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.isRateHaveFormulas()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6c47\u7387\u65b9\u6848\u5df2\u88ab\u6c47\u7387\u516c\u5f0f\u8bbe\u7f6e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ExchangeRateMaintainPlugin_53", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.isReadOnlyNode().booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u5220\u9664\u3002", (String)"ExchangeRateMaintainPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u6c47\u7387\u65b9\u6848\uff1f", (String)"ExchangeRateMaintainPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleterate_confirm", (IFormPlugin)this));
                break;
            }
        }
    }

    private boolean checkRateEntity() {
        QFilter qf = new QFilter("longnumber", "=", (Object)"Entity!RateEntity").and(model, "=", (Object)this.getModelId()).and("issysmember", "=", (Object)1);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,model", (QFilter[])new QFilter[]{qf});
        return dy == null;
    }

    private void openEditForm(Map<String, Object> params, OperationStatus status) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_exchangerateplan_edit");
        params.put("context", ObjectSerialUtil.toByteSerialized((Object)this.getContextFixItem(Boolean.FALSE)));
        this.showForm("bcm_exchangerateplan_edit", params, closeCallBack, ShowType.Modal, status);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "deleterate_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.checkPerm("btndel");
                this.delelteExchangeRatePlan();
                break;
            }
            case "delete_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.checkPerm("bar_delrow");
                this.deleterows();
                break;
            }
            case "mutualcover_confirm": {
                this.checkPerm("save");
                int[] selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selected"));
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    int rowIndex = this.deleteRelateRow(selected[0]);
                    DynamicObject row = this.getModel().getEntryRowEntity(entryentity, rowIndex);
                    DynamicObject sourceObject = (DynamicObject)row.get("source");
                    DynamicObject targetObject = (DynamicObject)row.get("target");
                    if (sourceObject == null || targetObject == null) break;
                    this.insertRow(rowIndex, row, sourceObject, targetObject);
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("mutual", (Object)false, selected[0]);
                this.getModel().endInit();
                this.getView().updateView("mutual", selected[0]);
                break;
            }
            case "close_save_confirm": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    ResultBox box = this.checkPeriodIsOpen();
                    if (box.isError()) {
                        this.getView().showTipNotification(box.getMessageText());
                        return;
                    }
                    this.checkPerm("save");
                    this.actionSave(false);
                    this.refreshEntryEntity();
                }
                this.getView().close();
                break;
            }
            case "treeNodeClick_save_confirm": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.checkPerm("save");
                    this.actionSave(true);
                }
                this.refreshEntryEntity();
                break;
            }
            case "propertyChanged_save_confirm": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.checkPerm("save");
                    this.isCopy = true;
                    this.actionSave(true);
                }
                this.filterChange();
                this.getPageCache().put(entryentity, SerializationUtils.serializeToBase64((Object)this.getModel().getEntryEntity(entryentity)));
                break;
            }
            case "ratePlanOperate_save_confirm": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.checkPerm("save");
                    this.actionSave(true);
                }
                this.ratePlanOperate();
                this.refreshEntryEntity();
                this.getPageCache().put(entryentity, SerializationUtils.serializeToBase64((Object)this.getModel().getEntryEntity(entryentity)));
                break;
            }
            case "refresh_save_confirm": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.checkPerm("save");
                    this.actionSave(false);
                }
                this.refreshEntryEntity();
                break;
            }
            case "close_override_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.checkPerm("btn_import");
                String str = this.getPageCache().get(SYS_IMPORT_TABLE);
                if (!StringUtils.isNotEmpty((CharSequence)str)) break;
                Table table = (Table)ObjectSerialUtil.deSerializedBytes((String)str);
                FixedItem context = this.getContextFixItem(Boolean.FALSE);
                ResultBox box = ExchageRateServiceHelper.sysImportRate((FixedItem)context, (Table)table);
                StringBuilder sb = new StringBuilder(this.getContextFixItem(Boolean.FALSE).getInfo());
                if (box.isSuccess()) {
                    sb.append(ResManager.loadKDString((String)"\u6210\u529f", (String)"ExchangeRateMaintainPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u5b8c\u6210\u3002", (String)"ExchangeRateMaintainPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ece\u7cfb\u7edf\u5bfc\u5165", (String)"ExchangeRateMaintainPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                    this.writeOperationLog(ResManager.loadKDString((String)"\u4ece\u7cfb\u7edf\u5bfc\u5165", (String)"ExchangeRateMaintainPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString());
                } else {
                    sb.append(ResManager.loadKDString((String)"\u5931\u8d25", (String)"ExchangeRateMaintainPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25,\u539f\u56e0:%2$s", (String)"ExchangeRateMaintainPlugin_66", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ece\u7cfb\u7edf\u5bfc\u5165", (String)"ExchangeRateMaintainPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]), box.getMessageText()));
                    sb.append(box.getMessageText());
                    this.writeOperationLog(ResManager.loadKDString((String)"\u4ece\u7cfb\u7edf\u5bfc\u5165", (String)"ExchangeRateMaintainPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString());
                }
                this.refreshEntryEntity();
                ExchangeQueryHelper.clearRateCache((BaseData)new BaseData(this.getContextFixItem(Boolean.FALSE)));
                break;
            }
        }
    }

    private void delelteExchangeRatePlan() {
        try (TXHandle tx = TX.required((String)"bcm_delelteExchangeRatePlan");){
            try {
                Long rateId = LongUtil.toLong((Object)this.getPageCache().get(this.treeNode_CacheId));
                QFilter filter = new QFilter("id", "=", (Object)rateId);
                DynamicObject ratePlan = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"model.id,model.number,number,issharescene", (QFilter[])filter.toArray());
                String number = ratePlan.getString("number");
                long modelId = ratePlan.getLong("model.id");
                String modelNumber = ratePlan.getString("model.number");
                DeleteServiceHelper.delete((String)"bcm_entitymembertree", (QFilter[])filter.toArray());
                QFilter filter2 = new QFilter("number", "=", (Object)number);
                DeleteServiceHelper.delete((String)"bcm_entitymember", (QFilter[])filter2.toArray());
                ArrayList<String> rateNumbers = new ArrayList<String>(16);
                rateNumbers.add(number);
                PairList pairList = new PairList();
                pairList.addPair((Object)PresetConstant.ENTITY_DIM, rateNumbers);
                QFilter sqf = new QFilter(model, "=", (Object)modelId);
                sqf.and("isversioned", "=", (Object)true);
                DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"number", (QFilter[])sqf.toArray());
                PairList deleteRateOrgPairList = OrgServiceHelper.getDeleteRateOrgPairList((Long)modelId, rateNumbers);
                for (DynamicObject dyn : dyns) {
                    try {
                        OlapServiceHelper.removePointScope((String)modelNumber, (String)dyn.getString("number"), (PairList)deleteRateOrgPairList);
                    }
                    catch (Exception ex) {
                        logger.error("remove rate org error", (Throwable)ex);
                    }
                }
                OlapServiceHelper.dropAggFactor((String)modelNumber, (String)PresetConstant.ENTITY_DIM, (String)number, (int)5, (String)"Entity");
                OlapServiceHelper.dropDimensionMemberForce((String)modelNumber, (String)PresetConstant.ENTITY_DIM, (String)number);
                if (ratePlan.getBoolean("issharescene")) {
                    QFilter sharescenes = new QFilter("rateplan", "=", (Object)rateId);
                    DeleteServiceHelper.delete((String)"bcm_rateplanscenes", (QFilter[])sharescenes.toArray());
                }
                OpNameMultiLangEnumBridge opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.DELETE.getMultiLangEnumBridge(), (String)OpItemEnum.DELETE.getCode());
                super.writeSuccessLog(opName, number);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExchangeRateMaintainPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getPageCache().remove(this.treeNode_CacheId);
                this.refreshRateTree();
                this.refreshEntryEntity();
            }
            catch (Throwable e) {
                this.getView().showErrorNotification(e.getMessage());
                tx.markRollback();
            }
        }
    }

    private boolean isRateHaveReference() {
        QFilter filter = new QFilter("exchangerate", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get(this.treeNode_CacheId)));
        return QueryServiceHelper.exists((String)"bcm_basecvtformula", (QFilter[])filter.toArray()) || QueryServiceHelper.exists((String)"bcm_specialrate", (QFilter[])filter.toArray());
    }

    private boolean isRateHaveDatas() {
        QFilter filter = new QFilter("entity", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get(this.treeNode_CacheId)));
        return QueryServiceHelper.exists((String)"bcm_exchagerate", (QFilter[])filter.toArray());
    }

    private boolean isRateHaveFormulas() {
        Long modelId = this.getModelId();
        if (!LongUtil.isvalidLong((Object)modelId)) {
            return Boolean.FALSE;
        }
        QFilter filter = new QFilter(model, "=", (Object)modelId);
        QFilter orgfilter = new QFilter("entity", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get(this.treeNode_CacheId)));
        filter.and(orgfilter);
        return QueryServiceHelper.exists((String)"bcm_rateformula", (QFilter[])filter.toArray());
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, OperationStatus status) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setStatus(status);
        param.setFormId(formId);
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    private Boolean getEntryEntityDataChange() {
        DynamicObjectCollection entryentitycolls;
        String old = this.getPageCache().get(entryentity);
        DynamicObjectCollection oldCols = null;
        if (old != null) {
            oldCols = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)old);
        }
        if ((entryentitycolls = this.getModel().getEntryEntity(entryentity)) != null && oldCols != null) {
            return !Objects.equals(SerializationUtils.toJsonString((Object)oldCols), SerializationUtils.toJsonString((Object)entryentitycolls));
        }
        return Boolean.FALSE;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        int[] selectRows;
        EntryGrid entryGrid;
        ResultBox box;
        super.itemClick(evt);
        String key = evt.getItemKey();
        ArrayList itemKeys = Lists.newArrayList((Object[])new String[]{"save", "btn_import", "bar_addrow", "bar_delrow", "btn_calculateformula", "btn_triangleratecalc", "btn_sysimport"});
        if (itemKeys.contains(key)) {
            String periodId = UserSelectUtil.getF7SelectId(this.getView(), period);
            if (periodId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"ExchangeRateMaintainPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            box = this.checkPeriodIsOpen();
            if (box.isError()) {
                this.getView().showTipNotification(box.getMessageText());
                return;
            }
        }
        if ("close".equals(key)) {
            if (this.getEntryEntityDataChange().booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u6c47\u7387\u6570\u636e\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ExchangeRateMaintainPlugin_73", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close_save_confirm", (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        } else {
            this.checkmodel();
        }
        if ("bar_addrow".equals(key)) {
            int row = this.getModel().createNewEntryRow(entryentity);
            String shareScenes = this.getPageCache().get(SHARESCENE);
            this.getModel().setValue("id", (Object)GlobalIdUtil.genGlobalLongId(), row);
            if (StringUtils.isNotEmpty((CharSequence)shareScenes)) {
                this.getModel().setValue(SHARESCENE, (Object)shareScenes, row);
            }
            this.setCellEnable(new String[]{"mutual", SHARESCENE}, false, row);
            this.getPageCache().put("selected", ObjectSerialUtil.toByteSerialized((Object)new int[]{this.getModel().getEntryCurrentRowIndex(entryentity)}));
            this.lockCols(Boolean.TRUE);
        } else if ("bar_delrow".equals(key)) {
            entryGrid = (EntryGrid)this.getView().getControl(entryentity);
            selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"ExchangeRateMaintainPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String select = this.getPageCache().get("selected");
            if (StringUtils.isEmpty((CharSequence)select)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"ExchangeRateMaintainPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            int[] selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selected"));
            if (selected.length <= 0 || selected[0] == -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"ExchangeRateMaintainPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.deleterows();
                this.lockCols(Boolean.TRUE);
            }
        } else if ("save".equals(key)) {
            this.actionSave(false);
            this.refreshEntryEntity();
        } else if ("btn_import".equals(key)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, IMPORT_CALLBACK);
            String listName = ResManager.loadKDString((String)"\u6c47\u7387\u7ba1\u7406", (String)"ExchangeRateMaintainPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
            AbsCommonImport.invokeOperation("bcm_exchagerate", "kd.fi.bcm.formplugin.exchangeRate.ExchangeRateMaintainImportPlugin", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
            this.writeOperationLog(OpItemEnum.IMPORT.getName(), ResultStatusEnum.SUCCESS.getName());
        } else if ("btn_sysimport".equals(key)) {
            ListShowParameter formShowParameter = ShowFormHelper.createShowListForm((String)"bd_exrate_tree", (boolean)Boolean.TRUE);
            formShowParameter.setFormId("bcm_exchangesysimport");
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            FixedItem ctx = this.getContextFixItem(Boolean.FALSE);
            params.put("context", ObjectSerialUtil.toByteSerialized((Object)ctx));
            params.put("KEY_MODEL_ID", this.getModelId());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParams(params);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btn_sysimport"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if ("btn_export".equals(key)) {
            entryGrid = (EntryGrid)this.getView().getControl(entryentity);
            selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bb0\u5f55", (String)"ExchangeRateMaintainPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Object[] selectRowsId = new Object[selectRows.length];
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entryentity, selectRows[i]);
                selectRowsId[i] = entryRowEntity.getLong("id");
                list.add(entryRowEntity);
            }
            try {
                this.export(selectRowsId);
                this.writeExportLog(list, ResultStatusEnum.SUCCESS.getName());
            }
            catch (Exception e) {
                this.writeExportLog(list, ResultStatusEnum.FAIL.getName());
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\u3002", (String)"ExchangeRateMaintainPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
            }
        } else if ("btn_triangleratesetting".equals(key)) {
            this.showTriangleForm();
        } else if ("btn_triangleratecalc".equals(key)) {
            FixedItem ctx = this.getContextFixItem(Boolean.FALSE);
            box = ExchangeRateShareSceneHelper.calcTriangleRate((FixedItem)ctx);
            StringBuilder sb = new StringBuilder(ctx.getInfo());
            if (box.isSuccess()) {
                sb.append(ResManager.loadKDString((String)"\u6210\u529f", (String)"ExchangeRateMaintainPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5df2\u5b8c\u6210\u3002", (String)"ExchangeRateMaintainPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.writeOperationLog(ResManager.loadKDString((String)"\u4e09\u89d2\u6c47\u7387-\u8ba1\u7b97", (String)"ExchangeRateMaintainPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString());
            } else {
                sb.append(ResManager.loadKDString((String)"\u5931\u8d25", (String)"ExchangeRateMaintainPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\uff1a%s", (String)"ExchangeRateMaintainPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), box.getErrorList().isEmpty() ? "" : ((MessageInfo)box.getErrorList().get(0)).getMessage()));
                this.writeOperationLog(ResManager.loadKDString((String)"\u4e09\u89d2\u6c47\u7387-\u8ba1\u7b97", (String)"ExchangeRateMaintainPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString());
            }
            this.refreshEntryEntity();
            ExchangeQueryHelper.clearRateCache((BaseData)new BaseData(ctx));
        } else if ("reflesh".equals(key)) {
            if (this.getEntryEntityDataChange().booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u6c47\u7387\u6570\u636e\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ExchangeRateMaintainPlugin_73", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("refresh_save_confirm", (IFormPlugin)this));
            } else {
                this.refreshRateTree();
                this.refreshEntryEntity();
            }
        } else if ("btn_configformula".equals(key)) {
            this.openConfigFormula();
        } else if ("btn_calculateformula".equals(key)) {
            this.calcConfigRate();
        } else if ("copyfromother".equals(key)) {
            ResultBox box2 = this.checkPeriodIsOpen();
            if (box2.isError()) {
                this.getView().showTipNotification(box2.getMessageText());
                return;
            }
            this.showCopyFromForm();
        }
    }

    @Override
    public void handleDys(DynamicObject[] dys) {
        if ("2".equals(this.getPageCache().get(CurrentRateShareType))) {
            String sceneIdstr = UserSelectUtil.getF7SelectId(this.getView(), scene);
            Long sceneId = LongUtil.toLong((Object)sceneIdstr);
            DynamicObject scene = BusinessDataServiceHelper.loadSingle((Object)sceneId, (String)"bcm_scenemembertree");
            Arrays.stream(dys).forEach(s -> s.set("scene", (Object)scene));
        }
    }

    private void openConfigFormula() {
        if (0L == this.getModelId()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExchangeRateMaintainPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_rateformulasetting");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("readOnly", (Object)this.getPageCache().get(LOCKMODE));
        formShowParameter.setCustomParam("context", (Object)SerializationUtils.serializeToBase64((Object)this.getContextFixItem(Boolean.FALSE)));
        this.getView().showForm(formShowParameter);
    }

    private void writeExportLog(List<DynamicObject> list, String result) {
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        try {
            if (!list.isEmpty()) {
                ArrayList listMsg = new ArrayList(16);
                list.forEach(dynamic -> this.getDetailMessage(allFields, (DynamicObject)dynamic, listMsg, OpItemEnum.EXPORT.getName(), result));
                OperationLogUtil.batchWriteOperationLog((IFormView)this.getView(), (String)OpItemEnum.EXPORT.getName(), listMsg, (Long)this.getModelId());
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void export(Object[] ids) throws Exception {
        if (ids != null && ids.length == 0) {
            return;
        }
        QFBuilder filters = new QFBuilder("bizobject.number", "=", (Object)"bcm_exchagerate");
        filters.add(new QFilter("templatetype", "=", (Object)"IMPT").or(new QFilter("templatetype", "is null", null)));
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters.toArray(), (String)kd.bos.util.StringUtils.getEmpty(), (int)2);
        FormView formView = (FormView)this.getView();
        String routeAppId = formView.getFormShowParameter().getServiceAppId();
        DynamicObject[] dys = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"bcm_exchagerate").values().toArray(new DynamicObject[0]);
        this.handleDys(dys);
        String url = ExportUtil.export((DynamicObject[])dys, pkIds.get(0), (String)routeAppId, (String)"bcm_exchagerate", (String)String.format("%s.xlsx", ResManager.loadKDString((String)"\u6c47\u7387\u7ba1\u7406\u5bfc\u51fa", (String)"ExchangeRateMaintainPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0])), e -> {
            Set userdefinedRates = ExchageRateServiceHelper.getUserdefinedrateAccountIgnoreCase((long)this.getModelId());
            List needRm = e.fields.stream().filter(field -> ExchageRateServiceHelper.isuserdefinedAcctWithIgnoreCase((String)field) && !userdefinedRates.contains(field)).collect(Collectors.toList());
            needRm.stream().forEach(r -> {
                e.properties.remove(r);
                e.fields.remove(r);
            });
        });
        if (kd.bos.util.StringUtils.isNotEmpty((String)url)) {
            this.downloadFile(url, "bcm_exchangerate_maintain", "1G2FW/G3YIL8");
        }
    }

    private void calcConfigRate() {
        FixedItem ctx = this.getContextFixItem(Boolean.FALSE);
        ResultBox result = ExchageRateServiceHelper.calcaluateRateFormula((FixedItem)ctx);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6c47\u7387\u516c\u5f0f\u8ba1\u7b97\u5df2\u5b8c\u6210\u3002", (String)"ExchangeRateMaintainPlugin_67", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        String sucess = result.isError() ? ResManager.loadKDString((String)"\u5931\u8d25", (String)"ExchangeRateMaintainPlugin_70", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6210\u529f", (String)"ExchangeRateMaintainPlugin_69", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String info = String.format(ResManager.loadKDString((String)"%1$s,%2$s,\u6c47\u7387\u516c\u5f0f\u8ba1\u7b97%3$s,\u8be6\u60c5:%4$s\u3002", (String)"ExchangeRateMaintainPlugin_68", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ctx.getNoEntityInfo(), result.getData() == null ? "" : result.getData(), sucess, result.getErrorList().stream().map(s -> s.getMessage()).collect(Collectors.joining(";")));
        this.writeOperationLog(ResManager.loadKDString((String)"\u6c47\u7387\u516c\u5f0f\u8ba1\u7b97", (String)"ExchangeRateMaintainPlugin_52", (String)"fi-bcm-formplugin", (Object[])new Object[0]), info);
        this.refreshEntryEntity();
        ExchangeQueryHelper.clearRateCache((BaseData)new BaseData(ctx));
    }

    private String getRealRateNumber(String rateNumber) {
        String result = rateNumber;
        switch (rateNumber) {
            case "ClosingRate": {
                result = "periodend";
                break;
            }
            case "AverageRate": {
                result = "average";
                break;
            }
            case "UserdefinedRate": {
                result = "userdefine";
                break;
            }
            case "BOYRate": {
                result = "beginyear";
                break;
            }
            case "BOYAverageRate": {
                result = "boyaveragerate";
                break;
            }
            case "BOYUserdefinedRate": {
                result = "boyuserdefinedrate";
            }
        }
        return result;
    }

    private void updateShareSceneCache(String entityNodeId) {
        this.getPageCache().remove(CurrentRateShareType);
        this.getPageCache().remove(SHARESCENE);
        if (StringUtils.isEmpty((CharSequence)entityNodeId)) {
            return;
        }
        if (!QueryServiceHelper.exists((String)"bcm_entitymembertree", (Object)LongUtil.toLong((Object)entityNodeId))) {
            this.getPageCache().remove(this.treeNode_CacheId);
            this.refreshRateTree();
            this.refreshEntryEntity();
            return;
        }
        this.releaseAndrequireLock();
        String sceneStr = UserSelectUtil.getF7SelectId(this.getView(), scene);
        Long sceneId = LongUtil.toLong((Object)sceneStr);
        if (!ExchangeRateShareSceneHelper.isOpenRateShare((String)entityNodeId).booleanValue()) {
            this.getPageCache().put(CurrentRateShareType, "1");
            return;
        }
        this.getPageCache().put(CurrentRateShareType, "2");
        Set shareScenes = ExchangeRateShareSceneHelper.getRateShareSceneIds((Long)LongUtil.toLong((Object)entityNodeId));
        String modelShowNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        HashSet<String> shareNames = new HashSet<String>(shareScenes.size());
        if (!CollectionUtils.isEmpty((Collection)shareScenes)) {
            for (Long s : shareScenes) {
                IDNumberTreeNode node = MemberReader.findScenaMemberById((String)modelShowNumber, (Long)s);
                shareNames.add(node.getName());
            }
            this.getPageCache().put(SHARESCENE, String.join((CharSequence)",", shareNames));
        }
    }

    private ResultBox checkPeriodIsOpen() {
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), scene);
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), year);
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), period);
        String orgNodeId = this.getPageCache().get(this.treeNode_CacheId);
        ResultBox result = ResultBox.of();
        if (StringUtils.isEmpty((CharSequence)orgNodeId)) {
            result.addError(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u7387\u65b9\u6848\u3002", (String)"ExchangeRateMaintainPlugin_64", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return result;
        }
        if (sceneId == null || yearId == null || periodId == null) {
            result.addError(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3001\u8d22\u5e74\u548c\u671f\u95f4\u3002", (String)"BeginYearCarryPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return result;
        }
        long orgId = Long.parseLong(orgNodeId);
        DynamicObject orgObject = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, number, model", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
        long modelId = this.getModelId();
        if (this.getPageCache().get("isChangeModel") != null) {
            modelId = orgObject.getLong(model);
            this.getPageCache().remove("isChangeModel");
        }
        if (!ExchangeRateShareSceneHelper.checkRateSharePeriodSceneOpen((Long)modelId, (Long)LongUtil.toLong((Object)orgNodeId), (Long)LongUtil.toLong((Object)sceneId), (Long)LongUtil.toLong((Object)yearId), (Long)LongUtil.toLong((Object)periodId)).booleanValue()) {
            result.addError(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff0c\u5982\u679c\u662f\u5171\u4eab\u60c5\u666f\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u6240\u6709\u60c5\u666f\u671f\u95f4\u662f\u5426\u90fd\u5f00\u542f\u3002", (String)"ExchangeRateMaintainPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return result;
        }
        result.addSuccess("");
        return result;
    }

    private void showCopyFromForm() {
        String modelid = String.valueOf(this.getModelId());
        if (StringUtil.isEmptyString((String)modelid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExchangeRateMaintainPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FixedItem ctx = this.getContextFixItem(Boolean.FALSE);
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("KEY_MODEL_ID", UserSelectUtil.getF7SelectId(this.getView(), model));
        params.put("context", ObjectSerialUtil.toByteSerialized((Object)ctx));
        IDNumberTreeNode fy = MemberReader.findFyMemberById((String)ctx.getModelNum(), (Long)ctx.getFyId());
        IDNumberTreeNode period = MemberReader.findPeriodMemberById((String)ctx.getModelNum(), (Long)ctx.getPeriodId());
        FormShowParameter formParameter = new FormShowParameter();
        formParameter.setFormId("bcm_exchangerate_copyfrom");
        formParameter.getOpenStyle().setShowType(ShowType.Modal);
        formParameter.setCustomParams(params);
        formParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_exchagerate"));
        formParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4ece\u5176\u4ed6\u671f\u95f4\u590d\u5236\u5230%1$s%2$s", (String)"ExchangeRateCopy_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fy.getName(), period.getName()));
        this.getView().showForm(formParameter);
    }

    private void showTriangleForm() {
        String modelid = String.valueOf(this.getModelId());
        if (StringUtil.isEmptyString((String)modelid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExchangeRateMaintainPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter formParameter = new FormShowParameter();
        formParameter.setFormId("bcm_trianglerate");
        formParameter.getOpenStyle().setShowType(ShowType.Modal);
        formParameter.setCustomParam("readOnly", (Object)this.getPageCache().get(LOCKMODE));
        formParameter.setCustomParam("modelid", (Object)this.getModelId());
        this.getView().showForm(formParameter);
    }

    private void actionSave(boolean isLeave) {
        this.actionSave(isLeave, false);
    }

    private void actionSave(boolean isLeave, boolean ignoreRepeat) {
        FixedItem ctx = this.getContextFixItem(isLeave);
        DynamicObjectCollection rateColl = this.getModel().getEntryEntity(entryentity);
        int i = 0;
        HashSet<String> originSourceTarget = new HashSet<String>(rateColl.size());
        for (DynamicObject row : rateColl) {
            if (this.isSkipRow(row)) continue;
            String msg = this.checkRow(row, i);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                throw new KDBizException(msg);
            }
            if (originSourceTarget.contains(row.getString("source.number") + "|" + row.getString("target.number"))) {
                msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u539f\u5e01\u548c\u76ee\u6807\u5e01\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExchangeRateMaintainPlugin_71", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1);
                if (!ignoreRepeat) {
                    throw new KDBizException(msg);
                }
            }
            ++i;
            originSourceTarget.add(row.getString("source.number") + "|" + row.getString("target.number"));
        }
        this.getPageCache().put(NEW_ENTRY_DATA_KEY, ObjectSerialUtil.toByteSerialized((Object)rateColl));
        Set sourceIDs = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.source_rate), Set.class);
        HashSet sourceIDsCopy = new HashSet(sourceIDs);
        Set modifyRow = null;
        if (this.getPageCache().get(this.change_rowId) != null) {
            modifyRow = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.change_rowId), Set.class);
            this.getPageCache().put(CHANGE_DATA_INDEX, ObjectSerialUtil.toByteSerialized((Object)modifyRow));
        }
        HashSet<String> rateIDs = new HashSet<String>(rateColl.size());
        ArrayList<DynamicObject> entry = new ArrayList<DynamicObject>();
        i = 0;
        DynamicObject user = this.getUser();
        int changeMutualRow = -1;
        for (DynamicObject row : rateColl) {
            if (this.isSkipRow(row)) continue;
            boolean keepModifytime = false;
            Date modifytime = null;
            if (modifyRow == null || modifyRow != null && !modifyRow.contains(row.getInt("seq") - 1)) {
                keepModifytime = true;
                modifytime = (Date)row.get("modifytime");
            } else if (row.getBoolean("mutual") && row.getLong("fromid") == 0L) {
                changeMutualRow = row.getInt("seq");
            }
            DynamicObject rate = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exchagerate");
            rate.set(model, (Object)ctx.getModelId());
            rate.set("scene", (Object)ctx.getScenarioId());
            rate.set("fy", (Object)ctx.getFyId());
            rate.set(period, (Object)ctx.getPeriodId());
            rate.set("mutual", row.get("mutual"));
            rate.set("entity", (Object)ctx.getEntityId());
            List allRatAallColumns = ExchangeRateShareSceneHelper.getAllrateColumns((Long)this.getModelId(), (String[])this.allColumns);
            for (Object property : allRatAallColumns) {
                rate.set((String)property, row.get((String)property));
            }
            rate.set("modifier", changeMutualRow != i && keepModifytime ? row.get("modifier") : user);
            rate.set("modifytime", (Object)(changeMutualRow != i && keepModifytime ? modifytime : TimeServiceHelper.now()));
            if (StringUtils.isNotEmpty((CharSequence)row.getString("triangle"))) {
                rate.set("modifier", (Object)user);
                rate.set("modifytime", (Object)TimeServiceHelper.now());
            }
            rate.set("eseq", (Object)i);
            entry.add(rate);
            String id = row.getString("id");
            rateIDs.add(id);
            ++i;
        }
        sourceIDs.removeIf(rateIDs::contains);
        Map<String, DynamicObject> existData = this.getNewlyData(ctx);
        Map<String, String> nowSourceAndTarget = existData.values().stream().collect(Collectors.toMap(s -> s.getString("source.number") + "|" + s.getString("target.number"), s -> s.getString("id"), (e1, e2) -> e2));
        try (TXHandle tx = TX.required((String)"bcm_actionSave");){
            try {
                QFilter filter;
                boolean existTriangle;
                if (!sourceIDs.isEmpty()) {
                    List delteData = existData.values().stream().filter(s -> sourceIDs.contains(s.getString("id"))).collect(Collectors.toList());
                    ExchangeRateShareSceneHelper.saveOlap4Rows(delteData, (boolean)true, (FixedItem)ctx, null, (OlapSourceEnum)OlapSourceEnum.M1);
                }
                if (!sourceIDsCopy.isEmpty()) {
                    DeleteServiceHelper.delete((String)"bcm_exchagerate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)LongUtil.toLongList(sourceIDsCopy))});
                }
                if (!entry.isEmpty()) {
                    ArrayList<DynamicObject> allUpdateDataList = new ArrayList<DynamicObject>();
                    ArrayList<DynamicObject> allAddDataList = new ArrayList<DynamicObject>();
                    HashSet<Long> needReLoadData = new HashSet<Long>(entry.size());
                    for (DynamicObject tmp : entry) {
                        String key = tmp.getString("source.number") + "|" + tmp.getString("target.number");
                        String existId = nowSourceAndTarget.get(key);
                        if (!(StringUtils.isEmpty((CharSequence)existId) || "0".equals(existId) || sourceIDsCopy.contains(existId))) {
                            tmp.set("id", (Object)LongUtil.toLong((Object)existId));
                            needReLoadData.add(LongUtil.toLong((Object)existId));
                            allUpdateDataList.add(tmp);
                            continue;
                        }
                        allAddDataList.add(tmp);
                    }
                    SaveServiceHelper.update((DynamicObject[])allUpdateDataList.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])allAddDataList.toArray(new DynamicObject[0]));
                    ArrayList newEntry = new ArrayList(entry.size());
                    DynamicObject[] newlyData = BusinessDataServiceHelper.load((Object[])needReLoadData.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_exchagerate"));
                    Map<Long, DynamicObject> dataMap = Arrays.stream(newlyData).collect(Collectors.toMap(s -> s.getLong("id"), s -> s));
                    entry.stream().forEach(s -> {
                        DynamicObject current = (DynamicObject)dataMap.get(s.getLong("id"));
                        if (current != null) {
                            newEntry.add(current);
                        } else {
                            newEntry.add(s);
                        }
                    });
                    ExchangeRateShareSceneHelper.saveOlap4Rows(newEntry, (boolean)false, (FixedItem)ctx, null, (OlapSourceEnum)OlapSourceEnum.M1);
                }
                if (existTriangle = QueryServiceHelper.exists((String)"bcm_trianglebaseinfo", (QFilter[])(filter = new QFilter(model, "=", (Object)ctx.getModelId())).toArray())) {
                    ExchangeRateShareSceneHelper.calcTriangleRate((FixedItem)ctx);
                }
                if (!this.isCopy) {
                    if (!existTriangle && rateColl.size() != rateIDs.size()) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u5df2\u7565\u8fc7\u90e8\u5206\u7a7a\u884c\u3002", (String)"ExchangeRateMaintainPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u5df2\u91cd\u65b0\u8ba1\u7b97\u4e09\u89d2\u6c47\u7387\u3002", (String)"ExchangeRateMaintainPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                }
                this.getPageCache().put(this.source_rate, SerializationUtils.toJsonString(rateIDs));
                this.getPageCache().remove(this.change_rowId);
                this.writeDetailLog(ResultStatusEnum.SUCCESS.getName());
                ExchangeQueryHelper.clearRateCache((BaseData)new BaseData(this.getContextFixItem(isLeave)));
            }
            catch (Throwable e) {
                tx.markRollback();
                this.writeDetailLog(ResultStatusEnum.FAIL.getName());
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f02\u5e38, %s", (String)"ExchangeRateMaintainPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
        ExchangeQueryHelper.clearRateCache((BaseData)new BaseData(ctx));
    }

    private Map<String, DynamicObject> getNewlyData(FixedItem ctx) {
        QFilter qFilter = new QFilter(model, "=", (Object)ctx.getModelId());
        qFilter.and(new QFilter("fy", "=", (Object)ctx.getFyId()));
        qFilter.and(new QFilter("scene", "=", (Object)ctx.getScenarioId()));
        qFilter.and(new QFilter(period, "=", (Object)ctx.getPeriodId()));
        qFilter.and(new QFilter("entity", "=", (Object)ctx.getEntityId()));
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet();
        DynamicObject[] newData = BusinessDataServiceHelper.load((String)"bcm_exchagerate", (String)String.join((CharSequence)",", fields), (QFilter[])qFilter.toArray());
        this.getPageCache().put(DATABASE_IDS_KEY, ObjectSerialUtil.toByteSerialized((Object)newData));
        Map<String, DynamicObject> originData = Arrays.stream(newData).collect(Collectors.toMap(s -> s.getString("source.number") + "|" + s.getString("target.number"), s -> s, (entity1, entity2) -> entity2));
        return originData;
    }

    private void writeDetailLog(String result) {
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        ArrayList<String> list = new ArrayList<String>(16);
        DynamicObjectCollection dynamicCollection = (DynamicObjectCollection)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(NEW_ENTRY_DATA_KEY));
        DynamicObject[] newData = (DynamicObject[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(DATABASE_IDS_KEY));
        ArrayList<String> sourceIdlist = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : newData) {
            sourceIdlist.add(dynamicObject.getString("id"));
        }
        ArrayList<String> excuteId = new ArrayList<String>(16);
        for (int i = 0; i < dynamicCollection.size(); ++i) {
            DynamicObject dynamic = (DynamicObject)dynamicCollection.get(i);
            String id = dynamic.getString("id");
            if (sourceIdlist.isEmpty()) {
                this.getDetailMessage(allFields, dynamic, list, OpItemEnum.ADD.getName(), result);
                continue;
            }
            if (sourceIdlist.contains(id)) {
                Set changeIndex;
                excuteId.add(id);
                String changeIndexStr = this.getPageCache().get(CHANGE_DATA_INDEX);
                if (StringUtils.isEmpty((CharSequence)changeIndexStr) || !(changeIndex = (Set)ObjectSerialUtil.deSerializedBytes((String)changeIndexStr)).contains(i)) continue;
                this.getDetailMessage(allFields, dynamic, list, OpItemEnum.BTN_EDIT.getName(), result);
                continue;
            }
            if (!this.checkVal(dynamic)) continue;
            this.getDetailMessage(allFields, dynamic, list, OpItemEnum.ADD.getName(), result);
        }
        sourceIdlist.removeAll(excuteId);
        for (DynamicObject dynamicObject : newData) {
            String id = dynamicObject.getString("id");
            if (!sourceIdlist.contains(id)) continue;
            this.getDetailMessage(allFields, dynamicObject, list, OpItemEnum.DELETE.getName(), result);
        }
        this.getPageCache().remove(CHANGE_DATA_INDEX);
        if (!list.isEmpty()) {
            OperationLogUtil.batchWriteOperationLog((IFormView)this.getView(), (String)OpItemEnum.SAVE.getName(), list, (Long)this.getModelId());
        }
    }

    private boolean checkVal(DynamicObject dy) {
        BigDecimal periodend = dy.getBigDecimal("periodend").stripTrailingZeros();
        BigDecimal average = dy.getBigDecimal("average").stripTrailingZeros();
        BigDecimal userdefine = dy.getBigDecimal("userdefine").stripTrailingZeros();
        return periodend.compareTo(BigDecimal.ZERO) + average.compareTo(BigDecimal.ZERO) + userdefine.compareTo(BigDecimal.ZERO) > 0;
    }

    private String operateLogPrefix(String orgNodeId) {
        return (String)ThreadCache.get((Object)("rate_" + orgNodeId), () -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)LongUtil.toLong((Object)orgNodeId));
            DynamicObject scenarioDyn = (DynamicObject)this.getModel().getValue(scene);
            DynamicObject yearDyn = (DynamicObject)this.getModel().getValue(year);
            DynamicObject periodDyn = (DynamicObject)this.getModel().getValue(period);
            StringBuilder prefix = new StringBuilder(" ");
            prefix.append(node.getNumber()).append(" ").append(scenarioDyn.getString("number")).append(" ").append(yearDyn.getString("number")).append(" ").append(periodDyn.getString("number"));
            return prefix.toString();
        });
    }

    private void getDetailMessage(Map<String, IDataEntityProperty> allFields, DynamicObject dynamic, List<String> list, String op, String result) {
        StringBuilder sb = new StringBuilder();
        sb.append(op).append(this.operateLogPrefix(this.getPageCache().get(this.treeNode_CacheId))).append('\uff1a');
        DynamicObject sourceTmp = dynamic.getDynamicObject("source");
        String sourceTitle = allFields.get("source").getDisplayName().getLocaleValue_zh_CN();
        sb.append(sourceTitle).append(" ");
        if (sourceTmp != null) {
            OrmLocaleValue source = (OrmLocaleValue)sourceTmp.get("name");
            sb.append(source.getLocaleValue_zh_CN());
        } else {
            sb.append(" ");
        }
        sb.append(" -> ");
        DynamicObject targetTmp = dynamic.getDynamicObject("target");
        String targetTitle = allFields.get("target").getDisplayName().getLocaleValue_zh_CN();
        sb.append(targetTitle).append(" ");
        if (targetTmp != null) {
            OrmLocaleValue target = (OrmLocaleValue)targetTmp.get("name");
            sb.append(target.getLocaleValue_zh_CN());
        } else {
            sb.append(" ");
        }
        sb.append("\uff0c");
        String periodend = dynamic.getBigDecimal("periodend").stripTrailingZeros().toPlainString();
        String periodendTitle = allFields.get("periodend").getDisplayName().getLocaleValue_zh_CN();
        sb.append(periodendTitle).append(" ").append(periodend).append('\uff0c');
        String average = dynamic.getBigDecimal("average").stripTrailingZeros().toPlainString();
        String averageTitle = allFields.get("average").getDisplayName().getLocaleValue_zh_CN();
        sb.append(averageTitle).append(" ").append(average).append('\uff0c');
        String userdefine = dynamic.getBigDecimal("userdefine").stripTrailingZeros().toPlainString();
        String userdefineTitle = allFields.get("userdefine").getDisplayName().getLocaleValue_zh_CN();
        sb.append(userdefineTitle).append(" ").append(userdefine).append("\uff0c");
        String precision = dynamic.getBigDecimal("precision").stripTrailingZeros().toPlainString();
        String precisionTitle = allFields.get("precision").getDisplayName().getLocaleValue_zh_CN();
        sb.append(precisionTitle).append(" ").append(precision);
        Long modelId = this.getModelId();
        for (DynamicObject obj : ExchangeRateMaintainPlugin.getUserDefineRate(modelId)) {
            String number = obj.getString("number").toLowerCase(Locale.ENGLISH);
            String value = dynamic.getBigDecimal(number).stripTrailingZeros().toPlainString();
            String title = obj.getString("name");
            sb.append(title).append(" ").append(value).append("\uff0c");
        }
        sb.append("\uff0c").append(result);
        list.add(sb.toString());
    }

    public void cellClick(CellClickEvent arg0) {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExchangeRateMaintainPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (arg0.getRow() < 0) {
            return;
        }
        DynamicObject row = this.getModel().getEntryRowEntity(entryentity, arg0.getRow());
        if (row == null) {
            return;
        }
        ResultBox box = this.checkPeriodIsOpen();
        if (box.isError()) {
            this.getView().showTipNotification(box.getMessageText());
            return;
        }
        if ((row.getLong("fromid") != 0L || StringUtils.isNotEmpty((CharSequence)row.getString("triangle"))) && !"0".equals(arg0.getFieldKey())) {
            this.getPageCache().put("selected", ObjectSerialUtil.toByteSerialized((Object)new int[]{arg0.getRow()}));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539\u4e92\u7b97\u6216\u4e09\u89d2\u8ba1\u7b97\u5f97\u5230\u7684\u6c47\u7387\u503c\u3002", (String)"ExchangeRateMaintainPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (arg0.getFieldKey()) {
            case "source": {
                if (!row.getBoolean("mutual")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6c47\u7387\u8bb0\u5f55\u5df2\u4e92\u7b97\u5f97\u5230\u5176\u4ed6\u6c47\u7387\u8bb0\u5f55\uff0c\u4e0d\u53ef\u4fee\u6539\u5f53\u524d\u6c47\u7387\u8bb0\u5f55\u7684\u539f\u5e01\u548c\u76ee\u6807\u5e01\u3002", (String)"ExchangeRateMaintainPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            case "target": {
                if (!row.getBoolean("mutual")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6c47\u7387\u8bb0\u5f55\u5df2\u4e92\u7b97\u5f97\u5230\u5176\u4ed6\u6c47\u7387\u8bb0\u5f55\uff0c\u4e0d\u53ef\u4fee\u6539\u5f53\u524d\u6c47\u7387\u8bb0\u5f55\u7684\u539f\u5e01\u548c\u76ee\u6807\u5e01\u3002", (String)"ExchangeRateMaintainPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            case "mutual": {
                DynamicObject sourceObject = (DynamicObject)row.get("source");
                DynamicObject targetObject = (DynamicObject)row.get("target");
                if (sourceObject != null && targetObject != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u5e01\u6216\u76ee\u6807\u5e01\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u6267\u884c\u6c47\u7387\u4e92\u7b97\u3002", (String)"ExchangeRateMaintainPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    private QFilter getDimPermissonFilter(Long modelId, String entityid) {
        QFilter permissonFilter;
        QFilter modelFilter = new QFilter(model, "=", (Object)modelId);
        QFilter filter = new QFilter("memberform", "=", (Object)entityid);
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,memberform", (QFilter[])new QFilter[]{modelFilter, filter});
        if (dimObj != null && (permissonFilter = SingleMemberF7Util.getPermissionFilter(entityid, dimObj.getLong("id"), modelId)) != null) {
            modelFilter = modelFilter.and(permissonFilter);
        }
        return modelFilter;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object status = evt.getReturnData() == null ? null : evt.getReturnData();
        switch (evt.getActionId()) {
            case "sourcef7": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
                if (rows == null || rows.isEmpty()) {
                    return;
                }
                this.getPageCache().remove("isCurrencyActive");
                this.getModel().setItemValueByID("source", rows.get(0).getPrimaryKeyValue(), this.getModel().getEntryCurrentRowIndex(entryentity));
                break;
            }
            case "targetf7": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
                if (rows == null || rows.isEmpty()) {
                    return;
                }
                this.getPageCache().remove("isCurrencyActive");
                this.getModel().setItemValueByID("target", rows.get(0).getPrimaryKeyValue(), this.getModel().getEntryCurrentRowIndex(entryentity));
                break;
            }
            case "bcm_exchangerateplan_edit": {
                if (status == null) {
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ExchangeRateMaintainPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refreshRateTree();
                TreeView tv = (TreeView)this.getControl(RATETREE);
                String nodeid = this.getPageCache().get(this.treeNode_CacheId);
                if (OperationStatus.ADDNEW.equals(status)) {
                    nodeid = this.getLastRatePlan().getString("id");
                    this.getPageCache().put(this.treeNode_CacheId, nodeid);
                    tv.focusNode(new TreeNode("", nodeid, ""));
                }
                tv.treeNodeClick("", nodeid);
                this.refreshEntryEntity();
                break;
            }
            case "import_callback": {
                this.refreshEntryEntity();
                ExchangeQueryHelper.clearRateCache((BaseData)new BaseData(this.getContextFixItem(Boolean.FALSE)));
                break;
            }
            case "bcm_exchagerate": {
                if (status == null) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"ExchangeRateMaintainPlugin_65", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refreshRateTree();
                this.refreshEntryEntity();
                ExchangeQueryHelper.clearRateCache((BaseData)new BaseData(this.getContextFixItem(Boolean.FALSE)));
                break;
            }
            case "btn_sysimport": {
                String data = (String)evt.getReturnData();
                if (StringUtils.isEmpty((CharSequence)data)) break;
                List ids = (List)ObjectSerialUtil.deSerializedBytes((String)data);
                this.importExchangeRateFromSys(ids);
                break;
            }
        }
    }

    private void importExchangeRateFromSys(List<Long> ids) {
        Map importData = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"bd_exrate_tree");
        HashBasedTable table = HashBasedTable.create();
        Map rateImportFieldMapping = ExchageRateServiceHelper.getRateImportFieldMapping((long)this.getModelId());
        importData.values().forEach(arg_0 -> ExchangeRateMaintainPlugin.lambda$importExchangeRateFromSys$19(rateImportFieldMapping, (Table)table, arg_0));
        QFilter qFilter = this.getFilter(false);
        qFilter.and("source.number", "in", (Object)table.rowKeySet());
        qFilter.and("target.number", "in", (Object)table.columnKeySet());
        if (QueryServiceHelper.exists((String)"bcm_exchagerate", (QFilter[])qFilter.toArray())) {
            this.getPageCache().put(SYS_IMPORT_TABLE, ObjectSerialUtil.toByteSerialized((Object)table));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8986\u76d6\u5df2\u7ecf\u5b58\u5728\u7684\u539f\u5e01\u5230\u76ee\u6807\u5e01\u6c47\u7387\u6570\u636e\uff1f", (String)"ExchangeRateMaintainPlugin_72", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close_override_confirm", (IFormPlugin)this));
        } else {
            FixedItem context = this.getContextFixItem(Boolean.FALSE);
            ResultBox box = ExchageRateServiceHelper.sysImportRate((FixedItem)context, (Table)table);
            StringBuilder sb = new StringBuilder(this.getContextFixItem(Boolean.FALSE).getInfo());
            if (box.isSuccess()) {
                sb.append(ResManager.loadKDString((String)"\u6210\u529f", (String)"ExchangeRateMaintainPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u5b8c\u6210\u3002", (String)"ExchangeRateMaintainPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ece\u7cfb\u7edf\u5bfc\u5165", (String)"ExchangeRateMaintainPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                this.writeOperationLog(ResManager.loadKDString((String)"\u4ece\u7cfb\u7edf\u5bfc\u5165", (String)"ExchangeRateMaintainPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString());
            } else {
                sb.append(ResManager.loadKDString((String)"\u5931\u8d25", (String)"ExchangeRateMaintainPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\u3002", (String)"ExchangeRateMaintainPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ece\u7cfb\u7edf\u5bfc\u5165", (String)"ExchangeRateMaintainPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                sb.append(box.getMessageText());
                this.writeOperationLog(ResManager.loadKDString((String)"\u4ece\u7cfb\u7edf\u5bfc\u5165", (String)"ExchangeRateMaintainPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString());
            }
            this.refreshEntryEntity();
            ExchangeQueryHelper.clearRateCache((BaseData)new BaseData(this.getContextFixItem(Boolean.FALSE)));
        }
    }

    private static DynamicObjectCollection getUserDefineRate(Long modelId) {
        DynamicObjectCollection collection = ExchangeRateShareSceneHelper.getUserDefinedRateAccount((Long)modelId);
        return collection;
    }

    private void checkAndSave(String entity) {
        int[] selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selected"));
        this.getPageCache().put("isCurrencyActive", "true");
        DynamicObject row = this.getModel().getEntryRowEntity(entryentity, selected[0]);
        DynamicObject sourceObject = (DynamicObject)row.get("source");
        DynamicObject targetObject = (DynamicObject)row.get("target");
        if (sourceObject != null && targetObject != null) {
            if (sourceObject.getString("number").equals(targetObject.getString("number"))) {
                this.getModel().setValue(entity, (Object)this.getPageCache().get("f7oldvalue"), selected[0]);
                this.updateEntry(false);
                this.getView().showMessage(ResManager.loadKDString((String)"\u539f\u5e01\u548c\u76ee\u6807\u5e01\u4e0d\u53ef\u76f8\u540c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6210\u5458\u540e\u91cd\u8bd5\u3002", (String)"ExchangeRateMaintainPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkRepetition(sourceObject.getLong("id"), targetObject.getLong("id"), selected[0]).booleanValue()) {
                this.getModel().setValue(entity, (Object)this.getPageCache().get("f7oldvalue"), selected[0]);
                this.updateEntry(false);
                this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6210\u5458\u540e\u91cd\u8bd5\u3002", (String)"ExchangeRateMaintainPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.updateEntry(true);
        }
    }

    private Boolean checkRepetition(Long sourceid, Long targetid, int currentrow) {
        DynamicObjectCollection entryentitycolls = this.getModel().getEntryEntity(entryentity);
        for (DynamicObject rowObj : entryentitycolls) {
            DynamicObject sourceObj = (DynamicObject)rowObj.get("source");
            DynamicObject targetObj = (DynamicObject)rowObj.get("target");
            if (sourceObj == null || targetObj == null || !sourceid.equals(sourceObj.getLong("id")) || !targetid.equals(targetObj.getLong("id")) || currentrow + 1 == rowObj.getInt("seq")) continue;
            return true;
        }
        return false;
    }

    private DynamicObject getReversionRow(int rowIndex, String operation) {
        DynamicObject row = this.getModel().getEntryRowEntity(entryentity, rowIndex);
        DynamicObject sourceObject = (DynamicObject)row.get("source");
        DynamicObject targetObject = (DynamicObject)row.get("target");
        if (sourceObject != null && targetObject != null) {
            DynamicObjectCollection entryentitycolls = this.getModel().getEntryEntity(entryentity);
            for (DynamicObject rowObj : entryentitycolls) {
                DynamicObject sourceObj = (DynamicObject)rowObj.get("source");
                DynamicObject targetObj = (DynamicObject)rowObj.get("target");
                if (sourceObj == null || targetObj == null) continue;
                Boolean flag = Objects.nonNull(operation) && "insertMutual".equals(operation);
                Boolean flag2 = Objects.nonNull(operation) && "deleteRelateRow".equals(operation);
                if (!sourceObject.getString("number").equals(targetObj.getString("number")) || !targetObject.getString("number").equals(sourceObj.getString("number")) || !flag.booleanValue() && (!flag2.booleanValue() || rowObj.getLong("fromid") != 0L) && !rowObj.getBoolean("mutual") && (!Objects.nonNull(operation) || !"deleterows".equals(operation) || rowObj.getLong("fromid") == 0L)) continue;
                return rowObj;
            }
        }
        return null;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long rateOrgId;
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(dimKeys, true);
        this.refreshRateTree();
        DynamicObject[] result = this.refreshEntryEntity();
        if (!this.checkHasRealData(result)) {
            this.copy();
        }
        if ((rateOrgId = this.getCurPresetRateId(this.getModelId())) != 0L) {
            this.getPageCache().put(this.sysNode_CacheId, rateOrgId.toString());
        }
    }

    private void resetBeginCols() {
        boolean isUpdateRate = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM009");
        if (isUpdateRate) {
            this.getView().setEnable(Boolean.TRUE, -1, BEGINRATE_TYPE);
        } else {
            this.getView().setEnable(Boolean.FALSE, -1, BEGINRATE_TYPE);
        }
    }

    private void initRateTree() {
        String modelIdStr = this.getPageCache().get("KEY_MODEL_ID");
        Long modelId = LongUtil.toLong((Object)modelIdStr);
        if (modelId == 0L) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(RATETREE);
        if (treeView == null) {
            return;
        }
        this.initPermCache();
        DynamicObjectCollection collection = this.getAllRateSchema(modelId);
        String showType = this.getModel().getValue(SHOWTYPE).toString();
        OrgTreeNode root = RateSchemeServiceHelper.buildLeftTree((DynamicObjectCollection)collection, (TreeView)treeView, (String)showType);
        List children = root.getChildren();
        if (children.size() == 0) {
            return;
        }
        String orgNodeId = this.getPageCache().get(this.treeNode_CacheId);
        if (StringUtils.isEmpty((CharSequence)orgNodeId)) {
            orgNodeId = ((ITreeNode)children.get(0)).getId();
            this.getPageCache().put(this.treeNode_CacheId, orgNodeId);
        } else {
            if (!QueryServiceHelper.exists((String)"bcm_entitymembertree", (Object)LongUtil.toLong((Object)orgNodeId))) {
                this.getPageCache().remove(this.treeNode_CacheId);
                this.refreshRateTree();
                this.refreshEntryEntity();
                return;
            }
            Optional<ITreeNode> node = children.stream().filter(s -> Objects.equals(this.getPageCache().get(this.treeNode_CacheId), s.getId())).findFirst();
            if (!node.isPresent()) {
                orgNodeId = ((ITreeNode)children.get(0)).getId();
                this.getPageCache().put(this.treeNode_CacheId, orgNodeId);
            }
        }
        this.updateShareSceneCache(orgNodeId);
        if (StringUtils.isNotEmpty((CharSequence)orgNodeId)) {
            OrgTreeNode focusNode = (OrgTreeNode)root.getTreeNode(orgNodeId, 10);
            String parentId = focusNode.getParent() == null ? "0" : focusNode.getParent().getId();
            treeView.focusNode(new TreeNode(parentId, focusNode.getId(), focusNode.getNumber()));
        }
        TreeModel treemodel = new TreeModel((ITreeNode)root);
        this.getPageCache().put(CacheTree, ObjectSerialUtil.toByteSerialized((Object)treemodel));
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)new TreeNode("", root.getId(), root.getNumber())));
    }

    private Long getCurPresetRateId(Long modelId) {
        return (Long)ThreadCache.get((Object)(modelId + "curPreset"), () -> {
            QFilter filter = new QFilter(model, "=", (Object)modelId);
            QFilter filter1 = new QFilter("number", "=", (Object)"RatePreset");
            DynamicObject rateOrg = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{filter, filter1});
            return rateOrg == null ? 0L : rateOrg.getLong("id");
        });
    }

    private DynamicObjectCollection getAllRateSchema(Long modelId) {
        Set noPermIds;
        QFBuilder qfBuilder = new QFBuilder(model, "=", (Object)modelId);
        qfBuilder.and(new QFilter("isexchangerate", "=", (Object)true));
        if (!"1".equals(this.getPageCache().get(KEY_ADMINUSERBOL)) && !CollectionUtils.isEmpty((Collection)(noPermIds = this.getPermList(KEY_NOPERMRATE)))) {
            qfBuilder.and(new QFilter("id", "not in", (Object)noPermIds));
        }
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,longnumber,level,parent.id as parent_id,issharescene", (QFilter[])qfBuilder.toArray(), (String)"dseq");
        return dcs;
    }

    private Set getPermList(String permFlag) {
        Long modelId = this.getModelId();
        ArrayListMultimap tmplPermMap = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_entitymembertree", (String)String.valueOf(modelId), (String)RequestContext.get().getUserId());
        HashSet ids = new HashSet(16);
        if (KEY_NOPERMRATE.equals(permFlag)) {
            ids.addAll(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()));
        } else if (KEY_READONLYRATE.equals(permFlag)) {
            ids.addAll(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue()));
        } else if (KEY_READWRITERATE.equals(permFlag)) {
            ids.addAll(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READWRITE.getValue()));
        }
        return ids;
    }

    private void initPermCache() {
        Long modelId = this.getModelId();
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId));
        if (adminUserBol) {
            this.getPageCache().put(KEY_ADMINUSERBOL, "1");
        } else {
            ArrayListMultimap tmplPermMap = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_entitymembertree", (String)String.valueOf(modelId), (String)RequestContext.get().getUserId());
            Long orgId = LongUtil.toLong((Object)this.getPageCache().get(this.treeNode_CacheId));
            if (tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()).contains(orgId)) {
                this.getPageCache().remove(this.treeNode_CacheId);
            }
        }
    }

    private DynamicObject getLastRatePlan() {
        QFilter filter1 = new QFilter(model, "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")));
        QFilter filter2 = new QFilter("isexchangerate", "=", (Object)true);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,dseq", (QFilter[])new QFilter[]{filter1, filter2}, (String)"dseq desc");
        return (DynamicObject)dcs.get(0);
    }

    private void refreshRateTree() {
        this.initRateTree();
    }

    private void filterChange() {
        String prop = this.getPageCache().get("propName");
        if (StringUtils.isEmpty((CharSequence)prop)) {
            return;
        }
        DynamicObject newValue = null;
        if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get("newValue"))) {
            newValue = (DynamicObject)ObjectSerialUtil.deSerializedToDynaObj((String)this.getPageCache().get("entityNumber"), (String)this.getPageCache().get("newValue"));
        }
        switch (prop) {
            case "model": {
                this.propertyChangedModelUse(dimKeys);
                if (newValue == null) break;
                this.getModel().deleteEntryData(entryentity);
                this.getPageCache().put(entryentity, SerializationUtils.serializeToBase64((Object)this.getModel().getEntryEntity(entryentity)));
                this.setUserdefinedrateVisible();
                this.getPageCache().remove(this.treeNode_CacheId);
                this.refreshRateTree();
                break;
            }
            default: {
                Boolean isSureReturn = this.propertyChangedDimUse(this.getPageCache().get("propName"), newValue, true, false);
                if (!isSureReturn.booleanValue()) {
                    return;
                }
                if (!scene.equalsIgnoreCase(this.getPageCache().get("propName"))) break;
                this.updateShareSceneCache(this.getPageCache().get(this.treeNode_CacheId));
            }
        }
        this.releaseAndrequireLock();
        DynamicObject[] result = this.refreshEntryEntity();
        if (!this.checkHasRealData(result)) {
            this.copy();
        }
    }

    private boolean checkHasRealData(DynamicObject[] result) {
        if (result == null) {
            return false;
        }
        String[] allRateColumnsOlap = ExchangeRateShareSceneHelper.getAllrateColumns((Long)this.getModelId(), (String[])this.rateColumns4Olap).toArray(new String[0]);
        for (DynamicObject dy : result) {
            for (String s : allRateColumnsOlap) {
                BigDecimal value = (BigDecimal)dy.get(s);
                if (value.compareTo(BigDecimal.ZERO) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private String getEntityNumber(String key, Long dimId) {
        if (model.equals(key)) {
            return "bcm_model";
        }
        DynamicObject dy = QueryDimensionServiceHelper.getMsgByDimId((Object)dimId);
        return dy.getString("membermodel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        int[] selected;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        this.getPageCache().remove("isChangeModel");
        if (model.equals(propName) || scene.equals(propName) || year.equals(propName) || period.equals(propName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (this.getPageCache().get("newValueIsNull") != null) {
                this.getPageCache().remove("newValueIsNull");
                return;
            }
            if (newValue == null && oldValue != null) {
                this.getPageCache().put("newValueIsNull", "true");
                this.getModel().getDataEntity().set(propName, (Object)oldValue);
                return;
            }
            this.getPageCache().put("propName", propName);
            if (model.equals(propName)) {
                this.getPageCache().put("isChangeModel", "true");
                this.getPageCache().put("entityNumber", newValue == null ? null : "bcm_model");
            } else {
                this.getPageCache().put("entityNumber", newValue == null ? null : this.getEntityNumber(propName, newValue.getLong("dimension.id")));
            }
            this.getPageCache().put("newValue", newValue == null ? null : ObjectSerialUtil.toSerializedToDynaObj((DynamicObject)newValue));
            if (oldValue != null) {
                this.getPageCache().put("oldValue_id", oldValue.getString("id"));
                this.getPageCache().put("oldValue_number", oldValue.getString("number"));
            }
            if (this.getEntryEntityDataChange().booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u6c47\u7387\u6570\u636e\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ExchangeRateMaintainPlugin_73", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("propertyChanged_save_confirm", (IFormPlugin)this));
            } else {
                this.filterChange();
            }
        } else if ("source".equals(propName) || "target".equals(propName)) {
            this.getPageCache().put("currecyentity", propName);
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject rowNew = (DynamicObject)changeData.getNewValue();
            DynamicObject rowOld = (DynamicObject)changeData.getOldValue();
            String type = this.getPageCache().get("isCurrencyActive");
            if (rowNew == null) {
                this.updateEntry(false);
            } else if (type == null) {
                String oldValue = rowOld == null ? null : rowOld.getString("id");
                this.getPageCache().put("f7oldvalue", oldValue);
                try {
                    this.checkAndSave(propName);
                }
                finally {
                    this.getPageCache().remove("isCurrencyActive");
                }
            }
        } else if (ExchangeRateShareSceneHelper.getAllrateColumns((Long)this.getModelId(), (String[])this.rateColumns).contains(propName)) {
            selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selected"));
            if (selected.length > 0) {
                DynamicObject row = this.getModel().getEntryRowEntity(entryentity, selected[0]);
                this.getModel().beginInit();
                this.getModel().setValue(propName, (Object)row.getBigDecimal(propName).setScale(row.getInt("precision"), RoundingMode.HALF_UP), row.getInt("seq") - 1);
                if (row.getBoolean("mutual")) {
                    DynamicObject reversionRow = this.getReversionRow(selected[0], "");
                    if (row.getLong("fromid") == 0L && reversionRow != null) {
                        this.getModel().setValue(propName, (Object)this.getReciprocal(row.getBigDecimal(propName), row.getInt("precision")), reversionRow.getInt("seq") - 1);
                        this.updateOnlyOneCell((IClientViewProxy)this.getView().getService(IClientViewProxy.class), entryentity, propName, this.getReciprocal(row.getBigDecimal(propName), row.getInt("precision")), reversionRow.getInt("seq") - 1);
                    }
                }
                this.getModel().endInit();
            }
        } else if ("precision".equals(propName)) {
            selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selected"));
            Long modelId = this.getModelId();
            boolean isUpdateRate = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM009");
            ArrayList beginCols = Lists.newArrayList((Object[])new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate"});
            if (selected.length > 0) {
                DynamicObject row = this.getModel().getEntryRowEntity(entryentity, selected[0]);
                int newprecision = (Integer)e.getChangeSet()[0].getNewValue();
                this.getModel().beginInit();
                this.setRatePrecision(row, newprecision, isUpdateRate, beginCols);
                DynamicObject reversionRow = this.getReversionRow(selected[0], "");
                if (row.getLong("fromid") == 0L && reversionRow != null) {
                    this.getModel().setValue("precision", (Object)newprecision, reversionRow.getInt("seq") - 1);
                    List allRateColumns = ExchangeRateShareSceneHelper.getAllrateColumns((Long)modelId, (String[])this.rateColumns);
                    for (String property : allRateColumns) {
                        if (!isUpdateRate && beginCols.stream().anyMatch(p -> property.toLowerCase(Locale.ENGLISH).startsWith((String)p))) continue;
                        this.getModel().setValue(property, (Object)this.getReciprocal(row.getBigDecimal(property), newprecision), reversionRow.getInt("seq") - 1);
                    }
                }
                this.getModel().endInit();
                this.updateEntry(true);
            }
        } else if ("mutual".equals(propName)) {
            Boolean isMutual = (Boolean)e.getChangeSet()[0].getNewValue();
            int[] selected2 = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selected"));
            if (selected2.length > 0) {
                DynamicObject row = this.getModel().getEntryRowEntity(entryentity, selected2[0]);
                DynamicObject sourceObject = (DynamicObject)row.get("source");
                DynamicObject targetObject = (DynamicObject)row.get("target");
                if (sourceObject != null && targetObject != null) {
                    DynamicObject reversionRow = this.getReversionRow(selected2[0], "insertMutual");
                    if (isMutual.booleanValue()) {
                        if (reversionRow == null) {
                            this.insertRow(selected2[0], row, sourceObject, targetObject);
                            String json = this.getPageCache().get(this.change_rowId);
                            if (json != null) {
                                HashSet newIdSet = new HashSet();
                                Set idSet = (Set)SerializationUtils.fromJsonString((String)json, Set.class);
                                idSet.forEach(id -> {
                                    if (id > selected2[0]) {
                                        id = id + 1;
                                        newIdSet.add(id);
                                    } else {
                                        newIdSet.add(id);
                                    }
                                });
                                this.getPageCache().put(this.change_rowId, SerializationUtils.toJsonString(newIdSet));
                            }
                        } else {
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u76ee\u6807\u5e01\u5bf9\u539f\u5e01\u7684\u6c47\u7387\u66ff\u6362\u4e3a\u4e92\u7b97\u5f97\u5230\u7684\u6c47\u7387\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ExchangeRateMaintainPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("mutualcover_confirm", (IFormPlugin)this));
                        }
                    } else {
                        if (reversionRow != null) {
                            this.getModel().deleteEntryRow(entryentity, reversionRow.getInt("seq") - 1);
                            String json = this.getPageCache().get(this.change_rowId);
                            if (json != null) {
                                HashSet newIdSet = new HashSet();
                                Set idSet = (Set)SerializationUtils.fromJsonString((String)json, Set.class);
                                idSet.forEach(id -> {
                                    if (id > selected2[0]) {
                                        id = id - 1;
                                        newIdSet.add(id);
                                    } else {
                                        newIdSet.add(id);
                                    }
                                });
                                this.getPageCache().put(this.change_rowId, SerializationUtils.toJsonString(newIdSet));
                            }
                        }
                        this.setCellEnable(new String[]{"source", "target"}, true, row.getInt("seq") - 1);
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u539f\u5e01\u548c\u76ee\u6807\u5e01\u3002", (String)"ExchangeRateMaintainPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (SHOWTYPE.equals(propName)) {
            String showType = (String)this.getModel().getValue(SHOWTYPE);
            this.getPageCache().put(SHOWTYPE, showType);
            this.refreshRateTree();
        }
        if (!(model.equals(propName) || scene.equals(propName) || year.equals(propName) || period.equals(propName) || (changeSet = e.getChangeSet()).length <= 0)) {
            ChangeData changeData = changeSet[0];
            int currentRowIndex = changeData.getRowIndex();
            String json = this.getPageCache().get(this.change_rowId);
            Set idSet = json != null ? (Set)SerializationUtils.fromJsonString((String)json, Set.class) : new HashSet();
            idSet.add(currentRowIndex);
            this.getPageCache().put(this.change_rowId, SerializationUtils.toJsonString(idSet));
        }
    }

    private void updateOnlyOneCell(IClientViewProxy proxy, String entryKey, String propertyName, Object val, int i) {
        this.updateCell(proxy, entryKey, propertyName, val, i);
        this.getPageCache().put("selected", ObjectSerialUtil.toByteSerialized((Object)new int[]{this.getModel().getEntryCurrentRowIndex(entryentity)}));
    }

    private BigDecimal getReciprocal(BigDecimal rate, int precision) {
        return rate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(precision, RoundingMode.HALF_UP) : BigDecimal.ONE.divide(rate, precision, RoundingMode.HALF_UP);
    }

    private void insertRow(int oldrow, DynamicObject row, DynamicObject sourceObject, DynamicObject targetObject) {
        this.getModel().beginInit();
        Long modelId = this.getModelId();
        int newrow = this.getModel().insertEntryRow(entryentity, oldrow + 1);
        DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, newrow);
        rowObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        rowObj.set("source", (Object)BusinessDataServiceHelper.loadSingle((String)"bcm_processmembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter(model, "=", (Object)modelId), new QFilter("number", "=", (Object)targetObject.getString("number"))}));
        rowObj.set("target", (Object)BusinessDataServiceHelper.loadSingle((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter(model, "=", (Object)modelId), new QFilter("number", "=", (Object)sourceObject.getString("number"))}));
        List allRateColumns = ExchangeRateShareSceneHelper.getAllrateColumns((Long)modelId, (String[])this.rateColumns);
        boolean isUpdateRate = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM009");
        ArrayList beginCols = Lists.newArrayList((Object[])new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate"});
        for (String property : allRateColumns) {
            if (!isUpdateRate && beginCols.stream().anyMatch(s -> property.toLowerCase(Locale.ENGLISH).startsWith((String)s))) continue;
            rowObj.set(property, (Object)this.getReciprocal(row.getBigDecimal(property), row.getInt("precision")));
        }
        rowObj.set("precision", (Object)row.getInt("precision"));
        rowObj.set("mutual", (Object)true);
        rowObj.set("fromid", (Object)row.getLong("id"));
        String scenes = this.getPageCache().get(SHARESCENE);
        if (StringUtils.isNotEmpty((CharSequence)scenes)) {
            rowObj.set(SHARESCENE, (Object)scenes);
        }
        this.getModel().endInit();
        this.getPageCache().put("selected", ObjectSerialUtil.toByteSerialized((Object)new int[]{newrow}));
        this.updateEntry(false);
    }

    private void deleterows() {
        int[] selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selected"));
        HashMap<Integer, DynamicObject> map = new HashMap<Integer, DynamicObject>();
        IntStream.Builder deletes = IntStream.builder();
        for (int i = selected.length - 1; i >= 0; --i) {
            DynamicObject row = this.getModel().getEntryRowEntity(entryentity, selected[i]);
            if (row == null) continue;
            DynamicObject reversionRow = this.getReversionRow(selected[i], "deleterows");
            map.put(selected[i], row);
            if (row.getLong("fromid") == 0L) {
                if (reversionRow == null) continue;
                map.put(reversionRow.getInt("seq") - 1, reversionRow);
                continue;
            }
            this.getModel().beginInit();
            if (reversionRow != null) {
                this.getModel().setValue("mutual", (Object)false, reversionRow.getInt("seq") - 1);
            }
            this.getModel().endInit();
        }
        if (!map.isEmpty()) {
            map.keySet().forEach(deletes::add);
            this.getModel().deleteEntryRows(entryentity, deletes.build().toArray());
        }
        this.updateEntry(true);
    }

    private int deleteRelateRow(int rowIndex) {
        DynamicObject row = this.getReversionRow(rowIndex, "deleteRelateRow");
        if (row == null) {
            return -1;
        }
        this.getModel().deleteEntryRow(entryentity, row.getInt("seq") - 1);
        return rowIndex < row.getInt("seq") ? rowIndex : rowIndex - 1;
    }

    private DynamicObject getUser() {
        RequestContext tx = RequestContext.get();
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)tx.getUserId());
        return user;
    }

    private QFilter getFilter(boolean isLastPeriod) {
        QFilter[] qfs;
        QFilter filter = null;
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelid)) {
            return new QFilter("1", "=", (Object)0L);
        }
        filter = new QFilter(model, "=", (Object)LongUtil.toLong((Object)modelid));
        String entityId = this.getPageCache().get(this.treeNode_CacheId);
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), scene);
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), year);
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), period);
        if (StringUtils.isEmpty((CharSequence)yearId) || StringUtils.isEmpty((CharSequence)periodId)) {
            return new QFilter("1", "=", (Object)0L);
        }
        filter = ExchangeRateShareSceneHelper.isInRateShare((String)entityId, (String)sceneId) != false ? filter.and(new QFilter("scene", "=", (Object)0L)) : filter.and(new QFilter("scene", "=", (Object)LongUtil.toLong((Object)sceneId)));
        String type = PeriodTypeEnum.CURRENT.getIndex();
        if (isLastPeriod) {
            type = PeriodTypeEnum.PRE.getIndex();
        }
        QFBuilder builder = QCfilterUtils.getFyAndPeriodFilter((String)modelid, (String)yearId, (String)periodId, (String)type);
        for (QFilter qf : qfs = builder.toArray()) {
            filter.and(qf);
        }
        String treenodeid = this.getPageCache().get(this.treeNode_CacheId);
        filter = filter.and(new QFilter("entity", "=", (Object)LongUtil.toLong((Object)treenodeid)));
        return filter;
    }

    private DynamicObject[] refreshEntryEntity() {
        this.getModel().beginInit();
        this.setUserdefinedrateVisible();
        this.getModel().deleteEntryData(entryentity);
        String scenes = this.getPageCache().get(SHARESCENE);
        DynamicObject[] sourceRates = BusinessDataServiceHelper.load((String)"bcm_exchagerate", (String)(this.searchColumns + this.getSearchrateColumns()), (QFilter[])new QFilter[]{this.getFilter(false)}, (String)"eseq");
        HashSet<String> ids = new HashSet<String>();
        if (sourceRates != null && sourceRates.length > 0) {
            this.getModel().batchCreateNewEntryRow(entryentity, sourceRates.length);
            List allRateColumns = ExchangeRateShareSceneHelper.getAllrateColumns((Long)this.getModelId(), (String[])this.allColumns);
            for (int i = 0; i < sourceRates.length; ++i) {
                DynamicObject object = sourceRates[i];
                DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, i);
                for (String column : allRateColumns) {
                    rowObj.set(column, object.get(column));
                }
                if (StringUtils.isNotEmpty((CharSequence)scenes)) {
                    rowObj.set(SHARESCENE, (Object)scenes);
                }
                ids.add(object.getString("id"));
            }
        }
        this.getModel().endInit();
        this.updateEntry(true);
        this.updateButtonAndEntryStatus();
        this.getPageCache().put(this.source_rate, SerializationUtils.toJsonString(ids));
        this.getPageCache().put(entryentity, SerializationUtils.serializeToBase64((Object)this.getModel().getEntryEntity(entryentity)));
        return sourceRates;
    }

    private boolean isSkipRow(DynamicObject row) {
        boolean isSlip = true;
        List allRateColumns = ExchangeRateShareSceneHelper.getAllrateColumns((Long)this.getModelId(), (String[])this.rateColumns);
        for (String property : allRateColumns) {
            if (row.get(property) == null || ((BigDecimal)row.get(property)).doubleValue() == 0.0) continue;
            return false;
        }
        return isSlip;
    }

    private String checkRow(DynamicObject row, int i) {
        if (row.get("source") == null || row.get("target") == null) {
            return String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u539f\u5e01\u6216\u76ee\u6807\u5e01\u4e3a\u7a7a\u3002", (String)"ExchangeRateMaintainPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1);
        }
        return "";
    }

    private boolean hasPerm() {
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue(scene);
        return sceneDy != null && PermissionServiceImpl.getInstance((Long)this.getModelId()).isAllWritePerm(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)"Scenario"), "bcm_scenemembertree", Collections.singletonList(sceneDy.getLong("id")));
    }

    private DynamicObject[] copy() {
        ResultBox box = this.checkPeriodIsOpen();
        if (box.isError()) {
            this.getView().showTipNotification(box.getMessageText());
            return null;
        }
        this.getModel().beginInit();
        String searchFields = this.searchColumns + this.getSearchrateColumns();
        DynamicObject[] sourceRates = BusinessDataServiceHelper.load((String)"bcm_exchagerate", (String)searchFields, (QFilter[])new QFilter[]{this.getFilter(true)}, (String)"eseq");
        DynamicObject[] currentRates = BusinessDataServiceHelper.load((String)"bcm_exchagerate", (String)searchFields, (QFilter[])new QFilter[]{this.getFilter(false)}, (String)"eseq");
        HashSet<String> ids = new HashSet<String>();
        if (this.checkHasRealData(sourceRates)) {
            String key;
            HashMap<String, DynamicObject> currentRatesMap = new HashMap<String, DynamicObject>(currentRates.length);
            for (DynamicObject currentRate : currentRates) {
                key = currentRate.getString("source.id") + ":" + currentRate.getString("target.id");
                currentRatesMap.put(key, currentRate);
            }
            ArrayList<DynamicObject> addRows = new ArrayList<DynamicObject>();
            Long modelId = this.getModelId();
            String[] allRateColumnsOlap = ExchangeRateShareSceneHelper.getAllrateColumns((Long)modelId, (String[])this.rateColumns4Olap).toArray(new String[0]);
            boolean isUpdateRate = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM009");
            ArrayList beginCols = Lists.newArrayList((Object[])new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate"});
            for (DynamicObject sourceRate : sourceRates) {
                key = sourceRate.getString("source.id") + ":" + sourceRate.getString("target.id");
                DynamicObject dy = (DynamicObject)currentRatesMap.get(key);
                if (dy != null) {
                    for (String s : allRateColumnsOlap) {
                        Object value;
                        if (!isUpdateRate && beginCols.stream().anyMatch(p -> s.toLowerCase(Locale.ENGLISH).startsWith((String)p)) || (value = sourceRate.get(s)) == null) continue;
                        dy.set(s, value);
                    }
                    continue;
                }
                ExchangeRateCopyServiceHelper.resetBeginRateCols((Long)this.getModelId(), (DynamicObject)sourceRate);
                addRows.add(sourceRate);
            }
            if (addRows.size() > 0) {
                this.getModel().batchCreateNewEntryRow(entryentity, addRows.size());
            }
            int rowNum = 0;
            List allRateCopyColumns = ExchangeRateShareSceneHelper.getAllrateColumns((Long)modelId, (String[])this.allColumns);
            for (DynamicObject object : currentRatesMap.values()) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, rowNum++);
                for (String column : allRateCopyColumns) {
                    rowObj.set(column, object.get(column));
                }
                rowObj.set("modifier", (Object)this.getUser());
                rowObj.set("modifytime", (Object)TimeServiceHelper.now());
                ids.add(rowObj.getString("id"));
            }
            for (int i = 0; i < addRows.size(); ++i) {
                DynamicObject object;
                object = (DynamicObject)addRows.get(i);
                Long id = GlobalIdUtil.genGlobalLongId();
                for (DynamicObject addRow : addRows) {
                    if (object.getLong("id") != addRow.getLong("fromid")) continue;
                    addRow.set("fromid", (Object)id);
                }
                object.set("id", (Object)id);
                DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, rowNum++);
                for (String column : allRateCopyColumns) {
                    rowObj.set(column, object.get(column));
                }
                rowObj.set("modifier", (Object)this.getUser());
                rowObj.set("modifytime", (Object)TimeServiceHelper.now());
                ids.add(rowObj.getString("id"));
            }
            this.isCopy = true;
            this.actionSave(false, true);
            this.refreshEntryEntity();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u5e76\u4fdd\u5b58\u6210\u529f\uff0c\u5f53\u524d\u6c47\u7387\u4ece\u4e0a\u4e00\u671f\u590d\u5236\u5f97\u5230\u3002", (String)"ExchangeRateMaintainPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(entryentity, SerializationUtils.serializeToBase64((Object)this.getModel().getEntryEntity(entryentity)));
            this.getPageCache().put(this.source_rate, SerializationUtils.toJsonString(ids));
        }
        this.getModel().endInit();
        this.updateEntry(true);
        return sourceRates;
    }

    private List<String> getUserdefinedrateList(boolean lowcase) {
        ArrayList<String> result = new ArrayList<String>(20);
        String userdefinedrate = lowcase ? "userdefinedrate" : "UserdefinedRate";
        String bOYUserdefinedRate = lowcase ? "boyuserdefinedrate" : "BOYUserdefinedRate";
        for (int j = 1; j <= 10; ++j) {
            result.add(userdefinedrate + j);
        }
        for (int i = 1; i <= 10; ++i) {
            result.add(bOYUserdefinedRate + i);
        }
        return result;
    }

    private void setUserdefinedrateVisible() {
        this.getUserdefinedrateList(true).forEach(item -> this.getView().setVisible(Boolean.valueOf(false), new String[]{item}));
        DynamicObjectCollection defineDyc = ExchangeRateShareSceneHelper.getAllRateAccount((Long)this.getModelId());
        if (defineDyc != null && defineDyc.size() > 0) {
            defineDyc.forEach(item -> {
                String realNumber = this.getRealRateNumber(item.getString("number")).toLowerCase(Locale.ENGLISH);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{realNumber});
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryentity);
                entryGrid.setColumnProperty(realNumber, "header", (Object)new LocaleString(item.getString("name")));
            });
        }
    }

    private String getSearchrateColumns() {
        String result = "";
        Object[] columns = ExchangeRateShareSceneHelper.getAllrateColumns((Long)this.getModelId(), (String[])this.rateColumns).toArray(new String[0]);
        if (columns != null && columns.length > 0) {
            result = "," + StringUtils.join((Object[])columns, (String)",");
        }
        return result;
    }

    private FixedItem getContextFixItem(Boolean isLeave) {
        Long modelId = this.getRealModel(isLeave);
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Pair sceneNode = this.getRealDim(modelId, scene, isLeave);
        Pair<Long, String> yearNode = this.getRealDim(modelId, year, isLeave);
        Pair<Long, String> periodNode = this.getRealDim(modelId, period, isLeave);
        Pair<Long, String> entityNode = this.getRealDim(modelId, "entity", isLeave);
        if (ExchangeRateShareSceneHelper.isInRateShare((String)((Long)entityNode.p1).toString(), (String)((Long)sceneNode.p1).toString()).booleanValue()) {
            sceneNode = new Pair((Object)0L, sceneNode.p2);
        }
        FixedItem ctx = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelId, (String)modelNumber), (SimpleItem)SimpleItem.newOne((Object)sceneNode.p1, (String)((String)sceneNode.p2)), (SimpleItem)SimpleItem.newOne((Object)yearNode.p1, (String)((String)yearNode.p2)), (SimpleItem)SimpleItem.newOne((Object)periodNode.p1, (String)((String)periodNode.p2)), (SimpleItem)SimpleItem.newOne((Object)entityNode.p1, (String)((String)entityNode.p2)));
        return ctx;
    }

    private Long getRealModel(Boolean isLeave) {
        String modelIdstr = UserSelectUtil.getF7SelectId(this.getView(), model);
        Long modelId = LongUtil.toLong((Object)modelIdstr);
        if (isLeave.booleanValue() && Objects.equals(this.getPageCache().get("isChangeModel"), "true")) {
            Long oldId = LongUtil.toLong((Object)this.getPageCache().get("oldValue_id"));
            if (Objects.equals(this.getPageCache().get("propName"), model) && LongUtil.isvalidLong((Object)oldId)) {
                modelId = oldId;
            }
        }
        return modelId;
    }

    private Pair<Long, String> getRealDim(Long modelId, String dim, Boolean isLeave) {
        Long oldId;
        Long dimId = 0L;
        String propName = this.getPageCache().get("propName");
        if (Objects.equals(dim, "entity")) {
            dimId = LongUtil.toLong((Object)this.getPageCache().get(this.treeNode_CacheId));
            if (Objects.equals(propName, dim) && isLeave.booleanValue() && LongUtil.isvalidLong((Object)(oldId = LongUtil.toLong((Object)this.getPageCache().get(this.treeNode_CacheOldId))))) {
                dimId = oldId;
            }
        } else {
            dimId = LongUtil.toLong((Object)UserSelectUtil.getF7SelectId(this.getView(), dim));
            if (Objects.equals(propName, dim) && isLeave.booleanValue() && LongUtil.isvalidLong((Object)(oldId = LongUtil.toLong((Object)this.getPageCache().get("oldValue_id"))))) {
                dimId = oldId;
            }
        }
        IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dim), (Long)dimId);
        return new Pair((Object)node.getId(), (Object)node.getNumber());
    }

    private void searchNext(String searchText, String foucesId, int before) {
        TreeView treeView = (TreeView)this.getControl(RATETREE);
        String cachetree = this.getPageCache().get(CacheTree);
        if (StringUtils.isEmpty((CharSequence)cachetree)) {
            return;
        }
        TreeModel treeModel = (TreeModel)ObjectSerialUtil.deSerializedBytes((String)cachetree);
        if (treeModel == null) {
            return;
        }
        ITreeNode root = treeModel.getRoot();
        List lists = treeModel.seekAllChildrenIf(root.getId(), p -> !"RateEntity".equalsIgnoreCase(p.getNumber()) && (p.getName().toLowerCase(Locale.ENGLISH).contains(searchText) || p.getNumber().toLowerCase(Locale.ENGLISH).contains(searchText)));
        if (lists.size() == 0) {
            this.getPageCache().put("resultlist", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"AbstractInvShareBasePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List list = lists.stream().map(s -> s.getId()).collect(Collectors.toList());
        this.getPageCache().put("resultlist", SerializationUtils.serializeToBase64(list));
        String focusnode = "";
        if (StringUtils.isEmpty((CharSequence)foucesId)) {
            focusnode = (String)list.get(0);
            this.getPageCache().put("focus", "0");
        } else {
            int index = list.indexOf(foucesId);
            if (index == -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"AbstractInvShareBasePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getPageCache().remove("foucesId");
                return;
            }
            int newlyindex = index + before;
            if (newlyindex < 0) {
                this.getView().showTipNotification(MessageConstant.getSELECT_FIRST());
                return;
            }
            if (newlyindex > list.size() - 1) {
                this.getView().showTipNotification(MessageConstant.getSELECT_LAST());
                return;
            }
            focusnode = ((OrgTreeNode)lists.get(newlyindex)).getId();
            this.getPageCache().put("focus", String.valueOf(newlyindex));
        }
        ITreeNode parent = ((OrgTreeNode)treeModel.searchByNodeId(focusnode)).getParent();
        String parentId = parent == null ? null : parent.getId();
        treeView.focusNode(new TreeNode(parentId, focusnode, ""));
        treeView.treeNodeClick(parentId, focusnode);
        while (parentId != null) {
            String temp = parentId;
            treeView.expand(temp);
            if (((OrgTreeNode)treeModel.searchByNodeId(temp)).getParent() == null) break;
            parentId = ((OrgTreeNode)treeModel.searchByNodeId(temp)).getParent().getId();
        }
        this.getPageCache().put("foucesId", focusnode);
        this.getPageCache().put("lastsearch", searchText);
    }

    private Boolean isDisabled() {
        String entityId = this.getPageCache().get(this.treeNode_CacheId);
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), scene);
        if ("2".equals(this.getPageCache().get(CurrentRateShareType)) && !ExchangeRateShareSceneHelper.isInRateShare((String)entityId, (String)sceneId).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void releaseAndrequireLock() {
        FixedItem item = this.getContextFixItem(Boolean.FALSE);
        String datakey = kd.fi.bcm.fel.common.StringUtils.stringToMD5((String)(item.getModelNum() + item.getScenarioId() + item.getFyNum() + item.getPeriodNum() + item.getEntityNum()));
        if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(PAGECACHE_LOCKED))) {
            this.releaseLock();
        }
        if (this.isReadOnlyNode().booleanValue() || this.isDisabled().booleanValue() || !this.hasPerm()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)item.getScenarioNum()) || item.getModelId() == 0L || item.getFyId() == 0L || item.getPeriodId() == 0L || item.getEntityId() == 0L) {
            return;
        }
        boolean success = DataMutextHelper.requestMutex((IFormView)this.getView(), (String)datakey, (String)"bcm_exchangerate_maintain", (String)opKey);
        if (success) {
            this.getPageCache().put(PAGECACHE_LOCKED, datakey);
        } else {
            this.getPageCache().remove(PAGECACHE_LOCKED);
        }
    }

    private void releaseLock() {
        String lockedKey = this.getPageCache().get(PAGECACHE_LOCKED);
        if (StringUtils.isEmpty((CharSequence)lockedKey)) {
            return;
        }
        Map lockInfo = DataMutextHelper.getLockInfo((String)lockedKey, (String)"bcm_exchangerate_maintain", (String)opKey);
        if (lockInfo != null && ((String)lockInfo.get("userid")).equals(RequestContext.getOrCreate().getUserId())) {
            DataMutextHelper.release((String)lockedKey, (String)"bcm_exchangerate_maintain", (String)opKey);
        }
        this.getPageCache().remove(PAGECACHE_LOCKED);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.releaseLock();
    }

    @Override
    public void checkPerm(String opkey) {
        switch (opkey) {
            case "btn_sysimport": {
                opkey = "btn_import";
                break;
            }
        }
        super.checkPerm(opkey);
    }

    private static /* synthetic */ void lambda$importExchangeRateFromSys$19(Map rateImportFieldMapping, Table table, DynamicObject s) {
        HashMap keyValueMap = new HashMap(16);
        for (Map.Entry entry : rateImportFieldMapping.entrySet()) {
            keyValueMap.put(entry.getKey(), s.getBigDecimal((String)entry.getValue()));
        }
        table.put((Object)s.getString("orgcur.number"), (Object)s.getString("cur.number"), keyValueMap);
    }
}

