/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.exchangeRate;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class ExchangeRatePlanEditPlugin
extends AbstractBaseFormPlugin {
    private static final String PERMCLASS = "permclass";
    private static final String SCENE = "mulscene";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(PERMCLASS);
        MulBasedataEdit basedatascene = (MulBasedataEdit)this.getControl(SCENE);
        if (basedataEdit != null) {
            PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERMCLASS)), (Object)this.getModelId());
        }
        if (basedatascene != null) {
            basedatascene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        Long modelId = this.getModelId();
        if (!LongUtil.isvalidLong((Object)modelId)) {
            return;
        }
        QFilter fmodel = new QFilter("model", "=", (Object)modelId);
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(SCENE)) {
            fmodel.and("isleaf", "=", (Object)Boolean.TRUE);
        }
        beforeF7SelectEvent.addCustomQFilter(fmodel);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("issharescene".equals(e.getProperty().getName())) {
            Boolean flag = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getView().setVisible(flag, new String[]{SCENE});
            if (!flag.booleanValue()) {
                this.getModel().setValue(SCENE, null);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getFormCustomParam("KEY_MODEL_ID");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.getModel().setValue("model", (Object)modelId);
        QFilter filter1 = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter filter2 = new QFilter("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
        String dimId = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{filter1, filter2}).getString("id");
        this.getModel().setValue("dimension", (Object)dimId);
        Long id = ((Number)this.getFormCustomParam("ids")).longValue();
        String type = (String)this.getFormCustomParam("type");
        boolean isShowMulScene = false;
        if (status == OperationStatus.EDIT) {
            String readOnly;
            DynamicObjectCollection objs;
            QFilter filter = new QFilter("id", "=", (Object)id);
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"number,name,issharescene,permclass", (QFilter[])new QFilter[]{filter});
            this.getModel().setValue("number", (Object)org.getString("number"));
            this.getModel().getDataEntity().set("id", (Object)id);
            this.getModel().setValue(PERMCLASS, (Object)this.getPermclass(id));
            this.getModel().setValue("name", org.get("name"));
            this.getModel().setValue("issharescene", org.get("issharescene"));
            if (org.getBoolean("issharescene") && (objs = ExchangeRateShareSceneHelper.getShareScenes((Long)id)).size() > 0) {
                this.getModel().setValue(SCENE, (Object)objs);
                isShowMulScene = true;
            }
            if (Objects.equals("1", readOnly = (String)this.getFormCustomParam("readOnly"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", PERMCLASS, "issharescene", SCENE, "bar_save"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
                if ("RatePreset".equals(org.getString("number"))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{"issharescene", SCENE});
            }
            this.getView().setVisible(Boolean.valueOf(Objects.equals("2", type)), new String[]{"issharescene"});
        } else if (status == OperationStatus.ADDNEW) {
            this.getModel().getDataEntity().set("id", (Object)0);
        }
        this.getView().setVisible(Boolean.valueOf(isShowMulScene), new String[]{SCENE});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        String ctxStr = (String)this.getFormCustomParam("context");
        if ("save".equals(key)) {
            operate.getOption().setVariableValue("context", ctxStr);
        }
    }

    private DynamicObject getPermclass(Long entityId) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("entityname", "=", (Object)"bcm_entitymembertree");
        qFilter.and("entityid", "=", (Object)entityId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_permclass_entity", (String)"permclass,permclass.number", (QFilter[])qFilter.toArray());
        if (Objects.isNull(dy)) {
            return null;
        }
        return dy.getDynamicObject(PERMCLASS);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("save".equals(key)) {
            boolean issuccess;
            boolean bl = issuccess = e.getOperationResult().getValidateResult().isSuccess() && e.getOperationResult().isSuccess();
            if (issuccess) {
                this.getView().returnDataToParent((Object)this.getView().getFormShowParameter().getStatus());
            }
        }
    }
}

