/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.exchangeRate;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class ExchangeRateSysImportPlugin
extends AbstractBaseFormPlugin
implements TreeNodeClickListener,
ListRowClickListener {
    private static final String BILLLISTAP = "billlistap";
    private static final String BTN_FIELD = "btnfield";
    private static final String ENABLE = "enable";
    private final String algoKey = this.getClass().getName();

    @Override
    public void initialize() {
        super.initialize();
        BillList originlist = (BillList)this.getControl(BILLLISTAP);
        originlist.addSetFilterListener(this::setFilter);
        originlist.addListRowDoubleClickListener((ListRowClickListener)this);
        this.addClickListeners("btnok", "btncancel", BTN_FIELD);
        originlist.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    String name = row.getString("orgcur.name") + "-" + row.getString("cur.name");
                    row.set("name", (Object)name);
                }
                return rows;
            }
        }));
        originlist.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listCol = args.getListColumns();
                for (IListColumn column : listCol) {
                    if (!"orgcur.name".equals(column.getListFieldKey())) continue;
                    column.setHyperlink(Boolean.FALSE.booleanValue());
                }
            }
        });
        ListView listView = (ListView)this.getView();
        TreeListView treeListView = (TreeListView)listView.getTreeListView();
        treeListView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        BillList originList = (BillList)this.getControl(BILLLISTAP);
        originList.clearSelection();
    }

    private void setFilter(SetFilterEvent setFilterEvent) {
        ListView listView = (ListView)this.getView();
        TreeListView treeListView = (TreeListView)listView.getTreeListView();
        Object currentId = treeListView.getTreeModel().getCurrentNodeId();
        if (Objects.equals(currentId, treeListView.getRoot().getId())) {
            setFilterEvent.addCustomQFilter(new QFilter("1", "=", (Object)0));
            return;
        }
        String constr = (String)this.getView().getFormShowParameter().getCustomParam("context");
        FixedItem item = (FixedItem)ObjectSerialUtil.deSerializedBytes((String)constr);
        Set<Long> validIds = this.getNearestIds(item.getModelId(), LongUtil.toLong((Object)currentId), item.getFyNum(), item.getPeriodNum());
        QFilter qFilter = new QFilter("id", "in", validIds);
        setFilterEvent.addCustomQFilter(qFilter);
        setFilterEvent.setOrderBy("orgcur.number,cur.number,effectdate desc");
    }

    private Set<Long> getNearestIds(Long modelId, Long tableId, String fyNumber, String periodNumber) {
        return (Set)ThreadCache.get((Object)(modelId + fyNumber + periodNumber), () -> {
            HashSet<Long> validIds = new HashSet<Long>(16);
            Date curPeriodDate = PeriodUtils.getPeriodLastDate((Long)modelId, (String)fyNumber, (String)periodNumber);
            QFilter tableFilters = new QFilter("exctable", "=", (Object)tableId).and(new QFilter(ENABLE, "=", (Object)"1"));
            tableFilters.and("effectdate", "<=", (Object)curPeriodDate);
            Set<String> existCurrencys = this.getExistCurrency();
            tableFilters.and(new QFilter("orgcur.number", "in", existCurrencys));
            tableFilters.and(new QFilter("cur.number", "in", existCurrencys));
            DataSet allRateDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"bd_exrate_tree", (String)"id,orgcur.number,cur.number,effectdate", (QFilter[])tableFilters.toArray(), (String)"orgcur.number,cur.number,effectdate desc").filter("orgcur.number != cur.number");
            DataSet originDataSet = allRateDataSet.copy();
            DataSet groupedDs = allRateDataSet.groupBy(new String[]{"orgcur.number", "cur.number"}).max("effectdate").finish();
            DataSet rs = originDataSet.rightJoin(groupedDs).on("orgcur.number", "orgcur.number").on("cur.number", "cur.number").on("effectdate", "effectdate").select(new String[]{"id"}).finish();
            for (Row row : rs) {
                validIds.add(row.getLong("id"));
            }
            return validIds;
        });
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(Boolean.TRUE.booleanValue());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String opKey = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(opKey)) {
            BillList originList = (BillList)this.getControl(BILLLISTAP);
            Object[] primaryKeyValues = originList.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeyValues.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u6c47\u7387\u6570\u636e\u3002", (String)"ExchangeRateSysImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Map rateImportFieldMapping = ExchageRateServiceHelper.getRateImportFieldMapping((long)this.getModelId());
            if (rateImportFieldMapping.size() > 0) {
                ArrayList<Long> selectIds = new ArrayList<Long>(10);
                for (Object primaryKeyValue : primaryKeyValues) {
                    selectIds.add((Long)primaryKeyValue);
                }
                this.returnDataToParent(selectIds);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u672a\u914d\u7f6e\u503c\u5b57\u6bb5\u4e0e\u6c47\u7387\u79d1\u76ee\u6620\u5c04\uff0c\u5c06\u4e0d\u4f1a\u5bfc\u5165\u4efb\u4f55\u6c47\u7387\u6570\u636e\u3002", (String)"ExchangeRateSysImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else if (BTN_FIELD.equals(opKey)) {
            this.openFieldSettingMappingView();
        }
    }

    private Set<String> getExistCurrency() {
        Long modelId = this.getModelId();
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        QFilter numberQf = new QFilter("number", "not in", (Object)new String[]{"EC", "DC"});
        modelQf.and("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"number", (QFilter[])new QFilter[]{modelQf, numberQf});
        Set<String> numbers = dys.stream().map(s -> s.getString("number")).collect(Collectors.toSet());
        return numbers;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ListView listView = (ListView)this.getView();
        TreeListView treeListView = (TreeListView)listView.getTreeListView();
        treeListView.getRoot().setText(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"ExchangeRateSysImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_FIELD});
    }

    private void openFieldSettingMappingView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_ratefieldmapping");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }
}

