/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.exchangeRate;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;

public class TriangleRatePlugin
extends AbstractBaseFormPlugin {
    private OpNameMultiLangEnumBridge getOperationTrianglerate() {
        return new OpNameMultiLangEnumBridge("\u4e09\u89d2\u6c47\u7387-\u914d\u7f6e", "TriangleRatePlugin_0", "fi-bcm-formplugin", "triangleRate");
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"TriangleRatePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"TriangleRatePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btngo", "btnback", "btnok");
        BasedataEdit basetcurrency = (BasedataEdit)this.getControl("basetcurrency");
        basetcurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basescurrency = (BasedataEdit)this.getControl("basescurrency");
        basescurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sourcecurrency = (BasedataEdit)this.getControl("sourcecurrency");
        sourcecurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetcurrency = (BasedataEdit)this.getControl("targetcurrency");
        targetcurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btngo": {
                EntryGrid toEntryGrid = (EntryGrid)this.getView().getControl("fromentryentity");
                int selectSize = this.getModel().getEntryEntity("toentryentity").size();
                int[] selectRows = toEntryGrid.getSelectRows();
                int r = 0;
                for (int i = 0; i < selectRows.length; ++i) {
                    DynamicObject toSelectEntryobj = this.getModel().getEntryRowEntity("fromentryentity", selectRows[i]);
                    this.getModel().createNewEntryRow("toentryentity");
                    this.getModel().setValue("tocurrency", toSelectEntryobj.get("fromcurrency"), selectSize + r);
                    this.getModel().deleteEntryRow("fromentryentity", selectRows[i]);
                    ++r;
                }
                break;
            }
            case "btnback": {
                EntryGrid sEntryGrid = (EntryGrid)this.getView().getControl("toentryentity");
                DynamicObjectCollection toSDoc = this.getModel().getEntryEntity("fromentryentity");
                DynamicObjectCollection sDoc = this.getModel().getEntryEntity("toentryentity");
                int size = toSDoc.size();
                int[] selects = sEntryGrid.getSelectRows();
                for (int i = 0; i < selects.length; ++i) {
                    this.getModel().createNewEntryRow("fromentryentity");
                    this.getModel().setValue("fromcurrency", ((DynamicObject)sDoc.get(selects[i])).get("tocurrency"), size + i);
                }
                this.getModel().deleteEntryRows("toentryentity", selects);
                break;
            }
            case "btnok": {
                DynamicObjectCollection lockentryentity = this.getModel().getEntryEntity("lockentryentity");
                boolean check = lockentryentity.stream().anyMatch(o -> o.get("sourcecurrency") == null || o.get("targetcurrency") == null);
                DynamicObjectCollection baseentryentity = this.getModel().getEntryEntity("baseentryentity");
                boolean checkbase = baseentryentity.stream().anyMatch(o -> o.get("basescurrency") == null || o.get("basetcurrency") == null);
                if (check || checkbase) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u586b\u5199\u5b8c\u6210\u3002", (String)"TriangleRatePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet<String> containentry = new HashSet<String>(10);
                for (DynamicObject object : baseentryentity) {
                    String currencyString = object.getString("basescurrency.number") + object.getString("basetcurrency.number");
                    if (containentry.add(currencyString)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TriangleRatePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                try (TXHandle tx = TX.required((String)"bcm_activeSave");){
                    try {
                        this.savePriority();
                        this.saveLock(lockentryentity);
                        this.saveBase(baseentryentity);
                        this.writeOperationLog(this.getOperationTrianglerate(), this.getOperationStstusSuccess());
                    }
                    catch (Exception e) {
                        this.writeOperationLog(this.getOperationTrianglerate(), this.getOperationStstusFail());
                    }
                }
                this.getView().close();
            }
        }
    }

    private void saveBase(DynamicObjectCollection baseentryentity) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        DeleteServiceHelper.delete((String)"bcm_trianglebaseinfo", (QFilter[])filter.toArray());
        ArrayList<DynamicObject> saveInfos = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < baseentryentity.size(); ++i) {
            DynamicObject row = (DynamicObject)baseentryentity.get(i);
            DynamicObject triangleBaseInfo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_trianglebaseinfo");
            triangleBaseInfo.set("model", (Object)this.getModelId());
            triangleBaseInfo.set("source", (Object)((DynamicObject)row.get("basescurrency")).getLong("id"));
            triangleBaseInfo.set("target", (Object)((DynamicObject)row.get("basetcurrency")).getLong("id"));
            triangleBaseInfo.set("sort", (Object)i);
            saveInfos.add(triangleBaseInfo);
        }
        if (saveInfos.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveInfos.toArray(new DynamicObject[0]));
        }
    }

    private void saveLock(DynamicObjectCollection lockentryentity) {
        QFilter modelFilter = this.getDimPermFilter(this.getModelId(), "bcm_processmembertree");
        QFilter sourceFilter = new QFilter("parent.number", "=", (Object)"TCF");
        QFilter currencyFilter = modelFilter.and(sourceFilter);
        DynamicObject[] initCurrencys = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,name,priority,lockcurr", (QFilter[])new QFilter[]{currencyFilter}, (String)"priority asc");
        List currenys = lockentryentity.stream().map(row -> {
            DynamicObject sourcecurr = (DynamicObject)row.get("sourcecurrency");
            sourcecurr.set("lockcurr", (Object)((DynamicObject)row.get("targetcurrency")).getLong("id"));
            return sourcecurr;
        }).collect(Collectors.toList());
        for (DynamicObject initCurrency : initCurrencys) {
            initCurrency.set("lockcurr", null);
            for (DynamicObject object : currenys) {
                if (initCurrency.getLong("id") != object.getLong("id")) continue;
                initCurrency.set("lockcurr", object.get("lockcurr"));
                initCurrency.set("lockcurr_id", object.get("lockcurr"));
            }
        }
        SaveServiceHelper.update((DynamicObject[])initCurrencys);
    }

    private void savePriority() {
        DynamicObjectCollection fromentryentity = this.getModel().getEntryEntity("fromentryentity");
        DynamicObjectCollection toentryentity = this.getModel().getEntryEntity("toentryentity");
        ArrayList<Object> fromCurrencys = new ArrayList<Object>(10);
        ArrayList<DynamicObject> toCurrencys = new ArrayList<DynamicObject>(10);
        for (DynamicObject from : fromentryentity) {
            DynamicObject currency = (DynamicObject)from.get("fromcurrency");
            currency.set("priority", (Object)0);
            fromCurrencys.add(currency);
        }
        for (int i = 0; i < toentryentity.size(); ++i) {
            DynamicObject currency = (DynamicObject)((DynamicObject)toentryentity.get(i)).get("tocurrency");
            currency.set("priority", (Object)(i + 1));
            toCurrencys.add(currency);
        }
        fromCurrencys.addAll(toCurrencys);
        DynamicObject[] currens = new DynamicObject[fromCurrencys.size()];
        fromCurrencys.toArray(currens);
        SaveServiceHelper.update((DynamicObject[])currens);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelId = (Long)this.getFormCustomParam("modelid");
        this.getModel().setValue("model", (Object)modelId);
        String textareafieldmsg = ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u4ece\u5de6\u4fa7\u9009\u62e9\u5230\u53f3\u4fa7\u540e\uff0c\u5728\u53f3\u4fa7\u901a\u8fc7\u4e0a\u79fb\u4e0b\u79fb\u6539\u53d8\u5176\u4f18\u5148\u7ea7\u987a\u5e8f\u3002\u7cfb\u7edf\u4e2d\u7ef4\u62a4\u4e86 A->B\u3001B->M\u3001A->C\u3001C->M \u7684\u6c47\u7387\u503c\uff0c\u5982\u679c\u4f18\u5148\u7ea7\u4e2d\u8bbe\u5b9aC\u4f18\u5148\u4e8eB\uff0c\u90a3\u4e48 A->M \u7684\u6c47\u7387\u503c\u6309A->C\u4e58\u4ee5C->M\u8ba1\u7b97\u51fa\u6765\u3002", (String)"TriangleRatePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("textareafield", (Object)textareafieldmsg);
        String textareafield1msg = ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u7cfb\u7edf\u4e2d\u5982\u679c\u7ef4\u62a4\u4e86 A->B\u3001B->M\u3001A->M \u7684\u6c47\u7387\u503c\uff0c\u82e5\u9501\u5b9a\u4e86 A->B\uff0c\u5219 A->M \u7684\u6c47\u7387\u503c\u6309 A->B \u4e58\u4ee5 B->M \u8ba1\u7b97\u51fa\u6765\uff0c\u4f1a\u8986\u76d6\u7cfb\u7edf\u4e2d\u7ef4\u62a4\u7684A->M\u7684\u6c47\u7387\u503c\u3002", (String)"TriangleRatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("textareafield1", (Object)textareafield1msg);
        String textareafield2msg = ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u5c06\u6839\u636e\u4e2d\u95f4\u5e01\u4f18\u5148\u7ea7\u548c\u9501\u5b9a\u7684\u914d\u7f6e\u4fe1\u606f\u8ba1\u7b97\u4ee5\u4e0a\u539f\u5e01\u5230\u76ee\u6807\u5e01\u7684\u6c47\u7387\u503c\u3002", (String)"TriangleRatePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("textareafield2", (Object)textareafield2msg);
        QFilter modelFilter = this.getDimPermFilter(modelId, "bcm_processmembertree");
        QFilter sourceFilter = new QFilter("parent.number", "=", (Object)"TCF");
        QFilter currencyFilter = modelFilter.and(sourceFilter);
        DynamicObject[] currency = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,name,priority,lockcurr", (QFilter[])new QFilter[]{currencyFilter}, (String)"priority asc");
        Stream.of(currency).filter(c -> c.getInt("priority") == 0).forEach(from -> {
            int index = this.getModel().createNewEntryRow("fromentryentity");
            this.getModel().setValue("fromcurrency", (Object)from.getLong("id"), index);
        });
        Stream.of(currency).filter(c -> c.getInt("priority") != 0).forEach(to -> {
            int index = this.getModel().createNewEntryRow("toentryentity");
            this.getModel().setValue("tocurrency", (Object)to.getLong("id"), index);
        });
        Stream.of(currency).filter(c -> c.get("lockcurr") != null).forEach(lock -> {
            int index = this.getModel().createNewEntryRow("lockentryentity");
            this.getModel().setValue("sourcecurrency", (Object)lock.getLong("id"), index);
            this.getModel().setValue("targetcurrency", (Object)((DynamicObject)lock.get("lockcurr")).getLong("id"), index);
        });
        QFilter baseFilter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObject[] baseinfos = BusinessDataServiceHelper.load((String)"bcm_trianglebaseinfo", (String)"source,target", (QFilter[])baseFilter.toArray(), (String)"sort");
        if (baseinfos != null) {
            for (DynamicObject row : baseinfos) {
                int index = this.getModel().createNewEntryRow("baseentryentity");
                this.getModel().setValue("basescurrency", (Object)row.getLong("source_id"), index);
                this.getModel().setValue("basetcurrency", (Object)row.getLong("target_id"), index);
            }
        }
        if (Objects.equals("1", this.getFormCustomParam("readOnly"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
        }
    }

    private QFilter getDimPermFilter(long modelId, String entityNumber) {
        QFilter permFilter;
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimEntityNumEnum.getNumberByEntieyNum((String)entityNumber));
        if (dimensionId != null && (permFilter = SingleMemberF7Util.getPermissionFilter(entityNumber, dimensionId, modelId)) != null) {
            modelFilter = modelFilter.and(permFilter);
        }
        return modelFilter;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        switch (arg0.getProperty().getName()) {
            case "basescurrency": {
                QFilter baseSourceFilter = this.getDimPermFilter(this.getModelId(), "bcm_processmembertree");
                ArrayList<QFilter> baseSourceCustomFilter = new ArrayList<QFilter>(10);
                baseSourceCustomFilter.add(baseSourceFilter);
                baseSourceCustomFilter.add(new QFilter("parent.number", "=", (Object)"TCF"));
                ArrayList<String> notInCurrency = new ArrayList<String>(10);
                int currentIndex = this.getModel().getEntryCurrentRowIndex("baseentryentity");
                DynamicObject targetCurrency = (DynamicObject)this.getModel().getEntryRowEntity("baseentryentity", currentIndex).get("basetcurrency");
                if (targetCurrency != null) {
                    notInCurrency.add(targetCurrency.getString("number"));
                    baseSourceCustomFilter.add(new QFilter("number", "not in", notInCurrency));
                }
                arg0.setCustomQFilters(baseSourceCustomFilter);
                arg0.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u539f\u5e01", (String)"TriangleRatePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "basetcurrency": {
                QFilter baseTargetFilter = this.getDimPermFilter(this.getModelId(), "bcm_currencymembertree");
                ArrayList<QFilter> baseTargetCustomFilter = new ArrayList<QFilter>(10);
                baseTargetCustomFilter.add(baseTargetFilter);
                baseTargetCustomFilter.add(new QFilter("isleaf", "=", (Object)"1"));
                int rowIndex = this.getModel().getEntryCurrentRowIndex("baseentryentity");
                DynamicObject currency = (DynamicObject)this.getModel().getEntryRowEntity("baseentryentity", rowIndex).get("basescurrency");
                ArrayList<String> notInCurrencyList = new ArrayList<String>(10);
                notInCurrencyList.add("CNone");
                notInCurrencyList.add("EC");
                notInCurrencyList.add("PC");
                notInCurrencyList.add("DC");
                notInCurrencyList.add("OC");
                if (currency != null) {
                    notInCurrencyList.add(currency.getString("number"));
                }
                baseTargetCustomFilter.add(new QFilter("number", "not in", notInCurrencyList));
                arg0.setCustomQFilters(baseTargetCustomFilter);
                arg0.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u76ee\u6807\u5e01", (String)"TriangleRatePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "sourcecurrency": {
                QFilter lockSourceFilter = this.getDimPermFilter(this.getModelId(), "bcm_processmembertree");
                ArrayList<QFilter> lockSourceCustomFilter = new ArrayList<QFilter>(10);
                lockSourceCustomFilter.add(lockSourceFilter);
                lockSourceCustomFilter.add(new QFilter("parent.number", "=", (Object)"TCF"));
                DynamicObjectCollection lockEntryEntity = this.getModel().getEntryEntity("lockentryentity");
                List lockSourceNotInCurrency = lockEntryEntity.stream().filter(row -> row.get("sourcecurrency") != null).map(o -> ((DynamicObject)o.get("sourcecurrency")).getString("number")).collect(Collectors.toList());
                int lockSRowIndex = this.getModel().getEntryCurrentRowIndex("lockentryentity");
                DynamicObject lockTargetCurrency = (DynamicObject)this.getModel().getEntryRowEntity("lockentryentity", lockSRowIndex).get("targetcurrency");
                if (lockTargetCurrency != null) {
                    lockSourceNotInCurrency.add(lockTargetCurrency.getString("number"));
                }
                lockSourceCustomFilter.add(new QFilter("number", "not in", lockSourceNotInCurrency));
                arg0.setCustomQFilters(lockSourceCustomFilter);
                arg0.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u539f\u5e01", (String)"TriangleRatePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "targetcurrency": {
                QFilter lockTargetFilter = this.getDimPermFilter(this.getModelId(), "bcm_currencymembertree");
                ArrayList<QFilter> lockTargetCustomFilter = new ArrayList<QFilter>(10);
                lockTargetCustomFilter.add(lockTargetFilter);
                lockTargetCustomFilter.add(new QFilter("isleaf", "=", (Object)"1"));
                int lockTRowIndex = this.getModel().getEntryCurrentRowIndex("lockentryentity");
                DynamicObject lockSourceCurrency = (DynamicObject)this.getModel().getEntryRowEntity("lockentryentity", lockTRowIndex).get("sourcecurrency");
                ArrayList<String> notInCurrencyForLockTarget = new ArrayList<String>(5);
                notInCurrencyForLockTarget.add("CNone");
                notInCurrencyForLockTarget.add("EC");
                notInCurrencyForLockTarget.add("PC");
                notInCurrencyForLockTarget.add("DC");
                notInCurrencyForLockTarget.add("OC");
                if (lockSourceCurrency != null) {
                    notInCurrencyForLockTarget.add(lockSourceCurrency.getString("number"));
                }
                lockTargetCustomFilter.add(new QFilter("number", "not in", notInCurrencyForLockTarget));
                arg0.setCustomQFilters(lockTargetCustomFilter);
                arg0.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e2d\u95f4\u5e01", (String)"TriangleRatePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }
}

