/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.extdatatrace;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.extdata.ExtFieldMappedService;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;

public class ExtDataTraceHelper {
    public static final String EXTROWPKID = "extrowpkid";
    public static final String SELECT_DIM_CELL = "SELECT_DIM_CELL";
    public static final String SELECT_EXT_COLS = "SELECT_EXT_COLS";
    public static final String SELECT_EXTEND_MODEL = "SELECT_EXTEND_MODEL";
    public static final String COMMON_DIM_INFO = "COMMON_DIM_INFO";
    public static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    public static final String MODEL = "model";
    public static final String COMMON_ENTITY_ID = "COMMON_ENTITY_ID";
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String IS_LEAF = "isleaf";
    public static final String LEVEL = "level";
    public static final String CELLFLAG = "cellFlag";
    public static final String OPENPARENT = "openParent";
    public static final String PARENTCELL = "parentCell";
    public static final String OPENCOUNT = "openCount";
    public static final String DIMID = "dimId";
    public static final String IS_ADJUST = "isadjust";
    public static final Set<String> NUMBER_TYPES = Sets.newHashSet((Object[])new String[]{DataTypeEnum.DEFAULT.getOIndex(), DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex()});
    public static final Set<String> COM_DIM = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});
    public static final Set<String> CHANGE_COM_DIM = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber()});
    public static final Map<String, String> TRANS_PROCESS = MapInitHelper.ofMap((Object)"ERpt", (Object)"Rpt", (Object)"EIRpt", (Object)"IRpt", (Object)"ERAdj", (Object)"RAdj");

    public static Map<String, Object> getSelectedCell(long modelId, SpreadManager sm, SpreadSelector selector, Sheet sheet) {
        String errorMsg = "";
        HashMap<String, Object> selectInfo = new HashMap<String, Object>(16);
        ArrayList<Map<String, String>> selectDimCell = new ArrayList<Map<String, String>>(10);
        LinkedHashSet<String> selects = new LinkedHashSet<String>(10);
        HashSet<PositionInfo> positionInfos = new HashSet<PositionInfo>(16);
        Collection dims = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelId)).values();
        block0: for (int i = selector.getStartRow(); i < selector.getEndRow() + 1; ++i) {
            for (int j = selector.getStartCol(); j < selector.getEndCol() + 1; ++j) {
                Cell cell = sheet.getCell(i, j);
                if (cell.getUserObject(EXTROWPKID) == null) {
                    return null;
                }
                PositionInfo ps = sm.getInAreaPositionByRow(cell.getRow(), cell.getCol());
                if (ps == null || ps.getExtendInfo() == null) {
                    errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u62d3\u5c55\u6570\u636e\u5355\u5143\u683c\u540e\u518d\u8bd5\u3002", (String)"ExtDataTraceHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    break block0;
                }
                Map index2DimNums = sm.getExtHeadInfo(ps);
                String extNum = (String)index2DimNums.get(cell.getCol());
                DataTypeEnum dataTypeEnum = (DataTypeEnum)MemberReader.getMemberDataType((long)modelId, (String)"bcm_structofextend", (String)"Extends").get("Extends_" + extNum);
                if (dims.contains(extNum) || dataTypeEnum != null && !NUMBER_TYPES.contains(dataTypeEnum.getOIndex())) {
                    errorMsg = ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u8054\u67e5\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b\u7684\u62d3\u5c55\u5b57\u6bb5\u3002", (String)"ExtDataTraceHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    break block0;
                }
                positionInfos.add(ps);
            }
        }
        if (errorMsg.isEmpty() && positionInfos.size() > 1) {
            errorMsg = ResManager.loadKDString((String)"\u6682\u65f6\u53ea\u652f\u6301\u4e00\u4e2a\u6570\u636e\u533a\u57df\u8054\u67e5\u3002", (String)"ExtDataTraceHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (errorMsg.isEmpty()) {
            PositionInfo position = (PositionInfo)new ArrayList(positionInfos).get(0);
            ExtFieldMappedService fieldMappedService = new ExtFieldMappedService(Long.valueOf(modelId), position.getExtendInfo().getExtGroup());
            for (int i = selector.getStartRow(); i < selector.getEndRow() + 1; ++i) {
                boolean isFirstRow = true;
                for (int j = selector.getStartCol(); j < selector.getEndCol() + 1; ++j) {
                    if (isFirstRow) {
                        List cols = position.getExtendInfo().getCols();
                        Map colsFieldMapped = fieldMappedService.getColsFieldMapped(cols.toArray(new String[0]));
                        Map dimsFieldMapped = fieldMappedService.getDimsFieldMapped(cols.toArray(new String[0]));
                        Map extHeadInfo = sm.getExtHeadInfo(position);
                        Map<String, String> extDimMemMap = ExtDataTraceHelper.collectExtRowMemMap(sheet, extHeadInfo, position, i, colsFieldMapped, dimsFieldMapped);
                        selectDimCell.add(extDimMemMap);
                        isFirstRow = false;
                    }
                    selects.add(sm.getExtHeadCol2(i, j));
                }
            }
            selectInfo.put(SELECT_DIM_CELL, selectDimCell);
            selectInfo.put(SELECT_EXT_COLS, new ArrayList(selects));
            selectInfo.put(SELECT_EXTEND_MODEL, position.getExtendInfo().getExtModelNumber());
            List commonMemberList = sm.getFilter().getPageDomain().getAllMembers();
            HashMap<String, String> commonDimMap = new HashMap<String, String>(16);
            for (IDimMember iDimMember : commonMemberList) {
                if (!COM_DIM.contains(iDimMember.getDimension().getNumber())) continue;
                commonDimMap.put(iDimMember.getDimension().getNumber(), iDimMember.getNumber());
            }
            selectInfo.put(COMMON_DIM_INFO, commonDimMap);
            selectInfo.put(MODEL, modelId);
        }
        selectInfo.put(ERROR_MESSAGE, errorMsg);
        return selectInfo;
    }

    public static Map<String, String> collectExtRowMemMap(Sheet sheet, Map<Integer, String> extHeadInfo, PositionInfo position, int rowIndex, Map<String, String> colsFieldMapped, Map<String, String> dimsFieldMapped) {
        LinkedHashMap<String, String> extDimMemMap = new LinkedHashMap<String, String>(16);
        String[] range = position.getAreaRange().split(":");
        int startX = ExcelUtils.pos2Point((String)range[0]).x;
        int endX = ExcelUtils.pos2Point((String)range[1]).x;
        List row = sheet.getRow(rowIndex);
        for (int i = startX; i <= endX; ++i) {
            Cell c = (Cell)row.get(i);
            Object v = c.getValue();
            String extCol = extHeadInfo.get(i);
            if (colsFieldMapped.get(extCol) != null) {
                if (v != null && DateTimeUtils.isOADate((String)v.toString())) {
                    try {
                        Date date = DateTimeUtils.parseStrDate((String)v.toString());
                        extDimMemMap.put(extHeadInfo.get(i), new Timestamp(date.getTime()).toString());
                        continue;
                    }
                    catch (ParseException e) {
                        String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u4e0d\u53ef\u8868\u5f0f\u8c03\u6574 %s", (String)"ExtTableAdjustPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), v);
                        throw new KDBizException(msg);
                    }
                }
                if (v instanceof BigDecimal) {
                    extDimMemMap.put(extHeadInfo.get(i), ((BigDecimal)c.getValue()).stripTrailingZeros().toPlainString());
                    continue;
                }
                String colExt = extHeadInfo.get(i);
                if (v == null && colsFieldMapped.get(colExt) != null && colsFieldMapped.get(colExt).startsWith("numext")) {
                    extDimMemMap.put(colExt, "0");
                    continue;
                }
                extDimMemMap.put(colExt, v != null ? v.toString() : "");
                continue;
            }
            if (!dimsFieldMapped.containsKey(extCol) && !extCol.equals(DimTypesEnum.ENTITY.getNumber()) || c.getUserObject() == null || !c.getUserObject().containsKey((Object)"KEY_DIM_FLAG")) continue;
            DimMember dimMember = (DimMember)((List)c.getUserObject().get((Object)"KEY_DIM_FLAG")).get(0);
            extDimMemMap.put(extCol, dimMember.getNumber());
        }
        return extDimMemMap;
    }

    public static String switchQueryMem(String dim, String member) {
        if (DimTypesEnum.PROCESS.getNumber().equals(dim)) {
            return TRANS_PROCESS.getOrDefault(member, member);
        }
        return member;
    }
}

