/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.extdatatrace;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.datatrace.DataTraceHelper;
import kd.fi.bcm.formplugin.extdatatrace.ExtDataTraceHelper;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.UserObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ExtDataTracePlugin
extends AbstractTemplateBasePlugin {
    protected static final String scenario = "scenario";
    protected static final String year = "year";
    protected static final String period = "period";
    protected static final String model = "model";
    protected static final String EXTEND_MODEL = "extendmodel";
    private static final List<String> DIM_KEYS = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static final String spreadKey = "report";
    private ExtendsModel extendsModel;
    public static final String EXPAND_PLUS = "\u25b6 ";
    public static final String EXPAND_SUB = "\u25bd ";
    private static final String PEER_ALIGNMENT = "    ";
    private static final String SOURCE_ENTITY = "SourceEntity";
    private static final String ORG = "org";
    private static final String IS_PARTICIP_MERGE = "isparticipmerge";
    private static final String GET_QUERYMAPPING_FILTER = "getQueryMappingFilter";
    private static final List<String> FIX_HEAD_DIMS = Lists.newArrayList((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), "SourceEntity", DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});
    private static final List<String> ADJUST_PROCESS = Lists.newArrayList((Object[])new String[]{"ADJ", "CADJ", "EJE", "CCADJ"});
    private static final Set<String> REMOVE_IRPT_PROCESS = Sets.newHashSet((Object[])new String[]{"CCTotal", "CC", "PRPT", "ARPT"});

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(DIM_KEYS, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        this.initProperty(customParams);
        this.initSpreadStyle();
        this.setPageData(customParams);
        this.buildSpreadHead(cellValues);
        this.initCellStyle();
        this.buildSpreadDataInit(cellValues);
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList(cellValues));
        SearchHelper.lockOrUnlockCell(this.getClientViewProxy(), spreadKey, true, 0, 0, this.getEffectiveSheet().getMaxRowCount(), this.getEffectiveSheet().getMaxColumnCount());
        SpreadClientInvoker.invokeSetSheetNameMethod(this.getClientViewProxy(), this.getSpreadKey(), ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6570\u636e\u8ffd\u6eaf", (String)"ExtDataTracePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.cacheSpreadModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doubleClickLockedCell(int row, int col) {
        this.getView().showLoading(ResManager.getLocaleString((String)"\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019...", (String)"ExtDataTracePlugin_2", (String)"fi-bcm-formplugin"));
        try {
            if (row > 0) {
                Sheet sheet = this.getEffectiveSheet();
                Cell cell = sheet.getCell(row, col);
                if (cell.getValue() == null) {
                    return;
                }
                String values = cell.getValue().toString().replaceAll("^[\u3000 ]+", "");
                if (values.startsWith(EXPAND_PLUS)) {
                    int insertCount = this.addNewRow(row, col, sheet);
                    if (insertCount <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5c55\u5f00\u3002", (String)"DataTracePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.packUpRow(row, col, sheet, cell);
                }
                this.cacheSpreadModel();
            }
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5185\u90e8\u9519\u8bef\uff1a%s\u3002", (String)"ExtDataTracePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)1)));
            } else {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
        finally {
            this.getView().hideLoading();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_export": {
                HashMap<String, String> map2 = new HashMap<String, String>(16);
                Date date = new Date();
                int year = DateTimeUtils.getYear((Date)date);
                int month = DateTimeUtils.getMonth((Date)date);
                String monthStr = month > 10 ? String.valueOf(month) : "0" + month;
                int day = DateTimeUtils.getDay((Date)date);
                String dayStr = day > 10 ? String.valueOf(day) : "0" + day;
                map2.put(SpreadProperties.ExportExcelFileMethod.FILENAME.k(), String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6570\u636e\u8ffd\u6eaf%1$s%2$s%3$s", (String)"ExtDataTracePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), year, monthStr, dayStr));
                SpreadClientInvoker.invokeExportExcelFileMethod(this.getClientViewProxy(), spreadKey, map2);
                break;
            }
            case "btn_name": 
            case "btn_number": 
            case "btn_numname": {
                this.getModel().setValue("showtype", (Object)key);
                this.changeDisplay(key);
            }
            case "btn_refresh": {
                this.refreshSheet();
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getChangeSet()[0].getNewValue() instanceof DynamicObject) {
            Optional<String> first = ExtDataTraceHelper.CHANGE_COM_DIM.stream().filter(dim -> this.getPageDim((String)dim) == null).findFirst();
            if (first.isPresent()) {
                return;
            }
            this.refreshSheet();
        }
    }

    private void refreshSheet() {
        this.clearSpreadData();
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        this.buildSpreadDataInit(cellValues);
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList(cellValues));
        SearchHelper.lockOrUnlockCell(this.getClientViewProxy(), spreadKey, true, 0, 0, this.getEffectiveSheet().getMaxRowCount(), this.getEffectiveSheet().getMaxColumnCount());
        this.focusCell();
        this.cacheSpreadModel();
    }

    private void focusCell() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put(SpreadProperties.FieldInsertMethod.R.k(), 1);
        params.put(SpreadProperties.FieldInsertMethod.C.k(), 0);
        params.put(SpreadProperties.FieldInsertMethod.RC.k(), 1);
        params.put(SpreadProperties.FieldInsertMethod.CC.k(), 1);
        SpreadClientInvoker.invokeSetSelectionsMethod(this.getClientViewProxy(), spreadKey, params);
    }

    private void clearSpreadData() {
        Sheet sheet = this.getEffectiveSheet();
        LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
        map.put("status", Boolean.valueOf(true));
        int rowCount = sheet.getMaxRowCount();
        ArrayList<Integer> delNumberList = new ArrayList<Integer>(rowCount);
        for (int i = 1; i < rowCount; ++i) {
            delNumberList.add(1);
            sheet.delRow(1);
        }
        map.put("data", delNumberList);
        SpreadClientInvoker.invokeDelRow(this.getClientViewProxy(), spreadKey, map);
    }

    private void packUpRow(int rowNumber, int colNumber, Sheet sheet, Cell cell) {
        int openCount = DataTraceHelper.packUpRowOrCol(this.getClientViewProxy(), spreadKey, rowNumber, colNumber, sheet, cell, false, true);
        SearchHelper.updateDataTraceParenOpenRowCount(sheet, cell, openCount, false);
    }

    private int addNewRow(int rowNumber, int colNumber, Sheet sheet) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        Cell clickDimCell = sheet.getCell(0, colNumber);
        String clickDimNumber = (String)clickDimCell.getUserObject("number");
        String clickMem = (String)sheet.getCell(rowNumber, colNumber).getUserObject("number");
        Map<String, Object> selectMap = this.collectClickDimRowValue(rowNumber, sheet);
        ArrayList<Map<String, Object>> realList = new ArrayList<Map<String, Object>>(10);
        List<Map<String, Object>> dataList = null;
        if (DimTypesEnum.PROCESS.getNumber().equals(clickDimNumber) || DimTypesEnum.AUDITTRIAL.getNumber().equals(clickDimNumber)) {
            dataList = this.queryExtData(selectMap, clickDimNumber, null);
            this.openProcessOrAudit(rowNumber, sheet, clickDimNumber, clickMem, realList, dataList);
        } else {
            IDNumberTreeNode processNode = MemberReader.findProcessMemberByNum((String)this.getModelNumber(), (String)selectMap.get(DimTypesEnum.PROCESS.getNumber()).toString());
            IDNumberTreeNode atNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)selectMap.get(DimTypesEnum.AUDITTRIAL.getNumber()).toString());
            IDNumberTreeNode curNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)DimTypesEnum.CURRENCY.getNumber(), (String)selectMap.get(DimTypesEnum.CURRENCY.getNumber()).toString());
            Long l = (Long)sheet.getCell(rowNumber, colNumber).getUserObject("id");
            Long sourceMemId = (Long)sheet.getCell(rowNumber, 1).getUserObject("id");
            List<Map<String, Object>> infos = this.getListInfo(l, sourceMemId, rowNumber, processNode, atNode, curNode, selectMap);
            realList.addAll(infos);
        }
        int insertSize = realList.size();
        if (!realList.isEmpty()) {
            this.updateSelectCellValue(rowNumber, colNumber, cellValues);
            this.insertSpaceRow(rowNumber, insertSize, sheet);
            int insertRow = rowNumber + 1;
            for (Map map : realList) {
                this.buildSingleNewRow(rowNumber, colNumber, sheet, cellValues, map, insertRow, clickDimNumber);
                ++insertRow;
            }
            sheet.getCell(rowNumber, colNumber).setUserObject("openCount", (Object)insertSize);
            SearchHelper.updateDataTraceParenOpenRowCount(sheet, sheet.getCell(rowNumber, colNumber), insertSize, true);
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList(cellValues));
            SearchHelper.lockOrUnlockCell(this.getClientViewProxy(), spreadKey, true, rowNumber + 1, 0, rowNumber + insertRow, sheet.getMaxColumnCount());
        }
        return insertSize;
    }

    private void openProcessOrAudit(int rowNumber, Sheet sheet, String clickDimNumber, String clickMem, List<Map<String, Object>> realList, List<Map<String, Object>> dataList) {
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        long orgId = (Long)sheet.getCell(rowNumber, 0).getUserObject("id");
        List<Map<String, Object>> allAddChildrenNumbers = this.getAllAddChildrenNumbers(this.getModelNumber(), clickDimNumber, clickMem);
        String modelNumber = this.getModelNumber();
        boolean showNoData = this.showNoData();
        Set dims = MemberReader.getDimNumberMapNameById((long)this.getModelId()).keySet();
        for (Map<String, Object> map : allAddChildrenNumbers) {
            String processNum = DimTypesEnum.PROCESS.getNumber().equals(clickDimNumber) ? map.get("number").toString() : (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.PROCESS.getNumber()).intValue()).getUserObject("number");
            String auditNum = DimTypesEnum.AUDITTRIAL.getNumber().equals(clickDimNumber) ? map.get("number").toString() : (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.AUDITTRIAL.getNumber()).intValue()).getUserObject("number");
            String currencyNum = (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.CURRENCY.getNumber()).intValue()).getUserObject("number");
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgId);
            List<String> selectCols = this.getCurSelectExtCols(orgNode, processNum, auditNum, currencyNum);
            Map<String, Map<String, Set<String>>> mappingFilter = this.getMappingFilter(orgId, rowNumber, clickDimNumber, map.get("number").toString(), columnIndexMap);
            HashMap<String, Object> info = new HashMap<String, Object>(16);
            if (CollectionUtils.isNotEmpty(dataList)) {
                boolean isIn;
                if (this.checkEntityCanFold(orgNode, processNum, auditNum, currencyNum)) {
                    info.put(clickDimNumber, this.getEntityMap(this.getModelId(), clickDimNumber, (Long)map.get("id")));
                    for (Map map2 : dataList) {
                        isIn = ExtDataTracePlugin.isInMapping(clickDimNumber, map2, mappingFilter);
                        if (isIn) {
                            for (String col : selectCols) {
                                Object value = info.get(col);
                                if (dims.contains(col) && map2.get(col) instanceof String) {
                                    IDNumberTreeNode colNode = MemberReader.findMemberByNumber((String)modelNumber, (String)col, (String)((String)value));
                                    if (colNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                                    info.putIfAbsent(col, this.getEntityMap(this.getModelId(), col, colNode.getId()));
                                    continue;
                                }
                                if (value instanceof BigDecimal) {
                                    info.put(col, ((BigDecimal)value).add((BigDecimal)map2.get(col)));
                                    continue;
                                }
                                info.put(col, map2.get(col));
                            }
                            info.putIfAbsent(SOURCE_ENTITY, this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), MemberReader.findEntityMemberByNum((String)modelNumber, (String)((String)map2.get(ORG))).getId()));
                        }
                        if (!showNoData) continue;
                        for (String col : selectCols) {
                            info.putIfAbsent(col, null);
                        }
                    }
                    if (info.size() <= 1) continue;
                    realList.add(info);
                    continue;
                }
                for (Map<String, Object> map3 : dataList) {
                    isIn = ExtDataTracePlugin.isInMapping(clickDimNumber, map3, mappingFilter);
                    if (isIn) {
                        info = new HashMap(16);
                        info.put(clickDimNumber, this.getEntityMap(this.getModelId(), clickDimNumber, (Long)map.get("id")));
                        info.putIfAbsent(SOURCE_ENTITY, this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), MemberReader.findEntityMemberByNum((String)modelNumber, (String)((String)map3.get(ORG))).getId()));
                        for (String col : selectCols) {
                            if (dims.contains(col) && map3.get(col) instanceof String) {
                                IDNumberTreeNode colNode = MemberReader.findMemberByNumber((String)modelNumber, (String)col, (String)((String)map3.get(col)));
                                if (colNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                                info.putIfAbsent(col, this.getEntityMap(this.getModelId(), col, colNode.getId()));
                                continue;
                            }
                            info.put(col, map3.get(col));
                        }
                        realList.add(info);
                    }
                    if (!showNoData) continue;
                    for (String col : selectCols) {
                        info.putIfAbsent(col, null);
                    }
                }
                continue;
            }
            if (!showNoData) continue;
            info.put(clickDimNumber, this.getEntityMap(this.getModelId(), clickDimNumber, (Long)map.get("id")));
            for (String string : selectCols) {
                info.putIfAbsent(string, null);
            }
            realList.add(info);
        }
    }

    private static boolean isInMapping(String clickDimNumber, Map<String, Object> rows, Map<String, Map<String, Set<String>>> mappingFilter) {
        String org = (String)rows.get(ORG);
        String process = (String)rows.get(DimTypesEnum.PROCESS.getNumber());
        String audit = (String)rows.get(DimTypesEnum.AUDITTRIAL.getNumber());
        boolean isIn = mappingFilter.containsKey(org);
        if (isIn) {
            isIn = DimTypesEnum.PROCESS.getNumber().equals(clickDimNumber) ? mappingFilter.get(org).containsKey(process) : mappingFilter.get(org).containsKey(process) && mappingFilter.get(org).get(process).contains(audit);
        }
        return isIn;
    }

    private List<Map<String, Object>> getListInfo(Long entityId, Long sourceMemId, int rowNumber, IDNumberTreeNode processNode, IDNumberTreeNode atNode, IDNumberTreeNode curNode, Map<String, Object> selectMap) {
        ArrayList<Map<String, Object>> infos = new ArrayList<Map<String, Object>>(10);
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId);
        if ("CCTotal".equals(processNode.getNumber()) && "ATTotal".equals(atNode.getNumber())) {
            List<Map<String, Object>> dataList = this.queryExtData(selectMap, DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber());
            if (sourceMemId == null || sourceMemId == 0L) {
                sourceMemId = entityId;
            }
            this.getCCTotalNextLevel(sourceMemId, curNode.getNumber(), infos, dataList);
        } else if (("IRpt".equals(processNode.getNumber()) || "EIRpt".equals(processNode.getNumber())) && "ATTotal".equals(atNode.getNumber()) && entityNode.isLeaf() && !entityNode.getCurrency().equals(curNode.getNumber())) {
            selectMap.put(DimTypesEnum.CURRENCY.getNumber(), entityNode.getCurrency());
            selectMap.put(DimTypesEnum.PROCESS.getNumber(), "IRpt".equals(processNode.getNumber()) ? "ERpt" : "Rpt");
            List<Map<String, Object>> dataList = this.queryExtData(selectMap, DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber());
            this.getLeafEntitySelfCurrencyData(entityId, infos, dataList, selectMap);
        } else if (Objects.equals(entityId, processNode.getId()) || Objects.equals(entityId, atNode.getId())) {
            String clickDimNumber = processNode.isLeaf() ? atNode.getDimNumber() : processNode.getDimNumber();
            String clickMember = processNode.isLeaf() ? atNode.getNumber() : processNode.getNumber();
            List<Map<String, Object>> dataList = this.queryExtData(selectMap, DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.PROCESS.getNumber());
            this.openProcessOrAudit(rowNumber, this.getEffectiveSheet(), clickDimNumber, clickMember, infos, dataList);
        } else if (!processNode.isLeaf()) {
            List<Map<String, Object>> dataList = this.queryExtData(selectMap, DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.PROCESS.getNumber());
            this.getProcessOrAuditNextLevel(entityId, processNode, infos, dataList, rowNumber);
        } else if (!atNode.isLeaf()) {
            List<Map<String, Object>> dataList = this.queryExtData(selectMap, DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber());
            this.getProcessOrAuditNextLevel(entityId, atNode, infos, dataList, rowNumber);
        } else if ("EIRpt".equals(processNode.getNumber()) || "IRpt".equals(processNode.getNumber()) && "EntityInput".equals(atNode.getNumber())) {
            List<Map<String, Object>> dataList = this.queryExtData(selectMap, DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber());
            this.getEIRptNextLevel(entityId, sourceMemId, infos, dataList, curNode.getNumber());
        }
        return infos;
    }

    private void getLeafEntitySelfCurrencyData(Long entityId, List<Map<String, Object>> infos, List<Map<String, Object>> dataList, Map<String, Object> selectMap) {
        String clickDimNumber = DimTypesEnum.PROCESS.getNumber();
        List<Map<String, Object>> allAddChildrenNumbers = this.getAllAddChildrenNumbers(this.getModelNumber(), clickDimNumber, selectMap.get(clickDimNumber).toString());
        boolean showNoData = this.showNoData();
        String modelNumber = this.getModelNumber();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId);
        Set dims = MemberReader.getDimNumberMapNameById((long)this.getModelId()).keySet();
        for (Map<String, Object> map : allAddChildrenNumbers) {
            String processNum = map.get("number").toString();
            String auditNum = "ATTotal";
            List<String> selectCols = this.getCurSelectExtCols(orgNode, processNum, auditNum, orgNode.getCurrency());
            HashMap<String, Object> info = new HashMap<String, Object>(16);
            Map<String, Object> entityMap = this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), entityId);
            info.putIfAbsent(DimTypesEnum.ENTITY.getNumber(), entityMap);
            info.putIfAbsent(SOURCE_ENTITY, entityMap);
            info.putIfAbsent(DimTypesEnum.CURRENCY.getNumber(), this.getEntityMap(this.getModelId(), DimTypesEnum.CURRENCY.getNumber(), MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)orgNode.getCurrency()).getId()));
            Map<String, Map<String, Set<String>>> mappingFilter = this.getMappingFilter(entityId, (String)map.get("number"), "ATTotal");
            if (CollectionUtils.isNotEmpty(dataList)) {
                for (Map<String, Object> rows : dataList) {
                    boolean isIn = ExtDataTracePlugin.isInMapping(clickDimNumber, rows, mappingFilter);
                    if (isIn) {
                        info.put(clickDimNumber, this.getEntityMap(this.getModelId(), clickDimNumber, (Long)map.get("id")));
                        for (String col : selectCols) {
                            if (dims.contains(col) && rows.get(col) instanceof String) {
                                IDNumberTreeNode colNode = MemberReader.findMemberByNumber((String)modelNumber, (String)col, (String)((String)rows.get(col)));
                                if (colNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                                info.putIfAbsent(col, this.getEntityMap(this.getModelId(), col, colNode.getId()));
                                continue;
                            }
                            info.put(col, rows.get(col));
                        }
                    }
                    if (showNoData) {
                        for (String col : selectCols) {
                            info.putIfAbsent(col, null);
                        }
                    }
                    if (info.size() <= 3) continue;
                    infos.add(info);
                }
                continue;
            }
            if (!showNoData) continue;
            info.put(clickDimNumber, this.getEntityMap(this.getModelId(), clickDimNumber, (Long)map.get("id")));
            for (String col : selectCols) {
                info.putIfAbsent(col, null);
            }
            infos.add(info);
        }
    }

    private void getCCTotalNextLevel(Long sourceMemId, String currency, List<Map<String, Object>> infos, List<Map<String, Object>> dataList) {
        this.addCCTotalDataInfo(sourceMemId, sourceMemId, "Rpt", "ATTotal", currency, dataList, infos);
        for (String adjustProcess : ADJUST_PROCESS) {
            this.addCCTotalDataInfo(sourceMemId, sourceMemId, adjustProcess, "ATTotal", currency, dataList, infos);
        }
    }

    private void getProcessOrAuditNextLevel(Long entityId, IDNumberTreeNode node, List<Map<String, Object>> infos, List<Map<String, Object>> dataList, int rowNumber) {
        Sheet sheet = this.getEffectiveSheet();
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        boolean showNoData = this.showNoData();
        Cell sourceCell = sheet.getCell(rowNumber, columnIndexMap.get(SOURCE_ENTITY).intValue());
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId);
        boolean canFold = this.checkEntityCanFold(entityNode);
        if (canFold) {
            if (showNoData) {
                if (sourceCell.getValue() == null) {
                    Object isLeaf = sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.AUDITTRIAL.getNumber()).intValue()).getUserObject("isleaf");
                    if (node.getDimNumber().equals(DimTypesEnum.PROCESS.getNumber()) && isLeaf != null && !((Boolean)isLeaf).booleanValue()) {
                        this.addNoExistInfo(entityId, entityNode.getParent_SonNumber(), node, infos, dataList, rowNumber, columnIndexMap, false);
                    } else {
                        Map<String, IDNumberTreeNode> allChildEntity = this.getAllChildEntity(entityNode);
                        for (Map.Entry<String, IDNumberTreeNode> entry : allChildEntity.entrySet()) {
                            this.addNoExistInfo(entityId, entry.getValue().getParent_SonNumber(), node, infos, dataList, rowNumber, columnIndexMap, true);
                        }
                    }
                } else if (Objects.equals(sourceCell.getUserObject("number"), entityNode.getNumber())) {
                    Map<String, IDNumberTreeNode> allChildEntity = this.getAllChildEntity(entityNode);
                    for (Map.Entry<String, IDNumberTreeNode> entry : allChildEntity.entrySet()) {
                        this.addNoExistInfo(entityId, entry.getKey(), node, infos, dataList, rowNumber, columnIndexMap, true);
                    }
                } else {
                    this.addNoExistInfo(entityId, (String)sourceCell.getUserObject("number"), node, infos, dataList, rowNumber, columnIndexMap, true);
                }
            } else if (sourceCell.getValue() == null) {
                this.addExistInfo(entityId, entityNode.getVirtualEntity(), node, infos, dataList, rowNumber, columnIndexMap, false);
            } else {
                this.addExistInfo(entityId, MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)((Long)sourceCell.getUserObject("id"))).getParent_SonNumber(), node, infos, dataList, rowNumber, columnIndexMap, false);
            }
        } else if (showNoData) {
            this.addNoExistInfo(entityId, entityNode.getNumber(), node, infos, dataList, rowNumber, columnIndexMap, true);
        } else {
            this.addExistInfo(entityId, entityNode.getNumber(), node, infos, dataList, rowNumber, columnIndexMap, true);
        }
    }

    private void addExistInfo(Long entityId, String sourceNum, IDNumberTreeNode clickNode, List<Map<String, Object>> infos, List<Map<String, Object>> dataList, int rowNumber, Map<String, Integer> columnIndexMap, boolean think) {
        String modelNumber = this.getModelNumber();
        Sheet sheet = this.getEffectiveSheet();
        Set dims = MemberReader.getDimNumberMapNameById((long)this.getModelId()).keySet();
        List<Map<String, Object>> allAddChildrenNumbers = this.getAllAddChildrenNumbers(modelNumber, clickNode.getDimNumber(), clickNode.getNumber());
        Map<String, Object> entityMap = this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), entityId);
        for (Map<String, Object> map : allAddChildrenNumbers) {
            String processNum = DimTypesEnum.PROCESS.getNumber().equals(clickNode.getDimNumber()) ? map.get("number").toString() : (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.PROCESS.getNumber()).intValue()).getUserObject("number");
            String auditNum = DimTypesEnum.AUDITTRIAL.getNumber().equals(clickNode.getDimNumber()) ? map.get("number").toString() : (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.AUDITTRIAL.getNumber()).intValue()).getUserObject("number");
            String currencyNum = (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.CURRENCY.getNumber()).intValue()).getUserObject("number");
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId);
            List<String> selectCols = this.getCurSelectExtCols(entityNode, processNum, auditNum, currencyNum);
            Map<String, Map<String, Set<String>>> mappingFilter = this.getMappingFilter(entityId, rowNumber, clickNode.getDimNumber(), map.get("number").toString(), columnIndexMap);
            if (!CollectionUtils.isNotEmpty(dataList)) continue;
            if (this.checkEntityCanFold(entityNode, processNum, auditNum, currencyNum)) {
                HashMap<String, Object> info = new HashMap<String, Object>(16);
                info.put(clickNode.getDimNumber(), this.getEntityMap(this.getModelId(), clickNode.getDimNumber(), (Long)map.get("id")));
                info.put(DimTypesEnum.ENTITY.getNumber(), entityMap);
                for (Map<String, Object> rows : dataList) {
                    boolean isIn;
                    if (think && !Objects.equals(rows.get(DimTypesEnum.ENTITY.getNumber()), sourceNum) || !(isIn = ExtDataTracePlugin.isInMapping(clickNode.getDimNumber(), rows, mappingFilter))) continue;
                    for (String col2 : selectCols) {
                        IDNumberTreeNode colNode;
                        Object value = info.get(col2);
                        if (!dims.contains(col2)) {
                            if (value instanceof BigDecimal) {
                                info.put(col2, ((BigDecimal)value).add((BigDecimal)rows.get(col2)));
                                continue;
                            }
                            info.put(col2, rows.get(col2));
                            continue;
                        }
                        if (!(value instanceof String) || (colNode = MemberReader.findMemberByNumber((String)modelNumber, (String)col2, (String)((String)value))) == IDNumberTreeNode.NotFoundTreeNode) continue;
                        info.putIfAbsent(col2, this.getEntityMap(this.getModelId(), col2, colNode.getId()));
                    }
                    info.putIfAbsent(SOURCE_ENTITY, this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), MemberReader.findEntityMemberByNum((String)modelNumber, (String)sourceNum).getId()));
                    selectCols.forEach(col -> info.putIfAbsent((String)col, null));
                }
                if (info.size() <= 2) continue;
                infos.add(info);
                continue;
            }
            for (Map<String, Object> rows : dataList) {
                String clickDimNumber;
                boolean isIn;
                HashMap<String, Object> info = new HashMap<String, Object>(16);
                if (think && !Objects.equals(rows.get(DimTypesEnum.ENTITY.getNumber()), sourceNum) || !(isIn = ExtDataTracePlugin.isInMapping(clickDimNumber = clickNode.getDimNumber(), rows, mappingFilter))) continue;
                info.put(clickNode.getDimNumber(), this.getEntityMap(this.getModelId(), clickNode.getDimNumber(), (Long)map.get("id")));
                info.put(DimTypesEnum.ENTITY.getNumber(), this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), entityId));
                info.putIfAbsent(SOURCE_ENTITY, this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), MemberReader.findEntityMemberByNum((String)modelNumber, (String)((String)rows.get(ORG))).getId()));
                for (String col3 : selectCols) {
                    Object value = rows.get(col3);
                    if (dims.contains(col3) && value instanceof String) {
                        IDNumberTreeNode colNode = MemberReader.findMemberByNumber((String)modelNumber, (String)col3, (String)((String)value));
                        if (colNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                        info.putIfAbsent(col3, this.getEntityMap(this.getModelId(), col3, colNode.getId()));
                        continue;
                    }
                    info.put(col3, value);
                }
                infos.add(info);
                selectCols.forEach(col -> info.putIfAbsent((String)col, null));
            }
        }
    }

    private void addNoExistInfo(Long entityId, String sourceNum, IDNumberTreeNode clickNode, List<Map<String, Object>> infos, List<Map<String, Object>> dataList, int rowNumber, Map<String, Integer> columnIndexMap, boolean think) {
        String modelNumber = this.getModelNumber();
        Sheet sheet = this.getEffectiveSheet();
        Set dims = MemberReader.getDimNumberMapNameById((long)this.getModelId()).keySet();
        List<Map<String, Object>> allAddChildrenNumbers = this.getAllAddChildrenNumbers(modelNumber, clickNode.getDimNumber(), clickNode.getNumber());
        Map<String, Object> entityMap = this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), entityId);
        for (Map<String, Object> map : allAddChildrenNumbers) {
            HashMap<String, Object> info;
            String processNum = DimTypesEnum.PROCESS.getNumber().equals(clickNode.getDimNumber()) ? map.get("number").toString() : (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.PROCESS.getNumber()).intValue()).getUserObject("number");
            String auditNum = DimTypesEnum.AUDITTRIAL.getNumber().equals(clickNode.getDimNumber()) ? map.get("number").toString() : (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.AUDITTRIAL.getNumber()).intValue()).getUserObject("number");
            String currencyNum = (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.CURRENCY.getNumber()).intValue()).getUserObject("number");
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId);
            List<String> selectCols = this.getCurSelectExtCols(entityNode, processNum, auditNum, currencyNum);
            Map<String, Map<String, Set<String>>> mappingFilter = this.getMappingFilter(entityId, rowNumber, clickNode.getDimNumber(), map.get("number").toString(), columnIndexMap);
            Map<String, Object> sourceEntity = this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), MemberReader.findEntityMemberByNum((String)modelNumber, (String)sourceNum).getId());
            if (CollectionUtils.isNotEmpty(dataList)) {
                if (this.checkEntityCanFold(entityNode, processNum, auditNum, currencyNum)) {
                    info = new HashMap<String, Object>(16);
                    info.put(clickNode.getDimNumber(), this.getEntityMap(this.getModelId(), clickNode.getDimNumber(), (Long)map.get("id")));
                    info.put(DimTypesEnum.ENTITY.getNumber(), entityMap);
                    for (Map<String, Object> rows : dataList) {
                        boolean isIn;
                        if (think && !Objects.equals(rows.get(DimTypesEnum.ENTITY.getNumber()), sourceNum) || !(isIn = ExtDataTracePlugin.isInMapping(clickNode.getDimNumber(), rows, mappingFilter))) continue;
                        for (String col2 : selectCols) {
                            IDNumberTreeNode colNode;
                            Object value = info.get(col2);
                            if (!dims.contains(col2)) {
                                if (value instanceof BigDecimal) {
                                    info.put(col2, ((BigDecimal)value).add((BigDecimal)rows.get(col2)));
                                    continue;
                                }
                                info.put(col2, rows.get(col2));
                                continue;
                            }
                            if (!(value instanceof String) || (colNode = MemberReader.findMemberByNumber((String)modelNumber, (String)col2, (String)((String)value))) == IDNumberTreeNode.NotFoundTreeNode) continue;
                            info.putIfAbsent(col2, this.getEntityMap(this.getModelId(), col2, colNode.getId()));
                        }
                    }
                    info.putIfAbsent(SOURCE_ENTITY, sourceEntity);
                    selectCols.forEach(col -> info.putIfAbsent((String)col, null));
                    infos.add(info);
                    continue;
                }
                for (Map map2 : dataList) {
                    HashMap<String, Map<String, Object>> info2 = new HashMap<String, Map<String, Object>>(16);
                    String clickDimNumber = clickNode.getDimNumber();
                    boolean isIn = ExtDataTracePlugin.isInMapping(clickDimNumber, map2, mappingFilter);
                    info2.put(clickNode.getDimNumber(), this.getEntityMap(this.getModelId(), clickNode.getDimNumber(), (Long)map.get("id")));
                    info2.put(DimTypesEnum.ENTITY.getNumber(), entityMap);
                    info2.putIfAbsent(SOURCE_ENTITY, sourceEntity);
                    if (isIn) {
                        for (String col3 : selectCols) {
                            Object value = map2.get(col3);
                            if (dims.contains(col3) && value instanceof String) {
                                IDNumberTreeNode colNode = MemberReader.findMemberByNumber((String)modelNumber, (String)col3, (String)((String)value));
                                if (colNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                                info2.putIfAbsent(col3, this.getEntityMap(this.getModelId(), col3, colNode.getId()));
                                continue;
                            }
                            info2.put(col3, (Map<String, Object>)value);
                        }
                    }
                    infos.add(info2);
                }
                continue;
            }
            info = new HashMap(16);
            if (this.checkEntityCanFold(entityNode, processNum, auditNum, currencyNum)) {
                info.put(DimTypesEnum.ENTITY.getNumber(), entityMap);
            } else {
                info.put(DimTypesEnum.ENTITY.getNumber(), sourceEntity);
            }
            info.put(clickNode.getDimNumber(), this.getEntityMap(this.getModelId(), clickNode.getDimNumber(), (Long)map.get("id")));
            info.putIfAbsent(SOURCE_ENTITY, sourceEntity);
            selectCols.forEach(col -> info.putIfAbsent((String)col, null));
            infos.add(info);
        }
    }

    private void getEIRptNextLevel(Long entityId, Long sourceMemId, List<Map<String, Object>> infos, List<Map<String, Object>> dataList, String currency) {
        if (sourceMemId != null && sourceMemId != 0L && !Objects.equals(entityId, sourceMemId)) {
            this.addCCTotalDataInfo(entityId, sourceMemId, "CCTotal", "ATTotal", currency, dataList, infos);
        } else {
            String modelNum = this.getModelNumber();
            String dAdj = MemberReader.findProcessMemberByNum((String)modelNum, (String)"DADJ").getNumber();
            String dEje = MemberReader.findProcessMemberByNum((String)modelNum, (String)"DEJE").getNumber();
            String total = MemberReader.findMemberByNumber((String)modelNum, (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)"ATTotal").getNumber();
            this.addCCTotalDataInfo(entityId, entityId, dAdj, total, currency, dataList, infos);
            this.addCCTotalDataInfo(entityId, entityId, dEje, total, currency, dataList, infos);
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId);
            Map<String, IDNumberTreeNode> map = this.getAllChildEntity(entityNode);
            for (Map.Entry<String, IDNumberTreeNode> entry : map.entrySet()) {
                this.addCCTotalDataInfo(entityId, entry.getValue().getId(), "CCTotal", "ATTotal", currency, dataList, infos);
            }
        }
    }

    private Map<String, IDNumberTreeNode> getAllChildEntity(IDNumberTreeNode entityNode) {
        long scenarioID = this.getPageDim(scenario).getLong("id");
        long yearID = this.getPageDim(year).getLong("id");
        long periodID = this.getPageDim(period).getLong("id");
        Set notMergeSet = MergeControlHelper.getNoMergeOrgIdWithChildrenByNumber((Long)this.getModelId(), (Long)scenarioID, (Long)yearID, (Long)periodID, (String)entityNode.getLongNumber());
        Map mdsSourceMap = MergeControlHelper.geAllMergeDs((Object)this.getModelId(), (Object)scenarioID, (Object)yearID, (Object)periodID);
        this.filterNoMergeSet(entityNode, scenarioID, yearID, periodID, notMergeSet, mdsSourceMap);
        Set removeParents = entityNode.getAllChildren().stream().filter(node -> !notMergeSet.contains(node.getId()) && (node.isLeaf() || !node.isLeaf() && MergeDataSourceEnum.CSTE.getIndex().equals(mdsSourceMap.get(node.getId())))).map(IDNumberTreeNode::getLongNumber).collect(Collectors.toSet());
        HashSet removeNums = new HashSet(16);
        for (String longNum : removeParents) {
            Object[] splits = longNum.split("!");
            removeNums.addAll(Sets.newHashSet((Object[])splits));
        }
        HashMap<String, IDNumberTreeNode> map = new HashMap<String, IDNumberTreeNode>(16);
        for (IDNumberTreeNode idNumberTreeNode : entityNode.getAllChildren()) {
            if (notMergeSet.contains(idNumberTreeNode.getId())) continue;
            if (idNumberTreeNode.isLeaf()) {
                map.putIfAbsent(idNumberTreeNode.getNumber(), idNumberTreeNode);
                continue;
            }
            if (removeNums.contains(idNumberTreeNode.getNumber())) continue;
            map.putIfAbsent(idNumberTreeNode.getNumber(), idNumberTreeNode);
        }
        return map;
    }

    private void addCCTotalDataInfo(Long parentEntityId, Long entityId, String process, String audit, String currency, List<Map<String, Object>> dataList, List<Map<String, Object>> infos) {
        HashMap<String, Object> info = new HashMap<String, Object>(16);
        String modelNum = this.getModelNumber();
        Map<String, Object> entityMap = this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), parentEntityId);
        if (!"CCTotal".equals(process) && OrgRelaProcessMembPool.isRelaProcess((String)process)) {
            entityMap.put("isadjust", true);
        }
        info.put(DimTypesEnum.ENTITY.getNumber(), entityMap);
        info.put(SOURCE_ENTITY, this.getEntityMap(this.getModelId(), DimTypesEnum.ENTITY.getNumber(), entityId));
        Long processId = MemberReader.findProcessMemberByNum((String)modelNum, (String)process).getId();
        info.put(DimTypesEnum.PROCESS.getNumber(), this.getEntityMap(this.getModelId(), DimTypesEnum.PROCESS.getNumber(), processId));
        Long auditId = MemberReader.findMemberByNumber((String)modelNum, (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)audit).getId();
        info.put(DimTypesEnum.AUDITTRIAL.getNumber(), this.getEntityMap(this.getModelId(), DimTypesEnum.AUDITTRIAL.getNumber(), auditId));
        boolean showNoData = this.showNoData();
        Map<String, Map<String, Set<String>>> mappingFilter = this.getMappingFilter(entityId, process, audit);
        List<String> selectCols = this.getCurSelectExtCols(MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId), process, audit, currency);
        String modelNumber = this.getModelNumber();
        Set dims = MemberReader.getDimNumberMapNameById((long)this.getModelId()).keySet();
        if (CollectionUtils.isNotEmpty(dataList)) {
            for (Map<String, Object> rows : dataList) {
                boolean isIn;
                String orgNum = (String)rows.get(ORG);
                String processNum = (String)rows.get(DimTypesEnum.PROCESS.getNumber());
                String auditNum = (String)rows.get(DimTypesEnum.AUDITTRIAL.getNumber());
                boolean bl = isIn = mappingFilter.containsKey(orgNum) && mappingFilter.get(orgNum).containsKey(processNum) && mappingFilter.get(orgNum).get(processNum).contains(auditNum);
                if (isIn) {
                    for (String col2 : selectCols) {
                        Object value = info.get(col2);
                        if (dims.contains(col2) && rows.get(col2) instanceof String) {
                            IDNumberTreeNode colNode = MemberReader.findMemberByNumber((String)modelNumber, (String)col2, (String)((String)value));
                            if (colNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                            info.putIfAbsent(col2, this.getEntityMap(this.getModelId(), col2, colNode.getId()));
                            continue;
                        }
                        if (value instanceof BigDecimal) {
                            info.put(col2, ((BigDecimal)value).add((BigDecimal)rows.get(col2)));
                            continue;
                        }
                        info.put(col2, rows.get(col2));
                    }
                }
                if (!showNoData) continue;
                selectCols.forEach(col -> info.putIfAbsent((String)col, null));
            }
            if (info.size() > 4) {
                infos.add(info);
            }
        } else if (showNoData) {
            selectCols.forEach(col -> info.putIfAbsent((String)col, null));
            infos.add(info);
        }
    }

    private Map<String, Object> getEntityMap(long modelId, String dim, long memId) {
        IDNumberTreeNode idNumberTreeNode = MemberReader.findMemberById((long)modelId, (String)MemberReader.getEntityNumberByDim((String)this.getModelNumber(), (String)dim), (Long)memId);
        HashMap<String, Object> info = new HashMap<String, Object>(16);
        info.put("number", idNumberTreeNode.getNumber());
        info.put("name", idNumberTreeNode.getName());
        info.put("id", idNumberTreeNode.getId());
        info.put("isleaf", idNumberTreeNode.isLeaf());
        info.put("level", idNumberTreeNode.getLevel());
        return info;
    }

    private void insertSpaceRow(int rowNumber, int insertCount, Sheet sheet) {
        LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
        map.put("status", Boolean.valueOf(true));
        ArrayList<Integer> insertRowNumbers = new ArrayList<Integer>(insertCount);
        int insertRowNumber = rowNumber + 1;
        for (int j = 0; j < insertCount; ++j) {
            insertRowNumbers.add(insertRowNumber);
            sheet.insertRow(insertRowNumber);
        }
        map.put("data", insertRowNumbers);
        SpreadClientInvoker.invokeInsertRow(this.getClientViewProxy(), spreadKey, map);
    }

    private Map<String, Object> collectClickDimRowValue(int rowNum, Sheet sheet) {
        HashMap<String, Object> res = new HashMap<String, Object>(16);
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        for (Map.Entry<String, Integer> entry : columnIndexMap.entrySet()) {
            String dim = entry.getKey();
            Integer col = entry.getValue();
            Cell cell = sheet.getCell(rowNum, col.intValue());
            Object value = cell.getValue();
            if (!this.isContainSuchCol(dim) && value == null) continue;
            UserObject userObject = cell.getUserObject();
            if (userObject == null || userObject.isEmpty()) {
                if (value instanceof String && DateTimeUtils.isOADate((String)((String)value))) {
                    try {
                        res.put(dim, DateTimeUtils.parseOADate((String)((String)value)));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"ExtDataTracePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                }
                FieldEntry fieldEntry = this.getExtendsModel().getFieldEntryByNumber(dim);
                if (fieldEntry != null && fieldEntry.getFieldType() == FieldTypeEnum.EXT_FIELD.getType() && fieldEntry.getExtField().getMapped().contains("numext")) {
                    if (!fieldEntry.getUniqueCheck()) continue;
                    if (value == null) {
                        value = BigDecimal.ZERO;
                    }
                    res.put(dim, value);
                    continue;
                }
                if (fieldEntry != null && fieldEntry.getFieldType() == FieldTypeEnum.EXT_FIELD.getType() && fieldEntry.getExtField().getMapped().contains("textext")) {
                    if (value == null || StringUtils.isEmpty((String)value.toString())) {
                        res.put(dim, "");
                        continue;
                    }
                    res.put(dim, value);
                    continue;
                }
                res.put(dim, value);
                continue;
            }
            Long id = (Long)userObject.get((Object)"id");
            if (id == null) continue;
            String modelNumber = this.getModelNumber();
            if (dim.equals(SOURCE_ENTITY)) {
                dim = DimTypesEnum.ENTITY.getNumber();
            }
            IDNumberTreeNode memNode = MemberReader.findMemberById((String)modelNumber, (String)MemberReader.getEntityNumberByDim((String)modelNumber, (String)dim), (Long)id);
            String mem = DimTypesEnum.ENTITY.getNumber().equals(entry.getKey()) ? memNode.getParent_SonNumber() : memNode.getNumber();
            res.put(entry.getKey(), mem);
        }
        return res;
    }

    private List<Map<String, Object>> queryExtData(Map<String, Object> selectMap, String clickDim, String foldDim) {
        String modelNum = MemberReader.findModelSNumberById((Object)this.getModelId());
        EdQueryComInfo queryComInfo = new EdQueryComInfo(modelNum, this.getExtendsModel().getExtendsGroupNumber(), this.getExtendsModel().getNumber());
        String entity = (String)selectMap.get(DimTypesEnum.ENTITY.getNumber());
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)this.getModelNumber(), (String)entity);
        queryComInfo.setParentOrg(entityNode.getParent().getNumber());
        queryComInfo.setMainOrgId(entityNode.getId().longValue());
        for (String fixDim : ExtDataTraceHelper.COM_DIM) {
            if (ExtDataTraceHelper.CHANGE_COM_DIM.contains(fixDim)) {
                queryComInfo.addDimFilter(fixDim, new String[]{((DynamicObject)this.getValue(fixDim.toLowerCase())).getString("number")});
                continue;
            }
            if (DimTypesEnum.ENTITY.getNumber().equals(fixDim)) {
                entity = selectMap.get(fixDim).toString().contains("_") ? selectMap.get(fixDim).toString().split("_")[1] : selectMap.get(fixDim).toString();
                queryComInfo.addDimFilter(fixDim, new String[]{entity});
                continue;
            }
            queryComInfo.addDimFilter(fixDim, new String[]{(String)selectMap.get(fixDim)});
        }
        ArrayList<String> dimSelects = new ArrayList<String>(10);
        dimSelects.add(ORG);
        dimSelects.add(DimTypesEnum.PROCESS.getNumber());
        dimSelects.add(DimTypesEnum.AUDITTRIAL.getNumber());
        if (foldDim != null) {
            dimSelects.add(DimTypesEnum.ENTITY.getNumber());
        }
        boolean canFold = this.checkEntityNextCanFold(entityNode, selectMap);
        List dimEntry = this.getExtendsModel().getDimFieldEntry();
        dimEntry.forEach(dimField -> {
            if (this.isContainSuchCol(dimField.getDimension().getNumber()) || !canFold) {
                dimSelects.add(dimField.getDimension().getNumber());
            }
        });
        queryComInfo.setDimselects(dimSelects.toArray(new String[0]));
        ArrayList extSelects = new ArrayList(10);
        List fieldEntry = this.getExtendsModel().getExtFieldEntry();
        List<String> selectExt = this.getSelectExt();
        fieldEntry.forEach(extFieldEntry -> {
            if (selectExt.contains(extFieldEntry.getExtField().getNumber())) {
                extSelects.add(extFieldEntry.getExtField().getNumber());
            } else if ((extFieldEntry.getUniqueCheck() || extFieldEntry.getExtField().getMapped().contains("textext")) && (this.isContainSuchCol(extFieldEntry.getExtField().getNumber()) || !canFold)) {
                extSelects.add(extFieldEntry.getExtField().getNumber());
            }
        });
        if (!extSelects.isEmpty()) {
            queryComInfo.setExtselects(extSelects.toArray(new String[0]));
        }
        String sourceEntity = (String)selectMap.get(SOURCE_ENTITY);
        IDNumberTreeNode sourceNode = MemberReader.findEntityMemberByNum((String)this.getModelNumber(), (String)sourceEntity);
        QFilter lastQFilter = null;
        for (Map.Entry<String, Object> entry : selectMap.entrySet()) {
            if (ExtDataTraceHelper.COM_DIM.contains(entry.getKey())) continue;
            String mapped = "";
            if (entry.getKey().equals(SOURCE_ENTITY)) {
                if (!sourceNode.isLeaf()) continue;
                mapped = DimTypesEnum.ENTITY.getNumber().toLowerCase();
            } else {
                String fieldMapped;
                FieldEntry field = this.getExtendsModel().getFieldEntryByNumber(entry.getKey());
                mapped = field.getFieldType() == FieldTypeEnum.EXT_FIELD.getType() ? field.getExtField().getMapped() : (StringUtils.isEmpty((String)(fieldMapped = ((DynamicObject)MemberReader.getDimDyoByModelId((long)this.getModelId()).get(field.getDimension().getNumber())).getString("fieldmapped"))) ? field.getDimension().getNumber().toLowerCase() : fieldMapped);
            }
            QFilter temp = entry.getValue() == null ? new QFilter(mapped, "is null", null) : new QFilter(mapped, "=", entry.getValue());
            if (lastQFilter == null) {
                lastQFilter = temp;
                continue;
            }
            lastQFilter.and(temp);
        }
        if (lastQFilter != null) {
            queryComInfo.setCustomFilter(lastQFilter);
        }
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(10);
        try (EDResultSet rs = ExtDataServiceHelper.queryData((EdQueryComInfo)queryComInfo);){
            for (EDRow row : rs.getRows()) {
                Object value;
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                for (String dimSelect : dimSelects) {
                    value = row.getOriginalValue(dimSelect);
                    result.put(dimSelect, value);
                }
                for (String extSelect : extSelects) {
                    value = row.getOriginalValue(extSelect);
                    if (value instanceof Date) {
                        value = DateTimeUtils.convertToOADate((Date)((Date)value));
                    } else if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).stripTrailingZeros();
                    }
                    result.put(extSelect, value);
                }
                data.add(result);
            }
        }
        ThreadCache.put((Object)GET_QUERYMAPPING_FILTER, (Object)queryComInfo);
        return data;
    }

    private void buildSingleNewRow(int rowNumber, int colNumber, Sheet sheet, List<Map<String, Object>> cellValues, Map<String, Object> map, int insertRow, String clickDimNumber) {
        Cell clickCell = sheet.getCell(rowNumber, colNumber);
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        for (int j = 0; j < sheet.getMaxColumnCount(); ++j) {
            Cell dimCell = sheet.getCell(0, j);
            if (dimCell.getUserObject("number") == null) continue;
            if (j == colNumber) {
                Map info = (Map)map.get(clickDimNumber);
                if (info == null) continue;
                this.buildSingleCellData(cellValues, insertRow, info, j, sheet, clickCell, dimCell.getUserObject("number").toString());
                continue;
            }
            if (map.containsKey(dimCell.getUserObject("number").toString())) {
                Object cellValue = map.get(dimCell.getUserObject("number").toString());
                Cell cell = sheet.getCell(insertRow, j);
                if (dimCell.getUserObject("dimId") == null) {
                    cell.setValue(cellValue);
                    cellValues.add(this.packedUpdateCellMap(insertRow, j, cellValue));
                    continue;
                }
                if (!(cellValue instanceof Map)) continue;
                Map info = (Map)cellValue;
                String displayContent = this.getDisplayContent(info, cell, dimCell.getUserObject("number").toString());
                displayContent = this.dealPrefix(sheet, displayContent, cell);
                cell.setValue((Object)displayContent);
                cell.setUserObject("number", (Object)info.getOrDefault("number", ""));
                cell.setUserObject("name", (Object)info.getOrDefault("name", ""));
                cell.setUserObject("id", info.get("id"));
                cell.setUserObject("level", info.get("level"));
                cell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
                cellValues.add(this.packedUpdateCellMap(insertRow, j, displayContent));
                continue;
            }
            this.copyOldCell(rowNumber, sheet, clickCell, cellValues, columnIndexMap, insertRow, j);
        }
        this.dealEntityCell(sheet, cellValues, insertRow, columnIndexMap, clickDimNumber);
    }

    private String dealPrefix(Sheet sheet, String displayContent, Cell cell) {
        int col;
        int row;
        Cell oldCell;
        Object ti;
        String newDisplayContent = displayContent;
        String dim = sheet.getCell(0, cell.getCol()).getUserObject("number").toString();
        if ((DimTypesEnum.AUDITTRIAL.getNumber().equals(dim) || DimTypesEnum.PROCESS.getNumber().equals(dim)) && (ti = (oldCell = sheet.getCell((row = cell.getRow()) - 1, col = cell.getCol())).getUserObject("ti")) instanceof Integer) {
            cell.setUserObject("ti", ti);
            SearchHelper.setIndent(this.getClientViewProxy(), spreadKey, row, col, 1, 1, (Integer)ti);
        }
        return newDisplayContent;
    }

    private void dealEntityCell(Sheet sheet, List<Map<String, Object>> cellValues, int insertRow, Map<String, Integer> columnIndexMap, String clickDimNumber) {
        Object ti;
        String displayContent;
        String processNum = sheet.getCell(insertRow, columnIndexMap.get(DimTypesEnum.PROCESS.getNumber()).intValue()).getUserObject("number").toString();
        String atNum = sheet.getCell(insertRow, columnIndexMap.get(DimTypesEnum.AUDITTRIAL.getNumber()).intValue()).getUserObject("number").toString();
        String currencyNum = sheet.getCell(insertRow, columnIndexMap.get(DimTypesEnum.CURRENCY.getNumber()).intValue()).getUserObject("number").toString();
        Cell entityCell = sheet.getCell(insertRow, 0);
        if (entityCell.getValue() == null) {
            return;
        }
        Long entityId = (Long)entityCell.getUserObject().get((Object)"id");
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId);
        String entityValue = entityCell.getValue().toString();
        if (this.checkEntityCanFold(entityNode, processNum, atNum, currencyNum) && entityCell.getUserObject("isadjust") == null) {
            displayContent = this.getDisplayContent(MapInitHelper.ofMap((Object)"number", (Object)entityNode.getNumber(), (Object)"name", (Object)entityNode.getName()), entityCell, DimTypesEnum.ENTITY.getNumber());
            entityCell.setValue((Object)displayContent);
            cellValues.add(this.packedUpdateCellMap(insertRow, 0, displayContent));
        } else {
            displayContent = entityValue.replace(EXPAND_PLUS, "");
            entityCell.setValue((Object)displayContent);
            cellValues.add(this.packedUpdateCellMap(insertRow, 0, displayContent));
        }
        if (!DimTypesEnum.ENTITY.getNumber().equals(clickDimNumber) && (ti = sheet.getCell(insertRow - 1, 0).getUserObject("ti")) instanceof Integer) {
            entityCell.setUserObject("ti", ti);
            SearchHelper.setIndent(this.getClientViewProxy(), spreadKey, insertRow, 0, 1, 1, (Integer)ti);
        }
    }

    private void copyOldCell(int rowNumber, Sheet sheet, Cell cell, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap, int insertRowNum, int col) {
        Cell newCell = sheet.getCell(insertRowNum, col);
        Cell oldCell = sheet.getCell(rowNumber, col);
        if (oldCell.getValue() == null) {
            return;
        }
        String oldValue = oldCell.getValue().toString();
        if (oldValue.startsWith(EXPAND_SUB)) {
            oldValue = oldValue.replace(EXPAND_SUB, EXPAND_PLUS);
        }
        if (columnIndexMap.get("Entity") == col) {
            oldValue = oldValue.replace(EXPAND_PLUS, "");
        }
        if (oldCell.getUserObject("number") != null) {
            String number = oldCell.getUserObject("number").toString();
            newCell.setValue((Object)oldValue);
            newCell.setUserObject("number", (Object)number);
            newCell.setUserObject("name", oldCell.getUserObject("name"));
            newCell.setUserObject("id", oldCell.getUserObject("id"));
            newCell.setUserObject("level", oldCell.getUserObject("level"));
            if (columnIndexMap.get("Entity") != col) {
                newCell.setUserObject("isleaf", oldCell.getUserObject("isleaf"));
            }
            newCell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
            newCell.setUserObject("openParent", cell.getUserObject("cellFlag"));
            newCell.setUserObject("parentCell", (Object)cell);
            cellValues.add(this.packedUpdateCellMap(insertRowNum, col, oldValue));
        } else {
            Cell dimCell = sheet.getCell(0, col);
            if (!this.getSelectExt().contains(dimCell.getUserObject("number").toString())) {
                newCell.setValue(oldCell.getValue());
                cellValues.add(this.packedUpdateCellMap(insertRowNum, col, oldCell.getValue()));
            }
        }
    }

    private boolean checkEntityNextCanFold(IDNumberTreeNode entityNode, Map<String, Object> selectMap) {
        EdQueryComInfo queryComInfo = new EdQueryComInfo(MemberReader.findModelSNumberById((Object)this.getModelId()), this.getExtendsModel().getExtendsGroupNumber(), this.getExtendsModel().getNumber());
        queryComInfo.setParentOrg(entityNode.getParent().getNumber());
        queryComInfo.setMainOrgId(entityNode.getId().longValue());
        for (String fixDim : ExtDataTraceHelper.COM_DIM) {
            if (ExtDataTraceHelper.CHANGE_COM_DIM.contains(fixDim)) {
                queryComInfo.addDimFilter(fixDim, new String[]{((DynamicObject)this.getValue(fixDim.toLowerCase())).getString("number")});
                continue;
            }
            if (DimTypesEnum.ENTITY.getNumber().equals(fixDim)) {
                queryComInfo.addDimFilter(fixDim, new String[]{entityNode.getNumber()});
                continue;
            }
            queryComInfo.addDimFilter(fixDim, new String[]{(String)selectMap.get(fixDim)});
        }
        Map mappingFilter = ExtDataServiceHelper.getQueryMappingFilter((EdQueryComInfo)queryComInfo);
        if (mappingFilter.isEmpty()) {
            return false;
        }
        if (mappingFilter.size() == 1) {
            Map map = (Map)new ArrayList(mappingFilter.values()).get(0);
            if (map.isEmpty()) {
                return false;
            }
            if (map.size() == 1) {
                return false;
            }
            return new ArrayList(map.values()).stream().anyMatch(adts -> adts.size() > 2);
        }
        return true;
    }

    private boolean checkEntityCanFold(IDNumberTreeNode entityNode, String processNum, String auditTrailNum, String currency) {
        IDNumberTreeNode processNode = MemberReader.findProcessMemberByNum((String)this.getModelNumber(), (String)processNum);
        IDNumberTreeNode auditNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)auditTrailNum);
        if (processNode.getNumber().equals("DADJ") || processNode.getNumber().equals("DEJE")) {
            return false;
        }
        if (!processNode.isLeaf() || !auditNode.isLeaf()) {
            return true;
        }
        IDNumberTreeNode group = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_structofextend", (Long)this.getExtendsModel().getExtendsGroup());
        if (((Boolean)group.getProperty(IS_PARTICIP_MERGE)).booleanValue()) {
            MergeDataSourceEnum mergeSource = MergeControlHelper.getMergeSource((Object)this.getModelId(), (Object)this.getPageDim(scenario).getLong("id"), (Object)this.getPageDim(year).getLong("id"), (Object)this.getPageDim(period).getLong("id"), (Object)entityNode.getId());
            return entityNode.isLeaf() && !entityNode.getCurrency().equals(currency) && ("IRpt".equals(processNum) || "EIRpt".equals(auditTrailNum)) || !entityNode.isLeaf() && MergeDataSourceEnum.SIRpt == mergeSource && (processNode.getNumber().equals("EIRpt") || processNode.getNumber().equals("IRpt")) && auditNode.getNumber().equals("EntityInput");
        }
        return false;
    }

    private boolean checkEntityCanFold(IDNumberTreeNode entityNode) {
        IDNumberTreeNode group = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_structofextend", (Long)this.getExtendsModel().getExtendsGroup());
        if (((Boolean)group.getProperty(IS_PARTICIP_MERGE)).booleanValue()) {
            MergeDataSourceEnum mergeSource = MergeControlHelper.getMergeSource((Object)this.getModelId(), (Object)this.getPageDim(scenario).getLong("id"), (Object)this.getPageDim(year).getLong("id"), (Object)this.getPageDim(period).getLong("id"), (Object)entityNode.getId());
            return !entityNode.isLeaf() && MergeDataSourceEnum.SIRpt == mergeSource;
        }
        return false;
    }

    private void buildSingleCellData(List<Map<String, Object>> cellValues, int rowNum, Map<String, Object> info, int colNum, Sheet sheet, Cell clickCell, String dimNum) {
        Cell cell = sheet.getCell(rowNum, colNum);
        String displayContent = this.getDisplayContent(info, cell, dimNum);
        SearchHelper.setCellIndent(this.getClientViewProxy(), spreadKey, sheet.getCell(clickCell.getRow(), colNum), cell);
        cell.setValue((Object)displayContent);
        cell.setUserObject("number", info.getOrDefault("number", ""));
        cell.setUserObject("name", info.getOrDefault("name", ""));
        cell.setUserObject("id", info.get("id"));
        cell.setUserObject("level", info.get("level"));
        if (info.containsKey("isadjust")) {
            cell.setUserObject("isadjust", info.get("isadjust"));
        }
        cell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
        if (clickCell.getUserObject("cellFlag") != null) {
            cell.setUserObject("openParent", clickCell.getUserObject("cellFlag"));
            cell.setUserObject("parentCell", (Object)clickCell);
        }
        cellValues.add(this.packedUpdateCellMap(rowNum, colNum, displayContent));
    }

    private String getDisplayContent(Map<String, Object> info, Cell cell, String dim) {
        String showType = this.getModel().getValue("showtype").toString();
        String displayContent = "";
        if (info.containsKey("isadjust")) {
            Long entityId = (Long)info.get("id");
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId);
            displayContent = "btn_number".equalsIgnoreCase(showType) ? entityNode.getParent_SonNumber() : ("btn_name".equalsIgnoreCase(showType) ? entityNode.getParent().getName() + "_" + entityNode.getName() : entityNode.getParent().getName() + "_" + entityNode.getName() + "|" + entityNode.getParent_SonNumber());
        } else {
            displayContent = info.getOrDefault("name", "") + "_" + info.getOrDefault("number", "");
            if ("btn_number".equalsIgnoreCase(showType)) {
                displayContent = info.getOrDefault("number", "").toString();
            } else if ("btn_name".equalsIgnoreCase(showType)) {
                displayContent = info.getOrDefault("name", "").toString();
            }
        }
        if (info.get("isleaf") != null && ((Boolean)info.get("isleaf")).booleanValue() || cell.getCol() == 1) {
            cell.setUserObject("isleaf", (Object)1);
        } else if (dim.equals(DimTypesEnum.ENTITY.getNumber())) {
            displayContent = EXPAND_PLUS + displayContent;
        }
        return displayContent;
    }

    protected List<Map<String, Object>> getAllAddChildrenNumbers(String modelNumber, String dimNumber, String memberNumber) {
        IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)memberNumber);
        ArrayList<IDNumberTreeNode> allChildren = memberByNumber.getAllChildren();
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>(10);
        allChildren = new ArrayList<IDNumberTreeNode>(allChildren);
        allChildren.add(memberByNumber);
        allChildren.sort((node1, node2) -> {
            if (node1.getLevel() != node2.getLevel()) {
                return node1.getLevel() - node2.getLevel();
            }
            return node1.getdSeq() - node2.getdSeq();
        });
        for (IDNumberTreeNode idNumberTreeNode : allChildren) {
            if (!AggOprtEnum.ADD.name.equals(idNumberTreeNode.getAggOprt()) || idNumberTreeNode.getStorageType() == StorageTypeEnum.DYNAMIC) continue;
            nodes.add(this.getEntityMap(this.getModelId(), dimNumber, idNumberTreeNode.getId()));
        }
        if (dimNumber.equals(DimTypesEnum.PROCESS.getNumber()) && REMOVE_IRPT_PROCESS.contains(memberNumber)) {
            nodes.removeIf(map -> map.get("number").toString().equals("IRpt") || map.get("number").toString().equals("RAdj"));
        }
        return nodes;
    }

    private void updateSelectCellValue(int rowNumber, int colNumber, List<Map<String, Object>> cellValues) {
        Cell cell = this.getEffectiveSheet().getCell(rowNumber, colNumber);
        String newCellValue = cell.getValue().toString().replace(EXPAND_PLUS, EXPAND_SUB);
        cell.setValue((Object)newCellValue);
        cellValues.add(this.packedUpdateCellMap(rowNumber, colNumber, newCellValue));
    }

    private void buildSpreadDataInit(List<Map<String, Object>> cellValues) {
        List selectDimCell = (List)this.getFormCustomParam("SELECT_DIM_CELL");
        Sheet sheet = this.getEffectiveSheet();
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        Map commonDimMap = (Map)this.getFormCustomParam("COMMON_DIM_INFO");
        int row = 1;
        String showType = this.getModel().getValue("showtype").toString();
        for (Map map : selectDimCell) {
            for (Map.Entry<String, Integer> entry : columnIndexMap.entrySet()) {
                String displayContent = "";
                IDNumberTreeNode node = null;
                String colNum = entry.getKey();
                Integer col = entry.getValue();
                Cell cell = sheet.getCell(row, col.intValue());
                if (SOURCE_ENTITY.equals(colNum)) {
                    if (map.containsKey(DimTypesEnum.ENTITY.getNumber())) {
                        IDNumberTreeNode parentNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)((Long)this.getFormCustomParam("COMMON_ENTITY_ID")));
                        if (parentNode.getNumber().equals(map.get(DimTypesEnum.ENTITY.getNumber()))) {
                            node = parentNode;
                        } else {
                            Optional<IDNumberTreeNode> first;
                            String parent = parentNode.getNumber();
                            node = MemberReader.findEntityMemberByNum((String)this.getModelNumber(), (String)((String)map.get(DimTypesEnum.ENTITY.getNumber())));
                            HashSet parents = Sets.newHashSet((Object[])node.getLongNumber().split("!"));
                            if (!parents.contains(parent) && (first = node.getShareNodes().stream().filter(te -> Sets.newHashSet((Object[])te.getLongNumber().split("!")).contains(parent)).findFirst()).isPresent()) {
                                node = first.get();
                            }
                        }
                    }
                } else if (DimTypesEnum.ENTITY.getNumber().equals(colNum)) {
                    Long entityId = (Long)this.getFormCustomParam("COMMON_ENTITY_ID");
                    node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId);
                } else if (DimTypesEnum.CURRENCY.getNumber().equals(colNum)) {
                    node = this.getRealCurrencyNode(commonDimMap);
                } else if (map.containsKey(colNum)) {
                    node = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)colNum, (String)((String)map.get(colNum)));
                } else if (commonDimMap.containsKey(colNum)) {
                    node = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)colNum, (String)((String)commonDimMap.get(colNum)));
                }
                if (node != null && node != IDNumberTreeNode.NotFoundTreeNode) {
                    String atNum;
                    String processNum;
                    displayContent = node.getName() + "_" + node.getNumber();
                    if ("btn_number".equalsIgnoreCase(showType)) {
                        displayContent = node.getNumber();
                    } else if ("btn_name".equalsIgnoreCase(showType)) {
                        displayContent = node.getName();
                    }
                    if (entry.getKey().equals(DimTypesEnum.ENTITY.getNumber()) && this.checkEntityCanFold(node, processNum = (String)commonDimMap.get(DimTypesEnum.PROCESS.getNumber()), atNum = (String)commonDimMap.get(DimTypesEnum.AUDITTRIAL.getNumber()), this.getRealCurrencyNode(commonDimMap).getNumber())) {
                        displayContent = EXPAND_PLUS + displayContent;
                    }
                }
                if (node == null) {
                    cell.setValue(null);
                    continue;
                }
                if (node == IDNumberTreeNode.NotFoundTreeNode) {
                    FieldEntry fieldEntry = this.getExtendsModel().getFieldEntryByNumber(colNum);
                    if (fieldEntry == null || fieldEntry.getFieldType() != FieldTypeEnum.EXT_FIELD.getType()) continue;
                    String mapped = fieldEntry.getExtField().getMapped();
                    Object value = map.get(colNum);
                    if (mapped.contains("numext")) {
                        value = value == null ? BigDecimal.ZERO : new BigDecimal(value.toString());
                    } else if (mapped.contains("dateext") && value != null && StringUtils.isNotEmpty((String)value.toString())) {
                        try {
                            value = DateTimeUtils.convertToOADate((Date)DateTimeUtils.parseStrDate((String)value.toString()));
                        }
                        catch (ParseException e) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"ExtDataTracePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                    }
                    if (value == null) continue;
                    cell.setValue(value);
                    cellValues.add(this.packedUpdateCellMap(row, col, value));
                    continue;
                }
                cell.setValue((Object)displayContent);
                cell.setUserObject("number", (Object)node.getNumber());
                cell.setUserObject("name", (Object)node.getName());
                cell.setUserObject("id", (Object)node.getId());
                cell.setUserObject("level", (Object)node.getLevel());
                cell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
                cell.setUserObject("isleaf", (Object)node.isLeaf());
                cellValues.add(this.packedUpdateCellMap(row, col, displayContent));
            }
            ++row;
        }
    }

    private IDNumberTreeNode getRealCurrencyNode(Map<String, String> commonDimMap) {
        String processNum = commonDimMap.get(DimTypesEnum.PROCESS.getNumber());
        String curNum = commonDimMap.get(DimTypesEnum.CURRENCY.getNumber());
        String realNum = (String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)MemberReader.findEntityMemberById((Long)Long.valueOf((long)this.getModelId()), (Long)((Long)this.getFormCustomParam((String)"COMMON_ENTITY_ID"))), (long)this.getModelId(), (String)processNum, (String)curNum).p2;
        IDNumberTreeNode node = MemberReader.findCurrencyMemberByNum((String)this.getModelNumber(), (String)realNum);
        return node;
    }

    private void initCellStyle() {
        SearchHelper.setCellBackColor(this.getClientViewProxy(), spreadKey, 0, 0, 1, this.getEffectiveSheet().getMaxColumnCount(), "#f4f4f4", true);
        HashMap<String, Object> features = new HashMap<String, Object>(16);
        features.put(SpreadProperties.SetFrozenSheetMethod.R.k(), 1);
        features.put(SpreadProperties.SetFrozenSheetMethod.C.k(), 0);
        features.put(SpreadProperties.SetFrozenSheetMethod.FLC.k(), "#ccc");
        SpreadClientInvoker.invokeSetFrozenSheetMethod(this.getClientViewProxy(), spreadKey, features);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        int[] colIndex = new int[this.getEffectiveSheet().getMaxColumnCount()];
        for (int i = 1; i < colIndex.length; ++i) {
            colIndex[i] = i;
        }
        map.put("index", colIndex);
        map.put("num", 150);
        SpreadClientInvoker.invokeSetColumsWidthMethod(this.getClientViewProxy(), spreadKey, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>(16);
        map2.put("index", new int[1]);
        map2.put("num", 200);
        SpreadClientInvoker.invokeSetColumsWidthMethod(this.getClientViewProxy(), spreadKey, map2);
    }

    private void buildSpreadHead(List<Map<String, Object>> cellValues) {
        Cell cell;
        int colIndex = 0;
        Sheet sheet = this.getEffectiveSheet();
        List<String> showCols = this.getShowCols();
        HashSet<String> allCols = new HashSet<String>(16);
        for (String string : FIX_HEAD_DIMS) {
            Cell cell2 = sheet.getCell(0, colIndex);
            Long dimId = 0L;
            dimId = SOURCE_ENTITY.equals(string) ? MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimTypesEnum.ENTITY.getNumber()) : MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)string);
            String dimName = MemberReader.getDimensionNameById((long)dimId);
            if (SOURCE_ENTITY.equals(string)) {
                dimName = ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"ExtDataTracePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            cell2.setValue((Object)dimName);
            cell2.setUserObject("number", (Object)string);
            cell2.setUserObject("dimId", (Object)dimId);
            cellValues.add(this.packedUpdateCellMap(0, colIndex, dimName));
            ++colIndex;
            allCols.add(string);
        }
        List selectExt = (List)this.getView().getFormShowParameter().getCustomParams().get("SELECT_EXT_COLS");
        for (String string : showCols) {
            FieldEntry entry = this.getExtendsModel().getFieldEntryByNumber(string);
            if (entry == null) continue;
            if (entry.getFieldType() == FieldTypeEnum.EXT_FIELD.getType()) {
                if (!entry.getExtField().getMapped().contains("textext") && (!entry.getUniqueCheck() || selectExt.contains(entry.getExtField().getNumber()))) continue;
                this.setExtFieldCellValue(cellValues, entry.getExtField(), sheet, colIndex);
                ++colIndex;
                allCols.add(entry.getExtField().getNumber());
                continue;
            }
            if (entry.getFieldType() != FieldTypeEnum.DIM_FIELD.getType()) continue;
            cell = sheet.getCell(0, colIndex);
            cell.setValue((Object)entry.getDimension().getName());
            cell.setUserObject("number", (Object)entry.getDimension().getNumber());
            cell.setUserObject("dimId", (Object)entry.getDimension().getId());
            cellValues.add(this.packedUpdateCellMap(0, colIndex, entry.getDimension().getName()));
            ++colIndex;
            allCols.add(entry.getDimension().getNumber());
        }
        List list = this.getExtendsModel().getDimFieldEntry();
        for (DimFieldEntry fieldEntry : list) {
            if (allCols.contains(fieldEntry.getDimension().getNumber())) continue;
            cell = sheet.getCell(0, colIndex);
            cell.setValue((Object)fieldEntry.getDimension().getName());
            cell.setUserObject("number", (Object)fieldEntry.getDimension().getNumber());
            cell.setUserObject("dimId", (Object)fieldEntry.getDimension().getId());
            cellValues.add(this.packedUpdateCellMap(0, colIndex, fieldEntry.getDimension().getName()));
            ++colIndex;
        }
        List list2 = this.getExtendsModel().getExtFieldEntry();
        for (ExtFieldEntry extFieldEntry : list2) {
            if (allCols.contains(extFieldEntry.getExtField().getNumber()) || !extFieldEntry.getExtField().getMapped().contains("textext") && (!extFieldEntry.getUniqueCheck() || selectExt.contains(extFieldEntry.getExtField().getNumber()))) continue;
            this.setExtFieldCellValue(cellValues, extFieldEntry.getExtField(), sheet, colIndex);
            ++colIndex;
        }
        for (String ext : selectExt) {
            this.setExtFieldCellValue(cellValues, this.getExtendsModel().getFieldEntryByNumber(ext).getExtField(), sheet, colIndex);
            ++colIndex;
        }
        this.insertSpaceCol(colIndex);
    }

    private void insertSpaceCol(int colIndex) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(16);
        ArrayList rangeList = new ArrayList(16);
        HashMap<String, Integer> data = new HashMap<String, Integer>(16);
        data.put("index", 0);
        data.put("count", colIndex);
        rangeList.add(data);
        map.put("status", Boolean.valueOf(true));
        map.put("data", rangeList);
        SpreadClientInvoker.invokeInsertCol(this.getClientViewProxy(), spreadKey, map);
    }

    private void setExtFieldCellValue(List<Map<String, Object>> cellValues, ExtField extField, Sheet sheet, int colIndex) {
        Cell cell = sheet.getCell(0, colIndex);
        cell.setValue((Object)extField.getName());
        cell.setUserObject("number", (Object)extField.getNumber());
        cellValues.add(this.packedUpdateCellMap(0, colIndex, extField.getName()));
    }

    private void initSpreadStyle() {
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), spreadKey);
        SpreadClientInvoker.invokeLockOrHideSpreadMenuItems(this.getClientViewProxy(), spreadKey);
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), spreadKey);
    }

    private void setPageData(Map<String, Object> customParams) {
        this.getModel().setValue(model, customParams.get(model));
        this.getModel().setValue(EXTEND_MODEL, (Object)this.getExtendsModel().getId());
        this.getModel().setValue(scenario, (Object)this.getCommonDimId(DimTypesEnum.SCENARIO.getNumber()));
        this.getModel().setValue(year, (Object)this.getCommonDimId(DimTypesEnum.YEAR.getNumber()));
        this.getModel().setValue(period, (Object)this.getCommonDimId(DimTypesEnum.PERIOD.getNumber()));
    }

    private void initProperty(Map<String, Object> customParams) {
        String selectFields = "id,number";
        QFBuilder qfBuilder = new QFBuilder("number", "=", customParams.get("SELECT_EXTEND_MODEL")).add("model.id", "=", (Object)this.getModelId());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)selectFields, (QFilter[])qfBuilder.toArray());
        if (!query.isEmpty()) {
            this.extendsModel = new ExtendsModel(Long.valueOf(((DynamicObject)query.get(0)).getLong("id")));
            this.getPageCache().put(EXTEND_MODEL, this.toByteSerialized(this.extendsModel));
        }
    }

    @Override
    public long getModelId() {
        return LongUtil.toLong(this.getView().getFormShowParameter().getCustomParams().get(model));
    }

    @Override
    public String getModelNumber() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }

    private Long getCommonDimId(String dim) {
        Map pageMemberMap = (Map)this.getFormCustomParam("COMMON_DIM_INFO");
        if (DimTypesEnum.ENTITY.getNumber().equals(dim)) {
            return (Long)this.getFormCustomParam("COMMON_ENTITY_ID");
        }
        return MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)dim, (String)((String)pageMemberMap.get(dim))).getId();
    }

    private boolean isContainSuchCol(String col) {
        List selectDimCell = (List)this.getFormCustomParam("SELECT_DIM_CELL");
        return selectDimCell != null && !selectDimCell.isEmpty() && ((Map)selectDimCell.get(0)).containsKey(col);
    }

    private List<String> getSelectExt() {
        return (List)this.getView().getFormShowParameter().getCustomParams().get("SELECT_EXT_COLS");
    }

    private List<String> getCurSelectExtCols(IDNumberTreeNode entityNode, String processNum, String auditTrailNum, String currencyNum) {
        ArrayList<String> selects = new ArrayList<String>(10);
        selects.addAll(this.getSelectExt());
        if (!this.checkEntityCanFold(entityNode, processNum, auditTrailNum, currencyNum)) {
            List dimEntry = this.getExtendsModel().getDimFieldEntry();
            dimEntry.forEach(dim -> selects.add(dim.getDimension().getNumber()));
            List fieldEntry = this.getExtendsModel().getExtFieldEntry();
            fieldEntry.forEach(extFieldEntry -> {
                if (!selects.contains(extFieldEntry.getExtField().getNumber()) && (extFieldEntry.getUniqueCheck() || extFieldEntry.getExtField().getMapped().contains("textext"))) {
                    selects.add(extFieldEntry.getExtField().getNumber());
                }
            });
        }
        return selects;
    }

    private ExtendsModel getExtendsModel() {
        if (this.extendsModel == null) {
            this.extendsModel = (ExtendsModel)this.deSerializedBytes(this.getPageCache().get(EXTEND_MODEL));
        }
        return this.extendsModel;
    }

    private DynamicObject getPageDim(String dim) {
        return (DynamicObject)this.getModel().getValue(dim);
    }

    private void filterNoMergeSet(IDNumberTreeNode entity, long scenario, long year, long period, Set<Long> notMergeSet, Map<Long, String> mdsSourceMap) {
        HashMap<String, String> mdNumberSourceMap = new HashMap<String, String>(mdsSourceMap.size());
        for (Map.Entry<Long, String> entry : mdsSourceMap.entrySet()) {
            mdNumberSourceMap.put(MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entry.getKey()).getNumber(), entry.getValue());
        }
        this.getNoMergeOrg(mdNumberSourceMap, notMergeSet, entity);
    }

    public void getNoMergeOrg(Map<String, String> mdsSourceMap, Set<Long> notMergeSet, IDNumberTreeNode entity) {
        if (MergeDataSourceEnum.CSTE.getIndex().equals(mdsSourceMap.get(entity.getNumber()))) {
            for (IDNumberTreeNode allChild : entity.getAllChildren()) {
                notMergeSet.add(allChild.getId());
            }
            return;
        }
        for (IDNumberTreeNode child : entity.getChildren()) {
            if (mdsSourceMap.get(child.getNumber()) != null && MergeDataSourceEnum.CSTE.getIndex().equals(mdsSourceMap.get(child.getNumber()))) {
                for (IDNumberTreeNode allChild : child.getAllChildren()) {
                    notMergeSet.add(allChild.getId());
                }
                continue;
            }
            this.getNoMergeOrg(mdsSourceMap, notMergeSet, child);
        }
    }

    private Map<String, Map<String, Set<String>>> getMappingFilter(long orgId, int rowNumber, String dim, String dimMem, Map<String, Integer> columnIndexMap) {
        Sheet sheet = this.getEffectiveSheet();
        Map<String, Map<String, Set<String>>> res = new HashMap<String, Map<String, Set<String>>>(16);
        EdQueryComInfo queryComInfo = (EdQueryComInfo)ThreadCache.get((Object)GET_QUERYMAPPING_FILTER);
        queryComInfo.setMainOrgId(orgId);
        HashMap<String, String[]> initMap = new HashMap<String, String[]>(queryComInfo.getDimFilter());
        if (DimTypesEnum.PROCESS.getNumber().equals(dim) || DimTypesEnum.AUDITTRIAL.getNumber().equals(dim)) {
            String orgNum = sheet.getCell(rowNumber, 0).getUserObject("isadjust") != null ? MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)((Long)sheet.getCell(rowNumber, 0).getUserObject("id"))).getParent_SonNumber() : (String)sheet.getCell(rowNumber, 0).getUserObject("number");
            initMap.put(DimTypesEnum.ENTITY.getNumber(), new String[]{orgNum});
            if (DimTypesEnum.PROCESS.getNumber().equals(dim)) {
                String auditNum = (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.AUDITTRIAL.getNumber()).intValue()).getUserObject("number");
                initMap.put(DimTypesEnum.PROCESS.getNumber(), new String[]{ExtDataTraceHelper.switchQueryMem(DimTypesEnum.PROCESS.getNumber(), dimMem)});
                initMap.put(DimTypesEnum.AUDITTRIAL.getNumber(), new String[]{auditNum});
            } else {
                String processNum = ExtDataTraceHelper.switchQueryMem(DimTypesEnum.PROCESS.getNumber(), (String)sheet.getCell(rowNumber, columnIndexMap.get(DimTypesEnum.PROCESS.getNumber()).intValue()).getUserObject("number"));
                initMap.put(DimTypesEnum.PROCESS.getNumber(), new String[]{processNum});
                initMap.put(DimTypesEnum.AUDITTRIAL.getNumber(), new String[]{dimMem});
            }
            queryComInfo.setDimFilter(initMap);
            res = ExtDataServiceHelper.getQueryMappingFilter((EdQueryComInfo)queryComInfo);
        }
        return res;
    }

    private Map<String, Map<String, Set<String>>> getMappingFilter(long orgId, String process, String audit) {
        EdQueryComInfo queryComInfo = (EdQueryComInfo)ThreadCache.get((Object)GET_QUERYMAPPING_FILTER);
        queryComInfo.setMainOrgId(orgId);
        HashMap<String, String[]> initMap = new HashMap<String, String[]>(queryComInfo.getDimFilter());
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgId);
        initMap.put(DimTypesEnum.ENTITY.getNumber(), new String[]{entityNode.getNumber()});
        initMap.put(DimTypesEnum.PROCESS.getNumber(), new String[]{ExtDataTraceHelper.switchQueryMem(DimTypesEnum.PROCESS.getNumber(), process)});
        initMap.put(DimTypesEnum.AUDITTRIAL.getNumber(), new String[]{audit});
        queryComInfo.setDimFilter(initMap);
        return ExtDataServiceHelper.getQueryMappingFilter((EdQueryComInfo)queryComInfo);
    }

    private boolean showNoData() {
        return (Boolean)this.getModel().getValue("iscontainson");
    }

    private void changeDisplay(String type) {
        Sheet sheet = this.getEffectiveSheet();
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        for (int i = 1; i < sheet.getTable().size(); ++i) {
            for (int j = 0; j < sheet.getMaxColumnCount(); ++j) {
                Cell cell = sheet.getCell(i, j);
                if (cell.getUserObject("name") == null || cell.getUserObject("number") == null) continue;
                String dinNumber = (String)cell.getUserObject("number");
                String dinName = (String)cell.getUserObject("name");
                String value = cell.getValue().toString();
                StringBuilder sb = new StringBuilder();
                if (value.startsWith(EXPAND_PLUS) || value.startsWith(EXPAND_SUB)) {
                    sb.append(value, 0, 2);
                }
                switch (type) {
                    case "btn_number": {
                        sb.append(dinNumber);
                        break;
                    }
                    case "btn_name": {
                        sb.append(dinName);
                        break;
                    }
                    case "btn_numname": {
                        sb.append(dinName);
                        sb.append("|");
                        sb.append(dinNumber);
                        break;
                    }
                }
                cell.setValue((Object)sb.toString());
                cellValues.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), sb.toString()));
            }
        }
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList(cellValues));
        this.cacheSpreadModel();
    }

    private List<String> getShowCols() {
        List selectDimCell = (List)this.getFormCustomParam("SELECT_DIM_CELL");
        Map showMap = (Map)selectDimCell.get(0);
        return new ArrayList<String>(showMap.keySet());
    }

    @Override
    public String getSpreadKey() {
        return spreadKey;
    }
}

