/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepInitHelper;
import kd.fi.bcm.common.enums.FlowStepTypeEnum;
import kd.fi.bcm.common.enums.StepModuleEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class FlowStepSettingFormPlugin
extends AbstractBaseListPlugin
implements BeforeF7SelectListener {
    private static final String btn_save = "btn_save";
    private static final String btn_close = "btn_close";
    private static final String btn_allo = "btn_allo";
    private static final String advcon_toolbarap = "advcontoolbarap";
    private static final List<String> interseq = Arrays.asList("a", "b", "c", "d", "e", "f", "g", "h", "i");

    private String getOperationSave() {
        return ResManager.loadKDString((String)"\u65b0\u589e\u4fdd\u5b58", (String)"FlowStepSettingFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(btn_save, btn_close, btn_allo, advcon_toolbarap);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        DynamicObjectCollection stepColls = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < stepColls.size(); ++i) {
            this.getModel().setValue("sort", (Object)(i + 1), i);
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        DynamicObjectCollection stepColls = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < stepColls.size(); ++i) {
            this.getModel().setValue("sort", (Object)(i + 1), i);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                this.actionSave();
                break;
            }
            case "btn_close": {
                int is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getView().getEntityId(), "4715a0df000000ac");
                if (this.getEntryEntityDataChange() && is != 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"FlowStepSettingFormPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close_save_confirm", (IFormPlugin)this));
                    break;
                }
                this.getView().close();
                break;
            }
            case "btn_allo": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_approvalauthorityview");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("model", (Object)this.getModelId());
                this.getView().showForm(showParameter);
                this.writeOperationLog(OpItemEnum.LOOKUP.getName(), ResultStatusEnum.SUCCESS.getName());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (this.getModelId() == 0L) {
            args.setCancel(true);
        }
    }

    private void actionSave() {
        if (!this.checkBeforeSave()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u4fe1\u606f\u3002", (String)"FlowStepSettingFormPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FlowStepInitHelper.initFlowStep((String)String.valueOf(this.getModelId()));
        Set sourceStep = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("sourcestep"), Set.class);
        HashSet<String> updateStep = new HashSet<String>(10);
        DynamicObjectCollection stepColls = this.getModel().getEntryEntity("entryentity");
        String comSchemeValue = String.valueOf(this.getValue("comscheme"));
        if (stepColls.size() == 0) {
            DynamicObject modelvalue = (DynamicObject)this.getValue("model");
            QFilter filter = new QFilter("model", "=", (Object)modelvalue.getLong("id"));
            filter.and("steptype", "in", (Object)new String[]{FlowStepTypeEnum.NOMAL.getValue(), FlowStepTypeEnum.END.getValue()});
            filter.and("module", "=", (Object)comSchemeValue);
            DeleteServiceHelper.delete((String)"bcm_flowstep", (QFilter[])filter.toArray());
            this.refreshEntry();
            this.getView().showSuccessNotification(OpItemEnum.SAVE.getName() + ResultStatusEnum.SUCCESS.getName());
            return;
        }
        ArrayList<DynamicObject> newstepLists = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
        if (StepModuleEnum.ADJUST.getCode().equals(comSchemeValue) && stepColls.size() > 9) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u6700\u9ad89\u7ea7\u81ea\u5b9a\u4e49\u5ba1\u6279\u6d41\u7a0b\u3002", (String)"FlowStepSettingFormPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < stepColls.size(); ++i) {
            DynamicObject stepColl = (DynamicObject)stepColls.get(i);
            String stepid = stepColl.getString("stepid");
            if (stepid == null || "".equals(stepid)) {
                DynamicObject newStep = BusinessDataServiceHelper.newDynamicObject((String)"bcm_flowstep");
                newStep.set("name", stepColl.get("name"));
                newStep.set("flowstatus", stepColl.get("flowstatus"));
                newStep.set("sort", (Object)(i + 1));
                newStep.set("model", this.getValue("model"));
                newStep.set("creator", (Object)RequestContext.get().getCurrUserId());
                newStep.set("createtime", (Object)TimeServiceHelper.now());
                newStep.set("modifier", (Object)RequestContext.get().getCurrUserId());
                newStep.set("modifytime", (Object)TimeServiceHelper.now());
                newStep.set("steptype", (Object)FlowStepTypeEnum.NOMAL.getValue());
                if (i == stepColls.size() - 1) {
                    newStep.set("steptype", (Object)FlowStepTypeEnum.END.getValue());
                }
                newStep.set("module", (Object)comSchemeValue);
                if (StepModuleEnum.ADJUST.getCode().equals(comSchemeValue)) {
                    if (i == 0) {
                        newStep.set("steptype", (Object)FlowStepTypeEnum.START.getValue());
                    }
                    newStep.set("interseq", (Object)interseq.get(i));
                }
                newstepLists.add(newStep);
                continue;
            }
            DynamicObject updateObject = BusinessDataServiceHelper.loadSingle((Object)stepid, (String)"bcm_flowstep");
            updateObject.set("name", stepColl.get("name"));
            updateObject.set("flowstatus", stepColl.get("flowstatus"));
            updateObject.set("sort", (Object)(i + 1));
            updateObject.set("modifier", (Object)RequestContext.get().getUserId());
            updateObject.set("modifytime", (Object)TimeServiceHelper.now());
            updateObject.set("steptype", (Object)FlowStepTypeEnum.NOMAL.getValue());
            if (i == stepColls.size() - 1) {
                updateObject.set("steptype", (Object)FlowStepTypeEnum.END.getValue());
            }
            updateObject.set("module", (Object)comSchemeValue);
            if (StepModuleEnum.ADJUST.getCode().equals(comSchemeValue)) {
                if (i == 0) {
                    updateObject.set("steptype", (Object)FlowStepTypeEnum.START.getValue());
                }
                updateObject.set("interseq", (Object)interseq.get(i));
            }
            updateList.add(updateObject);
            updateStep.add(stepid);
        }
        if (sourceStep.removeAll(updateStep) && sourceStep.size() > 0) {
            QFilter filter = new QFilter("id", "in", (Object)LongUtil.toLongList((Collection)sourceStep));
            DeleteServiceHelper.delete((String)"bcm_flowstep", (QFilter[])filter.toArray());
            QFilter authFilter = new QFilter("approvallevel", "in", (Object)LongUtil.toLongList((Collection)sourceStep));
            DeleteServiceHelper.delete((String)"bcm_approvalauthority", (QFilter[])authFilter.toArray());
        }
        if (updateList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        if (newstepLists.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newstepLists.toArray(new DynamicObject[0]));
        }
        this.refreshEntry();
        this.writeOperationLog(this.getOperationSave(), ResultStatusEnum.SUCCESS.getName());
        this.getView().showSuccessNotification(OpItemEnum.SAVE.getName() + ResultStatusEnum.SUCCESS.getName());
    }

    private boolean checkBeforeSave() {
        boolean flag = true;
        DynamicObject modelvalue = (DynamicObject)this.getValue("model");
        if (modelvalue == null) {
            flag = false;
            return flag;
        }
        DynamicObjectCollection stepColls = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject stepColl : stepColls) {
            if (!StringUtils.isEmpty((CharSequence)stepColl.getString("name")) && !StringUtils.isEmpty((CharSequence)stepColl.getString("flowstatus"))) continue;
            flag = false;
            break;
        }
        return flag;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        this.getModel().setValue("model", (Object)modelId);
        this.refreshEntry();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.getPageCache().put("isChange", "true");
        DynamicObjectCollection stepColls = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < stepColls.size(); ++i) {
            this.getModel().setValue("sort", (Object)(i + 1), i);
        }
        if (stepColls.size() > 10) {
            Object stepname = this.getModel().getValue("name", 9);
            Object stepstatus = this.getModel().getValue("flowstatus", 9);
            this.getModel().deleteEntryRow("entryentity", 9);
            this.getModel().setValue("name", stepname, 9);
            this.getModel().setValue("flowstatus", stepstatus, 9);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u5b9a\u4e4910\u4e2a\u5ba1\u6279\u73af\u8282\u3002", (String)"FlowStepSettingFormPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.getPageCache().put("isChange", "true");
        DynamicObjectCollection stepColls = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < stepColls.size(); ++i) {
            this.getModel().setValue("sort", (Object)(i + 1), i);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String id = (String)this.getModel().getValue("stepid", e.getRowIndexs()[0]);
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            QFilter filter = new QFilter("flowstep", "=", (Object)Long.parseLong(id));
            filter.or("laststep", "=", (Object)Long.parseLong(id));
            if (QueryServiceHelper.exists((String)"bcm_flowtask", (QFilter[])filter.toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6279\u6b65\u9aa4\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FlowStepSettingFormPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("name".equals(propName) || "flowstatus".equals(propName)) {
            this.getPageCache().put("isChange", "true");
        }
        if ("model".equals(propName) || "comscheme".equals(propName)) {
            this.refreshEntry();
        }
        DynamicObjectCollection stepColls = this.getModel().getEntryEntity("entryentity");
        if ("name".equals(propName) && stepColls.stream().map(dy -> dy.getString("name")).filter(StringUtils::isNotEmpty).distinct().count() < stepColls.stream().map(dy -> dy.getString("name")).filter(StringUtils::isNotEmpty).count()) {
            this.getModel().setValue("name", (Object)"", this.getModel().getEntryCurrentRowIndex("entryentity"));
        }
        if ("flowstatus".equals(propName) && stepColls.stream().map(dy -> dy.getString("flowstatus")).filter(StringUtils::isNotEmpty).distinct().count() < stepColls.stream().map(dy -> dy.getString("flowstatus")).filter(StringUtils::isNotEmpty).count()) {
            this.getModel().setValue("flowstatus", (Object)"", this.getModel().getEntryCurrentRowIndex("entryentity"));
        }
    }

    private void refreshEntry() {
        DynamicObject modelvalue = (DynamicObject)this.getValue("model");
        String comSchemeValue = String.valueOf(this.getValue("comscheme"));
        if (modelvalue == null) {
            this.getPageCache().put("isChange", "false");
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        QFilter filter = new QFilter("model", "=", (Object)modelvalue.getLong("id"));
        String selectFields = "id,number,name,sort,flowstatus,creator.name,createtime,modifier.name,modifytime";
        if (StepModuleEnum.ADJUST.getCode().equals(comSchemeValue)) {
            filter.and("module", "=", (Object)StepModuleEnum.ADJUST.getCode());
            filter.and("steptype", "in", (Object)new String[]{FlowStepTypeEnum.START.getValue(), FlowStepTypeEnum.NOMAL.getValue(), FlowStepTypeEnum.END.getValue()});
        } else {
            filter.and("module", "=", (Object)StepModuleEnum.MERGE.getCode());
            filter.and("steptype", "in", (Object)new String[]{FlowStepTypeEnum.NOMAL.getValue(), FlowStepTypeEnum.END.getValue()});
        }
        DynamicObject[] steps = BusinessDataServiceHelper.load((String)"bcm_flowstep", (String)selectFields, (QFilter[])filter.toArray(), (String)"sort");
        HashSet<String> ids = new HashSet<String>(10);
        if (steps == null || steps.length == 0) {
            this.getPageCache().put("isChange", "false");
            this.getPageCache().put("sourcestep", SerializationUtils.toJsonString(ids));
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", steps.length);
        for (int i = 0; i < steps.length; ++i) {
            this.getModel().setValue("name", steps[i].get("name"), i);
            this.getModel().setValue("sort", steps[i].get("sort"), i);
            this.getModel().setValue("flowstatus", steps[i].get("flowstatus"), i);
            this.getModel().setValue("creator", steps[i].get("creator.name"), i);
            this.getModel().setValue("createtime", (Object)steps[i].getDate("createtime"), i);
            this.getModel().setValue("modifier", steps[i].get("modifier.name"), i);
            this.getModel().setValue("modifytime", (Object)steps[i].getDate("modifytime"), i);
            this.getModel().setValue("stepid", (Object)steps[i].getString("id"), i);
            ids.add(steps[i].getString("id"));
        }
        this.getPageCache().put("sourcestep", SerializationUtils.toJsonString(ids));
        this.getPageCache().put("isChange", "false");
    }

    private boolean getEntryEntityDataChange() {
        String isChange = this.getPageCache().get("isChange");
        return "true".equals(isChange);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if ("save_confirm".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
                this.actionSave();
            } else {
                this.refreshEntry();
            }
        } else if ("close_save_confirm".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
                if (!this.checkBeforeSave()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u4fe1\u606f\u3002", (String)"FlowStepSettingFormPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.actionSave();
            }
            this.getView().close();
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }
}

