/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.form;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class DocumentFileEntityService {
    public static Map<String, DynamicObjectCollection> getDocumentFileEntity(long modelId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        qfBuilder.add(new QFilter("catalogtype", "=", (Object)Character.valueOf('0')));
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId));
        DynamicObjectCollection catalogori = QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,name,number,parent.id parent_id,longnumber", (QFilter[])qfBuilder.toArray(), (String)"sequence ASC");
        DynamicObjectCollection catalog = new DynamicObjectCollection();
        if (!adminUserBol) {
            ArrayListMultimap permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_templatecatalog", (String)String.valueOf(modelId), (String)RequestContext.get().getUserId());
            List noPerms = permissionMap.get((Object)DataTypeEnum.NO.getIndex());
            for (DynamicObject obj : catalogori) {
                if (noPerms.contains(obj.getLong("id"))) continue;
                catalog.add((Object)obj);
            }
        } else {
            catalog.addAll((Collection)catalogori);
        }
        QFilter qf = new QFilter("catalog", "!=", (Object)"0");
        QFilter qf2 = new QFilter("model", "=", (Object)modelId);
        QFilter qf3 = new QFilter("permid.id", "in", (Object)PermClassEntityHelper.getHasDataPermission((long)modelId));
        qf3.or(new QFilter("permid.id", "=", (Object)0));
        QFilter noPermqf = DocumentFileEntityService.getNoPermFilter2(qf2, adminUserBol, modelId);
        DynamicObjectCollection temps = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,versionnumber", (QFilter[])new QFilter[]{qf2});
        TemplateUtil.filterVersionTemplateTree((Collection)temps);
        List ids = temps.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        ids.add(0L);
        QFilter qf4 = new QFilter("template.id", "in", ids).and("scheme", "=", (Object)0);
        QFilter qf5 = new QFilter("scheme.scope", "=", (Object)"0").and("template", "=", (Object)0);
        QFilter qf6 = new QFilter("scheme.scope", "=", (Object)"1").and("scheme.createuserid", "=", (Object)LongUtil.toLong((Object)RequestContext.getOrCreate().getUserId())).and("template", "=", (Object)0);
        DynamicObjectCollection template = QueryServiceHelper.query((String)"bcm_filelistentity", (String)"id,catalog,number,name,parent.id parent_id,longnumber", (QFilter[])new QFilter[]{qf, qf2, adminUserBol ? new QFilter("1", "=", (Object)1) : qf3, qf4.or(qf5.or(qf6)), noPermqf}, (String)"catalog, longnumber");
        HashMap<String, DynamicObjectCollection> result = new HashMap<String, DynamicObjectCollection>(2);
        result.put("document", catalog);
        result.put("template", template);
        return result;
    }

    private static QFilter getNoPermFilter2(QFilter qf2, boolean adminUserBol, long modelId) {
        if (!adminUserBol) {
            Set hasDataPermission = PermClassEntityHelper.getHasDataPermission((long)modelId);
            hasDataPermission.add(0L);
            QFilter noPermqf = new QFilter("permid.id", "not in", (Object)hasDataPermission);
            DynamicObjectCollection noPermCol = QueryServiceHelper.query((String)"bcm_filelistentity", (String)"longnumber", (QFilter[])new QFilter[]{qf2, noPermqf});
            if (noPermCol != null && !noPermCol.isEmpty()) {
                QFilter longNumberQF = new QFilter("longnumber", "not like", (Object)(((DynamicObject)noPermCol.get(0)).getString("longnumber") + "!"));
                for (DynamicObject obj : noPermCol) {
                    longNumberQF.and("longnumber", "not like", (Object)(obj.getString("longnumber") + "!%"));
                }
                return longNumberQF;
            }
            return new QFilter("1", "=", (Object)1);
        }
        return new QFilter("1", "=", (Object)1);
    }
}

