/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.form;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.UserUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.util.DocumentUtils;
import kd.fi.bcm.formplugin.util.FormShowParameterUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class DocumentManagePlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener {
    private static final String model = "model";
    private static final String DOC_TREE = "doc_tree";
    private static final String FOCUS_NODE_ID = "focusnodeid";
    private static final String ACTION_NAME = "actionname";
    private static final String CATALOG_ID = "catalogid";
    private static final String ENTRYENTITY = "entryentity";
    private static final String AUTH_REPORT = "2QAFPU2JQCQR";
    private static final Set<String> DIM_KEY = Sets.newHashSet((Object[])new String[]{"scenario", "year", "period"});
    private static final String FILE = "0";
    private static final String FOLDER = "1";
    private static final String HYPERLINK = "2";
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DocumentManagePlugin.class);
    private static final Set<String> DIMS = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber()});
    private static final String BILLLISTAP = "billlistap";
    TempFileCache cache;

    @Override
    public void initialize() {
        super.initialize();
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (StringUtil.isEmptyString((String)focusNodeId) || FILE.equals(focusNodeId)) {
            this.disableBtn(false, new String[]{"btn_edit", "btn_delete", "btn_up", "btn_down"});
        }
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(DIM_KEY), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        FilterContainer filtercontainerap = (FilterContainer)this.getControl("filtercontainerap");
        filtercontainerap.setBillFormId("bcm_documentlist");
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addSetFilterListener(this::setFilter);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        FilterParameter fp = new FilterParameter();
        List qFilters = fp.getQFilters();
        qFilters.add(new QFilter(model, "=", (Object)this.getModelId()));
        qFilters.add(new QFilter("groupid", "=", (Object)this.gainGroupId()));
        e.getQFilters().addAll(qFilters);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_add", "btn_edit", "btn_delete", "btn_up", "btn_down", "entitys");
        TreeView tview = (TreeView)this.getControl(DOC_TREE);
        tview.addTreeNodeClickListener((TreeNodeClickListener)this);
        FilterContainer filtercontainerap = (FilterContainer)this.getControl("filtercontainerap");
        filtercontainerap.addBeforeF7SelectListener(this::f7SelectFilter);
        filtercontainerap.addSearchClickListener(this::doRefreshBillList);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(model);
        basedataEdit.addBeforeF7SelectListener(evt -> evt.getCustomQFilters());
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addHyperClickListener(event -> {
            String fieldName = event.getFieldName();
            if ("parent".equals(fieldName) || "parent_name".equals(fieldName)) {
                this.toFolder(billList);
            } else {
                this.doOpen();
            }
        });
    }

    private void toFolder(BillList billList) {
        long pkid = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject doc = QueryServiceHelper.queryOne((String)"bcm_documentlist", (String)"parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
        if (doc == null) {
            return;
        }
        long id = doc.getLong("parent");
        this.getPageCache().put(FOCUS_NODE_ID, String.valueOf(id));
        this.initLeftTree();
        this.focusOnNode(String.valueOf(id));
    }

    private void f7SelectFilter(BeforeFilterF7SelectEvent f7evt) {
        if (!"bos_user".equals(f7evt.getRefEntityId())) {
            f7evt.addCustomQFilter(new QFilter(model, "=", (Object)this.getModelId()));
        }
        if ("bcm_entitymembertree".equals(f7evt.getRefEntityId())) {
            f7evt.addCustomQFilter(new QFilter("number", "!=", (Object)DimTypesEnum.ENTITY.getNumber()));
        }
    }

    private void doRefreshBillList(SearchClickEvent evt) {
        QFBuilder qf = new QFBuilder();
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue(model);
        if (modelDy != null) {
            if (evt.getFastQFilters() != null) {
                qf.add(evt.getFastQFilters());
            }
            if (evt.getFilterParameter().getQFilters() != null) {
                qf.add(evt.getFilterParameter().getQFilters());
            }
            this.refreshBillList(qf.toList());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        long modelId;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ArrayList<String> dims = new ArrayList<String>(DIM_KEY);
        if (key.equals(model)) {
            this.propertyChangedModelUse(dims);
            this.removeEntitys(true);
            this.constructorData();
            this.getPageCache().put(FOCUS_NODE_ID, FILE);
            this.refrushEntityList(0);
        } else if (dims.contains(key)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            Boolean isSureReturn = this.propertyChangedDimUse(key, newValue, false, false);
            if (!isSureReturn.booleanValue()) {
                return;
            }
            this.refreshData();
        } else if ("entitys".equals(key)) {
            if (e.getChangeSet()[0].getNewValue() == null || StringUtils.isEmpty((CharSequence)e.getChangeSet()[0].getNewValue().toString())) {
                this.removeEntitys(false);
                this.refreshData();
            }
        } else if ("showall".equals(key) && (modelId = this.getModelId()) != 0L) {
            this.focusOnNode(this.getPageCache().get(FOCUS_NODE_ID));
        }
    }

    private void removeEntitys(boolean isNeedUpdateView) {
        this.getPageCache().remove("entitys");
        this.getPageCache().remove("selectentitys");
        if (isNeedUpdateView) {
            this.getModel().beginInit();
            this.getModel().setValue("entitys", null);
            this.getModel().endInit();
            this.getView().updateView("entitys");
        }
    }

    private void refreshData() {
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (this.isReportCatalog(focusNodeId)) {
            this.refreshReportEntityList(0);
        } else {
            this.refrushEntityList(0);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        this.getPageCache().put(FOCUS_NODE_ID, evt.getNodeId().toString());
        this.showBtn(evt.getNodeId().toString());
    }

    private void showBtn(String nodeId) {
        if (FILE.equals(nodeId)) {
            this.disableBtn(false, new String[]{"btn_edit", "btn_delete", "btn_up", "btn_down"});
            this.disableBtn(true, new String[]{"btn_add"});
            this.refrushEntityList(0);
        } else if (this.isReportCatalog(nodeId)) {
            this.disableBtn(false, new String[]{"btn_add", "btn_edit", "btn_delete", "btn_up", "btn_down"});
            this.refreshReportEntityList(0);
        } else {
            this.disableBtn(true, new String[]{"btn_add", "btn_edit", "btn_delete", "btn_up", "btn_down"});
            this.refrushEntityList(0);
        }
    }

    private boolean isReportCatalog(Object nodeId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("id", "=", (Object)LongUtil.toLong((Object)nodeId)));
        qfBuilder.add(new QFilter("level", "=", (Object)1));
        qfBuilder.add(new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"DocumentManagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        return QueryServiceHelper.exists((String)"bcm_docmodel", (QFilter[])qfBuilder.toArray());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), model);
        if (kd.bos.util.StringUtils.isEmpty((String)modelId)) {
            this.getPageCache().put("KEY_MODEL_ID", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb\u53ef\u4ee5\u4f7f\u7528\u3002", (String)"DocumentManagePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().getModel().setValue(model, (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
            ArrayList<String> dims = new ArrayList<String>(DIM_KEY);
            this.refreshBillByUserSelect(dims, false);
            this.getPageCache().put(FOCUS_NODE_ID, FILE);
            this.constructorData();
            this.refrushEntityList(0);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opkey = evt.getItemKey();
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        switch (opkey) {
            case "baritemap_upload": {
                this.doOpenUpload(focusNodeId, true);
                break;
            }
            case "baritemap_download": {
                this.doDocDownloadZip();
                break;
            }
            case "baritemap_delete": {
                this.doDocDelete(false);
                break;
            }
            case "baritemap_move": {
                this.doMove();
                break;
            }
            case "baritemap_refresh": {
                this.checkModel();
                this.initLeftTree();
                this.getPageCache().remove("selectentitys");
                this.focusOnNode(this.getPageCache().get(FOCUS_NODE_ID));
                break;
            }
            case "baritemap_exit": {
                this.getView().close();
            }
        }
    }

    private void checkModel() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DocumentManagePlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void doDocDelete(boolean confirm) {
        DynamicObjectCollection dynamicObjectCollection = this.getSelectRows();
        if (dynamicObjectCollection.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6587\u4ef6\u8fdb\u884c\u5220\u9664\u3002", (String)"DocumentManagePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!confirm) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\uff1f", (String)"DocumentManagePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("baritemap_delete", (IFormPlugin)this));
            return;
        }
        DynamicObject[] docReports = this.getReportFolder();
        List<Object> docs = new ArrayList(16);
        docs.addAll((Collection<Object>)dynamicObjectCollection);
        if (docReports != null && docReports.length != 0) {
            List reportFolderIds = Arrays.stream(docReports).map(doc -> doc.getLong("id")).collect(Collectors.toList());
            docs = dynamicObjectCollection.stream().filter(doc -> !reportFolderIds.contains(doc.getLong("parent"))).collect(Collectors.toList());
            if (docs.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236\u6587\u4ef6\u5939\u9644\u4ef6\u4e0d\u80fd\u5220\u9664\u3002", (String)"DocumentManagePlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        docs = (List)docs.stream().sorted((v1, v2) -> v2.getString("type").compareTo(v1.getString("type"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        ArrayList<String> names = new ArrayList<String>(10);
        Map<Long, DynamicObject> id2Doc = this.collectId2Doc(docs);
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        Collection<Long> rightData = DocumentUtils.getPermIds(this.getModelId(), DataTypeEnum.READ, DataTypeEnum.NO);
        for (int i = 0; i < docs.size(); ++i) {
            DynamicObjectCollection list;
            DynamicObject dynamicObject = (DynamicObject)docs.get(i);
            long id = dynamicObject.getLong("docid");
            if (!this.ifCanWrite(id, admin, rightData, id2Doc)) {
                return;
            }
            String type = dynamicObject.getString("type");
            if (FILE.equals(type) || HYPERLINK.equals(type)) {
                list = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,name,url", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                if (list.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u6587\u4ef6\u5df2\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6743\u9650\u3002", (String)"DocumentManagePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6587\u4ef6\u8fdb\u884c\u5220\u9664\u3002", (String)"DocumentManagePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.doDelete((DynamicObject)list.get(0));
            names.add(((DynamicObject)list.get(0)).getString("name"));
        }
        this.initLeftTree();
        this.refrushEntityList(0);
        if (!names.isEmpty()) {
            String opName = ResManager.loadKDString((String)"\u6587\u6863\u5220\u9664", (String)"UploadDocumentPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String opDescribe = String.format(ResManager.loadKDString((String)"%s \u6587\u6863\u5220\u9664\u6210\u529f", (String)"UploadDocumentPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)";", names));
            OperationLogUtil.writeOperationLog((String)opName, (String)opDescribe, (Long)this.getModelId(), (String)"bcm_docmodel");
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DocumentManagePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private Map<Long, DynamicObject> collectId2Doc(List<DynamicObject> docs) {
        List docIds;
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        Map<Long, DynamicObject> id2doc = new HashMap<Long, DynamicObject>(16);
        if (!admin && !CollectionUtil.isEmpty(docIds = docs.stream().map(doc -> doc.getLong("docid")).collect(Collectors.toList()))) {
            DynamicObjectCollection docDys = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,parentid,name", (QFilter[])new QFilter[]{new QFilter("id", "in", docIds)});
            id2doc = docDys.stream().collect(Collectors.toMap(doc -> doc.getLong("id"), doc -> doc, (e1, e2) -> e2));
        }
        return id2doc;
    }

    private DynamicObjectCollection getSelectRows() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return new DynamicObjectCollection();
        }
        Object[] ids = selectedRows.getPrimaryKeyValues();
        DynamicObjectCollection selectData = QueryServiceHelper.query((String)"bcm_documentlist", (String)"docid, type, isreport, name,parent", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        return selectData;
    }

    private void doDelete(DynamicObject obj) {
        long id = obj.getLong("id");
        DeleteServiceHelper.delete((String)"bcm_docmodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        String path = obj.getString("url");
        FileService fs = FileServiceFactory.getAttachmentFileService();
        fs.delete(path);
    }

    private void doDocDownloadZip() {
        DynamicObjectCollection dynamicObjectCollection = this.getSelectRows();
        ArrayList fails = Lists.newArrayListWithExpectedSize((int)16);
        if (dynamicObjectCollection.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u3002", (String)"DocumentManagePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.ifCanRead(dynamicObjectCollection)) {
            return;
        }
        if (dynamicObjectCollection.size() == 1) {
            DynamicObject doc = QueryServiceHelper.queryOne((String)"bcm_docmodel", (String)"id,name,url", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((DynamicObject)dynamicObjectCollection.get(0)).getLong("docid"))});
            if (doc != null && ((DynamicObject)dynamicObjectCollection.get(0)).getString("type").equals(FILE)) {
                this.doDownload(doc);
                String opName = ResManager.loadKDString((String)"\u6587\u6863\u7ba1\u7406-\u4e0b\u8f7d", (String)"DocumentManagePlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                OperationLogUtil.writeOperationLog((String)opName, (String)ResultStatusEnum.SUCCESS.getName(), (Long)this.getModelId(), (String)"bcm_docmodel");
                return;
            }
            if (doc == null) {
                doc = QueryServiceHelper.queryOne((String)"bcm_chkattachment", (String)"name,url", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((DynamicObject)dynamicObjectCollection.get(0)).getLong("docid")), new QFilter("name", "=", (Object)((DynamicObject)dynamicObjectCollection.get(0)).getString("name"))});
                if (doc != null) {
                    this.doDownload(doc);
                    return;
                }
                fails.add(((DynamicObject)dynamicObjectCollection.get(0)).getString("name"));
            }
        }
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             ZipOutputStream zipOStream = new ZipOutputStream(outputStream);){
            HashMap nameCountMap = Maps.newHashMapWithExpectedSize((int)16);
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                long id = dynamicObject.getLong("docid");
                String type = dynamicObject.getString("type");
                String name = dynamicObject.getString("name");
                boolean isreport = dynamicObject.getBoolean("isreport");
                if (type.equals(FILE)) {
                    DynamicObject doc = !isreport ? QueryServiceHelper.queryOne((String)"bcm_docmodel", (String)"name,url", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}) : QueryServiceHelper.queryOne((String)"bcm_chkattachment", (String)"name,url", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id), new QFilter("name", "=", (Object)name)});
                    if (doc == null) {
                        fails.add(dynamicObject.getString("name"));
                        continue;
                    }
                    this.zip(zipOStream, doc.getString("name"), doc.getString("url"), nameCountMap);
                    continue;
                }
                if (ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"DocumentManagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(name)) {
                    this.collectReportAttachment(zipOStream, nameCountMap);
                    continue;
                }
                this.collectDocsByParent(zipOStream, id, name, nameCountMap);
            }
            zipOStream.finish();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String dateStr = sdf.format(TimeServiceHelper.now());
            String orgZipUrl = this.cache.saveAsUrl(String.format(ResManager.loadKDString((String)"\u6587\u6863\u7ba1\u7406%1$s%2$s", (String)"DocumentManagePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dateStr, ".zip"), outputStream.toByteArray(), 5000);
            this.downloadFile(orgZipUrl, "bcm_doc_manage", "4730fc9f000007ae");
            String opName = ResManager.loadKDString((String)"\u6587\u6863\u7ba1\u7406-\u4e0b\u8f7d", (String)"DocumentManagePlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            OperationLogUtil.writeOperationLog((String)opName, (String)ResultStatusEnum.SUCCESS.getName(), (Long)this.getModelId(), (String)"bcm_docmodel");
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
        if (fails.size() > 0) {
            StringBuilder sb = new StringBuilder();
            fails.stream().forEach(o -> sb.append((String)o).append(' '));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u6216\u65e0\u6743\u9650\u3002", (String)"DocumentManagePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString()));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5b8c\u6210\u3002", (String)"DocumentManagePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void collectReportAttachment(ZipOutputStream zipOStream, Map<String, Integer> nameCountMap) throws IOException {
        Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>> reportAttachments = this.getReportAttachments();
        Map attachments = (Map)reportAttachments.p2;
        if (attachments != null) {
            for (List attachmentList : attachments.values()) {
                for (DynamicObject attachment : attachmentList) {
                    this.zip(zipOStream, String.format(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236/%s", (String)"DocumentManagePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), attachment.getString("name")), attachment.getString("url"), nameCountMap);
                }
            }
        } else {
            this.zip(zipOStream, String.format(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236/%s", (String)"DocumentManagePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ""), null, nameCountMap);
        }
    }

    private void collectDocsByParent(ZipOutputStream zipOStream, long parentId, String name, Map<String, Integer> nameCountMap) throws IOException {
        DynamicObjectCollection nodes;
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        QFilter qf = new QFilter("parentid", "=", (Object)parentId);
        if (!admin) {
            qf.and(new QFilter("id", "not in", DocumentUtils.getPermIds(this.getModelId(), DataTypeEnum.NO)));
        }
        if ((nodes = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,type,name,url", (QFilter[])new QFilter[]{qf})).size() == 0) {
            this.zip(zipOStream, name + "/", null, nameCountMap);
            return;
        }
        for (DynamicObject node : nodes) {
            long id = node.getLong("id");
            String type = node.getString("type");
            String nodeName = node.getString("name");
            if (type.equals(FOLDER)) {
                this.collectDocsByParent(zipOStream, id, nodeName, nameCountMap);
                continue;
            }
            this.zip(zipOStream, name + "/" + node.getString("name"), node.getString("url"), nameCountMap);
        }
    }

    private void zip(ZipOutputStream zipOStream, String name, String url, Map<String, Integer> nameCountMap) throws IOException {
        byte[] buffer = new byte[512];
        int readLength = 0;
        if (this.containsIgnoreCase(nameCountMap.keySet(), name)) {
            int count = nameCountMap.get(name) + 1;
            nameCountMap.put(name, count);
            String[] split = name.split("\\.");
            StringBuilder sb = new StringBuilder();
            if (split.length > 1) {
                for (int i = 0; i < split.length - 1; ++i) {
                    sb.append(split[i]).append('.');
                }
                sb.append('(').append(count).append(')').append('.').append(split[split.length - 1]);
                name = sb.toString();
            } else {
                name = name + '(' + count + ')';
            }
        } else {
            nameCountMap.put(name, 0);
        }
        ZipEntry docEntry = new ZipEntry(name);
        zipOStream.putNextEntry(docEntry);
        if (!StringUtil.isEmptyString((String)url)) {
            try (InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);){
                while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                    zipOStream.write(buffer, 0, readLength);
                }
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
        }
        zipOStream.closeEntry();
    }

    private boolean containsIgnoreCase(Collection<String> collection, String str) {
        for (String s : collection) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private void doDownload(DynamicObject obj) {
        FileService fs = FileServiceFactory.getAttachmentFileService();
        TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = obj.getString("url");
        String name = obj.getString("name");
        InputStream is = fs.getInputStream(url);
        int timeout = 1200;
        String url1 = tfc.saveAsUrl(name, is, timeout);
        this.downloadFile(url1, "bcm_doc_manage", "4730fc9f000007ae");
    }

    private void doMove() {
        DynamicObjectCollection selectRows = this.getSelectRows();
        if (selectRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u6587\u6863\u3002", (String)"DocumentManagePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<Long, DynamicObject> id2Doc = this.collectId2Doc((List<DynamicObject>)selectRows);
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        Collection<Long> rightData = DocumentUtils.getPermIds(this.getModelId(), DataTypeEnum.READ, DataTypeEnum.NO);
        for (DynamicObject selectRow : selectRows) {
            String type = selectRow.getString("type");
            if (FOLDER.equals(type)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u79fb\u52a8\u6587\u4ef6\u5939\u3002", (String)"DocumentManagePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.ifCanWrite(selectRow.getLong("docid"), admin, rightData, id2Doc)) continue;
            return;
        }
        DynamicObject[] docReports = this.getReportFolder();
        List<Object> docs = new ArrayList();
        docs.addAll((Collection<Object>)selectRows);
        if (docReports != null && docReports.length != 0) {
            List reportFolderIds = Arrays.stream(docReports).map(doc -> doc.getLong("id")).collect(Collectors.toList());
            docs = selectRows.stream().filter(doc -> !reportFolderIds.contains(doc.getLong("parent"))).collect(Collectors.toList());
            if (docs.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236\u6587\u4ef6\u5939\u9644\u4ef6\u4e0d\u80fd\u79fb\u52a8\u3002", (String)"DocumentManagePlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_doc_moveto");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        List ids = docs.stream().map(v -> v.getLong("docid")).collect(Collectors.toList());
        showParameter.setCustomParam("ids", ids);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_doc_moveto");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void doOpenUpload(String focusNodeId, boolean isAddNew) {
        if (!this.ifCanWrite(Long.parseLong(focusNodeId))) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("KEY_MODEL_ID", this.getModelId());
        long id = StringUtil.isEmptyString((String)focusNodeId) ? 0L : Long.parseLong(focusNodeId);
        params.put(CATALOG_ID, String.valueOf(id));
        params.put(ACTION_NAME, isAddNew ? "addnew" : "edit");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_doc_uploads");
        this.showUploadForm(params, closeCallBack, true);
    }

    private void showUploadForm(Map<String, Object> params, CloseCallBack closeCallBack, boolean isAddNew) {
        Set<String> selectOrgs;
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bcm_doc_uploads");
        param.setStatus(isAddNew ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        param.setCustomParams(params);
        if (this.getModel().getValue("scenario") != null) {
            param.setCustomParam("scenario", (Object)((DynamicObject)this.getModel().getValue("scenario")).getLong("id"));
        }
        if (this.getModel().getValue("year") != null) {
            param.setCustomParam("year", (Object)((DynamicObject)this.getModel().getValue("year")).getLong("id"));
        }
        if (this.getModel().getValue("period") != null) {
            param.setCustomParam("period", (Object)((DynamicObject)this.getModel().getValue("period")).getLong("id"));
        }
        if (!(selectOrgs = DocumentUtils.getSelectOrgs(this.getPageCache(), this.getModelId())).isEmpty()) {
            param.setCustomParam("entity", (Object)MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)selectOrgs.iterator().next()).getId());
        }
        this.getView().showForm(param);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_add": {
                this.addNewTreeNode(focusNodeId, true);
                break;
            }
            case "btn_edit": {
                this.addNewTreeNode(focusNodeId, false);
                break;
            }
            case "btn_up": {
                this.moveTreeNode(focusNodeId, true);
                break;
            }
            case "btn_down": {
                this.moveTreeNode(focusNodeId, false);
                break;
            }
            case "btn_delete": {
                this.deleteTreeNode(focusNodeId);
                break;
            }
            case "entitys": {
                Long dimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimTypesEnum.ENTITY.getNumber());
                String caption = String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"TemplateFloatSettingPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MemberReader.getDimensionNameById((long)dimensionId));
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("KEY_MODEL_ID", Long.toString(this.getModelId()));
                params.put("dimensionid", dimensionId);
                params.put("sign", "entitys");
                params.put("disableRateCls", true);
                this.getView().showForm(FormShowParameterUtil.getFormShowParameter("bcm_mulmemberf7base_tem", ShowType.Modal, caption, new CloseCallBack((IFormPlugin)this, "entitys"), null, params));
                break;
            }
        }
    }

    private void moveTreeNode(String focusNodeId, boolean isUp) {
        DynamicObjectCollection coll;
        Long parentid;
        if (!this.ifCanWrite(Long.parseLong(focusNodeId))) {
            return;
        }
        QFilter qf = new QFilter(model, "=", (Object)this.getModelId()).and("type", "=", (Object)Character.valueOf('1'));
        if (StringUtil.isEmptyString((String)focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u8282\u70b9\u3002", (String)"DocumentManagePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (FILE.equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u79fb\u52a8\u6839\u8282\u70b9\u3002", (String)"DocumentManagePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long id = Long.parseLong(focusNodeId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_docmodel");
        if (null != obj.getDynamicObject("parentid")) {
            parentid = obj.getDynamicObject("parentid").getLong("id");
            coll = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,fseq", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)parentid), qf}, (String)"fseq ASC");
        } else {
            parentid = 0L;
            coll = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,fseq", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)parentid), qf}, (String)"fseq ASC");
        }
        if (coll.size() <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u53ea\u6709\u4e00\u4e2a\u8282\u70b9\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"DocumentManagePlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (isUp) {
            if (1L == obj.getLong("fseq") || ((DynamicObject)coll.get(0)).getLong("fseq") == obj.getLong("fseq")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u4e0a\u9762\u7684\u8282\u70b9\uff0c\u65e0\u6cd5\u5f80\u4e0a\u79fb\u52a8\u3002", (String)"DocumentManagePlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qf1 = new QFilter("parentid", "=", (Object)parentid);
            QFilter qf2 = new QFilter("fseq", "<", (Object)obj.getLong("fseq"));
            DynamicObject upperPlain = (DynamicObject)QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,fseq", (QFilter[])new QFilter[]{qf, qf1, qf2}, (String)"fseq DESC", (int)1).get(0);
            DynamicObject upper = BusinessDataServiceHelper.loadSingle((Object)upperPlain.getLong("id"), (String)"bcm_docmodel");
            this.swapDseq(obj, upper);
            BusinessDataWriter.save((IDataEntityType)obj.getDataEntityType(), (Object[])new Object[]{obj});
            BusinessDataWriter.save((IDataEntityType)obj.getDataEntityType(), (Object[])new Object[]{upper});
            String opName = ResManager.loadKDString((String)"\u8282\u70b9\u4e0a\u79fb", (String)"UploadDocumentPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String opDescribe = String.format(ResManager.loadKDString((String)"%1$s -> %2$s \u8282\u70b9\u4e0a\u79fb\u6210\u529f", (String)"UploadDocumentPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getString("name"), upper.getString("name"));
            OperationLogUtil.writeOperationLog((String)opName, (String)opDescribe, (Long)this.getModelId(), (String)"bcm_docmodel");
        } else {
            if (((DynamicObject)coll.get(coll.size() - 1)).getLong("fseq") == obj.getLong("fseq")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u4e0b\u9762\u7684\u8282\u70b9\uff0c\u65e0\u6cd5\u5f80\u4e0b\u79fb\u52a8\u3002", (String)"DocumentManagePlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qf1 = new QFilter("parentid", "=", (Object)parentid);
            QFilter qf2 = new QFilter("fseq", ">", (Object)obj.getLong("fseq"));
            DynamicObject downerPlain = (DynamicObject)QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,fseq", (QFilter[])new QFilter[]{qf, qf1, qf2}, (String)"fseq ASC", (int)1).get(0);
            DynamicObject downer = BusinessDataServiceHelper.loadSingle((Object)downerPlain.getLong("id"), (String)"bcm_docmodel");
            this.swapDseq(obj, downer);
            BusinessDataWriter.save((IDataEntityType)obj.getDataEntityType(), (Object[])new Object[]{obj});
            BusinessDataWriter.save((IDataEntityType)obj.getDataEntityType(), (Object[])new Object[]{downer});
            String opName = ResManager.loadKDString((String)"\u8282\u70b9\u4e0b\u79fb", (String)"UploadDocumentPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String opDescribe = String.format(ResManager.loadKDString((String)"%1$s -> %2$s \u8282\u70b9\u4e0b\u79fb\u6210\u529f", (String)"UploadDocumentPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getString("name"), downer.getString("name"));
            OperationLogUtil.writeOperationLog((String)opName, (String)opDescribe, (Long)this.getModelId(), (String)"bcm_docmodel");
        }
        this.initLeftTree();
        this.focusOnNode(focusNodeId);
        this.refrushEntityList(0);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u6210\u529f\u3002", (String)"DocumentManagePlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void swapDseq(DynamicObject obj1, DynamicObject obj2) {
        long fseq = obj1.getLong("fseq");
        obj1.set("fseq", (Object)obj2.getLong("fseq"));
        obj2.set("fseq", (Object)fseq);
    }

    private void deleteTreeNode(String focusNodeId) {
        if (!this.ifCanWrite(Long.parseLong(focusNodeId))) {
            return;
        }
        if (StringUtil.isEmptyString((String)focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8282\u70b9\u3002", (String)"DocumentManagePlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (FILE.equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"DocumentManagePlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long id = Long.parseLong(focusNodeId);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id", (QFilter[])new QFilter("parentid", "=", (Object)id).toArray());
        if (coll != null && !coll.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u4e0b\u5b58\u5728\u5b50\u8282\u70b9\u6216\u6587\u6863\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DocumentManagePlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\uff1f", (String)"DocumentManagePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btn_delete", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() == MessageBoxResult.Yes && "btn_delete".equals(evt.getCallBackId())) {
            String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
            long docId = Long.parseLong(focusNodeId);
            DynamicObject document = QueryServiceHelper.queryOne((String)"bcm_docmodel", (String)"id,parentid,name", (QFilter[])this.getIdQfilter(docId).toArray());
            DeleteServiceHelper.delete((String)"bcm_docmodel", (QFilter[])this.getIdQfilter(docId).toArray());
            String parentid = FILE;
            if (null != document.get("parentid")) {
                parentid = document.getString("parentid");
            }
            this.getPageCache().put(FOCUS_NODE_ID, parentid);
            this.initLeftTree();
            this.focusOnNode(parentid);
            this.refrushEntityList(0);
            if (document != null) {
                String opName = ResManager.loadKDString((String)"\u76ee\u5f55\u5220\u9664", (String)"UploadDocumentPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                String opDescribe = String.format(ResManager.loadKDString((String)"%s \u5220\u9664\u6210\u529f", (String)"UploadDocumentPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), document.getString("name"));
                OperationLogUtil.writeOperationLog((String)opName, (String)opDescribe, (Long)this.getModelId(), (String)"bcm_docmodel");
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DocumentManagePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (evt.getResult() == MessageBoxResult.Yes && "baritemap_delete".equals(evt.getCallBackId())) {
            this.doDocDelete(true);
        }
    }

    private void focusOnNode(String nodeId) {
        TreeView tree = (TreeView)this.getControl(DOC_TREE);
        TreeNode treeNode = new TreeNode();
        treeNode.setId(nodeId);
        tree.focusNode(treeNode);
        this.showBtn(nodeId);
    }

    private void addNewTreeNode(String focusNodeId, boolean isAddNew) {
        if (!this.ifCanWrite(Long.parseLong(focusNodeId))) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("KEY_MODEL_ID", this.getModelId());
        long id = StringUtil.isEmptyString((String)focusNodeId) ? 0L : Long.parseLong(focusNodeId);
        params.put(CATALOG_ID, String.valueOf(id));
        params.put(ACTION_NAME, isAddNew ? "addnew" : "edit");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_docmodel");
        this.showEditForm(params, closeCallBack, isAddNew);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object id = evt.getReturnData();
        switch (actionId) {
            case "bcm_doc_uploads": {
                if (id != null) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\u3002", (String)"DocumentManagePlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.refrushEntityList(0);
                break;
            }
            case "bcm_docmodel": {
                if (!ObjectUtils.isEmpty((Object)id)) {
                    this.getPageCache().put(FOCUS_NODE_ID, id.toString());
                    this.initLeftTree();
                    this.focusOnNode(id.toString());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DocumentManagePlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.refrushEntityList(0);
                break;
            }
            case "bcm_doc_moveto": {
                if (ObjectUtils.isEmpty((Object)id)) break;
                this.getPageCache().put(FOCUS_NODE_ID, id.toString());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u6210\u529f\u3002", (String)"DocumentManagePlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.initLeftTree();
                this.focusOnNode(id.toString());
                this.refrushEntityList(0);
                break;
            }
            case "entitys": {
                DynamicObjectCollection doc = (DynamicObjectCollection)evt.getReturnData();
                if (doc == null && ThreadCache.get((Object)"okbtn") == null) {
                    return;
                }
                if (doc != null && doc.size() > 0) {
                    MultiF7Results results = MultiF7Results.buildParam((DynamicObjectCollection)doc, (long)this.getModelId());
                    this.getModel().setValue(actionId, (Object)results.getShowText());
                    this.getPageCache().put(actionId, SerializationUtils.toJsonString((Object)results.toList()));
                    this.getPageCache().remove("selectentitys");
                } else if (doc != null && doc.isEmpty()) {
                    this.getModel().setValue(actionId, (Object)" ");
                    this.getPageCache().put(actionId, null);
                    this.getPageCache().remove("selectentitys");
                }
                this.refreshData();
                break;
            }
        }
    }

    private void showEditForm(Map<String, Object> params, CloseCallBack closeCallBack, boolean isAddNew) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bcm_docmodel");
        param.setStatus(isAddNew ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        param.setCustomParams(params);
        this.getView().showForm(param);
    }

    private void constructorData() {
        this.initReportCatalog();
        this.initLeftTree();
    }

    private void initReportCatalog() {
        DynamicObject[] docReports = this.getReportFolder();
        String reportName = ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"DocumentManagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (docReports.length == 0) {
            DynamicObject catalog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_docmodel");
            catalog.set("type", (Object)Character.valueOf('1'));
            catalog.set("name", (Object)reportName);
            catalog.set("level", (Object)1);
            catalog.set("fseq", (Object)0);
            catalog.set("description", (Object)ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236\u5185\u4e0a\u4f20\u7684\u9644\u4ef6", (String)"DocumentManagePlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            catalog.set(model, (Object)this.getModelId());
            catalog.set("creator", (Object)UserUtils.getUserId());
            catalog.set("modifier", (Object)UserUtils.getUserId());
            catalog.set("createtime", (Object)new Date());
            catalog.set("modifytime", (Object)new Date());
            catalog.set("number", (Object)"doc_report");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{catalog});
            return;
        }
    }

    private DynamicObject[] getReportFolder() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter(model, "=", (Object)this.getModelId()));
        qfBuilder.add(new QFilter("type", "=", (Object)FOLDER));
        qfBuilder.add(new QFilter("parentid", "in", (Object)0L));
        qfBuilder.add(new QFilter("number", "=", (Object)"doc_report").or(new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"DocumentManagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
        DynamicObject[] docReports = BusinessDataServiceHelper.load((String)"bcm_docmodel", (String)"name, description, id", (QFilter[])qfBuilder.toArray());
        return docReports;
    }

    private void initLeftTree() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter(model, "=", (Object)this.getModelId()));
        qfBuilder.add(new QFilter("type", "in", (Object)FOLDER));
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        if (!adminUserBol) {
            qfBuilder.add(new QFilter("id", "not in", DocumentUtils.getPermIds(this.getModelId(), DataTypeEnum.NO)));
            int is = BcmBasePluginUtil.checkPermission(UserUtils.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.appnum).getId(), "bcm_doc_manage", AUTH_REPORT);
            if (is == 0) {
                qfBuilder.add(new QFilter("name", "!=", (Object)ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"DocumentManagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            }
        }
        DynamicObjectCollection nodes = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,name,type,parentid,fseq,url,description", (QFilter[])qfBuilder.toArray(), (String)"level asc, fseq asc");
        TreeNode catalog = new TreeNode();
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(10);
        if (!CollectionUtils.isEmpty((Collection)nodes)) {
            for (DynamicObject node : nodes) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", node.getString("id"));
                memberMap.put("name", node.getString("name"));
                memberMap.put("parentid", node.getString("parentid"));
                treeList.add(memberMap);
            }
        }
        catalog.setParentid("");
        catalog.setText(ResManager.loadKDString((String)"\u6839", (String)"DocumentManagePlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        catalog.setId(FILE);
        catalog.setIcon("kdfont kdfont-wenjianjia");
        DocumentManagePlugin.setEntryNode(catalog, treeList, catalog.getId());
        TreeView tree = (TreeView)this.getControl(DOC_TREE);
        tree.deleteAllNodes();
        tree.addNode(catalog);
        this.expandeAllSelectedNode(catalog, tree);
        tree.expand(catalog.getId());
        tree.focusNode(catalog);
    }

    private void doOpen() {
        this.checkPerm("baritemap_download");
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList.getSelectedRows().isEmpty()) {
            return;
        }
        long pkid = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject doc = QueryServiceHelper.queryOne((String)"bcm_documentlist", (String)"docid, type, isreport, name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
        if (doc == null) {
            return;
        }
        String type = doc.getString("type");
        boolean isreport = doc.getBoolean("isreport");
        long id = doc.getLong("docid");
        if (FILE.equals(type)) {
            DynamicObject dynamicObject;
            if (!isreport) {
                QFilter qFilter = new QFilter("id", "=", (Object)id);
                dynamicObject = QueryServiceHelper.queryOne((String)"bcm_docmodel", (String)"url, name", (QFilter[])qFilter.toArray());
            } else {
                QFilter qFilter = new QFilter("id", "=", (Object)id);
                qFilter.and("name", "=", (Object)doc.getString("name"));
                dynamicObject = QueryServiceHelper.queryOne((String)"bcm_chkattachment", (String)"url, name", (QFilter[])qFilter.toArray());
            }
            this.doDownload(dynamicObject);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"DocumentManagePlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (FOLDER.equals(type)) {
            this.getPageCache().put(FOCUS_NODE_ID, String.valueOf(id));
            this.initLeftTree();
            this.focusOnNode(String.valueOf(id));
        } else if (HYPERLINK.equals(type)) {
            QFilter qFilter = new QFilter("id", "=", (Object)id);
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_docmodel", (String)"url", (QFilter[])qFilter.toArray());
            String url = dy.getString("url");
            this.getView().openUrl(url);
        }
    }

    private void refreshBillList(List<QFilter> qfs) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.clearSelection();
        FilterParameter fp = new FilterParameter();
        if (qfs != null) {
            fp.setQFilters(qfs);
            billList.setFilterParameter(fp);
        }
        billList.refresh();
    }

    private void refreshReportEntityList(int rowNum) {
        this.deleteDocs();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"scene", "org", "fyear", "perioddim"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"baritemap_upload", "baritemap_delete", "baritemap_move"});
        if (DocumentUtils.getSelectOrgs(this.getPageCache(), this.getModelId()).isEmpty() && this.getPageCache().get("entitys") != null) {
            this.getView().updateView();
            return;
        }
        Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>> pair = this.getReportAttachments();
        List chkNoteInfos = (List)pair.p1;
        Map chkAttachments = (Map)pair.p2;
        if (chkAttachments == null) {
            this.getView().updateView();
            return;
        }
        List<DynamicObject> docs = this.collectRreportDocs(chkNoteInfos, chkAttachments);
        DocumentManagePlugin.saveDocs(docs);
        this.refreshBillList(null);
    }

    public static List<DynamicObject> sortDocs(List<DynamicObject> docs) {
        docs.sort(DocumentManagePlugin.compareType());
        docs.sort(DocumentManagePlugin.compareTime());
        return docs;
    }

    private static Comparator<DynamicObject> compareTime() {
        return (v1, v2) -> {
            String type = v1.getString("type");
            String type2 = v2.getString("type");
            if (FOLDER.equals(type) && FOLDER.equals(type2) || !FOLDER.equals(type) && !FOLDER.equals(type2)) {
                Date createtime1 = v1.getDate("createtime");
                if (createtime1 == null) {
                    return -1;
                }
                Date createtime2 = v2.getDate("createtime");
                if (createtime2 == null) {
                    return 0;
                }
                return createtime1.compareTo(createtime2);
            }
            return 0;
        };
    }

    private List<DynamicObject> collectRreportDocs(List<DynamicObject> chkNoteInfos, Map<Long, List<DynamicObject>> chkAttachments) {
        long modelId = this.getModelId();
        chkNoteInfos = this.filterDatas(chkNoteInfos, false, true);
        ArrayList<DynamicObject> docs = new ArrayList<DynamicObject>(16);
        DynamicObject[] reportFolder = this.getReportFolder();
        long parent = 0L;
        if (reportFolder != null && reportFolder.length != 0) {
            parent = reportFolder[0].getLong("id");
        }
        if (!CollectionUtil.isEmpty(chkNoteInfos)) {
            List notInfosIds = chkNoteInfos.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            AtomicInteger size = new AtomicInteger();
            chkAttachments.entrySet().stream().filter(e -> notInfosIds.contains(e.getKey())).forEach(e -> size.addAndGet(((List)e.getValue()).size()));
            Map<String, Map<String, Long>> dim2memNum2id = this.getDim2MemNum2Id(modelId, chkNoteInfos, "dimensionstr");
            for (DynamicObject row : chkNoteInfos) {
                long id = row.getLong("id");
                long templateId = row.getLong("template");
                List<DynamicObject> attachments = chkAttachments.get(id);
                for (DynamicObject attachment : attachments) {
                    String name = attachment.getString("name");
                    DynamicObject doc = BusinessDataServiceHelper.newDynamicObject((String)"bcm_documentlist");
                    doc.set(model, (Object)modelId);
                    doc.set("parent", (Object)parent);
                    doc.set("docid", (Object)attachment.getLong("id"));
                    doc.set("name", (Object)name);
                    doc.set("description", (Object)attachment.getString("description"));
                    doc.set("createtime", attachment.get("modifydate"));
                    doc.set("type", (Object)FILE);
                    doc.set("creator", (Object)attachment.getLong("modifier"));
                    doc.set("isreport", (Object)Character.valueOf('1'));
                    doc.set("template", (Object)templateId);
                    doc.set("groupid", (Object)this.gainGroupId());
                    Object o2 = ResManager.getLocaleString((String)"\u6587\u4ef6", (String)"DocumentManagePlugin_43", (String)"fi-bcm-formplugin");
                    int lastIndexOf = name.lastIndexOf(".");
                    if (lastIndexOf != -1) {
                        o2 = name.substring(lastIndexOf + 1);
                    }
                    doc.set("catalog", o2);
                    if (row.getString("attachmenttype").equals(FOLDER)) {
                        String dimStr = row.getString("dimensionstr");
                        if (kd.bos.util.StringUtils.isNotEmpty((String)dimStr)) {
                            this.generateInfoByDimensionStr(dimStr, dim2memNum2id, doc);
                        }
                        doc.set("source", (Object)String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c\u7ef4\u5ea6\u7ec4\u5408\uff1a%s", (String)"DocumentManagePlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DocumentUtils.getCellAttachmentSource(row.getString("dimensionstr"), this.getModelId())));
                    } else if (row.getString("attachmenttype").equals(HYPERLINK)) {
                        doc.set("entity", (Object)row.getLong("entity"));
                        doc.set("scene", (Object)row.getLong("scene"));
                        doc.set("year", (Object)row.getLong("year"));
                        doc.set("period", (Object)row.getLong("period"));
                        doc.set("source", (Object)String.format(ResManager.loadKDString((String)"\u62a5\u8868\uff1a%s", (String)"DocumentManagePlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row.getString("template.name")));
                    }
                    docs.add(doc);
                }
            }
        }
        return docs;
    }

    private void generateInfoByDimensionStr(String dimensionstr, Map<String, Map<String, Long>> dim2memNum2id, DynamicObject doc) {
        String[] split;
        for (String s : split = dimensionstr.split(",")) {
            String[] dimension = s.split("\\|");
            if (dimension.length != 2) continue;
            if (dimension[0].equalsIgnoreCase(DimEntityNumEnum.ENTITY.getNumber())) {
                DocumentManagePlugin.docSetMemId(dim2memNum2id, doc, dimension[1], DimEntityNumEnum.ENTITY.getNumber(), "entity");
                continue;
            }
            if (dimension[0].equalsIgnoreCase(DimEntityNumEnum.SCENARIO.getNumber())) {
                DocumentManagePlugin.docSetMemId(dim2memNum2id, doc, dimension[1], DimEntityNumEnum.SCENARIO.getNumber(), "scene");
                continue;
            }
            if (dimension[0].equalsIgnoreCase(DimEntityNumEnum.YEAR.getNumber())) {
                DocumentManagePlugin.docSetMemId(dim2memNum2id, doc, dimension[1], DimEntityNumEnum.YEAR.getNumber(), "year");
                continue;
            }
            if (!dimension[0].equalsIgnoreCase(DimEntityNumEnum.PERIOD.getNumber())) continue;
            DocumentManagePlugin.docSetMemId(dim2memNum2id, doc, dimension[1], DimEntityNumEnum.PERIOD.getNumber(), "period");
        }
    }

    private static void docSetMemId(Map<String, Map<String, Long>> dim2memNum2id, DynamicObject doc, String memNum, String entityNumber, String property) {
        Map<String, Long> dimnum2id = dim2memNum2id.get(entityNumber);
        if (dimnum2id.containsKey(memNum)) {
            doc.set(property, (Object)dimnum2id.get(memNum));
        }
    }

    private Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>> getReportAttachments() {
        QFilter modelQf = new QFilter(model, "=", (Object)this.getModelId());
        DynamicObjectCollection chkNoteInfos = QueryServiceHelper.query((String)"bcm_chknoteinfo", (String)"id,dimensionstr,scene,scene.number,scene.name,year,year.number,year.name,period,period.number,period.name,currency,entity,entity.id,entity.number,entity.name,template,template.name,attachmenttype", (QFilter[])new QFilter[]{modelQf});
        Set ids = chkNoteInfos.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        QFilter qf = new QFilter("noteinfo", "in", ids);
        DynamicObjectCollection chkAttachments = QueryServiceHelper.query((String)"bcm_chkattachment", (String)"id,noteinfo,name,url,uid,description,modifier,modifydate", (QFilter[])new QFilter[]{qf});
        if (chkAttachments.size() == 0) {
            return Pair.onePair(null, null);
        }
        Set uids = chkAttachments.stream().map(o -> o.getString("uid")).collect(Collectors.toSet());
        QFilter uidFilter = new QFilter("FNUMBER", "in", uids);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_attachment", (String)"FNUMBER,fdescription", (QFilter[])new QFilter[]{uidFilter});
        HashMap uidDesMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            uidDesMap.put(dynamicObject.getString("FNUMBER"), dynamicObject.getString("fdescription"));
        }
        HashSet idList = Sets.newHashSetWithExpectedSize((int)16);
        HashMap chkAttachmentMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject chkAttachment : chkAttachments) {
            long noteinfo = chkAttachment.getLong("noteinfo");
            String uid = chkAttachment.getString("uid");
            chkAttachment.set("description", uidDesMap.get(uid));
            idList.add(noteinfo);
            List atts = (List)chkAttachmentMap.get(noteinfo);
            if (CollectionUtils.isEmpty((Collection)atts)) {
                atts = Lists.newArrayList((Object[])new DynamicObject[]{chkAttachment});
            } else {
                atts.add(chkAttachment);
            }
            chkAttachmentMap.put(noteinfo, atts);
        }
        List chkNoteInfo = chkNoteInfos.stream().filter(o -> idList.contains(o.getLong("id"))).collect(Collectors.toList());
        return Pair.onePair(chkNoteInfo, (Object)chkAttachmentMap);
    }

    public List<DynamicObject> filterDatas(Collection<DynamicObject> dyos, final boolean flag, final boolean isReport) {
        if (CollectionUtil.isEmpty(dyos)) {
            return new ArrayList<DynamicObject>(16);
        }
        long modelId = this.getModelId();
        final Map<String, Object> pageDimMemMap = DocumentUtils.getPageDimMemMap(this.getPageCache(), modelId, this.getModel());
        Predicate<DynamicObject> predicate = new Predicate<DynamicObject>(){

            @Override
            public boolean test(DynamicObject e) {
                if (isReport) {
                    return !DocumentManagePlugin.this.isNoOrgPerm(e.getLong("entity.id"), e.getString("dimensionstr")) && DocumentUtils.isMatchDimMems(e, (Map<String, Object>)pageDimMemMap, false);
                }
                return DocumentManagePlugin.FOLDER.equals(e.getString("type")) || DocumentUtils.isMatchDimMems(e, (Map<String, Object>)pageDimMemMap, flag);
            }
        };
        List<Object> filetDocs = dyos.stream().filter(predicate).collect(Collectors.toList());
        String userId = RequestContext.get().getUserId();
        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(userId), (String)String.valueOf(modelId));
        if (isAdmin) {
            return filetDocs;
        }
        HashMultimap dim2nums = HashMultimap.create();
        HashMultimap dim2ids = HashMultimap.create();
        HashMap<Long, Map<String, String>> docId2DinMem = new HashMap<Long, Map<String, String>>(16);
        HashSet<Long> noPermTemplateIds = new HashSet(16);
        if (isReport) {
            DocumentManagePlugin.collectDimMems(filetDocs, (HashMultimap<String, String>)dim2nums, (HashMultimap<String, Long>)dim2ids, docId2DinMem);
            noPermTemplateIds = DocumentUtils.getNoPermTemplateIds(modelId);
        } else {
            DocumentManagePlugin.collectDimMems4Doc(filetDocs, (HashMultimap<String, String>)dim2nums, docId2DinMem, modelId);
        }
        Pair<HashMultimap<String, Long>, HashMultimap<String, String>> noPermDimMems = DocumentManagePlugin.collectNoPermDimMems(modelId, (HashMultimap<String, String>)dim2nums, (HashMultimap<String, Long>)dim2ids);
        HashMultimap noPermDim2nums = (HashMultimap)noPermDimMems.p2;
        HashMultimap noPermDim2ids = (HashMultimap)noPermDimMems.p1;
        filetDocs = filetDocs.stream().filter(DocumentManagePlugin.permFilterPredicate(docId2DinMem, (HashMultimap<String, String>)noPermDim2nums, (HashMultimap<String, Long>)noPermDim2ids, noPermTemplateIds)).collect(Collectors.toList());
        return filetDocs;
    }

    private static Predicate<DynamicObject> permFilterPredicate(Map<Long, Map<String, String>> docId2DinMem, HashMultimap<String, String> noPermDim2nums, HashMultimap<String, Long> noPermDim2ids, Set<Long> noPermTemplateIds) {
        boolean hasNoPermTemplate = !noPermTemplateIds.isEmpty();
        return doc -> {
            if (hasNoPermTemplate && noPermTemplateIds.contains(doc.getLong("template"))) {
                return false;
            }
            if (docId2DinMem.containsKey(doc.getLong("id"))) {
                for (String dim : DocumentUtils.NEED_CHECKDIM.keySet()) {
                    if (!noPermDim2nums.containsKey((Object)dim) || !noPermDim2nums.get((Object)dim).contains(((Map)docId2DinMem.get(doc.getLong("id"))).get(dim))) continue;
                    return false;
                }
            } else {
                for (Map.Entry<String, String> entry : DocumentUtils.NEED_CHECKDIM.entrySet()) {
                    String dim = entry.getKey();
                    if (!noPermDim2ids.containsKey((Object)dim) || !noPermDim2ids.get((Object)dim).contains(doc.getLong(entry.getValue()))) continue;
                    return false;
                }
            }
            return true;
        };
    }

    private static Pair<HashMultimap<String, Long>, HashMultimap<String, String>> collectNoPermDimMems(long modelId, HashMultimap<String, String> dim2nums, HashMultimap<String, Long> dim2ids) {
        Long dimensionId;
        String entieyNumByNumber;
        PermissionService permissionService = PermissionServiceImpl.getInstance((Long)modelId);
        HashMultimap noPermDim2nums = HashMultimap.create();
        HashMultimap noPermDim2ids = HashMultimap.create();
        for (String dim : dim2nums.keySet()) {
            entieyNumByNumber = DimEntityNumEnum.getEntieyNumByNumber((String)dim);
            dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dim);
            Set nums = permissionService.matchNoPermMembersByNum(dimensionId, entieyNumByNumber, (Collection)dim2nums.get((Object)dim));
            noPermDim2nums.putAll((Object)dim, (Iterable)nums);
        }
        for (String dim : dim2ids.keySet()) {
            entieyNumByNumber = DimEntityNumEnum.getEntieyNumByNumber((String)dim);
            dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dim);
            Set ids = permissionService.matchNoPermMembers(dimensionId, entieyNumByNumber, (Collection)dim2ids.get((Object)dim));
            noPermDim2ids.putAll((Object)dim, (Iterable)ids);
        }
        Pair noPermMems = new Pair((Object)noPermDim2ids, (Object)noPermDim2nums);
        return noPermMems;
    }

    private static void collectDimMems(List<DynamicObject> filetDocs, HashMultimap<String, String> dim2nums, HashMultimap<String, Long> dim2ids, Map<Long, Map<String, String>> docId2DinMem) {
        for (DynamicObject doc : filetDocs) {
            String dimensionstr = doc.getString("dimensionstr");
            if (kd.bos.util.StringUtils.isNotEmpty((String)dimensionstr)) {
                HashMap<String, String> dim2mem = DocumentUtils.parseDocDimension(dimensionstr);
                for (String dim : DocumentUtils.NEED_CHECKDIM.keySet()) {
                    String memNum = (String)dim2mem.get(dim);
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)memNum)) continue;
                    dim2nums.put((Object)dim, (Object)memNum);
                }
                if (dim2mem.isEmpty()) continue;
                docId2DinMem.put(doc.getLong("id"), dim2mem);
                continue;
            }
            DocumentUtils.NEED_CHECKDIM.forEach((dimNum, dimSelect) -> {
                long memId = doc.getLong(dimSelect);
                if (memId != 0L) {
                    dim2ids.put(dimNum, (Object)memId);
                }
            });
        }
    }

    private static void collectDimMems4Doc(List<DynamicObject> filetDocs, HashMultimap<String, String> dim2nums, Map<Long, Map<String, String>> docId2DinMem, Long modelId) {
        if (ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isAllowMemAuthority")) {
            for (DynamicObject doc : filetDocs) {
                String dimensionstr = doc.getString("dims");
                if (!kd.bos.util.StringUtils.isNotEmpty((String)dimensionstr)) continue;
                HashMap<String, String> dim2mem = DocumentUtils.parseDocDimension(dimensionstr);
                for (String dim : DocumentUtils.NEED_CHECKDIM.keySet()) {
                    String memNum = (String)dim2mem.get(dim);
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)memNum)) continue;
                    dim2nums.put((Object)dim, (Object)memNum);
                }
                if (dim2mem.isEmpty()) continue;
                docId2DinMem.put(doc.getLong("id"), dim2mem);
            }
        }
    }

    private boolean isNoOrgPerm(long orgId, String dimensionStr) {
        String[] split;
        long modelId = this.getModelId();
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.ENTITY.getNumber());
        if (orgId != 0L) {
            return PermissionServiceImpl.getInstance((Long)modelId).hasNoPerm(dimensionId, Long.valueOf(orgId));
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (String s : split = dimensionStr.split(",")) {
            String[] dimension = s.split("\\|");
            if (!dimension[0].equalsIgnoreCase(DimEntityNumEnum.ENTITY.getNumber())) continue;
            String memberNum = dimension[1];
            return PermissionServiceImpl.getInstance((Long)modelId).hasNoPerm(dimensionId, MemberReader.findEntityMemberByNum((String)modelNum, (String)memberNum).getId());
        }
        return true;
    }

    private void deleteDocs() {
        Object[] params = new SqlParameter[]{new SqlParameter(":fgroupid", 1, (Object)this.gainGroupId())};
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"delete from t_bcm_documentlist where fgroupid = ? ", (Object[])params);
    }

    private void refrushEntityList(int rowNum) {
        this.deleteDocs();
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"baritemap_upload", "baritemap_delete", "baritemap_move"});
        DynamicObjectCollection coll = this.getViewableDynamicObjects();
        Map<Long, Long> permMap = this.getPermClassMap();
        long modelId = this.getModelId();
        List<DynamicObject> filterCols = this.filterDatas((Collection<DynamicObject>)coll, DocumentUtils.getSelectOrgs(this.getPageCache(), modelId).isEmpty() && this.getPageCache().get("entitys") != null, false);
        ArrayList<DynamicObject> docs = new ArrayList<DynamicObject>(16);
        if (!filterCols.isEmpty()) {
            Map<String, Map<String, Long>> dim2memNum2id = this.getDim2MemNum2Id(modelId, filterCols, "dims");
            for (int i = 0; i < filterCols.size(); ++i) {
                DynamicObject doc = BusinessDataServiceHelper.newDynamicObject((String)"bcm_documentlist");
                DynamicObject row = filterCols.get(i);
                String type = row.getString("type");
                String dims = row.getString("dims");
                if ((FILE.equals(type) || HYPERLINK.equals(type)) && kd.bos.util.StringUtils.isNotEmpty((String)dims)) {
                    this.generateInfoByDimensionStr(dims, dim2memNum2id, doc);
                }
                doc.set("parent", (Object)row.getLong("parentid"));
                doc.set(model, (Object)modelId);
                doc.set("fseq", (Object)row.getInt("fseq"));
                long docId = row.getLong("id");
                doc.set("docid", (Object)docId);
                doc.set("name", (Object)row.getString("name"));
                doc.set("description", (Object)row.getString("description"));
                doc.set("createtime", row.get("createtime"));
                doc.set("type", (Object)type);
                if (permMap.containsKey(docId)) {
                    doc.set("permid", (Object)permMap.get(docId));
                }
                doc.set("creator", (Object)row.getLong("creator"));
                doc.set("isreport", (Object)Character.valueOf('0'));
                doc.set("groupid", (Object)this.gainGroupId());
                LocaleString o1 = ResManager.getLocaleString((String)"\u6587\u4ef6\u5939", (String)"DocumentManagePlugin_35", (String)"fi-bcm-formplugin");
                Object o2 = ResManager.getLocaleString((String)"\u6587\u4ef6", (String)"DocumentManagePlugin_36", (String)"fi-bcm-formplugin");
                LocaleString o3 = ResManager.getLocaleString((String)"\u94fe\u63a5", (String)"DocumentManagePlugin_34", (String)"fi-bcm-formplugin");
                if (FILE.equals(type)) {
                    String name = row.getString("name");
                    int lastIndexOf = name.lastIndexOf(".");
                    if (lastIndexOf != -1) {
                        o2 = name.substring(lastIndexOf + 1);
                    }
                    doc.set("catalog", o2);
                } else if (HYPERLINK.equals(type)) {
                    doc.set("catalog", (Object)o3);
                    doc.set("description", (Object)row.getString("url"));
                } else if (FOLDER.equals(type)) {
                    doc.set("catalog", (Object)o1);
                }
                docs.add(doc);
            }
        }
        boolean showAll = this.isShowAll();
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (showAll && FILE.equals(focusNodeId) && (!DocumentUtils.getSelectOrgs(this.getPageCache(), this.getModelId()).isEmpty() || this.getPageCache().get("entitys") == null)) {
            Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>> pair = this.getReportAttachments();
            List chkNoteInfos = (List)pair.p1;
            Map chkAttachments = (Map)pair.p2;
            List<DynamicObject> reportDocs = this.collectRreportDocs(chkNoteInfos, chkAttachments);
            docs.addAll(reportDocs);
        }
        DocumentManagePlugin.saveDocs(docs);
        this.refreshBillList(null);
    }

    private boolean isShowAll() {
        Object showall = this.getModel().getValue("showall");
        boolean showAll = showall instanceof Boolean ? (Boolean)showall : false;
        return showAll;
    }

    private static void saveDocs(List<DynamicObject> docs) {
        if (!docs.isEmpty()) {
            docs = DocumentManagePlugin.sortDocs(docs);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_documentlist");
            int fetchSize = 10000;
            int orm_maxobjects = 10000;
            int docSize = docs.size();
            for (int pos = 0; pos <= docSize && fetchSize > 0; pos += fetchSize) {
                fetchSize = orm_maxobjects;
                if (fetchSize > docSize - pos) {
                    fetchSize = docSize - pos;
                }
                if (fetchSize <= 0) continue;
                BusinessDataWriter.save((IDataEntityType)dynamicObject.getDynamicObjectType(), (Object[])docs.subList(pos, pos + fetchSize).toArray(new DynamicObject[0]));
            }
        }
    }

    private static Comparator<DynamicObject> compareType() {
        return (v1, v2) -> {
            String type = v1.getString("type");
            String type2 = v2.getString("type");
            if (FOLDER.equals(type)) {
                return -1;
            }
            if (FOLDER.equals(type2)) {
                return 1;
            }
            return 0;
        };
    }

    private Map<String, Map<String, Long>> getDim2MemNum2Id(long modelId, List<DynamicObject> filterCols, String dimProperty) {
        String cube = MemberReader.findModelNumberById((Object)modelId);
        HashMap<String, Map<String, Long>> dim2memNum2id = new HashMap<String, Map<String, Long>>(16);
        for (String dim : DIMS) {
            Collection nodes = MemberReader.getAllNodeByDimNum((String)dim, (String)cube);
            HashMap<String, Long> numMap = new HashMap<String, Long>(16);
            for (IDNumberTreeNode node : nodes) {
                numMap.put(node.getNumber(), node.getId());
            }
            dim2memNum2id.put(dim, numMap);
        }
        Map<String, Long> entityNum2Id = this.entityNum2Id(filterCols, dimProperty);
        dim2memNum2id.put(DimTypesEnum.ENTITY.getNumber(), entityNum2Id);
        return dim2memNum2id;
    }

    private Map<String, Long> entityNum2Id(List<DynamicObject> filterCols, String dimProperty) {
        String entityKey = "Entity|";
        HashSet<String> orgNums = new HashSet<String>(16);
        for (DynamicObject filterCol : filterCols) {
            String[] split;
            String dims = filterCol.getString(dimProperty);
            if (!kd.bos.util.StringUtils.isNotEmpty((String)dims) || !dims.contains(entityKey)) continue;
            for (String s : split = dims.split(",")) {
                String[] dimension = s.split("\\|");
                if (dimension.length != 2 || !dimension[0].equalsIgnoreCase(DimEntityNumEnum.ENTITY.getNumber())) continue;
                orgNums.add(dimension[1]);
            }
        }
        QFilter qf = new QFilter(model, "=", (Object)this.getModelId());
        qf.and("number", "in", orgNums);
        qf.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        DynamicObjectCollection entitys = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])qf.toArray());
        HashMap<String, Long> entityNum2Id = new HashMap<String, Long>(16);
        for (DynamicObject entity : entitys) {
            entityNum2Id.put(entity.getString("number"), entity.getLong("id"));
        }
        return entityNum2Id;
    }

    private DynamicObjectCollection getViewableDynamicObjects() {
        QFilter qf;
        String catalogid = this.getPageCache().get(FOCUS_NODE_ID);
        Long folderId = LongUtil.toLong((Object)catalogid);
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        boolean showAll = this.isShowAll();
        if (showAll) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter(model, "=", (Object)this.getModelId()));
            qfBuilder.add(new QFilter("type", "in", (Object)FOLDER));
            if (!admin) {
                qfBuilder.add(new QFilter("id", "not in", DocumentUtils.getPermIds(this.getModelId(), DataTypeEnum.NO)));
                int is = BcmBasePluginUtil.checkPermission(UserUtils.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.appnum).getId(), "bcm_doc_manage", AUTH_REPORT);
                if (is == 0) {
                    qfBuilder.add(new QFilter("name", "!=", (Object)ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"DocumentManagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                }
            }
            DynamicObjectCollection folders = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,parentid", (QFilter[])qfBuilder.toArray());
            HashMultimap parent2sonIds = HashMultimap.create();
            for (DynamicObject folder : folders) {
                long parentid = folder.getLong("parentid");
                long id = folder.getLong("id");
                parent2sonIds.put((Object)parentid, (Object)id);
            }
            ArrayList<Long> sons = new ArrayList<Long>(16);
            sons.add(folderId);
            this.getChild((Multimap<Long, Long>)parent2sonIds, folderId, sons);
            qf = new QFilter("parentid", "in", sons);
        } else {
            qf = new QFilter("parentid", "=", (Object)folderId);
        }
        qf.and(model, "=", (Object)this.getModelId());
        if (!admin) {
            qf.and(new QFilter("id", "not in", DocumentUtils.getPermIds(this.getModelId(), DataTypeEnum.NO)));
            int is = BcmBasePluginUtil.checkPermission(UserUtils.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.appnum).getId(), "bcm_doc_manage", AUTH_REPORT);
            if (is == 0) {
                qf.and(new QFilter("name", "!=", (Object)ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"DocumentManagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            }
        }
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,name,description,type,createtime,creator, dims, url, fseq, parentid", (QFilter[])new QFilter[]{qf}, (String)"fseq asc, createtime desc");
        return collect;
    }

    private void getChild(Multimap<Long, Long> parent2sonIds, long parentId, List<Long> sons) {
        Collection children = parent2sonIds.get((Object)parentId);
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        sons.addAll(children);
        for (Long child : children) {
            this.getChild(parent2sonIds, child, sons);
        }
    }

    private void expandeAllSelectedNode(TreeNode catalog, TreeView tree) {
        String nodeID = this.getPageCache().get(FOCUS_NODE_ID);
        if (!FILE.equals(nodeID)) {
            TreeNode currentNode = catalog.getTreeNode(nodeID, 10);
            tree.expand(nodeID);
            if (null != currentNode && currentNode.getId() != null) {
                String parentid = currentNode.getParentid();
                while (!parentid.equals(catalog.getId())) {
                    tree.expand(parentid);
                    TreeNode parentNode = catalog.getTreeNode(parentid, 10);
                    parentid = parentNode.getParentid();
                }
            }
        }
    }

    private static TreeNode setEntryNode(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>(16);
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parentid");
            ArrayList<Map<String, String>> nodeList = (ArrayList<Map<String, String>>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<Map<String, String>>(10);
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        return DocumentManagePlugin.createNode(root, nodeMap, headId);
    }

    private static TreeNode createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            for (Map<String, String> map : list) {
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name"));
                entry.setIcon("kdfont kdfont-wenjianjia");
                String entryHeadId = map.get("id");
                DocumentManagePlugin.createNode(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
        return root;
    }

    private void disableBtn(boolean flag, String[] strings) {
        if (null != strings && strings.length > 0) {
            for (String string : strings) {
                this.getView().setEnable(Boolean.valueOf(flag), new String[]{string});
            }
        }
    }

    private boolean ifCanRead(DynamicObjectCollection collect) {
        boolean flag = true;
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        DynamicObject obj = null;
        if (!admin) {
            Collection<Long> noRightData = DocumentUtils.getPermIds(this.getModelId(), DataTypeEnum.NO);
            for (DynamicObject dynamicObject : collect) {
                long id = dynamicObject.getLong("docid");
                if (!noRightData.contains(id)) continue;
                flag = false;
                obj = dynamicObject;
                break;
            }
        }
        if (!flag) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u201c%s\u201d\u7684\u6743\u9650\u3002", (String)"DocumentManagePlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getString("name")));
        }
        return flag;
    }

    private QFilter getIdQfilter(long id) {
        return new QFilter("id", "=", (Object)id);
    }

    private boolean ifCanWrite(Long docId) {
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        boolean flag = true;
        DynamicObject dynamicObject = null;
        if (!admin && docId != 0L) {
            dynamicObject = QueryServiceHelper.queryOne((String)"bcm_docmodel", (String)"id,parentid,name", (QFilter[])new QFilter[]{this.getIdQfilter(docId)});
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236\u6587\u4ef6\u5939\u9644\u4ef6\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"DocumentManagePlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            Collection<Long> rightData = DocumentUtils.getPermIds(this.getModelId(), DataTypeEnum.READ, DataTypeEnum.NO);
            if (rightData.contains(dynamicObject.getLong("id")) || dynamicObject.get("parentid") != null && rightData.contains(dynamicObject.getLong("parentid"))) {
                flag = false;
            }
        }
        if (!flag) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u201c%s\u201d\u7684\u6743\u9650\u3002", (String)"DocumentManagePlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")));
        }
        return flag;
    }

    private boolean ifCanWrite(Long docId, boolean admin, Collection<Long> rightData, Map<Long, DynamicObject> id2dy) {
        boolean flag = true;
        if (!admin && docId != 0L) {
            DynamicObject doc = id2dy.get(docId);
            if (doc == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236\u6587\u4ef6\u5939\u9644\u4ef6\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"DocumentManagePlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (rightData.contains(doc.getLong("id")) || doc.get("parentid") != null && rightData.contains(doc.getLong("parentid"))) {
                flag = false;
            }
            if (!flag) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u201c%s\u201d\u7684\u6743\u9650\u3002", (String)"DocumentManagePlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), doc.getString("name")));
            }
        }
        return flag;
    }

    private Map<Long, Long> getPermClassMap() {
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_docmodel", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId());
        if (map.size() == 0) {
            return new HashMap<Long, Long>();
        }
        Map permMap = map.asMap();
        HashMap<Long, Long> newMap = new HashMap<Long, Long>();
        for (Map.Entry entry : permMap.entrySet()) {
            Collection ids = (Collection)entry.getValue();
            QueryServiceHelper.query((String)"bcm_permclass_entity", (String)"entityid, permclass.id", (QFilter[])new QFilter[]{new QFilter(model, "=", (Object)this.getModelId()).and("entityid", "in", (Object)ids)}).forEach(e -> newMap.put(e.getLong("entityid"), e.getLong("permclass.id")));
        }
        return newMap;
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        this.deleteDocs();
        super.beforeClosed(e);
    }
}

