/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.form;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.DocumentUtils;

public class DocumentMovePlugin
extends AbstractBaseFormPlugin {
    protected static final String TREEVIEWWAP = "treeviewap";
    protected static final String TREEROOT = "treeroot";
    protected static final String ROWLIST = "rowlist";
    protected static final String FOCUS = "focus";
    protected static final Integer INITIALCAPACITY = 10;

    @Override
    public void initialize() {
        super.initialize();
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(var1 -> {
            if (var1.getText() != null && !"".equals(var1.getText())) {
                this.searchMember(var1.getText().toLowerCase(Locale.ENGLISH).trim());
            } else {
                this.getPageCache().put(ROWLIST, null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btn_cancel", "searchbefore", "searchnext");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTree();
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_confirm": {
                this.moveDoc();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
                break;
            }
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            TreeNode old;
            String rowcache = this.getPageCache().get(ROWLIST);
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"DocumentMovePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode[] rowList = (TreeNode[])SerializationUtils.fromJsonString((String)rowcache, TreeNode[].class);
            int rowCount = Integer.parseInt(this.getPageCache().get(FOCUS));
            if ("searchbefore".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DocumentMovePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else {
                if (rowList.length - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DocumentMovePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            this.getPageCache().put(FOCUS, String.valueOf(rowCount));
            TreeNode focusNode = rowList[rowCount];
            TreeView treeView = (TreeView)this.getControl(TREEVIEWWAP);
            String oldnode = this.getPageCache().get("oldnode");
            TreeNode treeNode = old = oldnode == null ? null : (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldnode);
            if (old != null) {
                old.setColor("");
                treeView.updateNode(old);
            }
            treeView.updateNode(focusNode);
            treeView.focusNode(focusNode);
            this.getPageCache().put("oldnode", SerializationUtils.serializeToBase64((Object)focusNode));
        }
    }

    private void moveDoc() {
        TreeView tree = (TreeView)this.getControl(TREEVIEWWAP);
        Map map = tree.getTreeState().getFocusNode();
        Long docId = LongUtil.toLong(map.get("id"));
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        Collection<Long> permIds = DocumentUtils.getPermIds(modelId, DataTypeEnum.READ, DataTypeEnum.NO);
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        if (0L != docId && permIds.contains(docId) && !admin) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u76ee\u5f55\u3010%s\u3011\u7684\u5199\u5165\u6743\u9650", (String)"DocumentMovePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), map.get("text")));
            return;
        }
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        Object[] moveDocs = BusinessDataServiceHelper.load((String)"bcm_docmodel", (String)"id, parentid, type, name, dims", (QFilter[])qFilter.toArray());
        List names = Arrays.stream(moveDocs).map(e -> e.getString("name")).collect(Collectors.toList());
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId()).and("name", "in", names).and("parentid", "=", (Object)docId);
        DynamicObjectCollection existDocs = QueryServiceHelper.query((String)"bcm_docmodel", (String)"parentid, type, name, dims", (QFilter[])qf.toArray());
        HashBasedTable docTable = HashBasedTable.create();
        for (DynamicObject existDoc : existDocs) {
            String string;
            String name = existDoc.getString("name");
            List dimsList = (List)docTable.get((Object)name, (Object)(string = existDoc.getString("type")));
            if (dimsList != null) {
                dimsList.add(existDoc.getString("dims"));
                continue;
            }
            ArrayList<String> dims = new ArrayList<String>(INITIALCAPACITY);
            dims.add(existDoc.getString("dims"));
            docTable.put((Object)name, (Object)string, dims);
        }
        for (DynamicObject dynamicObject : moveDocs) {
            String name = dynamicObject.getString("name");
            String type = dynamicObject.getString("type");
            String dims = dynamicObject.getString("dims");
            List dimsList = (List)docTable.get((Object)name, (Object)type);
            if (dimsList != null && dimsList.contains(dims)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"UploadDocumentPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
                return;
            }
            dynamicObject.set("parentid", (Object)docId);
        }
        if (moveDocs.length > 0) {
            BusinessDataWriter.update((IDataEntityType)moveDocs[0].getDynamicObjectType(), (Object[])moveDocs);
            String docs = Arrays.stream(moveDocs).map(e -> e.getString("name")).collect(Collectors.joining(";"));
            String opName = ResManager.loadKDString((String)"\u6587\u6863\u79fb\u52a8", (String)"UploadDocumentPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String opDescribe = String.format(ResManager.loadKDString((String)"%s \u6587\u6863\u79fb\u52a8\u6210\u529f", (String)"UploadDocumentPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), docs);
            OperationLogUtil.writeOperationLog((String)opName, (String)opDescribe, (Long)modelId, (String)"bcm_docmodel");
        }
        this.getView().returnDataToParent((Object)docId);
        this.getView().close();
    }

    private void initTree() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        qfBuilder.add(new QFilter("type", "=", (Object)Character.valueOf('1')));
        qfBuilder.add(new QFilter("name", "!=", (Object)ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"DocumentMovePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId));
        if (!adminUserBol) {
            qfBuilder.add(new QFilter("id", "not in", DocumentUtils.getPermIds(modelId, DataTypeEnum.NO)));
        }
        DynamicObjectCollection nodes = QueryServiceHelper.query((String)"bcm_docmodel", (String)"id,name,parentid,fseq", (QFilter[])qfBuilder.toArray(), (String)"fseq ASC");
        TreeNode catalog = new TreeNode();
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(INITIALCAPACITY);
        if (!CollectionUtils.isEmpty((Collection)nodes)) {
            for (DynamicObject node : nodes) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", node.getString("id"));
                memberMap.put("name", node.getString("name"));
                memberMap.put("parentid", node.getString("parentid"));
                treeList.add(memberMap);
            }
        }
        catalog.setParentid("");
        catalog.setText(ResManager.loadKDString((String)"\u6839", (String)"DocumentMovePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        catalog.setId("0");
        catalog.setIcon("kdfont kdfont-wenjianjia");
        DocumentMovePlugin.setEntryNode(catalog, treeList, catalog.getId());
        TreeView tree = (TreeView)this.getControl(TREEVIEWWAP);
        tree.deleteAllNodes();
        tree.addNode(catalog);
        tree.expand(catalog.getId());
        tree.focusNode(catalog);
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)catalog));
    }

    private static TreeNode setEntryNode(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>(16);
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parentid");
            List nodeList = nodeMap.computeIfAbsent(parentId, e -> new ArrayList(INITIALCAPACITY));
            nodeList.add(node);
        }
        return DocumentMovePlugin.createNode(root, nodeMap, headId);
    }

    private static TreeNode createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            for (Map<String, String> map : list) {
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name"));
                entry.setIcon("kdfont kdfont-wenjianjia");
                String entryHeadId = map.get("id");
                DocumentMovePlugin.createNode(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
        return root;
    }

    private void searchMember(String text) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        TreeView mTree = (TreeView)this.getControl(TREEVIEWWAP);
        List<TreeNode> treeNodes = new ArrayList<TreeNode>(INITIALCAPACITY);
        treeNodes = this.getTreeNodeListByText(root, treeNodes, text);
        List<TreeNode> alltreeNodes = new ArrayList<TreeNode>(INITIALCAPACITY);
        alltreeNodes = this.getTreeNodeListByText(root, alltreeNodes, "");
        for (TreeNode treeNode : alltreeNodes) {
            treeNode.setIsOpened(true);
        }
        mTree.updateNodes(alltreeNodes);
        if (treeNodes.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"DocumentMovePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ROWLIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
        TreeNode asd = treeNodes.get(0);
        this.getPageCache().put(FOCUS, "0");
        mTree.updateNode(asd);
        mTree.focusNode(asd);
    }

    private List<TreeNode> getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase().contains(text.toLowerCase())) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
        return treeNodes;
    }
}

