/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.perm.AbstractMemberPermEditPlugin;

public class DocumentUserPlugin
extends AbstractMemberPermEditPlugin
implements BeforeF7SelectListener {
    public static final String USERENTRY_ID = "userentry";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid eg = (EntryGrid)this.getControl(USERENTRY_ID);
        int endIndex = eg.getEntryData().getEndIndex();
        if (endIndex != 0) {
            int[] selects = IntStream.range(0, endIndex).toArray();
            eg.selectRows(selects, 0);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object users = this.getView().getFormShowParameter().getCustomParam("users");
        if (users != null && StringUtils.isNotEmpty((CharSequence)users.toString())) {
            Map user = (Map)ObjectSerialUtil.deSerializedBytes((String)users.toString());
            for (Map.Entry type2id : user.entrySet()) {
                String type = (String)type2id.getKey();
                List ids = (List)type2id.getValue();
                for (Long id : ids) {
                    int rowIndex = this.getModel().createNewEntryRow(USERENTRY_ID);
                    this.getModel().setValue("etype", (Object)type, rowIndex);
                    this.getModel().setValue("eusers", (Object)id, rowIndex);
                    this.getModel().setValue("eusersnumber", (Object)id, rowIndex);
                }
            }
        }
    }

    private void addListener() {
        this.addClickListeners("btnok");
        this.addItemClickListeners("advcontoolbarap");
        BasedataEdit user = (BasedataEdit)this.getControl("baseuser");
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit usergroup = (BasedataEdit)this.getControl("baseusergroup");
        usergroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid usereg = (EntryGrid)this.getControl(USERENTRY_ID);
        usereg.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
            }
        });
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        if ("baseuser".equals(evt.getProperty().getName()) || "baseusergroup".equals(evt.getProperty().getName())) {
            CloseCallBack type = new CloseCallBack((IFormPlugin)this, evt.getProperty().getName());
            evt.getFormShowParameter().setCloseCallBack(type);
            evt.getFormShowParameter().setHasRight(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "baseuser": {
                this.setData2UserEntry((ListSelectedRowCollection)evt.getReturnData(), "bos_user");
                break;
            }
            case "baseusergroup": {
                this.setData2UserEntry((ListSelectedRowCollection)evt.getReturnData(), "bos_usergroup");
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            List<DynamicObject> userList = this.getEntrySelectedAndResultList(USERENTRY_ID);
            Map type2ids = userList.stream().collect(Collectors.groupingBy(e -> e.getString("etype"), Collectors.mapping(e -> e.getLong("eusers_id"), Collectors.toList())));
            Map type2Names = userList.stream().collect(Collectors.groupingBy(e -> e.getString("etype"), Collectors.mapping(e -> e.getDynamicObject("eusers").getLocaleString("name").getLocaleValue(), Collectors.toList())));
            Pair pair = new Pair(type2ids, type2Names);
            this.getView().returnDataToParent((Object)pair);
            this.getView().close();
        }
    }

    private List<DynamicObject> getEntrySelectedAndResultList(String entityid) {
        int[] rows = this.getEnterySelectRows(entityid);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (int row : rows) {
            DynamicObject dd = this.getModel().getEntryRowEntity(entityid, row);
            if (dd == null) continue;
            list.add(dd);
        }
        return list;
    }

    private void setData2UserEntry(ListSelectedRowCollection returnData, String baseType) {
        if (returnData == null) {
            return;
        }
        EntryGrid eg = (EntryGrid)this.getControl(USERENTRY_ID);
        int[] rowsIndex = eg.getSelectRows();
        HashSet<Integer> listRows = new HashSet<Integer>();
        ArrayList<Object> oids = this.getOldDisIds();
        returnData.forEach(p -> {
            if (!oids.contains(p.getPrimaryKeyValue())) {
                int rowIndex = this.getModel().createNewEntryRow(USERENTRY_ID);
                this.getModel().setValue("etype", (Object)baseType, rowIndex);
                this.getModel().setValue("eusers", p.getPrimaryKeyValue(), rowIndex);
                this.getModel().setValue("eusersnumber", p.getPrimaryKeyValue(), rowIndex);
                listRows.add(rowIndex);
            }
        });
        this.setDefaultSelectRows(eg, listRows, rowsIndex);
    }

    private void setDefaultSelectRows(EntryGrid eg, Set<Integer> listRows, int[] rows) {
        for (int row : rows) {
            listRows.add(row);
        }
        if (listRows.size() == 0) {
            return;
        }
        rows = new int[listRows.size()];
        int index = 0;
        for (Integer row : listRows) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private ArrayList<Object> getOldDisIds() {
        ArrayList<Object> ids = new ArrayList<Object>();
        this.getModel().getEntryEntity(USERENTRY_ID).forEach(p -> {
            if (p.getDynamicObject("eusers") != null) {
                ids.add(p.getDynamicObject("eusers").getPkValue());
            }
        });
        return ids;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addusergroup": {
                MulBasedataEdit userGroup = (MulBasedataEdit)this.getControl("baseusergroup");
                userGroup.click();
                break;
            }
            case "adduser": {
                MulBasedataEdit user = (MulBasedataEdit)this.getControl("baseuser");
                user.click();
                break;
            }
            case "deluser": {
                this.deleteEntryRow(USERENTRY_ID);
                break;
            }
        }
    }

    private void deleteEntryRow(String entryId) {
        int[] rows = this.getEnterySelectRows(entryId);
        if (rows.length > 0) {
            this.getModel().deleteEntryRows(entryId, rows);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"MemberPermEditPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private int[] getEnterySelectRows(String entityid) {
        EntryGrid eg = (EntryGrid)this.getControl(entityid);
        return eg.getSelectRows();
    }
}

