/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class FileListEntityMovePlugin
extends AbstractBaseFormPlugin {
    protected static final String TREEVIEWWAP = "treeviewap";
    protected static final String TREEROOT = "treeroot";
    protected static final String ROWLIST = "rowlist";
    protected static final String FOCUS = "focus";
    private static final String FOCUS_NODE_ID = "focusnodeid";

    @Override
    public void initialize() {
        super.initialize();
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(var1 -> {
            if (var1.getText() != null && !"".equals(var1.getText())) {
                this.searchMember(var1.getText().toLowerCase(Locale.ENGLISH).trim());
            } else {
                this.getPageCache().put(ROWLIST, null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btn_cancel", "searchbefore", "searchnext");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTree();
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_confirm": {
                this.doConfirm();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
                break;
            }
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            TreeNode old;
            String rowcache = this.getPageCache().get(ROWLIST);
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"FileListEntityMovePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode[] rowList = (TreeNode[])SerializationUtils.fromJsonString((String)rowcache, TreeNode[].class);
            int rowCount = Integer.parseInt(this.getPageCache().get(FOCUS));
            if ("searchbefore".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"FileListEntityMovePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else {
                if (rowList.length - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"FileListEntityMovePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            this.getPageCache().put(FOCUS, String.valueOf(rowCount));
            TreeNode focusNode = rowList[rowCount];
            TreeView treeView = (TreeView)this.getControl(TREEVIEWWAP);
            String oldnode = this.getPageCache().get("oldnode");
            TreeNode treeNode = old = oldnode == null ? null : (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldnode);
            if (old != null) {
                old.setColor("");
                treeView.updateNode(old);
            }
            treeView.updateNode(focusNode);
            treeView.focusNode(focusNode);
            this.getPageCache().put("oldnode", SerializationUtils.serializeToBase64((Object)focusNode));
        }
    }

    public void doConfirm() {
        this.getView().close();
    }

    private void initTree() {
        long modelID = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        TreeNode templatecatalog = new TreeNode();
        String selectFields = "id,name,number,parent,catalogtype";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelID);
        QFilter ftype = this.getCatalogtypeQFilter().or("parent.id", "=", (Object)0);
        String headid = "";
        String headName = "";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_templatecatalog", (String)selectFields, (QFilter[])new QFilter[]{fmodelid, ftype}, (String)"sequence");
        PermClassCache.cachePermission((IPageCache)this.getPageCache(), (String)"bcm_templatecatalog", (String)String.valueOf(modelID));
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelID));
        List noPerms = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)DataTypeEnum.NO.getIndex());
        ArrayList treeList = new ArrayList(10);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                if (!adminUserBol && noPerms.contains(task.getLong("id"))) continue;
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", (String)task.get("number"));
                memberMap.put("name", (String)task.get("name"));
                memberMap.put("parentid", task.get("parent").toString());
                treeList.add(memberMap);
                if (!"0".equals(task.get("parent").toString())) continue;
                headid = task.get("id").toString();
                headName = this.getRootName();
                templatecatalog.setId(headid);
            }
        }
        templatecatalog.setParentid("");
        templatecatalog.setText(headName);
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNode((TreeNode)templatecatalog, treeList, (String)headid);
        BCMTreeUtils.spreadAllNode((TreeNode)templatecatalog);
        if (StringUtils.isEmpty((String)templatecatalog.getId())) {
            return;
        }
        TreeView tree = (TreeView)this.getControl(TREEVIEWWAP);
        tree.deleteAllNodes();
        tree.addNode(templatecatalog);
        String focusnodeid = (String)this.getView().getFormShowParameter().getCustomParam(FOCUS_NODE_ID);
        TreeNode fo = this.findFocusNodeById(focusnodeid, templatecatalog);
        if (fo == null) {
            fo = templatecatalog;
        }
        tree.focusNode(fo);
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)templatecatalog));
    }

    private TreeNode findFocusNodeById(String id, TreeNode tree) {
        if (StringUtils.isEmpty((String)id) || tree == null) {
            return null;
        }
        if (id.equals(tree.getId())) {
            return tree;
        }
        if (tree.getChildren() != null) {
            for (TreeNode c : tree.getChildren()) {
                TreeNode fc = this.findFocusNodeById(id, c);
                if (fc == null) continue;
                return fc;
            }
        }
        return null;
    }

    private void searchMember(String text) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        TreeView mTree = (TreeView)this.getControl(TREEVIEWWAP);
        List<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        treeNodes = this.getTreeNodeListByText(root, treeNodes, text);
        List<TreeNode> alltreeNodes = new ArrayList<TreeNode>(10);
        alltreeNodes = this.getTreeNodeListByText(root, alltreeNodes, "");
        for (TreeNode treeNode : alltreeNodes) {
            treeNode.setIsOpened(true);
        }
        mTree.updateNodes(alltreeNodes);
        if (treeNodes.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"FileListEntityMovePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ROWLIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
        TreeNode asd = treeNodes.get(0);
        this.getPageCache().put(FOCUS, "0");
        mTree.updateNode(asd);
        mTree.focusNode(asd);
    }

    private List<TreeNode> getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
        return treeNodes;
    }

    protected QFilter getCatalogtypeQFilter() {
        return TemplateCatalogTypeEnum.getTemplateCalcog();
    }

    protected String getRootName() {
        return ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"FileListEntityMovePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }
}

