/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.form;

import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.message.MessageBcmServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.DocumentUtils;

public class UploadDocumentPlugin
extends AbstractBaseFormPlugin {
    private static final String ADD_NEW = "addnew";
    private static final String CATALOG_ID = "catalogid";
    private static final String ATTACHMENT_PANEL = "attchment";
    private static final String DOC_ADD = "bcm_docmodel";
    private static final String DOC_UPLOAD = "bcm_doc_uploads";
    private static final Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario", "year", "period"});
    private static final String FILE = "0";
    private static final String HYPERLINK = "2";

    @Override
    public void initialize() {
        super.initialize();
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>();
        this.asMapF7toType(new ArrayList<String>(dimKeys), SingleF7TypeEnum.LEAF, map);
        map.put("entity", SingleF7TypeEnum.COMMON);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("confirm", "cancel", "cover", "user");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getFormCustomParam("KEY_MODEL_ID"));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.assemModel();
        this.initModel();
        this.getModel().setValue("type", (Object)FILE);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"hyperlink"});
    }

    private void initModel() {
        Object entity;
        Object period;
        Object year;
        Object scene = this.getFormCustomParam("scenario");
        if (scene != null) {
            this.getModel().setValue("scenario", scene);
        }
        if ((year = this.getFormCustomParam("year")) != null) {
            this.getModel().setValue("year", year);
        }
        if ((period = this.getFormCustomParam("period")) != null) {
            this.getModel().setValue("period", period);
        }
        if ((entity = this.getFormCustomParam("entity")) != null) {
            this.getModel().setValue("entity", entity);
        }
    }

    private QFilter getIdQfilter(long id) {
        return new QFilter("id", "=", (Object)id);
    }

    private void assemModel() {
        String actionName = (String)this.getView().getFormShowParameter().getCustomParam("actionname");
        if (!ADD_NEW.equals(actionName)) {
            long catalogid = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(CATALOG_ID));
            DynamicObject dy = QueryServiceHelper.queryOne((String)DOC_ADD, (String)"name,description", (QFilter[])new QFilter[]{this.getIdQfilter(catalogid)});
            this.getModel().setValue("name", (Object)dy.getString("name"));
            this.getModel().setValue("description", (Object)dy.getString("description"));
            Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            this.getModel().getDataEntity().set("id", this.getView().getFormShowParameter().getCustomParam(CATALOG_ID));
            PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)modelid, (boolean)false);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Object user;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("user".equals(name) && ((user = this.getModel().getValue("user")) == null || StringUtils.isEmpty((String)user.toString()))) {
            this.getView().getPageCache().remove("users");
        }
        if ("sendmsg".equals(name)) {
            Boolean send = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getView().setEnable(send, new String[]{"user"});
        }
        if ("type".equals(name)) {
            Object type = this.getModel().getValue("type");
            this.getView().setVisible(Boolean.valueOf(!HYPERLINK.equals(type)), new String[]{ATTACHMENT_PANEL});
            this.getView().setVisible(Boolean.valueOf(HYPERLINK.equals(type)), new String[]{"hyperlink"});
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String entityId = ((Control)evt.getSource()).getView().getEntityId();
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            switch (entityId) {
                case "bcm_docmodel": {
                    this.handleDocAdd();
                    break;
                }
                case "bcm_doc_uploads": {
                    this.handleDocUpload();
                    break;
                }
            }
        } else if ("cancel".equals(key)) {
            this.getView().close();
        } else if ("user".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_docuser");
            showParameter.setCustomParam("users", (Object)this.getView().getPageCache().get("users"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "user"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("user".equals(key)) {
            Pair returnData = (Pair)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            Map type2ids = (Map)returnData.p1;
            Map type2Names = (Map)returnData.p2;
            String boseUser = "";
            String boseGroup = "";
            ArrayList userIds = new ArrayList();
            if (type2Names.containsKey("bos_user")) {
                boseUser = String.join((CharSequence)";", (Iterable)type2Names.get("bos_user"));
                userIds.addAll((Collection)type2ids.get("bos_user"));
            }
            if (type2Names.containsKey("bos_usergroup")) {
                boseGroup = String.join((CharSequence)";", (Iterable)type2Names.get("bos_usergroup"));
                DynamicObjectCollection users = UserDistributeServiceHelper.queryAllUsersByGroupIds((List)((List)type2ids.get("bos_usergroup")));
                List ids = users.stream().map(user -> user.getLong("user")).collect(Collectors.toList());
                userIds.addAll(ids);
            }
            this.getModel().setValue("user", (Object)(boseGroup + boseUser));
            this.getPageCache().put("users", ObjectSerialUtil.toByteSerialized((Object)type2ids));
            this.getPageCache().put("userId", ObjectSerialUtil.toByteSerialized(userIds));
            this.getPageCache().put("userName", boseUser);
            this.getPageCache().put("groupname", boseGroup);
        }
    }

    private void handleDocAdd() {
        OperationStatus status;
        DynamicObject document;
        String nmae = String.valueOf(this.getModel().getValue("name"));
        if (StringUtils.isEmpty((String)nmae)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5939\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UploadDocumentPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String actionName = (String)this.getView().getFormShowParameter().getCustomParam("actionname");
        if (this.checkExist(nmae, actionName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5939\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u3002", (String)"UploadDocumentPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long catalogid = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(CATALOG_ID));
        String editName = "";
        if (ADD_NEW.equals(actionName)) {
            document = BusinessDataServiceHelper.newDynamicObject((String)DOC_ADD);
            this.assemForAdd(document);
            DimensionServiceHelper.initObject4BaseInfo((DynamicObject)document);
            status = OperationStatus.ADDNEW;
        } else {
            status = OperationStatus.EDIT;
            document = BusinessDataServiceHelper.loadSingle((Object)catalogid, (String)DOC_ADD);
            editName = document.getString("name");
            document.set("name", this.getModel().getValue("name"));
            document.set("description", this.getModel().getValue("description"));
            editName = editName + "->" + this.getModel().getValue("name");
            RequestContext tx = RequestContext.get();
            LocalDateTime localDateTime = LocalDateTime.now();
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDateTime.atZone(zone).toInstant();
            Date createTime = Date.from(instant);
            document.set("modifytime", (Object)createTime);
            DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
            user.set("id", (Object)tx.getUserId());
            document.set("modifier", (Object)user);
        }
        BusinessDataWriter.save((IDataEntityType)document.getDataEntityType(), (Object[])new Object[]{document});
        PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (String)this.getModel().getDataEntity().getDataEntityType().getName(), (Long)document.getLong("id"), (Object)this.getFormCustomParam("KEY_MODEL_ID"), (OperationStatus)status);
        if (document != null) {
            String opName = "";
            String opDescribe = "";
            if (ADD_NEW.equals(actionName)) {
                opName = ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u5939", (String)"UploadDocumentPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                opDescribe = String.format(ResManager.loadKDString((String)"%s \u6587\u4ef6\u5939\u521b\u5efa\u6210\u529f", (String)"UploadDocumentPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), document.getString("name"));
            } else {
                opName = ResManager.loadKDString((String)"\u7f16\u8f91\u6587\u4ef6\u5939", (String)"UploadDocumentPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                opDescribe = String.format(ResManager.loadKDString((String)"%s \u6587\u4ef6\u5939\u7f16\u8f91\u6210\u529f", (String)"UploadDocumentPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), editName);
            }
            Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            OperationLogUtil.writeOperationLog((String)opName, (String)opDescribe, (Long)modelId, (String)DOC_ADD);
        }
        this.getView().returnDataToParent((Object)document.getLong("id"));
        this.getView().close();
    }

    private boolean checkExist(String name, String actionName) {
        DynamicObjectCollection load;
        if (name.equals(ResManager.getLocaleString((String)"\u6839", (String)"DocumentManagePlugin_31", (String)"fi-bcm-formplugin").toString())) {
            return true;
        }
        long catalogid = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(CATALOG_ID));
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        QFilter qf = new QFilter("model", "=", (Object)modelid).and("name", "=", (Object)name).and("type", "=", (Object)"1");
        if (!ADD_NEW.equals(actionName)) {
            qf.and("id", "not in", (Object)catalogid);
        }
        return !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(load = QueryServiceHelper.query((String)DOC_ADD, (String)"id,name", (QFilter[])new QFilter[]{qf})));
    }

    private void handleDocUpload() {
        Object type = this.getModel().getValue("type");
        List<Map<String, Object>> attachmentData = new ArrayList(10);
        if (HYPERLINK.equals(type)) {
            Object name = this.getModel().getValue("name");
            Object object = this.getModel().getValue("address");
            HashMap<String, Object> attachment = new HashMap<String, Object>(10);
            attachment.put("name", name);
            attachment.put("address", object);
            attachmentData.add(attachment);
        } else {
            Control attachmentControl = this.getView().getControl(ATTACHMENT_PANEL);
            AttachmentPanel attachmentPanel = (AttachmentPanel)attachmentControl;
            attachmentData = attachmentPanel.getAttachmentData();
        }
        if (CollectionUtils.isEmpty(attachmentData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"UploadDocumentPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (Map map : attachmentData) {
            String[] split;
            String extend;
            String name = String.valueOf(map.get("name"));
            if (!HYPERLINK.equals(type) && "log".contains(extend = (split = name.split("\\."))[split.length - 1])) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a\u201c%s\u201d\u7684\u6587\u4ef6\u3002", (String)"UploadDocumentPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extend));
                return;
            }
            if (name.toCharArray().length <= 128) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u201c%s\u201d\u592a\u957f\u3002", (String)"UploadDocumentPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
            return;
        }
        this.saveUploadData(attachmentData, type);
    }

    private boolean checkFileExist(List<Map<String, Object>> attachmentData, boolean isCover, Object type) {
        DynamicObjectCollection load;
        StringBuffer dimFilterBuffer;
        boolean hasDimFilter;
        long catalogid;
        boolean isRepeat;
        List names = attachmentData.stream().map(v -> String.valueOf(v.get("name"))).collect(Collectors.toList());
        long count = names.stream().distinct().count();
        boolean bl = isRepeat = count < (long)names.size();
        if (isRepeat) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u6587\u4ef6\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u6587\u4ef6\u518d\u4e0a\u4f20\u3002", (String)"UploadDocumentPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelid));
        String qfType = HYPERLINK.equals(type) ? HYPERLINK : FILE;
        QFilter qf = new QFilter("model", "=", (Object)modelid).and("name", "in", names).and("type", "=", (Object)qfType);
        if (!admin && isCover) {
            qf.and("id", "in", DocumentUtils.getPermIds(modelid, DataTypeEnum.NO, DataTypeEnum.READ));
        }
        if (!FILE.equals(String.valueOf(catalogid = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(CATALOG_ID)))) || QueryServiceHelper.exists((String)DOC_ADD, (Object)catalogid)) {
            qf.and("parentid", "=", (Object)catalogid);
        }
        boolean bl2 = hasDimFilter = (dimFilterBuffer = DocumentUtils.getDimFilterBuffer(this.getModel())).length() > 0;
        if (hasDimFilter) {
            qf.and("dims", "=", (Object)dimFilterBuffer.toString());
        }
        if ((load = QueryServiceHelper.query((String)DOC_ADD, (String)"id,name", (QFilter[])new QFilter[]{qf})) != null && load.size() == 0) {
            return false;
        }
        if (load != null) {
            String nameList = load.stream().map(v -> v.getString("name")).distinct().collect(Collectors.joining(","));
            if (!admin && isCover) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u65e0\u6743\u9650\u6216\u53ea\u8bfb\u6743\u9650\u7684\u6587\u4ef6\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\u3002", (String)"UploadDocumentPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), nameList));
                return true;
            }
            if (!isCover) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"UploadDocumentPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), nameList));
                return true;
            }
        }
        return false;
    }

    private void saveUploadData(List<Map<String, Object>> attachmentData, Object type) {
        boolean cover = this.getModel().getDataEntity().getBoolean("cover");
        if (!cover && this.checkFileExist(attachmentData, cover, type)) {
            return;
        }
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        Object[] documents = new DynamicObject[attachmentData.size()];
        StringBuffer dimFilterBuffer = DocumentUtils.getDimFilterBuffer(this.getModel());
        boolean hasDimFilter = dimFilterBuffer.length() > 0;
        int i = 0;
        for (Map<String, Object> attachment : attachmentData) {
            if (cover) {
                DynamicObjectCollection load;
                long catalogid;
                DynamicObject parent;
                boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelid));
                String typeQf = HYPERLINK.equals(type) ? HYPERLINK : FILE;
                QFilter qf = new QFilter("model", "=", (Object)modelid).and("name", "=", attachment.get("name")).and("type", "=", (Object)typeQf);
                if (!admin) {
                    qf.and("id", "not in", DocumentUtils.getPermIds(modelid, DataTypeEnum.NO, DataTypeEnum.READ));
                }
                if ((parent = FILE.equals(String.valueOf(catalogid = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(CATALOG_ID)))) ? null : QueryServiceHelper.queryOne((String)DOC_ADD, (String)"id", (QFilter[])this.getIdQfilter(catalogid).toArray())) != null) {
                    qf.and("parentid", "=", (Object)parent.getLong("id"));
                }
                if (hasDimFilter) {
                    qf.and("dims", "=", (Object)dimFilterBuffer.toString());
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(load = QueryServiceHelper.query((String)DOC_ADD, (String)"id,model,name,dims", (QFilter[])new QFilter[]{qf})))) {
                    for (DynamicObject dynamicObject : load) {
                        String dims = dynamicObject.getString("dims");
                        if ((!hasDimFilter || !StringUtils.isNotEmpty((String)dims)) && (hasDimFilter || !StringUtils.isEmpty((String)dims))) continue;
                        BusinessDataWriter.delete((String)DOC_ADD, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getLong("id"))});
                    }
                } else if (this.checkFileExist(attachmentData, cover, type)) {
                    return;
                }
            }
            DynamicObject document = BusinessDataServiceHelper.newDynamicObject((String)DOC_ADD);
            long id = DBServiceHelper.genGlobalLongId();
            document.set("id", (Object)id);
            document.set("dims", (Object)dimFilterBuffer.toString());
            document.set("number", (Object)("doc" + id));
            if (HYPERLINK.equals(type)) {
                this.assemForHyperLink(document, attachment);
            } else {
                this.assemForUpload(document, attachment);
            }
            DimensionServiceHelper.initObject4BaseInfo((DynamicObject)document);
            documents[i] = document;
            ++i;
        }
        BusinessDataWriter.save((IDataEntityType)documents[0].getDataEntityType(), (Object[])documents);
        for (Object document : documents) {
            PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (String)DOC_ADD, (Long)document.getLong("id"), (Object)this.getFormCustomParam("KEY_MODEL_ID"), (OperationStatus)OperationStatus.ADDNEW);
        }
        List names = Arrays.stream(documents).map(e -> e.getString("name")).collect(Collectors.toList());
        if (names.size() > 0) {
            String name = String.join((CharSequence)";", names);
            this.sendMsg(name);
            String opName = ResManager.loadKDString((String)"\u6587\u6863\u4e0a\u4f20", (String)"UploadDocumentPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String opDescribe = String.format(ResManager.loadKDString((String)"%s \u6587\u6863\u4e0a\u4f20\u6210\u529f", (String)"UploadDocumentPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name);
            OperationLogUtil.writeOperationLog((String)opName, (String)opDescribe, (Long)modelid, (String)DOC_ADD);
            this.getView().returnDataToParent((Object)true);
        }
        this.getView().close();
    }

    private void sendMsg(String msg) {
        if (this.getPageCache().get("userId") == null) {
            return;
        }
        List userIds = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("userId"));
        String userName = this.getPageCache().get("userName");
        String groupName = this.getPageCache().get("groupname");
        String content = String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\uff1a%1s\uff0c\u7528\u6237\uff1a%2s\uff0c\u4e0a\u4f20\u4e86\u201c%3s\u201d\u540d\u79f0\u7684\u6587\u4ef6\u3002", (String)"UploadDocumentPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), groupName, userName, msg);
        if (userIds.size() > 0) {
            MessageBcmServiceHelper.sendSystemMessage((String)ResManager.loadKDString((String)"\u6587\u6863\u4e0a\u4f20\u6210\u529f\u3002", (String)"UploadDocumentPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)content, (List)userIds, null);
        }
    }

    private void assemForAdd(DynamicObject document) {
        long id = DBServiceHelper.genGlobalLongId();
        document.set("id", (Object)id);
        document.set("name", this.getModel().getValue("name"));
        document.set("description", this.getModel().getValue("description"));
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        document.set("model", (Object)modelid);
        document.set("type", (Object)1);
        document.set("number", (Object)("doc" + id));
        this.relateToParent(document);
    }

    private void assemForUpload(DynamicObject document, Map<String, Object> attachment) {
        String tempUrl = String.valueOf(attachment.get("url"));
        String name = String.valueOf(attachment.get("name"));
        String url = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)"bcm", (String)DOC_ADD, (Object)document.getLong("id"), (String)name);
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)DOC_ADD);
        dy.set("createtime", (Object)TimeServiceHelper.now());
        document.set("name", (Object)name);
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        document.set("model", (Object)modelid);
        document.set("url", (Object)url);
        document.set("description", attachment.get("description"));
        document.set("type", (Object)0);
        this.saveAttachmentData(attachment, document.get("id"), url);
        this.relateToParent(document);
    }

    private void saveAttachmentData(Map<String, Object> attachment, Object id, String url) {
        int lastIndexOf;
        String nameStr;
        DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        dynObj.set("fBillType", (Object)"bcm_document");
        dynObj.set("fnumber", attachment.get("uid"));
        dynObj.set("fInterID", id);
        dynObj.set("fFileId", (Object)url);
        Object name = attachment.get("name");
        dynObj.set("fAttachmentName", name);
        String extname = "";
        if (name != null && StringUtils.isNotEmpty((String)(nameStr = name.toString())) && (lastIndexOf = nameStr.lastIndexOf(".")) != -1) {
            extname = nameStr.substring(lastIndexOf + 1, nameStr.length());
        }
        dynObj.set("fExtName", (Object)extname);
        dynObj.set("fAttachmentSize", attachment.get("size"));
        dynObj.set("FBillStatus", (Object)"A");
        dynObj.set("fCreateMen_Id", attachment.get("creator"));
        dynObj.set("fCreateTime", attachment.get("createdate"));
        dynObj.set("fModifyMen_Id", attachment.get("creator"));
        dynObj.set("fModifyTime", attachment.get("lastModified"));
        dynObj.set("fattachmentpanel", (Object)"attachmentpanelap");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    private void assemForHyperLink(DynamicObject document, Map<String, Object> attachment) {
        String address = String.valueOf(attachment.get("address"));
        String name = String.valueOf(attachment.get("name"));
        document.set("name", (Object)name);
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        document.set("model", (Object)modelid);
        document.set("url", (Object)address);
        document.set("description", attachment.get("description"));
        document.set("type", (Object)2);
        this.relateToParent(document);
    }

    private void relateToParent(DynamicObject document) {
        DynamicObjectCollection load;
        long catalogid = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(CATALOG_ID));
        DynamicObject parent = FILE.equals(String.valueOf(catalogid)) ? null : QueryServiceHelper.queryOne((String)DOC_ADD, (String)"id,level", (QFilter[])this.getIdQfilter(catalogid).toArray());
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (null != parent) {
            document.set("level", (Object)(parent.getLong("level") + 1L));
            document.set("parentid", (Object)parent.getLong("id"));
            load = QueryServiceHelper.query((String)DOC_ADD, (String)"id,name,fseq", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)parent.getLong("id")), new QFilter("model", "=", (Object)modelid)}, (String)"fseq DESC", (int)1);
        } else {
            document.set("level", (Object)1);
            document.set("parentid", (Object)0);
            load = QueryServiceHelper.query((String)DOC_ADD, (String)"id,name,fseq", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)0), new QFilter("model", "=", (Object)modelid)}, (String)"fseq DESC", (int)1);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)load)) {
            document.set("fseq", (Object)1);
        } else {
            document.set("fseq", (Object)(((DynamicObject)load.get(0)).getInt("fseq") + 1));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() == MessageBoxResult.Yes && "btn_confirm".equals(evt.getCallBackId())) {
            Control attachmentControl = this.getView().getControl(ATTACHMENT_PANEL);
            AttachmentPanel panel = (AttachmentPanel)attachmentControl;
            List list = panel.getAttachmentData();
        }
    }
}

