/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.guidemenu;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.guidemenu.GuideTreeMenu;
import kd.fi.bcm.formplugin.guidemenu.OpenPage;
import kd.fi.bcm.formplugin.guidemenu.PageManager;
import kd.fi.bcm.spread.common.util.StringUtil;

abstract class AbstractPageManager
implements PageManager {
    protected GuideTreeMenu.GuideTreeMenuNode guideMenu;
    protected IFormView fromView;
    protected Map<String, Long> filterMap;
    protected String initFlag = "";
    protected String appId = "11H66HLOX4IC";
    protected String appNumber = "cm";

    public AbstractPageManager(GuideTreeMenu.GuideTreeMenuNode guideMenu, IFormView fromView, Map<String, Long> filterMap) {
        this.guideMenu = guideMenu;
        this.fromView = fromView;
        this.filterMap = filterMap;
        this.initFlag = filterMap.get("initflag").toString();
        if (guideMenu != null && StringUtil.isEmptyString((String)guideMenu.getAppId())) {
            this.appId = guideMenu.getAppId();
            this.appNumber = guideMenu.getAppNumber();
        }
    }

    protected void setMainPage() {
        FormShowParameter formShowParameter = this.fromView.getFormShowParameter();
        SessionManager current = SessionManager.getCurrent();
        current.putMainPageId(formShowParameter.getRootPageId(), this.fromView.getPageId());
        current.putMainPageId(this.fromView.getPageId(), this.fromView.getPageId());
        String pageId = this.appId + this.fromView.getPageId();
        PageCache pageCache = new PageCache(pageId);
        pageCache.put(FormShowParameter.class.getSimpleName(), FormShowParameter.toJsonString((FormShowParameter)formShowParameter));
        pageId = this.appNumber + this.fromView.getPageId();
        pageCache = new PageCache(pageId);
        pageCache.put(FormShowParameter.class.getSimpleName(), FormShowParameter.toJsonString((FormShowParameter)formShowParameter));
    }

    protected Map<String, Object> getSimpleCommonInfo() {
        IDataModel dataModel = this.fromView.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        HashMap<String, Object> commonInfo = new HashMap<String, Object>();
        commonInfo.put("year", this.filterMap.get("year"));
        commonInfo.put("period", this.filterMap.get("period"));
        commonInfo.put("currency", this.filterMap.get("currency"));
        commonInfo.put("scenario", this.filterMap.get("scenario"));
        commonInfo.put("cslscheme", this.filterMap.get("cslscheme"));
        commonInfo.put("model", dataEntity.getDynamicObject("model").getLong("id"));
        commonInfo.put("template", this.guideMenu.getTemplataId());
        commonInfo.put("menu", this.guideMenu.get_Id());
        if (dataEntity.get("entity") != null) {
            commonInfo.put("entity", this.filterMap.get("entity"));
        }
        if (this.guideMenu.getCustomParam() != null) {
            commonInfo.put("cus", this.guideMenu.getCustomParam());
        }
        return commonInfo;
    }

    protected String getMenuPageId() {
        return GuidePageUtils.getMenuPageId(this.guideMenu, this.fromView, this.initFlag);
    }

    @Override
    public void openTab(Map<String, Long> filterMap) {
        IFormView view;
        String formId = "bcm_guidechildpage";
        IFormView mainPageView = view = this.fromView;
        String pageId = this.getTabPageId();
        IFormView childView = mainPageView.getView(pageId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("filterMap", (Object)ObjectSerialUtil.toByteSerialized(filterMap));
        if (childView == null) {
            formShowParameter.setFormId(formId);
            formShowParameter.setPageId(pageId);
            this.handleOpenTabParameter(formShowParameter);
            formShowParameter.setCustomParam("menu", (Object)ObjectSerialUtil.toByteSerialized((Object)this.guideMenu));
            formShowParameter.setCustomParam("from_guide_page", (Object)true);
            formShowParameter.setCustomParam("common_guide_page", (Object)ObjectSerialUtil.toByteSerialized(this.getSimpleCommonInfo()));
            formShowParameter.setRootPageId(pageId);
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            openStyle.setShowType(ShowType.NewTabPage);
            openStyle.setTargetKey("_submaintab_");
            this.fromView.showForm(formShowParameter);
        } else {
            childView.activate();
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
            pluginProxy.getPlugIns().forEach(e -> {
                if (OpenPage.class.isAssignableFrom(e.getClass())) {
                    ((OpenPage)OpenPage.class.cast(e)).openPage(this.guideMenu, filterMap);
                }
            });
            view.sendFormAction(childView);
        }
    }

    public String getTabPageId() {
        return GuidePageUtils.getTabPageId(this.guideMenu, this.fromView, this.initFlag, true);
    }

    protected void handleOpenTabParameter(FormShowParameter formShowParameter) {
        formShowParameter.setCaption(this.guideMenu.get_Text());
    }
}

