/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.guidemenu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class GuideBasePlugin
extends AbstractBaseFormPlugin {
    protected static final String userSing = "guideMenu";
    public static final List<String> filters = Collections.unmodifiableList(Arrays.asList("model", "scenario", "year", "period", "currency", "entity", "cslscheme"));

    @Override
    public void initialize() {
        super.initialize();
        this.fromCommonToReportF7(this.isReportF7());
    }

    @Override
    protected boolean isGuideMenu() {
        return true;
    }

    public boolean isReportF7() {
        return false;
    }

    private void fromCommonToReportF7(boolean isReportF7) {
        if (isReportF7) {
            HashMap map = new HashMap();
            this.asMapF7toType(filters.subList(1, filters.size() - 1), SingleF7TypeEnum.COMMON, map);
            this.initSingleMemberF7(map);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_switch");
        for (String filter : filters) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(filter);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    protected Map<String, Long> getFilterMap() {
        Map filterMap = (Map)this.getView().getFormShowParameter().getCustomParam("filterMap");
        if (filterMap == null) {
            ApplicationTypeEnum application = ModelUtil.queryApp(this.getView());
            DynamicObject userSelect = UserSelectUtil.getUserSelectDynamicObject(StringUtils.join((Object[])filters.toArray(), (String)","), application);
            return GuidePageUtils.getUserSelectMap(userSelect);
        }
        return filterMap;
    }

    protected boolean loadCommonInfo(Map<String, Long> filterMaps) {
        return GuidePageUtils.loadFilterMapF7(this.getView(), filterMaps, true);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        this.click(((Control)evt.getSource()).getKey());
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.click(evt.getItemKey().toLowerCase(Locale.ENGLISH));
    }

    protected void click(String key) {
        switch (key) {
            case "btn_switch": {
                Map<String, Long> filterMap = GuidePageUtils.getFilterMap(this.getView(), false);
                this.showGuideMenuInitialize(filterMap);
            }
        }
    }

    protected void showGuideMenuInitialize(Map<String, Long> filterMap) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_guideinitialize");
        showParameter.setCustomParam("filterMap", filterMap);
        showParameter.setAppId("cm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack close = new CloseCallBack((IFormPlugin)this, userSing);
        showParameter.setCloseCallBack(close);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtil.equals((String)closedCallBackEvent.getActionId(), (String)userSing)) {
            Map filterMap = (Map)closedCallBackEvent.getReturnData();
            if (filterMap == null) {
                return;
            }
            this.createGuideMenuPage(filterMap);
        }
    }

    public void createGuideMenuPage(Map<String, Long> filterMap) {
        this.openNewPage(filterMap);
    }

    private void openNewPage(Map<String, Long> filterMap) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_guideoppage");
        showParameter.setCustomParam("filterMap", filterMap);
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(showParameter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtil.equals((String)key, (String)"model")) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            for (int i = 1; i < filters.size(); ++i) {
                this.getModel().setValue(filters.get(i), null);
            }
            this.getPageCache().put("KEY_MODEL_ID", newValue == null ? null : ((DynamicObject)newValue).get("id") + "");
        } else if (StringUtil.equals((String)key, (String)"scenario")) {
            this.getModel().setValue("period", null);
        } else if (StringUtil.equals((String)key, (String)"cslscheme")) {
            this.getModel().setValue("entity", null);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7Key;
        super.beforeF7Select(beforeF7SelectEvent);
        switch (f7Key = ((Control)beforeF7SelectEvent.getSource()).getKey()) {
            case "model": {
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("noNeedDefaultQFilter", (Object)true);
                Set<Long> modelIds = this.getMenuModel();
                QFBuilder qfBuilder = new QFBuilder("modeltype", "in", (Object)new String[]{"1", "3"});
                qfBuilder.and(new QFilter("id", "in", modelIds));
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qfBuilder.toList(), null));
                break;
            }
            case "entity": {
                DynamicObject cslScheme = (DynamicObject)this.getValue("cslscheme");
                if (cslScheme == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"GuideBasePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (!(beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter)) break;
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                qFilterList.add(new QFilter("cslscheme", "=", cslScheme.get("id")));
                qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                break;
            }
            default: {
                this.checkRecordField(f7Key);
            }
        }
    }

    private Set<Long> getMenuModel() {
        HashSet<Long> modelIds = new HashSet<Long>();
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_guidemenu", (String)"model.id", (QFilter[])new QFilter("1", "=", (Object)1).toArray());
        map.forEach((key, value) -> modelIds.add(value.getLong("model.id")));
        Set permIds = MemberPermHelper.getLimitedModelListByUser();
        Set<String> groups = this.getUserAndGroups();
        QFilter qFilter = new QFilter("guidepermentry.eusers", "=", (Object)this.getUserId());
        if (CollectionUtils.isNotEmpty(groups)) {
            qFilter.or("guidepermentry.eusers", "in", (Object)ConvertUtil.convertListToLong(groups));
        }
        DynamicObjectCollection guideMenus = QueryServiceHelper.query((String)"bcm_guidemenuperm", (String)"guidemenuids", (QFilter[])qFilter.toArray());
        Set dis = guideMenus.stream().map(dyn -> dyn.getLong("guidemenuids")).collect(Collectors.toSet());
        HashSet disModelIds = new HashSet();
        map.forEach((key, value) -> {
            if (dis.contains(key)) {
                disModelIds.add(value.getLong("model.id"));
            }
        });
        if (CollectionUtils.isNotEmpty(disModelIds)) {
            this.getPageCache().remove("dis");
            this.getPageCache().put("dis", ObjectSerialUtil.toJson(disModelIds));
            permIds.addAll(disModelIds);
        }
        modelIds.retainAll(permIds);
        return modelIds;
    }

    private Set<String> getUserAndGroups() {
        String select = "usergroup.id";
        QFilter qf = new QFilter("user", "=", (Object)LongUtil.toLong((Object)this.getUserId()));
        Map groupData = BusinessDataServiceHelper.loadFromCache((String)"bos_usergroupstaff", (String)select, (QFilter[])qf.toArray());
        HashSet groups = new HashSet(16);
        groupData.forEach((k, v) -> groups.add(v.getString("usergroup.id")));
        return PermClassEntityHelper.getRelGroupIds(groups);
    }

    @Override
    protected void initBasedataEditSingleMemberF7(String f7Key, BasedataEditSingleMemberF7 f7) {
        if ("entity".equals(f7Key) && this.getValue("cslscheme") != null) {
            f7.setCustomData((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("cslscheme", ((DynamicObject)GuideBasePlugin.this.getValue("cslscheme")).getLong("id"));
                    this.put("from_guide_page", GuideBasePlugin.this.getView().getPageId());
                }
            });
        }
    }

    private void checkRecordField(String key) {
        DynamicObject scenario;
        long modelId;
        if (!"model".equals(key) && (modelId = ((Long)this.getValue("model_id")).longValue()) == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"GuideBasePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if ("period".equals(key) && (scenario = (DynamicObject)this.getValue("scenario")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"GuideBasePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

