/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.guidemenu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class GuideMenuEditPlugin
extends AbstractBaseFormPlugin {
    private static String TEMPLATECALOG = "classification";
    private static String jichuFontIcon = "kdfont kdfont-jichuziliao";

    private static OpNameMultiLangEnumBridge getOperationSave() {
        return new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "GuideMenuEditPlugin_0", "fi-bcm-formplugin", "save");
    }

    private static final String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"GuideMenuEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static final String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"GuideMenuEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private void refreshTemplateCalog() {
        QFilter filterModel = new QFilter("model", "=", (Object)this.getModelId());
        QFilter typeFilter = new QFilter("catalogtype", "in", (Object)Character.valueOf(TemplateCatalogTypeEnum.TEMPLATECATALOG.getType()));
        DynamicObjectCollection doc = ReportListUtil.getCollection("bcm_templatecatalog", new QFilter[]{filterModel, typeFilter}, "name,parent");
        ComboEdit dbCombo = (ComboEdit)this.getView().getControl(TEMPLATECALOG);
        ArrayList dbInstenceItem = new ArrayList();
        HashMap templateCalogs = new HashMap();
        doc.stream().forEach(p -> {
            dbInstenceItem.add(new ComboItem(new LocaleString(p.getString("name")), p.getString("id")));
            ArrayList<String> templateCalog = templateCalogs.get(p.getString("parent")) != null ? (List)templateCalogs.get(p.getString("parent")) : new ArrayList<String>();
            templateCalog.add(p.getString("id"));
            templateCalogs.put(p.getString("parent"), templateCalog);
        });
        this.getPageCache().put(TEMPLATECALOG, ObjectSerialUtil.toByteSerialized(templateCalogs));
        dbCombo.setComboItems(dbInstenceItem);
    }

    private Map<String, List<String>> getTemplateCalogs() {
        String serial = this.getPageCache().get(TEMPLATECALOG);
        if (StringUtil.isEmptyString((String)serial)) {
            return new HashMap<String, List<String>>();
        }
        return (Map)ObjectSerialUtil.deSerializedBytes((String)serial);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("advcontoolbarap");
        this.addBeforeF7SelectListener("parent");
        this.addClickListeners("vectorap");
    }

    private void addBeforeF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private boolean checkClassificationPerm() {
        DynamicObject menu = (DynamicObject)this.getValue("menu");
        List<String> perms = Arrays.asList("bcm_report_list", "bcm_report_search", "bcm_cslreport_list", "bcm_cwpreport_list");
        return menu != null && perms.contains(menu.getString("formid"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if ("parent".equals(key)) {
            QFilter filterModel = new QFilter("model", "=", (Object)this.getModelId());
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(filterModel);
            qFilterList.add(new QFilter("id", "!=", this.getView().getFormShowParameter().getCustomParam("id")));
            qFilterList.add(new QFilter("menu", "=", (Object)""));
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_reset".equals(evt.getItemKey())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u91cd\u7f6e\u4e3a\u5df2\u9009\u5206\u7c7b\u7684\u5185\u5bb9\uff1f", (String)"GuideMenuEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("reset", (IFormPlugin)this));
        } else if ("remove".equals(evt.getItemKey())) {
            int[] rows = this.getSelectRow();
            if (rows != null) {
                this.deleteEntity(rows);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"GuideMenuEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void deleteEntity(int[] rows) {
        ArrayList<Long> templateColls = new ArrayList<Long>(rows.length);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (int row : rows) {
            templateColls.add((Long)((DynamicObject)entryentity.get(row)).getDynamicObject("open").get("id"));
        }
        String delete = this.getView().getPageCache().get("delete");
        if (delete != null) {
            List indelete = (List)this.deSerializedBytes(delete);
            indelete.addAll(templateColls);
            this.getView().getPageCache().put("delete", this.toByteSerialized(indelete));
        } else {
            this.getView().getPageCache().put("delete", this.toByteSerialized(templateColls));
        }
        this.getModel().deleteEntryRows("entryentity", rows);
    }

    private int[] getSelectRow() {
        EntryGrid entryentityfi = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryentityfi.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            return selectRows;
        }
        return null;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("vectorap".equals(key)) {
            FormShowParameter bsp = new FormShowParameter();
            bsp.getOpenStyle().setShowType(ShowType.Modal);
            bsp.setFormId("ide_vectorlist");
            bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "vectorapCallBack"));
            this.getView().showForm(bsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBackID = closedCallBackEvent.getActionId();
        IDataModel model = this.getModel();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "vectorapCallBack".equalsIgnoreCase(callBackID)) {
            Vector vector = (Vector)this.getControl("vectorap");
            Map map = (Map)returnData;
            if (StringUtils.isBlank((String)((String)map.get("value")))) {
                vector.setFontClass(jichuFontIcon);
                model.setValue("iconurl", (Object)"");
            } else {
                vector.setFontClass((String)map.get("value"));
                model.setValue("iconurl", (Object)((String)map.get("value")));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.refreshTemplateCalog();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object parent = this.getValue("parent");
        this.checkParent(parent == null ? 0L : ((DynamicObject)parent).getLong("id"));
        this.filltempnumber();
        this.getView().setVisible(Boolean.valueOf(this.checkClassificationPerm()), new String[]{TEMPLATECALOG});
        if (this.checkClassIsReportList()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("classification");
            comboEdit.setMustInput(true);
        }
        Vector vector = (Vector)this.getControl("vectorap");
        vector.setFontClass(this.getModel().getValue("iconurl") == null ? jichuFontIcon : (String)this.getModel().getValue("iconurl"));
    }

    private void filltempnumber() {
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        this.getView().getPageCache().put("entity", this.toByteSerialized(entity));
        ArrayList<Integer> delList = new ArrayList<Integer>();
        int length = entity.size();
        for (int i2 = 0; i2 < length; ++i2) {
            DynamicObject open = ((DynamicObject)entity.get(i2)).getDynamicObject("open");
            if (((DynamicObject)entity.get(i2)).getBoolean("isdelete")) {
                delList.add(i2);
                continue;
            }
            if (open != null) {
                model.setValue("opennumber", (Object)open.getString("number"), i2);
                continue;
            }
            delList.add(i2);
        }
        int[] arrays = delList.stream().filter(integer -> integer != null).mapToInt(i -> i).toArray();
        this.getModel().deleteEntryRows("entryentity", arrays);
        model.endInit();
        this.getView().updateView("entryentity");
        model.setDataChanged(false);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshTemplateCalog();
        if (this.getView().getFormShowParameter().getCustomParam("pid") != null) {
            long pid = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("pid") + "");
            this.getModel().setValue("parent", (Object)BusinessDataServiceHelper.loadSingle((Object)pid, (String)"bcm_guidemenu"));
        }
        this.getView().setVisible(Boolean.valueOf(this.checkClassificationPerm()), new String[]{TEMPLATECALOG});
    }

    private boolean checkParent(long id) {
        boolean isShow = false;
        if (id != 0L) {
            DynamicObject count = QueryServiceHelper.queryOne((String)"bcm_guidemenu", (String)"entryentity.businesstype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            isShow = count != null && !StringUtil.isEmptyString((String)count.getString("entryentity.businesstype"));
        }
        this.getView().setEnable(Boolean.valueOf(!isShow), new String[]{"weavereport", "queryreport", "cwpreport", "mergereport"});
        return isShow;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "menu": {
                boolean hasClassificationPerm = this.checkClassificationPerm();
                this.getView().setVisible(Boolean.valueOf(hasClassificationPerm), new String[]{"classification"});
                this.setValue("classification", null);
                ComboEdit comboEdit = (ComboEdit)this.getControl("classification");
                if (this.checkClassIsReportList()) {
                    comboEdit.setMustInput(true);
                    break;
                }
                comboEdit.setMustInput(false);
                break;
            }
            case "classification": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8986\u76d6\u4e0b\u65b9\u8868\u683c\u7684\u5185\u5bb9\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"GuideMenuEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(TEMPLATECALOG, (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "reset": {
                if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.refreshChildMenus();
                }
            }
            case "classification": {
                if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.refreshChildMenus();
                break;
            }
        }
    }

    private void refreshChildMenus() {
        this.getModel().deleteEntryData("entryentity");
        DynamicObject menu = (DynamicObject)this.getValue("menu");
        Object classification = this.getValue("classification");
        if (menu != null && classification != null && !StringUtil.isEmptyString((String)classification.toString())) {
            DynamicObjectCollection templateColls = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,versionnumber,number", (QFilter[])this.getQFList(menu.getString("formid"), classification).toArray(new QFilter[0]));
            this.fillDataToEntity(this.getBusinessType(), templateColls);
        }
    }

    private void fillDataToEntity(String businesstype, DynamicObjectCollection templateColls) {
        IDataModel model = this.getModel();
        for (DynamicObject templateColl : templateColls) {
            int index = model.createNewEntryRow("entryentity");
            model.setValue("businesstype", (Object)businesstype, index);
            model.setValue("opentype", (Object)"bcm_templateentity", index);
            model.setValue("open", templateColl.get("id"), index);
            model.setValue("opennumber", model.getEntryRowEntity("entryentity", index).getDynamicObject("open").get("number"), index);
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.setPageIndex(1);
        this.getView().getPageCache().put("entity", this.toByteSerialized(this.getModel().getEntryEntity("entryentity")));
        this.getView().getPageCache().remove("delete");
    }

    private List<QFilter> getQFList(String formid, Object menu) {
        this.refreshTemplateCalog();
        Map<String, List<String>> map = this.getTemplateCalogs();
        ArrayList<Long> templatecatalogRange = new ArrayList<Long>();
        this.getAllChildren(menu, map, templatecatalogRange);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)this.getModelId());
        qfBuilder.add("templatecatalog", "in", templatecatalogRange);
        qfBuilder.add("versionnumber", "=", (Object)1);
        String businessType = "";
        switch (formid) {
            case "bcm_cslreport_list": {
                businessType = "4";
                break;
            }
            case "bcm_report_list": {
                qfBuilder.add("usage", "=", (Object)"1");
                businessType = "1";
                break;
            }
            case "bcm_report_search": {
                qfBuilder.add("templatetype", "!=", (Object)"2");
                businessType = "2";
                break;
            }
        }
        this.setBusinessType(businessType);
        return qfBuilder.toList();
    }

    private void getAllChildren(Object menu, Map<String, List<String>> map, List<Long> templatecatalogRange) {
        if (menu == null || "null".equals(menu + "") || "".equals(menu + "")) {
            return;
        }
        templatecatalogRange.add(LongUtil.toLong((Object)menu));
        List<String> children = map.get(menu);
        if (children != null) {
            for (String child : children) {
                this.getAllChildren(child, map, templatecatalogRange);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            String errormesg = this.checkToSaveData();
            if (!StringUtil.isEmptyString((String)errormesg)) {
                this.getView().showTipNotification(errormesg);
                args.setCancel(true);
                return;
            }
            IDataModel dataModel = this.getModel();
            if (this.isAddNew()) {
                long modelId = this.getModelId();
                dataModel.setValue("model", (Object)modelId);
                dataModel.setValue("creator", (Object)RequestContext.get().getUserId());
                dataModel.setValue("createtime", (Object)TimeServiceHelper.now());
                DataSet fseq = QueryServiceHelper.queryDataSet((String)"getMaxSerial", (String)"bcm_guidemenu", (String)"serial,parent.serial", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}, (String)"serial desc", (int)1);
                int fseqNum = fseq.hasNext() ? fseq.next().getInteger("serial") : 0;
                dataModel.setValue("serial", (Object)(++fseqNum));
                dataModel.setValue("number", (Object)CodeRuleUtil.getCodeRuleNumber("bcm_analyticssoluentry", "createtime"));
            } else {
                dataModel.setValue("modifier", (Object)RequestContext.get().getUserId());
                dataModel.setValue("modifytime", (Object)TimeServiceHelper.now());
            }
            DynamicObject menu = (DynamicObject)this.getValue("menu");
            Object classification = this.getValue("classification");
            if (menu != null && classification != null && !StringUtil.isEmptyString((String)classification.toString())) {
                String entity = this.getView().getPageCache().get("entity");
                String o1 = this.getView().getPageCache().get("delete");
                List delete = null;
                DynamicObjectCollection tempcoloction = null;
                if (o1 != null) {
                    delete = (List)this.deSerializedBytes(o1);
                }
                if (entity != null) {
                    tempcoloction = (DynamicObjectCollection)this.deSerializedBytes(entity);
                }
                if (delete != null && delete.size() > 0 && tempcoloction != null) {
                    for (DynamicObject obj : tempcoloction) {
                        if (!delete.contains(obj.getDynamicObject("open").get("id"))) continue;
                        obj.set("isdelete", (Object)true);
                    }
                }
                this.fillEntity(tempcoloction);
            }
            this.initDefaultValue(TEMPLATECALOG, -1);
            this.initDefaultValue("iconurl", jichuFontIcon);
        }
    }

    private void fillEntity(DynamicObjectCollection tempcoloction) {
        this.getModel().deleteEntryData("entryentity");
        IDataModel model = this.getModel();
        if (tempcoloction != null) {
            for (DynamicObject templateColl : tempcoloction) {
                if (templateColl.getDynamicObject("open") == null) continue;
                int index = model.createNewEntryRow("entryentity");
                model.setValue("businesstype", templateColl.get("businesstype"), index);
                model.setValue("opentype", (Object)"bcm_templateentity", index);
                model.setValue("open", templateColl.getDynamicObject("open").get("id"), index);
                model.setValue("opennumber", templateColl.get("opennumber"), index);
                model.setValue("isdelete", (Object)templateColl.getBoolean("isdelete"), index);
            }
        }
    }

    private void initDefaultValue(String key, Object value) {
        IDataModel dataModel = this.getModel();
        if (dataModel.getValue(key) == null || StringUtil.isEmptyString((String)("" + dataModel.getValue(key)))) {
            dataModel.beginInit();
            dataModel.setValue(key, value);
            dataModel.endInit();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Save) {
            if (this.isAddNew()) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObject parent = dataEntity.getDynamicObject("parent");
                DynamicObject date = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"bcm_guidemenuperm");
                DynamicObjectCollection dynamicObjectCollection = date.getDynamicObjectCollection("guidepermentry");
                if (!Objects.isNull(parent)) {
                    DynamicObject loadSingle = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (String)"bcm_guidemenuperm");
                    DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)loadSingle, (boolean)false, (boolean)true);
                    dynamicObjectCollection.addAll((Collection)clone.getDynamicObjectCollection("guidepermentry"));
                } else {
                    DynamicObject perm = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
                    perm.set("etype", (Object)"bos_user");
                    perm.set("eusers", (Object)RequestContext.get().getUserId());
                    dynamicObjectCollection.add((Object)perm);
                    date.set("guidepermentry", (Object)dynamicObjectCollection);
                }
                SaveServiceHelper.save((IDataEntityType)date.getDynamicObjectType(), (Object[])new Object[]{date});
                this.writeOperationLog(GuideMenuEditPlugin.getOperationSave(), GuideMenuEditPlugin.getOperationStstusSuccess());
            }
            this.getView().returnDataToParent((Object)afterDoOperationEventArgs.getOperationResult().getSuccessPkIds());
            this.getView().close();
        }
    }

    private String checkToSaveData() {
        String classification;
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        if (name.isEmpty() || StringUtil.isEmptyString((String)name.getLocaleValue())) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u672a\u586b\u5199\u3002", (String)"GuideMenuEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (this.checkClassIsReportList() && ((classification = String.valueOf(this.getModel().getValue("classification"))).isEmpty() || StringUtil.isEmptyString((String)classification) || "null".equals(classification) || Long.parseLong(classification) == -1L)) {
            return ResManager.loadKDString((String)"\u5206\u7c7b\u672a\u9009\u62e9\u3002", (String)"GuideMenuEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        long parent_id = (Long)this.getModel().getValue("parent_id");
        if (parent_id != 0L) {
            DynamicObject count = QueryServiceHelper.queryOne((String)"bcm_guidemenu", (String)"menu,parent,parent.parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parent_id)});
            if (!StringUtil.equals((String)"0", (String)count.getString("parent")) && !StringUtil.equals((String)"0", (String)count.getString("parent.parent"))) {
                return ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u56db\u7ea7\u83dc\u5355\u3002", (String)"GuideMenuEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            if (!StringUtil.isEmptyString((String)count.getString("menu"))) {
                return ResManager.loadKDString((String)"\u5df2\u7ecf\u914d\u7f6e\u83dc\u5355\u7684\u8282\u70b9\u4e0d\u80fd\u4f5c\u4e3a\u7236\u8282\u70b9\u3002", (String)"GuideMenuEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        if (this.getModel().getValue("menu") != null && LongUtil.toLong((Object)this.getModel().getValue("id")) != 0L && QueryServiceHelper.exists((String)"bcm_guidemenu", (QFilter[])new QFilter[]{new QFilter("parent_id", "=", this.getModel().getValue("id")), new QFilter("model", "=", (Object)this.getModelId())})) {
            return ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u8282\u70b9\u4e0d\u53ef\u8bbe\u7f6e\u83dc\u5355\u3002", (String)"GuideMenuEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private boolean checkClassIsReportList() {
        DynamicObject menu = (DynamicObject)this.getValue("menu");
        List<String> perms = Arrays.asList("bcm_report_list", "bcm_report_search", "bcm_cslreport_list");
        return menu != null && perms.contains(menu.getString("formid"));
    }

    private void setBusinessType(String businesstype) {
        this.getPageCache().remove("businesstype");
        this.getPageCache().put("businesstype", businesstype);
    }

    private String getBusinessType() {
        return this.getPageCache().get("businesstype");
    }

    private boolean isAddNew() {
        long id = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("id") + "");
        return id == 0L;
    }

    @Override
    public long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("model");
    }
}

