/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.guidemenu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.Base39Coder;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class GuideMenuListPlugin
extends AbstractBaseListPlugin
implements TreeNodeQueryListener,
HyperLinkClickListener,
TreeNodeClickListener {
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String MODEL = "model";
    private static final int FIREST = 1;
    private static final int ENTRYTYPE = 2;
    private static final int MENUTYPE = 3;
    private static final String SELECTSTR = "id, name, number, menu.name, parent, modifier, modifytime, creator, createtime,serial,description";
    private static final String WITHENTRY = ", entryentity.open,entryentity.businesstype, entryentity.id, entryentity.seq";
    private static final String KEY_ROWINDEX = "rowIndex";

    private String getOperationDel() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"GuideMenuListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDistribution() {
        return ResManager.loadKDString((String)"\u5206\u914d", (String)"GuideMenuListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationView() {
        return ResManager.loadKDString((String)"\u67e5\u770b", (String)"GuideMenuListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"GuideMenuListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"GuideMenuListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(new ArrayList<String>(), Boolean.TRUE);
        String model = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
        this.getPlugin().getPageCache().put("KEY_MODEL_ID", model);
        if (Objects.isNull(model)) {
            return;
        }
        this.loadEntitymember(true);
        GuidePageUtils.resetGuideMenuBaseInfos();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().updateView(TREEENTRYENTITY);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        this.addClickListeners("name", TREEENTRYENTITY);
        TreeEntryGrid control = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        control.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntry.addCellClickListener((TreeNodeQueryListener)this);
        treeEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                if (evt.getRow() >= 0) {
                    GuideMenuListPlugin.this.getPageCache().put(GuideMenuListPlugin.KEY_ROWINDEX, String.valueOf(evt.getRow()));
                }
            }
        });
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("del".equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
                    ArrayList<String> exids = new ArrayList<String>();
                    if (treeEntry.getExpandNodes() != null) {
                        exids.addAll((List)treeEntry.getExpandNodes());
                    }
                    String row = this.getSelectRow();
                    DynamicObject rowDy = this.getModel().getEntryRowEntity(TREEENTRYENTITY, Integer.parseInt(row));
                    Long entryid = rowDy.getLong("entryid");
                    if (entryid == 0L) {
                        Long menuid = rowDy.getLong("menuid_id");
                        HashSet<Object> primaryKeys = new HashSet<Object>();
                        GuidePageUtils.getAllChildMenus(Collections.singletonList(menuid), primaryKeys);
                        DeleteServiceHelper.delete((String)"bcm_guidemenuperm", (QFilter[])new QFilter("id", "in", primaryKeys).toArray());
                    } else {
                        DynamicObject dy = rowDy.getDynamicObject("menuid");
                        DynamicObjectCollection coll = dy.getDynamicObjectCollection("entryentity");
                        DeleteServiceHelper.delete((IDataEntityType)coll.getDynamicObjectType(), (Object[])new Object[]{entryid});
                    }
                    this.getModel().beginInit();
                    this.loadEntitymember(true);
                    this.getModel().endInit();
                    this.getView().updateView(TREEENTRYENTITY);
                    this.getPageCache().remove(KEY_ROWINDEX);
                    this.extendChilds(exids, treeEntry);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"GuideMenuListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.writeOperationLog(this.getOperationDel(), this.getOperationStstusSuccess());
                }
                catch (Exception e) {
                    h.markRollback();
                    this.writeOperationLog(this.getOperationDel(), this.getOperationStstusFail());
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_moveup": 
            case "btn_movedown": {
                String selectRow = this.getSelectRow();
                if (selectRow != null) {
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, Integer.parseInt(selectRow));
                    if (entryRowEntity == null) break;
                    this.getPageCache().put("moveRow", entryRowEntity.getString("seq") + "|" + entryRowEntity.getString("name"));
                    break;
                }
                this.getPageCache().remove("moveRow");
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String[] split;
        String moveRow;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_new".equals(itemKey)) {
            DynamicObject rowDy;
            Long model = this.getModelId();
            if (model == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"GuideMenuListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_guidemenu");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_guidemenu"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(MODEL, (Object)this.getModelId());
            String row = this.getSelectRow();
            if (!StringUtil.isEmptyString((String)row) && (rowDy = this.getModel().getEntryRowEntity(TREEENTRYENTITY, Integer.parseInt(row))) != null) {
                showParameter.setCustomParam("pid", (Object)rowDy.getLong("menuid_id"));
            }
            showParameter.setCustomParam("id", (Object)0L);
            this.getView().showForm(showParameter);
        } else if ("btn_refresh".equals(itemKey)) {
            this.refreshTreeBill();
        } else if ("btn_delete".equals(itemKey)) {
            String row = this.getSelectRow();
            if (row == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"GuideMenuListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u6570\u636e\u5417\uff1f", (String)"GuideMenuListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del", (IFormPlugin)this));
        } else if ("btn_distribution".equals(itemKey)) {
            DynamicObject dy;
            TreeEntryGrid source = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectRows = source.getSelectRows();
            Long entryid = 0L;
            BaseShowParameter showParameter = new BaseShowParameter();
            if (selectRows.length >= 1 && (dy = this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectRows[0])) != null) {
                entryid = dy.getLong("menuid_id");
                if (entryid == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"GuideMenuListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!QueryServiceHelper.exists((String)"bcm_guidemenu", (Object)entryid)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u9009\u62e9\u975e\u62a5\u8868/\u5de5\u4f5c\u5e95\u7a3f\u8282\u70b9\u6267\u884c\u5206\u914d\u3002", (String)"GuideMenuListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (GuidePageUtils.hasMenuPerm(entryid)) {
                    if (this.getModelId() == 0L) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"GuideMenuListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u83dc\u5355\u7684\u5206\u914d\u6743\u9650\u3002", (String)"GuideMenuListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                showParameter.setPkId((Object)entryid);
            }
            showParameter.setFormId("bcm_guidemenuperm");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_guidemenuperm"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(MODEL, (Object)this.getModelId());
            showParameter.setCustomParam("entryid", (Object)entryid);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("btn_moveup".equals(itemKey)) {
            String[] split2;
            String moveRow2 = this.getPageCache().get("moveRow");
            if (moveRow2 != null && (split2 = moveRow2.split("\\|")).length == 2) {
                String rowIdx = split2[0];
                String name = split2[1];
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, Integer.parseInt(this.getSelectRow()));
                OPDescMultiLangEnumBridge opDes = name.equals(entryRowEntity.getString("name")) && Integer.parseInt(rowIdx) - 1 == entryRowEntity.getInt("seq") ? new OPDescMultiLangEnumBridge("\u201c%1$s\u201d\u4e0a\u79fb\u6210\u529f\u3002", "GuideMenuListPlugin_14", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{name})) : new OPDescMultiLangEnumBridge("\u201c%1$s\u201d\u4e0a\u79fb\u5931\u8d25\u3002", "GuideMenuListPlugin_15", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{name}));
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u4e0a\u79fb", "GuideMenuListPlugin_1", "fi-bcm-formplugin", "up");
                this.writeMultiLangLog(opName, opDes);
            }
        } else if ("btn_movedown".equals(itemKey) && (moveRow = this.getPageCache().get("moveRow")) != null && (split = moveRow.split("\\|")).length == 2) {
            String rowIdx = split[0];
            String name = split[1];
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, Integer.parseInt(this.getSelectRow()));
            if (entryRowEntity != null) {
                OPDescMultiLangEnumBridge opDes = name.equals(entryRowEntity.getString("name")) && Integer.parseInt(rowIdx) + 1 == entryRowEntity.getInt("seq") ? new OPDescMultiLangEnumBridge("\u201c%1$s\u201d\u4e0b\u79fb\u6210\u529f\u3002", "GuideMenuListPlugin_16", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{name})) : new OPDescMultiLangEnumBridge("\u201c%1$s\u201d\u4e0b\u79fb\u5931\u8d25\u3002", "GuideMenuListPlugin_17", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{name}));
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u4e0b\u79fb", "GuideMenuListPlugin_3", "fi-bcm-formplugin", "down");
                this.writeMultiLangLog(opName, opDes);
            }
        }
    }

    private String getSelectRow() {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        int[] selectRows = treeEntry.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            return String.valueOf(treeEntry.getSelectRows()[0]);
        }
        return null;
    }

    private void refreshTreeBill() {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        ArrayList<String> exids = new ArrayList<String>();
        if (treeEntry.getExpandNodes() != null) {
            exids.addAll((List)treeEntry.getExpandNodes());
        }
        this.getModel().beginInit();
        this.loadEntitymember(true);
        this.getModel().endInit();
        this.getView().updateView(TREEENTRYENTITY);
        this.extendChilds(exids, treeEntry);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("bcm_guidemenu".equals(actionId)) {
            this.refreshTreeBill();
            this.afterAddChild(evt);
            this.getPageCache().remove(KEY_ROWINDEX);
        } else if ("bcm_guidemenuperm".equals(actionId)) {
            this.getModel().deleteEntryData(TREEENTRYENTITY);
            this.refreshTreeBill();
            if (evt.getReturnData() != null) {
                this.writeOperationLog(this.getOperationDistribution(), this.getOperationStstusSuccess());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"GuideMenuListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void afterAddChild(ClosedCallBackEvent evt) {
        List returnData;
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        ArrayList exids = new ArrayList();
        if (treeEntry.getExpandNodes() != null) {
            exids.addAll((List)treeEntry.getExpandNodes());
        }
        if ((returnData = (List)evt.getReturnData()) != null && !returnData.isEmpty()) {
            long targetId = (Long)returnData.get(0);
            long pid = 0L;
            DynamicObjectCollection childs = QueryServiceHelper.query((String)"bcm_guidemenu", (String)SELECTSTR, (QFilter[])new QFilter("id", "=", (Object)targetId).and(MODEL, "=", (Object)this.getModelId()).toArray(), (String)"serial");
            if (!childs.isEmpty()) {
                pid = ((DynamicObject)childs.get(0)).getLong("parent");
            }
            DynamicObjectCollection objs = this.getModel().getEntryEntity(TREEENTRYENTITY);
            for (int i = 0; i < objs.size(); ++i) {
                long Id = ((DynamicObject)objs.get(i)).getDynamicObject("menuid").getLong("id");
                if ((Id != targetId || exids.contains(String.valueOf(targetId))) && (Id != pid || exids.contains(String.valueOf(pid)))) continue;
                this.getModel().beginInit();
                int[] re = this.addChildRows(i);
                this.getModel().endInit();
                this.getView().updateView(TREEENTRYENTITY);
                if (re != null) break;
                return;
            }
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryDown(e);
        this.moveEntry(2, e);
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        this.moveEntry(1, e);
    }

    private void moveEntry(int upOrDown, AfterMoveEntryEventArgs e) {
        try (TXHandle h = TX.requiresNew();){
            try {
                int[] rowIndexs = e.getRowIndexs();
                FormDataModel model = (FormDataModel)this.getModel();
                DynamicObject rowDy = model.getEntryEntity(TREEENTRYENTITY, rowIndexs[0]);
                String seqKey = "entryseq";
                int seq = rowDy.getInt(seqKey);
                if (seq == 0) {
                    seqKey = "billseq";
                    seq = rowDy.getInt(seqKey);
                }
                DynamicObject menuBase = rowDy.getDynamicObject("menuid");
                Long entryId = rowDy.getLong("entryid");
                DynamicObject menuDy = BusinessDataServiceHelper.loadSingle((Object)menuBase.getLong("id"), (String)"bcm_guidemenu");
                DynamicObject sourceRow = this.getModel().getEntryRowEntity(TREEENTRYENTITY, upOrDown == 1 ? rowIndexs[0] - 1 : rowIndexs[0] + 1);
                int sourceSeq = sourceRow.getInt(seqKey);
                DynamicObject sourceMeun = sourceRow.getDynamicObject("menuid");
                Long sourceEntryId = sourceRow.getLong("entryid");
                DynamicObject sourceMenuDy = BusinessDataServiceHelper.loadSingle((Object)sourceMeun.getLong("id"), (String)"bcm_guidemenu");
                if ("billseq".equals(seqKey)) {
                    rowDy.set("billseq", (Object)sourceSeq);
                    sourceRow.set("billseq", (Object)seq);
                    menuDy.set("serial", (Object)sourceSeq);
                    sourceMenuDy.set("serial", (Object)seq);
                } else {
                    DynamicObjectCollection dynamicObjectCollection = menuDy.getDynamicObjectCollection("entryentity");
                    menuDy = BusinessDataServiceHelper.loadSingle((Object)entryId, (DynamicObjectType)dynamicObjectCollection.getDynamicObjectType());
                    sourceMenuDy = BusinessDataServiceHelper.loadSingle((Object)sourceEntryId, (DynamicObjectType)dynamicObjectCollection.getDynamicObjectType());
                    menuDy.set("seq", (Object)sourceSeq);
                    sourceMenuDy.set("seq", (Object)seq);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{menuDy, sourceMenuDy});
                this.getView().updateView(TREEENTRYENTITY);
                TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
                int rowIndex = rowIndexs[0];
                int newIndex = upOrDown == 1 ? rowIndex - 1 : rowIndex + 1;
                treeEntry.selectRows(newIndex);
                this.getPageCache().put(KEY_ROWINDEX, String.valueOf(newIndex));
            }
            catch (Exception e2) {
                h.markRollback();
                throw new KDBizException(e2.getMessage());
            }
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        if (this.getModel().getEntryEntity(TREEENTRYENTITY).size() < evt.getRowKey() + 1) {
            return;
        }
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        this.getModel().beginInit();
        int[] re = this.addChildRows(evt.getRowKey());
        this.getModel().endInit();
        this.getView().updateView(TREEENTRYENTITY);
        if (re == null) {
            return;
        }
        treeEntry.selectRows(evt.getRowKey());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (MODEL.equals(propName)) {
            String modelId;
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                modelId = this.getView().getPageCache().get("KEY_MODEL_ID");
                this.getModel().setValue(MODEL, (Object)modelId);
            } else {
                modelId = model.getString("id");
                this.getView().getPageCache().put("KEY_MODEL_ID", modelId);
            }
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
            this.getModel().beginInit();
            this.loadEntitymember(true);
            this.getModel().endInit();
            this.getView().updateView(TREEENTRYENTITY);
        }
    }

    private void extendChilds(List<String> exids, TreeEntryGrid treeEntry) {
        String rowStr;
        ArrayList<Integer> collRowIndexs = new ArrayList<Integer>();
        if (exids != null) {
            ArrayList<Integer> allRows = new ArrayList<Integer>();
            while (exids.size() > 0) {
                ArrayList<Integer> rows = new ArrayList<Integer>();
                DynamicObjectCollection objs = this.getModel().getEntryEntity(TREEENTRYENTITY);
                for (int i = 0; i < objs.size(); ++i) {
                    if (!exids.contains(((DynamicObject)objs.get(i)).getString("id"))) continue;
                    rows.add(i);
                    allRows.add(i);
                    exids.remove(((DynamicObject)objs.get(i)).getString("id"));
                    break;
                }
                if (rows.size() == 0) break;
                this.getModel().beginInit();
                for (Integer rid : rows) {
                    if (this.addChildRows(rid) == null) continue;
                    collRowIndexs.add(rid);
                }
                this.getModel().endInit();
                this.getView().updateView(TREEENTRYENTITY);
            }
            int[] arr = new int[allRows.size()];
            for (int i = 0; i < allRows.size(); ++i) {
                arr[i] = (Integer)allRows.get(i);
            }
            int entryRowCount = this.getModel().getEntryRowCount(TREEENTRYENTITY);
            int[] arr2 = new int[entryRowCount - allRows.size()];
            int index = 0;
            for (int i = 0; i < entryRowCount; ++i) {
                if (allRows.contains(i)) continue;
                arr2[index] = i;
                ++index;
            }
            treeEntry.expand(arr);
            treeEntry.collapse(arr2);
            this.getView().updateView(TREEENTRYENTITY);
        }
        if ((rowStr = this.getPageCache().get(KEY_ROWINDEX)) != null) {
            int rowIndex = Integer.parseInt(rowStr);
            treeEntry.selectRows(rowIndex);
        }
    }

    private int[] addChildRows(int rowKey) {
        DynamicObject obj = this.getModel().getEntryRowEntity(TREEENTRYENTITY, rowKey);
        if (obj == null) {
            return null;
        }
        String model = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
        if (model == null) {
            return null;
        }
        DynamicObject menuDy = obj.getDynamicObject("menuid");
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
        DynamicObjectCollection coll = new DynamicObjectCollection();
        coll.addAll((Collection)QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_guidemenu", (String)"id, name, number, menu.name, parent, modifier, modifytime, creator, createtime,serial,description, entryentity.open,entryentity.businesstype, entryentity.id, entryentity.seq", (QFilter[])new QFilter("id", "=", (Object)menuDy.getLong("id")).and(MODEL, "=", (Object)ConvertUtil.convertStrToLong((String)modelId)).toArray(), (String)"entryentity.seq"));
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("id");
        properties.add("menuid");
        properties.add("modifier");
        properties.add("modifytime");
        properties.add("creator");
        properties.add("createtime");
        properties.add("biztype");
        properties.add("description");
        properties.add("open");
        properties.add("name");
        properties.add("number");
        properties.add("entryid");
        properties.add("entryseq");
        properties.add("billseq");
        properties.add("distribution");
        DynamicObjectCollection childs = QueryServiceHelper.query((String)"bcm_guidemenu", (String)SELECTSTR, (QFilter[])new QFilter("parent", "=", (Object)menuDy.getLong("id")).and(MODEL, "=", (Object)ConvertUtil.convertStrToLong((String)modelId)).toArray(), (String)"serial");
        if (childs.size() > 0) {
            coll.clear();
            coll.addAll((Collection)childs);
            properties.remove("open");
            properties.remove("entryid");
            properties.remove("entryseq");
            int[] re = this.insertTreeEntry(this.getView(), coll, properties, rowKey, false, true, 3, false);
            return re;
        }
        return null;
    }

    private void loadEntitymember(boolean isClearCache) {
        String model = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
        if (Objects.isNull(model)) {
            return;
        }
        this.getModel().deleteEntryData(TREEENTRYENTITY);
        QFilter qcf = new QFilter(MODEL, "=", (Object)ConvertUtil.convertStrToLong((String)model));
        DynamicObjectCollection menuTree = new DynamicObjectCollection();
        qcf.and("parent", "=", (Object)0);
        QFilter[] filters = new QFilter[]{qcf};
        menuTree.addAll((Collection)QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_guidemenu", (String)SELECTSTR, (QFilter[])filters, (String)"serial desc"));
        if (menuTree.size() > 0) {
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            ArrayList<String> properties = new ArrayList<String>(12);
            properties.add("id");
            properties.add("menuid");
            properties.add("modifier");
            properties.add("modifytime");
            properties.add("creator");
            properties.add("createtime");
            properties.add("description");
            properties.add("name");
            properties.add("number");
            properties.add("billseq");
            properties.add("biztype");
            properties.add("distribution");
            int[] re = this.createTreeEntry(this.getView(), menuTree, properties, false, 1, true);
            if (isClearCache) {
                treeEntry.setCollapse(false);
                treeEntry.collapse(re);
                treeEntry.selectRows(0);
            }
        }
    }

    public int[] createTreeEntry(IFormView view, DynamicObjectCollection menuColl, List<String> propertyList, boolean updateView, int nameType, boolean init) {
        DynamicObject root = null;
        for (int i = 0; i < menuColl.size(); ++i) {
            DynamicObject obj = (DynamicObject)menuColl.get(i);
            if (obj.getLong("id") != 0L) continue;
            root = obj;
            break;
        }
        int[] insertTreeEntry = this.insertTreeEntry(view, menuColl, propertyList, 0, false, updateView, nameType, init);
        return insertTreeEntry;
    }

    public int[] insertTreeEntry(IFormView view, DynamicObjectCollection menuColl, List<String> propertyList, int row, boolean isDel, boolean updateView, int nameType, boolean init) {
        IDataModel model = view.getModel();
        if (menuColl.size() == 0) {
            return null;
        }
        int index = row + 1;
        if (isDel && row != 0) {
            model.deleteEntryRow(TREEENTRYENTITY, index);
        }
        Map<Integer, DynamicObject> returnMap = this.doInsertTreeEntry(model, menuColl, propertyList, row, nameType, init);
        int[] list = new int[returnMap.size()];
        int i = 0;
        if (model.isInitialized()) {
            int count = 0;
            for (Map.Entry<Integer, DynamicObject> entry : returnMap.entrySet()) {
                list[i++] = count++;
            }
        }
        return list;
    }

    private Map<Integer, DynamicObject> doInsertTreeEntry(IDataModel model, DynamicObjectCollection menuColl, List<String> propertyList, int row, int nameType, boolean init) {
        HashMap<Integer, DynamicObject> returnMap = new HashMap<Integer, DynamicObject>();
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_guidemenu", (String)SELECTSTR, (QFilter[])new QFilter(MODEL, "=", (Object)ConvertUtil.convertStrToLong((String)modelId)).toArray());
        DynamicObjectCollection treeEntryRows = (DynamicObjectCollection)model.getDataEntity(true).get(TREEENTRYENTITY);
        EntryProp entryProp = (EntryProp)model.getProperty(TREEENTRYENTITY);
        DynamicObjectType dt = entryProp.getDynamicCollectionItemPropertyType();
        DynamicObject activeRow = new DynamicObject();
        Object pkVal = "";
        if (!treeEntryRows.isEmpty()) {
            activeRow = (DynamicObject)treeEntryRows.get(row);
            activeRow.set("isGroupNode", (Object)true);
            pkVal = activeRow.getPkValue();
        }
        DynamicObjectType objEntityType = ((DynamicObject)menuColl.get(0)).getDynamicObjectType();
        DataEntityPropertyCollection objAllProps = objEntityType.getProperties();
        HashMap<String, Object> objnotShowdpProps = new HashMap<String, Object>(16);
        ArrayList<DynamicProperty> treeEntryProperties = new ArrayList<DynamicProperty>(propertyList.size());
        DynamicProperty isgroupnodeProp = dt.getProperty("isgroupnode");
        for (int k = 0; k < propertyList.size(); ++k) {
            String propertyName = propertyList.get(k);
            treeEntryProperties.add(dt.getProperty(propertyName));
            if ("menuid".equals(propertyName)) {
                objnotShowdpProps.put(propertyName, (DynamicProperty)objAllProps.get((Object)"id"));
                continue;
            }
            if ("biztype".equals(propertyName)) {
                objnotShowdpProps.put(propertyName, (DynamicProperty)objAllProps.get((Object)"menu.name"));
                continue;
            }
            if ("open".equals(propertyName)) {
                objnotShowdpProps.put(propertyName, (DynamicProperty)objAllProps.get((Object)"entryentity.open"));
                continue;
            }
            if ("entryid".equals(propertyName)) {
                objnotShowdpProps.put(propertyName, (DynamicProperty)objAllProps.get((Object)"entryentity.id"));
                continue;
            }
            if ("entryseq".equals(propertyName)) {
                objnotShowdpProps.put(propertyName, (DynamicProperty)objAllProps.get((Object)"entryentity.seq"));
                continue;
            }
            if ("billseq".equals(propertyName)) {
                objnotShowdpProps.put(propertyName, (DynamicProperty)objAllProps.get((Object)"serial"));
                continue;
            }
            if ("distribution".equals(propertyName)) {
                objnotShowdpProps.put(propertyName, new DynamicSimpleProperty());
                continue;
            }
            objnotShowdpProps.put(propertyName, (DynamicProperty)objAllProps.get((Object)propertyName));
        }
        int curindex = 1;
        int r = 0;
        int index = row;
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)menuColl.size());
        for (DynamicObject obj : menuColl) {
            DynamicObject newInsertObj;
            if (init) {
                newInsertObj = new DynamicObject(dt);
                model.createNewEntryRow(TREEENTRYENTITY, 0, newInsertObj);
            } else {
                model.insertEntryRow(TREEENTRYENTITY, row);
                DynamicObject[] entryEntity = model.getEntryEntity(TREEENTRYENTITY, index + 1, index + 2);
                newInsertObj = entryEntity[0];
                newInsertObj.set("pid", pkVal);
            }
            ISimpleProperty entryIdProp = dt.getPrimaryKey();
            if (entryIdProp instanceof VarcharProp) {
                newInsertObj.getDataEntityType().getPrimaryKey().setValueFast((Object)newInsertObj, (Object)Base39Coder.toString((long)0L));
            } else if (entryIdProp instanceof LongProp) {
                newInsertObj.getDataEntityType().getPrimaryKey().setValueFast((Object)newInsertObj, (Object)ids[r++]);
            }
            for (DynamicProperty property : treeEntryProperties) {
                DynamicObject loadSingle;
                if (property == null) continue;
                if ("menuid".equals(property.getName())) {
                    Object valueFast = ((DynamicProperty)objnotShowdpProps.get(property.getName())).getValueFast((Object)obj);
                    loadSingle = BusinessDataServiceHelper.loadSingle((Object)valueFast, (String)"bcm_guidemenu");
                    property.setValueFast((Object)newInsertObj, (Object)loadSingle);
                    continue;
                }
                if ("creator".equals(property.getName()) || "modifier".equals(property.getName())) {
                    Object valueFast = ((DynamicProperty)objnotShowdpProps.get(property.getName())).getValueFast((Object)obj);
                    if (valueFast != null && (Long)valueFast != 0L) {
                        valueFast = BusinessDataServiceHelper.loadSingle((Object)valueFast, (String)"bos_user");
                    }
                    property.setValueFast((Object)newInsertObj, valueFast);
                    continue;
                }
                if ("biztype".equals(property.getName())) {
                    if (objnotShowdpProps.get(property.getName()) == null) {
                        property.setValueFast((Object)newInsertObj, obj.get("entryentity.businesstype"));
                        continue;
                    }
                    if (nameType == 2) {
                        String valueFast = (String)((DynamicProperty)objnotShowdpProps.get(property.getName())).getValueFast((Object)obj);
                        property.setValueFast((Object)newInsertObj, (Object)valueFast);
                        continue;
                    }
                    String valueFast = (String)((DynamicProperty)objnotShowdpProps.get("biztype")).getValueFast((Object)obj);
                    if (valueFast == null || "".equals(valueFast)) continue;
                    property.setValueFast((Object)newInsertObj, (Object)valueFast);
                    continue;
                }
                if ("name".equals(property.getName())) {
                    if (nameType == 2) {
                        Long valueFast = (Long)((DynamicProperty)objnotShowdpProps.get("open")).getValueFast((Object)obj);
                        loadSingle = BusinessDataServiceHelper.loadSingle((Object)valueFast, (String)"bcm_templateentity");
                        if (valueFast == null || valueFast == 0L) continue;
                        property.setValueFast((Object)newInsertObj, (Object)(loadSingle.getString("number") + " " + loadSingle.getString("name")));
                        continue;
                    }
                    Object name = ((DynamicProperty)objnotShowdpProps.get(property.getName())).getValueFast((Object)obj);
                    property.setValueFast((Object)newInsertObj, name);
                    continue;
                }
                if (nameType == 2 && "id".equals(property.getName())) {
                    property.setValueFast((Object)newInsertObj, ((DynamicProperty)objnotShowdpProps.get("entryid")).getValueFast((Object)obj));
                    continue;
                }
                if ("distribution".equals(property.getName())) {
                    long menuId = obj.getLong("id");
                    DynamicObject permObj = BusinessDataServiceHelper.loadSingle((Object)menuId, (String)"bcm_guidemenuperm");
                    DynamicObjectCollection permColl = permObj.getDynamicObjectCollection("guidepermentry");
                    StringBuilder sb = new StringBuilder();
                    int count = 0;
                    for (DynamicObject dy : permColl) {
                        DynamicObject eusers = dy.getDynamicObject("eusers");
                        if (eusers == null) continue;
                        if (count == 0) {
                            sb.append(eusers.getString("name"));
                        } else {
                            sb.append('\uff0c').append(eusers.getString("name"));
                        }
                        ++count;
                    }
                    property.setValueFast((Object)newInsertObj, (Object)sb.toString());
                    continue;
                }
                property.setValueFast((Object)newInsertObj, ((DynamicProperty)objnotShowdpProps.get(property.getName())).getValueFast((Object)obj));
            }
            if (nameType == 1 || nameType == 3) {
                DynamicObject menu = newInsertObj.getDynamicObject("menuid");
                boolean isEmpty = true;
                int flag = this.isEntryOrChild(data, menu.getLong("id"));
                isEmpty = flag != 0;
                isgroupnodeProp.setValueFast((Object)newInsertObj, (Object)isEmpty);
            }
            ++index;
            returnMap.put(curindex++, newInsertObj);
        }
        return returnMap;
    }

    private int isEntryOrChild(DynamicObjectCollection data, long menuId) {
        int entryCount = 0;
        int flag = 0;
        HashSet<Long> pidSet = new HashSet<Long>();
        for (DynamicObject dy : data) {
            if (dy.getLong("parent") == 0L) continue;
            pidSet.add(dy.getLong("parent"));
        }
        if (pidSet.contains(menuId)) {
            flag = 2;
        } else {
            for (DynamicObject dy : data) {
                long id = dy.getLong("id");
                if (id == menuId) {
                    ++entryCount;
                }
                flag = 0;
            }
        }
        return flag;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        TreeEntryGrid source = (TreeEntryGrid)evt.getSource();
        int[] selectRows = source.getSelectRows();
        this.getPageCache().put(KEY_ROWINDEX, String.valueOf(selectRows[0]));
        DynamicObject dy = this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectRows[0]);
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "bcm_guidemenu");
        Long entryid = dy.getLong("menuid_id");
        openParameter.put("pkId", entryid + "");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_guidemenu"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(MODEL, (Object)this.getModelId());
        showParameter.setCustomParam("id", (Object)entryid);
        this.getView().showForm(showParameter);
        this.writeOperationLog(this.getOperationView(), this.getOperationStstusSuccess());
    }
}

