/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.guidemenu;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.FloatMenu;
import kd.bos.form.control.Image;
import kd.bos.form.control.TreeMenu;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeMenuClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.lang.Lang;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.guidemenu.GuideBasePlugin;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.guidemenu.GuideTreeMenu;
import kd.fi.bcm.spread.common.util.StringUtil;

public class GuideMenuOperatPlugin
extends GuideBasePlugin
implements TreeMenuClickListener {
    private static final String APPID = "11H66HLOX4IC";
    private static final String APPSTR = "cm";
    private static final String CACHE_MENU = "cache_menu";

    @Override
    public void afterCreateNewData(EventObject e) {
        String url;
        super.afterCreateNewData(e);
        Image logo = (Image)this.getControl("logo");
        try {
            Class<?> aClass = Class.forName("kd.bos.portal.service.UseLoginConfigService");
            Method method = aClass.getMethod("getCustomLogo", String.class);
            url = (String)method.invoke(aClass.newInstance(), this.getView().getFormShowParameter().getAppId());
        }
        catch (Exception ex) {
            url = null;
        }
        if (StringUtils.isNotEmpty(url)) {
            logo.setUrl(url);
        } else {
            Lang lang = RequestContext.get().getLang();
            logo.setUrl(String.format("images/pc/other/%s.png?v=1.0", !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? "logo_ccs_abbr_278_72" : "logo_ccs_cn_242_72"));
        }
        this.loadCommonInfo(this.getFilterMap());
    }

    @Override
    public boolean loadCommonInfo(Map<String, Long> filterMaps) {
        boolean isSuccess = super.loadCommonInfo(filterMaps);
        for (String dimensionParam : filters) {
            if ("entity".equalsIgnoreCase(dimensionParam) || this.getValue(dimensionParam) != null) continue;
            isSuccess = false;
            break;
        }
        if (!isSuccess) {
            this.showGuideMenuInitialize(filterMaps);
        } else {
            this.setMainPage();
            this.setInitFlag();
            DynamicObject modelDyn = (DynamicObject)this.getValue("model");
            DynamicObject cslDyn = (DynamicObject)this.getValue("cslscheme");
            this.getView().executeClientCommand("setCaption", new Object[]{modelDyn.getString("name") + '_' + cslDyn.getString("number")});
            this.buildLeftTree();
            this.initGuideMenuDimension();
        }
        return isSuccess;
    }

    private void setInitFlag() {
        this.getModel().setValue("initflag", (Object)new Date().getTime());
    }

    private boolean hasInitFlag() {
        return !StringUtil.isEmptyString((String)((String)this.getModel().getValue("initflag")));
    }

    private void initGuideMenuDimension() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("direction", "top");
        map.put("formId", "bcm_guidemenu_dimension");
        map.put("offset", 10);
        proxy.addAction("setSlideBillFormId", map);
    }

    private void showGuideMenuDimension() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> o = new HashMap<String, String>(1);
        o.put("formId", "bcm_guidemenu_dimension");
        proxy.addAction("showSlideBill", o);
    }

    private void buildLeftTree() {
        TreeMenu tree = (TreeMenu)this.getView().getControl("navigationbar");
        GuideTreeMenu.GuideTreeMenuNode menu = this.generateGuideMenu();
        tree.addNodes(menu.getChildren());
    }

    private GuideTreeMenu.GuideTreeMenuNode generateGuideMenu() {
        IDataModel model = this.getModel();
        DynamicObject modelDyn = (DynamicObject)model.getValue("model");
        GuideTreeMenu.GuideTreeMenuNode root = new GuideTreeMenu.GuideTreeMenuNode();
        if (modelDyn != null) {
            Map menuDynCollection = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_guidemenu"), (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{modelDyn.getLong("id")}).toArray());
            GuideTreeMenu guideTreeMenu = new GuideTreeMenu(modelDyn, menuDynCollection);
            root = guideTreeMenu.getGuideTreeMenuNode();
            GuideTreeMenu.GuideTreeMenuNode mergecontrol = root.findNodeByMenu("bcm_mergecontrol");
            if (mergecontrol != null) {
                mergecontrol = new GuideTreeMenu.GuideTreeMenuNode(mergecontrol);
                mergecontrol.setName(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76", (String)"GuideMenuOperatPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                mergecontrol.openGuideMenu(this.getView());
            }
            this.getPageCache().put(CACHE_MENU, ObjectSerialUtil.toByteSerialized((Object)guideTreeMenu));
        }
        return root;
    }

    @Override
    public void registerListener(EventObject e) {
        Image logo;
        super.registerListener(e);
        FloatMenu floadmenu = (FloatMenu)this.getView().getControl("floatmenu1");
        floadmenu.addItemClickListener((ItemClickListener)this);
        TreeMenu tree = (TreeMenu)this.getView().getControl("navigationbar");
        tree.addTreeMenuClickListener((TreeMenuClickListener)this);
        Vector vector = (Vector)this.getControl("menulisticon");
        if (vector != null) {
            vector.addClickListener((ClickListener)this);
        }
        if ((logo = (Image)this.getControl("logo")) != null) {
            logo.addClickListener((ClickListener)this);
        }
    }

    @Override
    protected void click(String key) {
        switch (key) {
            case "menulisticon": {
                this.showGuideMenuDimension();
                break;
            }
            case "btn_reset": {
                Map<String, Long> filterMap = GuidePageUtils.getFilterMap(this.getView(), true);
                if (filterMap != null) {
                    this.buildLeftTree();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"GuideMenuOperatPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "logo": {
                key = "btn_switch";
            }
        }
        super.click(key);
    }

    protected void setMainPage() {
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        SessionManager current = SessionManager.getCurrent();
        current.putMainPageId(formShowParameter.getRootPageId(), formView.getPageId());
        String pageId = APPID + formView.getPageId();
        PageCache pageCache = new PageCache(pageId);
        pageCache.put(FormShowParameter.class.getSimpleName(), FormShowParameter.toJsonString((FormShowParameter)formShowParameter));
        pageId = APPSTR + formView.getPageId();
        pageCache = new PageCache(pageId);
        pageCache.put(FormShowParameter.class.getSimpleName(), FormShowParameter.toJsonString((FormShowParameter)formShowParameter));
    }

    @Override
    public void createGuideMenuPage(Map<String, Long> filterMap) {
        if (this.hasInitFlag()) {
            super.createGuideMenuPage(filterMap);
        } else {
            this.loadCommonInfo(filterMap);
        }
    }

    public void treeMenuClick(TreeNodeEvent arg0) {
        this.openTab((String)arg0.getNodeId());
    }

    public void treeMenuDoubleClick(TreeNodeEvent arg0) {
        this.openTab((String)arg0.getNodeId());
    }

    private void openTab(String nodeId) {
        GuideTreeMenu root;
        GuideTreeMenu.GuideTreeMenuNode menu;
        String cacheNode = this.getPageCache().get(CACHE_MENU);
        if (StringUtils.isNotEmpty((CharSequence)cacheNode) && (menu = (GuideTreeMenu.GuideTreeMenuNode)(root = (GuideTreeMenu)ObjectSerialUtil.deSerializedBytes((String)cacheNode)).getGuideTreeMenuNode().getTreeNode(nodeId, 10)) != null) {
            menu.openGuideMenu(this.getView());
        }
    }
}

