/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.guidemenu;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.spread.common.util.StringUtil;

public class GuideMenuPermEditPlugin
extends AbstractBasePlugIn {
    private static final String BASE_USER = "baseuser";
    private static final String BASE_USER_GROUP = "baseusergroup";
    private static final String disEntry_ID = "guidepermentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit user = (BasedataEdit)this.getControl(BASE_USER);
        user.addBeforeF7SelectListener(evt -> this.beforeF7Select(evt));
        BasedataEdit usergroup = (BasedataEdit)this.getControl(BASE_USER_GROUP);
        usergroup.addBeforeF7SelectListener(evt -> this.beforeF7Select(evt));
        MulBasedataEdit guidemenuids = (MulBasedataEdit)this.getControl("guidemenuids");
        guidemenuids.addBeforeF7SelectListener(evt -> this.beforeF7Select(evt));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        long modelId = LongUtil.toLong((Object)parameter.getCustomParam("model"));
        if (modelId == 0L) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u62a5\u8868\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserSelectUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        CloseCallBack aa = new CloseCallBack((IFormPlugin)this, evt.getProperty().getName());
        evt.getFormShowParameter().setCloseCallBack(aa);
        evt.getFormShowParameter().setHasRight(true);
        String name = evt.getProperty().getName();
        if (Objects.equals(BASE_USER, name) || Objects.equals(BASE_USER_GROUP, name)) {
            evt.getFormShowParameter().setCustomParam("ismergerows", (Object)Boolean.TRUE);
            evt.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)ConfigServiceHelper.getGlobalBoolParam((String)"P006"));
        }
        if (StringUtil.equals((String)(key = ((Control)evt.getSource()).getKey()), (String)"guidemenuids")) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(new QFilter("model", "=", this.getView().getFormShowParameter().getCustomParam("model")));
            ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getModel().setValue("guidemenuids", (Object)new Object[]{this.getView().getFormShowParameter().getCustomParam("entryid")});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "addusergroup": {
                MulBasedataEdit userGroup = (MulBasedataEdit)this.getControl(BASE_USER_GROUP);
                userGroup.click();
                break;
            }
            case "adduser": {
                MulBasedataEdit user = (MulBasedataEdit)this.getControl(BASE_USER);
                user.click();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
        if (rows == null) {
            return;
        }
        ArrayList<Object> oids = this.getOldDisIds();
        switch (actionId = evt.getActionId()) {
            case "baseuser": {
                this.setData2Entry(rows, oids, "bos_user");
                break;
            }
            case "baseusergroup": {
                this.setData2Entry(rows, oids, "bos_usergroup");
                break;
            }
            case "guidemenuids": {
                this.getModel().setValue("guidemenuids", (Object)rows.getPrimaryKeyValues());
            }
        }
    }

    private void setData2Entry(ListSelectedRowCollection rows, ArrayList<Object> oids, String baseType) {
        rows.forEach(p -> {
            if (!oids.contains(p.getPrimaryKeyValue())) {
                int rowIndex = this.getModel().createNewEntryRow(disEntry_ID);
                this.getModel().setValue("etype", (Object)baseType, rowIndex);
                this.getModel().setValue("eusers", p.getPrimaryKeyValue(), rowIndex);
            }
        });
    }

    private ArrayList<Object> getOldDisIds() {
        ArrayList<Object> ids = new ArrayList<Object>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(disEntry_ID);
        if (entryEntity != null && entryEntity.size() > 0) {
            entryEntity.forEach(p -> {
                DynamicObject eusers = p.getDynamicObject("eusers");
                if (eusers != null) {
                    ids.add(eusers.getPkValue());
                }
            });
        }
        return ids;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtil.equals((String)key, (String)"guidemenuids")) {
            DynamicObject dy;
            DynamicObjectCollection details;
            this.getModel().deleteEntryData(disEntry_ID);
            DynamicObjectCollection guidemenuids = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            if (guidemenuids != null && guidemenuids.size() == 1 && (details = (dy = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)guidemenuids.get(0)).getLong("fbasedataid.id"), (String)"bcm_guidemenuperm")).getDynamicObjectCollection(disEntry_ID)).size() > 0) {
                this.getModel().batchCreateNewEntryRow(disEntry_ID, details.size());
                for (int i = 0; i < details.size(); ++i) {
                    this.getModel().setValue("etype", ((DynamicObject)details.get(i)).get("etype"), i);
                    this.getModel().setValue("eusers", ((DynamicObject)details.get(i)).get("eusers"), i);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            DynamicObject[] allChildPerms;
            args.setCancel(true);
            DynamicObjectType allChildtype = BusinessDataServiceHelper.newDynamicObject((String)"bcm_guidemenuperm").getDynamicObjectType();
            DynamicObjectCollection menus = (DynamicObjectCollection)this.getModel().getValue("guidemenuids");
            if (menus.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83dc\u5355\u5411\u5bfc\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuideMenuPermEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            HashSet<Object> allChildId = new HashSet<Object>();
            GuidePageUtils.getAllChildMenus(menus.stream().map(menu -> menu.getDynamicObject("fbasedataid").get("id")).collect(Collectors.toList()), allChildId);
            for (DynamicObject childPermDyn : allChildPerms = BusinessDataServiceHelper.load((Object[])allChildId.toArray(), (DynamicObjectType)allChildtype)) {
                DynamicObjectCollection permEntryCollTemp = childPermDyn.getDynamicObjectCollection(disEntry_ID);
                DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(disEntry_ID);
                permEntryCollTemp.clear();
                int i = 0;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObject guidmenupermtype = permEntryCollTemp.addNew();
                    guidmenupermtype.set("etype", dynamicObject.get("etype"));
                    guidmenupermtype.set("eusers", dynamicObject.get("eusers"));
                    guidmenupermtype.set("seq", (Object)(++i));
                    guidmenupermtype.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                }
            }
            SaveServiceHelper.save((DynamicObject[])allChildPerms);
            this.getView().returnDataToParent((Object)"true");
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }
}

