/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.guidemenu;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.common.enums.GuideCustomSetEmum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.guidemenu.GuideTreeMenu;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class GuidePageUtils {
    private static final String[] FILTERS = new String[]{"model", "scenario", "year", "period", "currency", "cslscheme"};
    private static Log LOGGER = LogFactory.getLog(GuidePageUtils.class);
    public static final String CUSTOMPARAMETERS = "customparameters";
    public static final String FROM_GUIDE_PAGE = "from_guide_page";
    public static final String COMMON_GUIDE_PAGE = "common_guide_page";
    private static final String GUIDEMAIN = "&guidemain";
    private static final String PAGEID = "pageId";

    public static Map<String, Long> getFilterMap(IFormView view, boolean isCheckBlank) {
        HashMap filterMap = Maps.newHashMapWithExpectedSize((int)FILTERS.length);
        DynamicObject filterData = null;
        for (String filter : FILTERS) {
            filterData = (DynamicObject)view.getModel().getValue(filter);
            if (filterData == null) {
                if (!isCheckBlank) continue;
                return null;
            }
            filterMap.put(filter, filterData.getLong("id"));
        }
        Object org = view.getModel().getValue("entity");
        filterMap.put("entity", org == null ? null : Long.valueOf(((DynamicObject)org).getLong("id")));
        return filterMap;
    }

    public static Map<String, Long> getUserSelectMap(DynamicObject param) {
        HashMap filterMap = Maps.newHashMapWithExpectedSize((int)FILTERS.length);
        if (param != null) {
            String[] commonF7;
            for (String filter : commonF7 = Arrays.copyOfRange(FILTERS, 0, FILTERS.length)) {
                if (param.getLong(filter) == 0L) {
                    return null;
                }
                filterMap.put(filter, param.getLong(filter));
            }
        }
        return filterMap;
    }

    public static boolean loadFilterMapF7(IFormView view, Map<String, Long> filterMap, boolean isCheckBlank) {
        if (filterMap == null || filterMap.isEmpty()) {
            return false;
        }
        for (String filter : FILTERS) {
            if (isCheckBlank && filterMap.get(filter) == null) {
                return false;
            }
            view.getModel().setValue(filter, (Object)filterMap.get(filter));
        }
        view.getModel().setValue("entity", (Object)filterMap.get("entity"));
        return true;
    }

    public static void openApp(String appId, String appNumber, String menuId, Map<String, Object> map, IFormView myappView) {
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null || myappView == null) {
            LOGGER.error("OpenPageUtils----openApp----appId or view in map is null");
            return;
        }
        String appMainNumber = app.getHomeNum();
        IFormView mainPageView = myappView.getMainView();
        String appName = app.getName().getLocaleValue();
        if (StringUtils.isBlank((CharSequence)appName)) {
            appName = app.getName().getLocaleValue_zh_CN();
        }
        if (StringUtils.isBlank((CharSequence)appName)) {
            appName = app.getNumber();
        }
        if (map == null) {
            map = Maps.newHashMapWithExpectedSize((int)3);
            map.put("view", myappView);
            map.put("appname", appName);
            map.put("appmainnumber", appMainNumber);
        }
        if (Objects.isNull(map.get(PAGEID))) {
            map.put(PAGEID, GUIDEMAIN);
        } else {
            map.put(PAGEID, GUIDEMAIN + map.get(PAGEID));
            Tab tab = (Tab)mainPageView.getControl("_submaintab_");
            if (mainPageView.getView(map.get(PAGEID).toString()) != null && tab != null) {
                tab.activeTab("tabpageap");
                myappView.sendFormAction(mainPageView);
                return;
            }
        }
        if (menuId != null) {
            GuidePageUtils.openMenuPage(appId, appNumber, menuId, map);
        }
    }

    public static String getInitFlag(IFormView view) {
        return view.getMainView().getModel().getValue("initflag").toString();
    }

    @Deprecated
    private static void openMenuPage(String appID, String appNumber, String menuid, Map<String, Object> map) {
        GuidePageUtils.openMenuPage(appID, appNumber, map);
    }

    private static void openMenuPage(String appID, String appNumber, Map<String, Object> map) {
        IFormView appPageView;
        IFormView view = (IFormView)map.get("view");
        if (appID == null || map.get("view") == null || map.get("formnumber") == null) {
            LOGGER.info("OpenPageUtils----openMenuPage----appID or parameter in map is error [143]");
            return;
        }
        String parameterType = "";
        Object objParamType = map.get("parametertype");
        parameterType = objParamType == null ? "FormShowParameter" : objParamType.toString();
        String formNumber = map.get("formnumber").toString();
        HashMap<String, Object> parameter = new HashMap();
        Object parameterStr = map.get("parameter");
        if (StringUtils.isNotBlank((Object)parameterStr)) {
            parameter = (Map)SerializationUtils.fromJsonString((String)parameterStr.toString(), Map.class);
        }
        if ((appPageView = view) != null) {
            Map customMap;
            if (appPageView.getPageId().equalsIgnoreCase(view.getPageId())) {
                appPageView = view;
            }
            FormShowParameter fsp = GuidePageUtils.showFormParameter(formNumber, parameterType, parameter, map);
            fsp.setHasRight(true);
            fsp.setAppId(appNumber);
            fsp.setPageId(map.get(PAGEID).toString());
            Map params = (Map)map.get(CUSTOMPARAMETERS);
            if (params != null) {
                params.putAll(parameter);
                fsp.setCustomParams(params);
            }
            if ((customMap = fsp.getCustomParams()) == null) {
                customMap = Maps.newHashMapWithExpectedSize((int)2);
            }
            fsp.setCaption(map.get("menuname").toString());
            Boolean isAIVoiceRequest = (Boolean)customMap.get("isAIVoiceRequest");
            if (isAIVoiceRequest != null && isAIVoiceRequest.booleanValue()) {
                Map<String, String> openStyleCustParam = fsp.getOpenStyle().getCustParam() != null ? fsp.getOpenStyle().getCustParam() : new HashMap();
                openStyleCustParam.put("isFullScreen", "true");
                fsp.getOpenStyle().setCustParam(openStyleCustParam);
            }
            customMap.put("appid", appID);
            fsp.setCustomParams(customMap);
            List pluginList = ((FormViewPluginProxy)appPageView.getService(FormViewPluginProxy.class)).getPlugIns();
            if (pluginList != null && pluginList.size() > 0) {
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)pluginList.get(0), "close_menupage"));
            }
            view.showForm(fsp);
        }
    }

    @Deprecated
    private static FormShowParameter showFormParameter(String formNumber, String parameterType, Map<String, Object> parameter, Map<String, Object> map) {
        return GuidePageUtils.showFormParameter(formNumber, parameterType, parameter);
    }

    private static FormShowParameter showFormParameter(String formNumber, String parameterType, Map<String, Object> parameter) {
        FormShowParameter sp;
        if (parameterType.equalsIgnoreCase("ListShowParameter")) {
            MainEntityType dt;
            String entityId;
            parameter.put("type", "list");
            String billFormId = (String)parameter.get("billFormId");
            if (billFormId == null && !"empty".equalsIgnoreCase(entityId = FormMetadataCache.getFormConfig((String)formNumber).getEntityTypeId()) && (dt = EntityMetadataCache.getDataEntityType((String)entityId)) instanceof BillEntityType) {
                parameter.put("billFormId", formNumber);
            }
            sp = FormShowParameter.createFormShowParameter(parameter);
        } else {
            if (parameter.get("formId") == null) {
                parameter.put("formId", formNumber);
            }
            sp = FormShowParameter.createFormShowParameter(parameter);
        }
        GuidePageUtils.setParameterValue(sp, parameter);
        sp.getOpenStyle().setShowType(ShowType.InContainer);
        sp.getOpenStyle().setTargetKey("tabpageap");
        sp.setCustomParams(parameter);
        return sp;
    }

    private static void setParameterValue(FormShowParameter showParameter, Map<String, Object> params) {
        if (params != null) {
            Class<?> clazz = showParameter.getClass();
            try {
                GuidePageUtils.exeClass(showParameter, params, clazz);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
    }

    private static void exeClass(FormShowParameter showParameter, Map<String, Object> params, Class<?> clazz) throws IllegalArgumentException, IllegalAccessException, IOException {
        Field[] fields;
        if (clazz == Object.class) {
            return;
        }
        block0: for (Field field : fields = clazz.getDeclaredFields()) {
            ReflectionUtils.makeAccessible((Field)field);
            String paramName = field.getName();
            String type = field.getGenericType().getTypeName();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String pName = entry.getKey();
                if (pName.equalsIgnoreCase("status") && paramName.equalsIgnoreCase(pName)) {
                    int paramValue = Integer.parseInt((String)entry.getValue());
                    field.set(showParameter, OperationStatus.forValue((int)paramValue));
                    continue block0;
                }
                if (pName.equalsIgnoreCase("listFilterParameter") && paramName.equalsIgnoreCase(pName)) {
                    String paramValue = (String)entry.getValue();
                    ListFilterParameter filterParameter = new ListFilterParameter();
                    filterParameter.setQFilter(paramValue);
                    field.set(showParameter, filterParameter);
                    continue block0;
                }
                if (!paramName.equalsIgnoreCase(pName)) continue;
                String paramValue = "";
                if (params.get(paramName) instanceof LinkedHashMap) {
                    String captionLocalName;
                    LinkedHashMap paramLinkedHashMap = (LinkedHashMap)params.get(paramName);
                    LocaleString captionName = LocaleString.fromMap((Map)paramLinkedHashMap);
                    paramValue = captionLocalName = captionName.getLocaleValue();
                } else if (params.get(paramName) instanceof String) {
                    paramValue = (String)params.get(paramName);
                }
                if (type.endsWith("Object")) {
                    field.set(showParameter, paramValue);
                    continue block0;
                }
                if (type.endsWith("String")) {
                    String className = clazz.getName();
                    if ("kd.bos.list.ListShowParameter".equals(className) && "CAPTION".equals(paramName)) continue;
                    field.set(showParameter, paramValue);
                    continue block0;
                }
                if (type.endsWith("int") || type.endsWith("Integer")) {
                    field.set(showParameter, Integer.valueOf(paramValue));
                    continue block0;
                }
                if (type.endsWith("double") || type.endsWith("Double")) {
                    field.set(showParameter, Double.valueOf(paramValue));
                    continue block0;
                }
                if (type.endsWith("boolean") || type.endsWith("Boolean")) {
                    field.set(showParameter, Boolean.valueOf(paramValue));
                    continue block0;
                }
                if (type.endsWith("float") || type.endsWith("Float")) {
                    field.set(showParameter, Float.valueOf(paramValue));
                    continue block0;
                }
                if (type.endsWith("short") || type.endsWith("Short")) {
                    field.set(showParameter, Short.valueOf(paramValue));
                    continue block0;
                }
                if (type.endsWith("long") || type.endsWith("Long")) {
                    field.set(showParameter, Long.valueOf(paramValue));
                    continue block0;
                }
                if (type.endsWith("byte") || type.endsWith("Byte")) {
                    field.set(showParameter, Byte.valueOf(paramValue));
                    continue block0;
                }
                if (!type.endsWith("Map<java.lang.String, java.lang.Object>")) continue block0;
                field.set(showParameter, SerializationUtils.fromJsonString((String)paramValue, Map.class));
                continue block0;
            }
        }
        Class<?> clazzs = clazz.getSuperclass();
        GuidePageUtils.exeClass(showParameter, params, clazzs);
    }

    public static boolean isFromGuide(IFormView formView) {
        if (formView != null) {
            boolean isHasFromGuidePageParams = formView.getFormShowParameter().getCustomParam(FROM_GUIDE_PAGE) != null;
            boolean isGuideInitialize = formView.getEntityId().contains("bcm_guideinitialize");
            boolean isGuideMainView = formView.getMainView() != null && formView.getMainView().getMainView().getEntityId().contains("bcm_guide");
            return isHasFromGuidePageParams || isGuideInitialize || isGuideMainView;
        }
        return false;
    }

    public static Map<String, Object> getCommonInfo(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String commonStr = (String)formShowParameter.getCustomParam(COMMON_GUIDE_PAGE);
        Map<Object, Object> commonInfo = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)commonStr)) {
            commonInfo = (Map)ObjectSerialUtil.deSerializedBytes((String)commonStr);
        }
        if (commonInfo.size() == 0) {
            commonInfo = GuidePageUtils.getFilterMap(formView.getMainView(), false);
        }
        return commonInfo;
    }

    public static void afterCreateNewData4Rpt(IFormView view) {
        if (GuidePageUtils.isFromGuide(view)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"btn_batchoprt"});
        }
    }

    public static boolean refreshBillByUserSelect4List(List<String> dimKeys, IFormView view) {
        if (GuidePageUtils.isFromGuide(view)) {
            view.getModel().beginInit();
            Map<String, Object> commonInfo = GuidePageUtils.getCommonInfo(view);
            Object model = commonInfo.get("model");
            view.getModel().setValue("model", model);
            IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
            String modelStr = "" + model;
            pageCache.put("KEY_MODEL_ID", modelStr);
            SingleMemberF7Util.cacheModelPrem(pageCache, Long.valueOf(modelStr), ModelUtil.queryApp(view));
            dimKeys.forEach(k -> view.getModel().setValue(k, commonInfo.get(k)));
            view.getModel().endInit();
            return true;
        }
        return false;
    }

    public static boolean setDefaultCslSchemeValue(IFormView view, Object modelid) {
        if (GuidePageUtils.isguideModel(view, modelid)) {
            Map<String, Object> commonInfo = GuidePageUtils.getCommonInfo(view);
            view.getModel().setValue("cslscheme", commonInfo.get("cslscheme"));
            return true;
        }
        return false;
    }

    public static Object getEntity(IFormView view) {
        if (GuidePageUtils.isFromGuide(view)) {
            Map<String, Object> commonInfo = GuidePageUtils.getCommonInfo(view);
            Object entity = commonInfo.get("entity");
            return entity;
        }
        return null;
    }

    public static boolean isguideModel(IFormView view, Object modelid) {
        return GuidePageUtils.isFromGuide(view) && ObjectUtils.nullSafeEquals((Object)GuidePageUtils.getCommonInfo(view).get("model_id"), (Object)modelid);
    }

    public static boolean hasMenuPerm(Long entryid) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Set groupIds = UserDistributeServiceHelper.queryAllGroupByUserId((long)userId);
        groupIds.add(userId);
        boolean menuIds = QueryServiceHelper.exists((String)"bcm_guidemenu", (QFilter[])QFilter.of((String)"id = ? and creator = ?", (Object[])new Object[]{entryid, userId}).toArray());
        boolean menuIds2 = QueryServiceHelper.exists((String)"bcm_guidemenuperm", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{entryid}).and(new QFilter("guidepermentry.eusers", "in", (Object)groupIds)).toArray());
        return menuIds || menuIds2;
    }

    public static String getUserSelectOrg(IFormView iFormView, long userid, long modelid, boolean isCsl, boolean isBaseMember) {
        if (!GuidePageUtils.isguideModel(iFormView, modelid)) {
            return (String)UserSelectServiceHelper.getEntity((Long)userid, (Long)modelid);
        }
        Object appUserSelect = UserSelectServiceHelper.getEntity((Long)userid, (Long)modelid, GuidePageUtils::getEntity, (IFormView)iFormView);
        String selectnode = null;
        if (appUserSelect != null && !StringUtils.isEmpty((CharSequence)appUserSelect.toString())) {
            selectnode = appUserSelect.toString();
        } else if (GuidePageUtils.isFromGuide(iFormView)) {
            Object cslSchemeid = GuidePageUtils.getCommonInfo(iFormView).get("cslscheme");
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"isleaf,parent", (QFilter[])new QFilter[]{new QFilter("cslscheme", "=", cslSchemeid), new QFilter("parent.number", "=", (Object)"Entity"), new QFilter("model", "=", (Object)modelid)});
            String string = selectnode = org == null ? null : org.getString("id");
        }
        if (!StringUtil.isEmptyString(selectnode) && isCsl) {
            DynamicObject dimension;
            if (isBaseMember) {
                selectnode = ((Long)QueryMemberDetailsHelper.change2BaseMember(new HashSet<Long>(Collections.singletonList(Long.parseLong(selectnode)))).iterator().next()).toString();
            }
            if ((dimension = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"isleaf,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectnode)})) != null) {
                selectnode = dimension.getBoolean("isleaf") ? dimension.get("parent").toString() : selectnode;
            }
        }
        return selectnode;
    }

    public static QFilter filterCatalogTree(IFormView view, QFilter qFilter) {
        if (GuidePageUtils.isFromGuide(view)) {
            Map<String, Object> commonInfos = GuidePageUtils.getCommonInfo(view);
            if (!ObjectUtils.nullSafeEquals((Object)commonInfos.get("model"), (Object)view.getModel().getValue("model_id"))) {
                return qFilter;
            }
            Object pkid = commonInfos.get("menu");
            DynamicObject menu = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_guidemenu", (String)"classification,entryentity.open,entryentity.isdelete", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)pkid)).toArray());
            if (menu == null) {
                return qFilter;
            }
            Set numbers = menu.getDynamicObjectCollection("entryentity").stream().filter(s -> s.getBoolean("isdelete")).map(bill -> bill.getString("open.number")).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(numbers)) {
                qFilter.and("number", "not in", numbers);
            }
            DynamicObjectCollection doc = TemplatePermCrossUtil.getCatalogDyos((long)LongUtil.toLong((Object)commonInfos.get("model")));
            HashMap<String, List<Long>> templateCalogs = new HashMap<String, List<Long>>(16);
            doc.stream().forEach(p -> {
                String parent = p.getString("parent");
                if (StringUtils.isNotEmpty((CharSequence)parent)) {
                    templateCalogs.computeIfAbsent(parent, k -> new ArrayList()).add(p.getLong("id"));
                }
            });
            ArrayList<Long> guideTemplates = new ArrayList<Long>(16);
            GuidePageUtils.findAllTemplates(guideTemplates, templateCalogs, ObjectUtils.isEmpty((Object)menu.getString("classification")) ? (Long)((List)templateCalogs.get("0")).get(0) : LongUtil.toLong((Object)menu.getString("classification")));
            qFilter.and("templatecatalog", "in", guideTemplates);
        }
        return qFilter;
    }

    private static void findAllTemplates(List<Long> guideTemplates, Map<String, List<Long>> templateCalogs, Long classification) {
        guideTemplates.add(classification);
        if (templateCalogs.get(classification.toString()) != null) {
            templateCalogs.get(classification.toString()).stream().forEach(classification1 -> GuidePageUtils.findAllTemplates(guideTemplates, templateCalogs, classification1));
        }
    }

    public static void getAllChildMenus(List<Object> rootMenuids, Set<Object> menuids) {
        menuids.addAll(rootMenuids);
        List children = QueryServiceHelper.queryPrimaryKeys((String)"bcm_guidemenu", (QFilter[])new QFilter("parent.id", "in", rootMenuids).toArray(), (String)"", (int)-1);
        if (children != null && !children.isEmpty()) {
            GuidePageUtils.getAllChildMenus(children, menuids);
        }
    }

    public static String resetGuideMenuBaseInfos() {
        String bcmAppId = GuidePageUtils.getAppIdByAppNumber("cm");
        Map menuBases = BusinessDataServiceHelper.loadFromCache((String)"bcm_menubase", null);
        Set<Object> menuids = menuBases.keySet();
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)bcmAppId, (boolean)true);
        ArrayList needSaveDys = Lists.newArrayListWithCapacity((int)16);
        for (AppMenuElement appMenuElement : metadata.getAppMenus()) {
            if (StringUtil.isEmptyString((String)appMenuElement.getFormNumber()) || appMenuElement.getFormNumber().contains("guide") || appMenuElement.getFormNumber().contains("menubase") || StringUtil.isEmptyString((String)appMenuElement.getNumber()) || !"true".equals(appMenuElement.getVisible())) continue;
            GuidePageUtils.buildSaveDy(appMenuElement, menuids, menuBases, bcmAppId, false, needSaveDys);
        }
        JSONArray qingMenus = GuidePageUtils.getQingMenuArray(bcmAppId);
        if (qingMenus != null) {
            ListIterator qingMenusListIterator = qingMenus.listIterator();
            while (qingMenusListIterator.hasNext()) {
                final JSONObject qingObj = (JSONObject)qingMenusListIterator.next();
                GuidePageUtils.buildSaveDy(new AppMenuElement(){
                    {
                        this.setId(qingObj.getString("qingMenuId"));
                        this.setName(new LocaleString(qingObj.getString("qingMenuName")));
                        this.setFormNumber(qingObj.getString("formNumber"));
                        this.setNumber(qingObj.getString("formNumber"));
                        this.setParameter(qingObj.getString("formParams"));
                    }
                }, menuids, menuBases, bcmAppId, true, needSaveDys);
            }
        }
        try (TXHandle tx = TX.required();){
            try {
                if (CollectionUtils.isNotEmpty(menuids)) {
                    DeleteServiceHelper.delete((String)"bcm_menubase", (QFilter[])new QFilter("id", "in", menuids).toArray());
                }
                if (CollectionUtils.isNotEmpty((Collection)needSaveDys)) {
                    SaveServiceHelper.save((DynamicObject[])needSaveDys.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error((Throwable)e);
                String string = e.getMessage();
                if (tx != null) {
                    if (var7_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return string;
            }
        }
        return null;
    }

    private static JSONArray getQingMenuArray(String appNumber) {
        if (appNumber != null && !"".equals(appNumber.trim())) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
            if (appInfo != null && !StringUtil.isEmptyString((String)appInfo.getId())) {
                JSONArray qingMenus = null;
                try {
                    HashMap params = Maps.newHashMapWithExpectedSize((int)1);
                    String appId = appInfo.getId();
                    params.put("appId", appId);
                    byte[] result = (byte[])DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"doGetAppQingMenu", (Object[])new Object[]{params});
                    String res = new String(result, "UTF-8");
                    JSONObject qingObj = JSONObject.parseObject((String)res);
                    String qingMenuStr = qingObj.get((Object)"data").toString();
                    qingMenus = JSONArray.parseArray((String)qingMenuStr);
                    return qingMenus;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static String getAppIdByAppNumber(String appNumber) {
        DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter("number", "=", (Object)appNumber).toArray());
        return app == null ? null : app.getString("id");
    }

    private static int propertyHasChangedTimes(DynamicObject dy, String key, String value) {
        if (Objects.equals(dy.getString(key), value)) {
            return 0;
        }
        dy.set(key, (Object)value);
        return 1;
    }

    private static void buildSaveDy(AppMenuElement appMenuElement, Set<Object> menuids, Map<Object, DynamicObject> menuBases, String AppId, boolean isQingMenu, List<DynamicObject> dys) {
        if (menuids.contains(appMenuElement.getFormId())) {
            GuidePageUtils.existFormId(appMenuElement, menuids, menuBases, isQingMenu, dys);
            return;
        }
        if (menuids.contains(appMenuElement.getId())) {
            GuidePageUtils.existId(appMenuElement, menuids, menuBases, AppId, isQingMenu, dys);
            return;
        }
        DynamicObject menubase = BusinessDataServiceHelper.newDynamicObject((String)"bcm_menubase");
        menubase.set("id", (Object)appMenuElement.getId());
        menubase.set("menuid", (Object)appMenuElement.getId());
        menubase.set("appid", (Object)AppId);
        if (isQingMenu) {
            menubase.set("customsetting", (Object)(appMenuElement.getParameter() + "&qing"));
        } else {
            menubase.set("customsetting", (Object)GuideCustomSetEmum.getCustomsettingByFormNumber((String)appMenuElement.getFormNumber()));
        }
        menubase.set("number", (Object)appMenuElement.getNumber());
        menubase.set("name", (Object)appMenuElement.getName().getLocaleValue());
        menubase.set("formid", (Object)appMenuElement.getFormNumber());
        dys.add(menubase);
    }

    private static void existId(AppMenuElement appMenuElement, Set<Object> menuids, Map<Object, DynamicObject> menuBases, String AppId, boolean isQingMenu, List<DynamicObject> dys) {
        DynamicObject menubase = menuBases.get(appMenuElement.getId());
        int changedTimes = 0;
        changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "menuid", appMenuElement.getId());
        changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "appid", AppId);
        changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "number", appMenuElement.getNumber());
        changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "name", appMenuElement.getName().getLocaleValue());
        changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "formid", appMenuElement.getFormNumber());
        changedTimes = isQingMenu ? (changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "customsetting", appMenuElement.getParameter() + "&qing")) : (changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "customsetting", GuideCustomSetEmum.getCustomsettingByFormNumber((String)appMenuElement.getFormNumber())));
        if (changedTimes > 0) {
            dys.add(menubase);
        }
        menuids.remove(appMenuElement.getId());
    }

    private static void existFormId(AppMenuElement appMenuElement, Set<Object> menuids, Map<Object, DynamicObject> menuBases, boolean isQingMenu, List<DynamicObject> dys) {
        DynamicObject menubase = menuBases.get(appMenuElement.getFormId());
        int changedTimes = 0;
        changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "number", appMenuElement.getNumber());
        changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "name", appMenuElement.getName().getLocaleValue());
        changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "formid", appMenuElement.getFormNumber());
        if (isQingMenu) {
            changedTimes += GuidePageUtils.propertyHasChangedTimes(menubase, "customsetting", appMenuElement.getParameter() + "&qing");
        }
        if (changedTimes > 0) {
            dys.add(menubase);
        }
        menuids.remove(appMenuElement.getFormId());
    }

    public static UserSelectModel getUserSelectAfterCreateNewData(IFormView formView) {
        if (GuidePageUtils.isFromGuide(formView)) {
            Map<String, Object> commonInfos = GuidePageUtils.getCommonInfo(formView);
            UserSelectModel userSelect = new UserSelectModel();
            userSelect.setModel(commonInfos.get("model").toString());
            userSelect.setScene(commonInfos.get("scenario").toString());
            userSelect.setPeriod(commonInfos.get("period").toString());
            userSelect.setCurrency(commonInfos.get("currency").toString());
            userSelect.setCslScheme(commonInfos.get("cslscheme").toString());
            userSelect.setYear(commonInfos.get("year").toString());
            return userSelect;
        }
        return null;
    }

    public static String getTabPageId(GuideTreeMenu.GuideTreeMenuNode guideMenu, IFormView iFormView, String initFlag, boolean isParent) {
        String pageId = iFormView.getPageId() + initFlag;
        if (guideMenu == null) {
            return pageId;
        }
        return isParent ? guideMenu.get_Parentid() : guideMenu.get_Id() + guideMenu.getFormId() + guideMenu.getAppId() + pageId;
    }

    public static String getMenuPageId(GuideTreeMenu.GuideTreeMenuNode guideMenu, IFormView iFormView, String initFlag) {
        String pageId = iFormView.getPageId() + initFlag;
        if (guideMenu == null) {
            return pageId;
        }
        return guideMenu.get_Parentid() + guideMenu.getAppId() + guideMenu.getFormId() + pageId;
    }
}

