/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.guidemenu;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeMenuNode;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.guidemenu.PageManagerFactory;
import kd.fi.bcm.formplugin.tree.AbstractTreeMenuNode;
import org.apache.commons.lang3.StringEscapeUtils;

public class GuideTreeMenu
implements Serializable {
    private static final long serialVersionUID = 5228636935825766229L;
    private GuideTreeMenuNode guideTreeMenuNode;
    private Map<String, Set<String>> activeTabs;

    public GuideTreeMenu(DynamicObject modelDyn, Map<Object, DynamicObject> menuDynCollection) {
        this.guideTreeMenuNode = this.toTreeMenu(menuDynCollection, modelDyn);
        this.activeTabs = new HashMap<String, Set<String>>();
    }

    public GuideTreeMenuNode getGuideTreeMenuNode() {
        return this.guideTreeMenuNode;
    }

    public Map<String, Set<String>> getActiveTabs() {
        return this.activeTabs;
    }

    private Set<Long> getNodePerm(Set<Long> columnKeySet, Long modelId) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Set groupIds = UserDistributeServiceHelper.queryAllGroupByUserId((long)userId);
        groupIds.add(userId);
        DynamicObjectCollection menuIds = QueryServiceHelper.query((String)"bcm_guidemenu", (String)"id", (QFilter[])QFilter.of((String)"model = ? and creator = ? and 1!=1", (Object[])new Object[]{modelId, userId}).toArray());
        DynamicObjectCollection menuIds2 = QueryServiceHelper.query((String)"bcm_guidemenuperm", (String)"id", (QFilter[])new QFilter("guidepermentry.eusers", "in", (Object)groupIds).toArray());
        HashSet<Long> result = new HashSet<Long>();
        menuIds.forEach(v -> {
            if (columnKeySet.contains(v.getLong("id"))) {
                result.add(v.getLong("id"));
            }
        });
        menuIds2.forEach(v -> {
            if (columnKeySet.contains(v.getLong("id"))) {
                result.add(v.getLong("id"));
            }
        });
        return result;
    }

    private GuideTreeMenuNode toTreeMenu(Map<Object, DynamicObject> menuDynCollection, DynamicObject modelDyn) {
        GuideTreeMenuNode root = new GuideTreeMenuNode("0", "0", "root");
        if (menuDynCollection != null && menuDynCollection.size() >= 1) {
            HashSet tempIds = new HashSet();
            if (menuDynCollection != null && menuDynCollection.size() > 0) {
                HashBasedTable menuTable = HashBasedTable.create();
                menuDynCollection.forEach((arg_0, arg_1) -> GuideTreeMenu.lambda$toTreeMenu$2((Table)menuTable, tempIds, arg_0, arg_1));
                Set<Long> haveNodePermIds = this.getNodePerm(menuTable.columnKeySet(), modelDyn.getLong("id"));
                root.buildByTable((Table<Long, Long, GuideTreeMenuNode>)menuTable, haveNodePermIds);
            }
        }
        root.setHasRight(true);
        root.setHidden(false);
        return root;
    }

    private static /* synthetic */ void lambda$toTreeMenu$2(Table menuTable, Set tempIds, Object k, DynamicObject v) {
        GuideTreeMenuNode.newInstance(v, (Table<Long, Long, GuideTreeMenuNode>)menuTable, tempIds);
    }

    static enum OpenType {
        rptprocess(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"GuideTreeMenu_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])),
        cwpprocess(ResManager.loadKDString((String)"\u5e95\u7a3f\u5f0f\u8c03\u6574", (String)"GuideTreeMenu_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])),
        rptquery(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2", (String)"GuideTreeMenu_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])),
        rptinput(ResManager.loadKDString((String)"\u5408\u5e76\u5f55\u5165", (String)"GuideTreeMenu_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])),
        openpage(ResManager.loadKDString((String)"\u6253\u5f00\u754c\u9762", (String)"GuideTreeMenu_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])),
        emptypage(ResManager.loadKDString((String)"\u7a7a\u767d\u64cd\u4f5c", (String)"GuideTreeMenu_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));

        private String name;

        private OpenType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static OpenType getOpenType(int type) {
            switch (type) {
                case 1: {
                    return rptprocess;
                }
                case 2: {
                    return rptquery;
                }
                case 3: {
                    return cwpprocess;
                }
                case 4: {
                    return rptinput;
                }
            }
            return emptypage;
        }
    }

    public static class GuideTreeMenuNode
    extends AbstractTreeMenuNode {
        private static final long serialVersionUID = 5228636935825766219L;
        private String formId;
        private String appId;
        private String appNumber;
        protected String menuId;
        protected Long templataId;
        protected OpenType openType;
        private boolean hasRight = true;

        GuideTreeMenuNode(String id, String parentid, String name) {
            super(id, parentid, name);
        }

        GuideTreeMenuNode(GuideTreeMenuNode gt) {
            super(gt.get_Id(), gt.get_Parentid(), gt.get_Text());
            this.menuId = gt.getMenuId();
            this.formId = gt.getFormId();
            this.openType = gt.openType;
            this.templataId = gt.templataId;
            this.appId = gt.getAppId();
            this.seq = gt.seq;
            this.customParam = gt.getCustomParam();
        }

        GuideTreeMenuNode() {
        }

        public void openGuideMenu(IFormView iFormView) {
            if (!this.isHasRight()) {
                iFormView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83dc\u5355\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"GuideTreeMenu_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                Map<String, Long> filterMap = GuidePageUtils.getFilterMap(iFormView, false);
                filterMap.put("initflag", Long.parseLong(GuidePageUtils.getInitFlag(iFormView)));
                PageManagerFactory.getManager(this, iFormView, filterMap).openTab(filterMap);
            }
        }

        public GuideTreeMenuNode findNodeByMenu(String formId) {
            if (formId.equals(this.getFormId())) {
                return this;
            }
            List<TreeMenuNode> children = this.getChildren();
            if (children != null && !children.isEmpty()) {
                for (TreeMenuNode child : children) {
                    GuideTreeMenuNode guideTreeMenuNode1 = ((GuideTreeMenuNode)child).findNodeByMenu(formId);
                    if (guideTreeMenuNode1 == null) continue;
                    return guideTreeMenuNode1;
                }
            }
            return null;
        }

        public static void newInstance(DynamicObject v, Table<Long, Long, GuideTreeMenuNode> menuTable, Set<Long> tempIds) {
            Long parentId = v.getLong("parent.id");
            Long id = v.getLong("id");
            DynamicObject openPageDyn = v.getDynamicObject("menu");
            GuideTreeMenuNode node = new GuideTreeMenuNode("" + id, parentId + "", v.getString("name"));
            node.setIconUrl(v.getString("iconurl"));
            node.setActivedIconUrl(v.getString("iconurl"));
            node.formId = v.getString("menu.formid");
            DynamicObject app = v.getDynamicObject("menu.appid");
            if (app != null) {
                node.appId = app.getString("id");
                node.appNumber = app.getString("number");
            }
            if (openPageDyn == null) {
                node.openType = OpenType.emptypage;
                node.seq = v.getInt("serial");
            } else {
                node.openType = OpenType.openpage;
                node.seq = v.getInt("serial");
                node.menuId = openPageDyn.getString("menuid");
                String cusJson = openPageDyn.getString("customsetting");
                if (StringUtils.isNotEmpty((CharSequence)cusJson)) {
                    if (cusJson.endsWith("&qing")) {
                        node.addCustomParam("&qing", cusJson.replaceAll("&qing", ""));
                    } else {
                        cusJson = StringEscapeUtils.unescapeJava((String)cusJson);
                        node.customParam = (Map)JSONObject.parseObject((String)cusJson.trim(), Map.class);
                    }
                }
            }
            menuTable.put((Object)parentId, (Object)id, (Object)node);
        }

        public void updatePerm(Set<Long> havePermIds, Set<Long> haveNodePermIds, boolean showRptInput) {
            this.iterate(99, node -> {
                GuideTreeMenuNode temp = (GuideTreeMenuNode)node;
                temp.hasRight = temp.openType != OpenType.openpage && temp.openType != OpenType.emptypage ? (temp.openType == OpenType.cwpprocess ? haveNodePermIds.contains(Long.valueOf(temp.getParentid())) : (!havePermIds.contains(temp.templataId) ? false : (temp.openType == OpenType.rptinput ? showRptInput : true))) : haveNodePermIds.contains(Long.valueOf(temp.getId()));
            });
        }

        public void buildByTable(Table<Long, Long, GuideTreeMenuNode> menuTable, Set<Long> haveNodePermIds) {
            Map row = menuTable.row((Object)Long.valueOf(this.getId()));
            if (row != null && !row.isEmpty()) {
                row.forEach((k, v) -> {
                    boolean hasChild;
                    boolean bl = hasChild = menuTable.row((Object)Long.valueOf(v.get_Id())) != null && !menuTable.row((Object)Long.valueOf(v.get_Id())).isEmpty();
                    if (hasChild || haveNodePermIds.contains(Long.parseLong(v.get_Id()))) {
                        v.buildByTable(menuTable, haveNodePermIds);
                        if (!hasChild || v.getChildren() != null && !v.getChildren().isEmpty()) {
                            this.addChild((TreeMenuNode)v);
                        }
                    }
                });
                this.sort();
            }
        }

        public boolean isHasRight() {
            return this.hasRight;
        }

        public void setHasRight(boolean hasRight) {
            this.hasRight = hasRight;
        }

        public String getFormId() {
            return this.formId;
        }

        public void setFormId(String formId) {
            this.formId = formId;
        }

        public String getMenuId() {
            return this.menuId;
        }

        public void setMenuId(String menuId) {
            this.menuId = menuId;
        }

        public Long getTemplataId() {
            return this.templataId;
        }

        public void setTemplataId(Long templataId) {
            this.templataId = templataId;
        }

        public OpenType getOpenType() {
            return this.openType;
        }

        public void setOpenType(OpenType openType) {
            this.openType = openType;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAppNumber() {
            return this.appNumber;
        }

        public void setAppNumber(String appNumber) {
            this.appNumber = appNumber;
        }
    }
}

