/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.guidemenu;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.fi.bcm.formplugin.guidemenu.AbstractPageManager;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.guidemenu.GuideTreeMenu;

class OpenMenuPage
extends AbstractPageManager {
    private static List<String> singleMenus = Arrays.asList("bcm_exchangerate_maintain", "bcm_invrelation_search", "bcm_intergration_rule", "bcm_datasourceedit", "bcm_initperiodlist", "bcm_invrelation_set", "bcm_ajsglobalsettingedit", "bcm_memberperm_view");

    public OpenMenuPage(GuideTreeMenu.GuideTreeMenuNode guideMenu, IFormView fromView, Map<String, Long> filterMap) {
        super(guideMenu, fromView, filterMap);
    }

    @Override
    public void openPage(Map<String, Long> filterMap) {
        IFormView mainPageView = this.fromView;
        IFormView parentView = this.fromView;
        String menuPageID = this.getMenuPageId();
        if (mainPageView.getView(menuPageID) == null) {
            if (this.guideMenu.getCustomParam().containsKey("&qing")) {
                this.openQingMenuApp();
            } else {
                this.openNewAppPage();
            }
        } else {
            IFormView childFormView = mainPageView.getView(menuPageID);
            childFormView.activate();
            parentView.sendFormAction(childFormView);
        }
    }

    @Override
    public String getTabPageId() {
        return GuidePageUtils.getTabPageId(this.guideMenu, this.fromView, this.initFlag, false);
    }

    public void openQingMenuApp() {
        String formNumber = this.guideMenu.getFormId();
        String qingMenuId = this.guideMenu.get_Id();
        String qingMenuName = this.guideMenu.get_Text();
        String formParams = this.guideMenu.getCustomParam("&qing").toString();
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formNumber);
        if (formConfig == null) {
            this.fromView.showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8f7b\u5206\u6790\u52a8\u6001\u7f16\u7801\u4e3a\u201c %s \u201d\u7684\u52a8\u6001\u8868\u5355\uff0c\u8bf7\u524d\u5f80\u8f7b\u5206\u6790\u52a8\u6001\u8868\u5355\u7ba1\u7406\u4e2d\u7ef4\u62a4\u3002", (String)"GuideMenuChildPagePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formNumber));
            return;
        }
        if (!StringUtils.isNotBlank((CharSequence)qingMenuId) || StringUtils.isBlank((CharSequence)formNumber)) {
            this.fromView.showTipNotification(ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u83dc\u5355\u6253\u5f00\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8f7b\u5206\u6790\u83dc\u5355\u53d1\u5e03\u8bbe\u7f6e\u3002", (String)"GuideMenuChildPagePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", this.fromView);
        map.put("formnumber", formNumber);
        map.put("parameter", formParams);
        map.put("menuname", qingMenuName);
        map.put("parametertype", null);
        map.put("openType", null);
        map.put("permItem", null);
        map.put("pageId", this.getMenuPageId());
        this.setMainPage();
        GuidePageUtils.openApp(this.appId, this.appNumber, qingMenuId, map, this.fromView);
    }

    public void openNewAppPage() {
        AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)this.appId, (String)this.guideMenu.menuId);
        if (menu == null) {
            this.fromView.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u83dc\u5355\u4fe1\u606f\u5931\u8d25\u3002", (String)"GuideMenuChildPagePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = menu.getFormId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.fromView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7ed1\u5b9a\u83dc\u5355\u5bf9\u5e94\u7684\u9875\u9762\uff0c\u8bf7\u524d\u5f80\u5f00\u53d1\u8005\u95e8\u6237\u83dc\u5355\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u3002", (String)"GuideMenuChildPagePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", this.fromView);
        map.put("formnumber", formId);
        map.put("parametertype", menu.getParamType());
        JSONObject parameter = JSONArray.parseObject((String)menu.getParams());
        this.handleParameter((Map<String, Object>)parameter, formId);
        map.put("parameter", parameter);
        map.put("menuname", menu.getName());
        map.put("openType", menu.getOpenType());
        map.put("permItem", menu.getPermission());
        map.put("pageId", this.getMenuPageId());
        HashMap cusParams = Maps.newHashMap();
        cusParams.put("from_guide_page", true);
        cusParams.put("common_guide_page", this.fromView.getFormShowParameter().getCustomParam("common_guide_page"));
        map.put("customparameters", cusParams);
        this.setMainPage();
        if (this.checkHideNavigationPerm(menu.getFormId())) {
            this.fromView.updateControlMetadata("_submaintab_", (Map)new HashMap<String, Object>(){
                {
                    this.put("hideNav", true);
                }
            });
            this.fromView.updateControlMetadata("_submaintab_", (Map)new HashMap<String, Object>(){
                {
                    this.put("caption", "DAB");
                }
            });
        }
        GuidePageUtils.openApp(this.appId, this.appNumber, this.guideMenu.menuId, map, this.fromView);
    }

    private boolean checkHideNavigationPerm(String menu) {
        return singleMenus.contains(menu);
    }

    private void handleParameter(Map<String, Object> parameter, String formId) {
        if (formId.equals("bcm_report_search")) {
            parameter.put("used", "queryreport");
        }
    }
}

